/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.email;

import com.savvion.sbm.bizlogic.message.EmailMessage;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDocService;
import com.savvion.sbm.dms.DSContext;
import com.savvion.sbm.dms.svo.Document;
import com.savvion.sbm.util.FileUtil;
import com.savvion.sbm.util.SBMUtil;
import com.tdiinc.common.Emailer.SendEmail;
import com.tdiinc.common.Emailer.SendEmailRef;
import com.tdiinc.common.Emailer.SendHtmlEmail;
import java.io.ByteArrayInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class EmailNotify {
    private static EmailNotify self = null;

    private EmailNotify() {
    }

    public static synchronized EmailNotify self() {
        if (self == null) {
            self = new EmailNotify();
        }
        return self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(EmailMessage msg) {
        SendEmailRef sm = null;
        int ix = 0;
        try {
            sm = this.createEmailerInstance(msg);
            SendEmailRef.setDebug((boolean)BLControl.util.DEBUG_UTIL);
            String[] tmp = msg.getFrom();
            sm.setMailFrom(tmp[0]);
            tmp = msg.getTo();
            for (ix = 0; ix < tmp.length; ++ix) {
                sm.addMailTo(tmp[ix]);
            }
            tmp = msg.getCC();
            if (tmp != null) {
                for (ix = 0; ix < tmp.length; ++ix) {
                    sm.addMailCC(tmp[ix]);
                }
            }
            if ((tmp = msg.getBCC()) != null) {
                for (ix = 0; ix < tmp.length; ++ix) {
                    sm.addMailBCC(tmp[ix]);
                }
            }
            sm.setCharset(msg.getCharSet());
            sm.setSubject(msg.getSubject());
            ArrayList attachments = msg.getAttachment();
            DSContext dsContext = null;
            try {
                dsContext = BLDocService.startSession(null);
                if (attachments != null) {
                    for (Object obj : attachments) {
                        if (obj instanceof Document) {
                            Document doc = (Document)obj;
                            sm.addFile(FileUtil.getByteArray((ByteArrayInputStream)doc.getContent(dsContext)), doc.getName());
                            continue;
                        }
                        if (!(obj instanceof URL)) continue;
                        URL url = (URL)obj;
                        sm.addFile(FileUtil.getByteArray((URL)url), url.getFile());
                    }
                }
            }
            finally {
                if (dsContext != null) {
                    BLDocService.endSession((DSContext)dsContext);
                }
            }
            sm.send();
        }
        catch (Throwable ex) {
            throw new RuntimeException("Error sending Email. Error occured in either preparing or sending email or attaching the document.", ex);
        }
        return true;
    }

    private SendEmailRef createEmailerInstance(EmailMessage msg) {
        SendHtmlEmail sm = null;
        String content = (String)msg.getContent();
        if (msg.isHtmlMessage()) {
            SendHtmlEmail shm = sm = new SendHtmlEmail(SBMUtil.self().getOutgoingMailUser(), SBMUtil.self().getOutgoingMailPassword(), SBMUtil.self().getOutgoingMailCharset(), SBMUtil.self().getOutgoingMailServerProps());
            shm.setContent(content);
            Hashtable inlineImages = msg.getHtmlImages();
            if (inlineImages != null && !inlineImages.isEmpty()) {
                Set set = inlineImages.entrySet();
                for (Map.Entry element : set) {
                    shm.addHtmlImage((URL)element.getKey(), (String)element.getValue());
                }
            }
        } else {
            sm = new SendEmail(SBMUtil.self().getOutgoingMailUser(), SBMUtil.self().getOutgoingMailPassword(), SBMUtil.self().getOutgoingMailCharset(), SBMUtil.self().getOutgoingMailServerProps());
            sm.setText(content);
        }
        return sm;
    }
}

