/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.messaging.subscriber;

import com.savvion.sbm.bizlogic.messaging.MessageControl;
import com.savvion.sbm.bizlogic.messaging.MsgErrorHandler;
import com.savvion.sbm.bizlogic.messaging.subscriber.BLBizMessage;
import com.savvion.sbm.bizlogic.messaging.subscriber.BizTarget;
import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.dao.ProcessInstanceDAO;
import com.savvion.sbm.bizlogic.server.svo.MessageSubscription;
import com.savvion.sbm.bizlogic.server.svo.MessageSubscriptionList;
import com.savvion.sbm.bizlogic.util.BLControl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class InstanceLocator {
    public static List getTargetInstances(BLBizMessage message) {
        String msgName = message.getMessageName();
        if (message.receiverInstanceIDExists()) {
            long piid = message.getReceiverInstanceID();
            if (message.receiverTaskNameExists()) {
                String taskName = message.getReceiverTaskName();
                return InstanceLocator.getWSI(msgName, piid, taskName);
            }
            return InstanceLocator.getWSI(msgName, piid);
        }
        if (message.receiverAppNameExists()) {
            String ptName = message.getReceiverAppName();
            if (message.receiverTaskNameExists()) {
                String taskName = message.getReceiverTaskName();
                return InstanceLocator.getWSI(message, ptName, taskName);
            }
            return InstanceLocator.getWSI(message, ptName);
        }
        return InstanceLocator.getWSI(message);
    }

    private static List getWSI(String msgName, long piid, String wsName) {
        if (BLControl.util.DEBUG_MESSAGING) {
            MessageControl.self().logger.debugKey("BizLogic_ERR_2247", "InstanceLocator.getWSI(msgName, piid, wsName)", new Object[]{msgName, piid, wsName});
        }
        ArrayList<BizTarget> targetWSList = new ArrayList<BizTarget>();
        WFProcess pt = ProcessControl.getProcess(piid);
        WFWorkstep ws = pt.getWorkstep(wsName, true);
        if (ws == null) {
            throw MsgErrorHandler.createEx("BizLogic_ERR_3614", "InstanceLocator.getWSI(msg, ptName,wsName)", new Object[]{msgName, new Long(piid), wsName}, true);
        }
        if (ws.getMessageSubscriptionList().isSubscribedToMessage(msgName)) {
            if (BLControl.util.DEBUG_MESSAGING) {
                MessageControl.self().logger.debugKey("BizLogic_ERR_2240", "InstanceLocator.getWSI(msgName, piid, wsName)", new Object[]{wsName, new Long(piid), msgName});
            }
        } else {
            throw MsgErrorHandler.createEx("BizLogic_ERR_3615", "InstanceLocator.getWSI(msgName,piid,wsName)", new Object[]{msgName, new Long(piid), wsName}, true);
        }
        BizTarget target = new BizTarget(pt.getID(), piid, ws.getID());
        targetWSList.add(target);
        return targetWSList;
    }

    private static List getWSI(String msgName, long piid) {
        if (BLControl.util.DEBUG_MESSAGING) {
            MessageControl.self().logger.debugKey("BizLogic_ERR_2247", "InstanceLocator.getWSI(msgName, piid)", new Object[]{msgName, piid, "NIL"});
        }
        ArrayList<BizTarget> targetWSList = new ArrayList<BizTarget>();
        WFProcess pt = ProcessControl.getProcess(piid);
        List subscribedWSList = pt.getWorkstepsSubscribedToMessage(msgName);
        StringBuilder wsNames = new StringBuilder();
        WFWorkstep ws = null;
        for (int ix = 0; ix < subscribedWSList.size(); ++ix) {
            ws = (WFWorkstep)subscribedWSList.get(ix);
            BizTarget target = new BizTarget(pt.getID(), piid, ws.getID());
            targetWSList.add(target);
            if (!BLControl.util.DEBUG_MESSAGING) continue;
            wsNames.append(ws.getName()).append(" ");
        }
        if (BLControl.util.DEBUG_MESSAGING && !subscribedWSList.isEmpty()) {
            MessageControl.self().logger.debugKey("BizLogic_ERR_2240", "InstanceLocator.getWSI(msgName, piid)", new Object[]{wsNames.toString(), new Long(piid), msgName});
        }
        return targetWSList;
    }

    private static List getWSI(BLBizMessage message, String ptName, String wsName) {
        if (BLControl.util.DEBUG_MESSAGING) {
            MessageControl.self().logger.debugKey("BizLogic_ERR_2248", "InstanceLocator.getWSI(msg, ptName,wsName)", new Object[]{message.getMessageName(), ptName, wsName});
        }
        ArrayList targetWSI = new ArrayList();
        WFProcess pt = null;
        pt = ProcessControl.isProcessTemplateExist(ptName) ? ProcessControl.getProcessTemplate(ptName) : ProcessControl.getCurrentProcessTemplate(ptName);
        if (pt == null) {
            throw MsgErrorHandler.createEx("BizLogic_ERR_3613", "InstanceLocator.getWSI(msg, ptName,wsName)", new Object[]{message.getMessageName(), ptName}, true);
        }
        WFWorkstep ws = pt.getWorkstep(wsName, true);
        if (ws == null) {
            throw MsgErrorHandler.createEx("BizLogic_ERR_3614", "InstanceLocator.getWSI(msg, ptName,wsName)", new Object[]{message.getMessageName(), ptName, wsName}, true);
        }
        String msgName = message.getMessageName();
        if (!ws.getMessageSubscriptionList().isSubscribedToMessage(msgName)) {
            throw MsgErrorHandler.createEx("BizLogic_ERR_3615", "InstanceLocator.getWSI(msg, ptName,wsName)", new Object[]{message.getMessageName(), ptName, wsName}, true);
        }
        targetWSI = InstanceLocator.getCorrelatedTargtes(message, pt, ws);
        return targetWSI;
    }

    private static List getWSI(BLBizMessage message, String ptName) {
        if (BLControl.util.DEBUG_MESSAGING) {
            MessageControl.self().logger.debugKey("BizLogic_ERR_2248", "InstanceLocator.getWSI(msg,ptName)", new Object[]{message.getMessageName(), ptName, "NIL"});
        }
        String msgName = message.getMessageName();
        WFProcess pt = null;
        pt = ProcessControl.isProcessTemplateExist(ptName) ? ProcessControl.getProcessTemplate(ptName) : ProcessControl.getCurrentProcessTemplate(ptName);
        if (pt == null) {
            throw MsgErrorHandler.createEx("BizLogic_ERR_3613", "InstanceLocator.getWSI(msg, ptName)", new Object[]{message.getMessageName(), ptName}, true);
        }
        List wsList = pt.getWorkstepsSubscribedToMessage(msgName);
        ArrayList targetWSList = new ArrayList();
        WFWorkstep ws = null;
        for (int ix = 0; ix < wsList.size(); ++ix) {
            ws = (WFWorkstep)wsList.get(ix);
            ArrayList targetsForOneWS = InstanceLocator.getCorrelatedTargtes(message, pt, ws);
            targetWSList.addAll(targetsForOneWS);
        }
        return targetWSList;
    }

    private static List getWSI(BLBizMessage message) {
        if (BLControl.util.DEBUG_MESSAGING) {
            MessageControl.self().logger.debugKey("BizLogic_ERR_2249", "InstanceLocator.getWSI(msg)", new Object[]{message.getMessageName()});
        }
        String msgName = message.getMessageName();
        ArrayList targetWSList = new ArrayList();
        Collection ptObjects = ProcessControl.getAllProcessTemplates();
        ArrayList ptlist = new ArrayList(ptObjects);
        WFProcess pt = null;
        for (int index = 0; index < ptlist.size(); ++index) {
            pt = (WFProcess)ptlist.get(index);
            List wsList = pt.getWorkstepsSubscribedToMessage(msgName);
            WFWorkstep ws = null;
            for (int ix = 0; ix < wsList.size(); ++ix) {
                ws = (WFWorkstep)wsList.get(ix);
                ArrayList targetsForOneWS = InstanceLocator.getCorrelatedTargtes(message, pt, ws);
                targetWSList.addAll(targetsForOneWS);
            }
        }
        return targetWSList;
    }

    private static ArrayList getCorrelatedTargtes(BLBizMessage message, WFProcess pt, WFWorkstep ws) {
        String msgName = message.getMessageName();
        MessageSubscriptionList msgSubscriptionList = ws.getMessageSubscriptionList();
        MessageSubscription msgSubscr = msgSubscriptionList.getSubscribedMessage(msgName);
        ArrayList<BizTarget> targetWSIList = new ArrayList<BizTarget>();
        if (!msgSubscr.hasCorrelation()) {
            if (BLControl.util.DEBUG_MESSAGING) {
                MessageControl.self().logger.debugKey("BizLogic_ERR_2241", "InstanceLocator.getCorrelatedTargets", new Object[]{pt.getName(), msgName});
            }
            List piids = ProcessInstanceDAO.findByProcessTemplate(pt.getID());
            for (int ix = 0; ix < piids.size(); ++ix) {
                long piid = (Long)piids.get(ix);
                BizTarget target = new BizTarget(pt.getID(), piid, ws.getID());
                targetWSIList.add(target);
            }
            return targetWSIList;
        }
        HashMap correlationValues = InstanceLocator.getCorrelationValues(message, pt, ws);
        if (correlationValues == null) {
            return null;
        }
        HashMap objCorrelationValues = WFProcess.convertStringToObjectValue(pt, correlationValues);
        HashMap piParentIDMap = (HashMap)ProcessInstanceDAO.findBySlotValues(pt.getID(), objCorrelationValues, null);
        Iterator piids = piParentIDMap.keySet().iterator();
        while (piids.hasNext()) {
            long piid = (Long)piids.next();
            BizTarget target = new BizTarget(pt.getID(), piid, ws.getID());
            targetWSIList.add(target);
        }
        return targetWSIList;
    }

    private static HashMap getCorrelationValues(BLBizMessage message, WFProcess pt, WFWorkstep ws) {
        String msgName = message.getMessageName();
        MessageSubscriptionList msgSubscriptionList = ws.getMessageSubscriptionList();
        MessageSubscription msgSubscr = msgSubscriptionList.getSubscribedMessage(msgName);
        List corrMapping = msgSubscr.getCorrelationMapping();
        HashMap<String, String> corrValues = new HashMap<String, String>();
        String msgValue = null;
        for (int ix = 0; ix < corrMapping.size(); ++ix) {
            HashMap oneCorrMap = (HashMap)corrMapping.get(ix);
            String msgPropName = (String)oneCorrMap.get("PROP_NAME");
            String dsNameOrConst = (String)oneCorrMap.get("PROP_VAL");
            msgValue = message.getProperty(msgPropName);
            if (dsNameOrConst.startsWith("@")) {
                String dsName = dsNameOrConst.substring(1);
                WFDataslot ds = pt.getDataslot(dsName);
                if (ds.isObject() || ds.isXML()) {
                    throw MsgErrorHandler.createEx("BizLogic_ERR_710", "InstanceLocator.getCorrelationValues", new Object[]{msgPropName, dsName, pt.getName(), ds.getType()});
                }
                corrValues.put(dsName, msgValue);
                continue;
            }
            if (dsNameOrConst.equals(msgValue)) continue;
            return null;
        }
        return corrValues;
    }
}

