/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.email.EmailComposer;
import com.savvion.sbm.bizlogic.server.DebugService;
import com.savvion.sbm.bizlogic.server.Performer;
import com.savvion.sbm.bizlogic.server.WFAtomicWS;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFVoteWS;
import com.savvion.sbm.bizlogic.server.WFWorkItem;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.WFWorkstepInstance;
import com.savvion.sbm.bizlogic.server.dao.AvailableWorkItemDAO;
import com.savvion.sbm.bizlogic.server.dao.CWorkItemDAO;
import com.savvion.sbm.bizlogic.server.dao.ExcludePerformerDAO;
import com.savvion.sbm.bizlogic.server.dao.TimerActionDAO;
import com.savvion.sbm.bizlogic.server.dao.VoteDAO;
import com.savvion.sbm.bizlogic.server.dao.WorkItemDAO;
import com.savvion.sbm.bizlogic.server.dao.WorkItemPerformerDAO;
import com.savvion.sbm.bizlogic.server.ejb.WorkItemEBLocal;
import com.savvion.sbm.bizlogic.server.ejb.WorkItemEBLocalHome;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceEBLocal;
import com.savvion.sbm.bizlogic.server.ep.EPAdapterSB;
import com.savvion.sbm.bizlogic.server.ep.EPAdapterSBHome;
import com.savvion.sbm.bizlogic.server.svo.VoteCriteria;
import com.savvion.sbm.bizlogic.util.BLCalendar;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicAppException;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.util.SBMControl;
import com.savvion.sbm.util.SBMException;
import com.savvion.sbm.util.SBMHomeFactory;
import com.savvion.sbm.util.SBMURLClassLoader;
import com.savvion.sbm.util.SBMUtil;
import com.tdiinc.userManager.Group;
import com.tdiinc.userManager.User;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBHome;
import javax.naming.NamingException;

public class WFAtomicInstance
extends WFWorkstepInstance {
    private static WFAtomicInstance self;

    private WFAtomicInstance() {
    }

    private void init() {
    }

    public static WFAtomicInstance self() {
        if (self == null) {
            self = new WFAtomicInstance();
        }
        return self;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void execute(WFProcessContext pCtx, long wsid) {
        int typeTag = pCtx.getWorkstep(wsid).getType();
        if (typeTag != 100) {
            if (typeTag != 101) {
                this.createWorkitems(pCtx, wsid);
                return;
            }
        }
        this.complete(pCtx, wsid);
    }

    @Override
    public void complete(WFProcessContext pCtx, long wsid) {
        if (!pCtx.getWorkstep(wsid).isMonitorStep()) {
            this.complete(pCtx, wsid, true);
        } else {
            this.completeMonitorStep(pCtx, wsid);
        }
    }

    public void completeX(WFProcessContext pCtx, long wsid) {
        this.complete(pCtx, wsid, false);
    }

    private void complete(WFProcessContext pCtx, long wsid, boolean cleanupWIs) {
        this.validateCompletion(pCtx, wsid);
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        int typeTag = wsieb.getType();
        if (typeTag != 100) {
            if (typeTag != 101) {
                long piid = pCtx.getProcessInstanceID();
                try {
                    WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wsid);
                    if (cleanupWIs) {
                        if (ws.isCollaborationEnabled()) {
                            Collection coll = WorkItemDAO.findByWorkStepInstance(piid, wsid);
                            for (Object obj : coll) {
                                Long wiid = (Long)obj;
                                CWorkItemDAO.removeByParentWI(wiid);
                            }
                        }
                        if (!ws.getPerformedByAll()) {
                            AvailableWorkItemDAO.removeByWorkStepInstance(piid, wsid);
                        }
                        WorkItemEBLocalHome ebh = BLUtil.self().getWorkItemEBHome();
                        ebh.deleteByWorkStepInstance(piid, wsid);
                    }
                    ExcludePerformerDAO.removeByWorktepInstance(piid, wsid);
                    if (ws.isVoteEnabled() && BLControl.util.isVotePersistedForWSI()) {
                        if (BLControl.util.DEBUG_ENGINE) {
                            BLControl.logger.debugKey("BizLogic_ERR_6009", new Object[]{pCtx.getProcessInstanceID(), wsid, "WFAtomicInstance.complete"});
                        }
                        VoteDAO.removeByWorktepInstance(pCtx.getProcessInstanceID(), wsid);
                    }
                }
                catch (BizLogicException bex) {
                    BizLogicException.rethrow((BizLogicException)bex, (String)"WFAtomicInstance.complete");
                    return;
                }
                catch (Exception e) {
                    throw new BizLogicException("BizLogic_ERR_2603", "WFAtomicInstance.complete", new Object[]{pCtx.getWorkstep(wsid).getName(), pCtx.getProcessInstanceName()}, (Throwable)e);
                }
            }
        }
        super.complete(pCtx, wsid);
        long stat = wsieb.getState();
        if (stat != 21L) {
            return;
        }
        BLUtil.fireEvent(this.getEventContext(pCtx, wsid, 21), (int)21);
        super.afterComplete(pCtx, wsid);
        if (typeTag == 101) {
            if (pCtx.isDebug()) {
                DebugService.self().saveWorkStepInstances(pCtx);
            }
            pCtx.completeProcessInstance();
        } else {
            this.activateNextWorksteps(pCtx, wsid);
        }
    }

    private void completeMonitorStep(WFProcessContext pCtx, long wsid) {
        this.validateCompletion(pCtx, wsid);
        super.complete(pCtx, wsid);
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        long stat = wsieb.getState();
        if (stat != 21L) {
            return;
        }
        if (BLControl.util.DEBUG_ENGINE || BLControl.util.DEBUG_MONITORING) {
            Object[] objectArray = new Object[3];
            objectArray[0] = pCtx.getProcessInstanceID();
            objectArray[1] = wsid;
            objectArray[2] = 21;
            BLControl.logger.debugKey("BizLogic_ERR_4303", "WFAtomicInstance.completeMonitorStep", objectArray);
        }
        BLUtil.fireEvent(this.getEventContext(pCtx, wsid, 21), (int)21);
        super.afterComplete(pCtx, wsid);
        this.activateNextWorksteps(pCtx, wsid);
    }

    public Collection getWorkitems(WFProcessContext pCtx, long wsid) {
        long piid = pCtx.getProcessInstanceID();
        try {
            WorkItemEBLocalHome ebh = BLUtil.self().getWorkItemEBHome();
            return ebh.findByWorkStepInstance(piid, wsid);
        }
        catch (Exception e) {
            throw new BizLogicException("BizLogic_ERR_2604", "WFAtomicInstance.complete", new Object[]{pCtx.getWorkstep(wsid).getName(), pCtx.getProcessInstanceName()}, (Throwable)e);
        }
    }

    @Override
    public void terminate(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        long stat = wsieb.getState();
        if (stat == 21L) {
            return;
        }
        int typeTag = wsieb.getType();
        if (typeTag != 100) {
            if (typeTag != 101) {
                long piid = pCtx.getProcessInstanceID();
                try {
                    WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wsid);
                    Vector wilist = (Vector)WorkItemDAO.findByWorkStepInstance(piid, wsid);
                    for (int itr = 0; itr < wilist.size(); ++itr) {
                        Long wiid = (Long)wilist.elementAt(itr);
                        WFWorkItem.self().terminate(pCtx, wiid);
                    }
                    this.removeWorkItems(pCtx, wsid);
                }
                catch (BizLogicException bex) {
                    BizLogicException.rethrow((BizLogicException)bex, (String)"WFAtomicInstance.terminate");
                    return;
                }
                catch (Exception e) {
                    throw new BizLogicException("BizLogic_ERR_2603", "WFAtomicInstance.terminate", new Object[]{pCtx.getWorkstep(wsid).getName(), pCtx.getProcessInstanceName()}, (Throwable)e);
                }
            }
        }
        super.terminate(pCtx, wsid);
    }

    public final void createWorkitems(WFProcessContext pCtx, long wsid) {
        Set excludedPerformer;
        WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wsid);
        boolean byAll = ws.getPerformedByAll();
        String role = ws.getRole();
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        String wsName = ws.getName();
        String piName = pCtx.getProcessInstanceName();
        String performer = null;
        if (pCtx.isInstanceMigration()) {
            performer = this.getRealPerformer(pCtx, wsid, ws.getPerformer());
            wsieb.setActualPerformer(performer);
        } else {
            performer = wsieb.getActualPerformer();
        }
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debug((Object)("WFAtomicInstance.createWorkitems: RealPerf = " + performer + " for workstep <" + wsName + "> of process instance <" + piName + ">"));
        }
        if (performer == null) {
            performer = "";
        }
        boolean isStringListPerf = performer.indexOf(",") != -1;
        Vector perfs = null;
        Vector xperfs = null;
        try {
            perfs = this.getPerformerList(pCtx, wsid, performer);
        }
        catch (Exception e) {
            this.suspendOnExecute(pCtx, wsid, e, null);
            return;
        }
        if (perfs != null && BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debug((Object)"**** Returned List Performer ****");
            for (int ii = 0; ii < perfs.size(); ++ii) {
                BLControl.logger.debug(perfs.elementAt(ii));
            }
        }
        if (BLUtil.self().useCalendar()) {
            this.updateWSIDueDate(pCtx, wsid, perfs);
        }
        xperfs = this.expandListPerformer(pCtx, wsid, byAll, perfs, role);
        boolean hasQueue = false;
        if (SBMControl.util.isUseQueue()) {
            hasQueue = Performer.hasQueue(xperfs);
        }
        if ((excludedPerformer = this.getExcludedPerformerList(pCtx, wsid)) != null) {
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debug((Object)"**** Exclude the following Performers ****");
                BLControl.logger.debug((Object)excludedPerformer.toString());
            }
            xperfs = (Vector)Performer.removeAll(xperfs, excludedPerformer);
        }
        if (xperfs != null && BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debug((Object)"**** Expanded List Performer ****");
            for (int ii = 0; ii < xperfs.size(); ++ii) {
                BLControl.logger.debug(xperfs.elementAt(ii));
            }
        }
        String wiperf = null;
        if (isStringListPerf) {
            wiperf = performer;
        } else {
            wiperf = BLUtil.toStringListPerformer((List)perfs);
            this.setActualPerformer(pCtx, wsid, wiperf);
        }
        if (byAll) {
            this.createWorkitemsForList(pCtx, wsid, xperfs, role);
        } else {
            this.createAvailWorkitemForList(pCtx, wsid, wiperf, xperfs, role);
        }
        if (hasQueue) {
            ExcludePerformerDAO.insert(pCtx.getProcessInstanceID(), wsid, wsieb.getLoopCounter(), excludedPerformer);
        }
    }

    public final Vector getPerformerList(WFProcessContext pCtx, long wsid, String performer) {
        if (performer == null) {
            performer = "";
        }
        Vector<String> perfs = null;
        if (performer.toLowerCase().startsWith("js:")) {
            perfs = (Vector<String>)this.executeJS(pCtx, wsid, "ASSIGN");
        } else if (performer.toLowerCase().startsWith("jndi://")) {
            perfs = this.executeEJB(pCtx, wsid, performer);
        } else if (performer.indexOf(",") != -1) {
            perfs = BLUtil.toVectorListPerformer((String)performer);
        } else {
            perfs = new Vector<String>(1);
            perfs.addElement(performer);
        }
        return WFWorkstepInstance.single().getRealPerformer(pCtx, wsid, perfs);
    }

    private List getResources(WFProcessContext pCtx, long wsid, String performer, String role, boolean byAll) {
        ArrayList<Performer> users = new ArrayList<Performer>();
        if (BLControl.util.RESOURCE_VALIDATION_ASC) {
            User user = pCtx.getUser(performer);
            if (user != null) {
                users.add(new Performer(performer, user));
                return users;
            }
            Group group = BLUtil.getGroup((String)performer);
            if (group != null) {
                return this.getUsersFromGroup(pCtx, group, role);
            }
            if (SBMControl.util.isUseQueue() && BLControl.queueManager.isQueue(performer)) {
                if (byAll) {
                    WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wsid);
                    BLControl.logger.errorKey("BizLogic_ERR_856", new Object[]{pCtx.getProcessInstanceName(), ws.getName()});
                    return null;
                }
                users.add(new Performer(performer, 4));
                return users;
            }
        } else {
            if (SBMControl.util.isUseQueue() && BLControl.queueManager.isQueue(performer)) {
                if (byAll) {
                    WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wsid);
                    BLControl.logger.errorKey("BizLogic_ERR_856", new Object[]{pCtx.getProcessInstanceName(), ws.getName()});
                    return null;
                }
                users.add(new Performer(performer, 4));
                return users;
            }
            Group group = BLUtil.getGroup((String)performer);
            if (group != null) {
                return this.getUsersFromGroup(pCtx, group, role);
            }
            User user = pCtx.getUser(performer);
            if (user != null) {
                users.add(new Performer(performer, user));
                return users;
            }
        }
        if (BLUtil.isEmailAddress((String)performer)) {
            users.add(new Performer(performer, 3));
            return users;
        }
        return null;
    }

    private List getUsersFromGroup(WFProcessContext pCtx, Group group, String role) {
        String[] members = null;
        members = role != null ? group.getMemberNames(role) : group.getMemberNames();
        ArrayList<Performer> users = new ArrayList<Performer>();
        for (int ix = 0; ix < members.length; ++ix) {
            String performer = members[ix];
            if (BLControl.util.isValidateGroupMembers()) {
                User user = pCtx.getUser(performer);
                if (user == null) {
                    users.add(new Performer(performer, -1));
                    continue;
                }
                Performer perf = new Performer(performer, user);
                perf.setGroup(group);
                users.add(perf);
                continue;
            }
            Performer perf = new Performer(performer, 1);
            perf.setGroup(group);
            users.add(perf);
        }
        return users;
    }

    public Set getExcludedPerformerList(WFProcessContext pCtx, long wsid) {
        Vector performers;
        HashSet excludedPerformer = new HashSet();
        HashSet performerList = null;
        WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wsid);
        String jndiPerformer = ws.getJNDIExcludedPerformer();
        if (jndiPerformer != null && (performers = this.getPerformerList(pCtx, wsid, jndiPerformer)) != null) {
            excludedPerformer.addAll(performers);
        }
        if ((performerList = ws.getMappedExcludedPerformer()) != null && !performerList.isEmpty()) {
            String[] dsNames = new String[performerList.size()];
            dsNames = performerList.toArray(dsNames);
            HashMap dsValues = pCtx.getSlotValue(wsid, dsNames);
            Collection values = dsValues.values();
            Object value2 = null;
            for (Object value2 : values) {
                if (value2 instanceof Collection) {
                    excludedPerformer.addAll((Collection)value2);
                    continue;
                }
                excludedPerformer.add(value2);
            }
        }
        if ((performerList = ws.getStaticExcludedPerformer()) != null && !performerList.isEmpty()) {
            excludedPerformer.addAll(performerList);
        }
        Object performer = null;
        User u = null;
        Iterator i = excludedPerformer.iterator();
        while (i.hasNext()) {
            performer = i.next();
            if (performer == null || "<NULL>".equals(performer.toString().trim()) || performer.toString().trim().isEmpty()) {
                i.remove();
                continue;
            }
            if (!BLControl.util.isRemoveInvalidPerformers() || (u = pCtx.getUser(performer.toString())) != null) continue;
            i.remove();
        }
        HashMap wsList = ws.getExcludedPerformerOfWS();
        if (wsList != null && !wsList.isEmpty()) {
            performerList = new HashSet(WorkItemPerformerDAO.getPerformer(pCtx.getProcessInstanceID(), wsList));
        }
        if (performerList != null && !performerList.isEmpty()) {
            excludedPerformer.addAll(performerList);
        }
        return excludedPerformer;
    }

    private Vector expandListPerformer(WFProcessContext pCtx, long wsid, boolean byAll, Vector listperf, String role) {
        Vector invalidPerfs;
        String mgrEmail;
        if (listperf == null) {
            return null;
        }
        String wsname = pCtx.getWorkstep(wsid).getName();
        String piname = pCtx.getProcessInstanceName();
        Vector expandV = new Vector();
        for (int i = 0; i < listperf.size(); ++i) {
            String perf = (String)listperf.elementAt(i);
            List users = this.getResources(pCtx, wsid, perf, role, byAll);
            if (users != null) {
                this.addAll(expandV, users);
                continue;
            }
            Performer tempPerformer = new Performer(perf, -1);
            if (expandV.contains(tempPerformer)) continue;
            expandV.addElement(tempPerformer);
            BLControl.logger.warnKey("BizLogic_ERR_1133", new Object[]{perf, wsname, piname});
        }
        if (BLControl.util.sendEmailOnError && (mgrEmail = this.getManagerEmail(pCtx)) != null && !(invalidPerfs = (Vector)Performer.getInvalidPerformerNames(expandV)).isEmpty()) {
            Locale mgrLocale = SBMUtil.self().getUserLocale(this.getManager(pCtx), true);
            EmailComposer.self().sendInvalidPerformer(piname, wsname, invalidPerfs, byAll, mgrEmail, mgrLocale);
        }
        if (BLControl.util.isRemoveInvalidPerformers()) {
            expandV = (Vector)Performer.getValidPerformers(expandV);
        }
        return expandV;
    }

    private Performer getRealDefaultPerformer(WFProcessContext pCtx, long wsid) {
        Performer performer = null;
        String defaultPerf = this.getDefaultPerformer(pCtx, wsid);
        WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wsid);
        if (defaultPerf == null || defaultPerf.trim().length() == 0) {
            return null;
        }
        User user = pCtx.getUser(defaultPerf);
        if (user != null) {
            performer = new Performer(defaultPerf, user);
        }
        if (user == null && SBMUtil.self().isUseQueue() && BLControl.queueManager.isQueue(defaultPerf)) {
            performer = new Performer(defaultPerf, 4);
        }
        if (performer == null) {
            return null;
        }
        if (ws.getPerformedByAll() ? !performer.isUser() : !performer.isUser() && !performer.isQueue()) {
            return null;
        }
        if (performer != null) {
            BLControl.logger.infoKey("BizLogic_ERR_3245", "WFAtomicInstance.getRealDefaultPerformer()", new Object[]{pCtx.getProcessTemplateName(), pCtx.getProcessInstanceID(), ws.getName(), ws.getPerformer(), performer.getName()});
        }
        return performer;
    }

    public String getDefaultPerformer(WFProcessContext pCtx, long wsid) {
        WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wsid);
        String defaultPerformer = ws.getDefaultPerformer();
        if (defaultPerformer == null || defaultPerformer.trim().length() == 0) {
            return null;
        }
        if (BLUtil.isParameter((String)defaultPerformer)) {
            String dsName = BLUtil.getParameter((String)defaultPerformer);
            Object objDSVal = pCtx.getSlotValue(dsName);
            if (objDSVal != null && !(objDSVal instanceof String)) {
                throw new BizLogicException("BizLogic_ERR_3908", "WFAtomicInstance.getDefaultPerformer", new Object[]{defaultPerformer, ws.getName(), ws.getProcessName()});
            }
            String dsValue = (String)objDSVal;
            defaultPerformer = dsValue != null && dsValue.trim().length() != 0 ? dsValue.trim() : null;
        }
        return defaultPerformer;
    }

    private void createWorkitemsForList(WFProcessContext pCtx, long wsid, Vector perfs, String role) {
        if (perfs == null || perfs.isEmpty()) {
            BLControl.logger.warnKey("BizLogic_ERR_3696", new Object[]{pCtx.getWorkstep(wsid).getName(), pCtx.getProcessInstanceName()});
            this.createWorkitemForMgr(pCtx, wsid, "null");
        } else {
            for (int i = 0; i < perfs.size(); ++i) {
                Performer perf = (Performer)perfs.elementAt(i);
                if (perf.isUser()) {
                    this.createWorkitemForUser(pCtx, wsid, perf);
                    continue;
                }
                if (perf.isEmail()) {
                    if (BLUtil.self().isExternalEmailPerformerEnabled()) {
                        this.createWorkitemForEmailPerformer(pCtx, wsid, perf);
                        continue;
                    }
                    this.createWorkitemForMgr(pCtx, wsid, perf.getSuffix());
                    if (!BLControl.util.DEBUG_ENGINE) continue;
                    Object[] objectArray = new Object[6];
                    objectArray[0] = perf;
                    objectArray[1] = pCtx.getProcessInstanceID();
                    objectArray[2] = wsid;
                    objectArray[3] = "bizlogic.external.emailperformer";
                    objectArray[4] = true;
                    objectArray[5] = "bizlogic.conf";
                    BLControl.logger.debugKey("BizLogic_ERR_4720", objectArray);
                    continue;
                }
                this.createWorkitemForMgr(pCtx, wsid, perf.getSuffix());
            }
        }
        if (pCtx.isDebug()) {
            long piid = pCtx.getProcessInstanceID();
            if (DebugService.self().isForceCompleteWS(piid)) {
                DebugService.self().completeWorkItems(pCtx, wsid);
                return;
            }
        }
    }

    private void createAvailWorkitemForList(WFProcessContext pCtx, long wsid, String wiperf, Vector perfs, String role) {
        WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wsid);
        String wsName = ws.getName();
        String piName = pCtx.getProcessInstanceName();
        if (pCtx.isDebug()) {
            long piid = pCtx.getProcessInstanceID();
            if (DebugService.self().isForceCompleteWS(piid)) {
                Performer perf = DebugService.self().getAvailWorkItemPerformer(pCtx);
                this.createWorkitemForUser(pCtx, wsid, perf);
                DebugService.self().completeWorkItems(pCtx, wsid);
                return;
            }
        }
        if (perfs == null || perfs.isEmpty() || Performer.areAllInvalid(perfs)) {
            BLControl.logger.warnKey("BizLogic_ERR_864", new Object[]{wsName, piName});
            this.createWorkitemForMgr(pCtx, wsid, wiperf);
        } else {
            Performer performer;
            Vector perfNames = (Vector)Performer.getPerformerNames(perfs);
            if (wiperf == null || wiperf.trim().length() == 0) {
                wiperf = BLUtil.toStringListPerformer((List)perfNames);
            }
            if (wiperf.length() > BLControl.util.MAX_WIPERFORMER_SIZE) {
                wiperf = wiperf.substring(0, BLControl.util.MAX_WIPERFORMER_SIZE);
            }
            Performer perf = new Performer(wiperf, 1);
            perf.setSuffix(null);
            WorkItemEBLocal wieb = this.createWorkitem(pCtx, wsid, perf, 27);
            long wiid = wieb.getId();
            long ptid = wieb.getProcessTemplateID();
            long piid = wieb.getProcessInstanceID();
            AvailableWorkItemDAO.store(wiid, ptid, piid, BLUtil.Vector2String((Vector)perfNames));
            this.sendAvailableEmail(pCtx, wieb.getId(), perfs);
            if (perfs.size() == 1 && (performer = (Performer)perfs.get(0)) != null && !performer.isQueue()) {
                WFWorkItem.self().assignWorkItem(pCtx, wiid, performer.getName());
            }
        }
    }

    private void createWorkitemForEmailPerformer(WFProcessContext pCtx, long wsid, Performer perf) {
        WorkItemEBLocal wieb = this.createWorkitem(pCtx, wsid, perf, 28);
        WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wsid);
        String performer = perf.getName();
        if (this.isWorkstepWebApp(pCtx, ws)) {
            EmailComposer.self().sendEmailWithBizSoloURLOnly(pCtx, wieb.getId(), performer);
        } else {
            pCtx.overrideEmailSupport(true);
            EmailComposer.self().sendAssignedTask(pCtx, wieb.getId(), performer, null);
            pCtx.overrideEmailSupport(false);
        }
    }

    private void createWorkitemForUser(WFProcessContext pCtx, long wsid, Performer perf) {
        WorkItemEBLocal wieb = this.createWorkitem(pCtx, wsid, perf, 28);
        WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wsid);
        if (ws.getEmailSupport() || BLUtil.self().isSendEmailForTask()) {
            String emailAddress = pCtx.getUserEmailAddress(perf.getName());
            if (emailAddress != null) {
                EmailComposer.self().sendAssignedTask(pCtx, wieb.getId(), emailAddress, null);
            } else {
                BLControl.logger.warnKey("BizLogic_ERR_1106", new Object[]{perf.getName()});
            }
        }
    }

    private void createWorkitemForMgr(WFProcessContext pCtx, long wsid, String perfSuffix) {
        WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wsid);
        List<Performer> userList = this.getAlternatePerformers(pCtx, wsid, perfSuffix);
        if (userList != null && !userList.isEmpty()) {
            if (ws.getPerformedByAll()) {
                Performer perf = userList.get(0);
                this.createWorkitemForUser(pCtx, wsid, perf);
            } else {
                this.createAvailWorkitemForList(pCtx, wsid, perfSuffix, new Vector<Performer>(userList), ws.getRole());
            }
        } else {
            String mgr = pCtx.getProcess().getManager();
            BLControl.logger.errorKey("BizLogic_ERR_4509", new Object[]{pCtx.getProcessInstanceID(), ws.getName(), mgr});
            this.suspendOnExecute(pCtx, wsid, null, BLControl.msgFactory.lookup("BizLogic_ERR_4645"));
        }
    }

    private List<Performer> getAlternatePerformers(WFProcessContext pCtx, long wsid, String perfSuffix) {
        ArrayList<Performer> userList = new ArrayList<Performer>();
        Performer altPerf = this.getRealDefaultPerformer(pCtx, wsid);
        if (altPerf != null) {
            userList.add(altPerf);
            return userList;
        }
        String mgr = this.getManager(pCtx);
        if (mgr == null) {
            return userList;
        }
        User mgrUser = pCtx.getUser(mgr);
        if (mgrUser != null) {
            altPerf = new Performer(mgr, mgrUser);
            String suffix = mgr + "(" + perfSuffix + ")";
            altPerf.setSuffix(suffix);
            userList.add(altPerf);
            return userList;
        }
        Group mgrGroup = BLUtil.getGroup((String)mgr);
        if (mgrGroup == null) {
            return userList;
        }
        WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wsid);
        ArrayList users = (ArrayList)this.getUsersFromGroup(pCtx, mgrGroup, null);
        BLControl.logger.warnKey("BizLogic_ERR_045", new Object[]{perfSuffix, pCtx.getWorkstep(wsid).getName(), pCtx.getProcessInstanceName(), mgr});
        if (ws.getPerformedByAll()) {
            for (int x = 0; x < users.size(); ++x) {
                altPerf = (Performer)users.get(x);
                if (pCtx.getUser(altPerf.getName()) == null || !altPerf.isUser()) continue;
                String suffix = altPerf.getSuffix() + "(" + perfSuffix + ")";
                altPerf.setSuffix(suffix);
                userList.add(altPerf);
                break;
            }
        } else {
            userList.addAll(users);
        }
        return userList;
    }

    private String getManager(WFProcessContext pCtx) {
        String mgr = pCtx.getProcess().getManager();
        if (BLUtil.isParameter((String)mgr)) {
            BLConstants.single();
            if (mgr.equals("@CREATOR")) {
                mgr = pCtx.getProcessInstanceEB().getCreator();
            } else {
                String dsName = BLUtil.getParameter((String)mgr);
                WFDataslot ds = pCtx.getProcess().getDataslot(dsName, true);
                if (ds != null && ds.isGlobal() && ds.isString()) {
                    mgr = (String)pCtx.getSlotValue(dsName);
                }
            }
        }
        if (mgr != null) {
            mgr = mgr.trim().length() == 0 ? null : mgr.trim();
        }
        return mgr;
    }

    private String getManagerEmail(WFProcessContext pCtx) {
        User usr;
        String mgr = pCtx.getProcess().getManager();
        if (mgr == null) {
            return null;
        }
        BLConstants.single();
        if ("@CREATOR".equals(mgr.trim())) {
            mgr = pCtx.getProcessInstanceEB().getCreator();
        }
        if ((usr = pCtx.getUser(mgr)) != null) {
            return pCtx.getUserEmailAddress(mgr);
        }
        Group grp = BLUtil.getGroup((String)mgr);
        if (grp != null) {
            return grp.getAttribute("EMAIL");
        }
        return null;
    }

    private WorkItemEBLocal createWorkitem(WFProcessContext pCtx, long wsid, Performer perf, int wistat) {
        long wiid;
        String piName = pCtx.getProcessInstanceName();
        String wsName = pCtx.getWorkstep(wsid).getName();
        long ptid = pCtx.getProcessTemplateID();
        long piid = pCtx.getProcessInstanceID();
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        String suffix = perf.getSuffix();
        String wiperf = perf.getName();
        String winame = suffix == null || suffix.length() == 0 ? piName + "::" + wsName : piName + "::" + wsName + "::" + suffix;
        if (winame.length() > BLControl.util.MAX_WINAME_SIZE) {
            throw new BizLogicException("BizLogic_ERR_662", "WFAtomicInstance:createWorkitem", new Object[]{winame, piName, wsName, String.valueOf(BLControl.util.MAX_WINAME_SIZE)});
        }
        if (wiperf.length() > BLControl.util.MAX_WIPERFORMER_SIZE) {
            throw new BizLogicException("BizLogic_ERR_663", "WFAtomicInstance:createWorkitem", new Object[]{wiperf, winame, piName, wsName, String.valueOf(BLControl.util.MAX_WIPERFORMER_SIZE)});
        }
        try {
            wiid = BLControl.util.wiSeq.getNextNumber();
        }
        catch (SQLException sqle) {
            throw new BizLogicException("BizLogic_ERR_1602", "WFAtomicInstance.createWorkitem", new Object[]{winame}, (Throwable)sqle);
        }
        long dueDate = this.getWIDueDate(pCtx, wsid, winame, wistat, perf);
        WorkItemEBLocal i = null;
        try {
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("PROCESSTEMPLATEID", ptid);
            h.put("PROCESSINSTANCEID", piid);
            h.put("WORKSTEPID", wsid);
            h.put("WORKSTEPNAME", wsName);
            h.put("WORKITEMID", wiid);
            h.put("WORKITEMNAME", winame);
            h.put("PERFORMER", wiperf);
            h.put("STATUS", wistat);
            h.put("PREVIOUSASSIGNEE", wiperf);
            h.put("STARTTIME", wsieb.getTimeStarted());
            h.put("DUEDATE", dueDate);
            h.put("PRIORITY", wsieb.getPriority());
            WorkItemEBLocalHome ebh = BLUtil.self().getWorkItemEBHome();
            i = ebh.create(h);
            pCtx.cacheIt(wiid, i);
        }
        catch (CreateException ce) {
            throw new BizLogicException("BizLogic_ERR_1620", "WFAtomicInstance.createWorkitem", new Object[]{wsName}, (Throwable)ce);
        }
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debug((Object)("Created wi: \n\t winame=" + winame + "\n\t wiperf=" + wiperf));
        }
        if (!pCtx.isInstanceMigration()) {
            BLUtil.fireEvent(WFWorkItem.self().getEventContext(pCtx, wiid, 25), (int)25);
            BLUtil.fireEvent(WFWorkItem.self().getEventContext(pCtx, wiid, wistat), (int)wistat);
        }
        return i;
    }

    public long getWIDueDate(WFProcessContext pCtx, long wsid, String winame, int wistat, Performer perf) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        long startTime = wsieb.getTimeStarted();
        long dueDate = wsieb.getDuedate();
        long piid = pCtx.getProcessInstanceID();
        WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wsid);
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debugKey("BizLogic_ERR_1711", new Object[]{winame, piid, new Date(dueDate).toString()});
            BLControl.logger.debug((Object)("WFAtomicInstance.getWIDueDate(): Is duedate set for this workstep? " + pCtx.isDueDateSetForWs(wsid)));
        }
        if (BLUtil.self().useCalendar()) {
            BLConstants.single();
            if (wistat != 27) {
                long duration;
                if (pCtx.isDueDateSetForWs(wsid)) {
                    duration = 0L;
                } else {
                    duration = this.getDuration(pCtx, wsid) * 1000L;
                    dueDate = startTime;
                }
                dueDate = this.getDueDate(pCtx, wsid, perf, dueDate, duration);
                if (BLControl.util.DEBUG_ENGINE) {
                    BLControl.logger.debugKey("BizLogic_ERR_1712", new Object[]{ws.getName(), perf.getName(), piid, new Date(dueDate).toString()});
                }
            }
        }
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debugKey("BizLogic_ERR_1711", new Object[]{winame, piid, new Date(dueDate).toString()});
        }
        return dueDate;
    }

    public long getDueDate(WFProcessContext pCtx, long wsid, Performer perf, long startTime, long duration) {
        long dueDate = 0L;
        User user = perf.getUser();
        if (user == null) {
            user = pCtx.getUser(perf.getName());
        }
        if (user != null) {
            dueDate = BLCalendar.self().getDueDate(user, startTime, duration);
        } else {
            WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
            dueDate = wsieb.getDuedate();
        }
        return dueDate;
    }

    @Override
    public long adjustDueDate(WFProcessContext pCtx, long wsid, long dueDate) {
        WFWorkstep ws = pCtx.getWorkstep(wsid);
        String performer = ws.getPerformer();
        Vector perfs = this.getPerformerList(pCtx, wsid, performer);
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debug((Object)("WFAtomicInstance.adjustDueDate(pCtx,wsid,perfs,dueDate,duration): List of performers are: " + perfs));
        }
        if (!BLUtil.self().useCalendar()) {
            return dueDate;
        }
        if (perfs != null && perfs.size() == 1) {
            String perf = (String)perfs.get(0);
            if (!BLControl.util.RESOURCE_VALIDATION_ASC && SBMControl.util.isUseQueue() && BLControl.queueManager.isQueue(perf)) {
                return dueDate;
            }
            Group group = BLUtil.getGroup((String)perf);
            if (group != null) {
                return this.getDueDate(pCtx, wsid, group, dueDate, 0L);
            }
            User user = BLUtil.getUser((String)perf);
            if (null != user) {
                return this.getDueDate(pCtx, wsid, user, dueDate, 0L);
            }
        }
        return dueDate;
    }

    private void updateWSIDueDate(WFProcessContext pCtx, long wsid, Vector perfs) {
        long newDueDate;
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        if (perfs == null) {
            String realPerf = this.getRealPerformer(pCtx, wsid, wsieb.getPerformer());
            perfs = this.getPerformerList(pCtx, wsid, realPerf);
        }
        long cachedDueDate = pCtx.getDueDateBefPreScript(wsid);
        long dueDate = wsieb.getDuedate();
        if ((cachedDueDate == -1L || dueDate == cachedDueDate) && dueDate != (newDueDate = this.getWSIDueDate(pCtx, wsid, perfs))) {
            wsieb.setDuedate(newDueDate);
            WFWorkstep ws = pCtx.getWorkstep(wsid);
            if (ws.isCheckDue()) {
                TimerActionDAO.updateDueDate(pCtx.getProcessInstanceID(), wsid, newDueDate);
            }
        }
    }

    public long getWSIDueDate(WFProcessContext pCtx, long wsid, Vector perfs) {
        long duration = this.getDuration(pCtx, wsid) * 1000L;
        return this.getWSIDueDate(pCtx, wsid, perfs, duration);
    }

    private long getWSIDueDate(WFProcessContext pCtx, long wsid, Vector perfs, long duration) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        long dueDate = wsieb.getDuedate();
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debug((Object)("WFAtomicInstance.getWSIDueDate(): Is duedate set for this workstep? " + pCtx.isDueDateSetForWs(wsid)));
        }
        if (pCtx.isDueDateSetForWs(wsid)) {
            return dueDate;
        }
        if (BLUtil.self().useCalendar() && perfs != null && perfs.size() == 1) {
            String performer = (String)perfs.get(0);
            if (!BLControl.util.RESOURCE_VALIDATION_ASC && SBMControl.util.isUseQueue() && BLControl.queueManager.isQueue(performer)) {
                return dueDate;
            }
            Group group = BLUtil.getGroup((String)performer);
            if (group != null) {
                return this.getDueDate(pCtx, wsid, group, duration);
            }
            User user = BLUtil.getUser((String)performer);
            if (null != user) {
                return this.getDueDate(pCtx, wsid, user, duration);
            }
        }
        return dueDate;
    }

    private long getDueDate(WFProcessContext pCtx, long wsid, User user, long duration) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        long timeStarted = wsieb.getTimeStarted();
        return this.getDueDate(pCtx, wsid, user, timeStarted, duration);
    }

    private long getDueDate(WFProcessContext pCtx, long wsid, User user, long timeStarted, long duration) {
        WFWorkstep ws = pCtx.getWorkstep(wsid);
        long dueDate = BLCalendar.self().getDueDate(user, timeStarted, duration);
        if (BLControl.util.DEBUG_ENGINE) {
            long piid = pCtx.getProcessInstanceID();
            BLControl.logger.debugKey("BizLogic_ERR_1712", new Object[]{ws.getName(), user.getAttribute("username"), piid, new Date(dueDate).toString()});
        }
        return dueDate;
    }

    private long getDueDate(WFProcessContext pCtx, long wsid, Group group, long duration) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        long timeStarted = wsieb.getTimeStarted();
        return this.getDueDate(pCtx, wsid, group, timeStarted, duration);
    }

    private long getDueDate(WFProcessContext pCtx, long wsid, Group group, long timeStarted, long duration) {
        WFWorkstep ws = pCtx.getWorkstep(wsid);
        long dueDate = BLCalendar.self().getDueDate(group, timeStarted, duration);
        if (BLControl.util.DEBUG_ENGINE) {
            long piid = pCtx.getProcessInstanceID();
            BLControl.logger.debugKey("BizLogic_ERR_1713", new Object[]{ws.getName(), group.getAttribute("groupname"), piid, new Date(dueDate).toString()});
        }
        return dueDate;
    }

    private void suspendOnExecute(WFProcessContext pCtx, long wsid, Exception e, String reason) {
        String piName = pCtx.getProcessInstanceName();
        String wsName = pCtx.getWorkstep(wsid).getName();
        pCtx.getWorkstepInstanceEB(wsid).setSuspendState(3);
        BLControl.logger.errorKey("BizLogic_ERR_1101", new Object[]{piName, wsName});
        this.suspend(pCtx, wsid, true, e, reason);
    }

    @Override
    public void suspend(WFProcessContext pCtx, long wsID, boolean reactivateOnError, Throwable causedBy, String reason) {
        if (this.isSuspended(pCtx, wsID)) {
            BLControl.logger.warnKey("BizLogic_ERR_1669", new Object[]{pCtx.getWorkstep(wsID).getName(), pCtx.getProcessInstanceName()});
            return;
        }
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsID);
        int state = wsieb.getSuspendState();
        if (state == 5 && !pCtx.getWorkstep(wsID).isMonitorStep()) {
            this.suspendWorkitems(pCtx, wsID);
        }
        super.suspend(pCtx, wsID, reactivateOnError, causedBy, reason);
    }

    private void suspendWorkitems(WFProcessContext pCtx, long wsID) {
        Vector v = WorkItemDAO.getIDByWorkStepInstance(pCtx.getProcessInstanceID(), wsID, 26);
        for (int ix = v.size() - 1; ix >= 0; --ix) {
            long wiid = (Long)v.elementAt(ix);
            WFWorkItem.self().suspend(pCtx, wiid, "suspend by parent");
            if (!BLControl.util.DEBUG_ENGINE) continue;
            BLControl.logger.debug((Object)("Suspended workitem id<" + wiid + "> for piid<" + pCtx.getProcessInstanceID() + ">, wsid<" + wsID + ">"));
        }
    }

    @Override
    public void resume(WFProcessContext pCtx, long wsID) {
        if (this.isActivated(pCtx, wsID)) {
            BLControl.logger.warnKey("BizLogic_ERR_1670", new Object[]{pCtx.getWorkstep(wsID).getName(), pCtx.getProcessInstanceName()});
            return;
        }
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsID);
        int state = wsieb.getSuspendState();
        if (state == 5 && !pCtx.getWorkstep(wsID).isMonitorStep()) {
            WFWorkItem.self().resumeByWorkStepID(pCtx, wsID);
        }
        super.resume(pCtx, wsID);
    }

    private final Vector executeEJB(WFProcessContext pCtx, long wsid, String performer) {
        HashMap context = this.getProcessContextData(pCtx, wsid);
        String piName = pCtx.getProcessInstanceName();
        WFProcess pt = pCtx.getProcess();
        String ptName = pt.getName();
        String jndiName = "";
        String methodName = "";
        try {
            Object instanceObject = null;
            Hashtable ejbHash = BLUtil.parseEJBPerformer((String)performer, (String)piName, (String)ptName);
            if (ejbHash == null) {
                throw new BizLogicAppException("BizLogic_ERR_3006", "EPManager.loadJNDI", new Object[]{piName, performer, ptName});
            }
            String appserverName = (String)ejbHash.get("APPSERVER");
            jndiName = (String)ejbHash.get("JNDINAME");
            methodName = jndiName.substring(jndiName.lastIndexOf(":") + 1);
            jndiName = jndiName.substring(0, jndiName.lastIndexOf(":"));
            if (BLControl.util.useEPAdapter) {
                EPAdapterSBHome epHome = (EPAdapterSBHome)SBMControl.homeFactory.lookupHome(EPAdapterSBHome.class);
                EPAdapterSB epAdapter = epHome.create();
                instanceObject = epAdapter.connect(ptName, appserverName, jndiName);
            } else {
                StringBuilder loc = new StringBuilder();
                loc.append(SBMControl.util.SBM_APPS_DIR);
                loc.append("/");
                SBMControl.consts.getClass();
                loc.append("common/ejbadapters");
                loc.append("/");
                Class classObj = SBMHomeFactory.self().getClassObject((ClassLoader)new SBMURLClassLoader(this.getClass().getClassLoader(), loc.toString()), appserverName, jndiName);
                EJBHome homeObject = SBMControl.homeFactory.lookupHome(appserverName, jndiName, classObj);
                Class<?> homeClass = homeObject.getClass();
                Method m = homeClass.getMethod("create", new Class[0]);
                instanceObject = m.invoke((Object)homeObject, new Object[0]);
            }
            Class<?> classObj = instanceObject.getClass();
            Method method = classObj.getMethod(methodName, HashMap.class);
            return (Vector)method.invoke(instanceObject, context);
        }
        catch (IndexOutOfBoundsException e) {
            throw new BizLogicException("BizLogic_ERR_600", "WFAtomicInstance.executeEJB", new Object[]{piName, performer, pt.getWorkstep(wsid).getName()}, (Throwable)e);
        }
        catch (SBMException e) {
            throw e;
        }
        catch (NamingException e) {
            throw new BizLogicException("BizLogic_ERR_1527", "WFAtomicInstance.executeEJB", new Object[]{jndiName}, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BizLogicException("BizLogic_ERR_093", "WFAtomicInstance.executeEJB", new Object[]{methodName, jndiName, piName}, (Throwable)e);
        }
        catch (Throwable t) {
            BLControl.logger.errorKey("BizLogic_ERR_637", new Object[]{ptName, performer, piName}, t);
            throw new BizLogicException("BizLogic_ERR_2126", "WFAtomicInstance.executeEJB", new Object[]{"Execution failed for", pt.getWorkstep(wsid).getName(), piName});
        }
    }

    public final void sendAvailableEmail(WFProcessContext pCtx, long wiid, Vector userList) {
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiid);
        WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wieb.getWorkStepID());
        if (ws.getEmailSupport() || BLUtil.self().isSendEmailForTask() || BLUtil.self().notifyAvailablePerformers) {
            for (int ix = 0; ix < userList.size(); ++ix) {
                List queueMembers;
                Performer perf = (Performer)userList.elementAt(ix);
                String availperformer = perf.getName();
                if (perf.isUser()) {
                    String emailAddress = pCtx.getUserEmailAddress(availperformer);
                    if (emailAddress != null) {
                        EmailComposer.self().sendAvailableTask(pCtx, wieb.getId(), emailAddress, availperformer);
                        continue;
                    }
                    BLControl.logger.warnKey("BizLogic_ERR_1104", new Object[]{availperformer});
                    continue;
                }
                if (perf.isEmail()) {
                    if (this.isWorkstepWebApp(pCtx, ws)) {
                        EmailComposer.self().sendEmailWithBizSoloURLOnly(pCtx, wieb.getId(), availperformer);
                        continue;
                    }
                    pCtx.overrideEmailSupport(true);
                    EmailComposer.self().sendAvailableTask(pCtx, wieb.getId(), availperformer, availperformer);
                    pCtx.overrideEmailSupport(false);
                    continue;
                }
                if (!perf.isQueue()) continue;
                String emailAddr = BLControl.queueManager.getEmailAddress(availperformer);
                if (emailAddr != null && emailAddr.trim().length() != 0) {
                    EmailComposer.self().sendAvailableTask(pCtx, wieb.getId(), emailAddr, availperformer);
                }
                if ((queueMembers = BLControl.queueManager.getQueueMembers(perf.getName())) == null || queueMembers.isEmpty()) continue;
                for (String member : queueMembers) {
                    String emailAddress = pCtx.getUserEmailAddress(member);
                    if (emailAddress != null && emailAddress.trim().length() != 0) {
                        EmailComposer.self().sendAvailableTask(pCtx, wieb.getId(), emailAddress, member);
                        continue;
                    }
                    BLControl.logger.warnKey("BizLogic_ERR_1104", new Object[]{member});
                }
            }
        } else {
            for (int ix = 0; ix < userList.size(); ++ix) {
                Performer perf = (Performer)userList.elementAt(ix);
                if (!perf.isEmail()) continue;
                String availperformer = perf.getName();
                if (this.isWorkstepWebApp(pCtx, ws)) {
                    EmailComposer.self().sendEmailWithBizSoloURLOnly(pCtx, wieb.getId(), availperformer);
                    continue;
                }
                pCtx.overrideEmailSupport(true);
                EmailComposer.self().sendAvailableTask(pCtx, wieb.getId(), availperformer, availperformer);
                pCtx.overrideEmailSupport(false);
            }
        }
    }

    public static final String getWorkItemPerformerEmailList(WFProcessContext pCtx, long wsid) {
        Vector<String> performers = new Vector<String>();
        StringBuffer emailList = new StringBuffer(500);
        String performer = null;
        String email = null;
        Collection c = WFAtomicInstance.self().getWorkitems(pCtx, wsid);
        if (c != null && !c.isEmpty()) {
            WorkItemEBLocal wieb2 = null;
            for (WorkItemEBLocal wieb2 : c) {
                int status = wieb2.getState();
                BLConstants.single();
                if (status == 28) {
                    performers.addElement(wieb2.getPerformer());
                    continue;
                }
                BLConstants.single();
                if (status != 27) continue;
                performers.addAll(AvailableWorkItemDAO.getAvailablePerformers(wieb2.getId()));
            }
        }
        for (int ix = performers.size() - 1; ix >= 0; --ix) {
            performer = (String)performers.elementAt(ix);
            User u = pCtx.getUser(performer);
            email = u != null ? pCtx.getUserEmailAddress(performer) : BLControl.queueManager.getEmailAddress(performer);
            if (email == null || email.trim().isEmpty()) {
                BLControl.logger.warnKey("BizLogic_ERR_1106", new Object[]{performer});
                continue;
            }
            emailList.append(email);
            if (ix <= 0) continue;
            emailList.append(",");
        }
        return emailList.toString();
    }

    public List getCompletedWorkItemPerformer(WFProcessContext pCtx, long wsid) {
        WFWorkstep ws = pCtx.getWorkstep(wsid);
        if (!ws.isAtomic()) {
            throw new BizLogicException("BizLogic_ERR_778", "WFAtomicInstance::getCompletedWorkItemPerformer", new Object[]{"getCompletionPerfomer", "Activity workstep"});
        }
        WFAtomicWS aws = (WFAtomicWS)ws;
        if (BLControl.util.isTrackWorkItemPerformer() || aws.isTrackWorkItemPerformer()) {
            HashMap<Long, Boolean> wsidList = new HashMap<Long, Boolean>(1);
            wsidList.put(wsid, WFAtomicWS.ISEXCLUDELASTPERFORMER_DEFAULT);
            return WorkItemPerformerDAO.getPerformer(pCtx.getProcessInstanceID(), wsidList);
        }
        throw new BizLogicException("BizLogic_ERR_777", "WFAtomicInstance::getCompletedWorkItemPerformer", new Object[]{pCtx.getProcessInstanceName() + "::" + ws.getName()});
    }

    public void makeAvailable(WFProcessContext pCtx, long wsid, Vector performers) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        String piName = pCtx.getProcessInstanceName();
        WFWorkstep wfws = pCtx.getWorkstep(wsid);
        String wsName = wfws.getName();
        if (wsieb.getType() != 102) {
            throw new BizLogicException("BizLogic_ERR_2132", "WFAtomicInstance.makeAvailable", new Object[]{wsName, piName, performers});
        }
        if (wsieb.getState() != 18) {
            throw new BizLogicException("BizLogic_ERR_4702", "WFAtomicInstance.makeAvailable", new Object[]{wsName, piName, performers});
        }
        if (wsieb.getState() == 16) {
            throw new BizLogicException("BizLogic_ERR_4632", "WFAtomicInstance.makeAvailable", new Object[]{piName, "workstep", wsid});
        }
        WFAtomicWS ws = (WFAtomicWS)wfws;
        if (ws.getPerformedByAll()) {
            throw new BizLogicException("BizLogic_ERR_1520", "WFAtomicInstance.makeAvailable", new Object[]{piName, wsName});
        }
        long wiid = -1L;
        try {
            Vector wiList = (Vector)WorkItemDAO.findByWorkStepInstance(pCtx.getProcessInstanceID(), wsid);
            wiid = (Long)wiList.get(0);
        }
        catch (Exception ex) {
            throw new BizLogicException("BizLogic_ERR_2604", "WFAtomicInstance.makeAvailable(pCtx, wsid, performers)", new Object[]{wsName, piName}, (Throwable)ex);
        }
        Vector userList = null;
        if (performers != null) {
            userList = this.expandListPerformer(pCtx, wsid, ws.getPerformedByAll(), performers, ws.getRole());
            if (userList == null || userList.isEmpty() || Performer.areAllInvalid(userList)) {
                throw new BizLogicException("BizLogic_ERR_045", "WFAtomicInstance.makeAvailable", new Object[]{performers.toString(), wsName, pCtx.getProcessTemplateName()});
            }
            Set excludePerformer = this.getExcludedPerformerList(pCtx, wsid);
            if ((userList = (Vector)Performer.removeAll(userList, excludePerformer)) == null || userList.isEmpty()) {
                throw new BizLogicException("BizLogic_ERR_853", "WFAtomicInstance.makeAvailabke", new Object[]{performers.toString(), wsName, pCtx.getProcessTemplateName()});
            }
        }
        Vector perfNames = (Vector)Performer.getPerformerNames(userList);
        WFWorkItem.self().makeAvailable(pCtx, wiid, perfNames, performers);
        if (performers != null) {
            String wiperf = BLUtil.toStringListPerformer((List)performers);
            if (wiperf.length() > BLControl.util.MAX_PERFORMER_SIZE) {
                BLControl.logger.warnKey("BizLogic_ERR_869", new Object[]{wiperf, wsName, piName, String.valueOf(BLControl.util.MAX_PERFORMER_SIZE)});
                wiperf = wiperf.substring(0, BLControl.util.MAX_PERFORMER_SIZE);
            }
            wsieb.setPerformer(wiperf);
            wsieb.setActualPerformer(wiperf);
        }
        if (performers == null && (ws.getEmailSupport() || BLUtil.self().isSendEmailForTask())) {
            performers = AvailableWorkItemDAO.getPerformerList(wiid);
            userList = this.expandListPerformer(pCtx, wsid, ws.getPerformedByAll(), performers, ws.getRole());
        }
        if (userList != null) {
            this.sendAvailableEmail(pCtx, wiid, userList);
        }
    }

    private void addAll(List source, List target) {
        for (int count = 0; count < target.size(); ++count) {
            if (source.contains(target.get(count))) continue;
            source.add(target.get(count));
        }
    }

    @Override
    public void setSuspendedByCompensatory(WFProcessContext pCtx, long wsid, boolean flag) {
        WFWorkItem.self().resumeByWorkStepID(pCtx, wsid);
        super.setSuspendedByCompensatory(pCtx, wsid, flag);
    }

    public boolean isWorkstepWebApp(WFProcessContext pCtx, WFAtomicWS ws) {
        if (ws.isWebApp()) {
            return true;
        }
        String performingApp = (String)this.getRealPerformingApp(pCtx, ws.getID());
        if (performingApp == null) {
            return false;
        }
        BLConstants.PerfAppConstants cfr_ignored_0 = BLControl.consts.perfApp;
        return performingApp.endsWith(".bizsolo");
    }

    public HashMap getVoteResultAttributes(WFProcessContext pCtx, long wsid) {
        WFWorkstep ws = pCtx.getWorkstep(wsid);
        if (!((WFAtomicWS)ws).isVoteEnabled()) {
            return null;
        }
        if (BLControl.util.isVotePersistedForWSI() && pCtx.isWorkstepCompleted(wsid)) {
            throw new BizLogicException("BizLogic_ERR_6000", "WFAtomicInstance.getVoteResultAttributes", new Object[]{ws.getName(), pCtx.getProcessInstanceName()});
        }
        HashMap<String, Serializable> voteAttrs = new HashMap<String, Serializable>(5);
        VoteCriteria voteCriteria = ((WFVoteWS)ws).getVoteCriteria();
        long piid = pCtx.getProcessInstanceID();
        int loopCounter = pCtx.getWorkstepInstanceEB(wsid).getLoopCounter();
        HashMap voteDetails = (HashMap)VoteDAO.getVoteInfo(piid, wsid, loopCounter);
        BLConstants.single();
        voteAttrs.put("PROCESSINSTANCEID", Long.valueOf(piid));
        BLConstants.single();
        voteAttrs.put("WORKSTEPID", Long.valueOf(wsid));
        BLConstants.single();
        voteAttrs.put("VOTECRITERIA", voteCriteria);
        BLConstants.single();
        voteAttrs.put("VOTEDETAILS", voteDetails);
        return voteAttrs;
    }

    @Override
    public void skip(WFProcessContext pCtx, long wsid) {
        try {
            this.removeWorkItems(pCtx, wsid);
        }
        catch (Exception e) {
            throw new BizLogicException("BizLogic_ERR_4627", "WFAtomicInstance.skip", new Object[]{"atomic", pCtx.getWorkstep(wsid).getName(), pCtx.getProcessInstanceName()}, (Throwable)e);
        }
        super.skip(pCtx, wsid);
    }

    private void removeWorkItems(WFProcessContext pCtx, long wsid) throws Exception {
        long piid = pCtx.getProcessInstanceID();
        WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wsid);
        if (!ws.getPerformedByAll()) {
            AvailableWorkItemDAO.removeByWorkStepInstance(piid, wsid);
        }
        WorkItemEBLocalHome ebh = BLUtil.self().getWorkItemEBHome();
        ebh.deleteByWorkStepInstance(piid, wsid);
        ExcludePerformerDAO.removeByWorktepInstance(piid, wsid);
        if (ws.isVoteEnabled() && BLControl.util.isVotePersistedForWSI()) {
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_6009", new Object[]{pCtx.getProcessInstanceID(), wsid, "WFAtomicInstance.terminate"});
            }
            VoteDAO.removeByWorktepInstance(pCtx.getProcessInstanceID(), wsid);
        }
    }
}

