/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFProcessInstance;
import com.savvion.sbm.bizlogic.server.dao.CWorkItemDAO;
import com.savvion.sbm.bizlogic.server.dao.ProcessNotesDAO;
import com.savvion.sbm.bizlogic.server.ejb.WorkItemEBLocal;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceEBLocal;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.util.SBMUtil;
import java.util.HashMap;
import java.util.Map;

public class WFProcessNotes {
    private static WFProcessNotes self;

    private WFProcessNotes() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WFProcessNotes self() {
        if (self != null) return self;
        Class<WFProcessNotes> clazz = WFProcessNotes.class;
        synchronized (WFProcessNotes.class) {
            if (self != null) return self;
            self = new WFProcessNotes();
            // ** MonitorExit[var0] (shouldn't be in output)
            return self;
        }
    }

    public long create(WFProcessContext pCtx, String notes, Map<String, Object> processNotesInfo) {
        if (notes == null || notes.trim().length() == 0) {
            throw new BizLogicException("BizLogic_ERR_886", "WFProcessNotes.create");
        }
        notes = WFProcessNotes.validateNotes(notes);
        this.validateNotesInfo(pCtx, processNotesInfo);
        HashMap pNotesData = (HashMap)((HashMap)processNotesInfo).clone();
        long ptid = this.getLongValue("PROCESSTEMPLATEID", pNotesData);
        WFProcess process = null;
        if (ptid == -1L) {
            process = pCtx.getProcess();
            ptid = process.getID();
            pNotesData.put("PROCESSTEMPLATEID", ptid);
        }
        long cWorkItemID = this.addCurrentWorkItemID(pCtx, processNotesInfo, pNotesData);
        long wiid = this.addWorkStepItem(pCtx, processNotesInfo, pNotesData, cWorkItemID);
        process = this.getWSName(pCtx, pNotesData, process, wiid);
        this.addWSNameAndLoopCouter(pCtx, pNotesData, process);
        pNotesData.put("LAST_MODIFIED_TIME", System.currentTimeMillis());
        long piid = pCtx.getProcessInstanceID();
        long notesID = ProcessNotesDAO.create(piid, notes, pNotesData);
        pNotesData.put("NOTES_ID", notesID);
        pNotesData.put("NOTES", notes);
        Map<String, Object> eventContext = this.getEventContext(pCtx, pNotesData, 81);
        BLUtil.fireEvent(eventContext, (int)81);
        return notesID;
    }

    private long addCurrentWorkItemID(WFProcessContext pCtx, Map<String, Object> processNotesInfo, Map<String, Object> pNotesData) {
        long cWorkItemID = this.getLongValue("CWORKITEM_ID", pNotesData);
        if (cWorkItemID != -1L) {
            Map<String, Object> cwiData = CWorkItemDAO.getCWorkItem(cWorkItemID, false);
            this.validateCWI(pCtx, processNotesInfo, cwiData);
            Long cStepID = (Long)cwiData.get("CSTEP_ID");
            pNotesData.put("CSTEP_ID", cStepID);
            Long parentWIID = (Long)cwiData.get("PARENT_WORKITEM_ID");
            pNotesData.put("WORKITEMID", parentWIID);
            String cwiName = (String)cwiData.get("CWORKITEM_NAME");
            pNotesData.put("CWORKITEM_NAME", cwiName);
        } else {
            pNotesData.put("CWORKITEM_ID", -1L);
        }
        return cWorkItemID;
    }

    private long addWorkStepItem(WFProcessContext pCtx, Map<String, Object> processNotesInfo, Map<String, Object> pNotesData, long cWorkItemID) {
        long wiid;
        long cStepID = this.getLongValue("CSTEP_ID", pNotesData);
        if (cStepID != -1L) {
            wiid = this.getLongValue("WORKITEMID", pNotesData);
            if (wiid == -1L) {
                Map<String, Object> cstepData = CWorkItemDAO.getCStep(cStepID, false);
                Long parentWIID = (Long)cstepData.get("PARENT_WORKITEM_ID");
                pNotesData.put("WORKITEMID", parentWIID);
            }
        } else {
            pNotesData.put("CSTEP_ID", -1L);
        }
        if ((wiid = this.getLongValue("WORKITEMID", pNotesData)) != -1L) {
            WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiid);
            if (cWorkItemID == -1L) {
                this.validateWI(pCtx, processNotesInfo, wieb);
            }
            pNotesData.put("WORKITEMNAME", wieb.getName());
            long wsid = wieb.getWorkStepID();
            pNotesData.put("WORKSTEPID", wsid);
        } else {
            pNotesData.put("WORKITEMID", -1L);
        }
        return wiid;
    }

    private WFProcess getWSName(WFProcessContext pCtx, Map<String, Object> pNotesData, WFProcess pt, long wiid) {
        WFProcess process = pt;
        String wsName = (String)pNotesData.get("WORKSTEPNAME");
        if (wsName != null && wsName.trim().length() != 0) {
            if (process == null) {
                process = pCtx.getProcess();
            }
            long wsid = process.getWorkstepID(wsName);
            if (wiid == -1L) {
                this.validateWS(pCtx, wsid, wsName);
            }
            pNotesData.put("WORKSTEPID", wsid);
        }
        return process;
    }

    private void addWSNameAndLoopCouter(WFProcessContext pCtx, Map<String, Object> pNotesData, WFProcess pt) {
        long wsid = this.getLongValue("WORKSTEPID", pNotesData);
        if (wsid != -1L) {
            int loopCounter;
            String wsName = (String)pNotesData.get("WORKSTEPNAME");
            if (wsName == null || wsName.trim().length() == 0) {
                if (pt == null) {
                    pt = pCtx.getProcess();
                }
                wsName = pt.getWorkstep(wsid).getName();
                pNotesData.put("WORKSTEPNAME", wsName);
            }
            if ((loopCounter = this.getIntValue("LOOPCOUNTER", pNotesData)) == -1) {
                WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
                loopCounter = wsieb.getLoopCounter();
                pNotesData.put("LOOPCOUNTER", loopCounter);
            }
        } else {
            pNotesData.put("WORKSTEPID", -1L);
        }
    }

    private static String validateNotes(String notes) {
        if (notes.length() > BLUtil.self().MAX_NOTES_SIZE) {
            BLControl.logger.warnKey("BizLogic_ERR_4602", new Object[]{notes.length(), BLControl.util.MAX_NOTES_SIZE, notes.substring(BLUtil.self().MAX_NOTES_SIZE)});
            notes = notes.substring(0, BLUtil.self().MAX_NOTES_SIZE);
        }
        return notes;
    }

    private void validateNotesInfo(WFProcessContext pCtx, Map<String, Object> processNotesInfo) {
        if (processNotesInfo == null || processNotesInfo.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_887", "WFProcessNotes.validateNotesInfo()");
        }
        int notesContext = this.getIntValue("NOTES_CONTEXT", processNotesInfo);
        if (notesContext == -1) {
            throw new BizLogicException("BizLogic_ERR_888", "WFProcessNotes.validateNotesInfo()");
        }
        String threadName = (String)processNotesInfo.get("THREAD_NAME");
        if (threadName != null && threadName.length() > BLUtil.self().MAX_THREADNAME_SIZE) {
            throw new BizLogicException("BizLogic_ERR_4619", "WFProcessNotes.validateNotesInfo()", new Object[]{pCtx.getProcessInstanceName(), processNotesInfo, threadName.length(), BLUtil.self().MAX_THREADNAME_SIZE});
        }
    }

    private void validateCWI(WFProcessContext pCtx, Map<String, Object> processNotesInfo, Map<String, Object> cwiData) {
        BLConstants.single();
        String cwiName = (String)cwiData.get("CWORKITEM_NAME");
        long wiid = this.getLongValue("WORKITEMID", processNotesInfo);
        long parentWIID = (Long)cwiData.get("PARENT_WORKITEM_ID");
        if (wiid != -1L && wiid != parentWIID) {
            throw new BizLogicException("BizLogic_ERR_3874", "WFProcessNotes.validateCWI()", new Object[]{wiid, parentWIID, cwiName});
        }
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(parentWIID);
        String wsNameOfCWI = wieb.getWorkStepName();
        BLConstants.single();
        String wsName = (String)processNotesInfo.get("WORKSTEPNAME");
        if (wsName != null && wsName.trim().length() != 0 && !wsName.equals(wsNameOfCWI)) {
            throw new BizLogicException("BizLogic_ERR_3875", "WFProcessNotes.validateCWI()", new Object[]{wsName, wsNameOfCWI, cwiName});
        }
        long piid = pCtx.getProcessInstanceID();
        BLConstants.single();
        long piidOfCWI = (Long)cwiData.get("PROCESSINSTANCEID");
        if (piid != piidOfCWI) {
            throw new BizLogicException("BizLogic_ERR_3876", "WFProcessNotes.validateCWI()", new Object[]{piid, piidOfCWI, cwiName});
        }
    }

    private void validateWI(WFProcessContext pCtx, Map<String, Object> processNotesInfo, WorkItemEBLocal wieb) {
        long piidOfWI;
        String wiName = wieb.getName();
        String wsNameOfWI = wieb.getWorkStepName();
        BLConstants.single();
        String wsName = (String)processNotesInfo.get("WORKSTEPNAME");
        if (wsName != null && wsName.trim().length() != 0 && !wsName.equals(wsNameOfWI)) {
            throw new BizLogicException("BizLogic_ERR_3877", "WFProcessNotes.validateWI()", new Object[]{wsName, wsNameOfWI, wiName});
        }
        long piid = pCtx.getProcessInstanceID();
        if (piid != (piidOfWI = wieb.getProcessInstanceID())) {
            throw new BizLogicException("BizLogic_ERR_3878", "WFProcessNotes.validateWI()", new Object[]{piid, piidOfWI, wiName});
        }
    }

    private void validateWS(WFProcessContext pCtx, long wsid, String wsName) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid, true);
        if (wsieb == null) {
            throw new BizLogicException("BizLogic_ERR_3879", "WFProcessNotes.create()", new Object[]{wsName, pCtx.getProcessInstanceID()});
        }
    }

    public long update(long processNotesId, String newNotes, String userWhoIsUpdating) {
        Map<String, Object> processNotesInfo = ProcessNotesDAO.getProcessNotes(processNotesId);
        String userOfProcessNotes = (String)processNotesInfo.get("NOTES_USER");
        if (!userOfProcessNotes.equals(userWhoIsUpdating)) {
            throw new BizLogicException("BizLogic_ERR_889", "WFProcessNotes.update", new Object[]{processNotesId, userWhoIsUpdating, userOfProcessNotes});
        }
        long lastModifiedTime = System.currentTimeMillis();
        ProcessNotesDAO.update(processNotesId, newNotes, lastModifiedTime);
        processNotesInfo.put("NOTES", newNotes);
        processNotesInfo.put("LAST_MODIFIED_TIME", lastModifiedTime);
        long piid = this.getLongValue("PROCESSINSTANCEID", processNotesInfo);
        WFProcessContext pCtx = new WFProcessContext(BLControl.getServerSession(), piid);
        Map<String, Object> eventContext = this.getEventContext(pCtx, processNotesInfo, 82);
        BLUtil.fireEvent(eventContext, (int)82);
        return lastModifiedTime;
    }

    public void remove(long piid, long processNotesId) {
        int referenceCount = ProcessNotesDAO.getReferenceCount(processNotesId);
        if (referenceCount > 0) {
            throw new BizLogicException("BizLogic_ERR_890", "WFProcessNotes.remove", new Object[]{processNotesId, referenceCount});
        }
        ProcessNotesDAO.remove(processNotesId);
        HashMap<String, Long> processNotesInfo = new HashMap<String, Long>();
        processNotesInfo.put("NOTES_ID", processNotesId);
        WFProcessContext pCtx = new WFProcessContext(BLControl.getServerSession(), piid);
        Map<String, Object> eventContext = this.getEventContext(pCtx, processNotesInfo, 83);
        BLUtil.fireEvent(eventContext, (int)83);
    }

    private Map<String, Object> getEventContext(WFProcessContext pCtx, Map pNotesData, int eventType) {
        Map eventContext = SBMUtil.getNewEventContext();
        if (!WFProcessInstance.checkAuditRequired(pCtx, eventType)) {
            eventContext.put("AUDIT_DISABLED", true);
            return eventContext;
        }
        WFProcess pt = pCtx.getProcess();
        eventContext.put("APP_NAME", pt.getAppName());
        eventContext.put("PROCESSTEMPLATENAME", pt.getName());
        eventContext.put("PROCESSTEMPLATEID", pt.getID());
        eventContext.put("PROCESSINSTANCEID", pCtx.getProcessInstanceID());
        long longVal = this.getLongValue("NOTES_ID", pNotesData);
        eventContext.put("NOTES_ID", longVal);
        if (pNotesData.size() == 1) {
            if (pNotesData.containsKey("NOTES_ID")) {
                return eventContext;
            }
        }
        long wsid = this.getLongValue("WORKSTEPID", pNotesData);
        eventContext.put("WORKSTEPID", wsid);
        String stringVal = (String)pNotesData.get("WORKSTEPNAME");
        if (stringVal == null) {
            stringVal = "<NULL>";
        }
        eventContext.put("WORKSTEPNAME", stringVal);
        int intVal = this.getIntValue("LOOPCOUNTER", pNotesData);
        eventContext.put("LOOPCOUNTER", String.valueOf(intVal));
        longVal = this.getLongValue("WORKITEMID", pNotesData);
        eventContext.put("WORKITEMID", longVal);
        stringVal = (String)pNotesData.get("WORKITEMNAME");
        if (stringVal == null) {
            stringVal = "<NULL>";
        }
        eventContext.put("WORKITEMNAME", stringVal);
        longVal = this.getLongValue("CSTEP_ID", pNotesData);
        eventContext.put("CSTEP_ID", longVal);
        longVal = this.getLongValue("CWORKITEM_ID", pNotesData);
        eventContext.put("CWORKITEM_ID", longVal);
        stringVal = (String)pNotesData.get("CWORKITEM_NAME");
        if (stringVal == null) {
            stringVal = "<NULL>";
        }
        eventContext.put("CWORKITEM_NAME", stringVal);
        stringVal = (String)pNotesData.get("NOTES_USER");
        eventContext.put("NOTES_USER", stringVal);
        stringVal = (String)pNotesData.get("THREAD_NAME");
        if (stringVal == null) {
            stringVal = "<NULL>";
        }
        eventContext.put("THREAD_NAME", stringVal);
        stringVal = (String)pNotesData.get("NOTES");
        eventContext.put("NOTES", stringVal);
        intVal = this.getIntValue("NOTES_CONTEXT", pNotesData);
        eventContext.put("NOTES_CONTEXT", intVal);
        longVal = this.getLongValue("REFERENCE_ID", pNotesData);
        eventContext.put("REFERENCE_ID", longVal);
        longVal = this.getLongValue("LAST_MODIFIED_TIME", pNotesData);
        eventContext.put("LAST_MODIFIED_TIME", longVal);
        intVal = this.getIntValue("NOTES_TYPE", pNotesData);
        if (intVal == 1) {
            eventContext.put("NOTES_TYPE", "INFO");
        } else if (intVal == 3) {
            eventContext.put("NOTES_TYPE", "ERROR");
        } else if (intVal == 2) {
            eventContext.put("NOTES_TYPE", "WARN");
        } else {
            eventContext.put("NOTES_TYPE", "UNKNOWN");
        }
        return eventContext;
    }

    private long getLongValue(String key, Map<String, Object> notesInfo) {
        Long longObj = (Long)notesInfo.get(key);
        if (longObj == null) {
            return -1L;
        }
        return longObj;
    }

    private int getIntValue(String key, Map<String, Object> notesInfo) {
        Integer intObj = (Integer)notesInfo.get(key);
        if (intObj == null) {
            return -1;
        }
        return intObj;
    }
}

