/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.dao;

import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.DBConstants;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;

public class BLDocDSDAO
extends BLDAOService {
    private static final String[] INSERT_FOLDER_LIST;
    private static final String[] INSERT_DOCUMENT_LIST;
    private static final String INSERT_INTO = "INSERT INTO ";
    private static final String OPEN_PARENTHESIS = " (";
    private static final String CLOSE_PARENTHESIS = ")";
    private static final String VALUES = ") values (";
    private static final String QUESTION_MARK = "?";
    private static final String DELETE_FROM = "DELETE FROM ";
    private static final String WHERE = " WHERE ";
    private static final String COMMA = ", ";
    private static final String EQUALS_QUESTION_MARK = " =?";
    private static final String AND = " AND ";
    private static final String EQUALS_NEGATIVE_ONE = " = -1)";
    private static final String IN_SELECT = " IN (SELECT ";
    private static final String SELECT = "SELECT ";
    private static final String FROM = " FROM ";
    private static String insertDocument;
    private static String insertFolder;
    private static String deleteDocument;
    private static String deleteByFolderId;
    private static String deleteFolder;
    private static String deleteFolderByPT;
    private static String deleteFolderByPiid;
    private static String deleteDocumentByPT;
    private static String getDocuments;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertFolder(Map<String, Object> attributes) {
        BLDocDSDAO.validateInsertOrDelete();
        Connection conn = null;
        PreparedStatement pstmtInsertFolder = null;
        try {
            conn = BLDocDSDAO.getConnection();
            pstmtInsertFolder = conn.prepareStatement(insertFolder);
            String key = null;
            Object value = null;
            for (int i = 0; i < INSERT_FOLDER_LIST.length; ++i) {
                block14: {
                    block13: {
                        key = INSERT_FOLDER_LIST[i];
                        value = attributes.get(key);
                        DBConstants.ColConstants cfr_ignored_0 = DBConstants.single().col;
                        if (key.equals("PROCESS_TEMPLATE_ID")) break block13;
                        DBConstants.ColConstants cfr_ignored_1 = DBConstants.single().col;
                        if (key.equals("PROCESS_INSTANCE_ID")) break block13;
                        DBConstants.ColConstants cfr_ignored_2 = DBConstants.single().col;
                        if (!key.equals("PARENT_PIID")) break block14;
                    }
                    if (value == null) {
                        pstmtInsertFolder.setNull(i + 1, -5);
                        continue;
                    }
                    pstmtInsertFolder.setLong(i + 1, (Long)value);
                    continue;
                }
                DBConstants.ColConstants cfr_ignored_3 = DBConstants.single().col;
                if (!key.equals("DATASLOT_NAME")) {
                    DBConstants.ColConstants cfr_ignored_4 = DBConstants.single().col;
                    if (!key.equals("DATASLOT_FOLDER_ID")) continue;
                }
                if (value == null) {
                    pstmtInsertFolder.setNull(i + 1, 12);
                    continue;
                }
                pstmtInsertFolder.setString(i + 1, (String)value);
            }
            pstmtInsertFolder.execute();
        }
        catch (SQLException e) {
            BLDocDSDAO.handle((Throwable)e, (String)("BLDocDSDAO.insertFolder() " + attributes));
        }
        finally {
            BLDocDSDAO.clean(null, (Statement)pstmtInsertFolder, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertDocument(Map<String, Object> attributes) {
        BLDocDSDAO.validateInsertOrDelete();
        Connection conn = null;
        PreparedStatement pstmtInsertDocument = null;
        DBConstants.ColConstants cfr_ignored_0 = DBConstants.single().col;
        String docId = (String)attributes.get("DOC_ID");
        try {
            conn = BLDocDSDAO.getConnection();
            pstmtInsertDocument = conn.prepareStatement(insertDocument);
            String key = null;
            Object value = null;
            for (int i = 0; i < INSERT_DOCUMENT_LIST.length; ++i) {
                key = INSERT_DOCUMENT_LIST[i];
                value = attributes.get(key);
                DBConstants.ColConstants cfr_ignored_1 = DBConstants.single().col;
                if (!key.equals("DATASLOT_FOLDER_ID")) {
                    DBConstants.ColConstants cfr_ignored_2 = DBConstants.single().col;
                    if (!key.equals("DOC_ID")) continue;
                }
                if (value == null) {
                    pstmtInsertDocument.setNull(i + 1, 12);
                    continue;
                }
                pstmtInsertDocument.setString(i + 1, (String)value);
            }
            pstmtInsertDocument.execute();
        }
        catch (SQLException e) {
            BLDocDSDAO.handle((Throwable)e, (String)("BLDocDSDAO.insert() docId : " + docId));
        }
        finally {
            BLDocDSDAO.clean(null, (Statement)pstmtInsertDocument, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteById(String docId) {
        BLDocDSDAO.validateInsertOrDelete();
        Connection conn = null;
        PreparedStatement pstmtDeleteDocument = null;
        try {
            conn = BLDocDSDAO.getConnection();
            pstmtDeleteDocument = conn.prepareStatement(deleteDocument);
            pstmtDeleteDocument.setString(1, docId);
            pstmtDeleteDocument.execute();
        }
        catch (SQLException e) {
            BLDocDSDAO.handle((Throwable)e, (String)("BLDocDSDAO.deleteById() docId : " + docId));
        }
        finally {
            BLDocDSDAO.clean(null, (Statement)pstmtDeleteDocument, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteById(ArrayList docIdList) {
        BLDocDSDAO.validateInsertOrDelete();
        if (docIdList == null || docIdList.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmtDeleteDocument = null;
        StringBuffer deleteDocuments = new StringBuffer();
        deleteDocuments.append(DELETE_FROM);
        DBConstants.TableConstants cfr_ignored_0 = DBConstants.single().tab;
        deleteDocuments.append("BIZLOGIC_DOCDS_DOC");
        deleteDocuments.append(WHERE);
        DBConstants.ColConstants cfr_ignored_1 = DBConstants.single().col;
        deleteDocuments.append("DOC_ID");
        deleteDocuments.append(" IN (");
        for (int i = 0; i < docIdList.size(); ++i) {
            deleteDocuments.append('\'');
            deleteDocuments.append(docIdList.get(i));
            deleteDocuments.append('\'');
            if (i >= docIdList.size() - 1) continue;
            deleteDocuments.append(COMMA);
        }
        deleteDocuments.append(CLOSE_PARENTHESIS);
        try {
            conn = BLDocDSDAO.getConnection();
            pstmtDeleteDocument = conn.prepareStatement(deleteDocuments.toString());
            pstmtDeleteDocument.execute();
        }
        catch (SQLException e) {
            try {
                BLDocDSDAO.handle((Throwable)e, (String)("BLDocDSDAO.deleteById() document id : " + docIdList));
            }
            catch (Throwable throwable) {
                BLDocDSDAO.clean(null, pstmtDeleteDocument, (Connection)conn);
                throw throwable;
            }
            BLDocDSDAO.clean(null, (Statement)pstmtDeleteDocument, (Connection)conn);
        }
        BLDocDSDAO.clean(null, (Statement)pstmtDeleteDocument, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteByFolderId(String dsFolderId) {
        BLDocDSDAO.validateInsertOrDelete();
        Connection conn = null;
        PreparedStatement pstmtDeleteByFolderId = null;
        try {
            conn = BLDocDSDAO.getConnection();
            pstmtDeleteByFolderId = conn.prepareStatement(deleteByFolderId);
            pstmtDeleteByFolderId.setString(1, dsFolderId);
            pstmtDeleteByFolderId.execute();
        }
        catch (SQLException e) {
            BLDocDSDAO.handle((Throwable)e, (String)("BLDocDSDAO.deleteByFolderId() dsFolderId : " + dsFolderId));
        }
        finally {
            BLDocDSDAO.clean(null, (Statement)pstmtDeleteByFolderId, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFolder(long ptid, long piid, String dsName) {
        BLDocDSDAO.validateInsertOrDelete();
        Connection conn = null;
        PreparedStatement pstmtDeleteFolder = null;
        try {
            conn = BLDocDSDAO.getConnection();
            pstmtDeleteFolder = conn.prepareStatement(deleteFolder);
            pstmtDeleteFolder.setLong(1, ptid);
            pstmtDeleteFolder.setLong(2, piid);
            pstmtDeleteFolder.setString(3, dsName);
            pstmtDeleteFolder.execute();
        }
        catch (SQLException e) {
            BLDocDSDAO.handle((Throwable)e, (String)("BLDocDSDAO.deleteFolder() ptid : " + ptid + "  piid " + piid + "  dsName " + dsName));
        }
        finally {
            BLDocDSDAO.clean(null, (Statement)pstmtDeleteFolder, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteByProcessTemplate(long ptid) {
        BLDocDSDAO.validateInsertOrDelete();
        Connection conn = null;
        PreparedStatement pstmtDeleteFolderByPT = null;
        PreparedStatement pstmtDeleteDocumentByPT = null;
        try {
            conn = BLDocDSDAO.getConnection();
            pstmtDeleteDocumentByPT = conn.prepareStatement(deleteDocumentByPT);
            pstmtDeleteDocumentByPT.setLong(1, ptid);
            pstmtDeleteDocumentByPT.execute();
            pstmtDeleteFolderByPT = conn.prepareStatement(deleteFolderByPT);
            pstmtDeleteFolderByPT.setLong(1, ptid);
            pstmtDeleteFolderByPT.execute();
        }
        catch (SQLException e) {
            try {
                BLDocDSDAO.handle((Throwable)e, (String)("BLDocDSDAO.deleteByProcessTemplate() ptid : " + ptid));
            }
            catch (Throwable throwable) {
                BLDocDSDAO.clean(null, pstmtDeleteFolderByPT, null);
                BLDocDSDAO.clean(null, (Statement)pstmtDeleteDocumentByPT, (Connection)conn);
                throw throwable;
            }
            BLDocDSDAO.clean(null, (Statement)pstmtDeleteFolderByPT, null);
            BLDocDSDAO.clean(null, (Statement)pstmtDeleteDocumentByPT, (Connection)conn);
        }
        BLDocDSDAO.clean(null, (Statement)pstmtDeleteFolderByPT, null);
        BLDocDSDAO.clean(null, (Statement)pstmtDeleteDocumentByPT, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getDocuments(String dsFolderId) {
        Connection conn = null;
        PreparedStatement pstmtGetDocuments = null;
        ResultSet rs = null;
        ArrayList<String> documentList = new ArrayList<String>();
        try {
            conn = BLDocDSDAO.getConnection();
            pstmtGetDocuments = conn.prepareStatement(getDocuments);
            pstmtGetDocuments.setString(1, dsFolderId);
            rs = pstmtGetDocuments.executeQuery();
            while (rs.next()) {
                DBConstants.ColConstants cfr_ignored_0 = DBConstants.single().col;
                documentList.add(rs.getString("DOC_ID"));
            }
        }
        catch (SQLException e) {
            try {
                BLDocDSDAO.handle((Throwable)e, (String)("BLDocDSDAO.getDocuments() dsFolderId " + dsFolderId));
            }
            catch (Throwable throwable) {
                BLDocDSDAO.clean(rs, (Statement)pstmtGetDocuments, (Connection)conn);
                throw throwable;
            }
            BLDocDSDAO.clean((ResultSet)rs, (Statement)pstmtGetDocuments, (Connection)conn);
        }
        BLDocDSDAO.clean((ResultSet)rs, (Statement)pstmtGetDocuments, (Connection)conn);
        return documentList;
    }

    public static synchronized void initSQLStatements() {
        BLDocDSDAO.initSQLStatementInsertDocument();
        BLDocDSDAO.initSQLStatementDeleteDocument();
        BLDocDSDAO.initSQLStatementDeleteByFolderId();
        BLDocDSDAO.initSQLStatementDeleteFolder();
        BLDocDSDAO.initSQLStatementDeleteFolderByPT();
        BLDocDSDAO.initSQLStatementDeleteDocumentByPT();
        BLDocDSDAO.initSQLStatementGetDocuments();
        BLDocDSDAO.initSQLStatementInserFolder();
        deleteFolderByPiid = BLDocDSDAO.getDeleteFolderByPiidSQL();
        BLDocDSDAO.printSQLStatements();
    }

    private static void initSQLStatementInsertDocument() {
        int ix;
        StringBuffer tmpBuffer = new StringBuffer();
        tmpBuffer.append(INSERT_INTO).append("BIZLOGIC_DOCDS_DOC");
        BLDocDSDAO.addRowlockHint((StringBuffer)tmpBuffer);
        StringBuilder stringBuilder = new StringBuilder(tmpBuffer);
        stringBuilder.append(OPEN_PARENTHESIS);
        for (ix = 0; ix < INSERT_DOCUMENT_LIST.length; ++ix) {
            stringBuilder.append(INSERT_DOCUMENT_LIST[ix]);
            if (ix == INSERT_DOCUMENT_LIST.length - 1) continue;
            stringBuilder.append(COMMA);
        }
        stringBuilder.append(VALUES);
        for (ix = 0; ix < INSERT_DOCUMENT_LIST.length; ++ix) {
            stringBuilder.append(QUESTION_MARK);
            if (ix == INSERT_DOCUMENT_LIST.length - 1) continue;
            stringBuilder.append(COMMA);
        }
        stringBuilder.append(CLOSE_PARENTHESIS);
        insertDocument = stringBuilder.toString();
    }

    private static void initSQLStatementDeleteDocument() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DELETE_FROM).append("BIZLOGIC_DOCDS_DOC").append(WHERE).append("DOC_ID").append(EQUALS_QUESTION_MARK);
        deleteDocument = stringBuilder.toString();
    }

    private static void initSQLStatementDeleteByFolderId() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DELETE_FROM).append("BIZLOGIC_DOCDS_DOC").append(WHERE).append("DATASLOT_FOLDER_ID").append(EQUALS_QUESTION_MARK);
        deleteByFolderId = stringBuilder.toString();
    }

    private static void initSQLStatementDeleteFolder() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DELETE_FROM).append("BIZLOGIC_DOCDS_FOLDER").append(WHERE).append("PROCESS_TEMPLATE_ID").append(EQUALS_QUESTION_MARK).append(AND).append("PROCESS_INSTANCE_ID").append(EQUALS_QUESTION_MARK).append(AND).append("DATASLOT_NAME").append(EQUALS_QUESTION_MARK);
        deleteFolder = stringBuilder.toString();
    }

    private static void initSQLStatementDeleteFolderByPT() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DELETE_FROM).append("BIZLOGIC_DOCDS_FOLDER").append(WHERE).append("PROCESS_TEMPLATE_ID").append(EQUALS_QUESTION_MARK);
        deleteFolderByPT = stringBuilder.toString();
    }

    private static void initSQLStatementDeleteDocumentByPT() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DELETE_FROM).append("BIZLOGIC_DOCDS_DOC").append(WHERE).append("DATASLOT_FOLDER_ID").append(IN_SELECT).append("DATASLOT_FOLDER_ID").append(FROM).append("BIZLOGIC_DOCDS_FOLDER").append(WHERE).append("PROCESS_TEMPLATE_ID").append(EQUALS_QUESTION_MARK).append(AND).append("PARENT_PIID").append(EQUALS_NEGATIVE_ONE);
        deleteDocumentByPT = stringBuilder.toString();
    }

    private static void initSQLStatementGetDocuments() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SELECT).append("DOC_ID").append(FROM).append("BIZLOGIC_DOCDS_DOC").append(WHERE).append("DATASLOT_FOLDER_ID").append(EQUALS_QUESTION_MARK);
        getDocuments = stringBuilder.toString();
    }

    private static void initSQLStatementInserFolder() {
        int ix;
        StringBuffer tmpBuffer = new StringBuffer();
        tmpBuffer.append(INSERT_INTO).append("BIZLOGIC_DOCDS_FOLDER");
        BLDocDSDAO.addRowlockHint((StringBuffer)tmpBuffer);
        StringBuilder stringBuilder = new StringBuilder(tmpBuffer);
        stringBuilder.append(OPEN_PARENTHESIS);
        for (ix = 0; ix < INSERT_FOLDER_LIST.length; ++ix) {
            stringBuilder.append(INSERT_FOLDER_LIST[ix]);
            if (ix == INSERT_FOLDER_LIST.length - 1) continue;
            stringBuilder.append(COMMA);
        }
        stringBuilder.append(VALUES);
        for (ix = 0; ix < INSERT_FOLDER_LIST.length; ++ix) {
            stringBuilder.append(QUESTION_MARK);
            if (ix == INSERT_FOLDER_LIST.length - 1) continue;
            stringBuilder.append(COMMA);
        }
        stringBuilder.append(CLOSE_PARENTHESIS);
        insertFolder = stringBuilder.toString();
    }

    static String getDeleteFolderByPiidSQL() {
        DBConstants.TableConstants cfr_ignored_0 = DBConstants.single().tab;
        DBConstants.KeywordConstants cfr_ignored_1 = DBConstants.single().kwd;
        DBConstants.ViewAliasConstants cfr_ignored_2 = DBConstants.single().viewAlias;
        DBConstants.KeywordConstants cfr_ignored_3 = DBConstants.single().kwd;
        String sql = DELETE_FROM + "BIZLOGIC_DOCDS_FOLDER" + WHERE + "PROCESS_INSTANCE_ID" + " = ? ";
        return sql;
    }

    static void validateInsertOrDelete() {
        if (!BLUtil.self().isSaveDocumentIds()) {
            throw new BizLogicException("BizLogic_ERR_1716", "Misuse of insert/delete on DAO. Not allowed to insert/delete if BLUtil.self().isSaveDocumentIds is false");
        }
    }

    private static void printSQLStatements() {
        if (BLUtil.self().DEBUG_DAO) {
            BLControl.logger.debug((Object)"BLDocDSDAO:");
            BLControl.logger.debugKey("BizLogic_ERR_1199", insertDocument, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", insertFolder, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", deleteDocument, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", deleteByFolderId, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", deleteFolder, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", deleteFolderByPT, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", deleteFolderByPiid, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", deleteDocumentByPT, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getDocuments, new Object[0]);
        }
    }

    static {
        String[] stringArray = new String[5];
        DBConstants.ColConstants cfr_ignored_0 = DBConstants.single().col;
        stringArray[0] = "PROCESS_TEMPLATE_ID";
        DBConstants.ColConstants cfr_ignored_1 = DBConstants.single().col;
        stringArray[1] = "PROCESS_INSTANCE_ID";
        DBConstants.ColConstants cfr_ignored_2 = DBConstants.single().col;
        stringArray[2] = "DATASLOT_NAME";
        DBConstants.ColConstants cfr_ignored_3 = DBConstants.single().col;
        stringArray[3] = "DATASLOT_FOLDER_ID";
        DBConstants.ColConstants cfr_ignored_4 = DBConstants.single().col;
        stringArray[4] = "PARENT_PIID";
        INSERT_FOLDER_LIST = stringArray;
        String[] stringArray2 = new String[2];
        DBConstants.ColConstants cfr_ignored_5 = DBConstants.single().col;
        stringArray2[0] = "DATASLOT_FOLDER_ID";
        DBConstants.ColConstants cfr_ignored_6 = DBConstants.single().col;
        stringArray2[1] = "DOC_ID";
        INSERT_DOCUMENT_LIST = stringArray2;
    }
}

