/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.dao;

import com.savvion.sbm.bizlogic.client.queryservice.QSCWorkItemDAO;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.DBConstants;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CWorkItemDAO
extends BLDAOService {
    private static final String[] CREATE_LIST;
    private static final String[] CREATE_TABLELIST;
    private static final String[] CREATE_CSTEP_TABLELIST;
    private static final String[] CREATE_CSTEP_DS_TABLELIST;
    private static final String[] CREATE_AVAILABLE_CWI_TABLELIST;
    public static String createCWorkItem;
    public static String createCStep;
    public static String createCStepDS;
    public static String createAvailCWI;
    public static String findByPrimaryKeyAndParentWI;
    public static String findByParentWI;
    public static String removeCWorkItemByParentWI;
    public static String removeAvailCWorkItemByParentWI;
    public static String removeCStepByParentWI;
    public static String removeCStepDSByParentWI;
    public static String removeCWorkItemByParentPI;
    public static String removeAvailCWorkItemByParentPI;
    public static String removeCStepByParentPI;
    public static String removeCStepDSByParentPI;
    public static String getCWorkItem;
    public static String getCStep;
    public static String getAvailableFor;
    public static String getOutputDS;
    public static String getState;
    public static String isAvailableFor;
    public static String updateState;
    public static String updateCreator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create(Map<String, Object> attrsList) {
        String key = null;
        Object value = null;
        Connection conn = null;
        PreparedStatement pstmtCreateCWorkItem = null;
        long collwiid = -1L;
        try {
            conn = CWorkItemDAO.getConnection();
            pstmtCreateCWorkItem = conn.prepareStatement(createCWorkItem);
            for (int ix = 0; ix < CREATE_LIST.length; ++ix) {
                block39: {
                    block38: {
                        block37: {
                            block36: {
                                block35: {
                                    block34: {
                                        block33: {
                                            block32: {
                                                block31: {
                                                    block30: {
                                                        key = CREATE_LIST[ix];
                                                        value = attrsList.get(key);
                                                        if (key.equalsIgnoreCase("ESCALATION_TYPE")) break block30;
                                                        if (key.equalsIgnoreCase("STATUS")) break block30;
                                                        if (key.equalsIgnoreCase("PREVIOUSSTATUS")) break block30;
                                                        if (!key.equalsIgnoreCase("PRIORITY")) break block31;
                                                    }
                                                    if (value == null) {
                                                        pstmtCreateCWorkItem.setNull(ix + 1, 4);
                                                        continue;
                                                    }
                                                    pstmtCreateCWorkItem.setInt(ix + 1, (Integer)value);
                                                    continue;
                                                }
                                                if (key.equalsIgnoreCase("COLLABORATOR")) break block32;
                                                if (key.equalsIgnoreCase("CREATOR")) break block32;
                                                if (!key.equalsIgnoreCase("CWORKITEM_NAME")) break block33;
                                            }
                                            if (value == null) {
                                                throw new BizLogicException("BizLogic_ERR_1588", "CWIDAO.create", new Object[]{key, "COLLABORATIVE WORKITEM"});
                                            }
                                            pstmtCreateCWorkItem.setString(ix + 1, (String)value);
                                            continue;
                                        }
                                        if (key.equalsIgnoreCase("INSTRUCTION")) break block34;
                                        if (!key.equalsIgnoreCase("RESPONSE")) break block35;
                                    }
                                    if (value == null) {
                                        pstmtCreateCWorkItem.setNull(ix + 1, 12);
                                        continue;
                                    }
                                    pstmtCreateCWorkItem.setString(ix + 1, (String)value);
                                    continue;
                                }
                                if (key.equalsIgnoreCase("CWORKITEM_ID")) break block36;
                                if (key.equalsIgnoreCase("CSTEP_ID")) break block36;
                                if (key.equalsIgnoreCase("PARENT_WORKITEM_ID")) break block36;
                                if (key.equalsIgnoreCase("PROCESSINSTANCEID")) break block36;
                                if (key.equalsIgnoreCase("PROCESSTEMPLATEID")) break block36;
                                if (!key.equalsIgnoreCase("DURATION")) break block37;
                            }
                            if (value == null) {
                                throw new BizLogicException("BizLogic_ERR_1588", "CWIDAO.create", new Object[]{key, "COLLABORATIVE WORKITEM"});
                            }
                            pstmtCreateCWorkItem.setLong(ix + 1, (Long)value);
                            continue;
                        }
                        if (key.equalsIgnoreCase("ESCALATION_ID")) {
                            if (value == null) {
                                pstmtCreateCWorkItem.setNull(ix + 1, -5);
                                continue;
                            }
                            pstmtCreateCWorkItem.setLong(ix + 1, (Long)value);
                            continue;
                        }
                        if (key.equalsIgnoreCase("STARTTIME")) break block38;
                        if (!key.equalsIgnoreCase("DUEDATE")) break block39;
                    }
                    if (value == null) {
                        throw new BizLogicException("BizLogic_ERR_1588", "CWIDAO.create", new Object[]{key, "COLLABORATIVE WORKITEM"});
                    }
                    CWorkItemDAO.setDateValue((PreparedStatement)pstmtCreateCWorkItem, (int)(ix + 1), (long)((Long)value));
                    continue;
                }
                if (key.equalsIgnoreCase("LAST_MODIFIED_TIME")) {
                    pstmtCreateCWorkItem.setLong(ix + 1, System.currentTimeMillis());
                    continue;
                }
                if (key.equalsIgnoreCase("PROCESSINSTANCENAME")) continue;
                if (key.equalsIgnoreCase("WORKITEMNAME")) continue;
                if (key.equalsIgnoreCase("CSTEP_NAME")) continue;
                throw new BizLogicException("BizLogic_ERR_3627", "CWorkItemDAO", new Object[]{key});
            }
            pstmtCreateCWorkItem.executeUpdate();
        }
        catch (Throwable th) {
            CWorkItemDAO.handle((Throwable)th, (String)("CWIDAO.create(PKey: " + collwiid + ")"));
        }
        finally {
            BLDAOService.clean(null, (Statement)pstmtCreateCWorkItem, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createCStep(Map<String, Object> cStepData) {
        block8: {
            int ix;
            long parentWIID;
            long piid;
            long cStepID;
            PreparedStatement pstmtCreateCStepDS;
            PreparedStatement pstmtCreateCStep;
            Connection conn;
            block7: {
                conn = null;
                pstmtCreateCStep = null;
                pstmtCreateCStepDS = null;
                conn = CWorkItemDAO.getConnection();
                pstmtCreateCStep = conn.prepareStatement(createCStep);
                cStepID = (Long)cStepData.get("CSTEP_ID");
                long ptid = (Long)cStepData.get("PROCESSTEMPLATEID");
                piid = (Long)cStepData.get("PROCESSINSTANCEID");
                parentWIID = (Long)cStepData.get("PARENT_WORKITEM_ID");
                int dsAccess = (Integer)cStepData.get("DATASLOT_ACCESS");
                boolean collaborateByAll = (Boolean)cStepData.get("COLLABORATE_BY_ALL");
                String cStepName = (String)cStepData.get("CSTEP_NAME");
                ix = 1;
                pstmtCreateCStep.setLong(ix++, cStepID);
                pstmtCreateCStep.setLong(ix++, parentWIID);
                pstmtCreateCStep.setLong(ix++, piid);
                pstmtCreateCStep.setLong(ix++, ptid);
                pstmtCreateCStep.setInt(ix++, dsAccess);
                pstmtCreateCStep.setLong(ix++, -1L);
                pstmtCreateCStep.setInt(ix++, collaborateByAll ? 1 : 0);
                pstmtCreateCStep.setString(ix++, cStepName);
                pstmtCreateCStep.executeUpdate();
                if (dsAccess != -1) break block7;
                BLDAOService.clean(null, (Statement)pstmtCreateCStep, null);
                BLDAOService.clean(null, pstmtCreateCStepDS, (Connection)conn);
                return;
            }
            try {
                CWorkItemDAO.clean(null, (Statement)pstmtCreateCStep, null);
                pstmtCreateCStepDS = conn.prepareStatement(createCStepDS);
                HashMap dsMap = (HashMap)cStepData.get("DATASLOTNAMELIST");
                for (String dsName : dsMap.keySet()) {
                    int eachDSAccess = (Integer)dsMap.get(dsName);
                    ix = 1;
                    pstmtCreateCStepDS.setLong(ix++, cStepID);
                    pstmtCreateCStepDS.setLong(ix++, parentWIID);
                    pstmtCreateCStepDS.setLong(ix++, piid);
                    pstmtCreateCStepDS.setInt(ix++, eachDSAccess);
                    pstmtCreateCStepDS.setString(ix++, dsName);
                    pstmtCreateCStepDS.executeUpdate();
                }
            }
            catch (Throwable th) {
                try {
                    CWorkItemDAO.handle((Throwable)th, (String)"CWorkItemDAO.createCStep");
                    break block8;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    BLDAOService.clean(null, (Statement)pstmtCreateCStep, null);
                    BLDAOService.clean(null, pstmtCreateCStepDS, (Connection)conn);
                }
            }
            BLDAOService.clean(null, (Statement)pstmtCreateCStep, null);
            BLDAOService.clean(null, (Statement)pstmtCreateCStepDS, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAvailableCWorkItems(long piid, long parentWIID, long cWorkItemId, List<String> collaborators) {
        Connection conn = null;
        PreparedStatement pstmtCreate = null;
        try {
            conn = CWorkItemDAO.getConnection();
            pstmtCreate = conn.prepareStatement(createAvailCWI);
            String collaborator = null;
            for (int ix = 0; ix < collaborators.size(); ++ix) {
                collaborator = collaborators.get(ix);
                int index = 1;
                pstmtCreate.setLong(index++, cWorkItemId);
                pstmtCreate.setLong(index++, parentWIID);
                pstmtCreate.setLong(index++, piid);
                pstmtCreate.setString(index++, collaborator);
                pstmtCreate.executeUpdate();
            }
        }
        catch (Throwable th) {
            CWorkItemDAO.handle((Throwable)th, (String)"CWorkItemDAO.createAvailableCWorkItems");
        }
        finally {
            BLDAOService.clean(null, (Statement)pstmtCreate, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getCWorkItem(long cWorkItemId, boolean loadDataSlotNames) {
        Map<String, Object> loadedAttrs;
        ResultSet rs;
        PreparedStatement pstmtGetCWorkItem;
        Connection conn;
        block7: {
            conn = null;
            pstmtGetCWorkItem = null;
            rs = null;
            loadedAttrs = new HashMap<String, Object>();
            try {
                Map dsMap;
                conn = CWorkItemDAO.getConnection();
                pstmtGetCWorkItem = conn.prepareStatement(getCWorkItem);
                pstmtGetCWorkItem.setLong(1, cWorkItemId);
                rs = pstmtGetCWorkItem.executeQuery();
                if (!rs.next()) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = "Collaborative WorkItem";
                    objectArray[1] = new Long(cWorkItemId);
                    DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
                    objectArray[2] = "BIZLOGIC_CWORKITEM";
                    throw new BizLogicException("BizLogic_ERR_1548", "CWorkItemDAO.getCWorkItem", objectArray);
                }
                loadedAttrs = QSCWorkItemDAO.getAttributes((Connection)conn, (ResultSet)rs);
                CWorkItemDAO.clean((ResultSet)rs, (Statement)pstmtGetCWorkItem, null);
                if (loadDataSlotNames && !(dsMap = QSCWorkItemDAO.getDataSlots(loadedAttrs, (Connection)conn)).isEmpty()) {
                    loadedAttrs.put("DATASLOTNAMELIST", dsMap);
                }
                if (!BLControl.util.DEBUG_DAO) break block7;
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{getCWorkItem, "collwiid=" + cWorkItemId});
            }
            catch (Throwable th) {
                try {
                    CWorkItemDAO.handle((Throwable)th, (String)"CWorkItemDAO.getCWorkItem");
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    BLDAOService.clean(rs, (Statement)pstmtGetCWorkItem, (Connection)conn);
                }
            }
        }
        BLDAOService.clean((ResultSet)rs, (Statement)pstmtGetCWorkItem, (Connection)conn);
        return loadedAttrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getOutputDS(long cWorkItemId) {
        Connection conn = null;
        PreparedStatement pstmtGetOutputDS = null;
        ResultSet rs = null;
        ArrayList<String> outputDSNames = new ArrayList<String>();
        try {
            conn = CWorkItemDAO.getConnection();
            pstmtGetOutputDS = conn.prepareStatement(getOutputDS);
            pstmtGetOutputDS.setLong(1, cWorkItemId);
            pstmtGetOutputDS.setInt(2, 1);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{getOutputDS, "collwiid=" + cWorkItemId});
            }
            rs = pstmtGetOutputDS.executeQuery();
            while (rs.next()) {
                String dsName = rs.getString(1);
                outputDSNames.add(dsName);
            }
        }
        catch (Throwable th) {
            try {
                CWorkItemDAO.handle((Throwable)th, (String)"CWorkItemDAO.getOutputDS");
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                BLDAOService.clean(rs, (Statement)pstmtGetOutputDS, (Connection)conn);
            }
        }
        BLDAOService.clean((ResultSet)rs, (Statement)pstmtGetOutputDS, (Connection)conn);
        return outputDSNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getCStep(long cStepId, boolean loadDataSlotNames) {
        Map<String, Object> loadedAttrs;
        ResultSet rs;
        PreparedStatement pstmtGetCStep;
        Connection conn;
        block7: {
            conn = null;
            pstmtGetCStep = null;
            rs = null;
            loadedAttrs = new HashMap<String, Object>();
            try {
                Map dsMap;
                conn = CWorkItemDAO.getConnection();
                pstmtGetCStep = conn.prepareStatement(getCStep);
                pstmtGetCStep.setLong(1, cStepId);
                rs = pstmtGetCStep.executeQuery();
                if (!rs.next()) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = "Collaborative Step";
                    objectArray[1] = new Long(cStepId);
                    DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
                    objectArray[2] = "BIZLOGIC_CSTEP";
                    throw new BizLogicException("BizLogic_ERR_1548", "CWorkItemDAO.getCStep", objectArray);
                }
                loadedAttrs = CWorkItemDAO.getCStepAttributes(rs);
                CWorkItemDAO.clean((ResultSet)rs, (Statement)pstmtGetCStep, null);
                if (loadDataSlotNames && !(dsMap = QSCWorkItemDAO.getDataSlots(loadedAttrs, (Connection)conn)).isEmpty()) {
                    loadedAttrs.put("DATASLOTNAMELIST", dsMap);
                }
                if (!BLControl.util.DEBUG_DAO) break block7;
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{getCStep, "collstepid=" + cStepId});
            }
            catch (Throwable th) {
                try {
                    CWorkItemDAO.handle((Throwable)th, (String)"CWorkItemDAO.getCStep");
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    BLDAOService.clean(rs, (Statement)pstmtGetCStep, (Connection)conn);
                }
            }
        }
        BLDAOService.clean((ResultSet)rs, (Statement)pstmtGetCStep, (Connection)conn);
        return loadedAttrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getAvailableFor(long cWorkItemId) {
        Connection conn = null;
        PreparedStatement pstmtGetAvailableFor = null;
        ResultSet rs = null;
        ArrayList<String> availableForList = new ArrayList<String>();
        try {
            conn = CWorkItemDAO.getConnection();
            pstmtGetAvailableFor = conn.prepareStatement(getAvailableFor);
            pstmtGetAvailableFor.setLong(1, cWorkItemId);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{getAvailableFor, "collwiid=" + cWorkItemId});
            }
            rs = pstmtGetAvailableFor.executeQuery();
            while (rs.next()) {
                String availableFor = rs.getString(1);
                availableForList.add(availableFor);
            }
        }
        catch (Throwable th) {
            try {
                CWorkItemDAO.handle((Throwable)th, (String)"CWorkItemDAO.getAvailableFor");
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                BLDAOService.clean(rs, (Statement)pstmtGetAvailableFor, (Connection)conn);
            }
        }
        BLDAOService.clean((ResultSet)rs, (Statement)pstmtGetAvailableFor, (Connection)conn);
        return availableForList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAvailableFor(long cWorkItemId, String collaborator) {
        ResultSet rs;
        PreparedStatement pstmtIsAvailableFor;
        Connection conn;
        block6: {
            boolean bl;
            conn = null;
            pstmtIsAvailableFor = null;
            rs = null;
            try {
                conn = CWorkItemDAO.getConnection();
                pstmtIsAvailableFor = conn.prepareStatement(isAvailableFor);
                pstmtIsAvailableFor.setLong(1, cWorkItemId);
                pstmtIsAvailableFor.setString(2, collaborator);
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{isAvailableFor, "collwiid=" + cWorkItemId + " collab=" + collaborator});
                }
                if (!(rs = pstmtIsAvailableFor.executeQuery()).next()) break block6;
                bl = true;
            }
            catch (Throwable th) {
                try {
                    CWorkItemDAO.handle((Throwable)th, (String)"CWorkItemDAO.isAvailableFor");
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    BLDAOService.clean(rs, (Statement)pstmtIsAvailableFor, (Connection)conn);
                }
            }
            BLDAOService.clean((ResultSet)rs, (Statement)pstmtIsAvailableFor, (Connection)conn);
            return bl;
        }
        BLDAOService.clean((ResultSet)rs, (Statement)pstmtIsAvailableFor, (Connection)conn);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateState(long cWorkItemId, int previousState, int state) {
        Connection conn = null;
        PreparedStatement pstmtUpdateState = null;
        try {
            conn = CWorkItemDAO.getConnection();
            pstmtUpdateState = conn.prepareStatement(updateState);
            pstmtUpdateState.setInt(1, state);
            pstmtUpdateState.setInt(2, previousState);
            pstmtUpdateState.setLong(3, System.currentTimeMillis());
            pstmtUpdateState.setLong(4, cWorkItemId);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{updateState, "state=" + state + ", prev state=" + previousState + " and collwiid=" + cWorkItemId});
            }
            pstmtUpdateState.executeUpdate();
        }
        catch (Throwable th) {
            CWorkItemDAO.handle((Throwable)th, (String)"CWorkItemDAO.updateState");
        }
        finally {
            BLDAOService.clean(null, (Statement)pstmtUpdateState, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getState(long cWorkItemId) {
        int collWiState;
        ResultSet rs;
        PreparedStatement pstmtGetState;
        Connection conn;
        block6: {
            conn = null;
            pstmtGetState = null;
            rs = null;
            collWiState = -1;
            try {
                conn = CWorkItemDAO.getConnection();
                pstmtGetState = conn.prepareStatement(getState);
                pstmtGetState.setLong(1, cWorkItemId);
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{getState, "collwiid=" + cWorkItemId});
                }
                if (!(rs = pstmtGetState.executeQuery()).next()) break block6;
                collWiState = rs.getInt("STATUS");
            }
            catch (Throwable th) {
                try {
                    CWorkItemDAO.handle((Throwable)th, (String)"CWorkItemDAO.getState");
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    BLDAOService.clean(rs, (Statement)pstmtGetState, (Connection)conn);
                }
            }
        }
        BLDAOService.clean((ResultSet)rs, (Statement)pstmtGetState, (Connection)conn);
        return collWiState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCreator(long parentWIID, String creator) {
        Connection conn = null;
        PreparedStatement pstmtUpdateCreator = null;
        try {
            conn = CWorkItemDAO.getConnection();
            pstmtUpdateCreator = conn.prepareStatement(updateCreator);
            pstmtUpdateCreator.setString(1, creator);
            pstmtUpdateCreator.setLong(2, System.currentTimeMillis());
            pstmtUpdateCreator.setLong(3, parentWIID);
            pstmtUpdateCreator.executeUpdate();
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{updateCreator, "creator=" + creator + " and parent wiid=" + parentWIID});
            }
        }
        catch (Throwable th) {
            CWorkItemDAO.handle((Throwable)th, (String)"CWorkItemDAO.updateCreator");
        }
        finally {
            BLDAOService.clean(null, (Statement)pstmtUpdateCreator, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(long cWorkItemId, Map<String, Object> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        Set<String> keysForUpdate = attributes.keySet();
        String[] arrayOfKeysToUpdate = keysForUpdate.toArray(new String[]{""});
        DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
        String updateSQLBeforeWhere = CWorkItemDAO.composeUpdateStatement((String)"BIZLOGIC_CWORKITEM", (String[])arrayOfKeysToUpdate, (String[])new String[0]);
        String previousStatusSQL = "";
        if (attributes.containsKey("STATUS")) {
            Object[] objectArray = new Object[2];
            objectArray[0] = "PREVIOUSSTATUS";
            objectArray[1] = "STATUS";
            previousStatusSQL = CWorkItemDAO.composeSQL((String)", %s = %s", (Object[])objectArray);
        }
        Object[] objectArray = new Object[5];
        objectArray[0] = updateSQLBeforeWhere;
        objectArray[1] = previousStatusSQL;
        objectArray[2] = "LAST_MODIFIED_TIME";
        DBConstants.KeywordConstants cfr_ignored_1 = BLControl.dbconsts.kwd;
        objectArray[3] = " WHERE ";
        objectArray[4] = "CWORKITEM_ID";
        String updateSQL = CWorkItemDAO.composeSQL((String)"%s %s, %s = ? %s %s = ?", (Object[])objectArray);
        Connection conn = null;
        PreparedStatement pstmtSetAttrs = null;
        try {
            int ix;
            conn = CWorkItemDAO.getConnection();
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{updateSQL, "collwiid=" + cWorkItemId});
            }
            pstmtSetAttrs = conn.prepareStatement(updateSQL);
            for (ix = 0; ix < arrayOfKeysToUpdate.length; ++ix) {
                String key = arrayOfKeysToUpdate[ix];
                Object value = attributes.get(key);
                pstmtSetAttrs.setObject(ix + 1, value);
            }
            pstmtSetAttrs.setLong(++ix, System.currentTimeMillis());
            pstmtSetAttrs.setLong(++ix, cWorkItemId);
            pstmtSetAttrs.executeUpdate();
        }
        catch (Throwable th) {
            try {
                CWorkItemDAO.handle((Throwable)th, (String)"CWorkItemDAO.save");
            }
            catch (Throwable throwable) {
                BLDAOService.clean(null, pstmtSetAttrs, (Connection)conn);
                throw throwable;
            }
            BLDAOService.clean(null, (Statement)pstmtSetAttrs, (Connection)conn);
        }
        BLDAOService.clean(null, (Statement)pstmtSetAttrs, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCWorkItemExist(long workitemId, long cWorkItemId) {
        boolean wiexist;
        ResultSet rset;
        PreparedStatement pstmtIsCWorkItemExist;
        Connection conn;
        block6: {
            conn = null;
            pstmtIsCWorkItemExist = null;
            rset = null;
            wiexist = false;
            try {
                conn = CWorkItemDAO.getConnection();
                pstmtIsCWorkItemExist = conn.prepareStatement(findByPrimaryKeyAndParentWI);
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1185", findByPrimaryKeyAndParentWI, new Object[0]);
                }
                pstmtIsCWorkItemExist.setLong(1, workitemId);
                pstmtIsCWorkItemExist.setLong(2, cWorkItemId);
                rset = pstmtIsCWorkItemExist.executeQuery();
                if (!rset.next()) break block6;
                wiexist = true;
            }
            catch (Throwable th) {
                try {
                    CWorkItemDAO.handle((Throwable)th, (String)"CWorkItemDAO.isCWorkItemExist");
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    BLDAOService.clean(rset, (Statement)pstmtIsCWorkItemExist, (Connection)conn);
                }
            }
        }
        BLDAOService.clean((ResultSet)rset, (Statement)pstmtIsCWorkItemExist, (Connection)conn);
        return wiexist;
    }

    public static List<Long> findByParentWI(long parentWIID) {
        return CWorkItemDAO.findByParentWI(parentWIID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> findByParentWI(long parentWIID, int[] states) {
        Connection conn = null;
        PreparedStatement pstmtFindByWI = null;
        ResultSet rset = null;
        ArrayList<Long> cWorkItemIdList = new ArrayList<Long>();
        try {
            conn = CWorkItemDAO.getConnection();
            StringBuilder sb = new StringBuilder(findByParentWI);
            if (states != null && states.length != 0) {
                String comma = "";
                sb.append(" AND ").append("STATUS").append(" IN (");
                for (int state : states) {
                    sb.append(comma);
                    sb.append("?");
                    comma = ", ";
                }
                sb.append(")");
            }
            String sql = sb.toString();
            pstmtFindByWI = conn.prepareStatement(sql);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", sql, new Object[0]);
            }
            pstmtFindByWI.setLong(1, parentWIID);
            int currIndex = 1;
            if (states != null && states.length != 0) {
                for (int state : states) {
                    pstmtFindByWI.setInt(++currIndex, state);
                }
            }
            rset = pstmtFindByWI.executeQuery();
            while (rset.next()) {
                long cWorkItemId = rset.getLong(1);
                cWorkItemIdList.add(new Long(cWorkItemId));
            }
        }
        catch (Throwable th) {
            try {
                CWorkItemDAO.handle((Throwable)th, (String)"CWorkItemDAO.findByParentWI");
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                BLDAOService.clean(rset, pstmtFindByWI, (Connection)conn);
            }
        }
        BLDAOService.clean((ResultSet)rset, (Statement)pstmtFindByWI, (Connection)conn);
        return cWorkItemIdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeByParentWI(long parentWIID) {
        Connection conn = null;
        PreparedStatement pstmtRemoveCWIByWI = null;
        PreparedStatement pstmtRemoveAvailCWIByWI = null;
        PreparedStatement pstmtRemoveCStepByWI = null;
        PreparedStatement pstmtRemoveCStepDSByWI = null;
        try {
            conn = CWorkItemDAO.getConnection();
            pstmtRemoveCWIByWI = conn.prepareStatement(removeCWorkItemByParentWI);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", removeCWorkItemByParentWI, new Object[0]);
            }
            pstmtRemoveCWIByWI.setLong(1, parentWIID);
            pstmtRemoveCWIByWI.executeUpdate();
            CWorkItemDAO.clean(null, (Statement)pstmtRemoveCWIByWI, null);
            pstmtRemoveAvailCWIByWI = conn.prepareStatement(removeAvailCWorkItemByParentWI);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", removeAvailCWorkItemByParentWI, new Object[0]);
            }
            pstmtRemoveAvailCWIByWI.setLong(1, parentWIID);
            pstmtRemoveAvailCWIByWI.executeUpdate();
            CWorkItemDAO.clean(null, (Statement)pstmtRemoveAvailCWIByWI, null);
            pstmtRemoveCStepDSByWI = conn.prepareStatement(removeCStepDSByParentWI);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", removeCStepDSByParentWI, new Object[0]);
            }
            pstmtRemoveCStepDSByWI.setLong(1, parentWIID);
            pstmtRemoveCStepDSByWI.executeUpdate();
            CWorkItemDAO.clean(null, (Statement)pstmtRemoveCStepDSByWI, null);
            pstmtRemoveCStepByWI = conn.prepareStatement(removeCStepByParentWI);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", removeCStepByParentWI, new Object[0]);
            }
            pstmtRemoveCStepByWI.setLong(1, parentWIID);
            pstmtRemoveCStepByWI.executeUpdate();
        }
        catch (Throwable th) {
            try {
                CWorkItemDAO.handle((Throwable)th, (String)"CWorkItemDAO.removeByParentWI");
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                BLDAOService.clean(null, (Statement)pstmtRemoveCWIByWI, null);
                BLDAOService.clean(null, pstmtRemoveAvailCWIByWI, null);
                BLDAOService.clean(null, pstmtRemoveCStepDSByWI, null);
                BLDAOService.clean(null, pstmtRemoveCStepByWI, (Connection)conn);
            }
        }
        BLDAOService.clean(null, (Statement)pstmtRemoveCWIByWI, null);
        BLDAOService.clean(null, (Statement)pstmtRemoveAvailCWIByWI, null);
        BLDAOService.clean(null, (Statement)pstmtRemoveCStepDSByWI, null);
        BLDAOService.clean(null, (Statement)pstmtRemoveCStepByWI, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeByParentPI(long parentPIID) {
        Connection conn = null;
        PreparedStatement pstmtRemoveCWIByPI = null;
        PreparedStatement pstmtRemoveAvailCWIByPI = null;
        PreparedStatement pstmtRemoveCStepDSByPI = null;
        PreparedStatement pstmtRemoveCStepByPI = null;
        try {
            conn = CWorkItemDAO.getConnection();
            pstmtRemoveCWIByPI = conn.prepareStatement(removeCWorkItemByParentPI);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", removeCWorkItemByParentPI, new Object[0]);
            }
            pstmtRemoveCWIByPI.setLong(1, parentPIID);
            pstmtRemoveCWIByPI.executeUpdate();
            CWorkItemDAO.clean(null, (Statement)pstmtRemoveCWIByPI, null);
            pstmtRemoveAvailCWIByPI = conn.prepareStatement(removeAvailCWorkItemByParentPI);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", removeAvailCWorkItemByParentPI, new Object[0]);
            }
            pstmtRemoveAvailCWIByPI.setLong(1, parentPIID);
            pstmtRemoveAvailCWIByPI.executeUpdate();
            CWorkItemDAO.clean(null, (Statement)pstmtRemoveAvailCWIByPI, null);
            pstmtRemoveCStepDSByPI = conn.prepareStatement(removeCStepDSByParentPI);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", removeCStepDSByParentPI, new Object[0]);
            }
            pstmtRemoveCStepDSByPI.setLong(1, parentPIID);
            pstmtRemoveCStepDSByPI.executeUpdate();
            CWorkItemDAO.clean(null, (Statement)pstmtRemoveCStepDSByPI, null);
            pstmtRemoveCStepByPI = conn.prepareStatement(removeCStepByParentPI);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", removeCStepByParentPI, new Object[0]);
            }
            pstmtRemoveCStepByPI.setLong(1, parentPIID);
            pstmtRemoveCStepByPI.executeUpdate();
        }
        catch (Throwable th) {
            try {
                CWorkItemDAO.handle((Throwable)th, (String)"CWorkItemDAO.removeByParentPI");
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                BLDAOService.clean(null, (Statement)pstmtRemoveCWIByPI, null);
                BLDAOService.clean(null, pstmtRemoveAvailCWIByPI, null);
                BLDAOService.clean(null, pstmtRemoveCStepDSByPI, null);
                BLDAOService.clean(null, pstmtRemoveCStepByPI, (Connection)conn);
            }
        }
        BLDAOService.clean(null, (Statement)pstmtRemoveCWIByPI, null);
        BLDAOService.clean(null, (Statement)pstmtRemoveAvailCWIByPI, null);
        BLDAOService.clean(null, (Statement)pstmtRemoveCStepDSByPI, null);
        BLDAOService.clean(null, (Statement)pstmtRemoveCStepByPI, (Connection)conn);
    }

    private static Map<String, Object> getCStepAttributes(ResultSet rs) throws SQLException {
        HashMap<String, Object> loadedAttrs = new HashMap<String, Object>();
        BLConstants.single();
        String fieldName = "CSTEP_ID";
        long longField = rs.getLong(fieldName);
        BLConstants.single();
        loadedAttrs.put("CSTEP_ID", longField);
        BLConstants.single();
        fieldName = "PARENT_WORKITEM_ID";
        longField = rs.getLong(fieldName);
        BLConstants.single();
        loadedAttrs.put("PARENT_WORKITEM_ID", longField);
        DBConstants.ColConstants cfr_ignored_0 = DBConstants.single().col;
        fieldName = "PROCESS_INSTANCE_ID";
        longField = rs.getLong(fieldName);
        BLConstants.single();
        loadedAttrs.put("PROCESSINSTANCEID", longField);
        DBConstants.ColConstants cfr_ignored_1 = DBConstants.single().col;
        fieldName = "PROCESS_TEMPLATE_ID";
        long ptid = rs.getLong(fieldName);
        BLConstants.single();
        loadedAttrs.put("PROCESSTEMPLATEID", ptid);
        BLConstants.single();
        fieldName = "CSTEP_NAME";
        String stringField = rs.getString(fieldName);
        BLConstants.single();
        loadedAttrs.put("CSTEP_NAME", stringField);
        BLConstants.single();
        fieldName = "DATASLOT_ACCESS";
        int intField = rs.getInt(fieldName);
        BLConstants.single();
        loadedAttrs.put("DATASLOT_ACCESS", intField);
        BLConstants.single();
        fieldName = "ACTIVATE_AFTER";
        longField = rs.getLong(fieldName);
        BLConstants.single();
        loadedAttrs.put("ACTIVATE_AFTER", longField);
        return loadedAttrs;
    }

    public static synchronized void initSQLStatements() {
        DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
        createCWorkItem = CWorkItemDAO.composeInsertStatement((String)"BIZLOGIC_CWORKITEM", (String[])CREATE_TABLELIST);
        DBConstants.TableConstants cfr_ignored_1 = BLControl.dbconsts.tab;
        createAvailCWI = CWorkItemDAO.composeInsertStatement((String)"BIZLOGIC_AVAILABLE_CWORKITEM", (String[])CREATE_AVAILABLE_CWI_TABLELIST);
        DBConstants.TableConstants cfr_ignored_2 = BLControl.dbconsts.tab;
        createCStep = CWorkItemDAO.composeInsertStatement((String)"BIZLOGIC_CSTEP", (String[])CREATE_CSTEP_TABLELIST);
        DBConstants.TableConstants cfr_ignored_3 = BLControl.dbconsts.tab;
        createCStepDS = CWorkItemDAO.composeInsertStatement((String)"BIZLOGIC_CSTEP_DS", (String[])CREATE_CSTEP_DS_TABLELIST);
        Object[] objectArray = new Object[6];
        objectArray[0] = QSCWorkItemDAO.selectForCWIList;
        objectArray[1] = QSCWorkItemDAO.fromForCWIList;
        DBConstants.KeywordConstants cfr_ignored_4 = BLControl.dbconsts.kwd;
        objectArray[2] = " WHERE ";
        DBConstants.TableAliasConstants cfr_ignored_5 = BLControl.dbconsts.tabalias;
        objectArray[3] = "BLCWI";
        objectArray[4] = "CWORKITEM_ID";
        objectArray[5] = QSCWorkItemDAO.joinConditionForCWIList;
        getCWorkItem = CWorkItemDAO.composeSQL((String)"%s %s %s %s.%s = ? %s", (Object[])objectArray);
        Object[] objectArray2 = new Object[10];
        DBConstants.KeywordConstants cfr_ignored_6 = BLControl.dbconsts.kwd;
        objectArray2[0] = " SELECT ";
        DBConstants.ColConstants cfr_ignored_7 = BLControl.dbconsts.col;
        objectArray2[1] = "DATASLOT_NAME";
        String[] stringArray = new String[2];
        DBConstants.TableConstants cfr_ignored_8 = BLControl.dbconsts.tab;
        stringArray[0] = "BIZLOGIC_CSTEP_DS";
        DBConstants.TableConstants cfr_ignored_9 = BLControl.dbconsts.tab;
        stringArray[1] = "BIZLOGIC_CWORKITEM";
        String[] stringArray2 = new String[2];
        DBConstants.TableAliasConstants cfr_ignored_10 = BLControl.dbconsts.tabalias;
        stringArray2[0] = "BLCDS";
        DBConstants.TableAliasConstants cfr_ignored_11 = BLControl.dbconsts.tabalias;
        stringArray2[1] = "BLCWI";
        objectArray2[2] = CWorkItemDAO.composeFromStatement((String[])stringArray, (String[])stringArray2);
        DBConstants.KeywordConstants cfr_ignored_12 = BLControl.dbconsts.kwd;
        objectArray2[3] = " WHERE ";
        objectArray2[4] = "CWORKITEM_ID";
        DBConstants.TableAliasConstants cfr_ignored_13 = BLControl.dbconsts.tabalias;
        objectArray2[5] = "BLCWI";
        objectArray2[6] = "CSTEP_ID";
        DBConstants.TableAliasConstants cfr_ignored_14 = BLControl.dbconsts.tabalias;
        objectArray2[7] = "BLCDS";
        objectArray2[8] = "CSTEP_ID";
        objectArray2[9] = "DATASLOT_ACCESS";
        getOutputDS = CWorkItemDAO.composeSQL((String)"%s %s %s %s %s = ? AND %s.%s = %s.%s AND %s = ?", (Object[])objectArray2);
        DBConstants.TableConstants cfr_ignored_15 = BLControl.dbconsts.tab;
        getCStep = CWorkItemDAO.composeSelectStatement((String[])CREATE_CSTEP_TABLELIST, (String)"BIZLOGIC_CSTEP", (String)"CSTEP_ID");
        String[] stringArray3 = new String[1];
        stringArray3[0] = "AVAILABLEFOR";
        DBConstants.TableConstants cfr_ignored_16 = BLControl.dbconsts.tab;
        getAvailableFor = CWorkItemDAO.composeSelectStatement((String[])stringArray3, (String)"BIZLOGIC_AVAILABLE_CWORKITEM", (String)"CWORKITEM_ID");
        String[] stringArray4 = new String[1];
        stringArray4[0] = "CWORKITEM_ID";
        DBConstants.TableConstants cfr_ignored_17 = BLControl.dbconsts.tab;
        String[] stringArray5 = new String[2];
        stringArray5[0] = "CWORKITEM_ID";
        stringArray5[1] = "AVAILABLEFOR";
        isAvailableFor = CWorkItemDAO.composeSelectStatement((String[])stringArray4, (String)"BIZLOGIC_AVAILABLE_CWORKITEM", (String[])stringArray5);
        String[] stringArray6 = new String[1];
        stringArray6[0] = "CWORKITEM_ID";
        DBConstants.TableConstants cfr_ignored_18 = BLControl.dbconsts.tab;
        String[] stringArray7 = new String[2];
        stringArray7[0] = "PARENT_WORKITEM_ID";
        stringArray7[1] = "CWORKITEM_ID";
        findByPrimaryKeyAndParentWI = CWorkItemDAO.composeSelectStatement((String[])stringArray6, (String)"BIZLOGIC_CWORKITEM", (String[])stringArray7);
        String[] stringArray8 = new String[1];
        stringArray8[0] = "CWORKITEM_ID";
        DBConstants.TableConstants cfr_ignored_19 = BLControl.dbconsts.tab;
        findByParentWI = CWorkItemDAO.composeSelectStatement((String[])stringArray8, (String)"BIZLOGIC_CWORKITEM", (String)"PARENT_WORKITEM_ID");
        DBConstants.TableConstants cfr_ignored_20 = BLControl.dbconsts.tab;
        String[] stringArray9 = new String[1];
        stringArray9[0] = "PARENT_WORKITEM_ID";
        removeCWorkItemByParentWI = CWorkItemDAO.composeRemoveStatement((String)"BIZLOGIC_CWORKITEM", (String[])stringArray9);
        DBConstants.TableConstants cfr_ignored_21 = BLControl.dbconsts.tab;
        String[] stringArray10 = new String[1];
        stringArray10[0] = "PARENT_WORKITEM_ID";
        removeAvailCWorkItemByParentWI = CWorkItemDAO.composeRemoveStatement((String)"BIZLOGIC_AVAILABLE_CWORKITEM", (String[])stringArray10);
        DBConstants.TableConstants cfr_ignored_22 = BLControl.dbconsts.tab;
        String[] stringArray11 = new String[1];
        stringArray11[0] = "PARENT_WORKITEM_ID";
        removeCStepByParentWI = CWorkItemDAO.composeRemoveStatement((String)"BIZLOGIC_CSTEP", (String[])stringArray11);
        DBConstants.TableConstants cfr_ignored_23 = BLControl.dbconsts.tab;
        String[] stringArray12 = new String[1];
        stringArray12[0] = "PARENT_WORKITEM_ID";
        removeCStepDSByParentWI = CWorkItemDAO.composeRemoveStatement((String)"BIZLOGIC_CSTEP_DS", (String[])stringArray12);
        DBConstants.TableConstants cfr_ignored_24 = BLControl.dbconsts.tab;
        String[] stringArray13 = new String[1];
        DBConstants.ColConstants cfr_ignored_25 = BLControl.dbconsts.col;
        stringArray13[0] = "PROCESS_INSTANCE_ID";
        removeCWorkItemByParentPI = CWorkItemDAO.composeRemoveStatement((String)"BIZLOGIC_CWORKITEM", (String[])stringArray13);
        DBConstants.TableConstants cfr_ignored_26 = BLControl.dbconsts.tab;
        String[] stringArray14 = new String[1];
        DBConstants.ColConstants cfr_ignored_27 = BLControl.dbconsts.col;
        stringArray14[0] = "PROCESS_INSTANCE_ID";
        removeAvailCWorkItemByParentPI = CWorkItemDAO.composeRemoveStatement((String)"BIZLOGIC_AVAILABLE_CWORKITEM", (String[])stringArray14);
        DBConstants.TableConstants cfr_ignored_28 = BLControl.dbconsts.tab;
        String[] stringArray15 = new String[1];
        DBConstants.ColConstants cfr_ignored_29 = BLControl.dbconsts.col;
        stringArray15[0] = "PROCESS_INSTANCE_ID";
        removeCStepByParentPI = CWorkItemDAO.composeRemoveStatement((String)"BIZLOGIC_CSTEP", (String[])stringArray15);
        DBConstants.TableConstants cfr_ignored_30 = BLControl.dbconsts.tab;
        String[] stringArray16 = new String[1];
        DBConstants.ColConstants cfr_ignored_31 = BLControl.dbconsts.col;
        stringArray16[0] = "PROCESS_INSTANCE_ID";
        removeCStepDSByParentPI = CWorkItemDAO.composeRemoveStatement((String)"BIZLOGIC_CSTEP_DS", (String[])stringArray16);
        DBConstants.TableConstants cfr_ignored_32 = BLControl.dbconsts.tab;
        String[] stringArray17 = new String[3];
        stringArray17[0] = "STATUS";
        stringArray17[1] = "PREVIOUSSTATUS";
        stringArray17[2] = "LAST_MODIFIED_TIME";
        String[] stringArray18 = new String[1];
        stringArray18[0] = "CWORKITEM_ID";
        updateState = CWorkItemDAO.composeUpdateStatement((String)"BIZLOGIC_CWORKITEM", (String[])stringArray17, (String[])stringArray18);
        String[] stringArray19 = new String[1];
        stringArray19[0] = "STATUS";
        DBConstants.TableConstants cfr_ignored_33 = BLControl.dbconsts.tab;
        getState = CWorkItemDAO.composeSelectStatement((String[])stringArray19, (String)"BIZLOGIC_CWORKITEM", (String)"CWORKITEM_ID");
        DBConstants.TableConstants cfr_ignored_34 = BLControl.dbconsts.tab;
        String[] stringArray20 = new String[2];
        stringArray20[0] = "CREATOR";
        stringArray20[1] = "LAST_MODIFIED_TIME";
        String[] stringArray21 = new String[1];
        stringArray21[0] = "PARENT_WORKITEM_ID";
        updateCreator = CWorkItemDAO.composeUpdateStatement((String)"BIZLOGIC_CWORKITEM", (String[])stringArray20, (String[])stringArray21);
        CWorkItemDAO.printSQLStatements();
    }

    private static void printSQLStatements() {
        if (BLControl.util.DEBUG_DAO) {
            BLControl.logger.debug((Object)"CWorkItemDAO:");
            BLControl.logger.debugKey("BizLogic_ERR_1199", createCWorkItem, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", createAvailCWI, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", createCStep, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", createCStepDS, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", findByPrimaryKeyAndParentWI, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", findByParentWI, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeCWorkItemByParentWI, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeAvailCWorkItemByParentWI, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeCStepByParentWI, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeCStepDSByParentWI, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeCWorkItemByParentPI, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeAvailCWorkItemByParentPI, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeCStepByParentPI, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeCStepDSByParentPI, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getCWorkItem, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getOutputDS, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getAvailableFor, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getState, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", updateState, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", updateCreator, new Object[0]);
        }
    }

    static {
        String[] stringArray = new String[19];
        stringArray[0] = "CWORKITEM_ID";
        stringArray[1] = "CSTEP_ID";
        stringArray[2] = "PARENT_WORKITEM_ID";
        stringArray[3] = "PROCESSINSTANCEID";
        stringArray[4] = "PROCESSTEMPLATEID";
        stringArray[5] = "PRIORITY";
        stringArray[6] = "STARTTIME";
        stringArray[7] = "DURATION";
        stringArray[8] = "DUEDATE";
        stringArray[9] = "STATUS";
        stringArray[10] = "PREVIOUSSTATUS";
        stringArray[11] = "ESCALATION_TYPE";
        stringArray[12] = "ESCALATION_ID";
        stringArray[13] = "LAST_MODIFIED_TIME";
        stringArray[14] = "CWORKITEM_NAME";
        stringArray[15] = "COLLABORATOR";
        stringArray[16] = "CREATOR";
        stringArray[17] = "INSTRUCTION";
        stringArray[18] = "RESPONSE";
        CREATE_LIST = stringArray;
        String[] stringArray2 = new String[19];
        stringArray2[0] = "CWORKITEM_ID";
        stringArray2[1] = "CSTEP_ID";
        stringArray2[2] = "PARENT_WORKITEM_ID";
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        stringArray2[3] = "PROCESS_INSTANCE_ID";
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        stringArray2[4] = "PROCESS_TEMPLATE_ID";
        stringArray2[5] = "PRIORITY";
        stringArray2[6] = "STARTTIME";
        stringArray2[7] = "DURATION";
        stringArray2[8] = "DUEDATE";
        stringArray2[9] = "STATUS";
        stringArray2[10] = "PREVIOUSSTATUS";
        stringArray2[11] = "ESCALATION_TYPE";
        stringArray2[12] = "ESCALATION_ID";
        stringArray2[13] = "LAST_MODIFIED_TIME";
        stringArray2[14] = "CWORKITEM_NAME";
        stringArray2[15] = "COLLABORATOR";
        stringArray2[16] = "CREATOR";
        stringArray2[17] = "INSTRUCTION";
        stringArray2[18] = "RESPONSE";
        CREATE_TABLELIST = stringArray2;
        String[] stringArray3 = new String[8];
        stringArray3[0] = "CSTEP_ID";
        stringArray3[1] = "PARENT_WORKITEM_ID";
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        stringArray3[2] = "PROCESS_INSTANCE_ID";
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        stringArray3[3] = "PROCESS_TEMPLATE_ID";
        stringArray3[4] = "DATASLOT_ACCESS";
        stringArray3[5] = "ACTIVATE_AFTER";
        stringArray3[6] = "COLLABORATE_BY_ALL";
        stringArray3[7] = "CSTEP_NAME";
        CREATE_CSTEP_TABLELIST = stringArray3;
        String[] stringArray4 = new String[5];
        stringArray4[0] = "CSTEP_ID";
        stringArray4[1] = "PARENT_WORKITEM_ID";
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        stringArray4[2] = "PROCESS_INSTANCE_ID";
        stringArray4[3] = "DATASLOT_ACCESS";
        DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
        stringArray4[4] = "DATASLOT_NAME";
        CREATE_CSTEP_DS_TABLELIST = stringArray4;
        String[] stringArray5 = new String[4];
        stringArray5[0] = "CWORKITEM_ID";
        stringArray5[1] = "PARENT_WORKITEM_ID";
        DBConstants.ColConstants cfr_ignored_6 = BLControl.dbconsts.col;
        stringArray5[2] = "PROCESS_INSTANCE_ID";
        stringArray5[3] = "AVAILABLEFOR";
        CREATE_AVAILABLE_CWI_TABLELIST = stringArray5;
    }
}

