/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.dao;

import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.DBConstants;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Map;

public class MilestoneDAO
extends BLDAOService {
    private static final String[] CREATE_COLUMNS;
    static String insertMilestone;
    static String removeMilestone;

    public static synchronized void initSQLStatements() {
        StringBuilder sb = new StringBuilder();
        int ix = 0;
        sb.append("INSERT INTO ");
        DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_MILESTONE");
        sb.append(" (");
        for (ix = 0; ix < CREATE_COLUMNS.length; ++ix) {
            sb.append(CREATE_COLUMNS[ix]);
            if (ix == CREATE_COLUMNS.length - 1) continue;
            sb.append(", ");
        }
        sb.append(") VALUES (");
        for (ix = 0; ix < CREATE_COLUMNS.length; ++ix) {
            sb.append("?");
            if (ix == CREATE_COLUMNS.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        insertMilestone = sb.toString();
        sb = new StringBuilder();
        sb.append("DELETE FROM ");
        DBConstants.TableConstants cfr_ignored_1 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_MILESTONE");
        sb.append(" WHERE ");
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        sb.append("PROCESS_TEMPLATE_ID").append(" = ?");
        removeMilestone = sb.toString();
        MilestoneDAO.printSQLStatements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createMilestone(WFProcess pt) {
        Connection conn = null;
        PreparedStatement pstmtInsertMilestone = null;
        ResultSet rs = null;
        try {
            conn = MilestoneDAO.getConnection();
            Hashtable milestones = (Hashtable)pt.getMilestoneList();
            for (Map.Entry milestone : milestones.entrySet()) {
                pstmtInsertMilestone = conn.prepareStatement(insertMilestone);
                pstmtInsertMilestone.setLong(1, pt.getID());
                pstmtInsertMilestone.setString(2, pt.getName());
                pstmtInsertMilestone.setString(3, (String)milestone.getKey());
                pstmtInsertMilestone.setString(4, (String)milestone.getValue());
                pstmtInsertMilestone.executeUpdate();
            }
        }
        catch (SQLException sqlerr) {
            MilestoneDAO.handle((Throwable)sqlerr, (String)("MilestoneDAO.createProcessMilestone(PKey: " + pt.getID() + ")"));
        }
        finally {
            MilestoneDAO.clean(rs, pstmtInsertMilestone, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMilestone(long ptid) {
        Connection conn = null;
        PreparedStatement pstmtRemoveMilestone = null;
        try {
            conn = MilestoneDAO.getConnection();
            pstmtRemoveMilestone = conn.prepareStatement(removeMilestone);
            pstmtRemoveMilestone.setLong(1, ptid);
            pstmtRemoveMilestone.executeUpdate();
        }
        catch (SQLException sqlerr) {
            MilestoneDAO.handle((Throwable)sqlerr, (String)("MilestoneDAO.removeProcessMilestone(PKey: " + ptid + ")"));
        }
        finally {
            MilestoneDAO.clean(null, (Statement)pstmtRemoveMilestone, (Connection)conn);
        }
    }

    private static void printSQLStatements() {
        if (BLControl.util.DEBUG_DAO) {
            BLControl.logger.debugKey("BizLogic_ERR_1199", insertMilestone, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeMilestone, new Object[0]);
        }
    }

    static {
        String[] stringArray = new String[4];
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        stringArray[0] = "PROCESS_TEMPLATE_ID";
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        stringArray[1] = "PROCESS_TEMPLATE_NAME";
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        stringArray[2] = "MILESTONE_NAME";
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        stringArray[3] = "MILESTONE_DESC";
        CREATE_COLUMNS = stringArray;
    }
}

