/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.dao;

import com.savvion.sbm.bizlogic.client.queryservice.QSProcessNotesDAO;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.DBConstants;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class ProcessNotesDAO
extends BLDAOService {
    private static final String[] CREATE_TABLELIST;
    private static final String[] CREATE_LIST;
    private static boolean initialized;
    private static String createProcessNotes;
    public static String getProcessNotes;
    public static String updateProcessNotes;
    public static String removeProcessNotes;
    public static String getReferenceCount;
    public static String removeByProcessTemplate;
    public static String removeByProcessInstance;
    private static final int CREATE_NOTES_SQL = 1;
    private static final int GET_NOTES_SQL = 2;
    private static final int UPDATE_NOTES_SQL = 3;
    private static final int REMOVE_NOTES_SQL = 4;
    private static final int REFERENCE_COUNT_SQL = 5;
    private static final int REMOVE_NOTES_BY_PTID_SQL = 6;
    private static final int REMOVE_NOTES_BY_PIID_SQL = 7;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long create(long piid, String notes, Map<String, Object> attrsList) {
        String key = null;
        Object value = null;
        Connection conn = null;
        PreparedStatement pstmtCreateProcessNotes = null;
        long notesID = -1L;
        try {
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{createProcessNotes, "piid=" + piid + ", notes=" + notes + ", notesAttributes=" + attrsList});
            }
            notesID = BLControl.util.pnotesSeq.getNextNumber();
            conn = ProcessNotesDAO.getConnection();
            pstmtCreateProcessNotes = ProcessNotesDAO.prepareStatement(conn, 1);
            for (int ix = 0; ix < CREATE_LIST.length; ++ix) {
                block32: {
                    block31: {
                        block30: {
                            block29: {
                                block28: {
                                    block27: {
                                        key = CREATE_LIST[ix];
                                        value = attrsList.get(key);
                                        if (key.equalsIgnoreCase("NOTES_TYPE")) break block27;
                                        if (!key.equalsIgnoreCase("NOTES_CONTEXT")) break block28;
                                    }
                                    if (value == null) {
                                        throw new BizLogicException("BizLogic_ERR_1588", "ProcessNotesDAO.create", new Object[]{key, "PROCESS NOTES"});
                                    }
                                    pstmtCreateProcessNotes.setInt(ix + 1, (Integer)value);
                                    continue;
                                }
                                if (key.equalsIgnoreCase("LOOPCOUNTER")) {
                                    if (value == null) {
                                        pstmtCreateProcessNotes.setInt(ix + 1, -1);
                                        continue;
                                    }
                                    pstmtCreateProcessNotes.setInt(ix + 1, (Integer)value);
                                    continue;
                                }
                                if (key.equalsIgnoreCase("NOTES_USER")) {
                                    if (value == null) {
                                        throw new BizLogicException("BizLogic_ERR_1588", "ProcessNotesDAO.create", new Object[]{key, "PROCESS NOTES"});
                                    }
                                    pstmtCreateProcessNotes.setString(ix + 1, (String)value);
                                    continue;
                                }
                                if (key.equalsIgnoreCase("NOTES")) {
                                    pstmtCreateProcessNotes.setString(ix + 1, notes);
                                    continue;
                                }
                                if (key.equalsIgnoreCase("THREAD_NAME")) break block29;
                                if (key.equalsIgnoreCase("WORKSTEPNAME")) break block29;
                                if (key.equalsIgnoreCase("WORKITEMNAME")) break block29;
                                if (!key.equalsIgnoreCase("CWORKITEM_NAME")) break block30;
                            }
                            if (value == null) {
                                pstmtCreateProcessNotes.setString(ix + 1, "");
                                continue;
                            }
                            pstmtCreateProcessNotes.setString(ix + 1, (String)value);
                            continue;
                        }
                        if (key.equalsIgnoreCase("NOTES_ID")) {
                            pstmtCreateProcessNotes.setLong(ix + 1, notesID);
                            continue;
                        }
                        if (key.equalsIgnoreCase("PROCESSINSTANCEID")) {
                            pstmtCreateProcessNotes.setLong(ix + 1, piid);
                            continue;
                        }
                        if (key.equalsIgnoreCase("PROCESSTEMPLATEID")) break block31;
                        if (key.equalsIgnoreCase("WORKSTEPID")) break block31;
                        if (key.equalsIgnoreCase("WORKITEMID")) break block31;
                        if (key.equalsIgnoreCase("CSTEP_ID")) break block31;
                        if (key.equalsIgnoreCase("CWORKITEM_ID")) break block31;
                        if (!key.equalsIgnoreCase("LAST_MODIFIED_TIME")) break block32;
                    }
                    if (value == null) {
                        throw new BizLogicException("BizLogic_ERR_1588", "ProcessNotesDAO.create", new Object[]{key, "PROCESS NOTES"});
                    }
                    pstmtCreateProcessNotes.setLong(ix + 1, (Long)value);
                    continue;
                }
                if (key.equalsIgnoreCase("REFERENCE_ID")) {
                    if (value == null) {
                        pstmtCreateProcessNotes.setLong(ix + 1, -1L);
                        continue;
                    }
                    pstmtCreateProcessNotes.setLong(ix + 1, (Long)value);
                    continue;
                }
                throw new BizLogicException("BizLogic_ERR_892", "ProcessNotesDAO", new Object[]{key});
            }
            pstmtCreateProcessNotes.executeUpdate();
        }
        catch (Throwable th) {
            try {
                ProcessNotesDAO.handle((Throwable)th, (String)("ProcessNotesDAO.create(PKey: " + notesID + ")"));
            }
            catch (Throwable throwable) {
                ProcessNotesDAO.clean(null, pstmtCreateProcessNotes, conn);
                throw throwable;
            }
            ProcessNotesDAO.clean(null, (Statement)pstmtCreateProcessNotes, (Connection)conn);
        }
        ProcessNotesDAO.clean(null, (Statement)pstmtCreateProcessNotes, (Connection)conn);
        return notesID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getProcessNotes(long processNotesId) {
        Connection conn = null;
        PreparedStatement pstmtGetProcesNotes = null;
        ResultSet rs = null;
        Map<String, Object> loadedAttrs = new HashMap<String, Object>();
        try {
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{getProcessNotes, "pnotes=" + processNotesId});
            }
            conn = ProcessNotesDAO.getConnection();
            pstmtGetProcesNotes = ProcessNotesDAO.prepareStatement(conn, 2);
            pstmtGetProcesNotes.setLong(1, processNotesId);
            rs = pstmtGetProcesNotes.executeQuery();
            if (!rs.next()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = "Process Notes";
                objectArray[1] = processNotesId;
                DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
                objectArray[2] = "BIZLOGIC_PROCESS_NOTES";
                throw new BizLogicException("BizLogic_ERR_1548", "ProcesNotesDAO.getProcesNotes", objectArray);
            }
            loadedAttrs = QSProcessNotesDAO.getAttributes((Connection)conn, (ResultSet)rs);
        }
        catch (Throwable th) {
            try {
                ProcessNotesDAO.handle((Throwable)th, (String)"ProcesNotesDAO.getProcesNotes");
            }
            catch (Throwable throwable) {
                ProcessNotesDAO.clean(rs, pstmtGetProcesNotes, (Connection)conn);
                throw throwable;
            }
            ProcessNotesDAO.clean(rs, (Statement)pstmtGetProcesNotes, (Connection)conn);
        }
        ProcessNotesDAO.clean((ResultSet)rs, (Statement)pstmtGetProcesNotes, (Connection)conn);
        return loadedAttrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(long processNotesId, String newNotes, long lastModifiedTime) {
        Connection conn = null;
        PreparedStatement pstmtUpdateProcessNotes = null;
        try {
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{updateProcessNotes, "pnotes=" + processNotesId});
            }
            conn = ProcessNotesDAO.getConnection();
            pstmtUpdateProcessNotes = ProcessNotesDAO.prepareStatement(conn, 3);
            pstmtUpdateProcessNotes.setString(1, newNotes);
            pstmtUpdateProcessNotes.setLong(2, lastModifiedTime);
            pstmtUpdateProcessNotes.setLong(3, processNotesId);
            pstmtUpdateProcessNotes.executeUpdate();
        }
        catch (Throwable th) {
            try {
                ProcessNotesDAO.handle((Throwable)th, (String)"ProcesNotesDAO.updateProcessNotes");
            }
            catch (Throwable throwable) {
                ProcessNotesDAO.clean(null, pstmtUpdateProcessNotes, (Connection)conn);
                throw throwable;
            }
            ProcessNotesDAO.clean(null, (Statement)pstmtUpdateProcessNotes, (Connection)conn);
        }
        ProcessNotesDAO.clean(null, (Statement)pstmtUpdateProcessNotes, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(long processNotesId) {
        Connection conn = null;
        PreparedStatement pstmtRemoveProcessNotes = null;
        try {
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{removeProcessNotes, "pnotes=" + processNotesId});
            }
            conn = ProcessNotesDAO.getConnection();
            pstmtRemoveProcessNotes = ProcessNotesDAO.prepareStatement(conn, 4);
            pstmtRemoveProcessNotes.setLong(1, processNotesId);
            pstmtRemoveProcessNotes.executeUpdate();
        }
        catch (Throwable th) {
            try {
                ProcessNotesDAO.handle((Throwable)th, (String)"ProcesNotesDAO.removeProcessNotes");
            }
            catch (Throwable throwable) {
                ProcessNotesDAO.clean(null, pstmtRemoveProcessNotes, (Connection)conn);
                throw throwable;
            }
            ProcessNotesDAO.clean(null, (Statement)pstmtRemoveProcessNotes, (Connection)conn);
        }
        ProcessNotesDAO.clean(null, (Statement)pstmtRemoveProcessNotes, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeByProcessInstance(long piId) {
        Connection conn = null;
        PreparedStatement pstmtRemoveByProcessInstance = null;
        try {
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{removeByProcessInstance, "piid = " + piId});
            }
            conn = ProcessNotesDAO.getConnection();
            pstmtRemoveByProcessInstance = ProcessNotesDAO.prepareStatement(conn, 7);
            pstmtRemoveByProcessInstance.setLong(1, piId);
            pstmtRemoveByProcessInstance.executeUpdate();
        }
        catch (Throwable th) {
            try {
                ProcessNotesDAO.handle((Throwable)th, (String)"ProcesNotesDAO.removeByProcessInstance");
            }
            catch (Throwable throwable) {
                ProcessNotesDAO.clean(null, pstmtRemoveByProcessInstance, (Connection)conn);
                throw throwable;
            }
            ProcessNotesDAO.clean(null, (Statement)pstmtRemoveByProcessInstance, (Connection)conn);
        }
        ProcessNotesDAO.clean(null, (Statement)pstmtRemoveByProcessInstance, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeByProcessTemplate(long ptId) {
        Connection conn = null;
        PreparedStatement pstmtRemoveByProcessTemplate = null;
        try {
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{removeByProcessTemplate, "ptid = " + ptId});
            }
            conn = ProcessNotesDAO.getConnection();
            pstmtRemoveByProcessTemplate = ProcessNotesDAO.prepareStatement(conn, 6);
            pstmtRemoveByProcessTemplate.setLong(1, ptId);
            pstmtRemoveByProcessTemplate.executeUpdate();
        }
        catch (Throwable th) {
            try {
                ProcessNotesDAO.handle((Throwable)th, (String)"ProcesNotesDAO.removeByProcessTemplate");
            }
            catch (Throwable throwable) {
                ProcessNotesDAO.clean(null, pstmtRemoveByProcessTemplate, (Connection)conn);
                throw throwable;
            }
            ProcessNotesDAO.clean(null, (Statement)pstmtRemoveByProcessTemplate, (Connection)conn);
        }
        ProcessNotesDAO.clean(null, (Statement)pstmtRemoveByProcessTemplate, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getReferenceCount(long processNotesId) {
        int referenceCount;
        ResultSet rs;
        PreparedStatement pstmtGetReferenceCount;
        Connection conn;
        block5: {
            conn = null;
            pstmtGetReferenceCount = null;
            rs = null;
            referenceCount = 0;
            try {
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{getReferenceCount, "pnotes=" + processNotesId});
                }
                conn = ProcessNotesDAO.getConnection();
                pstmtGetReferenceCount = ProcessNotesDAO.prepareStatement(conn, 5);
                pstmtGetReferenceCount.setLong(1, processNotesId);
                rs = pstmtGetReferenceCount.executeQuery();
                if (!rs.next()) break block5;
                referenceCount = rs.getInt(1);
            }
            catch (Throwable th) {
                try {
                    ProcessNotesDAO.handle((Throwable)th, (String)"ProcesNotesDAO.getReferenceCount");
                }
                catch (Throwable throwable) {
                    ProcessNotesDAO.clean(rs, pstmtGetReferenceCount, (Connection)conn);
                    throw throwable;
                }
                ProcessNotesDAO.clean(rs, (Statement)pstmtGetReferenceCount, (Connection)conn);
            }
        }
        ProcessNotesDAO.clean((ResultSet)rs, (Statement)pstmtGetReferenceCount, (Connection)conn);
        return referenceCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        if (initialized) {
            return;
        }
        Class<ProcessNotesDAO> clazz = ProcessNotesDAO.class;
        synchronized (ProcessNotesDAO.class) {
            if (initialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            ProcessNotesDAO.initSQLStatements();
            initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static PreparedStatement prepareStatement(Connection conn, int sqlQuery) throws SQLException {
        ProcessNotesDAO.init();
        switch (sqlQuery) {
            case 1: {
                return conn.prepareStatement(createProcessNotes);
            }
            case 2: {
                return conn.prepareStatement(getProcessNotes);
            }
            case 3: {
                return conn.prepareStatement(updateProcessNotes);
            }
            case 4: {
                return conn.prepareStatement(removeProcessNotes);
            }
            case 5: {
                return conn.prepareStatement(getReferenceCount);
            }
            case 6: {
                return conn.prepareStatement(removeByProcessTemplate);
            }
            case 7: {
                return conn.prepareStatement(removeByProcessInstance);
            }
        }
        return null;
    }

    private static synchronized void initSQLStatements() {
        int ix = 0;
        StringBuffer sbuffer = new StringBuffer(210);
        sbuffer.append("insert into ");
        DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
        sbuffer.append("BIZLOGIC_PROCESS_NOTES");
        ProcessNotesDAO.addRowlockHint((StringBuffer)sbuffer);
        sbuffer.append(" (");
        for (ix = 0; ix < CREATE_TABLELIST.length; ++ix) {
            sbuffer.append(CREATE_TABLELIST[ix]);
            if (ix == CREATE_TABLELIST.length - 1) continue;
            sbuffer.append(", ");
        }
        sbuffer.append(") values (");
        for (ix = 0; ix < CREATE_TABLELIST.length; ++ix) {
            sbuffer.append("?");
            if (ix == CREATE_TABLELIST.length - 1) continue;
            sbuffer.append(", ");
        }
        sbuffer.append(")");
        createProcessNotes = sbuffer.toString();
        StringBuilder sb = new StringBuilder(150);
        sb.append(QSProcessNotesDAO.defaultSelect);
        sb.append(QSProcessNotesDAO.defaultFrom);
        sb.append(" WHERE ");
        sb.append("NOTES_ID");
        sb.append(" = ? ");
        getProcessNotes = sb.toString();
        sb = new StringBuilder(150);
        sb.append("UPDATE ");
        DBConstants.TableConstants cfr_ignored_1 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESS_NOTES");
        sb.append(" SET ");
        sb.append("NOTES");
        sb.append(" = ?, ");
        sb.append("LAST_MODIFIED_TIME");
        sb.append(" = ? ");
        sb.append(" WHERE ");
        sb.append("NOTES_ID");
        sb.append(" = ? ");
        updateProcessNotes = sb.toString();
        sb = new StringBuilder(150);
        sb.append("DELETE FROM ");
        DBConstants.TableConstants cfr_ignored_2 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESS_NOTES");
        sb.append(" WHERE ");
        sb.append("NOTES_ID");
        sb.append(" = ? ");
        removeProcessNotes = sb.toString();
        sb = new StringBuilder(150);
        sb.append("DELETE FROM ");
        DBConstants.TableConstants cfr_ignored_3 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESS_NOTES");
        sb.append(" WHERE ");
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" = ? ");
        removeByProcessInstance = sb.toString();
        sb = new StringBuilder(150);
        sb.append("DELETE FROM ");
        DBConstants.TableConstants cfr_ignored_5 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESS_NOTES");
        sb.append(" WHERE ");
        DBConstants.ColConstants cfr_ignored_6 = BLControl.dbconsts.col;
        sb.append("PROCESS_TEMPLATE_ID");
        sb.append(" = ? ");
        removeByProcessTemplate = sb.toString();
        sb = new StringBuilder(150);
        sb.append("SELECT COUNT(*) FROM ");
        DBConstants.TableConstants cfr_ignored_7 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESS_NOTES");
        sb.append(" WHERE ");
        sb.append("REFERENCE_ID");
        sb.append(" = ? ");
        getReferenceCount = sb.toString();
        ProcessNotesDAO.printSQLStatements();
    }

    private static void printSQLStatements() {
        if (BLControl.util.DEBUG_DAO) {
            BLControl.logger.debug((Object)"ProcessNotesDAO:");
            BLControl.logger.debugKey("BizLogic_ERR_1199", createProcessNotes, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getProcessNotes, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", updateProcessNotes, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeProcessNotes, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getReferenceCount, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeByProcessTemplate, new Object[0]);
        }
    }

    static {
        String[] stringArray = new String[18];
        stringArray[0] = "NOTES_ID";
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        stringArray[1] = "PROCESS_TEMPLATE_ID";
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        stringArray[2] = "PROCESS_INSTANCE_ID";
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        stringArray[3] = "WORKSTEP_ID";
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        stringArray[4] = "LOOPCOUNTER";
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        stringArray[5] = "WORKITEM_ID";
        stringArray[6] = "CSTEP_ID";
        stringArray[7] = "CWORKITEM_ID";
        stringArray[8] = "NOTES_TYPE";
        stringArray[9] = "NOTES_CONTEXT";
        stringArray[10] = "REFERENCE_ID";
        stringArray[11] = "LAST_MODIFIED_TIME";
        stringArray[12] = "NOTES_USER";
        DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
        stringArray[13] = "WORKSTEP_NAME";
        DBConstants.ColConstants cfr_ignored_6 = BLControl.dbconsts.col;
        stringArray[14] = "WORKITEM_NAME";
        stringArray[15] = "CWORKITEM_NAME";
        stringArray[16] = "THREAD_NAME";
        stringArray[17] = "NOTES";
        CREATE_TABLELIST = stringArray;
        String[] stringArray2 = new String[18];
        stringArray2[0] = "NOTES_ID";
        stringArray2[1] = "PROCESSTEMPLATEID";
        stringArray2[2] = "PROCESSINSTANCEID";
        stringArray2[3] = "WORKSTEPID";
        stringArray2[4] = "LOOPCOUNTER";
        stringArray2[5] = "WORKITEMID";
        stringArray2[6] = "CSTEP_ID";
        stringArray2[7] = "CWORKITEM_ID";
        stringArray2[8] = "NOTES_TYPE";
        stringArray2[9] = "NOTES_CONTEXT";
        stringArray2[10] = "REFERENCE_ID";
        stringArray2[11] = "LAST_MODIFIED_TIME";
        stringArray2[12] = "NOTES_USER";
        stringArray2[13] = "WORKSTEPNAME";
        stringArray2[14] = "WORKITEMNAME";
        stringArray2[15] = "CWORKITEM_NAME";
        stringArray2[16] = "THREAD_NAME";
        stringArray2[17] = "NOTES";
        CREATE_LIST = stringArray2;
        initialized = false;
        createProcessNotes = null;
        getProcessNotes = null;
        updateProcessNotes = null;
        removeProcessNotes = null;
        getReferenceCount = null;
        removeByProcessTemplate = null;
        removeByProcessInstance = null;
    }
}

