/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.dao;

import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.XMLDocRepository;
import com.savvion.sbm.bizlogic.server.dao.ProcessTemplateDAO;
import com.savvion.sbm.bizlogic.server.dao.TimerActionDAO;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.DBConstants;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;

public class RemovePiDAO
extends BLDAOService {
    static String removePTInstanceDataslots = null;
    static String removePTWorkItems = null;
    static String removePTAvailWorkItems = null;
    static String removePTWorkstepInstances = null;
    static String removePTProcessInstances = null;
    static String removeWaitWorkSteps = null;
    static String removeDynamicPIXML = null;
    static String removeDynamicPT = null;
    static String loadProcessInstanceID = null;
    static String invalPreCondPID = null;
    static String bs_piStatusUpdate = null;

    public static long removeAllProcessInstances(long ptid) {
        long pids = 0L;
        try {
            WFProcess pt = ProcessTemplateDAO.load(ptid);
            Vector xmlDS = pt.getDataslots("XML", false, false);
            RemovePiDAO.removeXMLRepositoryDocs(xmlDS);
            RemovePiDAO.removeAllDataslots(pt, ptid);
            RemovePiDAO.removeAllWorkItems(ptid);
            RemovePiDAO.removeAllWorkStepInstances(ptid);
            RemovePiDAO.removeDynamicProcess(ptid);
            pids = RemovePiDAO.removeAllPI(ptid);
        }
        catch (Throwable th) {
            RemovePiDAO.handle((Throwable)th);
        }
        return pids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getInvalPreCondPI(long ptid) {
        PreparedStatement pstmtInval = null;
        Vector<Long> invalPI = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = RemovePiDAO.getConnection();
            pstmtInval = conn.prepareStatement(invalPreCondPID);
            pstmtInval.setLong(1, ptid);
            rs = pstmtInval.executeQuery();
            while (rs.next()) {
                if (invalPI == null) {
                    invalPI = new Vector<Long>();
                }
                invalPI.add(new Long(rs.getLong(1)));
            }
            RemovePiDAO.clean((ResultSet)rs, (Statement)pstmtInval, (Connection)conn);
        }
        catch (SQLException sqlerr) {
            RemovePiDAO.handle((SQLException)sqlerr);
        }
        finally {
            RemovePiDAO.clean(rs, (Statement)pstmtInval, (Connection)conn);
        }
        return invalPI;
    }

    private static void removeXMLRepositoryDocs(Vector xmldataslots) {
        if (xmldataslots == null) {
            return;
        }
        for (int iy = 0; iy < xmldataslots.size(); ++iy) {
            WFDataslot ds = (WFDataslot)xmldataslots.elementAt(iy);
            if (ds == null || ds.isGlobal() || ds.isPublic()) continue;
            XMLDocRepository.removeCollection(ds.getXMLCollectionID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeAllDataslots(WFProcess pt, long ptid) {
        PreparedStatement pstmtDelete = null;
        Connection conn = null;
        try {
            conn = RemovePiDAO.getConnection();
            String table = pt.getDSTableName();
            if (table == null || "".equals(table)) {
                return;
            }
            RemovePiDAO.setInstanceDsSql(table);
            pstmtDelete = conn.prepareStatement(removePTInstanceDataslots);
            pstmtDelete.setLong(1, ptid);
            pstmtDelete.executeUpdate();
            RemovePiDAO.clean(null, (Statement)pstmtDelete, (Connection)conn);
        }
        catch (SQLException sqlerr) {
            RemovePiDAO.handle((SQLException)sqlerr);
        }
        finally {
            RemovePiDAO.clean(null, pstmtDelete, (Connection)conn);
        }
    }

    private static synchronized void setInstanceDsSql(String tableName) {
        if (tableName != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("delete from ");
            sb.append(tableName);
            sb.append(" where ");
            DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
            sb.append("PROCESS_INSTANCE_ID");
            sb.append(" in ");
            sb.append("(select ");
            DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
            sb.append("PROCESS_INSTANCE_ID");
            sb.append(" from ");
            DBConstants.TableConstants cfr_ignored_2 = BLControl.dbconsts.tab;
            sb.append("BIZLOGIC_PROCESSINSTANCE");
            sb.append(" where (");
            DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
            sb.append("ISCALLBACKCALLER");
            sb.append(" = 0 or ");
            DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
            sb.append("ISCALLBACKCALLER");
            sb.append(" IS NULL) ");
            sb.append(" and ");
            DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
            sb.append("PROCESS_TEMPLATE_ID");
            sb.append(" = ? )");
            removePTInstanceDataslots = sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeAllWorkItems(long ptid) {
        block5: {
            PreparedStatement pstmtDeleteAvailWorkItems = null;
            PreparedStatement pstmtDeleteWorkItems = null;
            Connection conn = null;
            try {
                conn = RemovePiDAO.getConnection();
                pstmtDeleteAvailWorkItems = conn.prepareStatement(removePTAvailWorkItems);
                pstmtDeleteAvailWorkItems.setLong(1, ptid);
                pstmtDeleteAvailWorkItems.executeUpdate();
                pstmtDeleteWorkItems = conn.prepareStatement(removePTWorkItems);
                pstmtDeleteWorkItems.setLong(1, ptid);
                pstmtDeleteWorkItems.executeUpdate();
                RemovePiDAO.clean(null, (Statement)pstmtDeleteAvailWorkItems, null);
            }
            catch (SQLException sqlerr) {
                RemovePiDAO.handle((SQLException)sqlerr);
                break block5;
            }
            finally {
                RemovePiDAO.clean(null, (Statement)pstmtDeleteAvailWorkItems, null);
                RemovePiDAO.clean(null, pstmtDeleteWorkItems, (Connection)conn);
            }
            RemovePiDAO.clean(null, (Statement)pstmtDeleteWorkItems, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeAllWorkStepInstances(long ptid) {
        PreparedStatement pstmtDeleteWorksteps = null;
        Connection conn = null;
        try {
            conn = RemovePiDAO.getConnection();
            pstmtDeleteWorksteps = conn.prepareStatement(removePTWorkstepInstances);
            pstmtDeleteWorksteps.setLong(1, ptid);
            pstmtDeleteWorksteps.executeUpdate();
            TimerActionDAO.removeByProcessTemplate(ptid);
        }
        catch (SQLException sqlerr) {
            RemovePiDAO.handle((SQLException)sqlerr);
        }
        finally {
            RemovePiDAO.clean(null, (Statement)pstmtDeleteWorksteps, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeDynamicProcess(long ptid) {
        block5: {
            PreparedStatement pstmtDeletePIXML = null;
            PreparedStatement pstmtDeletePT = null;
            Connection conn = null;
            try {
                conn = RemovePiDAO.getConnection();
                pstmtDeletePIXML = conn.prepareStatement(removeDynamicPIXML);
                pstmtDeletePIXML.setLong(1, ptid);
                pstmtDeletePIXML.executeUpdate();
                pstmtDeletePT = conn.prepareStatement(removeDynamicPT);
                pstmtDeletePT.setLong(1, ptid);
                pstmtDeletePT.executeUpdate();
                RemovePiDAO.clean(null, (Statement)pstmtDeletePIXML, null);
            }
            catch (SQLException sqlerr) {
                RemovePiDAO.handle((SQLException)sqlerr);
                break block5;
            }
            finally {
                RemovePiDAO.clean(null, (Statement)pstmtDeletePIXML, null);
                RemovePiDAO.clean(null, pstmtDeletePT, (Connection)conn);
            }
            RemovePiDAO.clean(null, (Statement)pstmtDeletePT, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long removeAllPI(long ptid) {
        long picount;
        block6: {
            PreparedStatement pstmtLoadPI = null;
            PreparedStatement pstmtUpdateBS = null;
            PreparedStatement pstmtPI = null;
            Connection conn = null;
            ResultSet rs = null;
            picount = 0L;
            Vector<Long> removedPI = new Vector<Long>();
            try {
                conn = RemovePiDAO.getConnection();
                pstmtLoadPI = conn.prepareStatement(loadProcessInstanceID);
                pstmtLoadPI.setLong(1, ptid);
                rs = pstmtLoadPI.executeQuery();
                while (rs.next()) {
                    removedPI.add(new Long(rs.getLong(1)));
                }
                Timestamp ts = new Timestamp(new Date().getTime());
                String status = BLControl.consts.wfStates[12];
                pstmtUpdateBS = conn.prepareStatement(bs_piStatusUpdate);
                pstmtUpdateBS.setString(1, status);
                pstmtUpdateBS.setTimestamp(2, ts);
                pstmtUpdateBS.setLong(3, ptid);
                pstmtUpdateBS.executeUpdate();
                pstmtPI = conn.prepareStatement(removePTProcessInstances);
                pstmtPI.setLong(1, ptid);
                pstmtPI.executeUpdate();
                picount = removedPI.size();
                RemovePiDAO.clean(null, (Statement)pstmtLoadPI, null);
            }
            catch (SQLException sqlerr) {
                RemovePiDAO.handle((SQLException)sqlerr);
                break block6;
            }
            finally {
                RemovePiDAO.clean(null, (Statement)pstmtLoadPI, null);
                RemovePiDAO.clean(null, pstmtUpdateBS, null);
                RemovePiDAO.clean((ResultSet)rs, pstmtPI, (Connection)conn);
            }
            RemovePiDAO.clean(null, (Statement)pstmtUpdateBS, null);
            RemovePiDAO.clean((ResultSet)rs, (Statement)pstmtPI, (Connection)conn);
        }
        return picount;
    }

    public static synchronized void initSQLStatements() {
        StringBuffer sb = new StringBuffer();
        sb.append(" select ");
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_1 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESSINSTANCE");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        sb.append("PROCESS_TEMPLATE_ID").append(" = ? ");
        sb.append(" and (");
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        sb.append("ISCALLBACKCALLER");
        sb.append(" = 0 or ");
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        sb.append("ISCALLBACKCALLER");
        sb.append(" IS NULL) ");
        loadProcessInstanceID = sb.toString();
        sb = new StringBuffer();
        sb.append("delete from ");
        DBConstants.TableConstants cfr_ignored_5 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_WORKITEM");
        sb.append(" where ");
        DBConstants.TableConstants cfr_ignored_6 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_WORKITEM").append(".");
        DBConstants.ColConstants cfr_ignored_7 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID").append(" in ( ");
        sb.append(loadProcessInstanceID);
        sb.append(" ) ");
        removePTWorkItems = sb.toString();
        sb = new StringBuffer();
        sb.append("delete from ");
        DBConstants.TableConstants cfr_ignored_8 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_AVAILABLEWORKITEM");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_9 = BLControl.dbconsts.col;
        sb.append("WORKITEM_ID");
        sb.append(" in ( select ");
        DBConstants.ColConstants cfr_ignored_10 = BLControl.dbconsts.col;
        sb.append("WORKITEM_ID");
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_11 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_WORKITEM");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_12 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" in ( ");
        sb.append(loadProcessInstanceID);
        sb.append(" ) ");
        sb.append(" ) ");
        removePTAvailWorkItems = sb.toString();
        sb = new StringBuffer();
        sb.append("delete from ");
        DBConstants.TableConstants cfr_ignored_13 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_WORKSTEPINSTANCE");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_14 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" in ( ");
        sb.append(loadProcessInstanceID);
        sb.append(" ) ");
        removePTWorkstepInstances = sb.toString();
        sb = new StringBuffer();
        sb.append("delete from ");
        DBConstants.TableConstants cfr_ignored_15 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESSINSTANCE");
        sb.append(" where (");
        DBConstants.ColConstants cfr_ignored_16 = BLControl.dbconsts.col;
        sb.append("ISCALLBACKCALLER");
        sb.append(" = 0 or ");
        DBConstants.ColConstants cfr_ignored_17 = BLControl.dbconsts.col;
        sb.append("ISCALLBACKCALLER");
        sb.append(" IS NULL) ");
        sb.append(" and ");
        DBConstants.ColConstants cfr_ignored_18 = BLControl.dbconsts.col;
        sb.append("PROCESS_TEMPLATE_ID").append(" = ?");
        removePTProcessInstances = sb.toString();
        sb = new StringBuffer();
        sb.append("delete from ");
        DBConstants.TableConstants cfr_ignored_19 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_WAITWORKSTEP");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_20 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" in ( ");
        sb.append(loadProcessInstanceID);
        sb.append(" ) ");
        removeWaitWorkSteps = sb.toString();
        sb = new StringBuffer();
        sb.append("delete from ");
        DBConstants.TableConstants cfr_ignored_21 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PIXML");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_22 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" in ( ");
        sb.append(loadProcessInstanceID);
        sb.append(" ) ");
        removeDynamicPIXML = sb.toString();
        sb = new StringBuffer();
        sb.append("delete from ");
        DBConstants.TableConstants cfr_ignored_23 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PITEMPLATE");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_24 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" in ( ");
        sb.append(loadProcessInstanceID);
        sb.append(" ) ");
        removeDynamicPT = sb.toString();
        sb = new StringBuffer();
        sb.append(" select ");
        DBConstants.TableConstants cfr_ignored_25 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_WORKSTEPINSTANCE");
        sb.append(".");
        DBConstants.ColConstants cfr_ignored_26 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_27 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_WORKSTEPINSTANCE");
        sb.append(" , ");
        DBConstants.TableConstants cfr_ignored_28 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESSINSTANCE");
        sb.append(" where ");
        DBConstants.TableConstants cfr_ignored_29 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_WORKSTEPINSTANCE");
        sb.append(".");
        DBConstants.ColConstants cfr_ignored_30 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" = ");
        DBConstants.TableConstants cfr_ignored_31 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESSINSTANCE");
        sb.append(".");
        DBConstants.ColConstants cfr_ignored_32 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" and ");
        DBConstants.TableConstants cfr_ignored_33 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_WORKSTEPINSTANCE");
        sb.append(".");
        DBConstants.ColConstants cfr_ignored_34 = BLControl.dbconsts.col;
        sb.append("STATUS");
        sb.append(" = ");
        sb.append(16);
        sb.append(" and ");
        DBConstants.TableConstants cfr_ignored_35 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_WORKSTEPINSTANCE");
        sb.append(".");
        DBConstants.ColConstants cfr_ignored_36 = BLControl.dbconsts.col;
        sb.append("SUSPENDSTATUS");
        sb.append(" = ");
        sb.append(1);
        sb.append(" and ( ");
        DBConstants.TableConstants cfr_ignored_37 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESSINSTANCE");
        sb.append(".");
        DBConstants.ColConstants cfr_ignored_38 = BLControl.dbconsts.col;
        sb.append("ISCALLBACKCALLER");
        sb.append(" = 0 or ");
        DBConstants.TableConstants cfr_ignored_39 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESSINSTANCE");
        sb.append(".");
        DBConstants.ColConstants cfr_ignored_40 = BLControl.dbconsts.col;
        sb.append("ISCALLBACKCALLER");
        sb.append(" IS NULL) ");
        sb.append(" and ");
        DBConstants.TableConstants cfr_ignored_41 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESSINSTANCE");
        sb.append(".");
        DBConstants.ColConstants cfr_ignored_42 = BLControl.dbconsts.col;
        sb.append("PROCESS_TEMPLATE_ID").append(" = ? ");
        invalPreCondPID = sb.toString();
        sb = new StringBuffer();
        sb.append("update ");
        DBConstants.TableConstants cfr_ignored_43 = BLControl.dbconsts.tab;
        sb.append("PROCESSINSTANCE");
        sb.append(" set ");
        DBConstants.ColConstants cfr_ignored_44 = BLControl.dbconsts.col;
        sb.append("STATUS");
        sb.append(" = ? ,");
        DBConstants.ColConstants cfr_ignored_45 = BLControl.dbconsts.col;
        sb.append("END_TIME");
        sb.append(" = ? ");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_46 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" in ( ");
        sb.append(loadProcessInstanceID);
        sb.append(" ) ");
        bs_piStatusUpdate = sb.toString();
        RemovePiDAO.printSQLStatements();
    }

    private static void printSQLStatements() {
        if (BLControl.util.DEBUG_DAO) {
            BLControl.logger.debug((Object)"RemoveProcessInstanceDAO:");
            BLControl.logger.debugKey("BizLogic_ERR_1199", removePTInstanceDataslots, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removePTWorkItems, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removePTAvailWorkItems, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removePTWorkstepInstances, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeWaitWorkSteps, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeDynamicPIXML, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeDynamicPT, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", invalPreCondPID, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removePTProcessInstances, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", bs_piStatusUpdate, new Object[0]);
        }
    }
}

