/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.dao;

import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.DBConstants;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.util.SBMControl;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class SessionDAO
extends BLDAOService {
    private static final String[] CREATE_LIST;
    private static final String[] LOAD_LIST;
    public static String findByPrimaryKey;
    public static String create;
    public static String update;
    public static String remove;
    public static String removeExpiredSessions;
    public static String createSessionTable;
    public static String getSessionCount;
    public static String getSessionList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object findByPrimaryKey(long sesid) {
        Connection conn = null;
        PreparedStatement pstmtFindByPrimaryKey = null;
        ResultSet rs = null;
        Vector<Object> v = null;
        try {
            conn = SessionDAO.getConnection();
            pstmtFindByPrimaryKey = conn.prepareStatement(findByPrimaryKey);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", findByPrimaryKey, new Object[0]);
            }
            pstmtFindByPrimaryKey.setLong(1, sesid);
            rs = pstmtFindByPrimaryKey.executeQuery();
            while (rs.next()) {
                v = new Vector<Object>(2);
                v.addElement(new Long(SessionDAO.getDateValue((ResultSet)rs, (int)1)));
                v.addElement(SessionDAO.convertToObject((byte[])rs.getBytes(2)));
            }
            SessionDAO.clean((ResultSet)rs, (Statement)pstmtFindByPrimaryKey, (Connection)conn);
        }
        catch (SQLException sqlex) {
            SessionDAO.handle((SQLException)sqlex);
        }
        finally {
            SessionDAO.clean(rs, (Statement)pstmtFindByPrimaryKey, (Connection)conn);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create(long sesid, long starttime, Session session) {
        Connection conn = null;
        PreparedStatement pstmtCreate = null;
        try {
            conn = SessionDAO.getConnection();
            pstmtCreate = conn.prepareStatement(create);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", create, new Object[0]);
            }
            pstmtCreate.setLong(1, sesid);
            SessionDAO.setDateValue((PreparedStatement)pstmtCreate, (int)2, (long)starttime);
            pstmtCreate.setBytes(3, SessionDAO.convertToBytes((Object)session));
            pstmtCreate.executeUpdate();
        }
        catch (SQLException sqlex) {
            SessionDAO.handle((Throwable)sqlex, (String)("SessionDAO.create(PKey: " + sesid + ")"));
        }
        finally {
            SessionDAO.clean(null, (Statement)pstmtCreate, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(long sesid) {
        Connection conn = null;
        PreparedStatement pstmtRemove = null;
        try {
            conn = SessionDAO.getConnection();
            pstmtRemove = conn.prepareStatement(remove);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", remove, new Object[0]);
            }
            pstmtRemove.setLong(1, sesid);
            pstmtRemove.executeUpdate();
        }
        catch (SQLException sqlex) {
            SessionDAO.handle((SQLException)sqlex);
        }
        finally {
            SessionDAO.clean(null, (Statement)pstmtRemove, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(Session session) {
        Connection conn = null;
        PreparedStatement pstmtUpdate = null;
        try {
            conn = SessionDAO.getConnection();
            pstmtUpdate = conn.prepareStatement(update);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", update, new Object[0]);
            }
            SessionDAO.setDateValue((PreparedStatement)pstmtUpdate, (int)1, (long)session.getLastAccessTime());
            pstmtUpdate.setLong(2, session.getID());
            pstmtUpdate.executeUpdate();
        }
        catch (SQLException sqlex) {
            SessionDAO.handle((SQLException)sqlex);
        }
        finally {
            SessionDAO.clean(null, (Statement)pstmtUpdate, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeExpiredSessions(long expiredtime) {
        Connection conn = null;
        PreparedStatement pstmtRemoveExpiredSessions = null;
        try {
            conn = SessionDAO.getConnection();
            pstmtRemoveExpiredSessions = conn.prepareStatement(removeExpiredSessions);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", removeExpiredSessions, new Object[0]);
            }
            SessionDAO.setDateValue((PreparedStatement)pstmtRemoveExpiredSessions, (int)1, (long)expiredtime);
            pstmtRemoveExpiredSessions.executeUpdate();
        }
        catch (SQLException sqlex) {
            SessionDAO.handle((SQLException)sqlex);
        }
        finally {
            SessionDAO.clean(null, (Statement)pstmtRemoveExpiredSessions, (Connection)conn);
        }
    }

    public static void createTable() {
        Connection conn = null;
        PreparedStatement pstmtCreateSessionTable = null;
        try {
            conn = SessionDAO.getConnection();
            pstmtCreateSessionTable = conn.prepareStatement(createSessionTable);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", createSessionTable, new Object[0]);
            }
            pstmtCreateSessionTable.executeUpdate();
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1186", "BizLogic_Session", new Object[0]);
            }
        }
        catch (SQLException sqlex) {
            SessionDAO.handle((SQLException)sqlex);
        }
        finally {
            SessionDAO.clean(null, (Statement)pstmtCreateSessionTable, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSessionCount() {
        int count;
        ResultSet rs;
        Statement stmtGetSessionCount;
        Connection conn;
        block6: {
            conn = null;
            stmtGetSessionCount = null;
            rs = null;
            count = 0;
            try {
                conn = SessionDAO.getConnection();
                stmtGetSessionCount = conn.createStatement();
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1185", getSessionCount, new Object[0]);
                }
                if (!(rs = stmtGetSessionCount.executeQuery(getSessionCount)).next()) break block6;
                count = rs.getInt(1);
            }
            catch (Throwable th) {
                try {
                    SessionDAO.handle((Throwable)th);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    SessionDAO.clean(rs, (Statement)stmtGetSessionCount, (Connection)conn);
                }
            }
        }
        SessionDAO.clean((ResultSet)rs, (Statement)stmtGetSessionCount, (Connection)conn);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getSessionList() {
        Connection conn = null;
        PreparedStatement pstmtGetSessionList = null;
        ResultSet rset = null;
        Vector<Session> sessionList = new Vector<Session>();
        Session session = null;
        InputStream is = null;
        try {
            conn = SessionDAO.getConnection();
            pstmtGetSessionList = conn.prepareStatement(getSessionList);
            rset = pstmtGetSessionList.executeQuery();
            while (rset.next()) {
                is = rset.getBinaryStream(1);
                session = (Session)SessionDAO.convertToObject((InputStream)is);
                if (session == null) {
                    throw new BizLogicException("BizLogic_ERR_924", "SessionDAO.getSessionList");
                }
                sessionList.add(session);
            }
        }
        catch (SQLException sqlerr) {
            try {
                sessionList.clear();
                SessionDAO.handle((SQLException)sqlerr);
            }
            catch (Throwable throwable) {
                SessionDAO.clean(is, rset, (PreparedStatement)pstmtGetSessionList, (Connection)conn);
                throw throwable;
            }
            SessionDAO.clean(is, (ResultSet)rset, (PreparedStatement)pstmtGetSessionList, (Connection)conn);
        }
        SessionDAO.clean((InputStream)is, (ResultSet)rset, (PreparedStatement)pstmtGetSessionList, (Connection)conn);
        return sessionList;
    }

    public static synchronized void initSQLStatements() {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table ");
        DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
        createTable.append("BIZLOGIC_SESSION");
        createTable.append(" (");
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        createTable.append("SESSION_ID");
        createTable.append(" ");
        createTable.append(SBMControl.dbmap.getSQLTypeWithSize(Long.TYPE));
        createTable.append(", ");
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        createTable.append("START_TIME");
        createTable.append(" ");
        createTable.append(SBMControl.dbmap.getSQLTypeWithSize(Long.TYPE));
        createTable.append(", ");
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        createTable.append("SESSION_OBJ");
        createTable.append(" ");
        createTable.append(SBMControl.dbmap.getSQLTypeWithSize(Object.class));
        createTable.append(")");
        createTable.toString();
        int ix = 0;
        StringBuffer buffer = new StringBuffer();
        buffer.append("insert into ");
        DBConstants.TableConstants cfr_ignored_4 = BLControl.dbconsts.tab;
        buffer.append("BIZLOGIC_SESSION");
        buffer.append(" (");
        for (ix = 0; ix < CREATE_LIST.length; ++ix) {
            buffer.append(CREATE_LIST[ix]);
            if (ix == CREATE_LIST.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append(") values (");
        for (ix = 0; ix < CREATE_LIST.length; ++ix) {
            buffer.append("?");
            if (ix == CREATE_LIST.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        create = buffer.toString();
        buffer = new StringBuffer();
        buffer.append("select ");
        for (ix = 0; ix < LOAD_LIST.length; ++ix) {
            buffer.append(LOAD_LIST[ix]);
            if (ix == LOAD_LIST.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append(" from ");
        DBConstants.TableConstants cfr_ignored_5 = BLControl.dbconsts.tab;
        buffer.append("BIZLOGIC_SESSION");
        buffer.append(" where ");
        DBConstants.ColConstants cfr_ignored_6 = BLControl.dbconsts.col;
        buffer.append("SESSION_ID");
        buffer.append(" = ?");
        findByPrimaryKey = buffer.toString();
        buffer = new StringBuffer();
        buffer.append("update ");
        DBConstants.TableConstants cfr_ignored_7 = BLControl.dbconsts.tab;
        buffer.append("BIZLOGIC_SESSION");
        buffer.append(" set ");
        DBConstants.ColConstants cfr_ignored_8 = BLControl.dbconsts.col;
        buffer.append("START_TIME");
        buffer.append(" = ? ");
        buffer.append(" where ");
        DBConstants.ColConstants cfr_ignored_9 = BLControl.dbconsts.col;
        buffer.append("SESSION_ID");
        buffer.append(" = ?");
        update = buffer.toString();
        buffer = new StringBuffer();
        buffer.append("delete from ");
        DBConstants.TableConstants cfr_ignored_10 = BLControl.dbconsts.tab;
        buffer.append("BIZLOGIC_SESSION");
        buffer.append(" where ");
        DBConstants.ColConstants cfr_ignored_11 = BLControl.dbconsts.col;
        buffer.append("SESSION_ID");
        buffer.append(" = ?");
        remove = buffer.toString();
        buffer = new StringBuffer();
        buffer.append("delete from ");
        DBConstants.TableConstants cfr_ignored_12 = BLControl.dbconsts.tab;
        buffer.append("BIZLOGIC_SESSION");
        buffer.append(" where ");
        DBConstants.ColConstants cfr_ignored_13 = BLControl.dbconsts.col;
        buffer.append("START_TIME");
        buffer.append(" < ?");
        removeExpiredSessions = buffer.toString();
        buffer = new StringBuffer(100);
        buffer.append("select count(*) from ");
        DBConstants.TableConstants cfr_ignored_14 = BLControl.dbconsts.tab;
        buffer.append("BIZLOGIC_SESSION");
        getSessionCount = buffer.toString();
        buffer = new StringBuffer();
        buffer.append("select ");
        DBConstants.ColConstants cfr_ignored_15 = BLControl.dbconsts.col;
        buffer.append("SESSION_OBJ");
        buffer.append(" from ");
        DBConstants.TableConstants cfr_ignored_16 = BLControl.dbconsts.tab;
        buffer.append("BIZLOGIC_SESSION");
        getSessionList = buffer.toString();
        SessionDAO.printSQLStatements();
    }

    private static void printSQLStatements() {
        if (BLControl.util.DEBUG_DAO) {
            BLControl.logger.debug((Object)"SessionDAO:");
            BLControl.logger.debugKey("BizLogic_ERR_1199", findByPrimaryKey, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", create, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", update, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", remove, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeExpiredSessions, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getSessionCount, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getSessionList, new Object[0]);
        }
    }

    static {
        String[] stringArray = new String[3];
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        stringArray[0] = "SESSION_ID";
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        stringArray[1] = "START_TIME";
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        stringArray[2] = "SESSION_OBJ";
        CREATE_LIST = stringArray;
        String[] stringArray2 = new String[2];
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        stringArray2[0] = "START_TIME";
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        stringArray2[1] = "SESSION_OBJ";
        LOAD_LIST = stringArray2;
    }
}

