/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.ejb;

import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.ejb.BLListener;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.util.TransactionService;
import com.savvion.sbm.util.logger.SBMLogger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.transaction.UserTransaction;

public class BLCacheSync
extends BLListener {
    public void start() {
        try {
            this.init("blcachesync", null);
            this.consumer.setMessageListener((MessageListener)this);
        }
        catch (JMSException err) {
            throw new BizLogicException("BizLogic_ERR_2617", "BLCacheSync.start");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onMessage(Message msg) {
        BLConstants consts = BLConstants.single();
        try {
            String server = msg.getStringProperty("SERVER_ID");
            if (server == null) return;
            if (server.equals(BLControl.getServerID())) {
                return;
            }
            String type = msg.getStringProperty("TYPE");
            if (type.equalsIgnoreCase("PROCESSTEMPLATENAME")) {
                this.syncProcessTemplate(msg, consts);
                return;
            }
            if (!type.equalsIgnoreCase("SUSPENDED_WORKSTEP")) return;
        }
        catch (JMSException jex) {
            BLControl.logger.errorKey("BizLogic_ERR_2620", new Object[]{msg.toString()}, (Throwable)jex);
        }
    }

    private void syncProcessTemplate(Message msg, BLConstants consts) {
        try {
            String operation = msg.getStringProperty("OPERATION");
            long ptid = msg.getLongProperty("PROCESSTEMPLATEID");
            try {
                if (operation.equalsIgnoreCase("ADD")) {
                    if (BLControl.util.DEBUG_CLUSTERING) {
                        BLControl.logger.debug((Object)("Clustering:Listener adding process template " + ptid + " to cache"));
                    }
                    this.updateProcessTemplate(ptid);
                } else if (operation.equalsIgnoreCase("REMOVE")) {
                    WFProcess pt;
                    if (BLControl.util.DEBUG_CLUSTERING) {
                        BLControl.logger.debug((Object)("Clustering:Listener removing process template " + ptid + " from cache"));
                    }
                    if ((pt = ProcessControl.removeProcessTemplateFromCache(ptid)) == null) {
                        BLControl.logger.debug((Object)("Clustering:Listener failed to remove process <" + ptid + "> from cache"));
                    }
                } else if (operation.equalsIgnoreCase("UPDATE")) {
                    if (BLControl.util.DEBUG_CLUSTERING) {
                        BLControl.logger.debug((Object)("Clustering:Listener updating process template " + ptid + " to cache"));
                    }
                    this.updateProcessTemplate(ptid);
                }
            }
            catch (Exception ex) {
                try {
                    TransactionService.rollback((UserTransaction)this.utx, (SBMLogger)BLControl.logger);
                }
                catch (Exception ex1) {
                    BLControl.logger.errorKey("BizLogic_ERR_2621", new Object[]{"BLCacheSync", "ProcessTemplateSync"}, (Throwable)ex1);
                }
                BLControl.logger.errorKey("BizLogic_ERR_2618", new Object[]{operation, ptid}, (Throwable)ex);
            }
        }
        catch (JMSException jex) {
            BLControl.logger.errorKey("BizLogic_ERR_2620", new Object[]{msg.toString()}, (Throwable)jex);
        }
    }

    private void updateProcessTemplate(long ptid) {
        try {
            int dura = 0;
            while ((long)dura < BLUtil.self().getMsgRetryMaxTime()) {
                this.utx.begin();
                WFProcess ptObject = ProcessControl.addProcessTemplateToCache(ptid);
                this.utx.commit();
                if (ptObject == null) {
                    Thread.sleep(BLUtil.self().getMsgRetryInterval());
                    dura = (int)((long)dura + BLUtil.self().getMsgRetryInterval());
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

