/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.ejb;

import com.savvion.sbm.bizlogic.server.DebugService;
import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFProcessInstance;
import com.savvion.sbm.bizlogic.server.WFProcessNotes;
import com.savvion.sbm.bizlogic.server.dao.ProcessInstanceDAO;
import com.savvion.sbm.bizlogic.server.dao.ProcessInstanceXMLDAO;
import com.savvion.sbm.bizlogic.server.dao.ProcessXMLDAO;
import com.savvion.sbm.bizlogic.server.dao.WorkStepInstanceDAO;
import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceEBLocal;
import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceEBLocalHome;
import com.savvion.sbm.bizlogic.server.svo.DataSlot;
import com.savvion.sbm.bizlogic.server.svo.DataSlotList;
import com.savvion.sbm.bizlogic.server.svo.ProcessInstance;
import com.savvion.sbm.bizlogic.server.svo.ProcessInstanceList;
import com.savvion.sbm.bizlogic.server.svo.ProcessNotes;
import com.savvion.sbm.bizlogic.server.svo.ProcessTemplate;
import com.savvion.sbm.bizlogic.server.svo.SVOFactory;
import com.savvion.sbm.bizlogic.server.svo.WorkItemList;
import com.savvion.sbm.bizlogic.server.svo.WorkStepInstance;
import com.savvion.sbm.bizlogic.server.svo.WorkStepInstanceList;
import com.savvion.sbm.bizlogic.server.svo.WorkStepTemplate;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.bizlogic.util.SessionAdapter;
import com.savvion.sbm.bizlogic.util.SessionManager;
import com.savvion.sbm.util.ResultData;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;

public class ProcessInstanceSBBean
extends SessionAdapter {
    public HashMap getAttributes(Session ses, long piid) {
        SessionManager.validate((Session)ses, (String)"PISB::getAttributes(s,piid");
        ProcessInstanceEBLocal piEB = BLControl.util.getProcessInstanceEB(piid);
        return BLControl.util.convertPriorityToString(piEB.getAttributes());
    }

    public HashMap getAttributes(Session ses, List piids) {
        SessionManager.validate((Session)ses, (String)"PISB::getAttributes(s,piids");
        HashMap<Long, HashMap> attributes = new HashMap<Long, HashMap>();
        for (int ix = 0; ix < piids.size(); ++ix) {
            long piid = (Long)piids.get(ix);
            ProcessInstanceEBLocal piEB = BLControl.util.getProcessInstanceEB(piid);
            HashMap piAttrs = BLControl.util.convertPriorityToString(piEB.getAttributes());
            attributes.put(piid, piAttrs);
        }
        return attributes;
    }

    public void save(Session ses, long piid, HashMap attributes) {
        SessionManager.validate((Session)ses, (String)"PISB::save(s,piid,attr)");
        WFProcessContext pCtx = new WFProcessContext(ses, piid);
        pCtx.setProcessInstanceAttributes(attributes);
    }

    public ProcessInstance getProcessInstance(Session ses, long piid) {
        SessionManager.validate((Session)ses, (String)"PISB::getProcessInstance(s,piid)");
        return SVOFactory.getProcessInstance(ses, piid);
    }

    public String getStartWorkstepName(Session ses, long piid) {
        SessionManager.validate((Session)ses, (String)"PISB::getStartWorkstepName(s,piid)");
        WFProcessContext pCtx = new WFProcessContext(ses, piid);
        return pCtx.getStartWorkStepName();
    }

    public HashMap getCallerInfo(Session ses, long piid) {
        SessionManager.validate((Session)ses, (String)"PISB::getCallerInfo(s,piid)");
        ProcessInstanceEBLocal piEB = BLControl.util.getProcessInstanceEB(piid);
        return piEB.getCallerInfo();
    }

    public String getProcessTemplateName(Session ses, long piid) {
        SessionManager.validate((Session)ses, (String)"PISB::getProcessTemplateName(s,piid)");
        WFProcessContext pCtx = new WFProcessContext(ses, piid);
        return pCtx.getProcessTemplateName();
    }

    public void activate(Session ses, long piid) {
        SessionManager.validate((Session)ses, (String)"PISB::activate(s,piid)");
        WFProcessContext pCtx = new WFProcessContext(ses, piid);
        pCtx.activateProcessInstance();
    }

    public void suspend(Session ses, long piid) {
        SessionManager.validate((Session)ses, (String)"PISB::suspend(s,piid)");
        WFProcessContext pCtx = new WFProcessContext(ses, piid);
        pCtx.suspendProcessInstance();
    }

    public void resume(Session ses, long piid) {
        SessionManager.validate((Session)ses, (String)"PISB::resume(s,piid)");
        WFProcessContext pCtx = new WFProcessContext(ses, piid);
        pCtx.resumeProcessInstance();
    }

    public void remove(Session ses, long piid) {
        SessionManager.validate((Session)ses, (String)"PISB::remove(s,piid)");
        WFProcessContext pCtx = new WFProcessContext(ses, piid);
        if (pCtx.isSyncSubProcessInstance()) {
            throw new BizLogicException("BizLogic_ERR_596", "ProcessInstanceSBBean.remove", new Object[]{pCtx.getProcessInstanceName()});
        }
        pCtx.removeProcessInstance(false);
    }

    public void removeSubProcessPI(Session ses, long piid) {
        SessionManager.validate((Session)ses, (String)"PISB::removeSubProcessPI(s,piid)");
        WFProcessContext pCtx = new WFProcessContext(ses, piid);
        pCtx.removeProcessInstance(true);
    }

    public void complete(Session ses, long piid) {
        SessionManager.validate((Session)ses, (String)"PISB::complete(s,piid)");
        WFProcessContext pCtx = new WFProcessContext(ses, piid);
        pCtx.completeProcessInstance();
    }

    public void complete(Session ses, long piid, HashMap dsValues) {
        SessionManager.validate((Session)ses, (String)"PISB::complete(s,piid,dsValues)");
        WFProcessContext pCtx = new WFProcessContext(ses, piid);
        pCtx.updateSlotValue(dsValues);
        pCtx.completeProcessInstance();
    }

    public String[] getActivatedWorkStepNames(Session ses, long piid) {
        SessionManager.validate((Session)ses, (String)"PISB::getActivatedWorkStepNames(s,piid)");
        WFProcessContext pCtx = new WFProcessContext(ses, piid);
        return pCtx.getActivatedWorkStepNames();
    }

    public String[] getSuspendedWorkStepNames(Session ses, long piid) {
        SessionManager.validate((Session)ses, (String)"PISB::getSuspendedWorkStepNames(s,piid)");
        WFProcessContext pCtx = new WFProcessContext(ses, piid);
        return pCtx.getSuspendedWorkStepNames();
    }

    public String[] getCompletedWorkStepNames(Session ses, long piid) {
        SessionManager.validate((Session)ses, (String)"PISB::getCompletedWorkStepNames(s,piid)");
        WFProcessContext pCtx = new WFProcessContext(ses, piid);
        return pCtx.getCompletedWorkStepNames();
    }

    public Vector getWorkStepExecutedList(Session ses, long piid) {
        SessionManager.validate((Session)ses, (String)"PISB::getWorkStepExecutedList(s,piid)");
        WFProcessContext pCtx = new WFProcessContext(ses, piid);
        ProcessInstanceEBLocal piEB = BLControl.util.getProcessInstanceEB(piid);
        String nodesVisited = piEB.getNodeVisited();
        return pCtx.getWorkStepExecutedList(nodesVisited);
    }

    public boolean isValidProcessInstance(Session ses, long piid) {
        SessionManager.validate((Session)ses, (String)"PISB::isValidProcessInstance(s,piid)");
        ProcessInstanceEBLocalHome home = BLControl.util.getProcessInstanceEBHome();
        try {
            home.findByPrimaryKey(piid);
        }
        catch (ObjectNotFoundException objExp) {
            return false;
        }
        catch (FinderException findExp) {
            return false;
        }
        return true;
    }

    public void save(Session ses, HashMap piModifiedAttrs) {
        SessionManager.validate((Session)ses, (String)"PISB::save(s,piAttrList)");
        if (piModifiedAttrs != null && !piModifiedAttrs.isEmpty()) {
            long piid = 0L;
            HashMap modifiedAttrs = null;
            Map.Entry entry2 = null;
            for (Map.Entry entry2 : piModifiedAttrs.entrySet()) {
                piid = (Long)entry2.getKey();
                modifiedAttrs = (HashMap)entry2.getValue();
                if (modifiedAttrs == null || modifiedAttrs.isEmpty()) continue;
                WFProcessContext pCtx = new WFProcessContext(ses, piid);
                pCtx.setProcessInstanceAttributes(modifiedAttrs);
            }
        }
    }

    public ProcessInstanceList getProcessInstanceList(Session ses, long ptid) {
        SessionManager.validate((Session)ses, (String)"PISB::getProcessInstanceList(s,ptid)");
        return SVOFactory.getProcessInstanceList(ses, new long[]{ptid}, null, null, null);
    }

    public ProcessInstanceList getActivatedProcessInstanceList(Session ses, long ptid) {
        SessionManager.validate((Session)ses, (String)"PISB::getActivedProcessInstanceList(s,ptid)");
        int[] nArray = new int[1];
        nArray[0] = 7;
        return SVOFactory.getProcessInstanceList(ses, new long[]{ptid}, null, nArray, null);
    }

    public ProcessInstanceList getSuspendedProcessInstanceList(Session ses, long ptid) {
        SessionManager.validate((Session)ses, (String)"PISB::getSuspendedProcessInstanceList(s,ptid)");
        int[] nArray = new int[1];
        nArray[0] = 8;
        return SVOFactory.getProcessInstanceList(ses, new long[]{ptid}, null, nArray, null);
    }

    public ProcessInstanceList getList(Session ses, long[] ptids, int[] states) {
        SessionManager.validate((Session)ses, (String)"PISB::getList(s,ptids,states)");
        return SVOFactory.getProcessInstanceList(ses, ptids, null, states, ses.getUser());
    }

    public ResultData<List<Long>> complete(Session ses, List<Long> idList) {
        SessionManager.validate((Session)ses, (String)"PISB::complete(s,idList)");
        return WFProcessInstance.self().completeByClient(ses, idList);
    }

    public ResultData<List<Long>> suspend(Session ses, List<Long> idList) {
        SessionManager.validate((Session)ses, (String)"PISB::suspend(s,idList)");
        return WFProcessInstance.self().suspendByClient(ses, idList);
    }

    public ResultData<List<Long>> resume(Session ses, List<Long> idList) {
        SessionManager.validate((Session)ses, (String)"PISB::resume(s,idList)");
        return WFProcessInstance.self().resumeByClient(ses, idList);
    }

    public ResultData<List<Long>> remove(Session ses, List<Long> idList) {
        SessionManager.validate((Session)ses, (String)"PISB::remove(s,idList)");
        return WFProcessInstance.self().removeByClient(ses, idList);
    }

    public DataSlotList getDataSlotList(Session session, long piid) {
        SessionManager.validate((Session)session, (String)"PISB::getDataSlotList(s,piid)");
        return SVOFactory.getDataSlotList(session, piid);
    }

    public DataSlotList getDataSlotList(Session session, long piid, boolean withMetaData) {
        return this.getDataSlotList(session, piid, withMetaData, true);
    }

    public DataSlotList getDataSlotList(Session session, long piid, boolean withMetaData, boolean isPublicOnly) {
        SessionManager.validate((Session)session, (String)"getDataSlotList(s,piid, withMetaData)");
        return SVOFactory.getDataSlotList(session, piid, withMetaData, isPublicOnly);
    }

    public void updateSlotValueForIM(Session session, long piid, HashMap dsValues) {
        SessionManager.validate((Session)session, (String)"PISB::updateSlotValueForIM(session, piid, dsValues)");
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        WFProcessInstance.self().updateSlotValueForIM(pCtx, dsValues);
    }

    public void updateSlotValue(Session session, long piid, HashMap dsValues) {
        SessionManager.validate((Session)session, (String)"PISB::updateSlotValue(session, piid, dsValues)");
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        pCtx.updateSlotValue(dsValues);
    }

    public void reactivateWorkStep(Session session, long piID, String wsName) {
        SessionManager.validate((Session)session, (String)"PISB::reactivateWorkStep(s, piID, wsName)");
        WFProcessContext pCtx = new WFProcessContext(session, piID);
        pCtx.reactivateWorkStep(wsName);
    }

    public ProcessInstance create(Session session, long parentID, String xmlDefinition, boolean removeOnCompletion) {
        WFProcessContext pCtx = null;
        SessionManager.validate((Session)session, (String)"PISB::create(session, parentID, xmlDefinition, removeOnCompletion)");
        pCtx = new WFProcessContext(session, parentID);
        long dpiid = pCtx.createDynamicProcessInstance(xmlDefinition, removeOnCompletion);
        return SVOFactory.getProcessInstance(session, dpiid);
    }

    public String getXML(Session session, long piID) {
        SessionManager.validate((Session)session, (String)"PISB::getXML(session, piID)");
        WFProcessContext pCtx = new WFProcessContext(session, piID);
        String xml = pCtx.getProcessInstanceEB().getParentID() == 0L ? ProcessXMLDAO.load(pCtx.getProcessTemplateID()) : ProcessInstanceXMLDAO.load(piID);
        if (xml == null) {
            throw new BizLogicException("BizLogic_ERR_2546", "ProcessInstanceSBBean.getXML");
        }
        return xml;
    }

    public HashMap getXMLWithData(Session session, long piID) {
        SessionManager.validate((Session)session, (String)"PISB::getXMLWithData(session, piID)");
        HashMap<String, Object> xmlData = new HashMap<String, Object>();
        WFProcessContext pCtx = new WFProcessContext(session, piID);
        xmlData.put("XML", this.getXML(session, piID));
        xmlData.put("WS_STATUS", WorkStepInstanceDAO.findStatusByProcessInstance(piID));
        HashMap mapDS = pCtx.getSlotValue(pCtx.getAllSlotName());
        xmlData.put("DS_VALUES", mapDS);
        return xmlData;
    }

    public WorkStepInstance getWorkStepInstance(Session session, long piID, String wsName) {
        SessionManager.validate((Session)session, (String)"PISB::getWorkStepInstance(s, piID, wsName)");
        return SVOFactory.getWorkStepInstance(session, piID, wsName);
    }

    public DataSlot getDataSlot(Session session, long piID, String dsName) {
        SessionManager.validate((Session)session, (String)"PISB::getDataSlot(s, piID, dsName)");
        return SVOFactory.getDataSlot(session, piID, dsName);
    }

    public Object getDataSlotValue(Session session, long piid, String dsName) {
        SessionManager.validate((Session)session, (String)"PISB::getDataSlotValue(s, piID, dsName)");
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        return pCtx.getSlotValue(dsName);
    }

    public HashMap getDataSlotValue(Session session, long piid, String[] dsNames) {
        SessionManager.validate((Session)session, (String)"PISB::getDataSlotValue(s, piID, dsNames)");
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        return pCtx.getSlotValue(dsNames);
    }

    public HashMap getDataSlotValue(Session session, long piid) {
        SessionManager.validate((Session)session, (String)"PISB::getDataSlotValue(s, piID)");
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        return pCtx.getAllSlotValue();
    }

    public WorkStepInstanceList getWorkStepInstanceList(Session session, long piid) throws RemoteException {
        SessionManager.validate((Session)session, (String)"PISB::getWorkStepInstanceList(s, piID)");
        return SVOFactory.getWorkStepInstanceList(session, null, new long[]{piid}, null, null);
    }

    public WorkStepInstanceList getWorkStepInstanceList(Session session, long piid, boolean inlcudeInlineActivities) throws RemoteException {
        SessionManager.validate((Session)session, (String)"PISB::getWorkStepInstanceList(s, piID, inlcudeInlineWS)");
        return SVOFactory.getWorkStepInstanceList(session, null, new long[]{piid}, null, null, inlcudeInlineActivities);
    }

    public WorkItemList getWorkItemList(Session session, long piid) throws RemoteException {
        SessionManager.validate((Session)session, (String)"PISB::getWorkItemList(s, piID)");
        return SVOFactory.getWorkItemList(session, null, new long[]{piid}, null, null);
    }

    public WorkItemList getUserWorkItemList(Session session, long piid, String performer) throws RemoteException {
        SessionManager.validate((Session)session, (String)"PISB::getUserWorkItemList(s, piID, performer)");
        return SVOFactory.getWorkItemList(session, null, new long[]{piid}, null, performer);
    }

    public Vector getWorkStepTemplateList(Session session, long piid) throws RemoteException {
        SessionManager.validate((Session)session, (String)"PISB::getWorkStepTemplateList(s, piID)");
        WFProcess ptObject = ProcessControl.getProcess(piid);
        Vector wst = SVOFactory.getWorkStepTemplateList(session, ptObject);
        return wst;
    }

    public Vector getWorkStepTemplateList(Session session, long piid, boolean inlcudeInlineActivities) throws RemoteException {
        SessionManager.validate((Session)session, (String)"PISB::getWorkStepTemplateList(s, piID, inlcudeInlineActivities)");
        WFProcess ptObject = ProcessControl.getProcess(piid);
        Vector wst = SVOFactory.getWorkStepTemplateList(session, ptObject, inlcudeInlineActivities);
        return wst;
    }

    public WorkStepTemplate getWorkStepTemplate(Session session, long piid, String wsName) {
        SessionManager.validate((Session)session, (String)"PISB::getWorkStepTemplate (s, piid, wsName");
        WFProcess ptObject = ProcessControl.getProcess(piid);
        return SVOFactory.getWorkStepTemplate(session, ptObject, wsName);
    }

    public ProcessTemplate getProcessTemplate(Session session, long piid) throws RemoteException {
        SessionManager.validate((Session)session, (String)"PISB::getProcessTemplate(s, piID)");
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        ProcessTemplate pt = SVOFactory.getProcessTemplate(session, pCtx);
        return pt;
    }

    public void reActivateWSForIM(Session session, long piid) throws RemoteException {
        SessionManager.validate((Session)session, (String)"PISB::reActivateWSForIM(s, piID)");
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        WFProcessInstance.self().reActivateWSForIM(pCtx);
    }

    public WorkStepInstanceList getWorkStepInstanceListForMilestone(Session session, long ptid, long piid) throws RemoteException {
        SessionManager.validate((Session)session, (String)"PISB::getWorkStepInstanceListForMilestone(s, ptID, piID)");
        return SVOFactory.getWorkStepInstanceListForMilestone(session, ptid, piid);
    }

    public boolean isExist(Session session, long piid) throws RemoteException {
        SessionManager.validate((Session)session, (String)"PISB::isExist(s, piid)");
        return ProcessInstanceDAO.isProcessInstanceExist(piid);
    }

    public ArrayList executeInstance(Session session, long piid, String startFromWS, HashMap dsValues) throws RemoteException {
        SessionManager.validate((Session)session, (String)"PISB::executeInstance(s, piid, startFromWS, dsValues)");
        return DebugService.self().executeInstance(session, piid, startFromWS, dsValues);
    }

    public void setDebug(Session session, long piid, boolean debug) throws RemoteException {
        SessionManager.validate((Session)session, (String)"PISB::enableInstanceDebugging(s, piid, debug)");
        if (debug) {
            DebugService.self().registerPI(piid);
        } else {
            DebugService.self().deRegisterPI(session, piid);
        }
    }

    public ProcessInstanceList getActiveSubProcessList(Session session, long piid, String wsName) throws RemoteException {
        SessionManager.validate((Session)session, (String)"PISB::getActiveSubProcessList(s, piid, wsName)");
        return SVOFactory.getActiveSubProcessList(session, piid, wsName);
    }

    public WorkStepInstance getParentWorkStepInstance(Session session, long subpiid) throws RemoteException {
        SessionManager.validate((Session)session, (String)"PISB::getParentWorkStepInstance(s, subpiid)");
        return SVOFactory.getParentWorkStepInstance(session, subpiid);
    }

    public ProcessNotes createProcessNotes(Session session, long piid, String notes, Map<String, Object> processNotesInfo) throws RemoteException {
        SessionManager.validate((Session)session, (String)"PISB::createProcessNotes(s, piid, notes, pNotesInfo)");
        processNotesInfo.put("NOTES_USER", session.getUser());
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        long notesID = pCtx.createProcessNotes(notes, processNotesInfo);
        return SVOFactory.getProcessNotes(session, notesID);
    }

    public long updateProcessNotes(Session session, long processNotesId, String newNotes) throws RemoteException {
        SessionManager.validate((Session)session, (String)"PISB::updateProcessNotes(s, pNotesId, newNotes)");
        String user = session.getUser();
        return WFProcessNotes.self().update(processNotesId, newNotes, user);
    }

    public void removeProcessNotes(Session session, long piid, long processNotesId) throws RemoteException {
        SessionManager.validate((Session)session, (String)"PISB::removeProcessNotes(s, pNotesId)");
        WFProcessNotes.self().remove(piid, processNotesId);
    }

    public Map<String, Integer> getUsersFromDataSlot(Session session, long piid, String dsName, boolean expandGroup, boolean allowQueue, boolean removeInvalid) throws RemoteException {
        SessionManager.validate((Session)session, (String)"PISB::getRealUsersFromDataSlot(s, ...)");
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        return pCtx.getRealUsersFromDataSlot(dsName, expandGroup, allowQueue, removeInvalid);
    }

    public long getProcessInstanceId(Session session, String ptName, String monitorDSValue) throws RemoteException {
        SessionManager.validate((Session)session, (String)"PISB::getProcessInstanceId(session, ptName, monitorDSValue)");
        return WFProcessInstance.self().getProcessInstanceId(session, ptName, monitorDSValue);
    }

    public ResultData<List<Long>> updateInstance(Session session, List<Long> piids, Map<String, Object> dsValues, Map<String, Object> attributes, boolean isMultiTrans) throws RemoteException {
        SessionManager.validate((Session)session, (String)"PISB::updateInstance(session, List, Map, Map, boolean)");
        return WFProcessInstance.self().updateInstance(session, piids, dsValues, attributes, isMultiTrans);
    }

    public ResultData<List<Long>> updateInstance(Session session, Map<Long, Map<String, Object>> dsValues, Map<Long, Map<String, Object>> attributes, boolean isMultiTrans) throws RemoteException {
        SessionManager.validate((Session)session, (String)"PISB::updateInstance(session, Map, Map, boolean)");
        return WFProcessInstance.self().updateInstance(session, dsValues, attributes, isMultiTrans);
    }

    public ResultData<List<Long>> removeInstance(Session session, List<Long> piids, boolean isMultiTrans) throws RemoteException {
        SessionManager.validate((Session)session, (String)"PISB::removeInstance(session, List, boolean)");
        return WFProcessInstance.self().removeInstance(session, piids, isMultiTrans);
    }

    public ResultData<List<Long>> suspendInstance(Session session, List<Long> piids, boolean isMultiTrans) throws RemoteException {
        SessionManager.validate((Session)session, (String)"PISB::suspendInstance(session, List, boolean)");
        return WFProcessInstance.self().suspendInstance(session, piids, isMultiTrans);
    }

    public ResultData<List<Long>> resumeInstance(Session session, List<Long> piids, boolean isMultiTrans) throws RemoteException {
        SessionManager.validate((Session)session, (String)"PISB::resumeInstance(session, List, boolean)");
        return WFProcessInstance.self().resumeInstance(session, piids, isMultiTrans);
    }
}

