/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.ejb;

import com.savvion.sbm.alerts.svo.Alert;
import com.savvion.sbm.alerts.svo.ProcessAlert;
import com.savvion.sbm.bizlogic.enums.PTState;
import com.savvion.sbm.bizlogic.server.ApplicationManager;
import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.WFInplaceProcessReplacement;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFProcessInstance;
import com.savvion.sbm.bizlogic.server.WFimportProcess;
import com.savvion.sbm.bizlogic.server.dao.ProcessInstanceDAO;
import com.savvion.sbm.bizlogic.server.dao.ProcessInstanceXMLDAO;
import com.savvion.sbm.bizlogic.server.dao.ProcessXMLDAO;
import com.savvion.sbm.bizlogic.server.svo.Application;
import com.savvion.sbm.bizlogic.server.svo.DataSlotTemplate;
import com.savvion.sbm.bizlogic.server.svo.ProcessInstance;
import com.savvion.sbm.bizlogic.server.svo.ProcessInstanceList;
import com.savvion.sbm.bizlogic.server.svo.ProcessTemplate;
import com.savvion.sbm.bizlogic.server.svo.ProcessTemplateList;
import com.savvion.sbm.bizlogic.server.svo.SVOFactory;
import com.savvion.sbm.bizlogic.server.svo.TimerActionList;
import com.savvion.sbm.bizlogic.server.svo.WorkStepInstanceList;
import com.savvion.sbm.bizlogic.server.svo.WorkStepTemplate;
import com.savvion.sbm.bizlogic.util.BLAlertService;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.bizlogic.util.SessionAdapter;
import com.savvion.sbm.bizlogic.util.SessionManager;
import com.savvion.sbm.util.LoggerUtil;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ProcessTemplateSBBean
extends SessionAdapter {
    public void remove(Session session, long ptid) {
        SessionManager.validate((Session)session, (String)"PTSB::remove(s, ptid)");
        ProcessControl.removeProcessTemplate(session, ptid, false);
    }

    public HashMap getAttributes(Session session, long pid, boolean dynamic) {
        SessionManager.validate((Session)session, (String)"PTSB::getAttributes(s,pid,dynamic)");
        WFProcess ptObject = ProcessControl.getProcess(pid, dynamic);
        return BLControl.util.convertPriorityToString(ptObject.getAttributes());
    }

    public void save(Session session, long pid, HashMap modifiedAttribs, boolean dynamic) {
        SessionManager.validate((Session)session, (String)"PTSB::save(s,pid,attrs,dynamic)");
        WFProcess ptObject = ProcessControl.getProcess(pid, dynamic);
        ptObject.setAttributes(modifiedAttribs);
    }

    public void save(Session session, HashMap modifiedAttribsByPTID) {
        SessionManager.validate((Session)session, (String)"PTSB::save(s, attrs)");
        if (modifiedAttribsByPTID != null && !modifiedAttribsByPTID.isEmpty()) {
            long ptid = 0L;
            HashMap modifiedAttrs = null;
            Map.Entry entry2 = null;
            for (Map.Entry entry2 : modifiedAttribsByPTID.entrySet()) {
                ptid = (Long)entry2.getKey();
                modifiedAttrs = (HashMap)entry2.getValue();
                if (modifiedAttrs == null || modifiedAttrs.isEmpty()) continue;
                WFProcess ptObject = ProcessControl.getProcess(ptid);
                ptObject.setAttributes(modifiedAttrs);
            }
        }
    }

    public void activate(Session session, long ptid) {
        SessionManager.validate((Session)session, (String)"PTSB::activate(s, ptid)");
        ProcessControl.activateProcessTemplate(ptid);
    }

    public void suspend(Session session, long ptid) {
        SessionManager.validate((Session)session, (String)"PTSB::suspend(s, ptid)");
        ProcessControl.suspendProcessTemplate(ptid);
    }

    public void suspend(Session session, Vector idList) {
        SessionManager.validate((Session)session, (String)"PTSB::suspend(s, idList)");
        if (idList != null) {
            for (int ix = idList.size() - 1; ix >= 0; --ix) {
                long ptid = (Long)idList.elementAt(ix);
                ProcessControl.suspendProcessTemplate(ptid);
            }
        }
    }

    public void resume(Session session, long ptid) {
        SessionManager.validate((Session)session, (String)"PTSB::resume(s, ptid)");
        ProcessControl.resumeProcessTemplate(ptid);
    }

    public void resume(Session session, Vector idList) {
        SessionManager.validate((Session)session, (String)"PTSB::resume(s, idList)");
        if (idList != null) {
            for (int ix = idList.size() - 1; ix >= 0; --ix) {
                long ptid = (Long)idList.elementAt(ix);
                ProcessControl.resumeProcessTemplate(ptid);
            }
        }
    }

    public Vector getDataSlotTemplateList(Session session, long pid, boolean dynamic) {
        SessionManager.validate((Session)session, (String)"PTSB::getDataSlotTemplateList(s,pid,dynamic)");
        WFProcess ptObject = ProcessControl.getProcess(pid, dynamic);
        return SVOFactory.getDataSlotTemplateList(session, ptObject);
    }

    public Vector getWorkStepTemplateList(Session session, long pid, boolean dynamic) {
        SessionManager.validate((Session)session, (String)"PTSB::getWorkStepTemplateList(s,pid,dynamic)");
        WFProcess ptObject = ProcessControl.getProcess(pid, dynamic);
        return SVOFactory.getWorkStepTemplateList(session, ptObject);
    }

    public Vector getWorkStepTemplateList(Session session, long pid, boolean dynamic, boolean inlcudeInlineActivities) {
        SessionManager.validate((Session)session, (String)"PTSB::getWorkStepTemplateList(s,pid,dynamic, inlcudeInlineActivities)");
        WFProcess ptObject = ProcessControl.getProcess(pid, dynamic);
        return SVOFactory.getWorkStepTemplateList(session, ptObject, inlcudeInlineActivities);
    }

    public WorkStepTemplate getWorkStepTemplate(Session session, long pid, String wsName, boolean dynamic) {
        SessionManager.validate((Session)session, (String)"PTSB::getWorkStepTemplate(s, pid, wsName, dynamic");
        WFProcess ptObject = ProcessControl.getProcess(pid, dynamic);
        return SVOFactory.getWorkStepTemplate(session, ptObject, wsName);
    }

    public int getProcessInstanceCount(Session session, long ptid) {
        SessionManager.validate((Session)session, (String)"PTSB::getProcessInstanceCount(s, ptid)");
        return ProcessInstanceDAO.getCount(ptid);
    }

    public int getActivatedProcessInstanceCount(Session session, long ptid) {
        SessionManager.validate((Session)session, (String)"PTSB::getActivatedProcessInstanceCount(s, ptid)");
        return ProcessInstanceDAO.getActiveCount(ptid);
    }

    public int getSuspendedProcessInstanceCount(Session session, long ptid) {
        SessionManager.validate((Session)session, (String)"PTSB::getSuspendedProcessInstanceCount(s, ptid)");
        return ProcessInstanceDAO.getSuspendedCount(ptid);
    }

    public ProcessInstance createProcessInstance(Session session, String ptName, HashMap attributes, HashMap dsValues, boolean toActivate) {
        SessionManager.validate((Session)session, (String)"PTSB::createProcessInstance(s,ptName,attrs,dsValues,toActivate)");
        HashMap attrs = WFProcessInstance.self().validateAttributesForCreateInstance(ptName, attributes);
        WFProcessContext pCtx = WFProcessContext.createProcessInstance(session, attrs, dsValues, toActivate);
        if (pCtx.getSVO() != null) {
            return pCtx.getSVO();
        }
        return SVOFactory.getProcessInstance(session, pCtx);
    }

    public void removeProcessInstance(Session session, long piid) {
        SessionManager.validate((Session)session, (String)"PTSB::removeProcessInstance(s, piid)");
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        if (pCtx.isSyncSubProcessInstance()) {
            throw new BizLogicException("BizLogic_ERR_596", "ProcessInstanceSBBean.remove", new Object[]{pCtx.getProcessInstanceName()});
        }
        pCtx.removeProcessInstance(false);
    }

    public ProcessInstance getProcessInstance(Session session, long piid) {
        SessionManager.validate((Session)session, (String)"PTSB::getProcessInstance(s, piid)");
        return SVOFactory.getProcessInstance(session, piid);
    }

    public ProcessInstanceList getProcessInstanceList(Session session, long[] piids) {
        SessionManager.validate((Session)session, (String)"PTSB::getProcessInstanceList(s, []piid)");
        return SVOFactory.getProcessInstanceList(session, null, piids, null, null);
    }

    public ProcessInstanceList getProcessInstanceList(Session session, long ptid) {
        SessionManager.validate((Session)session, (String)"PTSB::getProcessInstanceList(s, ptid)");
        return SVOFactory.getProcessInstanceList(session, new long[]{ptid}, null, null, null);
    }

    public ProcessInstanceList getActivatedProcessInstanceList(Session session, long ptid) {
        SessionManager.validate((Session)session, (String)"PTSB::getActivatedProcessInstanceList(s, ptid)");
        int[] nArray = new int[1];
        nArray[0] = 7;
        return SVOFactory.getProcessInstanceList(session, new long[]{ptid}, null, nArray, null);
    }

    public ProcessInstanceList getSuspendedProcessInstanceList(Session session, long ptid) {
        SessionManager.validate((Session)session, (String)"PTSB::getSuspendedProcessInstanceList(s, ptid)");
        int[] nArray = new int[1];
        nArray[0] = 8;
        return SVOFactory.getProcessInstanceList(session, new long[]{ptid}, null, nArray, null);
    }

    public Vector getDataSlotInfo(Session session, long pid, boolean dynamic) {
        SessionManager.validate((Session)session, (String)"PTSB::getDataSlotInfo(s,pid,dynamic)");
        WFProcess ptObject = ProcessControl.getProcess(pid, dynamic);
        return ptObject.getDataslotInfo();
    }

    public Hashtable getDataSlotInfo(Session session, long pid, String dsName, boolean dynamic) {
        SessionManager.validate((Session)session, (String)"PTSB::getDataSlotInfo(s,pid,dsName,dynamic)");
        WFProcess ptObject = ProcessControl.getProcess(pid, dynamic);
        return ptObject.getDataslotInfo(dsName);
    }

    public Vector getFYI(Session session, long pid, boolean dynamic) {
        SessionManager.validate((Session)session, (String)"PTSB::getFYI(s,pid,dynamic)");
        WFProcess ptObject = ProcessControl.getProcess(pid, dynamic);
        return ptObject.getFYI();
    }

    public String getXMLFileName(Session session, long pid, boolean dynamic) {
        SessionManager.validate((Session)session, (String)"PTSB::getXMLFileName(s, pid,dynamic)");
        WFProcess ptObject = ProcessControl.getProcess(pid, dynamic);
        return ptObject.getXMLFileName();
    }

    public Vector getRollbackPoints(Session session, long pID, boolean dynamic) {
        SessionManager.validate((Session)session, (String)"PTSB::getRollbackPoints(session,pID,dynamic)");
        WFProcess ptObject = ProcessControl.getProcess(pID, dynamic);
        return ptObject.getRollbackPoints();
    }

    public String getXML(Session session, long pID, boolean dynamic) {
        SessionManager.validate((Session)session, (String)"PTSB::getXML(session, pID,dynamic)");
        if (dynamic) {
            return ProcessInstanceXMLDAO.load(pID);
        }
        return ProcessXMLDAO.load(pID);
    }

    public ProcessTemplate createVersionAndGetTemplate(Session session, String xmlFileName, boolean activate) {
        SessionManager.validate((Session)session, (String)"PTSB::createVersionX(session, ptid, xmlFileName)");
        return ApplicationManager.createVersionAndGetTemplate(session, xmlFileName, activate);
    }

    public ProcessTemplateList getVersions(Session session, long ptid) {
        SessionManager.validate((Session)session, (String)"PTSB::getVersions(session, ptid)");
        Collection ptList = ProcessControl.getVersions(ptid);
        return SVOFactory.getProcessTemplateList(session, ptList);
    }

    public ProcessTemplate getParent(Session session, long ptid) {
        SessionManager.validate((Session)session, (String)"PTSB::getParent(session, ptid)");
        if (ProcessControl.isProcessTemplateExist(ptid)) {
            return SVOFactory.getProcessTemplate(session, ptid);
        }
        return null;
    }

    public void setString(String s) {
    }

    public String getString() {
        return "Goooooooo Onnnnnnn";
    }

    public void setAmount(long amt) {
    }

    public long getAmount() {
        return 50000L;
    }

    public void setConsent(boolean cons) {
    }

    public boolean getConsent() {
        return false;
    }

    public void setMyObjectDS(Object obj) {
    }

    public Object getMyObjectDS() {
        return new Hashtable();
    }

    public void execute() {
        LoggerUtil.logSOP((Object)"********* ********************************");
        LoggerUtil.logSOP((Object)"********* INSIDE NEW EP *****************");
    }

    public WorkStepTemplate getStartWorkStep(Session session, long pid, boolean dynamic) {
        SessionManager.validate((Session)session, (String)"PTSB::getStartWorkStep(s,pid,dynamic)");
        WFProcess pt = ProcessControl.getProcess(pid, dynamic);
        return SVOFactory.getWorkStepTemplate(session, pt, pt.getStartWorkStepName());
    }

    public Vector getDataSlotTemplateList(Session session, long pid, Vector dsNames, boolean dynamic) {
        SessionManager.validate((Session)session, (String)"PTSB::getDataSlotTemplateList(s,pid,dsNames,dynamic)");
        if (dsNames == null || dsNames.isEmpty()) {
            return null;
        }
        String[] sa = new String[dsNames.size()];
        sa = dsNames.toArray(sa);
        WFProcess ptObject = ProcessControl.getProcess(pid, dynamic);
        return SVOFactory.getDataSlotTemplateList(session, ptObject, sa, false);
    }

    public DataSlotTemplate getDataSlotTemplate(Session session, long pid, String dsName, boolean dynamic) {
        SessionManager.validate((Session)session, (String)"PTSB::getDataSlotTemplate(s,pid,dsName,dynamic)");
        if (dsName == null || "".equals(dsName)) {
            return null;
        }
        WFProcess pt = ProcessControl.getProcess(pid, dynamic);
        return SVOFactory.getDataSlotTemplate(session, pt, dsName);
    }

    public TimerActionList getOverDueAction(Session session, long pid, boolean dynamic) {
        SessionManager.validate((Session)session, (String)"PTSB::getOverDueAction(session,pid,dynamic)");
        WFProcess pt = ProcessControl.getProcess(pid, dynamic);
        return pt.getOverDueAction();
    }

    public void remove(Session session, Vector idList) {
        SessionManager.validate((Session)session, (String)"PTSB::remove(s,idList)");
        if (idList == null || idList.isEmpty()) {
            return;
        }
        long[] ptids = new long[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            ptids[i] = (Long)idList.elementAt(i);
        }
        ProcessControl.removeProcessTemplate(session, ptids, false);
    }

    public long removeAllProcessInstance(Session session, long ptid) {
        SessionManager.validate((Session)session, (String)"PTSB::removeAllProcessInstance(session, ptid)");
        return ProcessControl.removeAllProcessInstances(session, ptid);
    }

    public Vector getDataSlotNameList(Session session, long pid, boolean dynamic) {
        SessionManager.validate((Session)session, (String)"PTSB::getDataSlotNameList(session,pid,dynamic)");
        WFProcess pt = ProcessControl.getProcess(pid, dynamic);
        return pt.getDataSlotNames();
    }

    public ProcessTemplate replace(Session session, long ptid) {
        SessionManager.validate((Session)session, (String)"replace(s,ptid)");
        return ProcessControl.replace(session, ptid, null);
    }

    public ProcessTemplate replace(Session session, long ptid, String xmldefinition) {
        SessionManager.validate((Session)session, (String)"replace(s,ptid,xmldefinition)");
        return ProcessControl.replace(session, ptid, xmldefinition);
    }

    public void updateNewDataSlotsForPTR(Session session, long ptid) {
        SessionManager.validate((Session)session, (String)"updateNewDataSlotsForPTR(session, ptid)");
        if (BLUtil.self().isPTRNewDSUpdate()) {
            throw new BizLogicException("BizLogic_ERR_4647", "ProcessInstanceSBBean.updateNewDataSlotsForPTR()");
        }
        ProcessControl.updateNewDataSlotsForPTR(session, ptid);
    }

    public void createDataSlotIndexesForPTR(Session session, long ptid) {
        SessionManager.validate((Session)session, (String)"createDataSlotIndexesForPTR(session, ptid)");
        ProcessControl.updateDataSlotIndexes(ptid);
    }

    public HashMap validateForUpdate(Session session, long ptid, String xmldefinition) {
        SessionManager.validate((Session)session, (String)"validateForUpdate(s,ptid,xmldefinition)");
        WFProcess pt = ProcessControl.getProcessTemplate(ptid);
        if (xmldefinition == null) {
            xmldefinition = pt.getName() + ".xml";
        }
        WFInplaceProcessReplacement ipr = new WFInplaceProcessReplacement(pt, session);
        HashMap extrace = ipr.validateForUpdate(xmldefinition);
        ipr = null;
        return extrace;
    }

    public HashMap validateForUpdate(Session session, long ptid) {
        SessionManager.validate((Session)session, (String)"validateForUpdate(s,ptid)");
        WFProcess pt = ProcessControl.getProcessTemplate(ptid);
        WFInplaceProcessReplacement ipr = new WFInplaceProcessReplacement(pt, session);
        HashMap extrace = ipr.validateForUpdate(pt.getName() + ".xml");
        ipr = null;
        return extrace;
    }

    public ProcessInstanceList getProcessInstanceList(Session session, long ptid, String milestoneName) {
        SessionManager.validate((Session)session, (String)"getProcessInstanceList(s, ptid, milestoneName)");
        return SVOFactory.getProcessInstanceList(session, ptid, milestoneName);
    }

    public WorkStepInstanceList getWorkStepInstanceList(Session session, long ptid, String milestoneName) {
        SessionManager.validate((Session)session, (String)"getWorkStepInstanceList(s, ptid, milestoneName)");
        return SVOFactory.getWorkStepInstanceList(session, ptid, milestoneName);
    }

    public Map getMilestoneList(Session session, long ptid) {
        SessionManager.validate((Session)session, (String)"getMilestoneList(s, ptid)");
        WFProcess pt = ProcessControl.getProcessTemplate(ptid);
        return pt.getMilestoneList();
    }

    public String getMilestoneDescription(Session session, long ptid, String milestoneName) {
        SessionManager.validate((Session)session, (String)"getMilestoneDescription(s, ptid, milestoneName)");
        WFProcess pt = ProcessControl.getProcessTemplate(ptid);
        return pt.getMilestoneDescription(milestoneName);
    }

    public boolean isApplicationExist(Session session, String appName) {
        SessionManager.validate((Session)session, (String)"isApplicationExist(s, appName)");
        return ApplicationManager.isApplicationExist(appName);
    }

    public Application createVersion(Session session, String xmlDefinition, boolean activate) {
        SessionManager.validate((Session)session, (String)"createVersion(s, xml)");
        return ApplicationManager.createVersion(session, xmlDefinition, activate);
    }

    public boolean isExist(Session session, String ptName) {
        SessionManager.validate((Session)session, (String)"isExist(s, ptName)");
        return ProcessControl.isProcessTemplateExist(ptName);
    }

    public boolean isExist(Session session, long ptid) {
        SessionManager.validate((Session)session, (String)"isExist(s, ptid)");
        return ProcessControl.isProcessTemplateExist(ptid);
    }

    public ProcessTemplateList getProcessTemplateList(Session session, String category, String subCategory) {
        SessionManager.validate((Session)session, (String)"getProcessTemplateList (s, category, subCategory)");
        return SVOFactory.getProcessTemplateList(session, category, subCategory);
    }

    public List<ProcessTemplate> getList(Session session, EnumSet<PTState> ptStates) {
        SessionManager.validate((Session)session, (String)"getList(s, ptStateEnum)");
        return SVOFactory.getProcessTemplates(session, ptStates);
    }

    public Map<String, PTState> getNames(Session session) {
        SessionManager.validate((Session)session, (String)"getNames(s)");
        return ProcessControl.getTemplateNames();
    }

    public List<Alert> getAlertInfo(Session session, String ptName) {
        SessionManager.validate((Session)session, (String)"getAlertInfo (s, ptName)");
        return BLAlertService.single().getAlertInfo(ptName);
    }

    public List<ProcessAlert> getWSAlertInfo(Session session, String ptName) {
        SessionManager.validate((Session)session, (String)"getWSAlertInfo (s, ptName)");
        return BLAlertService.single().getWSAlertInfo(ptName);
    }

    public boolean isAlertCacheEnabled(Session session) {
        SessionManager.validate((Session)session, (String)"isAlertCacheEnabled (s)");
        return BLAlertService.single().isAlertCacheEnabled();
    }

    public void enableAlertCache(Session session) {
        SessionManager.validate((Session)session, (String)"enableAlertCache (s)");
        BLAlertService.single().enableAlertCache();
    }

    public void disableAlertCache(Session session) {
        SessionManager.validate((Session)session, (String)"disableAlertCache (s)");
        BLAlertService.single().disableAlertCache();
    }

    public void clearAlertCache(Session session, String ptName) {
        SessionManager.validate((Session)session, (String)"clearAlertCache (s, ptName)");
        BLAlertService.single().clearAlertCache(ptName);
    }

    public void clearAlertCache(Session session) {
        SessionManager.validate((Session)session, (String)"clearAlertCache (s)");
        BLAlertService.single().clearAlertCache();
    }

    public Map<String, List<WorkStepTemplate>> getWorkstepTemplates(Session session, String appName, int wsType) {
        SessionManager.validate((Session)session, (String)"getActivityWorkstepNames(s,appName,wsType)");
        return ApplicationManager.getWorkstepTemplates(session, appName, wsType);
    }

    public Map<String, Map<String, List<WorkStepTemplate>>> getWorkstepTemplates(Session session, int wsType) {
        SessionManager.validate((Session)session, (String)"getActivityWorkstepNames(s,wsType)");
        return ApplicationManager.getWorkstepTemplates(session, wsType);
    }

    public void updateGlobalDataSlot(Session session, long ptid, String dsName, Object dsValue) {
        SessionManager.validate((Session)session, (String)"updateGlobalDataSlot(s,ptid,dsName,dsValue)");
        ProcessControl.updateGlobalDSValue(session, ptid, dsName, dsValue);
    }

    public void updateGlobalDataSlots(Session session, long ptid, Map<String, Object> dsValues) {
        SessionManager.validate((Session)session, (String)"updateGlobalDataSlots(s,ptid,dsValues)");
        ProcessControl.updateGlobalDSValues(session, ptid, dsValues);
    }

    public Object getGlobalDataSlot(Session session, long ptid, String dsName) {
        SessionManager.validate((Session)session, (String)"getGlobalDataSlot(s,ptid,dsName)");
        return ProcessControl.getGlobalDSValue(session, ptid, dsName);
    }

    public Map<String, Object> getGlobalDataSlots(Session session, long ptid) {
        SessionManager.validate((Session)session, (String)"getGlobalDataSlots(s,ptid)");
        return ProcessControl.getGlobalDSValues(session, ptid);
    }

    public ProcessTemplate reinstall(Session session, String ptName, boolean forceRemoveInstances) {
        SessionManager.validate((Session)session, (String)"PTSB::reinstallProcessTemplate(session,ptName,force)");
        return ProcessControl.reinstallProcessTemplate(session, ptName, forceRemoveInstances);
    }

    public void remove(Session session, String ptName, boolean removePi) {
        SessionManager.validate((Session)session, (String)"PTSB::remove(ses, ptName, removePi)");
        ProcessControl.removeProcessTemplate(session, ProcessControl.getProcessTemplateId(ptName), removePi);
    }

    public ProcessTemplate replace(Session session, String ptName) {
        SessionManager.validate((Session)session, (String)"PTSB::replace(ses, ptName)");
        return ProcessControl.replace(session, ProcessControl.getProcessTemplateId(ptName), null);
    }

    public void suspend(Session session, String ptName) {
        SessionManager.validate((Session)session, (String)"PTSB::suspend(ses, ptName)");
        ProcessControl.suspendProcessTemplate(ProcessControl.getProcessTemplateId(ptName));
    }

    public void resume(Session session, String ptName) {
        SessionManager.validate((Session)session, (String)"PTSB::resume(ses, ptName)");
        ProcessControl.resumeProcessTemplate(ProcessControl.getProcessTemplateId(ptName));
    }

    public Map<String, Object> validateProcessTemplate(Session session, String processXMLDefinition) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        SessionManager.validate((Session)session, (String)"validateProcessTemplate(s,processXMLDefinition)");
        try {
            new WFimportProcess(processXMLDefinition, 0, -1L);
            result.put("RESULT", "SUCCESS");
        }
        catch (Exception e) {
            result.put("RESULT", "FAILED");
            result.put("FAILEDREASON", e.getMessage());
        }
        return result;
    }
}

