/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.ejb;

import com.savvion.sbm.bizlogic.server.dao.WorkItemDAO;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.EntityAdapter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;

public class WorkItemEBBBean
extends EntityAdapter {
    public Long id;
    public long processTemplateID;
    public long processInstanceID;
    public long workStepID;
    public String workStepName;
    public long timeStarted;
    public long timeCompleted;
    public int state;
    public int previousState;
    public String name;
    public String performer;
    public String previousPerformer;
    public long dueDate;
    public int priority;
    public String response;
    public long readTime;

    public Long getId() {
        return this.id;
    }

    public long getProcessTemplateID() {
        return this.processTemplateID;
    }

    public long getProcessInstanceID() {
        return this.processInstanceID;
    }

    public long getWorkStepID() {
        return this.workStepID;
    }

    public String getWorkStepName() {
        return this.workStepName;
    }

    public long getTimeStarted() {
        return this.timeStarted;
    }

    public long getTimeCompleted() {
        return this.timeCompleted;
    }

    public int getState() {
        return this.state;
    }

    public int getPreviousState() {
        return this.previousState;
    }

    public String getName() {
        return this.name;
    }

    public String getPerformer() {
        return this.performer;
    }

    public String getPreviousPerformer() {
        return this.previousPerformer;
    }

    public long getDueDate() {
        return this.dueDate;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getResponse() {
        return this.response;
    }

    public long getReadTime() {
        return this.readTime;
    }

    public void setTimeStarted(long timeStarted) {
        this.timeStarted = timeStarted;
        this.modifiedAttrs.put("STARTTIME", timeStarted);
    }

    public void setTimeCompleted(long timeCompleted) {
        this.timeCompleted = timeCompleted;
        this.modifiedAttrs.put("ENDTIME", timeCompleted);
    }

    public void setState(int state) {
        this.setPreviousState();
        this.state = state;
        this.modifiedAttrs.put("STATUS", state);
    }

    public void setPreviousState() {
        this.previousState = this.getState();
        this.modifiedAttrs.put("PREVIOUSSTATUS", this.previousState);
    }

    public void restorePreviousState() {
        this.setState(this.getPreviousState());
    }

    public void setName(String name) {
        this.name = name;
        this.modifiedAttrs.put("WORKITEMNAME", name);
    }

    public void setPerformer(String performer) {
        this.performer = performer;
        this.modifiedAttrs.put("PERFORMER", performer);
    }

    public void setPreviousPerformer(String performer) {
        this.previousPerformer = performer;
        this.modifiedAttrs.put("PREVIOUSASSIGNEE", performer);
    }

    public void setDueDate(long dueDate) {
        this.dueDate = dueDate;
        this.modifiedAttrs.put("DUEDATE", dueDate);
    }

    public void setPriority(int priority) {
        this.priority = priority;
        this.modifiedAttrs.put("PRIORITY", priority);
    }

    public void setResponse(String response) {
        this.response = response;
        this.modifiedAttrs.put("RESPONSE", response);
    }

    public void setReadTime(long readTime) {
        this.readTime = readTime;
        if (readTime == -1L) {
            this.modifiedAttrs.put("READTIME", null);
        } else {
            this.modifiedAttrs.put("READTIME", readTime);
        }
    }

    public HashMap getAttributes() {
        HashMap<String, Object> attrsList = new HashMap<String, Object>();
        attrsList.put("WORKITEMID", this.id);
        attrsList.put("PROCESSTEMPLATEID", this.processTemplateID);
        attrsList.put("PROCESSINSTANCEID", this.processInstanceID);
        attrsList.put("WORKSTEPID", this.workStepID);
        attrsList.put("WORKSTEPNAME", this.workStepName);
        attrsList.put("STARTTIME", this.timeStarted);
        attrsList.put("STATUS", this.state);
        attrsList.put("WORKITEMNAME", this.name);
        attrsList.put("PERFORMER", this.performer);
        attrsList.put("DUEDATE", this.dueDate);
        attrsList.put("PRIORITY", this.priority);
        attrsList.put("PREVIOUSASSIGNEE", this.previousPerformer);
        attrsList.put("RESPONSE", this.response);
        attrsList.put("READTIME", this.readTime);
        return attrsList;
    }

    public void ejbHomeDelete(Long wiid) throws RemoveException {
        WorkItemDAO.remove(wiid);
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"WIEB", "ejbHomeDelete()", this.getPrimaryKey(wiid), this};
            BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
        }
    }

    public void ejbHomeDeleteByProcessInstance(long piid) throws RemoveException {
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"WIEB", "ejbHomeDeleteByProcessInstance()", this};
            BLControl.logger.debugKey("BizLogic_ERR_1201", largs);
        }
        WorkItemDAO.removeByProcessInstance(piid);
    }

    public void ejbHomeDeleteByWorkStepInstance(long piid, long wsid) throws RemoveException {
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"WIEB", "ejbHomeDeleteByWorkStepInstance()", this};
            BLControl.logger.debugKey("BizLogic_ERR_1201", largs);
        }
        WorkItemDAO.removeByWorkStepInstance(piid, wsid);
    }

    public Long ejbCreate(HashMap attrsList) throws CreateException {
        Iterator keySet = attrsList.keySet().iterator();
        String key = null;
        Object value = null;
        while (keySet.hasNext()) {
            key = (String)keySet.next();
            value = attrsList.get(key);
            if (key.equalsIgnoreCase("WORKITEMID")) {
                this.id = value;
                continue;
            }
            if (key.equalsIgnoreCase("PROCESSTEMPLATEID")) {
                this.processTemplateID = value;
                continue;
            }
            if (key.equalsIgnoreCase("PROCESSINSTANCEID")) {
                this.processInstanceID = value;
                continue;
            }
            if (key.equalsIgnoreCase("WORKSTEPID")) {
                this.workStepID = value;
                continue;
            }
            if (key.equalsIgnoreCase("WORKSTEPNAME")) {
                this.workStepName = value;
                continue;
            }
            if (key.equalsIgnoreCase("STARTTIME")) {
                this.timeStarted = value;
                continue;
            }
            if (key.equalsIgnoreCase("STATUS")) {
                this.state = value;
                continue;
            }
            if (key.equalsIgnoreCase("WORKITEMNAME")) {
                this.name = value;
                continue;
            }
            if (key.equalsIgnoreCase("PERFORMER")) {
                this.performer = value;
                continue;
            }
            if (key.equalsIgnoreCase("DUEDATE")) {
                this.dueDate = value;
                continue;
            }
            if (key.equalsIgnoreCase("PRIORITY")) {
                this.priority = value;
                continue;
            }
            if (key.equalsIgnoreCase("PREVIOUSASSIGNEE")) {
                this.previousPerformer = value;
                continue;
            }
            if (key.equalsIgnoreCase("RESPONSE")) {
                this.response = value;
                continue;
            }
            Object[] eargs = new Object[]{"WIEB.create()", key, value};
            throw new BizLogicException("BizLogic_ERR_1506", "WorkItemEBBean.ejbCreate", eargs);
        }
        WorkItemDAO.create(attrsList);
        this.setLoaded(true);
        this.modifiedAttrs = new HashMap();
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"WIEB", "ejbCreate()", this.getPrimaryKey(), this};
            BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
        }
        return this.id;
    }

    public void ejbPostCreate(HashMap attrsList) {
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"WIEB", "ejbPostCreate()", this.getPrimaryKey(), this};
            BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
        }
    }

    public Long ejbFindByPrimaryKey(Long wiid) throws ObjectNotFoundException {
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"WIEB", "ejbFindByPrimaryKey()", this.getPrimaryKey(wiid), this};
            BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
        }
        return WorkItemDAO.findByPrimaryKey(wiid);
    }

    public Collection ejbFindByWorkStepInstance(long piid, long wsid) throws ObjectNotFoundException {
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"WIEB", "ejbFindByWorkStepInstance()", this};
            BLControl.logger.debugKey("BizLogic_ERR_1201", largs);
        }
        return WorkItemDAO.findByWorkStepInstance(piid, wsid);
    }

    public void ejbActivate() {
        this.setLoaded(false);
        this.modifiedAttrs = new HashMap();
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"WIEB", "ejbActivate()", this.getPrimaryKey(), this};
            BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
        }
    }

    public void ejbPassivate() {
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"WIEB", "ejbPassivate()", this.getPrimaryKey(), this};
            BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
        }
        this.setLoaded(false);
        this.modifiedAttrs = new HashMap();
        this.clean();
    }

    public void ejbLoad() {
        Object[] largs;
        if (BLControl.util.DEBUG_ENTITY) {
            largs = new Object[]{"WIEB", "ejbLoad()", this.getPrimaryKey(), this};
            BLControl.logger.debugKey("BizLogic_ERR_1208", largs);
        }
        if (this.isLoadRequired()) {
            this.load();
            if (BLControl.util.DEBUG_ENTITY) {
                largs = new Object[]{"WIEB", "ejbLoad()", this.getPrimaryKey(), this};
                BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
            }
        }
    }

    private void load() {
        Long wiid = (Long)this.ctx.getPrimaryKey();
        WorkItemDAO.load(this, wiid);
        this.setLoaded(true);
        this.modifiedAttrs = new HashMap();
    }

    public void ejbStore() {
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"WIEB", "ejbStore()", this.getPrimaryKey(), this};
            BLControl.logger.debugKey("BizLogic_ERR_1208", largs);
        }
        if (!this.modifiedAttrs.isEmpty()) {
            Long wiid = (Long)this.ctx.getPrimaryKey();
            WorkItemDAO.store(this, wiid, this.modifiedAttrs);
            this.modifiedAttrs = new HashMap();
            if (BLControl.util.DEBUG_ENTITY) {
                Object[] largs = new Object[]{"WIEB", "ejbStore()", this.getPrimaryKey(), this};
                BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
            }
        }
    }

    public void ejbRemove() throws RemoveException {
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"WIEB", "ejbRemove()", this.getPrimaryKey(), this};
            BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
        }
        Long wiid = (Long)this.ctx.getPrimaryKey();
        this.setLoaded(false);
        this.clean();
        WorkItemDAO.remove(wiid);
    }

    public Collection ejbFindByName(String wiName) throws ObjectNotFoundException {
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"WIEB", "ejbFindByName()", this};
            BLControl.logger.debugKey("BizLogic_ERR_1201", largs);
        }
        return WorkItemDAO.findByName(wiName);
    }

    public Collection ejbFindByPerformer(String performer) throws ObjectNotFoundException {
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"WIEB", "ejbFindByPerformer(), this"};
            BLControl.logger.debugKey("BizLogic_ERR_1201", largs);
        }
        return WorkItemDAO.findByPerformer(performer);
    }

    protected final void clean() {
        Long id = -1L;
        this.processTemplateID = -1L;
        this.processInstanceID = -1L;
        this.workStepID = -1L;
        this.workStepName = null;
        this.timeStarted = -1L;
        this.timeCompleted = -1L;
        this.state = 0;
        this.previousState = 0;
        this.name = null;
        this.performer = null;
        this.previousPerformer = null;
        this.dueDate = -1L;
        this.priority = 0;
        this.response = null;
        this.readTime = 0L;
    }

    private String getPrimaryKey(long wiid) {
        StringBuilder parameters = new StringBuilder("wiid=");
        parameters.append(wiid);
        return parameters.toString();
    }

    private String getPrimaryKey() {
        long wiid = -1L;
        if (this.id != null) {
            wiid = this.id;
        }
        return this.getPrimaryKey(wiid);
    }
}

