/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.server.ejb.DataSlotSB;
import com.savvion.sbm.bizlogic.server.ejb.DataSlotSBHome;
import com.savvion.sbm.bizlogic.server.svo.AbstractDataSlot;
import com.savvion.sbm.bizlogic.server.svo.DateTime;
import com.savvion.sbm.bizlogic.server.svo.Decimal;
import com.savvion.sbm.bizlogic.server.svo.DocumentDS;
import com.savvion.sbm.bizlogic.server.svo.XML;
import com.savvion.sbm.bizlogic.util.BizLogicClientException;
import com.savvion.sbm.util.SBMHomeFactory;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.HashMap;
import javax.ejb.EJBObject;

public class DataSlot
extends AbstractDataSlot {
    private final long piid;

    DataSlot(long ptid, long piid, String name, Object value, HashMap metaData) {
        super(ptid, name, value, metaData);
        this.piid = piid;
    }

    @Override
    public HashMap getMetaData() throws BizLogicClientException {
        if (this.metaData == null && !this.isSystemDataSlot()) {
            try {
                this.metaData = ((DataSlotSB)this.getRemoteRef()).getAttributes(this.getSession(), this.piid, this.getName());
            }
            catch (RemoteException ex) {
                throw new BizLogicClientException("BizLogic_ERR_1532", new Object[]{"checkMetaDataRead", "dataslot", this.getName(), ex.getMessage()}, (Throwable)ex);
            }
        }
        return this.metaData;
    }

    public long getProcessInstanceID() {
        return this.piid;
    }

    @Override
    protected EJBObject findRemoteRef() throws BizLogicClientException {
        try {
            SBMHomeFactory sbmHome = SBMHomeFactory.self();
            DataSlotSBHome home = (DataSlotSBHome)sbmHome.lookupHome(DataSlotSBHome.class);
            DataSlotSB ref = home.create();
            return ref;
        }
        catch (Exception e) {
            throw new BizLogicClientException("BizLogic_ERR_1527", new Object[]{this.getName()}, (Throwable)e);
        }
    }

    @Override
    public void save() throws BizLogicClientException, RemoteException {
        DocumentDS docDS;
        if (this.isValueModified && this.isXML() && this.value == null) {
            throw new BizLogicClientException("BizLogic_ERR_4642", new Object[]{this.getName()});
        }
        if (this.isValueModified && this.isDocument() && this.value == null) {
            throw new BizLogicClientException("BizLogic_ERR_3571", new Object[]{this.getName(), this.getProcessTemplateID(), this.getProcessInstanceID()});
        }
        if (this.isDocument() && this.value != null) {
            docDS = (DocumentDS)this.value;
            this.isValueModified = docDS.isModified();
        }
        if (!this.isValueModified || this.isSystemDataSlot()) {
            return;
        }
        ((DataSlotSB)this.getRemoteRef()).setValue(this.getSession(), this.getProcessInstanceID(), this.getName(), this.value);
        this.isValueModified = false;
        if (this.isDocument() && this.value != null) {
            docDS = (DocumentDS)this.value;
            docDS.clean();
        }
    }

    public void incrementLongDS(long value) throws BizLogicClientException, RemoteException {
        if (!this.isLong()) {
            throw new BizLogicClientException("BizLogic_ERR_3674", new Object[]{this.getProcessTemplateID(), this.getProcessInstanceID(), this.getName()});
        }
        if (this.isSystemDataSlot()) {
            throw new BizLogicClientException("BizLogic_ERR_4531", new Object[]{"incrementLongDS", this.getName()});
        }
        ((DataSlotSB)this.getRemoteRef()).incrementLongDS(this.getSession(), this.getProcessInstanceID(), this.getName(), value);
    }

    public void appendStringDS(String value) throws BizLogicClientException, RemoteException {
        if (!this.isString()) {
            throw new BizLogicClientException("BizLogic_ERR_3680", new Object[]{this.getProcessTemplateID(), this.getProcessInstanceID(), this.getName()});
        }
        if (value == null || value.length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_4630", new Object[]{this.getName(), this.getProcessTemplateID(), this.getProcessInstanceID()});
        }
        if (this.isSystemDataSlot()) {
            throw new BizLogicClientException("BizLogic_ERR_4531", new Object[]{"appendStringDS", this.getName()});
        }
        ((DataSlotSB)this.getRemoteRef()).appendStringDS(this.getSession(), this.getProcessInstanceID(), this.getName(), value);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String format) {
        if (this.value == null) {
            return null;
        }
        if (format == null) {
            format = "0.0#####";
        }
        if (this.isDouble()) {
            double dblValue = (Double)this.value;
            return this.formatDouble(format, dblValue);
        }
        if (this.isDecimal()) {
            Decimal decimal = (Decimal)this.value;
            if (decimal.isNull()) {
                return null;
            }
            return decimal.getValue().toPlainString();
        }
        return this.value.toString();
    }

    private String formatDouble(String pattern, double value) {
        StringBuffer str = new StringBuffer();
        DecimalFormat format = new DecimalFormat(pattern);
        FieldPosition fp = new FieldPosition(0);
        format.format(value, str, fp);
        return str.toString();
    }

    @Override
    public Object getValue() {
        return super.getValue();
    }

    @Override
    public boolean isNull() {
        if (this.isDocument()) {
            if (this.value != null) {
                DocumentDS docDS = (DocumentDS)this.value;
                return docDS.isNull();
            }
        } else if (this.isXML()) {
            if (this.value != null) {
                XML xmlDS = (XML)this.value;
                return xmlDS.isNull();
            }
        } else if (this.isDateTime()) {
            if (this.value != null) {
                DateTime dateTimeDS = (DateTime)this.value;
                return dateTimeDS.isNull();
            }
        } else if (this.isDecimal() && this.value != null) {
            Decimal decDS = (Decimal)this.value;
            return decDS.isNull();
        }
        return super.isNull();
    }
}

