/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.client.queryservice.ProcessNotesFilter;
import com.savvion.sbm.bizlogic.client.queryservice.QSProcessNotes;
import com.savvion.sbm.bizlogic.client.queryservice.QSProcessNotesFilter;
import com.savvion.sbm.bizlogic.server.ejb.BLServer;
import com.savvion.sbm.bizlogic.server.ejb.BLServerHome;
import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceSB;
import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceSBHome;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceSB;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceSBHome;
import com.savvion.sbm.bizlogic.server.svo.BLProcess;
import com.savvion.sbm.bizlogic.server.svo.BLProcessInterface;
import com.savvion.sbm.bizlogic.server.svo.DateTime;
import com.savvion.sbm.bizlogic.server.svo.ProcessInstance;
import com.savvion.sbm.bizlogic.server.svo.ProcessNotes;
import com.savvion.sbm.bizlogic.server.svo.ProcessNotesList;
import com.savvion.sbm.bizlogic.server.svo.ProcessTemplate;
import com.savvion.sbm.bizlogic.server.svo.WorkItem;
import com.savvion.sbm.bizlogic.server.svo.WorkItemList;
import com.savvion.sbm.bizlogic.server.svo.WorkStepTemplate;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicClientException;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.Session;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.ejb.EJBObject;

public class WorkStepInstance
extends BLProcess
implements BLProcessInterface {
    private ProcessInstance parent;

    WorkStepInstance(Session session, HashMap attributes) {
        BLConstants.single();
        super(session, (Long)attributes.get("WORKSTEPID"), attributes);
        this.parent = null;
        this.modifiedAttrs = new HashMap();
    }

    public int getType() {
        BLConstants.single();
        return (Integer)this.attributes.get("TYPE");
    }

    public String getTypeString() {
        return WorkStepInstance.getStringWSType(this.getType());
    }

    public int getLoopCounter() {
        BLConstants.single();
        if (this.attributes.get("LOOPCOUNTER") == null) {
            return -1;
        }
        BLConstants.single();
        return (Integer)this.attributes.get("LOOPCOUNTER");
    }

    public long getCompleteTime() {
        BLConstants.single();
        return (Long)this.attributes.get("ENDTIME");
    }

    public boolean isCompleted() {
        int n = this.getState();
        BLConstants.single();
        return n == 21;
    }

    public boolean isAtomic() {
        int n = this.getType();
        BLConstants.single();
        return n == 102;
    }

    public boolean isActivity() {
        int n = this.getType();
        BLConstants.single();
        return n == 102;
    }

    public boolean isAdapter() {
        int n = this.getType();
        BLConstants.single();
        return n == 107;
    }

    public boolean isSubProcess() {
        int n = this.getType();
        BLConstants.single();
        return n == 108;
    }

    public boolean isInlineBlock() {
        int n = this.getType();
        BLConstants.single();
        return n == 114;
    }

    public boolean isConnector() {
        block3: {
            block2: {
                int type = this.getType();
                BLConstants.single();
                if (type == 103) break block2;
                BLConstants.single();
                if (type == 105) break block2;
                BLConstants.single();
                if (type == 104) break block2;
                BLConstants.single();
                if (type == 106) break block2;
                BLConstants.single();
                if (type != 113) break block3;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isSuspended() {
        int n = this.getState();
        BLConstants.single();
        return n == 16;
    }

    public boolean isTerminated() {
        int n = this.getState();
        BLConstants.single();
        return n == 19;
    }

    public boolean isSkipped() {
        int n = this.getState();
        BLConstants.single();
        return n == 63;
    }

    @Override
    public boolean isActivated() {
        int n = this.getState();
        BLConstants.single();
        return n == 18;
    }

    public boolean isActivationWait() {
        int n = this.getState();
        BLConstants.single();
        return n == 61;
    }

    public boolean isEventActivationWait() {
        int n = this.getState();
        BLConstants.single();
        return n == 91;
    }

    public boolean isPreConditionWait() {
        int n = this.getState();
        BLConstants.single();
        return n == 62;
    }

    private int getSuspendedState() {
        BLConstants.single();
        return (Integer)this.attributes.get("SUSPENDSTATUS");
    }

    public HashMap getInputValuesByDataslotName() throws RemoteException {
        HashMap map = ((WorkStepInstanceSB)this.getRemoteRef()).getInputValuesByDataSlotNames(this.session, this.getProcessTemplateID(), this.getProcessInstanceID(), this.getID());
        return map;
    }

    public HashMap getInputDataSlotNames() throws RemoteException {
        HashMap inputDSMap = ((WorkStepInstanceSB)this.getRemoteRef()).getInputDataSlotMappedNames(this.session, this.getProcessTemplateID(), this.getProcessInstanceID(), this.getID());
        return inputDSMap;
    }

    public HashMap getOutputDataSlotNames() throws RemoteException {
        HashMap outputDSMap = ((WorkStepInstanceSB)this.getRemoteRef()).getOutputDataSlotMappedNames(this.session, this.getProcessTemplateID(), this.getProcessInstanceID(), this.getID());
        return outputDSMap;
    }

    public HashMap getOutputValuesByDataslotName() throws RemoteException {
        HashMap map = ((WorkStepInstanceSB)this.getRemoteRef()).getOutputValuesByDataSlotNames(this.session, this.getProcessTemplateID(), this.getProcessInstanceID(), this.getID());
        return map;
    }

    public void setPerformer(String performer) throws RemoteException {
        block3: {
            block2: {
                int type = this.getType();
                BLConstants.single();
                if (type == 104) break block2;
                BLConstants.single();
                if (type == 105) break block2;
                BLConstants.single();
                if (type == 103) break block2;
                BLConstants.single();
                if (type != 106) break block3;
            }
            throw new BizLogicClientException("BizLogic_ERR_595", (Object)this.getProcessTemplateName());
        }
        BLConstants.single();
        this.attributes.put("PERFORMER", performer);
        BLConstants.single();
        this.modifiedAttrs.put("PERFORMER", performer);
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public String getName() {
        BLConstants.single();
        return (String)this.attributes.get("WORKSTEPNAME");
    }

    public DateTime getDueDate() {
        BLConstants.single();
        Long duedate = (Long)this.attributes.get("DUEDATE");
        return new DateTime(duedate);
    }

    public void setDueDate(DateTime duedate) {
        if (this.isSuspended() || this.isCompleted()) {
            throw new BizLogicClientException("Bizlogic_ERR_4805", new Object[]{this.getName(), this.getProcessInstanceName()});
        }
        Long date = duedate.getValue().getTime();
        BLConstants.single();
        this.attributes.put("DUEDATE", date);
        BLConstants.single();
        this.modifiedAttrs.put("DUEDATE", date);
    }

    @Override
    protected EJBObject findRemoteRef() {
        try {
            return (WorkStepInstanceSB)WorkStepInstance.getRemoteRef(WorkStepInstanceSBHome.class);
        }
        catch (Exception e) {
            throw new BizLogicClientException("BizLogic_ERR_1527", new Object[]{this.getName()}, (Throwable)e);
        }
    }

    @Override
    public void refresh() throws RemoteException {
        this.attributes = ((WorkStepInstanceSB)this.getRemoteRef()).getAttributes(this.session, this.getProcessInstanceID(), this.getID());
        this.modifiedAttrs.clear();
        this.parent = null;
    }

    @Override
    public void save() throws RemoteException {
        boolean receivedException = false;
        try {
            if (!this.modifiedAttrs.isEmpty()) {
                ((WorkStepInstanceSB)this.getRemoteRef()).save(this.session, this.getProcessInstanceID(), this.getID(), this.modifiedAttrs);
                this.modifiedAttrs.clear();
            }
        }
        catch (BizLogicException | RemoteException e) {
            receivedException = true;
            throw e;
        }
        finally {
            WorkStepInstance.doFinally(receivedException, this);
        }
    }

    @Override
    public void suspend() throws RemoteException {
        if (this.isSuspended()) {
            throw new BizLogicClientException("BizLogic_ERR_1669", new Object[]{this.getName(), this.getProcessInstanceName()});
        }
        if (!this.canSuspendWorkstep()) {
            throw new BizLogicClientException("BizLogic_ERR_1671", new Object[]{this.getName(), this.getProcessInstanceName(), this.getTypeString(), this.getStateDescription()});
        }
        ((WorkStepInstanceSB)this.getRemoteRef()).suspend(this.session, this.getProcessInstanceID(), this.getID());
        BLConstants.single();
        super.setState(16);
    }

    private boolean canSuspendWorkstep() {
        block16: {
            block17: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                int n = this.getState();
                                BLConstants.single();
                                if (n == 61) break block12;
                                int n2 = this.getState();
                                BLConstants.single();
                                if (n2 == 91) break block12;
                                int n3 = this.getState();
                                BLConstants.single();
                                if (n3 != 62) break block13;
                            }
                            return true;
                        }
                        int n = this.getType();
                        BLConstants.single();
                        if (n == 102) break block14;
                        int n4 = this.getType();
                        BLConstants.single();
                        if (n4 != 108) break block15;
                    }
                    int n = this.getState();
                    BLConstants.single();
                    if (n == 18) {
                        return true;
                    }
                }
                int n = this.getType();
                BLConstants.single();
                if (n == 110) {
                    int n5 = this.getState();
                    BLConstants.single();
                    if (n5 == 60) {
                        return true;
                    }
                }
                if (!this.isMonitorStep()) break block16;
                int n6 = this.getState();
                BLConstants.single();
                if (n6 == 91) break block17;
                int n7 = this.getState();
                BLConstants.single();
                if (n7 != 18) break block16;
            }
            return true;
        }
        return false;
    }

    @Override
    public void resume() throws RemoteException {
        if (!this.isSuspended() && !this.isPreConditionWait()) {
            throw new BizLogicClientException("BizLogic_ERR_1672", new Object[]{this.getName(), this.getProcessInstanceName(), this.getStateDescription()});
        }
        ((WorkStepInstanceSB)this.getRemoteRef()).resume(this.session, this.getProcessInstanceID(), this.getID());
        boolean val = ((BLServer)WorkStepInstance.getRemoteRef(BLServerHome.class)).isProcessInstanceExist(this.session, this.getProcessInstanceID());
        if (val) {
            this.refresh();
        }
    }

    public void makeAvailable() throws RemoteException {
        this.makeAvailable(null);
    }

    @Override
    public long getProcessTemplateID() {
        BLConstants.single();
        return (Long)this.attributes.get("PROCESSTEMPLATEID");
    }

    @Override
    public String getProcessTemplateName() {
        BLConstants.single();
        return (String)this.attributes.get("PROCESSTEMPLATENAME");
    }

    @Override
    public long getProcessInstanceID() {
        BLConstants.single();
        return (Long)this.attributes.get("PROCESSINSTANCEID");
    }

    @Override
    public String getProcessInstanceName() {
        BLConstants.single();
        return (String)this.attributes.get("PROCESSINSTANCENAME");
    }

    public ProcessInstance getParent() throws RemoteException {
        if (this.parent == null) {
            this.parent = ((ProcessInstanceSB)WorkStepInstance.getRemoteRef(ProcessInstanceSBHome.class)).getProcessInstance(this.session, this.getProcessInstanceID());
        }
        return this.parent;
    }

    public long getParentID() {
        return this.getProcessInstanceID();
    }

    @Override
    public void complete(HashMap dsValues) throws RemoteException {
        if (this.isConnector()) {
            throw new BizLogicClientException("BizLogic_ERR_3766", new Object[]{"complete", this.getName(), this.getTypeString(), this.getProcessInstanceName()});
        }
        if (this.isCompleted()) {
            throw new BizLogicClientException("BizLogic_ERR_863", new Object[]{this.getName(), this.getProcessInstanceName()});
        }
        if (this.isInlineBlock()) {
            throw new BizLogicClientException("BizLogic_ERR_4506", new Object[]{this.getName(), this.getProcessInstanceName(), "completed"});
        }
        ((WorkStepInstanceSB)this.getRemoteRef()).complete(this.session, this.getProcessInstanceID(), this.getID(), dsValues);
        BLConstants.single();
        super.setState(21);
    }

    @Override
    public void complete() throws RemoteException {
        if (this.isConnector()) {
            throw new BizLogicClientException("BizLogic_ERR_3766", new Object[]{"complete", this.getName(), this.getTypeString(), this.getProcessInstanceName()});
        }
        if (this.isCompleted()) {
            throw new BizLogicClientException("BizLogic_ERR_863", new Object[]{this.getName(), this.getProcessInstanceName()});
        }
        if (this.isInlineBlock()) {
            throw new BizLogicClientException("BizLogic_ERR_4506", new Object[]{this.getName(), this.getProcessInstanceName(), "completed"});
        }
        ((WorkStepInstanceSB)this.getRemoteRef()).complete(this.session, this.getProcessInstanceID(), this.getID());
        BLConstants.single();
        super.setState(21);
    }

    public void reActivate() throws RemoteException {
        if (this.isConnector()) {
            throw new BizLogicClientException("BizLogic_ERR_3766", new Object[]{"reActivate", this.getName(), this.getTypeString(), this.getProcessInstanceName()});
        }
        ((WorkStepInstanceSB)this.getRemoteRef()).reActivate(this.session, this.getProcessInstanceID(), this.getName());
    }

    @Override
    public void remove() {
    }

    @Override
    public HashMap getProcessContext() {
        return this.attributes;
    }

    public WorkItemList getWorkItemList() throws RemoteException {
        WorkStepInstanceSB wsiSB = (WorkStepInstanceSB)this.getRemoteRef();
        return wsiSB.getWorkItemList(this.session, this.getProcessInstanceID(), this.getID());
    }

    public WorkItem getWorkItem(long wiID) throws RemoteException {
        WorkStepInstanceSB wsiSB = (WorkStepInstanceSB)this.getRemoteRef();
        return wsiSB.getWorkItem(this.session, wiID);
    }

    public void removeWorkItem(long wiID) throws RemoteException {
        int n = this.getType();
        BLConstants.single();
        if (n != 102) {
            throw new BizLogicClientException("BizLogic_ERR_2536", new Object[]{this.getName()});
        }
        WorkStepInstanceSB wsiSB = (WorkStepInstanceSB)this.getRemoteRef();
        wsiSB.removeWorkItem(this.session, this.getProcessInstanceID(), wiID);
    }

    public void addWorkItem(String wiPerformer, String wiSuffix, int priority, long duedate) throws RemoteException {
        if (wiPerformer == null) {
            throw new BizLogicClientException("BizLogic_ERR_2547");
        }
        int n = this.getType();
        BLConstants.single();
        if (n != 102) {
            throw new BizLogicClientException("BizLogic_ERR_2535", new Object[]{this.getName()});
        }
        WorkStepInstanceSB wsiSB = (WorkStepInstanceSB)this.getRemoteRef();
        wsiSB.addWorkItem(this.session, this.getProcessInstanceID(), this.getID(), wiPerformer, wiSuffix, priority, duedate);
    }

    public String getPerformer() {
        BLConstants.single();
        return (String)this.attributes.get("PERFORMER");
    }

    public String getActualPerformer() {
        BLConstants.single();
        return (String)this.attributes.get("ACTUALPERFORMER");
    }

    public void makeAvailable(Vector performers) throws RemoteException {
        int n = this.getType();
        BLConstants.single();
        if (n != 102) {
            throw new BizLogicClientException("BizLogic_ERR_2132", new Object[]{this.getName(), this.getProcessInstanceName(), performers});
        }
        if (!this.isActivated()) {
            throw new BizLogicClientException("BizLogic_ERR_4702", new Object[]{this.getName(), this.getProcessInstanceName(), performers});
        }
        WorkStepInstanceSB wsiSB = (WorkStepInstanceSB)this.getRemoteRef();
        wsiSB.makeAvailable(this.session, this.getProcessInstanceID(), this.getID(), performers);
    }

    public String getInstruction() throws RemoteException {
        BLConstants.single();
        String instruction = (String)this.attributes.get("INSTRUCTION");
        if (instruction == null) {
            BLConstants.single();
            if (!this.attributes.containsKey("INSTRUCTION")) {
                instruction = ((WorkStepInstanceSB)this.getRemoteRef()).getInstruction((Session)this.getSession(), this.getProcessInstanceID(), this.getID());
                BLConstants.single();
                this.attributes.put("INSTRUCTION", instruction);
            }
        }
        return instruction;
    }

    public String getMileStone() throws RemoteException {
        throw new BizLogicClientException("Bizlogic_ERR_3703", new Object[]{"getMileStone", "WorkStepInstance"});
    }

    public String getMilestoneDescription() throws RemoteException {
        BLConstants.single();
        return (String)this.attributes.get("MILESTONE_DESC");
    }

    public String getMilestoneName() throws RemoteException {
        BLConstants.single();
        return (String)this.attributes.get("MILESTONE_NAME");
    }

    public long getDuration() throws RemoteException {
        BLConstants.single();
        Long duration = (Long)this.attributes.get("DURATION");
        if (duration == null) {
            BLConstants.single();
            if (!this.attributes.containsKey("DURATION")) {
                duration = ((WorkStepInstanceSB)this.getRemoteRef()).getDuration((Session)this.getSession(), this.getProcessInstanceID(), this.getID());
                BLConstants.single();
                this.attributes.put("DURATION", duration);
            } else {
                return BLUtil.self().getDefaultWSDuration();
            }
        }
        return duration;
    }

    public Object getPerformingApp() throws RemoteException {
        BLConstants.single();
        Object performingApp = this.attributes.get("PERFORMINGAPP");
        if (performingApp == null) {
            BLConstants.single();
            if (!this.attributes.containsKey("PERFORMINGAPP")) {
                performingApp = ((WorkStepInstanceSB)this.getRemoteRef()).getPerformingApp((Session)this.getSession(), this.getProcessInstanceID(), this.getID());
                BLConstants.single();
                this.attributes.put("PERFORMINGAPP", performingApp);
            }
        }
        return performingApp;
    }

    public String getPreCondition() throws RemoteException {
        BLConstants.single();
        String preCondition = (String)this.attributes.get("PRECONDITION");
        if (preCondition == null) {
            BLConstants.single();
            if (!this.attributes.containsKey("PRECONDITION")) {
                preCondition = ((WorkStepInstanceSB)this.getRemoteRef()).getPreCondition((Session)this.getSession(), this.getProcessInstanceID(), this.getID());
                BLConstants.single();
                this.attributes.put("PRECONDITION", preCondition);
            }
        }
        return preCondition;
    }

    public void setInstruction(String instruction) {
        if (instruction != null) {
            instruction = instruction.trim();
        }
        BLConstants.single();
        this.attributes.put("INSTRUCTION", instruction);
        BLConstants.single();
        this.modifiedAttrs.put("INSTRUCTION", instruction);
    }

    public void setMilestone(String ms) {
        throw new BizLogicClientException("Bizlogic_ERR_3703", new Object[]{"setMilestone", "WorkStepInstance"});
    }

    public long getSubProcessInstanceID() throws RemoteException {
        int n = this.getType();
        BLConstants.single();
        if (n == 108) {
            return ((WorkStepInstanceSB)this.getRemoteRef()).getSubProcessInstanceID(this.session, this.getProcessInstanceID(), this.getID());
        }
        throw new BizLogicClientException("BizLogic_ERR_1532", new Object[]{"getSubProcessInstanceID()", "WorkStepInstance", this.getName(), "only nested workstep can have sub process instance id."});
    }

    public void setSubProcessInstanceID(long subpiid) {
        int n = this.getType();
        BLConstants.single();
        if (n == 108) {
            BLConstants.single();
            this.attributes.put("SUBPIID", subpiid);
            BLConstants.single();
            this.modifiedAttrs.put("SUBPIID", subpiid);
        }
        throw new BizLogicClientException("BizLogic_ERR_1532", new Object[]{"getSubProcessInstanceID()", "WorkStepInstance", this.getName(), "only nested workstep can have sub process instance id."});
    }

    public boolean isRollbackPoint() throws RemoteException {
        BLConstants.single();
        Boolean rollbackPoint = (Boolean)this.attributes.get("ROLLBACK");
        if (rollbackPoint == null) {
            BLConstants.single();
            if (!this.attributes.containsKey("ROLLBACK")) {
                boolean rbpt = ((WorkStepInstanceSB)this.getRemoteRef()).isRollbackPoint((Session)this.getSession(), this.getProcessInstanceID(), this.getID());
                BLConstants.single();
                this.attributes.put("ROLLBACK", rbpt);
                return rbpt;
            }
            return false;
        }
        return rollbackPoint;
    }

    public boolean isInputDataSlot(String dsName) throws RemoteException {
        return this.isDataSlot(dsName, this.getInputDataSlotNames().keySet());
    }

    public boolean isOutputDataSlot(String dsName) throws RemoteException {
        return this.isDataSlot(dsName, this.getOutputDataSlotNames().keySet());
    }

    public List getCompletedWorkItemPerformer() throws RemoteException {
        int n = this.getType();
        BLConstants.single();
        if (n != 102) {
            throw new BizLogicClientException("BizLogic_ERR_778", new Object[]{"getCompletionPerfomer", "Activity workstep"});
        }
        WorkStepInstanceSB wsiSB = (WorkStepInstanceSB)this.getRemoteRef();
        return wsiSB.getCompletedWorkItemPerformer(this.session, this.getProcessInstanceID(), this.getID());
    }

    public long getActivationTime() {
        BLConstants.single();
        return (Long)this.attributes.get("ACTIVATIONTIME");
    }

    public void setActivationTime(long time) {
        if (!this.isActivationWait()) {
            throw new BizLogicClientException("BizLogic_ERR_871", new Object[]{this.getName(), this.getProcessInstanceName()});
        }
        BLConstants.single();
        this.attributes.put("ACTIVATIONTIME", time);
        BLConstants.single();
        this.modifiedAttrs.put("ACTIVATIONTIME", time);
    }

    public boolean isWebService() {
        int n = this.getType();
        BLConstants.single();
        return n == 109;
    }

    public boolean isMessageSubscriber() {
        int n = this.getType();
        BLConstants.single();
        return n == 110;
    }

    public boolean isMessagePublisher() {
        int n = this.getType();
        BLConstants.single();
        return n == 111;
    }

    public boolean isVoteEnabled() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        Boolean isVoteEnabled = (Boolean)hashMap.get("VOTEINFO");
        if (isVoteEnabled == null) {
            return false;
        }
        return isVoteEnabled;
    }

    public boolean isProcessInstanceSubProcess() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        Integer callbackCaller = (Integer)hashMap.get("ISCALLBACKCALLER");
        return callbackCaller != null && callbackCaller != -1;
    }

    public boolean isProcessInstanceSyncSubProcess() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        Integer callbackCaller = (Integer)hashMap.get("ISCALLBACKCALLER");
        return callbackCaller != null && callbackCaller == 1;
    }

    public boolean isProcessInstanceAsyncSubProcess() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        Integer callbackCaller = (Integer)hashMap.get("ISCALLBACKCALLER");
        return callbackCaller != null && callbackCaller == 0;
    }

    public void activate() throws RemoteException {
        if (this.isConnector()) {
            throw new BizLogicClientException("BizLogic_ERR_3766", new Object[]{"activate", this.getName(), this.getTypeString(), this.getProcessInstanceName()});
        }
        ((WorkStepInstanceSB)this.getRemoteRef()).activate(this.session, this.getProcessInstanceID(), this.getID());
    }

    public long getLoopConditionCounter() throws RemoteException {
        return ((WorkStepInstanceSB)this.getRemoteRef()).getLoopConditionCounter(this.session, this.getProcessInstanceID(), this.getID());
    }

    public static WorkStepInstance get(Session session, long piID, String wsName) throws RemoteException {
        WorkStepInstanceSB wsiSB = (WorkStepInstanceSB)WorkStepInstance.getRemoteRef(WorkStepInstanceSBHome.class);
        return wsiSB.getWorkStepInstance(session, piID, wsName);
    }

    public static boolean isActivated(Session session, long piid, String wsName) throws RemoteException {
        WorkStepInstance wsi = WorkStepInstance.get(session, piid, wsName);
        return wsi.isActivated();
    }

    public static boolean isCompleted(Session session, long piid, String wsName) throws RemoteException {
        WorkStepInstance wsi = WorkStepInstance.get(session, piid, wsName);
        return wsi.isCompleted();
    }

    public static boolean isSuspended(Session session, long piid, String wsName) throws RemoteException {
        WorkStepInstance wsi = WorkStepInstance.get(session, piid, wsName);
        return wsi.isSuspended();
    }

    public static boolean isTerminated(Session session, long piid, String wsName) throws RemoteException {
        WorkStepInstance wsi = WorkStepInstance.get(session, piid, wsName);
        return wsi.isTerminated();
    }

    public static boolean isSkipped(Session session, long piid, String wsName) throws RemoteException {
        WorkStepInstance wsi = WorkStepInstance.get(session, piid, wsName);
        return wsi.isSkipped();
    }

    public WorkStepTemplate getWorkStepTemplate() throws RemoteException {
        return ((WorkStepInstanceSB)this.getRemoteRef()).getWorkStepTemplate(this.session, this.getProcessInstanceID(), this.getID());
    }

    public ProcessTemplate getProcessTemplate() throws RemoteException {
        return ProcessTemplate.get(this.session, this.getProcessTemplateID());
    }

    public ProcessNotes createNotes(String notes, String threadName) throws RemoteException {
        return ProcessNotes.createForWorkStepInstance(this.session, this.getProcessInstanceID(), this.getName(), notes, threadName);
    }

    public ProcessNotesList getAllNotes() {
        QSProcessNotes qsProcessNotes = this.getQSProcessNotes();
        QSProcessNotesFilter filter = new QSProcessNotesFilter("NotesForWorkStep");
        filter.setConditionForWorkStep();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("piid", this.getProcessInstanceID());
        params.put("wsname", this.getName());
        filter.setParameterValues(params);
        return qsProcessNotes.getList((ProcessNotesFilter)filter);
    }

    @Override
    public String getAppName() {
        BLConstants.single();
        return (String)this.attributes.get("APP_NAME");
    }

    public static void updateAttributes(Session session, List<Map<String, Object>> modifiedAttributes, boolean isMultiTrans) throws RemoteException {
        if (modifiedAttributes == null || modifiedAttributes.isEmpty()) {
            return;
        }
        WorkStepInstanceSB wsisb = (WorkStepInstanceSB)WorkStepInstance.getRemoteRef(WorkStepInstanceSBHome.class);
        wsisb.save(session, modifiedAttributes, isMultiTrans);
    }

    public static void resume(Session session, List<Map<String, Object>> wsiList, boolean isMultiTrans) throws RemoteException {
        WorkStepInstanceSB wsisb = (WorkStepInstanceSB)WorkStepInstance.getRemoteRef(WorkStepInstanceSBHome.class);
        wsisb.resume(session, wsiList, isMultiTrans);
    }

    public static void suspend(Session session, List<Map<String, Object>> wsiList, boolean isMultiTrans) throws RemoteException {
        WorkStepInstanceSB wsisb = (WorkStepInstanceSB)WorkStepInstance.getRemoteRef(WorkStepInstanceSBHome.class);
        wsisb.suspend(session, wsiList, isMultiTrans);
    }

    private boolean isMessageWait() {
        int n = this.getState();
        BLConstants.single();
        return n == 60;
    }

    public void skip() throws RemoteException {
        if (this.isConnector()) {
            throw new BizLogicClientException("BizLogic_ERR_3766", new Object[]{"skip", this.getName(), this.getTypeString(), this.getProcessInstanceName()});
        }
        if (!this.isSuspended() && !this.isMessageWait()) {
            throw new BizLogicClientException("BizLogic_ERR_3763", new Object[]{this.getName(), this.getProcessInstanceName(), this.getStateDescription()});
        }
        ((WorkStepInstanceSB)this.getRemoteRef()).skip(this.session, this.getProcessInstanceID(), this.getID());
        BLConstants.single();
        super.setState(63);
    }

    public static void skip(Session session, List<Map<String, Object>> wsiList, boolean isMultiTrans) throws RemoteException {
        WorkStepInstanceSB wsisb = (WorkStepInstanceSB)WorkStepInstance.getRemoteRef(WorkStepInstanceSBHome.class);
        wsisb.skip(session, wsiList, isMultiTrans);
    }

    public boolean isMonitorStep() {
        BLConstants.single();
        return (Boolean)this.attributes.get("MONITOR_STEP");
    }
}

