/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.smp.persistence;

import com.savvion.sbm.bizlogic.smp.MPService;
import com.savvion.sbm.bizlogic.smp.model.BLExternalEvent;
import com.savvion.sbm.bizlogic.smp.model.ExternalEvent;
import com.savvion.sbm.bizlogic.smp.model.OperationType;
import com.savvion.sbm.bizlogic.smp.persistence.dao.ExternalEventDAO;
import com.savvion.sbm.bizlogic.smp.persistence.dao.HistoryEventDAO;
import com.savvion.sbm.bizlogic.smp.persistence.dao.InvalidEventDAO;
import com.savvion.sbm.bizlogic.smp.persistence.dao.MonitorProcessEiidDAO;
import com.savvion.sbm.bizlogic.smp.persistence.dao.MonitorWaitWorkStepDAO;
import com.savvion.sbm.bizlogic.smp.util.InvalidEventDataException;
import com.savvion.sbm.bizlogic.smp.util.MPEmailService;
import com.savvion.sbm.bizlogic.smp.util.MPUtil;
import com.savvion.sbm.bizlogic.smp.util.MonitoringProcessException;
import com.savvion.sbm.util.ConnectionPool;
import com.savvion.sbm.util.DBService;
import com.savvion.sbm.util.ExceptionService;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.logger.SBMLogger;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class EventPersistenceService {
    private DataSource datasource;
    private ConnectionPool connPool = null;

    public EventPersistenceService(DataSource ds) {
        this.datasource = ds != null ? ds : MPService.self().getDatasource();
    }

    public void storeEvent(ExternalEvent externalEvent) {
        if (externalEvent == null) {
            throw (MonitoringProcessException)((Object)EventPersistenceService.getMonitoringProcessES().createException("BM_MPCM114", "EventPersistentService.storeEvent(ExternalEvent)"));
        }
        Connection conn = null;
        try {
            conn = this.getConnection();
            ExternalEventDAO.create(conn, externalEvent);
        }
        catch (Throwable th) {
            EventPersistenceService.handleThrowable(th);
            throw (MonitoringProcessException)((Object)EventPersistenceService.getMonitoringProcessES().createException("BM_MPCM119", "EventPersistentService.storeEvent(ExternalEvent)", new Object[]{MPUtil.getEventCtx(externalEvent)}, th));
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
    }

    public void storeInvalidEvent(Map<String, Object> invalidEvent) {
        if (invalidEvent == null || invalidEvent.isEmpty()) {
            throw (MonitoringProcessException)((Object)EventPersistenceService.getMonitoringProcessES().createException("BM_MPCM120", "EventPersistentService.storeInvalidEvent(ExternalEvent)"));
        }
        Connection conn = null;
        try {
            conn = this.getConnection();
            InvalidEventDAO.create(conn, invalidEvent);
            this.sendNotification(invalidEvent);
        }
        catch (Throwable th) {
            EventPersistenceService.handleThrowable(th);
            throw (MonitoringProcessException)((Object)EventPersistenceService.getMonitoringProcessES().createException("BM_MPCM119", "EventPersistentService.storeInvalidEvent(Map)", new Object[]{MPUtil.getInvalidEvtCtx(invalidEvent)}, th));
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
    }

    public void storeInvalidEvent(BLExternalEvent invalidEvent, String reason) {
        if (invalidEvent == null) {
            throw (MonitoringProcessException)((Object)EventPersistenceService.getMonitoringProcessES().createException("BM_MPCM006", "EventPersistentService.storeInvalidEvent(BLExternalEvent,S)"));
        }
        try {
            HashMap<String, Object> invalidEvtMap = new HashMap<String, Object>();
            invalidEvtMap.put("EVENT_ID", invalidEvent.getEventId());
            invalidEvtMap.put("EXTERNAL_INSTANCE_ID", invalidEvent.getExternalInstanceId());
            invalidEvtMap.put("OPERATION_TYPE", invalidEvent.getOperationType().getId());
            invalidEvtMap.put("SENDER", invalidEvent.getSender());
            invalidEvtMap.put("CREATE_TIME", invalidEvent.getCreateTime());
            invalidEvtMap.put("PROCESS_NAME", invalidEvent.getProcessName());
            invalidEvtMap.put("WORKSTEP_NAME", invalidEvent.getWorkstepName());
            invalidEvtMap.put("REASON", reason);
            invalidEvtMap.put("RECEIVED_TIME", invalidEvent.getEvtReceivedTime());
            invalidEvtMap.put("MESSAGE", invalidEvent.getAttributes());
            if (invalidEvent.getEmailId() != null && !invalidEvent.getEmailId().isEmpty()) {
                invalidEvtMap.put("NOTIFY_EMAILS", MPUtil.getListAsDelimitedStr(invalidEvent.getEmailId()));
            }
            this.storeInvalidEvent(invalidEvtMap);
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM121", "EventPersistentService.storeInvalidEvent(BLExternalEvent,S)", new Object[]{MPUtil.getEventCtx(invalidEvent)}, th);
        }
    }

    public void markEventAsReadyToProcess(long eventId) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            ExternalEventDAO.updateStatusAsReadyToProcess(conn, eventId);
        }
        catch (Throwable th) {
            EventPersistenceService.handleThrowable(th);
            throw (MonitoringProcessException)((Object)EventPersistenceService.getMonitoringProcessES().createException("BM_MPCM128", "EventPersistentService.markEventAsReadyToProcess(long)", new Object[]{eventId}, th));
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
    }

    public void markEventAsProcessed(long eventId) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            ExternalEventDAO.updateEventStatus(conn, eventId, true);
        }
        catch (Throwable th) {
            EventPersistenceService.handleThrowable(th);
            throw (MonitoringProcessException)((Object)EventPersistenceService.getMonitoringProcessES().createException("BM_MPCM129", "EventPersistentService.markEventAsProcessed(long)", new Object[]{eventId}, th));
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
    }

    public void markEventAsNotProcessed(long eventId) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            ExternalEventDAO.updateEventStatus(conn, eventId, false);
        }
        catch (Throwable th) {
            EventPersistenceService.handleThrowable(th);
            throw (MonitoringProcessException)((Object)EventPersistenceService.getMonitoringProcessES().createException("BM_MPCM011", "EventPersistentService.markEventAsNotProcessed(long)", new Object[]{eventId}, th));
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
    }

    public void incrementEventRetryCount(long eventId, long retryInterval) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            ExternalEventDAO.incrementRetryCounter(conn, eventId, retryInterval);
        }
        catch (Throwable th) {
            EventPersistenceService.handleThrowable(th);
            throw (MonitoringProcessException)((Object)EventPersistenceService.getMonitoringProcessES().createException("BM_MPCM131", "EventPersistentService.incrementEventRetryCount(long, long)", new Object[]{eventId}, th));
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
    }

    public List<BLExternalEvent> getReadyToProcessEventList(int batchSize, boolean sortEvents) {
        List<BLExternalEvent> eventList;
        Connection conn = null;
        try {
            conn = this.getConnection();
            eventList = ExternalEventDAO.getReadyToProcessList(conn, batchSize, sortEvents);
        }
        catch (Throwable th) {
            EventPersistenceService.handleThrowable(th);
            throw (MonitoringProcessException)((Object)EventPersistenceService.getMonitoringProcessES().createException("BM_MPCM132", "EventPersistentService.getReadyToProcessEvents(long)", new Object[]{batchSize}, th));
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
        return eventList;
    }

    public List<BLExternalEvent> getEventsForWorkstep(String eiid, String ptName, String wsName, int loopCounter, OperationType[] operations, int batchSize, boolean sortEvents) {
        List<BLExternalEvent> eventList;
        Connection conn = null;
        try {
            conn = this.getConnection();
            eventList = ExternalEventDAO.getEventsForWorkstep(conn, eiid, ptName, wsName, loopCounter, operations, batchSize, sortEvents);
        }
        catch (InvalidEventDataException e) {
            throw e;
        }
        catch (MonitoringProcessException e) {
            throw e;
        }
        catch (Throwable th) {
            throw (MonitoringProcessException)((Object)EventPersistenceService.getMonitoringProcessES().createException("BM_MPCM132", "EventPersistentService.getEventsForWorkstep()", new Object[]{batchSize}, th));
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
        return eventList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeMonitorWaitWorkStep(Map<String, Object> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            throw (MonitoringProcessException)((Object)EventPersistenceService.getMonitoringProcessES().createException("BM_MPCM204", "EventPersistentService.storeMonitorWaitWorkStep(Map)"));
        }
        Connection conn = null;
        try {
            conn = this.getConnection();
            MonitorWaitWorkStepDAO.create(conn, attributes);
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM203", "EventPersistentService.storeMonitorWaitWorkStep(Map)", new Object[]{attributes}, th);
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEventExist(String processName, String eiid, String wsName, int loopcounter) {
        Connection conn = null;
        boolean isEventExist = false;
        try {
            conn = this.getConnection();
            isEventExist = ExternalEventDAO.isEventExist(conn, processName, eiid, wsName, loopcounter);
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM201", "EventPersistentService.isEventExist", new Object[]{processName, wsName, loopcounter, eiid}, th);
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
        return isEventExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEvent(String processName, String eiid, String wsName, int loopcounter, HashMap<String, Object> modifiedAttrs) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            ExternalEventDAO.updateProcessContext(conn, processName, eiid, wsName, loopcounter, modifiedAttrs);
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM202", "EventPersistentService.updateEvent", new Object[]{processName, eiid, wsName, loopcounter}, th);
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEvent(long eventId, HashMap<String, Object> modifiedAttrs) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            ExternalEventDAO.updateProcessContext(conn, eventId, modifiedAttrs);
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM222", "EventPersistentService.updateEvent", new Object[]{eventId}, th);
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMonitorWaitWorkStepEiid(long piid, String eiidValue) {
        if (eiidValue == null || eiidValue.trim().length() == 0) {
            throw (MonitoringProcessException)((Object)EventPersistenceService.getMonitoringProcessES().createException("BM_MPCM209", "EventPersistentService.updateMonitorWaitWorkStepEiid(long, String)"));
        }
        Connection conn = null;
        try {
            conn = this.getConnection();
            MonitorWaitWorkStepDAO.updateEIID(conn, piid, eiidValue);
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM205", "EventPersistentService.updateMonitorWaitWorkStepEiid", new Object[]{eiidValue, piid}, th);
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWaitForActivationFlag(long piid, long wsid, int loopCounter, int waitForActivateEvent) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            MonitorWaitWorkStepDAO.updateWaitForActivation(piid, wsid, loopCounter, waitForActivateEvent, conn);
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM502", "EventPersistentService.updateMonitorWaitWSWaitForActivation", new Object[]{piid, wsid, loopCounter, waitForActivateEvent}, th);
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEvent(long piid, long wsid, int loopcounter) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            ExternalEventDAO.remove(conn, piid, wsid, loopcounter);
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM213", "EventPersistentService.removeEvent(long, long, int)", new Object[]{piid, wsid, loopcounter}, th);
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEvent(String processName, String eiid) {
        if (processName == null || processName.trim().length() == 0) {
            throw (MonitoringProcessException)((Object)EventPersistenceService.getMonitoringProcessES().createException("BM_MPCM214", "EventPersistentService.removeEvent(String, String)"));
        }
        if (eiid == null || eiid.trim().length() == 0) {
            throw (MonitoringProcessException)((Object)EventPersistenceService.getMonitoringProcessES().createException("BM_MPCM215", "EventPersistentService.removeEvent(String, String)"));
        }
        Connection conn = null;
        try {
            conn = this.getConnection();
            ExternalEventDAO.remove(conn, processName, eiid);
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM212", "EventPersistentService.removeEvent(String, String)", new Object[]{processName, eiid}, th);
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEvent(String processName) {
        if (processName == null || processName.trim().length() == 0) {
            throw (MonitoringProcessException)((Object)EventPersistenceService.getMonitoringProcessES().createException("BM_MPCM214", "EventPersistentService.removeEvent(String)"));
        }
        Connection conn = null;
        try {
            conn = this.getConnection();
            ExternalEventDAO.remove(conn, processName);
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM211", "EventPersistentService.removeEvent(String)", new Object[]{processName}, th);
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMonitorWaitWorkstep(long piid, long wsid, int loopcounter) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            MonitorWaitWorkStepDAO.remove(conn, piid, wsid, loopcounter);
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM208", "EventPersistentService.removeMonitorWaitWorkstep(long, long, int)", new Object[]{piid, wsid, loopcounter}, th);
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMonitorWaitWorkstep(long piid) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            MonitorWaitWorkStepDAO.remove(conn, piid);
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM207", "EventPersistentService.removeMonitorWaitWorkstep(long)", new Object[]{piid}, th);
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMonitorWaitWorkstep(String ptName) {
        if (ptName == null || ptName.trim().length() == 0) {
            throw (MonitoringProcessException)((Object)EventPersistenceService.getMonitoringProcessES().createException("BM_MPCM210", "EventPersistentService.removeMonitorWaitWorkstep(String)"));
        }
        Connection conn = null;
        try {
            conn = this.getConnection();
            MonitorWaitWorkStepDAO.remove(conn, ptName);
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM206", "EventPersistentService.removeMonitorWaitWorkstep(String)", new Object[]{ptName}, th);
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getEventAttributes(Map<String, Object> whereAttributes) {
        Connection conn = null;
        List<Map<String, Object>> events = null;
        try {
            conn = this.getConnection();
            events = ExternalEventDAO.getAttributes(conn, whereAttributes);
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM217", "EventPersistentService.getEventAttributes(Map)", new Object[]{whereAttributes}, th);
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getWaitWSAttributes(int batchSize) {
        if (batchSize < 0) {
            throw (MonitoringProcessException)((Object)EventPersistenceService.getMonitoringProcessES().createException("BM_MPCM221", "EventPersistentService.getWaitWSAttributes(int)", new Object[]{batchSize}));
        }
        Connection conn = null;
        List<Map<String, Object>> events = null;
        try {
            conn = this.getConnection();
            events = MonitorWaitWorkStepDAO.getAttributes(conn, batchSize);
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM219", "EventPersistentService.getWaitWSAttributes(int)", null, th);
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
        return events;
    }

    private void sendNotification(Map<String, Object> invalidEvent) {
        List<String> emailIds = null;
        try {
            emailIds = MPEmailService.self().prepareEmailIds(invalidEvent);
            if (emailIds != null && !emailIds.isEmpty()) {
                MPEmailService.self().notifyInvalidEvent(emailIds, invalidEvent);
            }
        }
        catch (Throwable th) {
            EventPersistenceService.getLogger().errorKey("BM_MPCM406", "EventPersistentService.sendNotification(Map<String, Object>)", th, new Object[]{emailIds, MPUtil.getInvalidEvtCtx(invalidEvent)});
        }
    }

    private static void handleThrowable(Throwable th) {
        if (th instanceof InvalidEventDataException) {
            throw (InvalidEventDataException)((Object)th);
        }
        if (th instanceof MonitoringProcessException) {
            throw (MonitoringProcessException)((Object)th);
        }
    }

    private Connection getConnection() throws SQLException {
        return this.datasource.getConnection();
    }

    private static void closeConnection(Connection conn) {
        try {
            DBService.clean(null, null, (Connection)conn);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static ExceptionService<MonitoringProcessException> getMonitoringProcessES() {
        return MPService.self().getMonitoringProcessES();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getProcessedEventIds(int batchSize) {
        List<Long> processedEvt = null;
        Connection conn = null;
        try {
            conn = this.getConnection();
            processedEvt = ExternalEventDAO.getProcessedEventIds(conn, batchSize);
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM002", "EventPersistenceService.getProcessedEventIds()", new Object[0], th);
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
        return processedEvt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BLExternalEvent> getProcessedEvents(int batchSize) {
        List<BLExternalEvent> processedEvt = null;
        Connection conn = null;
        try {
            conn = this.getConnection();
            processedEvt = ExternalEventDAO.getProcessedEvents(conn, batchSize);
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM002", "EventPersistenceService.getProcessedEvents()", new Object[0], th);
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
        return processedEvt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertEventsInHistoryByIds(List<Long> processedEvt) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            HistoryEventDAO.insertEventsById(conn, processedEvt);
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM003", "EventPersistenceService.insertEventsInHistoryByIds()", new Object[0], th);
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertEventsInHistory(List<BLExternalEvent> processedEvt) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            HistoryEventDAO.insertEvents(conn, processedEvt);
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM003", "EventPersistenceService.insertEventsInHistory()", new Object[0], th);
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteExternalEventByIds(List<Long> processedEvt) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            ExternalEventDAO.deleteEventsById(conn, processedEvt);
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM004", "EventPersistenceService.deleteExternalEventByIds()", new Object[0], th);
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteExternalEvents(List<BLExternalEvent> processedEvt) {
        Connection conn = null;
        try {
            ArrayList<Long> evtIdList = new ArrayList<Long>();
            for (BLExternalEvent blExtEvnt : processedEvt) {
                evtIdList.add(blExtEvnt.getEventId());
            }
            this.deleteExternalEventByIds(evtIdList);
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM004", "EventPersistenceService.deleteExternalEvents()", new Object[0], th);
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteExternalEvent(long evtId) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            ArrayList<Long> eventIds = new ArrayList<Long>();
            eventIds.add(evtId);
            ExternalEventDAO.deleteEventsById(conn, eventIds);
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM007", "EventPersistenceService.deleteExternalEvent()", new Object[0], th);
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
    }

    private static SBMLogger getLogger() {
        return MPService.self().getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEventById(long eventId, Map<String, Object> modifiedAttrs) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            ExternalEventDAO.updateEventById(eventId, conn, modifiedAttrs);
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM010", "EventPersistenceService.updateEventById()", new Object[]{modifiedAttrs, eventId}, th);
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteInvalidEventByCreateTime(Timestamp createTime) {
        Connection conn = null;
        try {
            conn = this.getConnectionPool().getConnection();
            InvalidEventDAO.deleteEventsByCreateTime(conn, createTime);
        }
        catch (MonitoringProcessException mpe) {
            throw mpe;
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM225", "EventPersistenceService.deleteInvalidEventByCreateTime()", new Object[]{createTime}, th);
        }
        finally {
            this.getConnectionPool().close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteHistoryEventByCreateTime(Timestamp createTime) {
        Connection conn = null;
        try {
            conn = this.getConnectionPool().getConnection();
            HistoryEventDAO.deleteEventsByCreateTime(conn, createTime);
        }
        catch (MonitoringProcessException mpe) {
            throw mpe;
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM223", "EventPersistenceService.deleteHistoryEventByCreateTime()", new Object[]{createTime}, th);
        }
        finally {
            this.getConnectionPool().close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMonitorProcessEiid(long ptId, String eiid) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            MonitorProcessEiidDAO.create(conn, ptId, eiid);
        }
        catch (MonitoringProcessException e) {
            throw e;
        }
        catch (Throwable e) {
            MPUtil.handleThrowable("BM_MPCM505", "EventPersistenceService.createMonitorProcessEiid()", new Object[]{ptId, eiid}, e);
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMonitorProcessEiid(long ptId, String eiid) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            MonitorProcessEiidDAO.remove(conn, ptId, eiid);
        }
        catch (MonitoringProcessException e) {
            throw e;
        }
        catch (Throwable e) {
            MPUtil.handleThrowable("BM_MPCM506", "EventPersistenceService.removeMonitorProcessEiid()", new Object[]{ptId, eiid}, e);
        }
        finally {
            EventPersistenceService.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionPool getConnectionPool() {
        if (this.connPool == null) {
            EventPersistenceService eventPersistenceService = this;
            synchronized (eventPersistenceService) {
                if (this.connPool == null) {
                    this.connPool = SBMUtil.createConnectionPool((SBMLogger)MPService.self().getLogger());
                    this.connPool.setLimits(1, 2, 2);
                    this.connPool.setTestOnReserve(true);
                    this.connPool.setConnectionReqTimeout(30L);
                }
            }
        }
        return this.connPool;
    }

    static {
        ExternalEventDAO.initSQLStatements();
        InvalidEventDAO.initSQLStatements();
        MonitorWaitWorkStepDAO.initSQLStatements();
        MonitorProcessEiidDAO.initSQLStatements();
    }
}

