/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.smp.util;

import com.savvion.sbm.bizlogic.client.queryservice.bizstore.dao.BSProcessInstanceDAO;
import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceEBLocal;
import com.savvion.sbm.bizlogic.smp.MPService;
import com.savvion.sbm.bizlogic.smp.gateway.jms.util.JMSUtil;
import com.savvion.sbm.bizlogic.smp.model.BLExternalEvent;
import com.savvion.sbm.bizlogic.smp.model.ExternalEvent;
import com.savvion.sbm.bizlogic.smp.model.OperationType;
import com.savvion.sbm.bizlogic.smp.persistence.EventPersistenceService;
import com.savvion.sbm.bizlogic.smp.persistence.dao.ExternalEventDAO;
import com.savvion.sbm.bizlogic.smp.persistence.dao.HistoryEventDAO;
import com.savvion.sbm.bizlogic.smp.persistence.dao.InvalidEventDAO;
import com.savvion.sbm.bizlogic.smp.persistence.dao.MonitorProcessEiidDAO;
import com.savvion.sbm.bizlogic.smp.persistence.dao.MonitorWaitWorkStepDAO;
import com.savvion.sbm.bizlogic.smp.util.InvalidEventDataException;
import com.savvion.sbm.bizlogic.smp.util.MonitoringProcessException;
import com.savvion.sbm.bizlogic.smp.util.SMPConfig;
import com.savvion.sbm.util.DBService;
import com.savvion.sbm.util.ExceptionService;
import com.savvion.sbm.util.FileUtil;
import com.savvion.sbm.util.LoggerUtil;
import com.savvion.sbm.util.ResourceUtil;
import com.savvion.sbm.util.SBMDatabase;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.TransactionService;
import com.savvion.sbm.util.logger.SBMLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jms.Message;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;

public class MPUtil {
    private static String dbAvailableQuery = null;
    private static boolean isDebugEnabled = false;
    private static boolean initialized = false;
    private static boolean isSchedulerDebugEnabled = false;

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        MPUtil.readBLProperties();
        MPUtil.initDBAvailableQuery();
        initialized = true;
    }

    private static synchronized void readBLProperties() {
        String propFile = SBMUtil.self().ABSOLUTE_CONF_PATH + "bizlogic.conf";
        try {
            Properties blProps = ResourceUtil.getPropertyObject((String)propFile);
            String prop = blProps.getProperty("bizlogic.debug.monitoring");
            if (prop != null) {
                isDebugEnabled = Boolean.parseBoolean(prop.trim());
            }
            if ((prop = blProps.getProperty("bizlogic.debug.scheduler")) != null) {
                isSchedulerDebugEnabled = Boolean.parseBoolean(prop.trim());
            }
        }
        catch (Throwable th) {
            throw new RuntimeException("Error reading property file: " + propFile, th);
        }
    }

    public static void printDAOSql() {
        if (initialized && MPUtil.isDebug()) {
            ExternalEventDAO.printSQLStatements();
            InvalidEventDAO.printSQLStatements();
            HistoryEventDAO.printSQLStatements();
            MonitorWaitWorkStepDAO.printSQLStatements();
            MonitorProcessEiidDAO.printSQLStatements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isDBAvailable() {
        block10: {
            Statement stmt = null;
            ResultSet rs = null;
            Connection con = null;
            con = DBService.getConnection((DataSource)MPUtil.getDatasource());
            stmt = con.createStatement();
            rs = stmt.executeQuery(dbAvailableQuery);
            try {
                DBService.clean((ResultSet)rs, (Statement)stmt, (Connection)con);
            }
            catch (Throwable th) {
                MPUtil.getLogger().errorKey("BM_MPCM116", "MPUtil.isDBAvailable()", th, new Object[0]);
            }
            break block10;
            catch (Throwable th) {
                boolean bl;
                try {
                    MPUtil.getLogger().errorKey("BM_MPCM115", "MPUtil.isDBAvailable()", th, new Object[]{dbAvailableQuery});
                    bl = false;
                }
                catch (Throwable throwable) {
                    try {
                        DBService.clean(rs, (Statement)stmt, (Connection)con);
                    }
                    catch (Throwable th2) {
                        MPUtil.getLogger().errorKey("BM_MPCM116", "MPUtil.isDBAvailable()", th2, new Object[0]);
                    }
                    throw throwable;
                }
                try {
                    DBService.clean((ResultSet)rs, (Statement)stmt, (Connection)con);
                }
                catch (Throwable th3) {
                    MPUtil.getLogger().errorKey("BM_MPCM116", "MPUtil.isDBAvailable()", th3, new Object[0]);
                }
                return bl;
            }
        }
        return true;
    }

    public static long getSystemTimeFromDB(Connection con) {
        if (con == null) {
            throw (MonitoringProcessException)((Object)MPUtil.getMonitoringPrcExSvc().createException("BM_MPCM122", "MPUtil.getSystemTimeFromDB(Connection)"));
        }
        long dbSysTime = 0L;
        try {
            dbSysTime = DBService.getSystemTimeFromDB((Connection)con);
        }
        catch (Throwable th) {
            MPUtil.getLogger().errorKey("BM_MPCM117", "MPUtil.getSystemTimeFromDB(Connection)", th, new Object[0]);
        }
        return dbSysTime;
    }

    public static String getEventCtx(ExternalEvent externalEvent) {
        StringBuilder sb = new StringBuilder();
        if (externalEvent != null) {
            sb.append(" EXTERNAL_INSTANCE_ID: " + externalEvent.getExternalInstanceId());
            sb.append(" | PROCESS_NAME: " + externalEvent.getProcessName());
            sb.append(" | OPERATION_TYPE: " + (Object)((Object)externalEvent.getOperationType()));
            OperationType opType = externalEvent.getOperationType();
            if (opType != null && opType.isWorkstep()) {
                sb.append(" | WORKSTEP_NAME: " + externalEvent.getWorkstepName());
            }
            sb.append(" | SENDER: " + externalEvent.getSender());
        }
        return sb.toString();
    }

    public static String getEventCtx(BLExternalEvent blExternalEvent) {
        StringBuilder sb = new StringBuilder();
        if (blExternalEvent != null) {
            sb.append(" | EVENT_ID: " + blExternalEvent.getEventId());
            sb.append(" | EXTERNAL_INSTANCE_ID: " + blExternalEvent.getExternalInstanceId());
            sb.append(" | PROCESS_INSTANCE_ID: " + blExternalEvent.getBLProcessInstanceId());
            sb.append(" | PROCESS_NAME: " + blExternalEvent.getProcessName());
            sb.append(" | OPERATION_TYPE: " + (Object)((Object)blExternalEvent.getOperationType()));
            OperationType opType = blExternalEvent.getOperationType();
            if (opType != null && opType.isWorkstep()) {
                sb.append(" | WORKSTEP_NAME: " + blExternalEvent.getWorkstepName());
            }
            sb.append(" | SENDER: " + blExternalEvent.getSender());
        }
        return sb.toString();
    }

    public static String getEventCtx(String eiid, String processName, String operationType, String workstepName) {
        StringBuilder sb = new StringBuilder();
        sb.append(" EXTERNAL_INSTANCE_ID: " + eiid);
        sb.append(" | PROCESS_NAME: " + processName);
        sb.append(" | OPERATION_TYPE: " + operationType);
        if (workstepName != null) {
            sb.append(" | WORKSTEP_NAME: " + workstepName);
        }
        return sb.toString();
    }

    public static String getInvalidEvtCtx(Map<String, Object> invalidEvt) {
        StringBuilder sb = new StringBuilder();
        if (invalidEvt != null && !invalidEvt.isEmpty()) {
            sb.append(" EXTERNAL_INSTANCE_ID: " + invalidEvt.get("EXTERNAL_INSTANCE_ID"));
            sb.append(" | PROCESS_NAME: " + invalidEvt.get("PROCESS_NAME"));
            sb.append(" | OPERATION_TYPE: " + invalidEvt.get("OPERATION_TYPE"));
            Object wsName = invalidEvt.get("WORKSTEP_NAME");
            if (wsName != null && wsName instanceof String && MPUtil.isValidString((String)wsName)) {
                sb.append(" | WORKSTEP_NAME: " + wsName);
            }
            sb.append(" | SENDER: " + invalidEvt.get("SENDER"));
        }
        return sb.toString();
    }

    public static String getListAsDelimitedStr(List<String> valLst) {
        StringBuilder sb = new StringBuilder();
        if (valLst != null && !valLst.isEmpty()) {
            for (int index = 0; index < valLst.size(); ++index) {
                sb.append(valLst.get(index));
                if (index == valLst.size() - 1) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }

    public static List<String> convertToStringList(String delimitedStr) {
        ArrayList valLst = null;
        if (MPUtil.isValidString(delimitedStr)) {
            valLst = SBMUtil.convertToStringList((String)delimitedStr, (String)",");
        }
        if (valLst == null) {
            valLst = new ArrayList(0);
        }
        return valLst;
    }

    public static byte[] convertToBytes(Object obj) {
        byte[] byArray;
        ByteArrayOutputStream byteStream = null;
        ObjectOutputStream objStream = null;
        try {
            byteStream = new ByteArrayOutputStream();
            objStream = new ObjectOutputStream(byteStream);
            objStream.writeObject(obj);
            byArray = byteStream.toByteArray();
        }
        catch (Throwable th) {
            try {
                throw (MonitoringProcessException)((Object)MPUtil.getMonitoringPrcExSvc().createException("BM_MPCM118", "MPUtil.convertToBytes(Object)", th));
            }
            catch (Throwable throwable) {
                FileUtil.close(objStream);
                throw throwable;
            }
        }
        FileUtil.close((OutputStream)objStream);
        return byArray;
    }

    public static Object convertToObject(InputStream in) {
        Object object;
        ObjectInputStream objStream = null;
        try {
            Object obj;
            objStream = new ObjectInputStream(in);
            object = obj = objStream.readObject();
        }
        catch (Throwable th) {
            try {
                throw (MonitoringProcessException)((Object)MPUtil.getMonitoringPrcExSvc().createException("BM_MPCM126", "MPUtil.convertToObject(InputStream)", th));
            }
            catch (Throwable throwable) {
                FileUtil.close(objStream);
                throw throwable;
            }
        }
        FileUtil.close((InputStream)objStream);
        return object;
    }

    public static boolean isValidString(String str) {
        return str != null && str.trim().length() > 0;
    }

    public static void sleep(long timeinMillis) {
        try {
            Thread.sleep(timeinMillis);
        }
        catch (Throwable th) {
            LoggerUtil.logStackTrace((String)"Exception while Thread-sleep : <MPUtil:sleep()>", (Throwable)th, (SBMLogger)MPUtil.getLogger());
        }
    }

    public static boolean isDebug() {
        return isDebugEnabled;
    }

    private static synchronized void initDBAvailableQuery() {
        if (SBMDatabase.self().isOracle()) {
            dbAvailableQuery = "select 1 from DUAL";
        } else if (SBMDatabase.self().isSQLServer()) {
            dbAvailableQuery = "select 1";
        } else if (SBMDatabase.self().isDB2()) {
            dbAvailableQuery = "select 1 from SYSIBM.SYSDUMMY1";
        } else if (SBMDatabase.self().isSybase()) {
            dbAvailableQuery = "select 1";
        } else if (SBMDatabase.self().isOpenEdge()) {
            dbAvailableQuery = "SELECT 1 FROM SBM_TEST";
        }
    }

    private static ExceptionService<MonitoringProcessException> getMonitoringPrcExSvc() {
        return MPService.self().getMonitoringProcessES();
    }

    private static SBMLogger getLogger() {
        return MPService.self().getLogger();
    }

    private static DataSource getDatasource() {
        return MPService.self().getDatasource();
    }

    public static void handleThrowable(String msgKey, String ctx, Object[] args, Throwable th) {
        if (th instanceof InvalidEventDataException) {
            throw (InvalidEventDataException)((Object)th);
        }
        if (th instanceof MonitoringProcessException) {
            throw (MonitoringProcessException)((Object)th);
        }
        throw (MonitoringProcessException)((Object)MPUtil.getMonitoringPrcExSvc().createException(msgKey, ctx, args, th));
    }

    public static boolean isProcessInstanceExist(String ptName, String monitorDSName, String monitorDSValue) {
        long piid = -1L;
        try {
            piid = MPUtil.getProcessInstanceId(ptName, monitorDSName, monitorDSValue, false);
        }
        catch (Throwable th) {
            boolean isTableExist = DBService.checkTableExists((Connection)BSProcessInstanceDAO.getConnection(), (String)ptName);
            if (!isTableExist) {
                MPUtil.getLogger().warnKey("BM_MPCM013", "MPUtil.isProcessInstanceExist", new Object[]{ptName});
                return false;
            }
            throw (MonitoringProcessException)((Object)MPUtil.getMonitoringPrcExSvc().createException("BM_MPCM012", "MPUtil.isProcessInstanceExist", new Object[]{ptName, monitorDSName, monitorDSValue}, th));
        }
        return piid != -1L;
    }

    public static long getProcessInstanceId(String ptName, String monitorDSName, String monitorDSValue, boolean throwExNotfound) {
        long piid = BSProcessInstanceDAO.getProcessInstanceId((String)ptName, (String)monitorDSName, (String)monitorDSValue);
        if (piid == -1L && throwExNotfound) {
            throw (MonitoringProcessException)((Object)MPUtil.getMonitoringPrcExSvc().createException("BM_MPCM220", "MPUtil.getProcessInstanceId", new Object[]{ptName, monitorDSName, monitorDSValue}));
        }
        return piid;
    }

    public static boolean isPIExistInBizStore(String ptName, String eiid) {
        String monitorDSName = ProcessControl.getProcessTemplate(ptName).getMonitorDSName();
        long piid = BSProcessInstanceDAO.getProcessInstanceId((String)ptName, (String)monitorDSName, (String)eiid);
        return -1L != piid;
    }

    public static boolean isDebugScheduler() {
        return isSchedulerDebugEnabled;
    }

    public static void refresh() {
        MPUtil.readBLProperties();
    }

    public static String lookupMessage(String msgID, Object ... args) {
        return MPService.self().getMessageFactory().lookup(msgID, args);
    }

    public static boolean validateDateTime(long timeValue, String context, Map eventCtx, boolean throwExceptionIfInvalid) {
        try {
            String timeStr = String.valueOf(timeValue);
            long timeLng = Long.valueOf(timeStr);
            new Timestamp(timeLng);
        }
        catch (Throwable th) {
            if (throwExceptionIfInvalid) {
                throw (InvalidEventDataException)((Object)MPService.self().getInvalidEventDataES().createException("BM_MPGW135", "MPUtil.validateDateTime(long,String,Map,boolean)", new Object[]{context, timeValue, eventCtx}, th));
            }
            if (SMPConfig.self().logWarningMessage()) {
                MPUtil.getLogger().warnKey("BM_MPGW134", "MPUtil.validateDateTime(long,String,Map,boolean)", th, new Object[]{context, timeValue, eventCtx});
            }
            return false;
        }
        return true;
    }

    public static boolean shouldProcessCompleteEvent(WFProcessContext pCtx, long wsid, WorkStepInstanceEBLocal wsEBean) {
        WFWorkstep workstep = pCtx.getWorkstep(wsid);
        if (workstep.isWaitForActivateEvent()) {
            if (18 != wsEBean.getState()) {
                return false;
            }
        } else if (18 != wsEBean.getState()) {
            if (91 != wsEBean.getState()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidProcessTemplate(String ptName) {
        return ProcessControl.isProcessTemplateExist(ptName);
    }

    public static boolean isValidWorkstep(String ptName, String wsName) {
        return ProcessControl.isValidWorkstep(ptName, wsName);
    }

    public static List<BLExternalEvent> getEventsForWorkstep(String eiid, String ptName, String wsName, int loopCounter) {
        OperationType[] operations = new OperationType[]{OperationType.ACTIVATE_WORKSTEP, OperationType.COMPLETE_WORKSTEP};
        List<BLExternalEvent> events = MPService.self().getPersistenceService().getEventsForWorkstep(eiid, ptName, wsName, loopCounter, operations, SMPConfig.self().getEventJobBatch(), SMPConfig.self().isSortedEventSelection());
        return events;
    }

    public static void handleInvalidEvent(BLExternalEvent event, String errorMsg) {
        EventPersistenceService eps = MPService.self().getPersistenceService();
        eps.storeInvalidEvent(event, errorMsg);
        eps.deleteExternalEvent(event.getEventId());
        MPService.self().getLogger().warnKey("BM_MPSH009", "MPUtil.handleInvalidEvent()", new Object[]{MPUtil.getEventCtx(event), errorMsg});
    }

    public static void handleProcessedEvent(BLExternalEvent event) {
        EventPersistenceService eps = MPService.self().getPersistenceService();
        if (SMPConfig.self().isExtEventHistoryEnabled()) {
            eps.markEventAsProcessed(event.getEventId());
        } else {
            eps.deleteExternalEvent(event.getEventId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List convertByteArrToList(byte[] bytes, String listKey, Map<String, Object> jmsProps) {
        if (bytes == null || bytes.length == 0) {
            return new ArrayList();
        }
        ByteArrayInputStream inputStream = null;
        Object object = null;
        try {
            inputStream = new ByteArrayInputStream(bytes);
            object = MPUtil.convertToObject(inputStream);
            if (object == null || !(object instanceof List)) {
                throw (InvalidEventDataException)((Object)MPService.self().getInvalidEventDataES().createException("BM_MPGW207", "MPUtil.convertByteArrToList(byte[])", new Object[]{listKey, jmsProps}));
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(inputStream);
            throw throwable;
        }
        FileUtil.close((InputStream)inputStream);
        return (List)object;
    }

    public static void handleException(Throwable th, Message message) {
        if (th instanceof InvalidEventDataException) {
            MPUtil.handleInvalidEventDataEx((InvalidEventDataException)((Object)th), message);
        } else {
            MPUtil.handleThrowable(th, message);
        }
    }

    public static void handleInvalidEventDataEx(InvalidEventDataException invalidEvtDataEx, Message message) {
        UserTransaction utx = null;
        try {
            Map<String, Object> invalidEvent = JMSUtil.getInvalidEvent(message, invalidEvtDataEx);
            if (MPUtil.isDebug()) {
                MPUtil.getLogger().debugKey("BM_MPGW123", new Object[]{MPUtil.getInvalidEvtCtx(invalidEvent)});
            }
            utx = TransactionService.getUserTransaction();
            utx.begin();
            MPService.self().getPersistenceService().storeInvalidEvent(invalidEvent);
            utx.commit();
            if (MPUtil.isDebug()) {
                MPUtil.getLogger().debugKey("BM_MPGW124", new Object[]{MPUtil.getInvalidEvtCtx(invalidEvent)});
            }
        }
        catch (Throwable th) {
            TransactionService.rollback(utx, (SBMLogger)MPUtil.getLogger());
            MPUtil.handleThrowable(th, message);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void handleThrowable(Throwable th, Message message) {
        Map eventCtx = JMSUtil.getEventCtx(message);
        MonitoringProcessException mpEx = (MonitoringProcessException)((Object)MPUtil.getMonitoringProcessES().createException("BM_MPGW110", "MPUtil.handleThrowable(Throwable,Message)", new Object[]{eventCtx, message}, th));
        if (MPUtil.isDBAvailable()) {
            try {
                if (MPUtil.isDebug()) {
                    MPUtil.getLogger().debugKey("BM_MPGW125", new Object[]{MPUtil.getInvalidEvtCtx(eventCtx), "jms/BMExternalEventQueue"});
                }
                JMSUtil.self().repostMessage(message);
                if (!MPUtil.isDebug()) return;
                MPUtil.getLogger().debugKey("BM_MPGW126", new Object[]{MPUtil.getInvalidEvtCtx(eventCtx), "jms/BMExternalEventQueue"});
                return;
            }
            catch (Throwable error) {
                throw (MonitoringProcessException)((Object)MPUtil.getMonitoringProcessES().createException("BM_MPGW114", "MPUtil.handleThrowable(Throwable,Message)", new Object[]{"jms/BMExternalEventQueue", eventCtx, message}, error));
            }
        } else {
            if (MPUtil.isDebug()) {
                MPUtil.getLogger().debugKey("BM_MPGW127", new Object[]{eventCtx});
            }
            MPUtil.sleep(60000L);
            throw mpEx;
        }
    }

    public static ExceptionService<InvalidEventDataException> getInvalidEventDataES() {
        return MPService.self().getInvalidEventDataES();
    }

    public static ExceptionService<MonitoringProcessException> getMonitoringProcessES() {
        return MPService.self().getMonitoringProcessES();
    }

    public static long getCreateTime(Object object, String context, Map eventCtx) {
        long timeValue = MPUtil.getValidTime(object, context, eventCtx, true);
        if (timeValue <= 0L) {
            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW129", "MPUtil.getCreateTime(Object,String,Map)", new Object[]{context, object, eventCtx}));
        }
        return timeValue;
    }

    public static long getValidTime(Object object, String context, Map eventCtx, boolean throwExceptionIfInvalid) {
        long timeValue = 0L;
        if (object == null) {
            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW115", "MPUtil.getValidTime(Object,String,Map,boolean)", new Object[]{context, eventCtx}));
        }
        if (object instanceof Date) {
            timeValue = ((Date)object).getTime();
        } else if (object instanceof Timestamp) {
            timeValue = ((Timestamp)object).getTime();
        } else if (object instanceof java.util.Date) {
            timeValue = ((java.util.Date)object).getTime();
        } else if (object instanceof Calendar) {
            timeValue = ((Calendar)object).getTimeInMillis();
        } else if (object instanceof Long) {
            timeValue = (Long)object;
        } else if (object instanceof Integer) {
            timeValue = ((Integer)object).intValue();
        } else {
            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW130", "MPUtil.getValidTime(Object,String,Map,boolean)", new Object[]{context, object, eventCtx}));
        }
        if (!MPUtil.validateDateTime(timeValue, context, eventCtx, throwExceptionIfInvalid)) {
            timeValue = 0L;
        }
        return timeValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap convertByteArrToHashMap(byte[] byteArr, String mapkey, Map context) {
        if (byteArr == null || byteArr.length == 0) {
            return new HashMap();
        }
        ByteArrayInputStream inputStream = null;
        Object object = null;
        try {
            inputStream = new ByteArrayInputStream(byteArr);
            object = MPUtil.convertToObject(inputStream);
            if (object == null || !(object instanceof HashMap)) {
                throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW140", "JMSService.convertByteArrToHashMap(byte[])", new Object[]{mapkey, context}));
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(inputStream);
            throw throwable;
        }
        FileUtil.close((InputStream)inputStream);
        return (HashMap)object;
    }
}

