/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.storeevent;

import com.savvion.sbm.bizlogic.storeevent.BSControl;
import com.savvion.sbm.bizlogic.storeevent.BSDataslot;
import com.savvion.sbm.bizlogic.storeevent.BSProcess;
import com.savvion.sbm.bizlogic.storeevent.BSUtil;
import com.savvion.sbm.bizlogic.storeevent.BizLogicEventMap;
import com.savvion.sbm.bizlogic.storeevent.BizStoreSchemaViewService;
import com.savvion.sbm.bizlogic.util.ProcessType;
import com.savvion.sbm.util.CommonEvent;
import com.savvion.sbm.util.DBService;
import com.savvion.sbm.util.SBMDAOService;
import com.savvion.sbm.util.SBMDatabase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class BSProcessTemplate
extends BSProcess {
    public static final String INSTANCE = "INSTANCE";
    public static final String GLOBAL = "GLOBAL";
    private static final String SQL_INSERT_PT = "INSERT INTO PROCESSTEMPLATE (PROCESS_TEMPLATE_ID, PROCESS_TEMPLATE_NAME, APP_NAME, PROCESS_MANAGER, PROCESS_INSTANCE_COUNTER, STATUS, PROCESS_TYPE, MONITORDS_NAME, CREATE_DATE, MODIFIED_DATE, CATEGORY) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_PTINFO = "UPDATE PROCESSTEMPLATE SET PROCESS_TYPE = ?, MONITORDS_NAME = ?, MODIFIED_DATE = ?, CATEGORY = ? WHERE PROCESS_TEMPLATE_ID = ?";
    private static final String SQL_INSERT_WSI = "INSERT INTO PROCESSWORKSTEPINFO (PROCESS_TEMPLATE_ID, WORKSTEP_ID, WORKSTEP_NAME, WORKSTEP_TYPE, MILESTONE_NAME, MILESTONE_DESC) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String SQL_UPDATE_PT = "UPDATE PROCESSTEMPLATE SET STATUS = ?, APP_NAME = ?  WHERE PROCESS_TEMPLATE_ID = ?";
    private static final String SQL_DELETE_PI = "DELETE FROM PROCESSINSTANCE WHERE PROCESS_TEMPLATE_ID = ?";
    private static final String SQL_DELETE_WS = "DELETE FROM WORKSTEP WHERE PROCESS_TEMPLATE_ID = ?";
    private static final String SQL_DELETE_WI = "DELETE FROM WORKITEM WHERE PROCESS_TEMPLATE_ID = ?";
    private static final String SQL_DELETE_CWI = "DELETE FROM CWORKITEM WHERE PROCESS_TEMPLATE_ID = ?";
    private static final String SQL_DELETE_CSTEP = "DELETE FROM CSTEP WHERE PROCESS_TEMPLATE_ID = ?";
    private static final String SQL_DELETE_CSTEPDS = "DELETE FROM CSTEP_DS WHERE PROCESS_TEMPLATE_ID = ?";
    private static final String SQL_DELETE_PNOTES = "DELETE FROM PROCESS_NOTES WHERE PROCESS_TEMPLATE_ID = ?";
    private static final String SQL_DELETE_PT = "DELETE FROM PROCESSTEMPLATE WHERE PROCESS_TEMPLATE_ID = ?";
    private static final String SQL_DELETE_PDI = "DELETE FROM PROCESSDATAINFO WHERE PROCESS_TEMPLATE_ID = ?";
    private static final String SQL_DELETE_WSI = "DELETE FROM PROCESSWORKSTEPINFO WHERE PROCESS_TEMPLATE_ID = ?";
    private static final String SQL_DELETE_SPI = "DELETE FROM SUBPROCESSINFO WHERE PROCESS_TEMPLATE_ID = ?";
    private static final String SQL_INSERT_VOTEINFO = "INSERT INTO WORKSTEPVOTEINFO (PROCESS_TEMPLATE_ID,WORKSTEP_NAME,TYPE,EXPECTED_COUNT,CHOICES,MAJORITY_DS,RESULT_DS) VALUES  ( ?,?,?,?,?,?,? ) ";
    private static final String SQL_DELETE_VOTEINFO = "DELETE FROM WORKSTEPVOTEINFO WHERE PROCESS_TEMPLATE_ID = ?";
    private static final String SQL_UPDATE_DS = "UPDATE PROCESSTEMPLATE SET INSTANCE_DATA_TABLE_NAME = ?, GLOBAL_DATA_TABLE_NAME = ? WHERE PROCESS_TEMPLATE_ID = ?";
    private static final String BIZ_STORE_MSG_1501 = "BizStore_MSG_1501";
    private static PreparedStatement stmt_insertWSI;
    private static PreparedStatement stmt_updatePT;
    private static PreparedStatement stmt_deletePI;
    private static PreparedStatement stmt_deleteWS;
    private static PreparedStatement stmt_deleteWI;
    private static PreparedStatement stmt_deleteCWI;
    private static PreparedStatement stmt_deleteCStep;
    private static PreparedStatement stmt_deleteCStepDS;
    private static PreparedStatement stmt_sql_deletePNotes;
    private static PreparedStatement stmt_deletePT;
    private static PreparedStatement stmt_deletePDI;
    private static PreparedStatement stmt_deleteWSI;
    private static PreparedStatement stmt_deleteSPI;
    private static PreparedStatement stmt_insertVoteInfo;
    private static PreparedStatement stmt_deleteVoteInfo;
    private static PreparedStatement stmt_updateDS;

    protected static void onCreate(CommonEvent event) throws Exception {
        try {
            BSProcessTemplate.insertProcessTemplate(event);
            BSProcessTemplate.insertProcessWorkstepInfos(event);
            BSDataslot.insertProcessDataInfos(event);
            BSProcessTemplate.insertWorkstepVoteInfo(event);
            BSProcessTemplate.updateProcessDataTableNames(event);
        }
        catch (Exception ex) {
            ptCache.remove(BizLogicEventMap.getProcessTemplateID(event));
            throw ex;
        }
    }

    protected static void onReplace(CommonEvent event) throws Exception {
        BSProcessTemplate.updateProcessTemplate(event);
        long ptid = BizLogicEventMap.getProcessTemplateID(event);
        String templateName = BSProcessTemplate.getName(ptid);
        BSProcessTemplate.deleteProcessDataAndWorkstepInfoOnReplace(templateName, ptid);
        BSProcessTemplate.removeProcessTemplateView(templateName, ptid, true);
        BSProcessTemplate.insertProcessWorkstepInfos(event);
        BSDataslot.replaceProcessDataInfos(event);
    }

    protected static synchronized void onInstall(CommonEvent event) throws Exception {
        Connection conn = null;
        try {
            conn = BSControl.util.getBSConnection();
            long ptid = BizLogicEventMap.getProcessTemplateID(event);
            String appName = BizLogicEventMap.getAppName(event);
            stmt_updatePT = conn.prepareStatement(SQL_UPDATE_PT);
            stmt_updatePT.setString(1, "P_INSTALLED");
            stmt_updatePT.setString(2, appName);
            stmt_updatePT.setLong(3, ptid);
            stmt_updatePT.executeUpdate();
        }
        catch (SQLException se) {
            BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_UPDATE_PT, se.getMessage()});
            throw se;
        }
        finally {
            SBMDAOService.clean(null, (Statement)stmt_updatePT, (Connection)conn);
        }
    }

    protected static void onRemove(CommonEvent event) throws Throwable {
        try {
            long ptid = BizLogicEventMap.getProcessTemplateID(event);
            String templateName = BSProcessTemplate.getName(ptid);
            BSProcessTemplate.removeProcessTemplateView(templateName, ptid, false);
            BSProcessTemplate.removeProcessTemplate(templateName, ptid);
        }
        catch (Throwable th) {
            ptCache.remove(BizLogicEventMap.getProcessTemplateID(event));
            throw th;
        }
    }

    protected static synchronized void onSuspend(CommonEvent event) throws SQLException {
        Connection conn = null;
        try {
            conn = BSControl.util.getBSConnection();
            long ptid = BizLogicEventMap.getProcessTemplateID(event);
            String appName = BizLogicEventMap.getAppName(event);
            stmt_updatePT = conn.prepareStatement(SQL_UPDATE_PT);
            stmt_updatePT.setString(1, "P_SUSPENDED");
            stmt_updatePT.setString(2, appName);
            stmt_updatePT.setLong(3, ptid);
            stmt_updatePT.executeUpdate();
        }
        catch (SQLException se) {
            BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_UPDATE_PT, se.getMessage()});
            throw se;
        }
        finally {
            SBMDAOService.clean(null, (Statement)stmt_updatePT, (Connection)conn);
        }
    }

    protected static synchronized void onResume(CommonEvent event) throws SQLException {
        Connection conn = null;
        try {
            conn = BSControl.util.getBSConnection();
            long ptid = BizLogicEventMap.getProcessTemplateID(event);
            String appName = BizLogicEventMap.getAppName(event);
            stmt_updatePT = conn.prepareStatement(SQL_UPDATE_PT);
            stmt_updatePT.setString(1, "P_INSTALLED");
            stmt_updatePT.setString(2, appName);
            stmt_updatePT.setLong(3, ptid);
            stmt_updatePT.executeUpdate();
        }
        catch (SQLException se) {
            BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_UPDATE_PT, se.getMessage()});
            throw se;
        }
        finally {
            SBMDAOService.clean(null, (Statement)stmt_updatePT, (Connection)conn);
        }
    }

    public static String getName(long templateId) {
        String templateName = ptCache.getPTName(templateId);
        return templateName;
    }

    protected static void createProcessTemplateView(Map<String, Object> viewInfo, boolean newTx) {
        String templateName = (String)viewInfo.get("PT_NAME");
        long ptId = (Long)viewInfo.get("PT_ID");
        String processViewName = BizStoreSchemaViewService.getProcessViewName(templateName);
        String createProcessViewSql = BizStoreSchemaViewService.getSqlCreateProcessView(processViewName, viewInfo);
        BSProcessTemplate.createView(templateName, ptId, processViewName, "process", createProcessViewSql, newTx);
        String wsViewName = BizStoreSchemaViewService.getWSViewName(templateName);
        String createWSViewSql = BizStoreSchemaViewService.getSqlCreateWSView(wsViewName, viewInfo);
        BSProcessTemplate.createView(templateName, ptId, wsViewName, "workstep", createWSViewSql, newTx);
    }

    private static void createView(String templateName, Long ptId, String viewName, String viewType, String createViewSql, boolean newTx) {
        try {
            if (templateName != null && templateName.trim().length() > 25) {
                BSUtil.logDynamicViewCreateError(createViewSql, templateName, ptId, viewType);
                return;
            }
            if (BSUtil.isViewExists(viewName)) {
                BSControl.logger.errorKey("BizStore_MSG_1608", new Object[]{templateName, viewType, viewName, createViewSql});
                return;
            }
            BSControl.logger.debugKey("BizStore_MSG_009", new Object[]{templateName, viewType, viewName, createViewSql});
            BSControl.util.executeDDLStmt(createViewSql, newTx);
            if (SBMDatabase.self().isDualDbUser()) {
                String strGrant = SBMDatabase.getSqlGrantStatementForView((String)viewName, (String)SBMDatabase.self().getAppUserRole());
                BSControl.util.executeDDLStmt(strGrant);
            }
            BSControl.logger.infoKey("BizStore_MSG_529", new Object[]{templateName, viewType, viewName});
        }
        catch (Throwable th) {
            BSControl.logger.errorKey("BizStore_MSG_1604", new Object[]{templateName, viewType, viewName, createViewSql}, th);
        }
    }

    protected static void removeProcessTemplateView(String templateName, long ptId, boolean newTx) {
        String processViewName = BizStoreSchemaViewService.getProcessViewName(templateName);
        String dropProcessViewSql = BizStoreSchemaViewService.getSqlDropProcessView(processViewName);
        BSProcessTemplate.removeView(templateName, ptId, processViewName, "process", dropProcessViewSql, newTx);
        String wsViewName = BizStoreSchemaViewService.getWSViewName(templateName);
        String dropWSViewSql = BizStoreSchemaViewService.getSqlDropWSView(wsViewName);
        BSProcessTemplate.removeView(templateName, ptId, wsViewName, "workstep", dropWSViewSql, newTx);
    }

    private static void removeView(String templateName, long ptId, String viewName, String viewType, String dropViewSql, boolean newTx) {
        if (templateName != null && templateName.trim().length() > 25) {
            BSControl.logger.errorKey("BizStore_MSG_1609", new Object[]{templateName, ptId, viewType, 25});
            return;
        }
        if (!BSUtil.isViewExists(viewName)) {
            BSControl.logger.errorKey("BizStore_MSG_1610", new Object[]{templateName, ptId, viewType, viewName});
            return;
        }
        try {
            BSControl.logger.debugKey("BizStore_MSG_010", new Object[]{templateName, viewType, viewName, dropViewSql});
            BSControl.util.executeDDLStmt(dropViewSql, newTx);
            BSControl.logger.infoKey("BizStore_MSG_530", new Object[]{templateName, viewType, viewName});
        }
        catch (Throwable th) {
            BSControl.logger.errorKey("BizStore_MSG_1605", new Object[]{templateName, viewType, viewName, dropViewSql}, th);
        }
    }

    private static void insertProcessTemplate(CommonEvent event) throws SQLException {
        String templateName = null;
        Connection conn = null;
        PreparedStatement stmt_insertPT = null;
        try {
            conn = BSControl.util.getBSConnection();
            stmt_insertPT = conn.prepareStatement(SQL_INSERT_PT);
            templateName = BizLogicEventMap.getProcessTemplateName(event);
            String appName = BizLogicEventMap.getAppName(event);
            String manager = BizLogicEventMap.getProcessManager(event);
            long ptid = BizLogicEventMap.getProcessTemplateID(event);
            ProcessType processtype = BizLogicEventMap.getProcessType(event);
            String monitorDSName = BizLogicEventMap.getMonitorDSName(event);
            String createdTime = BizLogicEventMap.getStartTime(event);
            Timestamp createdTS = BSUtil.stringToTimestamp(createdTime);
            String lastModifiedTime = String.valueOf(BizLogicEventMap.getLastModifiedTime(event));
            Timestamp lastModifiedTS = BSUtil.stringToTimestamp(lastModifiedTime);
            String category = BizLogicEventMap.getCategory(event);
            stmt_insertPT.setLong(1, ptid);
            stmt_insertPT.setString(2, templateName);
            stmt_insertPT.setString(3, appName);
            BSUtil.setValue(stmt_insertPT, 4, manager);
            stmt_insertPT.setInt(5, 0);
            stmt_insertPT.setString(6, "P_CREATED");
            stmt_insertPT.setInt(7, processtype.getId());
            if (monitorDSName != null && monitorDSName.trim().length() > 0) {
                stmt_insertPT.setString(8, monitorDSName);
            } else {
                stmt_insertPT.setNull(8, 12);
            }
            stmt_insertPT.setTimestamp(9, createdTS);
            stmt_insertPT.setTimestamp(10, lastModifiedTS);
            stmt_insertPT.setString(11, category);
            stmt_insertPT.executeUpdate();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_INSERT_PT, se.getMessage()});
                if (BSControl.DEBUG_ENGINE) {
                    BSControl.logger.debugKey("BizStore_MSG_1519", new Object[]{templateName, se.getMessage()});
                }
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, stmt_insertPT, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)stmt_insertPT, (Connection)conn);
    }

    private static void updateProcessTemplate(CommonEvent event) throws SQLException {
        long ptId = BizLogicEventMap.getProcessTemplateID(event);
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = BSControl.util.getBSConnection();
            pstmt = conn.prepareStatement(UPDATE_PTINFO);
            ProcessType processType = BizLogicEventMap.getProcessType(event);
            String monitorDSName = BizLogicEventMap.getMonitorDSName(event);
            String lastModifiedTime = String.valueOf(BizLogicEventMap.getLastModifiedTime(event));
            Timestamp lastModifiedTS = BSUtil.stringToTimestamp(lastModifiedTime);
            String category = BizLogicEventMap.getCategory(event);
            pstmt.setInt(1, processType.getId());
            if (monitorDSName != null && monitorDSName.trim().length() > 0) {
                pstmt.setString(2, monitorDSName);
            } else {
                pstmt.setNull(2, 12);
            }
            pstmt.setTimestamp(3, lastModifiedTS);
            pstmt.setString(4, category);
            pstmt.setLong(5, ptId);
            pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                BSControl.logger.errorKey(BIZ_STORE_MSG_1501, "BSProcessTemplate.updateProcessTemplate()", new Object[]{UPDATE_PTINFO, sqle.getMessage()});
                throw sqle;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateProcessDataTableNames(CommonEvent event) throws Exception {
        long ptid = BizLogicEventMap.getProcessTemplateID(event);
        boolean hasIDS = ptCache.hasInstanceDS(ptid);
        boolean hasGDS = ptCache.hasGlobalDS(ptid);
        if (!hasIDS && !hasGDS) {
            return;
        }
        String templateName = null;
        Connection conn = null;
        try {
            conn = BSControl.util.getBSConnection();
            templateName = BizLogicEventMap.getProcessTemplateName(event);
            String instanceDataTableName = DBService.polish((String)templateName);
            String globalDataTableName = "BS_" + ptid;
            Class<BSProcessTemplate> clazz = BSProcessTemplate.class;
            synchronized (BSProcessTemplate.class) {
                stmt_updateDS = conn.prepareStatement(SQL_UPDATE_DS);
                // ** MonitorExit[var9_9] (shouldn't be in output)
                if (hasIDS) {
                    stmt_updateDS.setString(1, instanceDataTableName);
                } else {
                    BSUtil.setValue(stmt_updateDS, 1, null);
                }
                if (hasGDS) {
                    stmt_updateDS.setString(2, globalDataTableName);
                } else {
                    BSUtil.setValue(stmt_updateDS, 2, null);
                }
                stmt_updateDS.setLong(3, ptid);
                stmt_updateDS.executeUpdate();
            }
        }
        catch (SQLException se) {
            BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_UPDATE_DS, se.getMessage()});
            if (BSControl.DEBUG_ENGINE) {
                BSControl.logger.debugKey("BizStore_MSG_1533", new Object[]{templateName, se.getMessage()});
            }
            throw se;
        }
        finally {
            SBMDAOService.clean(null, (Statement)stmt_updateDS, (Connection)conn);
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void insertProcessWorkstepInfos(CommonEvent event) throws SQLException {
        String processworkstepList = BizLogicEventMap.getProcessWorkstepList(event);
        long id = BizLogicEventMap.getProcessTemplateID(event);
        String templateName = BizLogicEventMap.getProcessTemplateName(event);
        if (processworkstepList == null) return;
        if (processworkstepList.trim().isEmpty()) {
            return;
        }
        StringTokenizer st = new StringTokenizer(processworkstepList, "|");
        String workstepName = null;
        String workstepType = null;
        String milestoneName = null;
        String milestoneDesc = null;
        long workstepId = -1L;
        while (st.hasMoreTokens()) {
            String worksteplist = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(worksteplist, "|;");
            while (st2.hasMoreTokens()) {
                if (st2.hasMoreTokens()) {
                    workstepName = st2.nextToken();
                }
                if (st2.hasMoreTokens()) {
                    workstepType = st2.nextToken();
                }
                if (st2.hasMoreTokens()) {
                    try {
                        workstepId = Long.parseLong(st2.nextToken());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (st2.hasMoreTokens()) {
                    milestoneName = st2.nextToken();
                }
                if (milestoneName != null && !"".equals(milestoneName)) {
                    milestoneDesc = BizLogicEventMap.getMilestoneDescription(event, milestoneName);
                }
                Connection conn = null;
                try {
                    conn = BSControl.util.getBSConnection();
                    Class<BSProcessTemplate> clazz = BSProcessTemplate.class;
                    // MONITORENTER : com.savvion.sbm.bizlogic.storeevent.BSProcessTemplate.class
                    stmt_insertWSI = conn.prepareStatement(SQL_INSERT_WSI);
                    stmt_insertWSI.setLong(1, id);
                    stmt_insertWSI.setLong(2, workstepId);
                    stmt_insertWSI.setString(3, workstepName);
                    stmt_insertWSI.setString(4, workstepType);
                    BSUtil.setValue(stmt_insertWSI, 5, milestoneName);
                    BSUtil.setValue(stmt_insertWSI, 6, milestoneDesc);
                    stmt_insertWSI.executeUpdate();
                    // MONITOREXIT : clazz
                }
                catch (SQLException e) {
                    BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_INSERT_WSI, e.getMessage()});
                    if (!BSControl.DEBUG_ENGINE) throw e;
                    BSControl.logger.debugKey("BizStore_MSG_1507", new Object[]{templateName, e.getMessage()});
                    throw e;
                }
                finally {
                    SBMDAOService.clean(null, (Statement)stmt_insertWSI, (Connection)conn);
                }
            }
            workstepName = null;
            workstepType = null;
            milestoneName = null;
            milestoneDesc = null;
            workstepId = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void insertWorkstepVoteInfo(CommonEvent event) throws SQLException {
        HashMap voteinfo = BizLogicEventMap.getProcessVoteInfo(event);
        if (voteinfo == null) {
            return;
        }
        long ptid = BizLogicEventMap.getProcessTemplateID(event);
        String templateName = BizLogicEventMap.getProcessTemplateName(event);
        Iterator iter = voteinfo.keySet().iterator();
        while (iter.hasNext()) {
            String wsName = (String)iter.next();
            HashMap map = (HashMap)voteinfo.get(wsName);
            Connection conn = null;
            try {
                conn = BSControl.util.getBSConnection();
                Class<BSProcessTemplate> clazz = BSProcessTemplate.class;
                // MONITORENTER : com.savvion.sbm.bizlogic.storeevent.BSProcessTemplate.class
                stmt_insertVoteInfo = conn.prepareStatement(SQL_INSERT_VOTEINFO);
                stmt_insertVoteInfo.setLong(1, ptid);
                stmt_insertVoteInfo.setString(2, wsName);
                String voteType = BizLogicEventMap.getVoteType(map);
                if (voteType == null) {
                    stmt_insertVoteInfo.setNull(3, 12);
                } else {
                    stmt_insertVoteInfo.setString(3, voteType);
                }
                Integer expCount = BizLogicEventMap.getExpectedCount(map);
                if (expCount == null) {
                    stmt_insertVoteInfo.setNull(4, 4);
                } else {
                    stmt_insertVoteInfo.setInt(4, expCount);
                }
                String voteChoices = BizLogicEventMap.getVoteChoices(map);
                if (voteChoices == null) {
                    stmt_insertVoteInfo.setNull(5, 12);
                } else {
                    if (voteChoices.length() > BSControl.util.MAX_CHOICES_SIZE) {
                        voteChoices = voteChoices.substring(0, BSControl.util.MAX_CHOICES_SIZE);
                    }
                    stmt_insertVoteInfo.setString(5, voteChoices);
                }
                String majorityDS = BizLogicEventMap.getMajorityDS(map);
                if (majorityDS == null) {
                    stmt_insertVoteInfo.setNull(6, 12);
                } else {
                    stmt_insertVoteInfo.setString(6, majorityDS);
                }
                String voteResultDS = BizLogicEventMap.getVoteResultDS(map);
                if (voteResultDS == null) {
                    stmt_insertVoteInfo.setNull(7, 12);
                } else {
                    stmt_insertVoteInfo.setString(7, voteResultDS);
                }
                stmt_insertVoteInfo.executeUpdate();
                // MONITOREXIT : clazz
            }
            catch (SQLException e) {
                BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{stmt_insertVoteInfo, e.getMessage()});
                if (!BSControl.DEBUG_ENGINE) throw e;
                BSControl.logger.debugKey("BizStore_MSG_1507", new Object[]{templateName, e.getMessage()});
                throw e;
            }
            finally {
                SBMDAOService.clean(null, (Statement)stmt_insertVoteInfo, (Connection)conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void removeProcessTemplate(String templateName, long id) throws Throwable {
        Connection conn = null;
        boolean hasIDS = ptCache.hasInstanceDS(id);
        boolean hasGDS = ptCache.hasGlobalDS(id);
        try {
            conn = BSControl.util.getBSConnection();
            BSProcessTemplate.deletePi(id, conn);
            BSProcessTemplate.deleteWs(id, conn);
            BSProcessTemplate.deleteVoteInfo(id, conn);
            BSProcessTemplate.deleteWi(id, conn);
            BSProcessTemplate.deleteCollaborativeStepDataSlots(id, conn);
            BSProcessTemplate.deleteCollaborativeSteps(id, conn);
            BSProcessTemplate.deleteCwi(id, conn);
            BSProcessTemplate.deletePNotes(id, conn);
            BSProcessTemplate.deletePt(id, conn);
            BSProcessTemplate.deletePdi(id, conn);
            BSProcessTemplate.deleteWsi(id, conn);
            BSProcessTemplate.deleteSpi(id, conn);
        }
        catch (RuntimeException | SQLException th) {
            BSControl.logger.errorKey("BizStore_MSG_1505", new Object[]{templateName});
        }
        finally {
            SBMDAOService.clean(null, null, (Connection)conn);
        }
        BSDataslot.dropDSTables(templateName, id, hasIDS, hasGDS);
        ptCache.remove(id);
    }

    private static void deletePt(long id, Connection conn) throws SQLException {
        try {
            stmt_deletePT = conn.prepareStatement(SQL_DELETE_PT);
            stmt_deletePT.setLong(1, id);
            stmt_deletePT.executeUpdate();
        }
        catch (SQLException se) {
            BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_DELETE_PT, se.getMessage()});
            throw se;
        }
        finally {
            SBMDAOService.clean(null, (Statement)stmt_deletePT, null);
        }
    }

    private static void deletePNotes(long id, Connection conn) throws SQLException {
        try {
            stmt_sql_deletePNotes = conn.prepareStatement(SQL_DELETE_PNOTES);
            stmt_sql_deletePNotes.setLong(1, id);
            stmt_sql_deletePNotes.executeUpdate();
        }
        catch (SQLException se) {
            BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_DELETE_PNOTES, se.getMessage()});
            throw se;
        }
        finally {
            SBMDAOService.clean(null, (Statement)stmt_sql_deletePNotes, null);
        }
    }

    private static void deleteCwi(long id, Connection conn) throws SQLException {
        try {
            stmt_deleteCWI = conn.prepareStatement(SQL_DELETE_CWI);
            stmt_deleteCWI.setLong(1, id);
            stmt_deleteCWI.executeUpdate();
        }
        catch (SQLException se) {
            BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_DELETE_CWI, se.getMessage()});
            throw se;
        }
        finally {
            SBMDAOService.clean(null, (Statement)stmt_deleteCWI, null);
        }
    }

    private static void deleteCollaborativeSteps(long id, Connection conn) throws SQLException {
        try {
            stmt_deleteCStep = conn.prepareStatement(SQL_DELETE_CSTEP);
            stmt_deleteCStep.setLong(1, id);
            stmt_deleteCStep.executeUpdate();
        }
        catch (SQLException se) {
            BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_DELETE_CSTEP, se.getMessage()});
            throw se;
        }
        finally {
            SBMDAOService.clean(null, (Statement)stmt_deleteCStep, null);
        }
    }

    private static void deleteCollaborativeStepDataSlots(long id, Connection conn) throws SQLException {
        try {
            stmt_deleteCStepDS = conn.prepareStatement(SQL_DELETE_CSTEPDS);
            stmt_deleteCStepDS.setLong(1, id);
            stmt_deleteCStepDS.executeUpdate();
        }
        catch (SQLException se) {
            BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_DELETE_CSTEPDS, se.getMessage()});
            throw se;
        }
        finally {
            SBMDAOService.clean(null, (Statement)stmt_deleteCStepDS, null);
        }
    }

    private static void deleteWi(long id, Connection conn) throws SQLException {
        try {
            stmt_deleteWI = conn.prepareStatement(SQL_DELETE_WI);
            stmt_deleteWI.setLong(1, id);
            stmt_deleteWI.executeUpdate();
        }
        catch (SQLException se) {
            BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_DELETE_WI, se.getMessage()});
            throw se;
        }
        finally {
            SBMDAOService.clean(null, (Statement)stmt_deleteWI, null);
        }
    }

    private static void deleteVoteInfo(long id, Connection conn) throws SQLException {
        try {
            stmt_deleteVoteInfo = conn.prepareStatement(SQL_DELETE_VOTEINFO);
            stmt_deleteVoteInfo.setLong(1, id);
            stmt_deleteVoteInfo.executeUpdate();
        }
        catch (SQLException se) {
            BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_DELETE_VOTEINFO, se.getMessage()});
            throw se;
        }
        finally {
            SBMDAOService.clean(null, (Statement)stmt_deleteWS, null);
        }
    }

    private static void deleteWs(long id, Connection conn) throws SQLException {
        try {
            stmt_deleteWS = conn.prepareStatement(SQL_DELETE_WS);
            stmt_deleteWS.setLong(1, id);
            stmt_deleteWS.executeUpdate();
        }
        catch (SQLException se) {
            BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_DELETE_WS, se.getMessage()});
            throw se;
        }
        finally {
            SBMDAOService.clean(null, (Statement)stmt_deleteWS, null);
        }
    }

    private static void deletePi(long id, Connection conn) throws SQLException {
        try {
            stmt_deletePI = conn.prepareStatement(SQL_DELETE_PI);
            stmt_deletePI.setLong(1, id);
            stmt_deletePI.executeUpdate();
        }
        catch (SQLException se) {
            BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_DELETE_PI, se.getMessage()});
            throw se;
        }
        finally {
            SBMDAOService.clean(null, (Statement)stmt_deletePI, null);
        }
    }

    private static void deleteWsi(long id, Connection conn) throws SQLException {
        try {
            stmt_deleteWSI = conn.prepareStatement(SQL_DELETE_WSI);
            stmt_deleteWSI.setLong(1, id);
            stmt_deleteWSI.executeUpdate();
        }
        catch (SQLException se) {
            BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_DELETE_WSI, se.getMessage()});
            throw se;
        }
        finally {
            SBMDAOService.clean(null, (Statement)stmt_deleteWSI, null);
        }
    }

    private static void deleteSpi(long id, Connection conn) throws SQLException {
        try {
            stmt_deleteSPI = conn.prepareStatement(SQL_DELETE_SPI);
            stmt_deleteSPI.setLong(1, id);
            stmt_deleteSPI.executeUpdate();
        }
        catch (SQLException se) {
            BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_DELETE_SPI, se.getMessage()});
            throw se;
        }
        finally {
            SBMDAOService.clean(null, (Statement)stmt_deleteSPI, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void deleteProcessDataAndWorkstepInfoOnReplace(String templateName, long id) throws Exception {
        Connection conn = null;
        try {
            conn = BSControl.util.getBSConnection();
            BSProcessTemplate.deleteWsi(id, conn);
            BSProcessTemplate.deletePdi(id, conn);
        }
        catch (Throwable th) {
            BSControl.logger.errorKey("BizStore_MSG_1505", new Object[]{templateName});
        }
        finally {
            SBMDAOService.clean(null, null, (Connection)conn);
        }
    }

    private static void deletePdi(long id, Connection conn) throws SQLException {
        try {
            stmt_deletePDI = conn.prepareStatement(SQL_DELETE_PDI);
            stmt_deletePDI.setLong(1, id);
            stmt_deletePDI.executeUpdate();
        }
        catch (SQLException se) {
            BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_DELETE_PDI, se.getMessage()});
            throw se;
        }
        finally {
            SBMDAOService.clean(null, (Statement)stmt_deletePDI, null);
        }
    }

    public static void printSQLStatements() {
        BSControl.logger.debug((Object)"BSProcessTemplate.printSQLStatements:");
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_INSERT_PT});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_INSERT_WSI});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_UPDATE_PT});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_DELETE_PI});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_DELETE_WS});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_DELETE_WI});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_DELETE_CWI});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_DELETE_CSTEP});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_DELETE_CSTEPDS});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_DELETE_PT});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_DELETE_PDI});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_DELETE_WSI});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_DELETE_SPI});
    }
}

