/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.storeevent;

import com.savvion.sbm.bizlogic.storeevent.BSControl;
import com.savvion.sbm.bizlogic.storeevent.BSProcess;
import com.savvion.sbm.bizlogic.storeevent.BizLogicEventMap;
import com.savvion.sbm.util.CommonEvent;
import com.savvion.sbm.util.SBMDAOService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Set;

public class BSWIResourceUsage
extends BSProcess {
    private static final String SQL_INSERT_WIRU = "INSERT INTO WI_RESOURCE_USAGE ( PROCESS_TEMPLATE_ID, PROCESS_INSTANCE_ID, RESOURCE_NAME, WORKITEM_ID, RESOURCE_USAGE, COST) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String SQL_DELETE_WIRU = "DELETE FROM WI_RESOURCE_USAGE WHERE PROCESS_TEMPLATE_ID = ?";
    private static PreparedStatement stmtInsertWIRU;
    private static PreparedStatement stmtDeleteWIRU;

    protected static synchronized void onStatusChange(CommonEvent event) throws SQLException {
        Connection conn = null;
        try {
            conn = BSControl.util.getBSConnection();
            String status = BizLogicEventMap.getStatusString(event);
            if ("I_COMPLETED".equals(status)) {
                long ptId = BizLogicEventMap.getProcessTemplateID(event);
                HashMap<String, Double> resMap = BSWIResourceUsage.getProcessResourceInfo(ptId);
                if (resMap == null) {
                    return;
                }
                long wiId = BizLogicEventMap.getWorkitemID(event);
                long piId = BizLogicEventMap.getProcessInstanceID(event);
                Set<String> resSet = resMap.keySet();
                stmtInsertWIRU = conn.prepareStatement(SQL_INSERT_WIRU);
                stmtInsertWIRU.clearBatch();
                for (String resName : resSet) {
                    double noOfUnits;
                    Double unitCost = (double)resMap.get(resName);
                    Double noUnits = (Double)event.getContext().get("RES_" + resName);
                    if (noUnits == null || !(Math.abs((noOfUnits = noUnits.doubleValue()) - 0.0) > 1.0E-8)) continue;
                    stmtInsertWIRU.setLong(1, ptId);
                    stmtInsertWIRU.setLong(2, piId);
                    stmtInsertWIRU.setString(3, resName);
                    stmtInsertWIRU.setLong(4, wiId);
                    stmtInsertWIRU.setDouble(5, noOfUnits);
                    stmtInsertWIRU.setDouble(6, unitCost * noOfUnits);
                    stmtInsertWIRU.addBatch();
                }
                stmtInsertWIRU.executeBatch();
            }
        }
        catch (SQLException se) {
            BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_INSERT_WIRU, se.getMessage()});
            throw se;
        }
        finally {
            SBMDAOService.clean(null, (Statement)stmtInsertWIRU, (Connection)conn);
        }
    }

    public static synchronized void removeProcessResources(CommonEvent event) throws SQLException {
        Connection conn = null;
        try {
            conn = BSControl.util.getBSConnection();
            long ptId = BizLogicEventMap.getProcessTemplateID(event);
            stmtDeleteWIRU = conn.prepareStatement(SQL_DELETE_WIRU);
            stmtDeleteWIRU.setLong(1, ptId);
            stmtDeleteWIRU.executeUpdate();
        }
        catch (SQLException se) {
            BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_DELETE_WIRU, se.getMessage()});
            throw se;
        }
        finally {
            SBMDAOService.clean(null, (Statement)stmtDeleteWIRU, (Connection)conn);
        }
    }

    public static void printSQLStatements() {
        BSControl.logger.debug((Object)"BSWIResourceUsage.printSQLStatements:");
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_INSERT_WIRU});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_DELETE_WIRU});
    }
}

