/*
 * Decompiled with CFR 0.152.
 */
package com.tdiinc.BizLogic.Server;

import com.savvion.sbm.bizlogic.util.BLConstants;
import com.tdiinc.BizLogic.Server.PAKException;
import java.io.Serializable;
import java.util.StringTokenizer;

public class PAKClientData
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -958132656182997290L;
    private boolean ischanged = false;
    private final String name;
    private final String mappedto;
    private final String type;
    private final String mime;
    private Object value;
    private final String comment;
    private final String choices;
    private final String processName;
    private long piid = -1L;
    private boolean isReadOnly = false;
    private boolean multiLine = false;
    private Object appendWith = null;
    public boolean userMapped = false;
    public String label = null;
    public boolean required = false;
    public String session = null;
    public static String LONG_SLOT = "LONG";
    public static String DOUBLE_SLOT = "DOUBLE";
    public static String STRING_SLOT = "STRING";
    public static String DOCUMENT_SLOT = "DOCUMENT";
    public static String URL_SLOT = "URL";
    public static String BOOLEAN_SLOT = "BOOLEAN";
    public static String OBJECT_SLOT = "OBJECT";
    public static final String DECIMAL_SLOT = "DECIMAL";
    public static final String DATETIME_SLOT = "DATETIME";
    public static final String XML_SLOT = "XML";
    public static final String SET_SLOT = "SET";
    public static final String LIST_SLOT = "LIST";
    public static final String MAP_SLOT = "MAP";

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Throwable th) {
            throw new RuntimeException("Unable to Clone the PAKClientData Object", th);
        }
    }

    public PAKClientData(long piid, String pName, String name, String map, String type, String mime, Object v, String comment, String choices, boolean multiLine, String lbl, boolean required, boolean readonly) {
        if (v != null) {
            BLConstants.single();
            if (type.equals("STRING") && !(v instanceof String)) {
                throw new PAKException("DataSlot String Type mismatch ...");
            }
            BLConstants.single();
            if (type.equals("LONG") && !(v instanceof Long)) {
                throw new PAKException("DataSlot Long Type mismatch ...");
            }
            BLConstants.single();
            if (type.equals("DOUBLE") && !(v instanceof Double)) {
                throw new PAKException("DataSlot Double Type mismatch ...");
            }
            BLConstants.single();
            if (type.equals("BOOLEAN") && !(v instanceof Boolean)) {
                throw new PAKException("DataSlot Boolean Type mismatch ...");
            }
            BLConstants.single();
            if (type.equals("URL") && !(v instanceof String)) {
                throw new PAKException("DataSlot URL Type mismatch ...");
            }
        }
        this.piid = piid;
        this.processName = pName;
        this.name = name;
        this.mappedto = map;
        this.type = type;
        this.mime = mime;
        this.value = v;
        this.comment = comment;
        this.choices = choices;
        this.multiLine = multiLine;
        this.label = lbl;
        this.required = required;
        this.isReadOnly = readonly;
    }

    public PAKClientData(long piid, String pName, String name, String map, String type, String mime, Object v, String comment, String choices, boolean multiLine, boolean required, String lbl) {
        this(piid, pName, name, map, type, mime, v, comment, choices, multiLine, lbl, required, true);
    }

    public PAKClientData(long piid, String pName, String name, String map, String type, String mime, Object v, String comment, String choices, boolean multiLine) {
        this(piid, pName, name, map, type, mime, v, comment, choices, multiLine, name, false, true);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getMapping() {
        return this.mappedto;
    }

    public String getMime() {
        return this.mime;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isMultiLine() {
        return this.multiLine;
    }

    public void setValue(Object v) {
        if (this.isReadOnly()) {
            return;
        }
        if (v == null) {
            if (this.value != null) {
                this.value = v;
                this.ischanged = true;
            }
        } else if (this.value == null || !this.value.equals(v) || this.isXML() || this.isDocument()) {
            this.value = v;
            this.ischanged = true;
        }
    }

    public void setValueX(String s) {
        if (this.isString() || this.isObject() || this.isDocument()) {
            this.setValue(s);
        }
        if (this.isLong()) {
            Long l = Long.valueOf(s.trim());
            this.setValue(l);
        }
        if (this.isDouble()) {
            Double d = Double.valueOf(s.trim());
            this.setValue(d);
        }
        if (this.isBoolean()) {
            if ("TRUE".equals((s = s.trim()).toUpperCase()) || "YES".equals(s.toUpperCase()) || "OK".equals(s.toUpperCase())) {
                this.setValue(Boolean.TRUE);
            } else if ("FALSE".equals(s.toUpperCase()) || "NO".equals(s.toUpperCase())) {
                this.setValue(Boolean.FALSE);
            } else {
                throw new PAKException("can not convert to Boolean (should have value true/false or  yes,ok/no !!!");
            }
        }
        if (this.isURL()) {
            this.setValue(s.trim());
        }
    }

    public boolean isString() {
        String string = this.getType();
        BLConstants.single();
        return string.equals("STRING");
    }

    public boolean isLong() {
        String string = this.getType();
        BLConstants.single();
        return string.equals("LONG");
    }

    public boolean isBoolean() {
        String string = this.getType();
        BLConstants.single();
        return string.equals("BOOLEAN");
    }

    public boolean isDocument() {
        String string = this.getType();
        BLConstants.single();
        return string.equals("DOCUMENT");
    }

    public boolean isDecimal() {
        String string = this.getType();
        BLConstants.single();
        return string.equals(DECIMAL_SLOT);
    }

    public boolean isList() {
        String string = this.getType();
        BLConstants.single();
        return string.equals(LIST_SLOT);
    }

    public boolean isDateTime() {
        String string = this.getType();
        BLConstants.single();
        return string.equals(DATETIME_SLOT);
    }

    public boolean isXML() {
        String string = this.getType();
        BLConstants.single();
        return string.equals(XML_SLOT);
    }

    public boolean isURL() {
        String string = this.getType();
        BLConstants.single();
        return string.equals("URL");
    }

    public boolean isObject() {
        String string = this.getType();
        BLConstants.single();
        return string.equals("OBJECT");
    }

    public boolean isDouble() {
        String string = this.getType();
        BLConstants.single();
        return string.equals("DOUBLE");
    }

    public String getComment() {
        return this.comment;
    }

    public String getChoices() {
        return this.choices;
    }

    public void makeReadOnly() {
        this.isReadOnly = true;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean hasChoices() {
        return this.choices != null;
    }

    public String[] getChoicesList() {
        int x = 0;
        if (this.choices == null) {
            return null;
        }
        BLConstants.single();
        StringTokenizer tok = new StringTokenizer(this.choices, "|");
        if (tok.countTokens() == 0) {
            return null;
        }
        String[] tmp = new String[tok.countTokens()];
        while (tok.hasMoreTokens()) {
            tmp[x++] = tok.nextToken();
        }
        return tmp;
    }

    public String getProcessName() {
        return this.processName;
    }

    public boolean isChanged() {
        return this.ischanged;
    }

    public Object getAppendWith() {
        return this.appendWith;
    }

    public void setAppendWith(Object aw) {
        this.appendWith = aw;
    }

    public boolean isUserMapped() {
        return this.userMapped;
    }

    public String getLabel() {
        return this.getName();
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getSession() {
        return this.session;
    }

    public long getProcessInstanceID() {
        return this.piid;
    }
}

