/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.messaging.subscriber;

import com.savvion.sbm.bizlogic.messaging.MsgErrorHandler;
import com.savvion.sbm.bizlogic.messaging.subscriber.BLBizMessage;
import com.savvion.sbm.util.JMSMessageData;
import com.savvion.sbm.util.JMSMessageUtil;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class BizJMSMessage
extends BLBizMessage {
    static final long serialVersionUID = 5600135935212552701L;
    private JMSMessageData jmsMsgData = null;
    private transient TextMessage message;
    private String payload;
    private transient String msgName;

    public BizJMSMessage(Object message) {
        if (message == null) {
            throw MsgErrorHandler.createEx("BizLogic_ERR_3605", "BizJMSMessage.<init>");
        }
        try {
            this.message = (TextMessage)message;
            this.jmsMsgData = JMSMessageUtil.self().convertToMessageData((Message)message);
        }
        catch (ClassCastException e) {
            throw MsgErrorHandler.createEx("BizLogic_ERR_3606", "BizJMSMessage.<init>", new Object[]{message});
        }
        try {
            this.getPayloadDocument();
        }
        catch (Exception e) {
            throw MsgErrorHandler.createEx("BizLogic_ERR_3608", "BizJMSMessage.getPayload", new Object[]{this.getMessageName()}, e);
        }
    }

    @Override
    public boolean isSerializable() {
        return this.getTextMessage() instanceof Serializable;
    }

    @Override
    public final String getMessageName() {
        if (this.msgName == null) {
            try {
                this.msgName = this.getTextMessage().getStringProperty("MessageName");
            }
            catch (JMSException jmse) {
                throw MsgErrorHandler.createEx("BizLogic_ERR_3607", "BLBizJMSMessage.getMessageName", new Object[]{"MessageName", this.getTextMessage()});
            }
        }
        return this.msgName;
    }

    @Override
    public String getPassword() {
        return this.getProperty("MessagePassword");
    }

    @Override
    public Object getMessage() {
        return this.getTextMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextMessage getTextMessage() {
        block6: {
            try {
                if (null != this.message) break block6;
                BizJMSMessage bizJMSMessage = this;
                synchronized (bizJMSMessage) {
                    if (null == this.message) {
                        this.message = (TextMessage)JMSMessageUtil.self().convertToJMSMessage(this.jmsMsgData);
                    }
                }
            }
            catch (Throwable th) {
                throw MsgErrorHandler.createEx("BizLogic_ERR_8103", "BizJMSMessage.getTextMessage()", new Object[]{this.jmsMsgData, this.getMessageName()}, th);
            }
        }
        return this.message;
    }

    @Override
    public String getPayload() {
        try {
            if (this.payload == null) {
                this.payload = this.getTextMessage().getText();
            }
            return this.payload;
        }
        catch (Exception e) {
            throw MsgErrorHandler.createEx("BizLogic_ERR_3608", "BizJMSMessage.getPayload", new Object[]{this.getMessageName()}, e);
        }
    }

    @Override
    public long getReceivedTime() {
        if (this.propertyExists("JMSXRcvTimestamp")) {
            return this.getLongProperty("JMSXRcvTimestamp");
        }
        return System.currentTimeMillis();
    }

    @Override
    public boolean propertyExists(String propName) {
        if (propName == null || propName.trim().length() == 0) {
            return false;
        }
        try {
            return this.getTextMessage().propertyExists(propName);
        }
        catch (JMSException e) {
            throw MsgErrorHandler.createEx("BizLogic_ERR_3607", "BizJMSMessage.propertyExists", new Object[]{propName, this.getMessageName()}, e);
        }
    }

    @Override
    public String getProperty(String name) {
        return this.getStringProperty(name);
    }

    @Override
    public boolean senderTaskNameExists() {
        return this.propertyExists("SenderTaskName");
    }

    @Override
    public String getSenderTaskName() {
        return this.getProperty("SenderTaskName");
    }

    @Override
    public boolean senderAppNameExists() {
        return this.propertyExists("SenderAppName");
    }

    @Override
    public String getSenderAppName() {
        return this.getProperty("SenderAppName");
    }

    @Override
    public boolean senderTemplateNameExists() {
        return this.propertyExists("SenderTemplateName");
    }

    @Override
    public String getSenderTemplateName() {
        return this.getProperty("SenderTemplateName");
    }

    @Override
    public boolean senderInstanceIDExists() {
        return this.propertyExists("SenderInstanceId");
    }

    @Override
    public long getSenderInstanceID() {
        return Long.parseLong(this.getProperty("SenderInstanceId"));
    }

    @Override
    public boolean senderEmailExists() {
        return this.propertyExists("SenderEmail");
    }

    @Override
    public String getSenderEmail() {
        return this.getProperty("SenderEmail");
    }

    @Override
    public boolean receiverTaskNameExists() {
        return this.propertyExists("ReceiverTaskName");
    }

    @Override
    public String getReceiverTaskName() {
        return this.getProperty("ReceiverTaskName");
    }

    @Override
    public boolean receiverAppNameExists() {
        return this.propertyExists("ReceiverAppName");
    }

    @Override
    public String getReceiverAppName() {
        return this.getProperty("ReceiverAppName");
    }

    @Override
    public boolean receiverInstanceIDExists() {
        return this.propertyExists("ReceiverInstanceId");
    }

    @Override
    public long getReceiverInstanceID() {
        return Long.parseLong(this.getProperty("ReceiverInstanceId"));
    }

    @Override
    public boolean receiverPriorityExists() {
        return this.propertyExists("ReceiverPriority");
    }

    @Override
    public String getReceiverPriority() {
        return this.getProperty("ReceiverPriority");
    }

    @Override
    public boolean receiverInstanceAliasExists() {
        return this.propertyExists("ReceiverInstanceAlias");
    }

    @Override
    public boolean senderNameExists() {
        return this.propertyExists("SenderName");
    }

    @Override
    public String getReceiverInstanceAlias() {
        return this.getProperty("ReceiverInstanceAlias");
    }

    @Override
    public String getSenderName() {
        return this.getProperty("SenderName");
    }

    @Override
    public String getStringProperty(String name) {
        if (name == null || name.trim().length() == 0) {
            throw this.propertyNotFound("String", "NULL/EMPTY", null);
        }
        String propval = this.evaluateXPath(name);
        if (propval != null) {
            return propval;
        }
        try {
            propval = this.getTextMessage().getStringProperty(name);
            if (propval == null && "SenderCorrelationId".equals(name) && ((propval = this.getTextMessage().getJMSCorrelationID()) == null || propval.trim().isEmpty())) {
                throw this.propertyNotFound("String", name, null);
            }
            return propval;
        }
        catch (JMSException e) {
            throw this.propertyNotFound("String", name, (Exception)((Object)e));
        }
    }

    @Override
    public long getLongProperty(String name) {
        if (name == null || name.trim().length() == 0) {
            throw this.propertyNotFound("Long", "NULL/EMPTY", null);
        }
        String propval = this.evaluateXPath(name);
        if (propval != null) {
            try {
                return Long.parseLong(propval);
            }
            catch (NumberFormatException e) {
                throw this.propertyNotFound("Long", name, e);
            }
        }
        try {
            return this.getTextMessage().getLongProperty(name);
        }
        catch (JMSException e) {
            throw this.propertyNotFound("Long", name, (Exception)((Object)e));
        }
    }

    @Override
    public double getDoubleProperty(String name) {
        if (name == null || name.trim().length() == 0) {
            throw this.propertyNotFound("Double", "NULL/EMPTY", null);
        }
        String propval = this.evaluateXPath(name);
        if (propval != null) {
            try {
                return Double.parseDouble(propval);
            }
            catch (NumberFormatException e) {
                throw this.propertyNotFound("Double", name, e);
            }
        }
        try {
            return this.getTextMessage().getDoubleProperty(name);
        }
        catch (JMSException e) {
            throw this.propertyNotFound("Double", name, (Exception)((Object)e));
        }
    }

    @Override
    public boolean getBooleanProperty(String name) {
        if (name == null || name.trim().length() == 0) {
            throw this.propertyNotFound("Boolean", "NULL/EMPTY", null);
        }
        String propval = this.evaluateXPath(name);
        if (propval != null) {
            return Boolean.getBoolean(propval);
        }
        try {
            return this.getTextMessage().getBooleanProperty(name);
        }
        catch (JMSException e) {
            throw this.propertyNotFound("Boolean", name, (Exception)((Object)e));
        }
    }

    @Override
    public Object getObjectProperty(String name) {
        if (name == null || name.trim().length() == 0) {
            throw this.propertyNotFound("Object", "NULL/EMPTY", null);
        }
        String propval = this.evaluateXPath(name);
        if (propval != null) {
            return propval;
        }
        try {
            return this.getTextMessage().getObjectProperty(name);
        }
        catch (JMSException e) {
            throw this.propertyNotFound("Object", name, (Exception)((Object)e));
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        String id = "";
        String messageName = "";
        if (this.getID() == -1L) {
            try {
                id = ((Message)this.getMessage()).getJMSMessageID();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        buffer.append("<JMS>");
        buffer.append("<Msg-ID=" + id + ">");
        buffer.append("<NAME=" + messageName + ">");
        return buffer.toString();
    }
}

