/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.scheduler;

import com.savvion.sbm.bizlogic.scheduler.SchedulerUtil;
import com.savvion.sbm.bizlogic.smp.util.SMPConfig;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.replication.ReplicationManager;
import com.savvion.sbm.replication.service.IServiceHandler;
import com.savvion.sbm.replication.service.ServiceRegister;
import com.savvion.sbm.util.MessageFactory;
import com.savvion.sbm.util.QuartzSchedulerService;
import com.savvion.sbm.util.SBMConstants;
import com.savvion.sbm.util.logger.LoggerManager;
import com.savvion.sbm.util.logger.SBMLogger;

public class BLScheduler {
    private static QuartzSchedulerService qrtzSchedService = null;
    private static BLScheduler self = null;
    private boolean isStarted = false;
    private boolean isPaused = false;
    private SBMLogger logger;
    private MessageFactory msgFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BLScheduler self() {
        if (self != null) return self;
        Class<BLScheduler> clazz = BLScheduler.class;
        synchronized (BLScheduler.class) {
            if (self != null) return self;
            self = new BLScheduler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return self;
        }
    }

    private BLScheduler() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        try {
            LoggerManager loggerManager = LoggerManager.self();
            SBMConstants.self().getClass();
            BLConstants.single();
            BLConstants.single();
            this.logger = loggerManager.createLogger("BizLogic", "sbmlog.conf", "BLMessages", BLScheduler.class.getClassLoader());
            this.msgFactory = this.logger.getMessageFactory();
            ServiceRegister.self().registerService((IServiceHandler)new BLSchedulerHandler());
            Class<BLScheduler> clazz = BLScheduler.class;
            synchronized (BLScheduler.class) {
                qrtzSchedService = new QuartzSchedulerService(SchedulerUtil.self().getSchedulerProps(), this.logger);
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Throwable th) {
            StringBuilder stringBuilder = new StringBuilder().append("Error occurred initializing the QuartzSchedulerService and logger for component <");
            SBMConstants.self().getClass();
            throw new RuntimeException(stringBuilder.append("BizLogic").append(">").toString(), th);
        }
        {
            return;
        }
    }

    public synchronized void start() {
        String ctx = "BLScheduler.start()";
        try {
            if (ReplicationManager.self().isPrimaryDatabase()) {
                this.validateScheduledJob("EventJob", "MonitoringJobGroup", "EventTrigger", "MonitoringTriggerGroup");
                this.validateScheduledJob("WaitWSJob", "MonitoringJobGroup", "WaitWSTrigger", "MonitoringTriggerGroup");
                this.validateScheduledJob("HistoryJob", "MonitoringJobGroup", "HistoryTrigger", "MonitoringTriggerGroup");
                this.validateScheduledJob("PurgeEventJob", "MonitoringJobGroup", "PurgeEventTrigger", "MonitoringTriggerGroup");
                qrtzSchedService.startScheduler();
                this.isStarted = true;
                this.logInfo("BizLogic_ERR_4108", ctx, "started");
            } else {
                this.logInfo("BizLogic_ERR_4109", ctx, new Object[0]);
            }
        }
        catch (Throwable th) {
            this.logger.errorKey("BizLogic_ERR_4688", ctx, th, new Object[]{"starting"});
            throw this.createException("BizLogic_ERR_4688", ctx, th, "starting");
        }
    }

    public synchronized void stop() {
        String ctx = "BLScheduler.stop()";
        try {
            qrtzSchedService.shutdownScheduler(true);
            this.isStarted = false;
            this.logInfo("BizLogic_ERR_4108", ctx, "stopped");
        }
        catch (Throwable th) {
            this.logger.errorKey("BizLogic_ERR_4688", ctx, th, new Object[]{"stopping"});
            throw this.createException("BizLogic_ERR_4688", ctx, th, "stopping");
        }
        finally {
            qrtzSchedService = null;
        }
    }

    public synchronized void pause() {
        String ctx = "BLScheduler.pause()";
        try {
            qrtzSchedService.pauseAll();
            this.isPaused = true;
            this.logInfo("BizLogic_ERR_4108", ctx, "paused");
        }
        catch (Throwable th) {
            throw this.createException("BizLogic_ERR_4688", ctx, th, "pausing");
        }
    }

    public synchronized void resume() {
        String ctx = "BLScheduler.resume()";
        try {
            qrtzSchedService.resumeAll();
            if (!SMPConfig.self().isPurgeEvents()) {
                BLScheduler.self().pauseJob("PurgeEventJob", "MonitoringJobGroup", "PurgeEventTrigger", "MonitoringTriggerGroup");
            }
            this.isPaused = false;
            this.logInfo("BizLogic_ERR_4108", ctx, "resumed");
        }
        catch (Throwable th) {
            throw this.createException("BizLogic_ERR_4688", ctx, th, "resuming");
        }
    }

    public synchronized boolean isStarted() {
        return this.isStarted;
    }

    public synchronized boolean isPaused() {
        return this.isPaused;
    }

    public synchronized boolean isStopped() {
        return !this.isStarted;
    }

    public synchronized boolean isResumed() {
        return !this.isPaused;
    }

    public static synchronized void clean() {
        BLScheduler.self().close();
        self = null;
    }

    private synchronized void close() {
        qrtzSchedService = null;
        this.isStarted = false;
        this.isPaused = false;
        this.logger = null;
        this.msgFactory = null;
    }

    private void validateScheduledJob(String jobName, String jobGroupName, String triggerName, String trgGroupName) {
        if (!qrtzSchedService.isJobScheduled(jobName, jobGroupName, triggerName, trgGroupName)) {
            throw this.createException("BizLogic_ERR_4690", "BLScheduler.validateScheduledJob()", jobName, jobGroupName, triggerName, trgGroupName);
        }
    }

    private RuntimeException createException(String msgId, String ctx, Object ... args) {
        return this.createException(msgId, ctx, null, args);
    }

    private RuntimeException createException(String msgId, String ctx, Throwable th, Object ... args) {
        String msg = this.msgFactory.lookup(msgId, args, ctx);
        this.logger.error((Object)msg, th);
        return new RuntimeException(msg, th);
    }

    private void logInfo(String msgId, String ctx, Object ... args) {
        this.logger.infoKey(msgId, ctx, args);
    }

    public void pauseJob(String jobName, String jobGroupName, String triggerName, String trgGroupName) {
        try {
            if (qrtzSchedService.isJobScheduled(jobName, jobGroupName, triggerName, trgGroupName)) {
                qrtzSchedService.pauseJob(jobName, jobGroupName);
                this.logInfo("BizLogic_ERR_4834", "BLScheduler.pauseJob()", jobName, jobGroupName);
            }
        }
        catch (Throwable th) {
            throw this.createException("BizLogic_ERR_4832", "BLScheduler.pauseJob()", th, jobName, jobGroupName);
        }
    }

    public void resumeJob(String jobName, String jobGroupName) {
        try {
            if (this.isStarted()) {
                qrtzSchedService.resumeJob(jobName, jobGroupName);
                this.logInfo("BizLogic_ERR_4835", "BLScheduler.resumeJob()", jobName, jobGroupName);
            }
        }
        catch (Throwable th) {
            throw this.createException("BizLogic_ERR_4833", "BLScheduler.resumeJob()", th, jobName, jobGroupName);
        }
    }

    private class BLSchedulerHandler
    implements IServiceHandler {
        private BLSchedulerHandler() {
        }

        public String getServiceName() {
            return "BLScheduler";
        }

        public void startService() {
            BLScheduler.this.start();
            if (!BLScheduler.this.isPaused()) {
                BLScheduler.this.resume();
            }
        }

        public void stopService() {
            BLScheduler.this.stop();
        }

        public boolean isServiceRunning() {
            return BLScheduler.this.isStarted() && BLScheduler.this.isResumed();
        }
    }
}

