/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.server.Performer;
import com.savvion.sbm.bizlogic.server.WFAtomicInstance;
import com.savvion.sbm.bizlogic.server.WFAtomicWS;
import com.savvion.sbm.bizlogic.server.WFExternalWS;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFWorkItem;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.WFWorkstepInstance;
import com.savvion.sbm.bizlogic.server.dao.DebugServiceDAO;
import com.savvion.sbm.bizlogic.server.ejb.WorkItemEBLocal;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceEBLocal;
import com.savvion.sbm.bizlogic.server.svo.SVOFactory;
import com.savvion.sbm.bizlogic.server.svo.WorkStepInstance;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.Session;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DebugService {
    private static DebugService self;
    private static final String EXECUTE_WORKSTEP = "executeWorkStep";
    private static final String EXECUTE_HUMAN_WORKSTEP = "executeHumanWorkStep";
    private static final String EXECUTE_WORKSTEPS = "executeWorkSteps";
    private static final String EXECUTE_INSTANCE = "executeInstance";
    private static final String SKIP_WORKSTEP = "skipWorkStep";
    private static final String WORKSTEP_TO_ACTIVATE = "getWorkStepsToActivate";
    public static final int BP_BEFOREACTIVATION = 1;
    public static final String DEBUG_PROCESS_INSTANCE = "DEBUG_PROCESS_INSTANCE";
    public static final String STOP_AT_WORKSTEP = "STOP_AT_WORKSTEP";
    public static final String END_WS = "END";
    private HashMap<Long, DebugContext> contextMap = new HashMap();
    private HashMap<Long, Boolean> piDebugMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DebugService self() {
        if (self != null) return self;
        Class<DebugService> clazz = DebugService.class;
        synchronized (DebugService.class) {
            if (self != null) return self;
            self = new DebugService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return self;
        }
    }

    public static synchronized void clean() {
        self = null;
    }

    private DebugService() {
        try {
            DebugServiceDAO.initSQLStatements();
            this.piDebugMap = DebugServiceDAO.loadDebugInstanceEntry();
        }
        catch (Throwable th) {
            BLControl.logger.error((Object)"DebugService(): Error initializing process debug informations.", th);
        }
    }

    public WorkStepInstance executeWorkStep(Session session, long piid, String wsName, HashMap dsValues, boolean forceComplete) {
        WFProcessContext pCtx;
        block10: {
            String paramStr = "<" + piid + ":" + wsName + ":" + dsValues + ":" + forceComplete + ">";
            this.debugMethod(EXECUTE_WORKSTEP, paramStr);
            this.validateDebug(piid);
            pCtx = new WFProcessContext(session, piid);
            try {
                DebugContext context = this.getContextObject(piid);
                context.setForceComplete(forceComplete);
                long wsid = pCtx.getProcess().getWorkstep(wsName).getID();
                this.updateSlotValue(pCtx, dsValues);
                this.debugWorkStepState(pCtx, wsid, wsName);
                if (WFWorkstepInstance.single().isActivated(pCtx, wsid)) {
                    this.info("Workstep <" + wsName + "> of Process Instance <" + piid + "> is activated.");
                    if (forceComplete) {
                        this.completeWorkItems(pCtx, wsid);
                    } else {
                        this.warn("Workstep <" + wsName + "> of Process Instance <" + piid + "> cannot be completed as force complete flag is false.");
                    }
                    break block10;
                }
                if (WFWorkstepInstance.single().isCompleted(pCtx, wsid) || WFWorkstepInstance.single().isCreated(pCtx, wsid) || WFWorkstepInstance.single().isSkipped(pCtx, wsid) || WFWorkstepInstance.single().isTerminated(pCtx, wsid)) {
                    this.validateWorkStep(pCtx, wsName);
                    pCtx.activateWorkstep(wsid);
                    break block10;
                }
                if (WFWorkstepInstance.single().isSuspendedByCompensatory(pCtx, wsid)) {
                    pCtx.activateWorkstep(wsid);
                    break block10;
                }
                throw new RuntimeException("DebugService.executeWorkStep: The workstep <" + wsName + "> cannot be executed as  the workstep is in <" + this.getWorkStepState(pCtx, wsid) + "> state.");
            }
            catch (Throwable th) {
                throw new RuntimeException("Error executing the workstep <" + wsName + ">", th);
            }
            finally {
                this.removeContextObject();
            }
        }
        return this.getWorkStepInstance(pCtx, wsName);
    }

    public WorkStepInstance executeHumanWorkStep(Session session, long piid, String wsName, HashMap dsValues, String performer) {
        String paramStr = "<" + piid + ":" + wsName + ":" + dsValues + ":" + performer + ">";
        this.debugMethod(EXECUTE_HUMAN_WORKSTEP, paramStr);
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        WFWorkstep ws = pCtx.getProcess().getWorkstep(wsName);
        if (ws.isAtomic()) {
            boolean byAll = ((WFAtomicWS)ws).getPerformedByAll();
            if (byAll) {
                throw new RuntimeException("DebugService.executeHumanWorkStep():This API is supported only for Atomic worksteps of type <performByAny>. For other worksteps invoke executeWorkStep API");
            }
            DebugContext context = this.getContextObject(piid);
            context.setPerformer(performer);
            return this.executeWorkStep(session, piid, wsName, dsValues, true);
        }
        throw new RuntimeException("DebugService.executeHumanWorkStep():This API is supported only for Atomic worksteps of type <performByAny>. For other worksteps invoke executeWorkStep API");
    }

    public WorkStepInstance skipWorkStep(Session session, long piid, String wsName) {
        WFProcessContext pCtx;
        block6: {
            String paramStr = "<" + piid + ":" + wsName + ">";
            this.debugMethod(SKIP_WORKSTEP, paramStr);
            this.validateDebug(piid);
            DebugContext context = this.getContextObject(piid);
            pCtx = new WFProcessContext(session, piid);
            try {
                context.registerSkipWorkStep(wsName);
                long wsid = pCtx.getProcess().getWorkstep(wsName).getID();
                if (WFWorkstepInstance.single().isCompleted(pCtx, wsid) || WFWorkstepInstance.single().isCreated(pCtx, wsid) || WFWorkstepInstance.single().isSkipped(pCtx, wsid) || WFWorkstepInstance.single().isTerminated(pCtx, wsid)) {
                    this.debugWorkStepState(pCtx, wsid, wsName);
                    this.validateWorkStep(pCtx, wsName);
                    pCtx.activateWorkstep(wsid);
                    break block6;
                }
                throw new RuntimeException("DebugService.executeWorkSteps:The workstep " + wsName + " cannot be skipped as it is in the state <" + this.getWorkStepState(pCtx, wsid) + ">");
            }
            catch (Throwable th) {
                throw new RuntimeException("Error skipping the workstep <" + wsName + ">", th);
            }
            finally {
                this.removeContextObject();
            }
        }
        return this.getWorkStepInstance(pCtx, wsName);
    }

    public ArrayList executeWorkSteps(Session session, long piid, String startFromWS, String stopAtWS, HashMap dsValues) {
        String[] stopAtWSs = new String[]{stopAtWS};
        ArrayList<WorkStepInstance> wsiList = this.executeWorkSteps(session, piid, startFromWS, stopAtWSs, dsValues);
        return wsiList;
    }

    public ArrayList<WorkStepInstance> executeWorkSteps(Session session, long piid, String startFromWS, String[] stopAtWS, HashMap dsValues) {
        String paramStr = "<" + piid + ":" + startFromWS + ":" + Arrays.asList(stopAtWS) + ":" + dsValues + ">";
        this.debugMethod(EXECUTE_WORKSTEPS, paramStr);
        this.validateDebug(piid);
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        ArrayList<WorkStepInstance> wsiList = null;
        try {
            DebugContext context = this.getContextObject(piid);
            context.registerStopAtWS(stopAtWS);
            context.setForceComplete(true);
            long wsid = pCtx.getProcess().getWorkstep(startFromWS).getID();
            this.updateSlotValue(pCtx, dsValues);
            if (WFWorkstepInstance.single().isActivated(pCtx, wsid)) {
                this.info("Workstep <" + startFromWS + "> of Process Instance <" + piid + "> is activated.");
                this.completeWorkItems(pCtx, wsid);
            } else if (WFWorkstepInstance.single().isCompleted(pCtx, wsid) || WFWorkstepInstance.single().isCreated(pCtx, wsid) || WFWorkstepInstance.single().isSkipped(pCtx, wsid) || WFWorkstepInstance.single().isTerminated(pCtx, wsid)) {
                this.debugWorkStepState(pCtx, wsid, startFromWS);
                this.validateWorkStep(pCtx, startFromWS);
                pCtx.activateWorkstep(wsid);
            } else if (WFWorkstepInstance.single().isSuspendedByCompensatory(pCtx, wsid)) {
                pCtx.activateWorkstep(wsid);
            } else {
                throw new RuntimeException("DebugService.executeWorkSteps: The workstep <" + startFromWS + "> cannot be executed as  the workstep is in <" + this.getWorkStepState(pCtx, wsid) + "> state.");
            }
            wsiList = context.getWorkStepInstances(pCtx);
        }
        catch (Throwable th) {
            throw new RuntimeException("Error executing from workstep <" + startFromWS + ">", th);
        }
        finally {
            this.removeContextObject();
        }
        return wsiList;
    }

    public ArrayList executeInstance(Session session, long piid, String wsName, HashMap dsValues) {
        String paramStr = "<" + piid + ":" + wsName + ":" + dsValues + ">";
        this.debugMethod(EXECUTE_INSTANCE, paramStr);
        return this.executeWorkSteps(session, piid, wsName, END_WS, dsValues);
    }

    public Map getWorkStepsToActivate(long piid) {
        String paramStr = "<" + piid + ">";
        this.debugMethod(WORKSTEP_TO_ACTIVATE, paramStr);
        return DebugServiceDAO.getDebugWSEntryByPI(piid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPI(long piid) {
        HashMap<Long, Boolean> hashMap = this.piDebugMap;
        synchronized (hashMap) {
            if (this.piDebugMap.containsKey(piid)) {
                return;
            }
            this.piDebugMap.put(piid, true);
            DebugServiceDAO.createDebugInstanceEntry(piid, true);
        }
    }

    public void deRegisterPI(Session session, long piid) {
        this.activateWorkstepsOnDeRegister(session, piid);
        this.removeDebugInstanceEntry(piid);
    }

    public void removeDebugInstanceEntry(long piid) {
        this.removeDebugInstanceEntryFromDB(piid);
        this.piDebugMap.remove(piid);
    }

    boolean isDebug(long piid) {
        Boolean obj = this.piDebugMap.get(piid);
        if (obj != null) {
            return obj;
        }
        return false;
    }

    void saveWorkStepInstances(WFProcessContext pCtx) {
        long piid = pCtx.getProcessInstanceID();
        DebugContext context = this.getContextObject(piid);
        context.saveWorkStepInstances(pCtx);
    }

    boolean isInlineTask(WFExternalWS ws) {
        if (ws.isSynchron()) {
            return true;
        }
        String[] outputSlots = ws.getOutputSlotsKeys();
        return outputSlots == null || outputSlots.length == 0;
    }

    boolean isSkipWS(long piid, String wsName) {
        DebugContext context = this.getContextObject(piid);
        return context.isSkipWorkStepDefined(wsName);
    }

    boolean isForceCompleteWS(long piid) {
        DebugContext context = this.getContextObject(piid);
        return context.isForceComplete();
    }

    boolean isDebugAllowed(WFProcessContext pCtx, WFWorkstep currentWS, WFWorkstep nextWS) {
        long piid = pCtx.getProcessInstanceID();
        long nextWSID = nextWS.getID();
        String nextWSName = nextWS.getName();
        boolean flag = true;
        if (this.isValidDebugWS(piid, nextWS)) {
            DebugContext context = this.getContextObject(piid);
            this.debug("workstep <" + nextWSName + "> is a valid debug workstep of process instance <" + piid + ">.");
            if (currentWS.isInitialWorkstep() && !context.isStopAtWSDefined()) {
                this.debug("workstep <" + currentWS.getName() + "> is the initial workstep of process instance <" + piid + "> and stopAtWS is not defined.");
                flag = false;
            }
            if (!context.isStopAtWSDefined()) {
                this.debug("stopAtWS is not defined for process instance <" + piid + ">.");
                flag = false;
            }
            if (context.isStopAtWSReached(nextWSName)) {
                this.debug("workstep <" + nextWSName + "> is defined as stopAtWS for process instance <" + piid + ">.");
                flag = false;
            }
        }
        if (!flag) {
            int loopCounter = this.getLoopCounter(pCtx, nextWSID, true);
            this.addDebugWSEntry(piid, nextWSID, nextWSName, loopCounter, 1);
        }
        return flag;
    }

    void saveStopAtWS(WFProcessContext pCtx, String wsName) {
        if (wsName == null) {
            return;
        }
        WFWorkstep ws = pCtx.getProcess().getWorkstep(wsName, true);
        if (ws == null) {
            throw new RuntimeException("The passed workstep name " + wsName + " is not a valid one. Please pass a valid workstep.");
        }
        DebugContext context = this.getContextObject(pCtx.getProcessInstanceID());
        context.registerStopAtWS(wsName);
        context.setForceComplete(true);
    }

    Performer getAvailWorkItemPerformer(WFProcessContext pCtx) {
        DebugContext context = this.getContextObject(pCtx.getProcessInstanceID());
        String performer = context.getPerformer(pCtx);
        this.debug("Performer <" + performer + "> will be completing the available WorkItem");
        if (performer == null) {
            throw new BizLogicException("BizLogic_ERR_571", "DebugService.getAvailWorkItemPerformer", (Object[])new String[]{pCtx.getProcessInstanceName()});
        }
        return new Performer(performer, 1);
    }

    void completeWorkItems(WFProcessContext pCtx, long wsid) {
        Collection wiids = WFAtomicInstance.self().getWorkitems(pCtx, wsid);
        Iterator itr = wiids.iterator();
        this.debug("WorkItems with ids <" + wiids + "> are completed for workstep <" + wsid + "> for process instance <" + pCtx.getProcessInstanceID() + ">.");
        while (itr.hasNext()) {
            WorkItemEBLocal wieb = (WorkItemEBLocal)itr.next();
            WFWorkItem.self().complete(pCtx, (long)wieb.getId());
        }
    }

    void removeDebugWSEntry(WFProcessContext pCtx, long wsid, int status) {
        int loopCounter = this.getLoopCounter(pCtx, wsid, false);
        long piid = pCtx.getProcessInstanceID();
        this.debug("Removed debug entry for workstep <" + wsid + "> of process instance <" + piid + "> and loopCounter <" + loopCounter + "> and status <" + status + ">");
        DebugServiceDAO.removeDebugWSEntry(piid, wsid, loopCounter, status);
        DebugContext context = this.getContextObject(piid);
        context.registerWorkStepExecuted(wsid);
    }

    void addReactivateWS(WFProcessContext pCtx, long wsid) {
        int loopCounter = this.getLoopCounter(pCtx, wsid, true);
        String wsName = pCtx.getWorkStepInstanceName(wsid);
        long piid = pCtx.getProcessInstanceID();
        this.debug("workstep <" + wsName + "> of process instance <" + piid + "> with loopCounter <" + loopCounter + " is reactivated.");
        this.addDebugWSEntry(piid, wsid, wsName, loopCounter, 1);
    }

    private void activateWorkstepsOnDeRegister(Session session, long piid) {
        Map wsMap = DebugServiceDAO.getDebugWSEntryByPI(piid);
        if (wsMap != null && !wsMap.isEmpty()) {
            Iterator iterator = wsMap.keySet().iterator();
            for (int i = 0; i < wsMap.size(); ++i) {
                String wsName = (String)iterator.next();
                this.executeWorkStep(session, piid, wsName, null, false);
            }
        }
    }

    private boolean isValidDebugWS(long piid, WFWorkstep ws) {
        return ws.isPrimaryWS() || ws.isDecision();
    }

    private void updateSlotValue(WFProcessContext pCtx, HashMap dsValues) {
        if (dsValues != null && !dsValues.isEmpty()) {
            pCtx.updateSlotValue(dsValues);
            String piName = pCtx.getProcessInstanceName();
            this.debugKey("BizLogic_ERR_3235", "DebugService.updateSlotValue", new Object[]{dsValues, piName});
        }
    }

    private WorkStepInstance getWorkStepInstance(WFProcessContext pCtx, String wsName) {
        DebugContext context = this.getContextObject(pCtx.getProcessInstanceID());
        ArrayList<WorkStepInstance> wsList = context.getWorkStepInstances(pCtx);
        if (wsList == null || wsList.isEmpty()) {
            return null;
        }
        WorkStepInstance wsi = null;
        for (int i = 0; i < wsList.size() && !(wsi = wsList.get(i)).getName().equals(wsName); ++i) {
        }
        return wsi;
    }

    private void addDebugWSEntry(long piid, long wsid, String wsName, int loopCounter, int status) {
        if (DebugServiceDAO.isExistDebugWSEntry(piid, wsid, loopCounter, status)) {
            return;
        }
        this.debug("Added debug entry for workstep <" + wsid + "> of process instance <" + piid + "> and loopCounter <" + loopCounter + "> and status <" + status + ">");
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("PROCESS_INSTANCE_ID", piid);
        attrs.put("WORKSTEP_ID", wsid);
        attrs.put("WORKSTEP_NAME", wsName);
        attrs.put("LOOPCOUNTER", loopCounter);
        attrs.put("BREAKPOINT_STATE", status);
        DebugServiceDAO.insertDebugWSEntry(attrs);
    }

    private void validateWorkStep(WFProcessContext pCtx, String wsName) {
        pCtx.getProcess().getWorkstep(wsName);
        Map wsMap = DebugServiceDAO.getDebugWSEntryByPI(pCtx.getProcessInstanceID());
        if (!wsMap.containsKey(wsName)) {
            throw new RuntimeException("DebugService.validateWorkStep:The mentioned workstep " + wsName + " cannot be executed as it is not the next workstep in the process flow. The next worksteps in the flow are <" + wsMap + ">");
        }
    }

    private int getLoopCounter(WFProcessContext pCtx, long wsid, boolean incr) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid, true);
        if (wsieb == null) {
            return 1;
        }
        if (incr) {
            int n = wsieb.getState();
            BLConstants.single();
            if (n == 16) {
                return wsieb.getLoopCounter();
            }
            return wsieb.getLoopCounter() + 1;
        }
        return wsieb.getLoopCounter();
    }

    private void validateDebug(long piid) {
        if (!this.isDebug(piid)) {
            throw new RuntimeException("DebugService.validatedebug: ProcessInstance with ID <" + piid + "> is not debug enabled");
        }
    }

    private void removeDebugInstanceEntryFromDB(long piid) {
        DebugServiceDAO.removeDebugWSEntryByPI(piid);
        DebugServiceDAO.removeDebugInstanceEntry(piid);
    }

    private String getWorkStepState(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        int state = wsieb.getState();
        return BLConstants.single().wfStates[state];
    }

    private DebugContext getContextObject(long piid) {
        long threadID = Thread.currentThread().getId();
        if (this.contextMap.containsKey(threadID)) {
            return this.contextMap.get(threadID);
        }
        DebugContext context = new DebugContext(piid, threadID);
        this.contextMap.put(threadID, context);
        return context;
    }

    private void removeContextObject() {
        long threadID = Thread.currentThread().getId();
        this.contextMap.remove(threadID);
    }

    private void debugMethod(String methodName, String paramStr) {
        this.debugKey("BizLogic_ERR_3236", "DebugService:debugMethod", new Object[]{methodName, paramStr});
    }

    private void debugWorkStepState(WFProcessContext pCtx, long wsid, String wsName) {
        StringBuilder message = new StringBuilder("Workstep <");
        message.append(wsName).append("> of Process Instance <");
        message.append(pCtx.getProcessInstanceID()).append("> is in <");
        if (WFWorkstepInstance.single().isCreated(pCtx, wsid)) {
            message.append("created");
        } else if (WFWorkstepInstance.single().isCompleted(pCtx, wsid)) {
            message.append("completed");
        } else if (WFWorkstepInstance.single().isSkipped(pCtx, wsid)) {
            message.append("skipped");
        } else if (WFWorkstepInstance.single().isTerminated(pCtx, wsid)) {
            message.append("terminated");
        } else if (WFWorkstepInstance.single().isSuspendedByCompensatory(pCtx, wsid)) {
            message.append("suspended due to rollback");
        }
        message.append("> state.");
        this.debug(message.toString());
    }

    private void debug(String message) {
        if (BLControl.util.isDebugFlow()) {
            BLControl.logger.debug((Object)message);
        }
    }

    private void debugKey(String key, String context, Object[] params) {
        BLControl.logger.debugKey(key, context, params);
    }

    private void info(String message) {
        BLControl.logger.info((Object)message);
    }

    private void warn(String message) {
        BLControl.logger.warn((Object)message);
    }

    private class DebugContext {
        private final long piid;
        private final long threadID;
        private ArrayList<String> skipWSList = null;
        private boolean forceComplete = false;
        private ArrayList<String> stopAtWSList = null;
        private ArrayList<Long> executedWSIDList = null;
        private ArrayList<WorkStepInstance> executedWSObjList = null;
        private String performer = null;

        public DebugContext(long piid, long threadID) {
            this.piid = piid;
            this.threadID = threadID;
            this.skipWSList = new ArrayList();
            this.stopAtWSList = new ArrayList();
            this.executedWSIDList = new ArrayList();
            this.executedWSObjList = new ArrayList();
        }

        public void registerSkipWorkStep(String wsName) {
            this.skipWSList.add(wsName);
        }

        public boolean isSkipWorkStepDefined(String wsName) {
            return this.skipWSList != null && this.skipWSList.contains(wsName);
        }

        public void setForceComplete(boolean flag) {
            this.forceComplete = flag;
        }

        public boolean isForceComplete() {
            return this.forceComplete;
        }

        public void registerStopAtWS(String wsName) {
            String[] wsNames = new String[]{wsName};
            this.registerStopAtWS(wsNames);
        }

        public void registerStopAtWS(String[] wsName) {
            if (wsName == null || wsName.length == 0) {
                return;
            }
            List<String> wsNameList = Arrays.asList(wsName);
            this.stopAtWSList.addAll(wsNameList);
        }

        public boolean isStopAtWSDefined() {
            return this.stopAtWSList != null && !this.stopAtWSList.isEmpty();
        }

        public boolean isStopAtWSReached(String wsName) {
            return this.stopAtWSList != null && this.stopAtWSList.contains(wsName);
        }

        public void registerWorkStepExecuted(long wsid) {
            this.executedWSIDList.add(wsid);
        }

        public ArrayList<Long> getWorkStepsExecuted() {
            return this.executedWSIDList;
        }

        public void saveWorkStepInstances(WFProcessContext pCtx) {
            Session session = pCtx.getSession();
            long piid = pCtx.getProcessInstanceID();
            if (this.executedWSIDList == null || this.executedWSIDList.isEmpty()) {
                return;
            }
            DebugService.this.debug("SVOs of worksteps <" + this.executedWSIDList + "> are created for process instance <" + piid + ">.");
            for (int i = 0; i < this.executedWSIDList.size(); ++i) {
                long wsid = this.executedWSIDList.get(i);
                WorkStepInstance wsi = SVOFactory.getWorkStepInstance(session, piid, wsid);
                this.executedWSObjList.add(wsi);
            }
        }

        public ArrayList<WorkStepInstance> getWorkStepInstances(WFProcessContext pCtx) {
            if (this.executedWSObjList.isEmpty()) {
                this.saveWorkStepInstances(pCtx);
            }
            return this.executedWSObjList;
        }

        public void setPerformer(String performer) {
            this.performer = performer;
        }

        public String getPerformer(WFProcessContext pCtx) {
            if (this.performer == null || this.performer.trim().isEmpty()) {
                return pCtx.getSession().getUser();
            }
            return this.performer;
        }
    }
}

