/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.email.EmailComposer;
import com.savvion.sbm.bizlogic.enums.BLLockContext;
import com.savvion.sbm.bizlogic.enums.SubProcessType;
import com.savvion.sbm.bizlogic.messaging.dao.BLMessagesDAO;
import com.savvion.sbm.bizlogic.server.BLBusinessObjectService;
import com.savvion.sbm.bizlogic.server.BOManager;
import com.savvion.sbm.bizlogic.server.DebugService;
import com.savvion.sbm.bizlogic.server.ExtBOConfig;
import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.WFAtomicInstance;
import com.savvion.sbm.bizlogic.server.WFDataSlotInstance;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFJavaScript;
import com.savvion.sbm.bizlogic.server.WFNestedWS;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFProcessReplaceInfo;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.WFWorkstepInstance;
import com.savvion.sbm.bizlogic.server.XMLDocRepository;
import com.savvion.sbm.bizlogic.server.dao.AvailableWorkItemDAO;
import com.savvion.sbm.bizlogic.server.dao.CWorkItemDAO;
import com.savvion.sbm.bizlogic.server.dao.DataSlotDAO;
import com.savvion.sbm.bizlogic.server.dao.ExcludePerformerDAO;
import com.savvion.sbm.bizlogic.server.dao.ProcessInstanceDAO;
import com.savvion.sbm.bizlogic.server.dao.ProcessInstanceTemplateDAO;
import com.savvion.sbm.bizlogic.server.dao.ProcessInstanceXMLDAO;
import com.savvion.sbm.bizlogic.server.dao.ProcessNotesDAO;
import com.savvion.sbm.bizlogic.server.dao.SubProcessDAO;
import com.savvion.sbm.bizlogic.server.dao.TimerActionDAO;
import com.savvion.sbm.bizlogic.server.dao.VoteDAO;
import com.savvion.sbm.bizlogic.server.dao.WaitWorkStepDAO;
import com.savvion.sbm.bizlogic.server.dao.WorkItemDAO;
import com.savvion.sbm.bizlogic.server.dao.WorkItemPerformerDAO;
import com.savvion.sbm.bizlogic.server.dao.WorkStepInstanceDAO;
import com.savvion.sbm.bizlogic.server.ejb.BLServer;
import com.savvion.sbm.bizlogic.server.ejb.BLServerHome;
import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceEBLocal;
import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceEBLocalHome;
import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceSB;
import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceSBHome;
import com.savvion.sbm.bizlogic.server.ejb.WorkItemEBLocal;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceEBLocal;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceSB;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceSBHome;
import com.savvion.sbm.bizlogic.server.svo.DataSlotMapping;
import com.savvion.sbm.bizlogic.server.svo.DataSlotMappingList;
import com.savvion.sbm.bizlogic.server.svo.DateTime;
import com.savvion.sbm.bizlogic.server.svo.DocumentDS;
import com.savvion.sbm.bizlogic.server.svo.ProcessInstance;
import com.savvion.sbm.bizlogic.server.svo.SVOFactory;
import com.savvion.sbm.bizlogic.server.svo.XML;
import com.savvion.sbm.bizlogic.smp.MPService;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDocClient;
import com.savvion.sbm.bizlogic.util.BLDocService;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.DAOContext;
import com.savvion.sbm.bizlogic.util.ProcessContext;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.dms.DSContext;
import com.savvion.sbm.dms.svo.Document;
import com.savvion.sbm.dms.svo.DocumentFolder;
import com.savvion.sbm.dms.util.DSUtil;
import com.savvion.sbm.objectgraph.service.OGSFactory;
import com.savvion.sbm.util.ResultData;
import com.savvion.sbm.util.SBMContext;
import com.savvion.sbm.util.SBMControl;
import com.savvion.sbm.util.SBMHomeFactory;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.callback.ProcessCallback;
import com.tdiinc.userManager.Group;
import com.tdiinc.userManager.User;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class WFProcessInstance {
    private static final String NULL = "<NULL>";
    private static WFProcessInstance self = null;
    private static Hashtable PICREATELIST = new Hashtable();
    private static final boolean IS_ENTERPRISE = false;

    public WFProcessInstance() {
        WFProcessInstance.init();
    }

    private static void init() {
    }

    public static WFProcessInstance self() {
        if (self == null) {
            self = new WFProcessInstance();
        }
        return self;
    }

    public ProcessInstance createInstance(Session s, String appName, HashMap attrs, HashMap dsValues, boolean toActivate) {
        WFProcess activePT = ProcessControl.getActiveProcessTemplate(appName);
        if (activePT == null) {
            throw new BizLogicException("Bizlogic_ERR_3208", "WFProcessInstance.createInstance", new Object[]{appName});
        }
        HashMap piAttrs = this.validateAttributesForCreateInstance(activePT.getName(), attrs);
        WFProcessContext pCtx = this.createInstance(s, piAttrs, dsValues, toActivate);
        if (pCtx.getSVO() != null) {
            return pCtx.getSVO();
        }
        return SVOFactory.getProcessInstance(s, pCtx);
    }

    /*
     * Exception decompiling
     */
    public WFProcessContext createInstance(Session s, HashMap piAttrs, HashMap dsValues, boolean toActivate) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isPICreationAllowed(WFProcess ptObject, boolean isSubProcess) {
        boolean canCreate = false;
        if (ptObject.isActivated() || ptObject.isSuspendedBySeqVersion() && isSubProcess) {
            canCreate = true;
        }
        return canCreate;
    }

    public static boolean isSubPICreationAllowed(WFProcess ptObject) {
        boolean canCreate = true;
        if (ptObject.isSuspended() && !ptObject.isSuspendedBySeqVersion()) {
            canCreate = false;
        }
        return canCreate;
    }

    private String deriveCreatorValue(Session session, HashMap piAttrs) {
        String creator = (String)piAttrs.get("CREATOR");
        if (creator != null && creator.trim().length() != 0) {
            long ptid = (Long)piAttrs.get("PROCESSTEMPLATEID");
            String piName = (String)piAttrs.get("PROCESSINSTANCENAME");
            if ("@CREATOR".equalsIgnoreCase(creator)) {
                piAttrs.remove("CREATOR");
                BLControl.logger.warnKey("BizLogic_ERR_4637", new Object[]{creator, session.getUser(), piName, ptid});
            } else if (creator.startsWith("@")) {
                String dsName;
                WFProcess pt = ProcessControl.getProcessTemplate(ptid);
                if (pt.isValidGlobalSlot(dsName = creator.substring(1)) && pt.getDataslot(dsName).isString()) {
                    String dsVal = (String)WFDataSlotInstance.self().getGlobalDSValue(session, pt.getDataslot(dsName));
                    if (dsVal != null && !NULL.equalsIgnoreCase(dsVal) && dsVal.trim().length() != 0) {
                        creator = dsVal.trim();
                        piAttrs.put("CREATOR", creator);
                    } else {
                        piAttrs.remove("CREATOR");
                        BLControl.logger.warnKey("BizLogic_ERR_4638", new Object[]{dsName, session.getUser(), piName, ptid});
                    }
                } else {
                    throw new BizLogicException("BizLogic_ERR_4639", "WFProcessInstance.deriveCreatorValue", new Object[]{creator, piName, ptid});
                }
            }
        }
        if ((creator = (String)piAttrs.get("CREATOR")) == null || creator.trim().length() == 0) {
            creator = session.getUser();
            piAttrs.put("CREATOR", creator);
        }
        return creator;
    }

    public final ProcessInstanceEBLocal createInstance(WFProcess ptObject, HashMap piAttrs) throws Exception {
        ProcessInstanceEBLocalHome home = (ProcessInstanceEBLocalHome)SBMControl.homeFactory.lookupLocalHome(ProcessInstanceEBLocalHome.class);
        return home.create(piAttrs);
    }

    private HashMap insertInstanceDS(WFProcessContext pCtx, WFProcess pt, HashMap dsValues, String creator, boolean isSubProcess) {
        long piid = pCtx.getProcessInstanceID();
        WFDataslot ds = null;
        HashMap<String, Object> hm = new HashMap<String, Object>();
        new HashMap();
        Vector hasDataslots = pt.getDataslots();
        HashMap globalList = null;
        HashMap<String, Object> valueNeedValidate = new HashMap<String, Object>();
        HashMap sqlObjects = new HashMap();
        this.validateValueForDocumentSlot(pt, dsValues);
        DocumentFolder piFolder = null;
        HashMap<String, Object> extBODSMap = new HashMap<String, Object>();
        for (int i = 0; i < hasDataslots.size(); ++i) {
            ds = (WFDataslot)hasDataslots.elementAt(i);
            String dsName = ds.getName();
            if (!ds.global) {
                Object defaultValue;
                if (dsValues != null && dsValues.containsKey(dsName)) {
                    if (ds.isValueMapped() || ds.isDateDSMappedToStartTime() || ds.isCollection() || ds.isXML() || ds.isObject()) {
                        if (ds.isObject() && ds.isSqlMap() && ds.getSqlMap().hasInsertQuery()) {
                            sqlObjects.put(dsName, dsValues.get(dsName));
                        } else if (ds.isObject() && ds.isExternalBO()) {
                            extBODSMap.put(dsName, dsValues.get(dsName));
                        } else {
                            valueNeedValidate.put(dsName, dsValues.get(dsName));
                        }
                        if (ds.isCollection()) {
                            defaultValue = ds.getValue();
                            if (!BLUtil.isNull((Object)defaultValue)) {
                                hm.put(dsName, defaultValue);
                            } else {
                                hm.put(dsName, null);
                            }
                        } else {
                            hm.put(dsName, null);
                        }
                    } else if (ds.isDocument()) {
                        Object value = dsValues.get(dsName);
                        if (value == null) {
                            throw new BizLogicException("BizLogic_ERR_3660", "WFProcessInstance.insertInstanceDS()", new Object[]{pt.getName(), dsName, value});
                        }
                        if (!(value instanceof DocumentDS || value instanceof Document || WFDataslot.isDocumentList(value))) {
                            throw new BizLogicException("BizLogic_ERR_3660", "WFProcessInstance.insertInstanceDS()", new Object[]{pt.getName(), dsName, value});
                        }
                        DocumentDS docList = null;
                        if (value instanceof DocumentDS) {
                            docList = (DocumentDS)value;
                        } else {
                            if (piFolder == null) {
                                piFolder = BLDocService.createInstanceFolder((long)pt.getID(), (long)piid);
                            }
                            docList = this.handleDocumentDSCreation(pCtx, dsName, value, piFolder);
                        }
                        if (isSubProcess) {
                            DocumentDS newDS;
                            DSContext dsContext = null;
                            if (BLUtil.self().isMultiUserCredential()) {
                                dsContext = BLUtil.self().getDSContext(pCtx.getSession());
                            }
                            docList = newDS = SVOFactory.getDocumentDS(dsContext, pCtx.getProcessTemplateID(), piid, dsName, docList.getDataSlotFolderId(), docList.getPiid(), pCtx.getDataslot(dsName).isEditableByAuthor(), docList.isDocBundle());
                        } else {
                            this.processDocsForInstanceCreation(pCtx, pt.getID(), piid, dsName, docList);
                        }
                        hm.put(dsName, docList);
                        valueNeedValidate.put(dsName, docList);
                    } else {
                        hm.put(dsName, ds.getValidatedValueForUpdate(dsValues.get(dsName)));
                    }
                } else {
                    defaultValue = ds.getValue();
                    if (ds.isObject()) {
                        if (ds.isSqlMap() && ds.getSqlMap().hasInsertQuery()) {
                            sqlObjects.put(dsName, null);
                            hm.put(dsName, null);
                        } else if (!ds.isExternalBO()) {
                            hm.put(dsName, WFDataSlotInstance.self().createObjectForObjectDS(pCtx.getSession(), ds));
                        }
                    } else if (ds.isXML()) {
                        hm.put(dsName, defaultValue);
                        valueNeedValidate.put(dsName, defaultValue);
                    } else if (ds.isValueMapped()) {
                        hm.put(dsName, this.getValueMappedSlotValue(pCtx, dsName, defaultValue.toString()));
                    } else {
                        hm.put(dsName, defaultValue);
                    }
                }
            } else {
                if (dsValues == null || !dsValues.containsKey(dsName)) continue;
                if (globalList == null) {
                    globalList = new HashMap();
                }
                globalList.put(dsName, dsValues.get(dsName));
            }
            if (dsValues == null) continue;
            dsValues.remove(dsName);
        }
        if (dsValues != null && !dsValues.isEmpty()) {
            StringBuffer missingDS = new StringBuffer();
            Iterator iter = dsValues.keySet().iterator();
            while (iter.hasNext()) {
                missingDS.append((String)iter.next());
                missingDS.append(",");
            }
            missingDS.deleteCharAt(missingDS.length() - 1);
            throw new BizLogicException("BizLogic_ERR_550", "WFProcessInstance.insertInstanceDS", new Object[]{pt.getName(), missingDS});
        }
        DataSlotDAO.create(pt.getID(), piid, hm);
        if (pt.hasDocumentDataslot()) {
            DocumentFolder folder = BLDocService.createInstanceFolder((long)pt.getID(), (long)piid);
            pCtx.getProcessInstanceEB().setFolderId(folder.getId());
        }
        if (null != extBODSMap && !extBODSMap.isEmpty()) {
            WFDataSlotInstance.self().updateExtBODataslots(pCtx, extBODSMap);
        }
        HashMap dsWithDefaultValues = WFDataSlotInstance.self().getComplexDSDefaultValues(pCtx, valueNeedValidate);
        valueNeedValidate.putAll(dsWithDefaultValues);
        if (!valueNeedValidate.isEmpty()) {
            pCtx.updateSlotValue(valueNeedValidate);
        }
        if (!sqlObjects.isEmpty()) {
            BOManager.self().createSqlObjects(pCtx, sqlObjects);
        }
        return globalList;
    }

    private void processDocsForInstanceCreation(WFProcessContext pCtx, long ptid, long piid, String dsName, DocumentDS docDS) {
        String piFolderId = docDS.getInstanceFolderId();
        if (piFolderId == null && !SBMUtil.self().isCustomPathForDocDS()) {
            throw new BizLogicException("BizLogic_ERR_4664", "WFProcessInstance.processDocsForInstanceCreation", new Object[]{ptid, piid, dsName});
        }
        ProcessInstanceEBLocal piEB = pCtx.getProcessInstanceEB();
        String currentPIFolderId = piEB.getFolderId();
        if (currentPIFolderId == null) {
            if (piFolderId != null) {
                piEB.setFolderId(piFolderId);
                BLDocService.changePIFolderName((String)piFolderId, (long)piid);
            }
        } else if (piFolderId != null && !currentPIFolderId.equals(piFolderId)) {
            throw new BizLogicException("BizLogic_ERR_3661", "WFProcessInstance.processDocsForInstanceCreation", new Object[]{ptid, piid, dsName, currentPIFolderId, piFolderId});
        }
    }

    public void activate(WFProcessContext pCtx) {
        WFProcess pt;
        long duedate;
        ProcessInstanceEBLocal piEB = pCtx.getProcessInstanceEB();
        if (piEB.getState() != 6) {
            throw new BizLogicException("BizLogic_ERR_2608", "WFProcessInstance.activate", new Object[]{pCtx.getProcessInstanceName()});
        }
        long timeStarted = piEB.getTimeStarted();
        if (!pCtx.getProcess().isMonitoringProcess() || timeStarted <= 0L) {
            timeStarted = new Date().getTime();
            piEB.setTimeStarted(timeStarted);
        }
        if ((duedate = piEB.getDuedate()) <= timeStarted) {
            long estimatedDuration = this.getDuration(pCtx);
            duedate = timeStarted + estimatedDuration * 1000L;
            piEB.setDuedate(duedate);
        }
        if ((pt = pCtx.getProcess()).isCheckDue()) {
            TimerActionDAO.create(piEB.getId(), -1L, pt.getID(), duedate, null, null, null, "BIZLOGIC");
        }
        piEB.setState(7);
        BLUtil.fireEvent(this.getEventContext(pCtx, 7), (int)7);
        if (piEB.getParentID() > 0L) {
            return;
        }
        WFWorkstep ws = pt.getInitialWorkstep();
        Long piidObj = null;
        try {
            piidObj = piEB.getId();
            if (pt.hasInLineTasks()) {
                PICREATELIST.put(piidObj, piidObj);
            }
            pCtx.activateWorkstep(ws.getID());
            if (pt.hasInLineTasks() || pCtx.isPiCompletedOnCreatePIRequest()) {
                Object svo = PICREATELIST.get(piidObj);
                PICREATELIST.remove(piidObj);
                if (svo != null && !(svo instanceof ProcessInstance)) {
                    svo = SVOFactory.getProcessInstance(pCtx.getSession(), pCtx);
                }
                pCtx.setSVO((ProcessInstance)svo);
            }
        }
        catch (Exception ex) {
            if (pt.hasInLineTasks() && piidObj != null) {
                PICREATELIST.remove(piidObj);
            }
            throw new BizLogicException("BizLogic_ERR_3505", "WFProcessInstance.activate", new Object[]{piEB.getName(), ws.getName()}, (Throwable)ex);
        }
    }

    public boolean isCallerCallBack(WFProcessContext pCtx) {
        int i = pCtx.getProcessInstanceEB().getIsCallbackCaller();
        return SubProcessType.isSynchronousSubProcess((int)i);
    }

    public boolean isAsynchronousSubProcess(WFProcessContext pCtx) {
        int i = pCtx.getProcessInstanceEB().getIsCallbackCaller();
        return SubProcessType.isAsynchronousSubProcess((int)i);
    }

    public boolean remove(WFProcessContext pCtx, boolean forceRemove) {
        if (!forceRemove && pCtx.isSyncSubProcessInstance()) {
            throw new BizLogicException("BizLogic_ERR_529", "WFProcessInstance.remove", new Object[]{pCtx.getProcessInstanceName()});
        }
        if (!BLControl.util.isRemovePIWithActiveWS()) {
            int[] nArray = new int[1];
            nArray[0] = 18;
            int[] nArray2 = new int[4];
            nArray2[0] = 107;
            nArray2[1] = 109;
            nArray2[2] = 111;
            nArray2[3] = 110;
            int wsCount = WorkStepInstanceDAO.getCount(pCtx.getProcessInstanceID(), nArray, nArray2);
            if (wsCount > 0) {
                throw new BizLogicException("BizLogic_ERR_1532", "WFProcessInstance.remove", new Object[]{"remove()", "ProcessInstance", pCtx.getProcessInstanceName(), "external/webservice/mesage publisher/message subscriber workstep is running."});
            }
        }
        pCtx.getProcessTemplateID();
        long piid = pCtx.getProcessInstanceID();
        if (pCtx.getProcess().hasSqlMapDatsSlots()) {
            BOManager.self().deleteInstanceSqlObjects(pCtx);
        }
        this.removePrivateDocuments(pCtx);
        this.removePrivateInstanceXMLDS(pCtx);
        if (pCtx.getProcess().hasSubProcessWS()) {
            this.stopNestedProcesses(pCtx);
        }
        this.setStatus(pCtx, 12);
        long timeCompleted = new Date().getTime();
        pCtx.setProcessInstanceCompleteTime(timeCompleted);
        BLUtil.fireEvent(this.getEventContext(pCtx, 12), (int)12);
        if (BLControl.util.isCallback()) {
            if (ProcessCallback.hasCallback((int)12, (String)pCtx.getProcessTemplateName(), (String)pCtx.getProcess().getAppName())) {
                ProcessContext prcctx = BLUtil.getProcessContext((WFProcessContext)pCtx);
                ProcessCallback.execute((int)12, (SBMContext)prcctx, (boolean)true);
            }
        }
        if (pCtx.isProcessInstanceDynamic()) {
            this.removeDynamicProcessTemplate(piid);
        }
        this.deleteDatas(pCtx);
        if (pCtx.isDebug()) {
            DebugService.self().removeDebugInstanceEntry(piid);
        }
        return true;
    }

    private void removePrivateInstanceXMLDS(WFProcessContext pCtx) {
        Vector dsNames = pCtx.getProcess().getPrivateInstanceXMLDSNames();
        if (!dsNames.isEmpty()) {
            DAOContext daoCtx = BLUtil.self().getDAOContext(pCtx.getSession());
            HashMap dsValues = DataSlotDAO.findByNameList(daoCtx, pCtx.getProcessTemplateID(), pCtx.getProcessInstanceID(), dsNames);
            String dsName = null;
            Object dsValue = null;
            for (int x = 0; x < dsNames.size(); ++x) {
                XML xmlobj;
                long docid;
                dsName = (String)dsNames.elementAt(x);
                dsValue = dsValues.get(dsName);
                if (dsValue == null || (docid = (xmlobj = (XML)dsValue).getID()) <= 0L) continue;
                XMLDocRepository.remove(docid);
            }
        }
    }

    private void deleteDatas(WFProcessContext pCtx) {
        this.deleteDatasStd(pCtx);
    }

    private void deleteDatasStd(WFProcessContext pCtx) {
        long ptid = pCtx.getProcessTemplateID();
        long piid = pCtx.getProcessInstanceID();
        String monitorDSValue = null;
        if (pCtx.getProcess().isMonitoringProcess()) {
            monitorDSValue = pCtx.getMonitorDSValue();
        }
        try {
            if (pCtx.isRemoveDataslot()) {
                DataSlotDAO.remove(ptid, piid);
            }
            TimerActionDAO.removeByProcessInstance(piid);
            if (this.isCallerCallBack(pCtx)) {
                SubProcessDAO.removeBySubProcessInstance(piid);
            } else if (this.isAsynchronousSubProcess(pCtx)) {
                try {
                    SubProcessDAO.removeBySubProcessInstance(piid);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            WFProcess pt = ProcessControl.getProcessTemplate(ptid);
            if (pt.hasPerfomByAnyHumanWS()) {
                AvailableWorkItemDAO.removeByProcessInstance(piid);
            }
            WorkItemDAO.removeByProcessInstance(piid);
            WaitWorkStepDAO.remove(piid);
            WorkStepInstanceDAO.removeByProcessInstance(piid);
            SubProcessDAO.removeByProcessInstance(piid);
            WorkItemPerformerDAO.delete(piid);
            if (pCtx.getProcess().isMonitoringProcess()) {
                this.removeMonitorEventData(pCtx, monitorDSValue);
            }
            ExcludePerformerDAO.removeByProcessInstance(piid);
            ProcessNotesDAO.removeByProcessInstance(piid);
            if (pt.hasVoteWorksteps()) {
                VoteDAO.removeByProcessInstance(piid);
            }
            if (!pt.getWorkstepsSubscribedToAnyMessage().isEmpty()) {
                BLMessagesDAO.removeByProcessInstance(piid);
            }
            if (pt.hasCollaborationEnabledWS()) {
                CWorkItemDAO.removeByParentPI(piid);
            }
            BLUtil.self().getProcessInstanceEB(piid).remove();
        }
        catch (BizLogicException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BizLogicException("BizLogic_ERR_3101", "WFProcessInstance.deleteDatas", new Object[]{piid}, (Throwable)ex);
        }
    }

    private void deleteDatasEnt(WFProcessContext pCtx) {
        long ptid = pCtx.getProcessTemplateID();
        long piid = pCtx.getProcessInstanceID();
        String monitorDSValue = null;
        WFProcess pt = pCtx.getProcess();
        if (pt.isMonitoringProcess()) {
            monitorDSValue = pCtx.getMonitorDSValue();
        }
        try {
            String tableName = pt.getDSTableName();
            boolean hws = pt.hasPerfomByAnyHumanWS();
            boolean isMonitoring = pt.isMonitoringProcess();
            boolean hasVote = pt.hasVoteWorksteps();
            boolean hasMessages = !pt.getWorkstepsSubscribedToAnyMessage().isEmpty();
            boolean collaborationEnabled = pt.hasCollaborationEnabledWS();
            boolean deleteEvents = false;
            String processName = pCtx.getProcessTemplateName();
            if (isMonitoring) {
                deleteEvents = this.saveInvalidEvents(pCtx, monitorDSValue) != -1;
            }
            DataSlotDAO.removeAllData(piid, ptid, tableName, hws, isMonitoring, hasVote, hasMessages, collaborationEnabled, deleteEvents, processName, monitorDSValue);
            BLUtil.self().getProcessInstanceEB(piid).remove();
        }
        catch (BizLogicException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BizLogicException("BizLogic_ERR_3101", "WFProcessInstance.deleteDatas", new Object[]{piid}, (Throwable)ex);
        }
    }

    public void stopNestedProcesses(WFProcessContext pCtx) {
        List subPIList = SubProcessDAO.findByProcessInstance(pCtx.getProcessInstanceID());
        for (int ix = 0; ix < subPIList.size(); ++ix) {
            WFNestedWS pws;
            HashMap subPIInfo = (HashMap)subPIList.get(ix);
            long wsid = (Long)subPIInfo.get("WORKSTEPID");
            long subpiid = (Long)subPIInfo.get("SUBPROCESS_INSTANCE_ID");
            boolean isRemote = (Boolean)subPIInfo.get("IS_REMOTE");
            String appServer = (String)subPIInfo.get("APPSERVER_ID");
            WorkStepInstanceEBLocal wseb = pCtx.getWorkstepInstanceEB(wsid);
            if (wseb.getSuspendState() == 4 || !(pws = (WFNestedWS)pCtx.getWorkstep(wsid)).isSynchronous()) continue;
            if (isRemote) {
                try {
                    BLServerHome blServerHome = (BLServerHome)SBMControl.homeFactory.lookupHome(appServer, BLServerHome.class);
                    BLServer remoteBL = blServerHome.create();
                    Session session = remoteBL.connect(SBMControl.util.getGuestUser(), SBMControl.util.getGuestPasswd());
                    ProcessInstanceSBHome piSBHome = (ProcessInstanceSBHome)SBMControl.homeFactory.lookupHome(appServer, ProcessInstanceSBHome.class);
                    ProcessInstanceSB piSB = piSBHome.create();
                    piSB.removeSubProcessPI(session, subpiid);
                    remoteBL.disConnect(session);
                }
                catch (Exception e) {
                    BLControl.logger.errorKey("BizLogic_ERR_587", new Object[]{"BLServer"}, (Throwable)e);
                }
                continue;
            }
            if (pCtx.getCompleteCallerID() == subpiid) {
                if (!BLControl.util.DEBUG_ENGINE) continue;
                BLControl.logger.debugKey("BizLogic_ERR_1011", new Object[]{pCtx.getProcessInstanceID(), subpiid});
                continue;
            }
            ProcessInstanceEBLocal pieb = null;
            try {
                pieb = BLUtil.self().getProcessInstanceEB(subpiid);
            }
            catch (BizLogicException remoteBL) {
                // empty catch block
            }
            if (pieb == null) continue;
            WFProcessContext spCtx = new WFProcessContext(pCtx.getSession(), pieb);
            if (spCtx != null) {
                spCtx.removeProcessInstance(true);
            }
            if (!BLControl.util.DEBUG_ENGINE) continue;
            BLControl.logger.debugKey("BizLogic_ERR_1012", new Object[]{pCtx.getProcessInstanceID(), subpiid});
        }
    }

    public void activateDuringRestart() {
    }

    /*
     * Unable to fully structure code
     */
    public void complete(WFProcessContext pCtx) {
        block11: {
            pCtx.getProcessTemplateID();
            piid = pCtx.getProcessInstanceID();
            v0 = pCtx.getProcessInstanceEB().getState();
            BLConstants.single();
            if (v0 == 7) break block11;
            if (!pCtx.isResumingSuspendedPI()) ** GOTO lbl-1000
            BLConstants.single();
            if (8 == pCtx.getProcessInstanceEB().getState()) {
                this.updateStatusToActivated(pCtx);
            } else lbl-1000:
            // 2 sources

            {
                ptName = pCtx.getProcessTemplateName();
                throw new BizLogicException("BizLogic_ERR_3756", "WFProcessInstance.complete(pCtx)", new Object[]{piid, ptName});
            }
        }
        this.setStatus(pCtx, 11);
        timeCompleted = new Date().getTime();
        pCtx.setProcessInstanceCompleteTime(timeCompleted);
        piidObj = piid;
        if (pCtx.isInstanceCreation()) {
            WFProcessInstance.PICREATELIST.put(piidObj, piidObj);
            pCtx.setPiCompletedOnCreatePIRequest(true);
        }
        if (WFProcessInstance.PICREATELIST.get(piidObj) != null) {
            svo = SVOFactory.getCompletedProcessInstance(pCtx.getSession(), pCtx);
            WFProcessInstance.PICREATELIST.put(piidObj, svo);
        }
        if (pCtx.getProcess().hasSqlMapDatsSlots()) {
            BOManager.self().deleteInstanceSqlObjects(pCtx);
        }
        this.stopNestedProcesses(pCtx);
        if (this.isWorkitemCaller(pCtx)) {
            this.resumeWorkitemCaller(pCtx);
        }
        if (this.isCallerCallBack(pCtx)) {
            this.completeCaller(pCtx);
        }
        this.removePrivateDocuments(pCtx);
        this.removePrivateInstanceXMLDS(pCtx);
        eventContext = this.getEventContext(pCtx, 11);
        if (BLControl.util.isCallback()) {
            if (ProcessCallback.hasCallback((int)11, (String)pCtx.getProcessTemplateName(), (String)pCtx.getProcess().getAppName())) {
                prcctx = BLUtil.getProcessContext((WFProcessContext)pCtx);
                ProcessCallback.execute((int)11, (SBMContext)prcctx, (boolean)true);
            }
        }
        this.deleteDatas(pCtx);
        if (BLControl.util.DEBUG_EP) {
            BLControl.logger.info((Object)("    PI:" + piid + " completion at " + System.currentTimeMillis()));
        }
        if (pCtx.isDebug()) {
            DebugService.self().removeDebugInstanceEntry(piid);
        }
        BLUtil.fireEvent(eventContext, (int)11);
    }

    /*
     * Loose catch block
     */
    public void completeCaller(WFProcessContext pCtx) {
        block22: {
            String protocol;
            long wsid;
            long ppiid;
            HashMap parentDSValues;
            DataSlotMappingList outputSlots;
            block23: {
                String[] indexedDSNames;
                HashMap callerInfo = pCtx.getProcessInstanceEB().getCallerInfo();
                if (null == callerInfo) {
                    if (ProcessInstanceDAO.isProcessInstanceExist(pCtx.getProcessInstanceID())) {
                        throw new BizLogicException("BizLogic_ERR_8079", "WFProcessInstance.completeCaller", new Object[]{pCtx.getProcessInstanceID()});
                    }
                    throw new BizLogicException("BizLogic_ERR_8080", "WFProcessInstance.completeCaller", new Object[]{pCtx.getProcessInstanceID()});
                }
                outputSlots = (DataSlotMappingList)callerInfo.get("OUTPUTDATASLOTS");
                parentDSValues = new HashMap();
                ppiid = (Long)callerInfo.get("CALLERPROCESSINSTANCEID");
                wsid = (Long)callerInfo.get("CALLERWORKSTEPID");
                protocol = (String)callerInfo.get("CALLERPROTOCOL");
                String server = (String)callerInfo.get("CALLERLOCATION");
                if (!protocol.equalsIgnoreCase("jndi://")) break block23;
                Properties callerServer = (Properties)callerInfo.get("CALLERSERVER");
                BLServer rBL = null;
                Session session = null;
                Object jndiName = null;
                jndiName = callerServer.get("JNDI_NAME");
                BLServerHome blHome23332 = (BLServerHome)SBMHomeFactory.lookupHome((Map)callerServer, BLServerHome.class);
                rBL = blHome23332.create();
                session = rBL.connect(SBMUtil.self().getGuestUser(), SBMUtil.self().getGuestPasswd());
                if (outputSlots != null && !outputSlots.isEmpty() && (indexedDSNames = outputSlots.getIndexedDataSlotNames()) != null && indexedDSNames.length > 0) {
                    callerServer.put("JNDI_NAME", "ejb/" + ProcessInstanceSBHome.class.getName());
                    ProcessInstanceSBHome piSBHome = (ProcessInstanceSBHome)SBMHomeFactory.lookupHome((Map)callerServer, ProcessInstanceSBHome.class);
                    ProcessInstanceSB piSB = piSBHome.create();
                    parentDSValues = piSB.getDataSlotValue(session, ppiid, indexedDSNames);
                }
                HashMap outputValues = this.getOutputSlotValues(pCtx, wsid, outputSlots, parentDSValues);
                callerServer.put("JNDI_NAME", "ejb/" + WorkStepInstanceSBHome.class.getName());
                WorkStepInstanceSBHome wsiSBHome = (WorkStepInstanceSBHome)SBMHomeFactory.lookupHome((Map)callerServer, WorkStepInstanceSBHome.class);
                WorkStepInstanceSB wsiSB = wsiSBHome.create();
                wsiSB.completeCallerSubProcessWorkStep(session, ppiid, wsid, pCtx.getProcessInstanceID(), outputValues);
                try {
                    if (jndiName != null) {
                        callerServer.put("JNDI_NAME", jndiName);
                    }
                    if (rBL != null) {
                        rBL.disConnect(session);
                    }
                    break block22;
                }
                catch (Throwable blHome23332) {}
                break block22;
                catch (Exception e) {
                    try {
                        throw new BizLogicException("BizLogic_ERR_587", "WFProcessInstance.completeCaller", new Object[]{server}, (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (jndiName != null) {
                                callerServer.put("JNDI_NAME", jndiName);
                            }
                            if (rBL != null) {
                                rBL.disConnect(session);
                            }
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            if (protocol.equalsIgnoreCase("local")) {
                int count;
                HashMap dsNameValue;
                WFProcessContext ppCtx = new WFProcessContext(pCtx.getSession(), ppiid);
                if (outputSlots != null && !outputSlots.isEmpty()) {
                    String[] indexedDSNames = outputSlots.getIndexedDataSlotNames();
                    WFNestedWS nestedWS = (WFNestedWS)ppCtx.getWorkstep(wsid);
                    if (!nestedWS.isSingleSubProcess()) {
                        ppCtx.lockRootOrInstanceDS(BLLockContext.PI, "WFProcessInstance.completeCaller", new Object[0]);
                    }
                    parentDSValues = ppCtx.getSlotValue(indexedDSNames);
                }
                if ((dsNameValue = this.getOutputSlotValues(pCtx, wsid, outputSlots, parentDSValues)) == null || dsNameValue.isEmpty()) {
                    ppCtx.lockRootOrInstanceDS(BLLockContext.PI, "WFProcessInstance.completeCaller", new Object[0]);
                } else {
                    ppCtx.updateSlotValue(dsNameValue);
                }
                if (BLControl.util.DEBUG_ENGINE) {
                    BLControl.logger.debugKey("BizLogic_ERR_3122", new Object[]{pCtx.getProcessInstanceName(), ppCtx.getWorkstep(wsid).getName(), ppCtx.getProcessInstanceName()});
                }
                if ((count = SubProcessDAO.getCount(ppiid, wsid)) == 1) {
                    ppCtx.setCompleteCallerID(pCtx.getProcessInstanceID());
                    ppCtx.completeWorkstep(wsid);
                }
            }
        }
    }

    private HashMap getOutputSlotValues(WFProcessContext pCtx, long wsid, DataSlotMappingList outputSlots, HashMap parentDSValues) {
        if (outputSlots == null || outputSlots.isEmpty()) {
            return null;
        }
        String piName = pCtx.getProcessInstanceName();
        String[] mappedDSNames = outputSlots.getMappedNames();
        HashMap slotValues = WFProcessInstance.copyXML(pCtx, wsid, pCtx.getSlotValue(mappedDSNames));
        outputSlots.populateValuesByMappedName(slotValues);
        ArrayList indexedOutputSlots = outputSlots.getIndexedDataSlotMappings();
        if (indexedOutputSlots != null && !indexedOutputSlots.isEmpty()) {
            for (int ix = 0; ix < indexedOutputSlots.size(); ++ix) {
                DataSlotMapping indexedSlotMapping = (DataSlotMapping)indexedOutputSlots.get(ix);
                String dsName = indexedSlotMapping.getDataSlotName();
                Object subProcessDSValue = indexedSlotMapping.getValue();
                Object parentProcessDSValue = parentDSValues.get(dsName);
                if (parentProcessDSValue == null) {
                    String storageClass = indexedSlotMapping.getStorageClass();
                    try {
                        parentProcessDSValue = Class.forName(storageClass).newInstance();
                    }
                    catch (Throwable th) {
                        throw new BizLogicException("BizLogic_ERR_762", "WFProcessInstance.getOutputSlotValues", new Object[]{storageClass, dsName});
                    }
                }
                if (indexedSlotMapping.isList()) {
                    ((List)parentProcessDSValue).add(subProcessDSValue);
                } else {
                    ((HashMap)parentProcessDSValue).put(piName, subProcessDSValue);
                }
                indexedSlotMapping.setValue(parentProcessDSValue);
            }
        }
        HashMap outputDSValues = outputSlots.getValues();
        Map<String, String> docDSNames = outputSlots.getDocumentDSNames();
        for (String dsName : docDSNames.keySet()) {
            outputDSValues.remove(dsName);
        }
        return outputDSValues;
    }

    public String getParentProcess(WFProcessContext pCtx) {
        return pCtx.getProcessTemplateName();
    }

    public void setCreator(WFProcessContext pCtx, String c, boolean fireEvent) {
        pCtx.getProcessInstanceEB().setCreator(c);
        if (fireEvent) {
            BLUtil.fireEvent(this.getEventContext(pCtx, 51), (int)51);
        }
    }

    public final void setPriority(WFProcessContext pCtx, int pri, boolean fireEvent) {
        pCtx.getProcessInstanceEB().setPriority(pri);
        if (fireEvent) {
            BLUtil.fireEvent(this.getEventContext(pCtx, 13), (int)13);
        }
    }

    public final void setPriority(WFProcessContext pCtx, String priority, boolean fireEvent) {
        int pri;
        if (priority != null && (pri = SBMControl.util.getIntegerPriority(priority)) != -1) {
            this.setPriority(pCtx, pri, fireEvent);
            return;
        }
        throw new BizLogicException("BizLogic_ERR_1647", "WFProcessInstance.setPriority", new Object[]{SBMControl.util.strPriority});
    }

    public int getPriority(WFProcessContext pCtx) {
        return pCtx.getProcessInstanceEB().getPriority();
    }

    public void setStatus(WFProcessContext pCtx, int s) {
        pCtx.getProcessInstanceEB().setState(s);
    }

    public long getInstanceID(WFProcessContext pCtx) {
        return pCtx.getProcessInstanceEB().getId();
    }

    public long getStartTime(WFProcessContext pCtx) {
        return pCtx.getProcessInstanceEB().getTimeStarted();
    }

    public String[] getActiveWorksteps(WFProcessContext pCtx) {
        return WorkStepInstanceDAO.getActiveWorkStepNameList(pCtx.getProcessInstanceID());
    }

    public String[] getSuspendedWorksteps(WFProcessContext pCtx) {
        return WorkStepInstanceDAO.getSuspendedWorkStepNameList(pCtx.getProcessInstanceID());
    }

    public String[] getCompletedWorksteps(WFProcessContext pCtx) {
        return WorkStepInstanceDAO.getCompletedWorkStepNameList(pCtx.getProcessInstanceID());
    }

    public void setStartPoint(WFProcessContext pCtx, String wsName) {
        try {
            pCtx.getProcess().getWorkstep(wsName);
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_1116", new Object[]{wsName});
            }
            pCtx.getProcessInstanceEB().setStartPoint(wsName);
            return;
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_1584", "WFProcessInstance.setStartPoint", new Object[]{wsName});
        }
    }

    public String getStartPoint(WFProcessContext pCtx) {
        String startPoint = pCtx.getProcessInstanceEB().getStartPoint();
        if (startPoint == null || startPoint.trim().isEmpty()) {
            return pCtx.getProcess().getInitialWorkstep().getName();
        }
        return startPoint;
    }

    public boolean isWorkitemCallerUpdate(WFProcessContext pCtx) {
        HashMap hm = pCtx.getProcessInstanceEB().getCallerInfo();
        return (Boolean)hm.get("ISUPDATEWORKITEMDATA");
    }

    public void setWorkitemCaller(WFProcessContext pCtx, long ppid, long pwsid, long callerWI, String callerWS, HashMap outputs, boolean updateCaller) {
        ProcessInstanceEBLocal piEB = pCtx.getProcessInstanceEB();
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("CALLEROBJECT", callerWS);
        hm.put("CALLERMAPPING", outputs);
        hm.put("CALLERPROCESSINSTANCEID", ppid);
        hm.put("CALLERWORKSTEPID", pwsid);
        hm.put("ISUPDATEWORKITEMDATA", updateCaller);
        hm.put("CALLERWORKITEMID", callerWI);
        piEB.setCallerInfo(hm);
    }

    public void resumeWorkitemCaller(WFProcessContext pCtx) {
    }

    public WFDataslot getDataslot(WFProcessContext pCtx, String dsName) {
        return pCtx.getProcess().getDataslot(dsName);
    }

    public boolean isWorkitemCaller(WFProcessContext pCtx) {
        long wiCallerId = pCtx.getProcessInstanceEB().getIsCallbackCaller();
        return SubProcessType.isSynchronousWI((int)((int)wiCallerId));
    }

    public long getWorkitemCallerID(WFProcessContext pCtx) {
        HashMap hm = pCtx.getProcessInstanceEB().getCallerInfo();
        return (Long)hm.get("CALLERWORKITEMID");
    }

    public String getWorkitemCallerName(WFProcessContext pCtx) {
        block3: {
            long wiid = this.getWorkitemCallerID(pCtx);
            if (wiid != 0L) {
                WorkItemEBLocal wiEB = null;
                try {
                    wiEB = pCtx.getWorkItemEB(wiid);
                    return wiEB.getName();
                }
                catch (Throwable throwable) {
                    if (wiEB != null) break block3;
                    return null;
                }
            }
        }
        return null;
    }

    public String getCreator(WFProcessContext pCtx) {
        return pCtx.getProcessInstanceEB().getCreator();
    }

    public void setCaller(WFProcessContext pCtx, HashMap callerInfo, boolean isCallback) {
        pCtx.getProcessInstanceEB();
        pCtx.getProcessInstanceEB().setCallerInfo(callerInfo);
        if (isCallback) {
            pCtx.getProcessInstanceEB().setIsCallbackCaller(1);
        } else {
            pCtx.getProcessInstanceEB().setIsCallbackCaller(0);
        }
    }

    public String getInstruction(WFProcessContext pCtx) {
        return pCtx.getProcess().getInstruction();
    }

    public Vector getFYI(WFProcessContext pCtx) {
        return pCtx.getProcess().getFYI();
    }

    public Vector getWSFYI(WFProcessContext pCtx, String wsName) {
        return pCtx.getProcess().getWSFYI(wsName);
    }

    public String toString() {
        String buf = "";
        return buf;
    }

    public String getPIprefix(WFProcessContext pCtx) {
        String piname = pCtx.getProcessInstanceEB().getName();
        return piname.substring(0, piname.lastIndexOf("#"));
    }

    protected Map<String, Object> getEventContext(WFProcessContext pCtx, int eventType) {
        String pri;
        String piName;
        ProcessInstanceEBLocal pieb;
        WFProcess pt;
        Map eventContext;
        block12: {
            long timeCompleted;
            long timeStarted;
            block11: {
                Vector v;
                eventContext = SBMUtil.getNewEventContext();
                if (!WFProcessInstance.checkAuditRequired(pCtx, eventType)) {
                    eventContext.put("AUDIT_DISABLED", true);
                    return eventContext;
                }
                String tmp = null;
                pt = pCtx.getProcess();
                pieb = pCtx.getProcessInstanceEB();
                piName = pieb.getName();
                eventContext.put("RPID", pieb.getRootInstanceID());
                eventContext.put("RPTID", pieb.getRootTemplateID());
                eventContext.put("PROCESSTEMPLATENAME", pt.getName());
                eventContext.put("PROCESSTEMPLATEID", pt.getID());
                eventContext.put("PROCESSINSTANCENAME", piName);
                eventContext.put("PROCESSINSTANCEID", pieb.getId());
                tmp = pieb.getCreator();
                if (tmp != null) {
                    eventContext.put("CREATOR", tmp);
                }
                if ((v = pt.getGlobalDSNamesList()) != null && !v.isEmpty()) {
                    eventContext.put("GLOBAL_SLOT_NAME_LIST", v);
                }
                timeStarted = pieb.getTimeStarted();
                eventContext.put("STARTTIME", String.valueOf(timeStarted));
                long duedate = pieb.getDuedate();
                eventContext.put("DUEDATE", String.valueOf(duedate));
                timeCompleted = pCtx.getProcessInstanceCompleteTime();
                eventContext.put("ENDTIME", String.valueOf(timeCompleted));
                long estimatedDuration = this.getDuration(pCtx);
                eventContext.put("ESTIMATEDDURATION", String.valueOf(estimatedDuration));
                int state = pieb.getState();
                if (state == 11) break block11;
                if (state != 12) break block12;
            }
            long duration = (timeCompleted - timeStarted) / 1000L;
            eventContext.put("DURATION", String.valueOf(duration));
        }
        if (pCtx.getSession() != null) {
            eventContext.put("SESSION_USER", pCtx.getSession().getUser());
        }
        if ((pri = SBMControl.util.getStringPriority(pieb.getPriority())) != null) {
            eventContext.put("PRIORITY", pri);
        }
        eventContext.put("APP_NAME", pt.getAppName());
        eventContext.put("SUBPROCESS_TYPE", pieb.getIsCallbackCaller());
        if (pieb.getState() == 7 && this.isSubProcessInstance(pCtx)) {
            HashMap callerObject = pieb.getCallerInfo();
            eventContext.put("PARENTPROCESSINSTANCEID", callerObject.get("CALLERPROCESSINSTANCEID"));
            eventContext.put("PARENTPROCESSINSTANCENAME", callerObject.get("CALLERPROCESSINSTANCENAME"));
            eventContext.put("PARENTWORKSTEPID", callerObject.get("CALLERWORKSTEPID"));
            eventContext.put("PARENTWORKSTEPNAME", callerObject.get("CALLERWORKSTEPNAME"));
            eventContext.put("PARENTWORKSTEPNAME", callerObject.get("CALLERWORKSTEPNAME"));
            int loopCounter = (Integer)callerObject.get("LOOPCOUNTER");
            eventContext.put("LOOPCOUNTER", String.valueOf(loopCounter));
        }
        if (BLControl.util.isPrintEvent()) {
            eventContext.put("NAME", piName);
        }
        if (pCtx.isDebug()) {
            eventContext.put("PI_DEBUG", Boolean.TRUE);
        }
        return eventContext;
    }

    public boolean isSubProcessInstance(WFProcessContext pCtx) {
        int i = pCtx.getProcessInstanceEB().getIsCallbackCaller();
        return SubProcessType.isSubProcess((int)i);
    }

    public String getParentProcessInstanceName(WFProcessContext pCtx) {
        String parentPIname = null;
        parentPIname = pCtx.getProcessInstanceName().substring(0, pCtx.getProcessInstanceName().indexOf(64));
        return parentPIname;
    }

    public Object getExtBusinessObject(WFProcessContext pCtx, String dsName, Object pkInfo) {
        return this.getExtBO(pCtx, dsName, pkInfo);
    }

    public HashMap getSlotValue(WFProcessContext pCtx, String[] dsNames, boolean isPublicOnly) {
        Map boDsExpMap;
        if (dsNames == null || dsNames.length == 0) {
            return new HashMap();
        }
        HashMap<String, Object> dsNameValues = new HashMap<String, Object>();
        WFDataslot ds = null;
        Vector<String> globalDSNames = new Vector<String>();
        Vector<String> instanceDSNames = new Vector<String>();
        ArrayList<String> extBODSList = new ArrayList<String>();
        List validDsNames = BLUtil.prepareDataSlotNames(Arrays.asList(dsNames), (WFProcessContext)pCtx);
        for (String dsName : validDsNames) {
            if (dsName.startsWith("@")) {
                dsNameValues.put(dsName, this.getSystemPredefinedSlotValue(pCtx, dsName));
                continue;
            }
            ds = pCtx.getProcess().getDataslot(dsName);
            if (isPublicOnly && !ds.isPublic) continue;
            if (ds.isValueMapped() && !ds.isValueMappedToCreator()) {
                Object dsValue = ds.getValue();
                dsNameValues.put(dsName, this.getValueMappedSlotValue(pCtx, dsName, (String)dsValue));
                continue;
            }
            if (ds.isObject() && ds.isExternalBO()) {
                if (pCtx.isInstanceCreation() || pCtx.isPICompleted()) continue;
                extBODSList.add(dsName);
                continue;
            }
            if (ds.isGlobal()) {
                globalDSNames.addElement(dsName);
                continue;
            }
            instanceDSNames.addElement(dsName);
        }
        long ptid = pCtx.getProcessTemplateID();
        long piid = pCtx.getProcessInstanceID();
        DAOContext daoCtx = BLUtil.self().getDAOContext(pCtx.getSession());
        HashMap tmp = DataSlotDAO.findByNameList(daoCtx, ptid, globalDSNames);
        if (tmp != null) {
            dsNameValues.putAll(tmp);
        }
        if ((tmp = DataSlotDAO.findByNameList(daoCtx, ptid, piid, instanceDSNames)) != null) {
            dsNameValues.putAll(tmp);
        }
        if (null != extBODSList && !extBODSList.isEmpty()) {
            BLBusinessObjectService.self().populateExtBODataslots(extBODSList, pCtx, dsNameValues);
        }
        if ((boDsExpMap = BLUtil.prepareBOExpression(Arrays.asList(dsNames))) != null && !boDsExpMap.isEmpty()) {
            Map<String, Object> boDsExpValue = WFProcessInstance.getBOExpressionValue(boDsExpMap, dsNameValues, pCtx);
            if (boDsExpValue != null && !boDsExpValue.isEmpty()) {
                dsNameValues.putAll(boDsExpValue);
            }
            HashMap<String, Object> dsValues = new HashMap<String, Object>();
            for (String dataslotName : dsNames) {
                if (dataslotName == null || dataslotName.trim().length() == 0) continue;
                dsValues.put(dataslotName, dsNameValues.get(dataslotName));
            }
            return dsValues;
        }
        return dsNameValues;
    }

    private Object getExtBO(WFProcessContext pCtx, String dsName, Object pkInfo) {
        WFDataslot wfDataslot = pCtx.getDataslot(dsName);
        ExtBOConfig boCfg = wfDataslot.getBOPersistenceConfig();
        if (null == boCfg) {
            throw new BizLogicException("BizLogic_ERR_3302", "WFProcessInstance.getExtBO", new Object[]{dsName, pCtx.getProcessInstanceID(), pCtx.getProcessTemplateName()});
        }
        if (Map.class.isAssignableFrom(pkInfo.getClass())) {
            Map pkMap = null;
            try {
                pkMap = (Map)pkInfo;
            }
            catch (Throwable th) {
                throw new BizLogicException("BizLogic_ERR_3303", "WFProcessInstance.getExtBO", new Object[]{dsName, pCtx.getProcessInstanceID()});
            }
            Object extBO = BLBusinessObjectService.self().getByPKMap(pCtx, wfDataslot, pkMap);
            return extBO;
        }
        if (pkInfo.getClass().isPrimitive()) {
            if (1 != boCfg.getPKAttributes().size()) {
                throw new BizLogicException("BizLogic_ERR_3304", "WFProcessInstance.getExtBO", new Object[]{pkInfo, boCfg.getPKAttributes().size(), dsName, pCtx.getProcessInstanceID()});
            }
            HashMap<String, Object> pkMap = new HashMap<String, Object>();
            pkMap.put((String)boCfg.getPKAttributes().get(0), pkInfo);
            Object extBO = BLBusinessObjectService.self().getByPKMap(pCtx, wfDataslot, pkMap);
            return extBO;
        }
        this.validatePKObject(boCfg, pkInfo, dsName);
        Object extBO = BLBusinessObjectService.self().get(wfDataslot, pkInfo);
        return extBO;
    }

    private void validatePKObject(ExtBOConfig boCfg, Object pkInfo, String dsName) {
        List pkAttributes = boCfg.getPKAttributes();
        Field[] fields = pkInfo.getClass().getDeclaredFields();
        ArrayList<String> invalidAttributes = new ArrayList<String>();
        for (String pk : pkAttributes) {
            boolean found = false;
            for (int idx = 0; idx < fields.length; ++idx) {
                if (!pk.equals(fields[idx].getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            invalidAttributes.add(pk);
        }
        if (!invalidAttributes.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_3305", "WFProcessInstance.validatePKObject", new Object[]{dsName, pkInfo.getClass().getName(), invalidAttributes});
        }
    }

    public Object getSystemPredefinedSlotValue(WFProcessContext pCtx, String dsName) {
        if (dsName.equalsIgnoreCase("@" + "CREATOR")) {
            return pCtx.getProcessInstanceEB().getCreator();
        }
        if (dsName.equalsIgnoreCase("@" + "PROCESSNAME")) {
            return pCtx.getProcessInstanceName();
        }
        if (dsName.equalsIgnoreCase("@" + "WORKSTEPNAME")) {
            return null;
        }
        if (dsName.equalsIgnoreCase("@" + "PRIORITY")) {
            return SBMControl.util.getStringPriority(pCtx.getProcessInstanceEB().getPriority());
        }
        if (dsName.equalsIgnoreCase("@" + "STARTTIME")) {
            return pCtx.getProcessInstanceEB().getTimeStarted();
        }
        if (dsName.equalsIgnoreCase("@" + "ALLDATASLOTS")) {
            return this.createCompleteDSlist(pCtx);
        }
        if (dsName.equalsIgnoreCase("@PROCESS_INSTANCE_ID")) {
            return pCtx.getProcessInstanceID();
        }
        if (dsName.equalsIgnoreCase("@PROCESS_TEMPLATE_NAME")) {
            return pCtx.getProcessTemplateName();
        }
        throw new BizLogicException("BizLogic_ERR_570", "WFProcessInstance.getSystemPredefinedSlotValue", new Object[]{pCtx.getProcessInstanceName(), dsName});
    }

    public HashMap createCompleteDSlist(WFProcessContext pCtx) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("PROCESSNAME", pCtx.getProcessInstanceName());
        hm.put("WORKSTEPNAME", null);
        hm.put("CREATOR", pCtx.getProcessInstanceEB().getCreator());
        hm.put("PRIORITY", SBMControl.util.getStringPriority(pCtx.getProcessInstanceEB().getPriority()));
        hm.put("STARTTIME", pCtx.getProcessInstanceEB().getTimeStarted());
        hm.put("PROCESS_INSTANCE_ID", pCtx.getProcessInstanceID());
        hm.put("PROCESS_TEMPLATE_NAME", pCtx.getProcessTemplateName());
        String[] allDSNameList = pCtx.getProcess().getAllDataSlotName();
        HashMap tmp = this.getSlotValue(pCtx, allDSNameList, true);
        if (tmp != null) {
            hm.putAll(tmp);
        }
        return hm;
    }

    public Object getValueMappedSlotValue(WFProcessContext pCtx, String dsName, String mappedValue) {
        if (mappedValue.equalsIgnoreCase("@" + "PROCESSPRIORITY")) {
            return SBMControl.util.getStringPriority(pCtx.getProcessInstanceEB().getPriority());
        }
        if (mappedValue.startsWith("@" + "WORKSTEPPRIORITY:")) {
            String wsName = mappedValue.substring(mappedValue.indexOf(":") + 1);
            WFWorkstep ws = pCtx.getProcess().getWorkstep(wsName);
            long wsid = ws.getID();
            WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid, true);
            if (wsieb == null) {
                return SBMUtil.self().getStringPriority(ws.getPriority());
            }
            return SBMControl.util.getStringPriority(wsieb.getPriority());
        }
        if (mappedValue.startsWith("@" + "WORKSTEPDUEDATE:")) {
            String wsName = mappedValue.substring(mappedValue.indexOf(":") + 1);
            long wsid = pCtx.getProcess().getWorkstep(wsName).getID();
            WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid, true);
            if (wsieb == null) {
                return "0";
            }
            return new DateTime(wsieb.getDuedate()).getStringValue();
        }
        if (mappedValue.equalsIgnoreCase("@" + "CREATOR")) {
            return pCtx.getProcessInstanceEB().getCreator();
        }
        throw new BizLogicException("BizLogic_ERR_550", "WFProcessInstance.getValueMappedSlotValue", (Object[])new String[]{pCtx.getProcessInstanceName(), dsName});
    }

    private WFJavaScript getWorkstepJavaScriptObj(WFProcessContext pCtx, String ptName, String wsName) {
        WFJavaScript jsObj = null;
        WFProcess ptObj = pCtx.getProcess();
        jsObj = ptObj.getJScript(wsName);
        if (BLControl.util.DEBUG_ENGINE && jsObj != null) {
            BLControl.logger.debug((Object)("PT: " + ptName + "  WS: " + wsName + "  JS: " + jsObj));
        }
        return jsObj;
    }

    public void suspend(WFProcessContext pCtx) {
        Vector piWS;
        long piid;
        block6: {
            if (this.isSuspended(pCtx)) {
                BLControl.logger.warnKey("BizLogic_ERR_1660", new Object[]{pCtx.getProcessInstanceName()});
                return;
            }
            if (!this.isActivated(pCtx)) {
                throw new BizLogicException("BizLogic_ERR_1661", "WFProcessInstance.suspend", new Object[]{pCtx.getProcessInstanceName()});
            }
            piid = pCtx.getProcessInstanceID();
            piWS = WorkStepInstanceDAO.findByProcessInstance(piid, 61);
            this.suspendWorksteps(pCtx, piWS);
            piWS = WorkStepInstanceDAO.findByProcessInstance(piid, 91);
            this.suspendWorksteps(pCtx, piWS);
            piWS = WorkStepInstanceDAO.findByProcessInstance(piid, 62);
            this.suspendWorksteps(pCtx, piWS);
            piWS = WorkStepInstanceDAO.findByProcessInstance(piid, 18);
            if (piWS.isEmpty()) break block6;
            HashMap attrs = null;
            for (int ix = piWS.size() - 1; ix >= 0; --ix) {
                int wstype;
                long wsid;
                block8: {
                    block7: {
                        attrs = (HashMap)piWS.elementAt(ix);
                        wsid = (Long)attrs.get("WORKSTEPID");
                        wstype = (Integer)attrs.get("TYPE");
                        if (wstype == 107 && !pCtx.getWorkstep(wsid).isMonitorStep()) break block7;
                        if (wstype == 109) break block7;
                        if (wstype == 111) break block7;
                        if (wstype == 112) break block7;
                        if (wstype != 110) break block8;
                    }
                    throw new BizLogicException("BizLogic_ERR_1532", "WFProcessInstance.suspend", new Object[]{"suspend()", "ProcessInstance", pCtx.getProcessInstanceName(), "external/webservice/message subscriber workstep is running."});
                }
                WFWorkstepInstance.getWorkstepInstance(wstype).suspend(pCtx, wsid, false, null, BLControl.msgFactory.lookup("BizLogic_ERR_4646"));
            }
        }
        piWS = WorkStepInstanceDAO.findByProcessInstance(piid, 60);
        this.suspendWorksteps(pCtx, piWS);
        this.setStatus(pCtx, 8);
        BLUtil.fireEvent(this.getEventContext(pCtx, 8), (int)8);
        EmailComposer.self().sendPISuspendProblem(BLUtil.SYSTEMADMIN, pCtx.getProcessInstanceName());
    }

    private void suspendWorksteps(WFProcessContext pCtx, Vector wsList) {
        if (wsList != null && !wsList.isEmpty()) {
            HashMap attrs = null;
            for (int ix = wsList.size() - 1; ix >= 0; --ix) {
                attrs = (HashMap)wsList.get(ix);
                long wsid = (Long)attrs.get("WORKSTEPID");
                int wstype = (Integer)attrs.get("TYPE");
                WFWorkstepInstance.getWorkstepInstance(wstype).suspend(pCtx, wsid, false, null, BLControl.msgFactory.lookup("BizLogic_ERR_4646"));
            }
        }
    }

    public void resume(WFProcessContext pCtx) {
        if (this.isActivated(pCtx)) {
            BLControl.logger.warnKey("BizLogic_ERR_1665", new Object[]{pCtx.getProcessInstanceName()});
            return;
        }
        if (!this.isSuspended(pCtx)) {
            throw new BizLogicException("BizLogic_ERR_1666", "WFProcessInstance.resume", new Object[]{pCtx.getProcessInstanceName()});
        }
        pCtx.setResumingSuspendedPI(true);
        if (pCtx.isSyncSubProcessInstance()) {
            HashMap subProcessInfo = SubProcessDAO.findBySubProcessInstance(pCtx.getProcessInstanceID());
            long parentPIID = (Long)subProcessInfo.get("PROCESSINSTANCEID");
            WFProcessContext parentPrcCtx = new WFProcessContext(pCtx.getSession(), parentPIID);
            if (!pCtx.isResumeFromParent()) {
                long subProcessWSID = (Long)subProcessInfo.get("WORKSTEPID");
                if (parentPrcCtx.isWorkstepSuspended(subProcessWSID)) {
                    throw new BizLogicException("BizLogic_ERR_4725", "WFProcessInstance.resume", new Object[]{pCtx.getProcessInstanceID(), subProcessWSID, parentPIID});
                }
            }
        }
        long piid = pCtx.getProcessInstanceID();
        Vector v = WorkStepInstanceDAO.findByProcessInstance(piid, 16);
        HashMap attrs = null;
        for (int ix = v.size() - 1; ix >= 0; --ix) {
            attrs = (HashMap)v.elementAt(ix);
            long wsid = (Long)attrs.get("WORKSTEPID");
            int wstype = (Integer)attrs.get("TYPE");
            WFWorkstepInstance.getWorkstepInstance(wstype).resume(pCtx, wsid);
        }
        if (this.isSuspended(pCtx)) {
            this.updateStatusToActivated(pCtx);
        }
    }

    private void updateStatusToActivated(WFProcessContext pCtx) {
        this.setStatus(pCtx, 7);
        BLUtil.fireEvent(this.getEventContext(pCtx, 9), (int)9);
    }

    public String getName(WFProcessContext pCtx) {
        return pCtx.getProcessInstanceName();
    }

    public void setDuedate(WFProcessContext pCtx, long date, boolean fireEvent) {
        if (this.isSuspended(pCtx)) {
            throw new BizLogicException("Bizlogic_ERR_4804", "WFProcessInstance.setDuedate", new Object[]{pCtx.getProcessInstanceName()});
        }
        long timeStarted = pCtx.getProcessInstanceEB().getTimeStarted();
        long duedate = this.adjustDueDate(date, timeStarted);
        pCtx.getProcessInstanceEB().setDuedate(duedate);
        if (pCtx.getProcess().isCheckDue()) {
            TimerActionDAO.updateDueDate(pCtx.getProcessInstanceID(), -1L, duedate);
        }
        if (fireEvent) {
            BLUtil.fireEvent(this.getEventContext(pCtx, 14), (int)14);
        }
    }

    public boolean isActivated(WFProcessContext pCtx) {
        return pCtx.getProcessInstanceEB().getState() == 7;
    }

    public boolean isSuspended(WFProcessContext pCtx) {
        return pCtx.getProcessInstanceEB().getState() == 8;
    }

    public boolean isExist(WFProcessContext pCtx) {
        return this.isExist(pCtx.getProcessInstanceID());
    }

    public boolean isExist(long piid) {
        return ProcessInstanceDAO.isProcessInstanceExist(piid);
    }

    public long getRootInstanceID(WFProcessContext pCtx) {
        return pCtx.getProcessInstanceEB().getRootInstanceID();
    }

    public void removePrivateDocuments(WFProcessContext pCtx) {
        String[] docslots = pCtx.getProcess().getInstancePrivateDocDSNames();
        HashMap dsMap = pCtx.getSlotValue(docslots);
        if (dsMap != null && !dsMap.isEmpty()) {
            WFDataSlotInstance.self().removeDocumentDS(pCtx, dsMap);
        }
    }

    public Map<String, Object> getBulkUpdateEventContext(WFProcessContext pCtx, HashMap changedAtts, int eventType) {
        Map eventContext = SBMUtil.getNewEventContext();
        if (!WFProcessInstance.checkAuditRequired(pCtx, eventType)) {
            eventContext.put("AUDIT_DISABLED", true);
            return eventContext;
        }
        ProcessInstanceEBLocal pieb = pCtx.getProcessInstanceEB();
        WFProcess pt = pCtx.getProcess();
        eventContext.put("PROCESSTEMPLATENAME", pt.getName());
        eventContext.put("PROCESSTEMPLATEID", pt.getID());
        eventContext.put("PROCESSINSTANCENAME", pCtx.getProcessInstanceName());
        eventContext.put("PROCESSINSTANCEID", pCtx.getProcessInstanceID());
        eventContext.put("RPID", pieb.getRootInstanceID());
        eventContext.put("RPTID", pieb.getRootTemplateID());
        if (eventType == 41) {
            eventContext.put("CHANGEDATTRIBUTESLIST", changedAtts);
            eventContext.put("DURATION", String.valueOf((pieb.getDuedate() - pieb.getTimeStarted()) / 1000L));
            eventContext.put("STARTTIME", String.valueOf(pieb.getTimeStarted()));
            String tmp = pieb.getCreator();
            if (tmp != null) {
                eventContext.put("CREATOR", tmp);
            }
            if ((tmp = pt.getManager()) != null) {
                eventContext.put("PMANAGER", tmp);
            }
            eventContext.put("PRIORITY", SBMControl.util.getStringPriority(pieb.getPriority()));
            tmp = pt.getDescription();
            if (tmp != null) {
                eventContext.put("DESCRIPTION", tmp);
            }
            eventContext.put("PILABEL", BLUtil.getPILabelString((String)pCtx.getProcessInstanceName()));
        } else if (eventType == 42) {
            HashMap<String, String> dsValues = new HashMap<String, String>(changedAtts);
            if (BLControl.util.excludeBlobDSInEvents()) {
                Set dsNameSet = changedAtts.keySet();
                List<String> validBlobDS = pCtx.getProcess().getBlobDataslots(new ArrayList<String>(dsNameSet));
                for (String name : validBlobDS) {
                    dsValues.put(name, "<VALUE NOT ADDED>");
                }
            }
            eventContext.put("SESSION_USER", pCtx.getSession().getUser());
            eventContext.put("CHANGEDDATASLOTSLIST", dsValues);
            eventContext.put("GLOBAL_SLOT_NAME_LIST", pt.getGlobalDSNamesList());
        }
        return eventContext;
    }

    private void removeDynamicProcessTemplate(long piid) {
        boolean removeOnCompletion = ProcessInstanceXMLDAO.isRemoveOnCompletion(piid);
        if (removeOnCompletion) {
            ProcessInstanceXMLDAO.remove(piid);
            ProcessInstanceTemplateDAO.remove(piid);
        }
    }

    public void setAttributes(WFProcessContext pCtx, HashMap attributes) {
        int size;
        if (attributes.containsKey("STARTPOINT")) {
            this.setStartPoint(pCtx, (String)attributes.get("STARTPOINT"));
            attributes.remove("STARTPOINT");
        }
        if ((size = attributes.size()) > 0) {
            boolean fireSingleEvent = false;
            if (size == 1) {
                fireSingleEvent = true;
            }
            Map.Entry entry2 = null;
            String key = null;
            Object value = null;
            for (Map.Entry entry2 : attributes.entrySet()) {
                key = (String)entry2.getKey();
                value = entry2.getValue();
                if (key.equalsIgnoreCase("PRIORITY")) {
                    this.setPriority(pCtx, value, fireSingleEvent);
                    continue;
                }
                if (key.equalsIgnoreCase("CREATOR")) {
                    this.setCreator(pCtx, value, fireSingleEvent);
                    continue;
                }
                if (key.equalsIgnoreCase("DUEDATE")) {
                    this.setDuedate(pCtx, (Long)value, fireSingleEvent);
                    continue;
                }
                throw new BizLogicException("BizLogic_ERR_1507", "WFProcessInstance.setAttributes", new Object[]{"ProcessInstance", pCtx.getProcessInstanceID(), key});
            }
            if (!fireSingleEvent) {
                BLUtil.fireEvent(this.getBulkUpdateEventContext(pCtx, attributes, 41), (int)41);
            }
        }
    }

    public static final HashMap copyXML(WFProcessContext pCtx, long wsid, HashMap slotValues) {
        if (slotValues == null) {
            return slotValues;
        }
        HashMap<String, XML> newSlotValues = new HashMap<String, XML>();
        for (String mappedName : slotValues.keySet()) {
            Object slotValue = slotValues.get(mappedName);
            try {
                if (slotValue != null && slotValue instanceof XML) {
                    String name = ((XML)slotValue).getName();
                    String xmlContent = ((XML)slotValue).getContent(pCtx.getSession());
                    XML subXML = new XML(xmlContent);
                    subXML.setName(name);
                    newSlotValues.put(mappedName, subXML);
                    continue;
                }
                newSlotValues.put(mappedName, (XML)slotValue);
            }
            catch (Exception e) {
                throw new BizLogicException("BizLogic_ERR_2134", "WFProcessInstance.copyXML", new Object[]{mappedName, pCtx.getProcessInstanceName()}, (Throwable)e);
            }
        }
        return newSlotValues;
    }

    public final long getDuration(WFProcessContext pCtx) {
        HashMap callerInfo;
        ProcessInstanceEBLocal pieb = pCtx.getProcessInstanceEB();
        if (pieb.isSubProcessInstance() && (callerInfo = pieb.getCallerInfo()) != null) {
            Long duration = (Long)callerInfo.get("CALLERWORKSTEPDURATION");
            if (duration != null && duration > 0L) {
                return duration;
            }
        }
        return pCtx.getProcess().getEstimatedDuration();
    }

    protected HashMap getProcessContextData(WFProcessContext pCtx) {
        WFProcess pt = pCtx.getProcess();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("PROCESSTEMPLATEID", pt.getID());
        context.put("PROCESSTEMPLATENAME", pt.getName());
        context.put("PROCESSINSTANCEID", pCtx.getProcessInstanceID());
        context.put("PROCESSINSTANCENAME", pCtx.getProcessInstanceName());
        return context;
    }

    public HashMap validateAttributesForCreateInstance(String ptName, HashMap piAttributes) {
        String piname;
        HashMap attributes = new HashMap();
        if (piAttributes != null) {
            attributes.putAll(piAttributes);
        }
        if ((piname = (String)attributes.get("PROCESSINSTANCENAME")) == null || piname.trim().isEmpty()) {
            piname = ptName;
            attributes.put("PROCESSINSTANCENAME", piname);
        }
        if (BLUtil.checkName((String)piname)) {
            Object[] objectArray = new Object[2];
            objectArray[0] = piname;
            objectArray[1] = "*!#@\\'\"/?:%$<>";
            throw new BizLogicException("BizLogic_ERR_598", "WFProcessInstance::validateAttributesForCreateInstance", objectArray);
        }
        WFProcess pt = ProcessControl.getProcessTemplate(ptName);
        attributes.put("PROCESSTEMPLATEID", pt.getID());
        int pri = 0;
        String priority = (String)attributes.get("PRIORITY");
        if (priority != null && priority.trim().length() > 0) {
            attributes = BLControl.util.convertPriorityToInt(attributes);
            pri = (Integer)attributes.get("PRIORITY");
            if (pri == -1) {
                throw new BizLogicException("BizLogic_ERR_1592", "WFProcessInstance.validateAttributesForCreateInstance", new Object[]{priority == null ? NULL : priority});
            }
        } else {
            pri = SBMControl.util.Default_Priority_int;
            attributes.put("PRIORITY", pri);
            BLControl.logger.warnKey("BizLogic_ERR_907", new Object[]{SBMControl.util.getStringPriority(pri)});
        }
        return attributes;
    }

    public void updateNewDataSlotsForPTR(Session ses, Map<String, Object> piDetails, Map dsMap) {
        long parentid = (Long)piDetails.get("PARENTID");
        long ptid = (Long)piDetails.get("PROCESSTEMPLATEID");
        long rptid = (Long)piDetails.get("RPTID");
        long piid = (Long)piDetails.get("PROCESSINSTANCEID");
        long rpid = (Long)piDetails.get("RPID");
        String piname = (String)piDetails.get("PROCESSINSTANCENAME");
        WFProcessContext pCtx = new WFProcessContext(ses, piid, ptid, piname, parentid, rpid, rptid);
        pCtx.setProcessRefresh(true);
        WFProcess pt = pCtx.getProcess();
        WFProcessInstance.createPIFolderForPTR(pCtx);
        WFProcessReplaceInfo replaceInfo = pt.getReplaceInfo();
        if (replaceInfo.hasNewComplexInstanceDS()) {
            HashMap<String, Object> newComplexDS = new HashMap<String, Object>();
            HashMap excludeDS = new HashMap();
            BLConstants.single();
            excludeDS.putAll(pt.getDataSlotsWithDefaultValues("XML", false));
            BLConstants.single();
            excludeDS.putAll(pt.getDataSlotsWithDefaultValues("DOCUMENT", false));
            BLConstants.single();
            excludeDS.putAll(pt.getDataSlotsWithDefaultValues("DATETIME", false));
            Map newInstanceDS = replaceInfo.getNewInstanceDSList();
            for (String dsName : newInstanceDS.keySet()) {
                WFDataslot ds = pt.getDataslot(dsName);
                Object dsValue = null;
                if (!ds.isXML() && !ds.isDocument() && !ds.isDate()) continue;
                dsValue = ds.getValue();
                newComplexDS.put(ds.getName(), dsValue);
                excludeDS.remove(ds.getName());
                dsMap.put(dsName, dsValue);
            }
            HashMap complexDSDefaultValues = WFDataSlotInstance.self().getComplexDSDefaultValues(pCtx, excludeDS);
            dsMap.putAll(complexDSDefaultValues);
            pCtx.setSendSUpdateEvent(true);
        } else {
            pCtx.setSendSUpdateEvent(false);
        }
        pCtx.updateSlotValue(dsMap);
    }

    protected final String getStateDescription(WFProcessContext pCtx) {
        ProcessInstanceEBLocal pieb = pCtx.getProcessInstanceEB();
        int state = pieb.getState();
        return BLConstants.single().wfStates[state];
    }

    public void reActivateWSForIM(WFProcessContext pCtx) {
        pCtx.setIsInstanceMigration(true);
        long piid = pCtx.getProcessInstanceID();
        long[] lArray = new long[]{piid};
        int[] nArray = new int[1];
        BLConstants.single();
        nArray[0] = 18;
        Vector wsList = WorkStepInstanceDAO.getWorkStepInstanceList(null, lArray, nArray, null, false);
        HashMap wsAttrs = null;
        for (int ix = 0; ix < wsList.size(); ++ix) {
            wsAttrs = (HashMap)wsList.get(ix);
            BLConstants.single();
            long wsid = (Long)wsAttrs.get("WORKSTEPID");
            BLConstants.single();
            int wsType = (Integer)wsAttrs.get("TYPE");
            BLConstants.single();
            if (wsType != 102) {
                throw new BizLogicException("BizLogic_ERR_815", "WFProcessInstance.reActivateWSForIM()", new Object[]{piid, wsid});
            }
            boolean isMonitorWorkstep = false;
            BLConstants.single();
            if (wsAttrs.containsKey("MONITOR_STEP")) {
                BLConstants.single();
                isMonitorWorkstep = (Boolean)wsAttrs.get("MONITOR_STEP");
            }
            if (isMonitorWorkstep) continue;
            WFAtomicInstance.self().createWorkitems(pCtx, wsid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createPIFolderForPTR(WFProcessContext pCtx) {
        if (pCtx.getProcess().hasDocumentDataslot()) {
            DSContext dsContext = new DSContext(null);
            try {
                BLDocClient.getService().startSession(dsContext);
                long ptid = pCtx.getProcessTemplateID();
                long piid = pCtx.getProcessInstanceID();
                String piFolderPath = BLDocClient.getPIFolderPath((long)ptid, (long)piid);
                if (!BLDocClient.getService().isFolderExistByPath(dsContext, piFolderPath)) {
                    DocumentFolder piFolder = BLDocService.createInstanceFolder((long)ptid, (long)piid);
                    pCtx.getProcessInstanceEB().setFolderId(piFolder.getId());
                }
            }
            finally {
                BLDocClient.getService().endSession(dsContext);
            }
        }
    }

    public void updateSlotValueForIM(WFProcessContext pCtx, HashMap dsValues) {
        pCtx.setIsInstanceMigration(true);
        pCtx.setSendSUpdateEvent(false);
        WFDataSlotInstance.self().updateSlotValue(pCtx, dsValues);
    }

    public Map<String, Integer> getRealUsersFromDataSlot(WFProcessContext pCtx, String dsName, boolean expandGroup, boolean allowQueue, boolean removeInvalid) {
        if (dsName == null || dsName.trim().length() == 0) {
            throw new BizLogicException("BizLogic_ERR_3563", "WFProcessInstance.getRealUsersFromDataSlot");
        }
        HashMap<String, Integer> realUsers = new HashMap<String, Integer>();
        BLConstants.single();
        if ("@CREATOR".equalsIgnoreCase(dsName)) {
            String piCreator = pCtx.getProcessInstanceEB().getCreator();
            if (piCreator == null) {
                throw new BizLogicException("BizLogic_ERR_571", "WFProcessInstance.getRealUsersFromDataSlot", (Object[])new String[]{pCtx.getProcessInstanceName()});
            }
            BLConstants.single();
            realUsers.put(piCreator, 1);
            return realUsers;
        }
        Object dsValue = pCtx.getSlotValue(dsName);
        List userListFromDS = new ArrayList();
        if (dsValue != null) {
            if (dsValue instanceof String) {
                userListFromDS = BLUtil.toVectorListPerformer((String)((String)dsValue));
            } else if (dsValue instanceof List) {
                userListFromDS = BLUtil.validateAndFilterUserList((List)((List)dsValue), (String)dsName, (String)pCtx.getProcessInstanceName());
            } else {
                throw new BizLogicException("BizLogic_ERR_3910", "WFProcessInstance.getRealUsersFromDataSlot", (Object[])new String[]{dsName, pCtx.getProcessTemplateName()});
            }
        }
        for (int ix = 0; ix < userListFromDS.size(); ++ix) {
            String userFromDS = (String)userListFromDS.get(ix);
            User userObj = pCtx.getUser(userFromDS);
            if (userObj != null) {
                BLConstants.single();
                realUsers.put(userFromDS, 1);
                continue;
            }
            Group group = BLUtil.getGroup((String)userFromDS);
            if (group != null) {
                if (expandGroup) {
                    String[] memberNames = group.getMemberNames();
                    for (int index = 0; index < memberNames.length; ++index) {
                        String string = memberNames[index];
                        BLConstants.single();
                        realUsers.put(string, 1);
                    }
                    continue;
                }
                BLConstants.single();
                realUsers.put(userFromDS, 3);
                continue;
            }
            if (SBMControl.util.isUseQueue() && allowQueue && BLControl.queueManager.isQueue(userFromDS)) {
                BLConstants.single();
                realUsers.put(userFromDS, 2);
                continue;
            }
            if (removeInvalid) continue;
            BLConstants.single();
            realUsers.put(userFromDS, 4);
        }
        return realUsers;
    }

    public void updateSlotValue(Session session, List<Long> piids, Map<String, Object> dsValues, boolean isMultiTrans) {
        if (piids == null || piids.isEmpty()) {
            throw new BizLogicException("Bizlogic_ERR_4624", "WFProcessInstance.updateSlotValue()");
        }
        HashMap<Long, Map<String, Object>> piDataslots = new HashMap<Long, Map<String, Object>>();
        for (Long piid : piids) {
            piDataslots.put(piid, dsValues);
        }
        this.updateSlotValue(session, piDataslots, isMultiTrans);
    }

    public void updateSlotValue(Session session, Map<Long, Map<String, Object>> piDataslots, boolean isMultiTrans) {
        if (piDataslots == null || piDataslots.isEmpty()) {
            throw new BizLogicException("Bizlogic_ERR_4623", "WFProcessInstance.updateSlotValue()");
        }
        Set<Long> piids = piDataslots.keySet();
        if (isMultiTrans) {
            for (Long piid : piids) {
                BLUtil.getServiceLocal().updateSlotValue(session, piid, piDataslots.get(piid));
            }
        } else {
            for (Long piid : piids) {
                WFDataSlotInstance.self().updateSlotValue(session, piid, piDataslots.get(piid));
            }
        }
    }

    public ResultData<List<Long>> completeByClient(Session ses, List<Long> idList) {
        if (idList == null || idList.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4621", "WFProcessInstance.completeByClient()", new Object[]{"complete", "process instance"});
        }
        ArrayList<Long> validIdList = new ArrayList<Long>();
        for (Long piid : idList) {
            try {
                if (piid == null) {
                    throw new BizLogicException("BizLogic_ERR_3762", "WFProcessInstance.completeByClient()", new Object[]{idList, "complete", "process instance"});
                }
                BLUtil.getServiceLocal().completeProcessInstance(ses, piid);
                validIdList.add(piid);
            }
            catch (Throwable th) {
                return new ResultData(validIdList, th, (Object)piid);
            }
        }
        return new ResultData();
    }

    public ResultData<List<Long>> suspendByClient(Session ses, List<Long> idList) {
        if (idList == null || idList.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4621", "WFProcessInstance.suspendByClient()", new Object[]{"suspend", "process instance"});
        }
        ArrayList<Long> validIdList = new ArrayList<Long>();
        for (Long piid : idList) {
            try {
                if (piid == null) {
                    throw new BizLogicException("BizLogic_ERR_3762", "WFProcessInstance.suspendByClient()", new Object[]{idList, "suspend", "process instance"});
                }
                BLUtil.getServiceLocal().suspendProcessInstance(ses, piid);
                validIdList.add(piid);
            }
            catch (Throwable th) {
                return new ResultData(validIdList, th, (Object)piid);
            }
        }
        return new ResultData();
    }

    public ResultData<List<Long>> resumeByClient(Session ses, List<Long> idList) {
        if (idList == null || idList.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4621", "WFProcessInstance.resumeByClient()", new Object[]{"resume", "process instance"});
        }
        ArrayList<Long> validIdList = new ArrayList<Long>();
        for (Long piid : idList) {
            try {
                if (piid == null) {
                    throw new BizLogicException("BizLogic_ERR_3762", "WFProcessInstance.resumeByClient()", new Object[]{idList, "resume", "process instance"});
                }
                BLUtil.getServiceLocal().resumeProcessInstance(ses, piid);
                validIdList.add(piid);
            }
            catch (Throwable th) {
                return new ResultData(validIdList, th, (Object)piid);
            }
        }
        return new ResultData();
    }

    public ResultData<List<Long>> removeByClient(Session ses, List<Long> idList) {
        if (idList == null || idList.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4621", "WFProcessInstance.removeByClient()", new Object[]{"remove", "process instance"});
        }
        ArrayList<Long> validIdList = new ArrayList<Long>();
        for (Long piid : idList) {
            try {
                if (piid == null) {
                    throw new BizLogicException("BizLogic_ERR_3762", "WFProcessInstance.removeByClient()", new Object[]{idList, "remove", "process instance"});
                }
                BLUtil.getServiceLocal().removeProcessInstance(ses, piid);
                validIdList.add(piid);
            }
            catch (Throwable th) {
                return new ResultData(validIdList, th, (Object)piid);
            }
        }
        return new ResultData();
    }

    public long getProcessInstanceId(Session session, String ptName, String monitorDSValue) {
        if (ptName == null || ptName.trim().length() == 0) {
            throw new BizLogicException("BizLogic_ERR_3871", "WFProcessInstance.getProcessInstanceId()", new Object[]{"ProcessInstanceSB::getProcessInstanceId()"});
        }
        if (monitorDSValue == null || monitorDSValue.trim().length() == 0) {
            throw new BizLogicException("BizLogic_ERR_4839", "WFProcessInstance.getProcessInstanceId()", new Object[]{ptName});
        }
        WFProcess wfProcess = ProcessControl.getProcessTemplate(ptName);
        if (wfProcess == null) {
            throw new BizLogicException("BizLogic_ERR_519", "WFProcessInstance.getProcessInstanceId()", new Object[]{ptName});
        }
        if (!wfProcess.isMonitoringProcess()) {
            throw new BizLogicException("BizLogic_ERR_4838", "WFProcessInstance.getProcessInstanceId()", new Object[]{ptName});
        }
        return WFDataSlotInstance.getProcessInstanceId(ptName, monitorDSValue, true);
    }

    private final long adjustDueDate(long duedate, long timeStarted) {
        Date d = null;
        boolean currentTimeSet = false;
        long currentTime = System.currentTimeMillis();
        d = new Date(duedate);
        if (duedate == 0L) {
            d = new Date();
            currentTimeSet = true;
        } else if (duedate < currentTime) {
            long limitHrs = BLControl.util.getPastDueDateLimit() / 3600000L;
            if (duedate != timeStarted && this.isPastDueDateUnderLimit(duedate, currentTime)) {
                BLControl.logger.warnKey("BizLogic_ERR_4635", new Object[]{d, limitHrs + " hrs"});
            } else {
                BLControl.logger.warnKey("BizLogic_ERR_2570", new Object[]{d, limitHrs + " hrs"});
                d = new Date();
                currentTimeSet = true;
            }
        }
        if (currentTimeSet || duedate == timeStarted || d.getHours() == 0 && d.getMinutes() == 0 && d.getSeconds() == 0) {
            d.setHours(23);
            d.setMinutes(59);
            duedate = d.getTime();
        }
        return duedate;
    }

    private boolean isPastDueDateUnderLimit(long duedate, long currentTime) {
        long allowedPastTime = currentTime - BLControl.util.getPastDueDateLimit();
        return duedate > allowedPastTime;
    }

    static boolean checkAuditRequired(WFProcessContext pCtx, int eventType) {
        return WFProcessInstance.checkAuditRequired(pCtx.getProcess(), eventType);
    }

    static boolean checkAuditRequired(WFProcess process, int eventType) {
        boolean isAudit = process.isAuditEnabled();
        boolean isAuditFilter = BLUtil.self().isAuditFilter();
        if (!isAudit) {
            if (!isAuditFilter) {
                return false;
            }
            if (!BLUtil.self().getAuditFilterValues().contains(eventType)) {
                return false;
            }
        }
        return true;
    }

    private Map<String, Object> createEventContext(WFProcessContext pCtx, String[] dsNames, int eventType) {
        Map<String, Object> eventContext = this.getEventContext(pCtx, eventType);
        if (dsNames != null && dsNames.length > 0) {
            HashMap<String, String> dsNameValueMap = new HashMap<String, String>();
            if (BLControl.util.excludeBlobDSInEvents()) {
                List<String> blobDsNameList = pCtx.getProcess().getBlobDataslots(Arrays.asList(dsNames));
                for (String dsName : blobDsNameList) {
                    dsNameValueMap.put(dsName, "<VALUE NOT ADDED>");
                }
                List<String> dsNameList = pCtx.getProcess().excludeBlobDataslots(Arrays.asList(dsNames));
                dsNames = dsNameList.toArray(new String[0]);
            }
            dsNameValueMap.putAll(this.getSlotValue(pCtx, dsNames, false));
            HashMap dsValuesAsString = BLUtil.makeObjectToString(dsNameValueMap);
            eventContext.putAll(dsValuesAsString);
        }
        return eventContext;
    }

    private int saveInvalidEvents(WFProcessContext pCtx, String monitorDSValue) {
        if (StringUtils.isBlank((String)monitorDSValue) || NULL.equalsIgnoreCase(monitorDSValue.trim())) {
            return -1;
        }
        HashMap<String, Object> whereAttributes = new HashMap<String, Object>();
        whereAttributes.put("PROCESS_NAME", pCtx.getProcessTemplateName());
        whereAttributes.put("EXTERNAL_INSTANCE_ID", monitorDSValue);
        whereAttributes.put("IS_PROCESSED", 0);
        List<Map<String, Object>> events = MPService.self().getPersistenceService().getEventAttributes(whereAttributes);
        for (Map<String, Object> eventAttrs : events) {
            eventAttrs.put("REASON", "Event removed as the process instance is completed/removed");
            MPService.self().getPersistenceService().storeInvalidEvent(eventAttrs);
        }
        return events.size();
    }

    private void removeMonitorEventData(WFProcessContext pCtx, String monitorDSValue) {
        int invalidEventsSize = this.saveInvalidEvents(pCtx, monitorDSValue);
        if (invalidEventsSize == -1) {
            return;
        }
        MPService.self().getPersistenceService().removeMonitorWaitWorkstep(pCtx.getProcessInstanceID());
        MPService.self().getPersistenceService().removeEvent(pCtx.getProcessTemplateName(), monitorDSValue);
        MPService.self().getPersistenceService().removeMonitorProcessEiid(pCtx.getProcessTemplateID(), monitorDSValue);
        if (BLControl.logger.isDebugEnabled() && BLControl.util.DEBUG_MONITORING) {
            BLControl.logger.debugKey("BizLogic_ERR_3307", "WFProcessInstance.removeMonitorEventData", new Object[]{pCtx.getProcessInstanceID(), monitorDSValue, pCtx.getProcessTemplateID(), invalidEventsSize});
        }
    }

    private DocumentDS handleDocumentDSCreation(WFProcessContext pCtx, String dsName, Object value, DocumentFolder piFolder) {
        DSContext dsContext = null;
        DocumentDS docDS = null;
        if (value == null) {
            throw new BizLogicException("BizLogic_ERR_3660", "WFProcessInstance.handleDocumentDSCreation()", new Object[]{pCtx.getProcessTemplateName(), dsName, value});
        }
        if (piFolder == null) {
            throw new BizLogicException("BizLogic_ERR_4696", "WFProcessInstance.handleDocumentDSCreation()");
        }
        dsContext = BLUtil.self().isMultiUserCredential() ? BLUtil.self().getDSContext(pCtx.getSession()) : new DSContext(null);
        docDS = BLDocClient.createInstanceDS((DSContext)dsContext, (DocumentFolder)piFolder, (String)dsName);
        if (value instanceof Document) {
            Document doc = (Document)value;
            HashMap attributes = new HashMap(doc.getMetadata());
            DSUtil.removeSystemDocAttrs(attributes);
            docDS.createOrReplace(doc.getCreator(), doc.getName(), (InputStream)doc.getContent(dsContext), attributes);
        } else {
            List docObjs = (List)value;
            for (Document doc : docObjs) {
                HashMap attributes = new HashMap(doc.getMetadata());
                DSUtil.removeSystemDocAttrs(attributes);
                docDS.createOrReplace(doc.getCreator(), doc.getName(), (InputStream)doc.getContent(dsContext), attributes);
            }
        }
        return docDS;
    }

    private void validateValueForDocumentSlot(WFProcess pt, HashMap<String, Object> dsValues) {
        if (dsValues == null || dsValues.isEmpty()) {
            return;
        }
        boolean isValDocDS = false;
        boolean isValDocument = false;
        HashMap<String, Object> docDSVal = new HashMap<String, Object>();
        Set<Map.Entry<String, Object>> entries = dsValues.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            WFDataslot ds = pt.getDataslot(entry.getKey());
            if (!ds.isDocument()) continue;
            Object dsValue = entry.getValue();
            docDSVal.put(entry.getKey(), dsValue);
            if (dsValue instanceof DocumentDS) {
                isValDocDS = true;
                continue;
            }
            isValDocument = true;
        }
        if (isValDocDS && isValDocument) {
            throw new BizLogicException("BizLogic_ERR_4697", "WFProcessInstance.validateValueForDocumentSlot()", new Object[]{docDSVal});
        }
    }

    private static Map<String, Object> getBOExpressionValue(Map<String, Set<String>> boDsExprMap, Map<String, Object> dsNameValue, WFProcessContext pCtx) {
        HashMap<String, Object> boExprValue = new HashMap<String, Object>();
        if (boDsExprMap != null && !boDsExprMap.isEmpty()) {
            for (Map.Entry<String, Set<String>> boExprEntry : boDsExprMap.entrySet()) {
                String boDsName = boExprEntry.getKey();
                for (String expr : boExprEntry.getValue()) {
                    Object dsValue = dsNameValue.get(boDsName);
                    StringBuilder boExpr = new StringBuilder(boDsName);
                    BLConstants.single();
                    boExpr.append(".").append(expr);
                    Object value = null;
                    try {
                        value = OGSFactory.getDefault().getValue(dsValue, expr);
                    }
                    catch (Throwable th) {
                        throw new BizLogicException("BizLogic_ERR_4717", "WFProcessInstance.getBOExpressionValue", new Object[]{pCtx.getProcessInstanceID(), dsValue, boExpr.toString()}, th);
                    }
                    boExprValue.put(boExpr.toString(), value);
                }
            }
        }
        return boExprValue;
    }

    public ResultData<List<Long>> updateInstance(Session session, List<Long> piids, Map<String, Object> dsValues, Map<String, Object> attributes, boolean isMultiTrans) {
        if (piids == null || piids.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4730", "wfpi.updateInstance()", new Object[]{"update"});
        }
        if ((dsValues == null || dsValues.isEmpty()) && (attributes == null || attributes.isEmpty())) {
            throw new BizLogicException("BizLogic_ERR_4729", "wfpi.updateInstance()", new Object[]{"wfpi.updateInstance()"});
        }
        if (BLUtil.self().isDebugEngine()) {
            BLControl.logger.debugKey("BizLogic_ERR_4734", new Object[]{"update", "wfpi.updateInstance()", piids, isMultiTrans, dsValues, attributes});
        }
        ArrayList<Long> failedPi = new ArrayList<Long>();
        ResultData result = new ResultData();
        WFProcessContext pCtx = null;
        for (long piid : piids) {
            if (!isMultiTrans) {
                pCtx = new WFProcessContext(session, piid);
                pCtx.updateInstance(dsValues, attributes);
                continue;
            }
            try {
                BLUtil.getServiceLocal().updateInstance(session, piid, dsValues, attributes);
            }
            catch (Throwable th) {
                failedPi.add(piid);
                new BizLogicException("BizLogic_ERR_4727", "wfpi.updateInstance()", new Object[]{"Update", piid}, th);
                result.addFailureToTrace(String.valueOf(piid), th);
            }
        }
        if (BLUtil.self().isDebugEngine() && failedPi != null && !failedPi.isEmpty()) {
            BLControl.logger.debugKey("BizLogic_ERR_4733", new Object[]{"update", "wfpi.updateInstance()", failedPi, piids, isMultiTrans});
        }
        result.setReturnValue(failedPi);
        return result;
    }

    public ResultData<List<Long>> updateInstance(Session session, Map<Long, Map<String, Object>> dsValues, Map<Long, Map<String, Object>> attributes, boolean isMultiTrans) {
        if ((dsValues == null || dsValues.isEmpty()) && (attributes == null || attributes.isEmpty())) {
            throw new BizLogicException("BizLogic_ERR_4729", "wfpi::updateInstance()", new Object[]{"wfpi::updateInstance()"});
        }
        ArrayList<Long> failedPi = new ArrayList<Long>();
        ResultData result = new ResultData();
        WFProcessContext pCtx = null;
        HashSet<Long> piidSet = new HashSet<Long>();
        if (dsValues != null && !dsValues.isEmpty()) {
            piidSet.addAll(dsValues.keySet());
        }
        if (attributes != null && !attributes.isEmpty()) {
            piidSet.addAll(attributes.keySet());
        }
        if (BLUtil.self().isDebugEngine()) {
            BLControl.logger.debugKey("BizLogic_ERR_4734", new Object[]{"update", "wfpi.updateInstance()", piidSet, isMultiTrans, dsValues, attributes});
        }
        Iterator iterator = piidSet.iterator();
        while (iterator.hasNext()) {
            long piid = (Long)iterator.next();
            if ((dsValues == null || dsValues.get(piid) == null || dsValues.get(piid).isEmpty()) && (attributes == null || attributes.get(piid) == null || attributes.get(piid).isEmpty())) {
                if (!BLControl.logger.isDebugEnabled()) continue;
                BLControl.logger.debugKey("BizLogic_ERR_4731", "wfpi.updateInstance()", new Object[]{piid, "wfpi.updateInstance()"});
                continue;
            }
            if (!isMultiTrans) {
                pCtx = new WFProcessContext(session, piid);
                pCtx.updateInstance(dsValues.get(piid), attributes.get(piid));
                continue;
            }
            try {
                BLUtil.getServiceLocal().updateInstance(session, piid, dsValues.get(piid), attributes.get(piid));
            }
            catch (Throwable th) {
                failedPi.add(piid);
                new BizLogicException("BizLogic_ERR_4727", "wfpi.updateInstance()", new Object[]{"Update", piid}, th);
                result.addFailureToTrace(String.valueOf(piid), th);
            }
        }
        if (BLUtil.self().isDebugEngine() && failedPi != null && !failedPi.isEmpty()) {
            BLControl.logger.debugKey("BizLogic_ERR_4733", new Object[]{"update", "wfpi.updateInstance()", failedPi, piidSet, isMultiTrans});
        }
        result.setReturnValue(failedPi);
        return result;
    }

    public ResultData<List<Long>> removeInstance(Session session, List<Long> piids, boolean isMultiTrans) {
        if (piids == null || piids.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4730", "wfpi.removeInstance()", new Object[]{"remove"});
        }
        if (BLUtil.self().isDebugEngine()) {
            BLControl.logger.debugKey("BizLogic_ERR_4732", new Object[]{"remove", "wfpi.removeInstance()", piids, isMultiTrans});
        }
        ArrayList<Long> failedPi = new ArrayList<Long>();
        ResultData result = new ResultData();
        WFProcessContext pCtx = null;
        for (long piid : piids) {
            if (!isMultiTrans) {
                pCtx = new WFProcessContext(session, piid);
                pCtx.removeProcessInstance(false);
                continue;
            }
            try {
                BLUtil.getServiceLocal().removeProcessInstance(session, piid);
            }
            catch (Throwable th) {
                failedPi.add(piid);
                new BizLogicException("BizLogic_ERR_4727", "wfpi.removeInstance()", new Object[]{"Removal", piid}, th);
                result.addFailureToTrace(String.valueOf(piid), th);
            }
        }
        if (BLUtil.self().isDebugEngine() && failedPi != null && !failedPi.isEmpty()) {
            BLControl.logger.debugKey("BizLogic_ERR_4733", new Object[]{"remove", "wfpi.removeInstance()", failedPi, piids, isMultiTrans});
        }
        result.setReturnValue(failedPi);
        return result;
    }

    public ResultData<List<Long>> suspendInstance(Session session, List<Long> piids, boolean isMultiTrans) {
        if (piids == null || piids.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4730", "wfpi.suspendInstance()", new Object[]{"suspend"});
        }
        if (BLUtil.self().isDebugEngine()) {
            BLControl.logger.debugKey("BizLogic_ERR_4732", new Object[]{"suspend", "wfpi.suspendInstance()", piids, isMultiTrans});
        }
        ArrayList<Long> failedPi = new ArrayList<Long>();
        ResultData result = new ResultData();
        WFProcessContext pCtx = null;
        for (long piid : piids) {
            if (!isMultiTrans) {
                pCtx = new WFProcessContext(session, piid);
                pCtx.suspendProcessInstance();
                continue;
            }
            try {
                BLUtil.getServiceLocal().suspendProcessInstance(session, piid);
            }
            catch (Throwable th) {
                failedPi.add(piid);
                new BizLogicException("BizLogic_ERR_4727", "wfpi.suspendInstance()", new Object[]{"Suspend", piid}, th);
                result.addFailureToTrace(String.valueOf(piid), th);
            }
        }
        if (BLUtil.self().isDebugEngine() && failedPi != null && !failedPi.isEmpty()) {
            BLControl.logger.debugKey("BizLogic_ERR_4733", new Object[]{"suspend", "wfpi.suspendInstance()", failedPi, piids, isMultiTrans});
        }
        result.setReturnValue(failedPi);
        return result;
    }

    public ResultData<List<Long>> resumeInstance(Session session, List<Long> piids, boolean isMultiTrans) {
        if (piids == null || piids.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4730", "wfpi.resumeInstance()", new Object[]{"resume"});
        }
        if (BLUtil.self().isDebugEngine()) {
            BLControl.logger.debugKey("BizLogic_ERR_4732", new Object[]{"resume", "wfpi.resumeInstance()", piids, isMultiTrans});
        }
        ArrayList<Long> failedPi = new ArrayList<Long>();
        ResultData result = new ResultData();
        WFProcessContext pCtx = null;
        for (long piid : piids) {
            if (!isMultiTrans) {
                pCtx = new WFProcessContext(session, piid);
                pCtx.resumeProcessInstance();
                continue;
            }
            try {
                BLUtil.getServiceLocal().resumeProcessInstance(session, piid);
            }
            catch (Throwable th) {
                failedPi.add(piid);
                new BizLogicException("BizLogic_ERR_4727", "wfpi.resumeInstance()", new Object[]{"Resume", piid}, th);
                result.addFailureToTrace(String.valueOf(piid), th);
            }
        }
        if (BLUtil.self().isDebugEngine() && failedPi != null && !failedPi.isEmpty()) {
            BLControl.logger.debugKey("BizLogic_ERR_4733", new Object[]{"resume", "wfpi.resumeInstance()", failedPi, piids, isMultiTrans});
        }
        result.setReturnValue(failedPi);
        return result;
    }
}

