/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFWorkstepInstance;
import com.savvion.sbm.bizlogic.server.dao.ProcessInstanceDAO;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLJMSService;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import java.util.HashMap;
import javax.jms.Message;

public class WFWebServiceInstance
extends WFWorkstepInstance {
    private static WFWebServiceInstance self;

    private WFWebServiceInstance() {
    }

    public static synchronized WFWebServiceInstance self() {
        if (self == null) {
            self = new WFWebServiceInstance();
        }
        return self;
    }

    @Override
    public void execute(WFProcessContext pCtx, long wsid) {
        this.sendMessage(pCtx, wsid);
    }

    public void sendMessage(WFProcessContext pCtx, long wsid) {
        long ptid = pCtx.getProcessTemplateID();
        long piid = pCtx.getProcessInstanceID();
        HashMap<String, Object> selectors = new HashMap<String, Object>(5);
        selectors.put("TYPE", "BLWEBSERVICEMDB");
        selectors.put("PROCESSTEMPLATEID", ptid);
        selectors.put("PROCESSINSTANCEID", piid);
        selectors.put("WORKSTEPID", wsid);
        BLConstants.ClusterConstants cfr_ignored_0 = BLControl.consts.cluster;
        BLConstants.ClusterConstants cfr_ignored_1 = BLControl.consts.cluster;
        selectors.put("REPEAT_MSG_COUNT", 1);
        try {
            BLJMSService.self().sendMessage("blwebservicequeue", (Object)"", 1, selectors);
            if (BLControl.util.DEBUG_ENGINE) {
                this.printDebug(pCtx, wsid);
            }
        }
        catch (Exception ex) {
            String piName = pCtx.getProcessInstanceName();
            String wsName = pCtx.getWorkStepInstanceName(wsid);
            throw new BizLogicException("BizLogic_ERR_3103", "WFWebServiceInstance.execute()", new Object[]{piName, wsName}, (Throwable)ex);
        }
    }

    public boolean processMessage(Message msg) {
        BLConstants.single();
        return this.processMessage(msg, "blwebservicequeue", true);
    }

    private final void printDebug(WFProcessContext pCtx, long wsid) {
        StringBuilder buf = new StringBuilder("Sent a JMS message to activate a ");
        buf.append("webservice WS:").append(pCtx.getWorkStepInstanceName(wsid));
        buf.append(" of PI:").append(pCtx.getProcessInstanceName());
        BLControl.logger.debug((Object)buf.toString());
    }

    @Override
    public void complete(WFProcessContext pCtx, long wsid) {
        this.validateCompletion(pCtx, wsid);
        long piid = pCtx.getProcessInstanceID();
        if (!ProcessInstanceDAO.isProcessInstanceExist(piid)) {
            BLControl.logger.errorKey("BizLogic_ERR_862", new Object[]{piid, "webservice", wsid});
            return;
        }
        super.complete(pCtx, wsid);
        long wsstate = pCtx.getWorkstepInstanceEB(wsid).getState();
        if (wsstate != 21L) {
            return;
        }
        BLUtil.fireEvent(this.getEventContext(pCtx, wsid, 21), (int)21);
        super.afterComplete(pCtx, wsid);
        if (!this.isSuspendedByCompensatory(pCtx, wsid)) {
            this.activateNextWorksteps(pCtx, wsid);
        }
    }

    public boolean isWorkstepReady(HashMap<String, Object> message) {
        try {
            long piid = (Long)message.get("PROCESSINSTANCEID");
            long wsid = (Long)message.get("WORKSTEPID");
            if (this.workstepReady(piid, wsid)) {
                return true;
            }
            this.rePublishMsg("BLWEBSERVICEMDB", "blwebservicequeue", message);
        }
        finally {
            return false;
        }
    }
}

