/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.email.EmailComposer;
import com.savvion.sbm.bizlogic.enums.BLLockContext;
import com.savvion.sbm.bizlogic.messaging.dao.BLMessagesDAO;
import com.savvion.sbm.bizlogic.server.BLBusinessObjectService;
import com.savvion.sbm.bizlogic.server.DebugService;
import com.savvion.sbm.bizlogic.server.JSTools;
import com.savvion.sbm.bizlogic.server.WFAtomicInstance;
import com.savvion.sbm.bizlogic.server.WFAtomicWS;
import com.savvion.sbm.bizlogic.server.WFBlockEndInstance;
import com.savvion.sbm.bizlogic.server.WFBlockStartInstance;
import com.savvion.sbm.bizlogic.server.WFConnectorInstance;
import com.savvion.sbm.bizlogic.server.WFDataSlotInstance;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFDelayInstance;
import com.savvion.sbm.bizlogic.server.WFExternalInstance;
import com.savvion.sbm.bizlogic.server.WFExternalWS;
import com.savvion.sbm.bizlogic.server.WFInlineBlockInstance;
import com.savvion.sbm.bizlogic.server.WFJavaScript;
import com.savvion.sbm.bizlogic.server.WFLink;
import com.savvion.sbm.bizlogic.server.WFMessagePublisherInstance;
import com.savvion.sbm.bizlogic.server.WFMessageSubscriberInstance;
import com.savvion.sbm.bizlogic.server.WFNestedInstance;
import com.savvion.sbm.bizlogic.server.WFNestedWS;
import com.savvion.sbm.bizlogic.server.WFPreCondition;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFProcessInstance;
import com.savvion.sbm.bizlogic.server.WFWebServiceInstance;
import com.savvion.sbm.bizlogic.server.WFWorkItem;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.dao.BLLockDAO;
import com.savvion.sbm.bizlogic.server.dao.DataSlotDAO;
import com.savvion.sbm.bizlogic.server.dao.TimerActionDAO;
import com.savvion.sbm.bizlogic.server.dao.WaitWorkStepDAO;
import com.savvion.sbm.bizlogic.server.dao.WorkItemDAO;
import com.savvion.sbm.bizlogic.server.dao.WorkStepInstanceDAO;
import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceEBLocal;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceEBLocal;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceEBLocalHome;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstancePK;
import com.savvion.sbm.bizlogic.server.svo.DateTime;
import com.savvion.sbm.bizlogic.server.svo.DocumentDS;
import com.savvion.sbm.bizlogic.server.svo.MessageSubscription;
import com.savvion.sbm.bizlogic.server.svo.MessageSubscriptionList;
import com.savvion.sbm.bizlogic.smp.MPService;
import com.savvion.sbm.bizlogic.smp.core.EventProcessor;
import com.savvion.sbm.bizlogic.smp.model.BLExternalEvent;
import com.savvion.sbm.bizlogic.smp.util.InvalidEventDataException;
import com.savvion.sbm.bizlogic.smp.util.InvalidProcessStateException;
import com.savvion.sbm.bizlogic.smp.util.MPUtil;
import com.savvion.sbm.bizlogic.smp.util.SMPConfig;
import com.savvion.sbm.bizlogic.util.BLAlertService;
import com.savvion.sbm.bizlogic.util.BLCalendar;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDocService;
import com.savvion.sbm.bizlogic.util.BLJMSService;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BOExpression;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.DAOContext;
import com.savvion.sbm.bizlogic.util.ProcessContext;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.util.BMBootProps;
import com.savvion.sbm.util.CacheManager;
import com.savvion.sbm.util.ResultData;
import com.savvion.sbm.util.SBMConstants;
import com.savvion.sbm.util.SBMContext;
import com.savvion.sbm.util.SBMControl;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.callback.ProcessCallback;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.jms.Destination;
import javax.jms.Message;

public class WFWorkstepInstance {
    private static final String ACTIVATE_NEXT_WORKSTEPS = "WFWorkstepInstance.activateNextWorksteps";
    private static final String BIZ_LOGIC_ERR_2562 = "BizLogic_ERR_2562";
    private static final String COLON = ":";
    private static final String BIZ_LOGIC_ERR_4107 = "BizLogic_ERR_4107";
    private static final String RUN_IT_METHOD = "WFWorkstepInstance.runIt()";
    private static final String BIZ_LOGIC_ERR_3242 = "BizLogic_ERR_3242";
    private static final String BIZ_LOGIC = "BIZLOGIC";
    private static final String BIZ_LOGIC_ERR_3519 = "BizLogic_ERR_3519";
    private static final String RUN_IT_MESSAGE = "WFWorkstepInstance.runIt";
    private static final String ACTION_NAME_ACTIVE_TIMEOUT_FLOW = "ActionName:ACTIVATETIMEOUTFLOW";
    private static final String BIZ_LOGIC_ERR_3520 = "BizLogic_ERR_3520";
    private static final String BIZ_LOGIC_ERR_2684 = "BizLogic_ERR_2684";
    private static final String BIZ_LOGIC_ERR_020 = "BizLogic_ERR_020";
    private static final String BIZ_LOGIC_ERR_8001 = "BizLogic_ERR_8001";
    private static final String PRE_COND_EVALUATED = "Pre-cond evaluated for <";
    private static final String GT_SIGN = ">";
    private static final String EXECUTION_DONE_FOR = "Execution done for <";
    private static final String BIZ_LOGIC_ERR_4724 = "BizLogic_ERR_4724";
    private static final String BIZ_LOGIC_ERR_3562 = "BizLogic_ERR_3562";
    private static final String BIZ_LOGIC_ERR_931 = "BizLogic_ERR_931";
    private static final String COMPENSATORY_FLAG_INITIALIZED_FOR = "Compensatory flag initialized for <";
    private static final String PRE_JAVASCRIPT_EXECUTED_FOR = "PreJavaScript executed for <";
    private static final String BIZ_LOGIC_ERR_3160 = "BizLogic_ERR_3160";
    private static final String W_ACTIVATED = "W_ACTIVATED";
    private static final String BIZ_LOGIC_ERR_3691 = "BizLogic_ERR_3691";
    private static final String BIZ_LOGIC_ERR_4303 = "BizLogic_ERR_4303";
    private static WFWorkstepInstance single = null;
    public static final int WS_START = 100;
    public static final int WS_END = 101;
    public static final int WS_ATOMIC = 102;
    public static final int WS_PARALLEL = 103;
    public static final int WS_ANDJOIN = 104;
    public static final int WS_ORJOIN = 105;
    public static final int WS_DECISION = 106;
    public static final int WS_EXTERNAL = 107;
    public static final int WS_NESTED = 108;
    public static final int WS_WEBSERVICE = 109;
    public static final int WS_MESSAGESUBSCRIBER = 110;
    public static final int WS_MESSAGEPUBLISHER = 111;
    public static final int WS_DELAY = 112;
    public static final int WS_XORJOIN = 113;
    public static final int WS_INLINE_BLOCK = 114;
    public static final int WS_BLOCK_START = 115;
    public static final int WS_BLOCK_END = 116;
    public static final int PROCESSES_EXT_SERVICES = 200;

    public static WFWorkstepInstance getWorkstepInstance(int wsType) {
        switch (wsType) {
            case 100: 
            case 101: 
            case 102: {
                return WFAtomicInstance.self();
            }
            case 107: {
                return WFExternalInstance.self();
            }
            case 108: {
                return WFNestedInstance.self();
            }
            case 109: {
                return WFWebServiceInstance.self();
            }
            case 110: {
                return WFMessageSubscriberInstance.self();
            }
            case 111: {
                return WFMessagePublisherInstance.self();
            }
            case 112: {
                return WFDelayInstance.self();
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 113: {
                return WFConnectorInstance.self();
            }
            case 114: {
                return WFInlineBlockInstance.self();
            }
            case 115: {
                return WFBlockStartInstance.self();
            }
            case 116: {
                return WFBlockEndInstance.self();
            }
        }
        return null;
    }

    protected WFWorkstepInstance() {
    }

    public static WFWorkstepInstance single() {
        if (single == null) {
            single = new WFWorkstepInstance();
        }
        return single;
    }

    public synchronized WorkStepInstanceEBLocal createInstanceSync(WFProcessContext pCtx, long wsid) {
        return this.create(pCtx, wsid);
    }

    public WorkStepInstanceEBLocal createInstance(WFProcessContext pCtx, long wsid) {
        if (BLUtil.self().isSyncCreateWS()) {
            if (BLUtil.self().DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_9201", new Object[]{pCtx.getProcessInstanceID(), wsid});
            }
            return this.createInstanceSync(pCtx, wsid);
        }
        if (BLUtil.self().DEBUG_ENGINE) {
            BLControl.logger.debugKey("BizLogic_ERR_9202", new Object[]{pCtx.getProcessInstanceID(), wsid});
        }
        return this.create(pCtx, wsid);
    }

    public WorkStepInstanceEBLocal create(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = null;
        WorkStepInstanceEBLocalHome wsiebh = null;
        ProcessInstanceEBLocal pieb = pCtx.getProcessInstanceEB();
        HashMap<String, Object> hm = new HashMap<String, Object>();
        WFWorkstep ws = pCtx.getWorkstep(wsid);
        try {
            String perf = ws.getPerformer();
            if (perf != null && perf.length() > BLControl.util.MAX_PERFORMER_SIZE) {
                throw new BizLogicException("BizLogic_ERR_666", "WFWorkStepInstance:createInstance", new Object[]{perf, ws.getName(), pCtx.getProcessInstanceName(), String.valueOf(BLControl.util.MAX_PERFORMER_SIZE)});
            }
            hm.put("WORKSTEPID", wsid);
            hm.put("PROCESSINSTANCEID", pCtx.getProcessInstanceID());
            hm.put("PROCESSTEMPLATEID", pCtx.getProcessTemplateID());
            hm.put("TYPE", ws.getType());
            int priority = this.getRealPriority(pCtx, wsid);
            if (!SBMControl.util.isValidPriority(priority)) {
                priority = pieb.getPriority();
            }
            hm.put("PRIORITY", priority);
            hm.put("STATUS", 15);
            hm.put("WORKSTEPNAME", ws.getName());
            hm.put("CREATOR", null);
            hm.put("PERFORMER", ws.getPerformer());
            hm.put("INSTRUCTION", this.getRealInstruction(pCtx, wsid));
            if (ws.isWithinInlineBlock()) {
                hm.put("INLINEBLOCK_NAME", ws.getInlineBlockName());
            }
            if (ws.isMilestone()) {
                hm.put("MILESTONE_NAME", ws.getMilestoneName());
                hm.put("MILESTONE_DESC", ws.getMilestoneDescription());
            }
            hm.put("MONITOR_STEP", ws.isMonitorStep());
            wsiebh = BLUtil.self().getWorkStepInstanceEBHome();
            wsieb = wsiebh.create(hm);
            pCtx.cacheIt(wsid, wsieb);
        }
        catch (BizLogicException be) {
            throw be;
        }
        catch (RuntimeException re) {
            throw new BizLogicException("BizLogic_ERR_2606", "WFWorkstepInstance.createInstance", new Object[]{ws.getName(), pCtx.getProcessInstanceName()}, (Throwable)re);
        }
        catch (Throwable thr) {
            try {
                WorkStepInstanceEBLocalHome home = (WorkStepInstanceEBLocalHome)SBMControl.homeFactory.lookupLocalHome(WorkStepInstanceEBLocalHome.class);
                wsieb = home.findByPrimaryKey(new WorkStepInstancePK(pCtx.getProcessInstanceID(), wsid));
            }
            catch (BizLogicException be) {
                throw be;
            }
            catch (Throwable th) {
                throw new BizLogicException("BizLogic_ERR_2606", "WFWorkstepInstance.createInstance", new Object[]{pCtx.getWorkstep(wsid).getName(), pCtx.getProcessInstanceName()}, th);
            }
        }
        return wsieb;
    }

    public void terminate(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        wsieb.setSuspendState(0);
        wsieb.setTimeCompleted(System.currentTimeMillis());
        wsieb.setState(19);
        WFWorkstep ws = pCtx.getWorkstep(wsid);
        if (ws.isCheckDue()) {
            TimerActionDAO.removeByWorkStepInstance(pCtx.getProcessInstanceID(), wsid);
        }
        this.forceSave(pCtx, wsieb);
        BLUtil.fireEvent(this.getEventContext(pCtx, wsid, 19), (int)19);
        if (pCtx.isDebug()) {
            DebugService.self().removeDebugWSEntry(pCtx, wsid, 1);
        }
    }

    public void complete(WFProcessContext pCtx, long wsid) {
        if (this.isCompleted(pCtx, wsid)) {
            throw new BizLogicException("BizLogic_ERR_863", "WFWorkstepInstance.complete", new Object[]{pCtx.getWorkstep(wsid).getName(), pCtx.getProcessInstanceName()});
        }
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        WFWorkstep ws = pCtx.getWorkstep(wsid);
        if (ws.isSubProcess() && ((WFNestedWS)ws).isSynchronous() && !pCtx.isCompleteCaller()) {
            if (9 != wsieb.getSuspendState()) {
                if (8 != wsieb.getSuspendState()) {
                    if (4 != wsieb.getSuspendState()) {
                        throw new BizLogicException("BizLogic_ERR_8081", "WFWorkstepInstance.complete", new Object[]{pCtx.getWorkstep(wsid).getName(), pCtx.getProcessInstanceName()});
                    }
                }
            }
        }
        if (!wsieb.isSuspendedByCompensatory()) {
            if (wsieb.getState() == 16) {
                return;
            }
        }
        if (wsieb.getSuspendState() != 9) {
            try {
                this.executeScript(pCtx, wsid, "POST");
            }
            catch (BizLogicException ex) {
                wsieb.setSuspendState(4);
                this.suspend(pCtx, wsid, true, ex, null);
                return;
            }
            this.incrementLoopConditionCounter(pCtx, ws);
        }
        wsieb.setSuspendState(0);
        if (wsieb.getTimeCompleted() <= 0L) {
            wsieb.setTimeCompleted(new Date().getTime());
        }
        wsieb.setState(21);
        if (ws.isMonitorStep()) {
            if (wsieb.getPerformer() == null || wsieb.getPerformer().trim().length() == 0) {
                this.setDefaultPerformer(pCtx, wsid);
            }
            if (ws.getDuration() == wsieb.getDuration() && wsieb.getTimeCompleted() > wsieb.getTimeStarted()) {
                wsieb.setDuration((wsieb.getTimeCompleted() - wsieb.getTimeStarted()) / 1000L);
            }
        }
        boolean executionStatus = false;
        if (ws.hasLoopCondition() && !(executionStatus = this.executeLoopCondition(pCtx, ws))) {
            return;
        }
        if (pCtx.getWorkstep(wsid).isCheckDue() || pCtx.getWorkstep(wsid).isDelayActivation()) {
            TimerActionDAO.removeByWorkStepInstance(pCtx.getProcessInstanceID(), wsid);
        }
        try {
            BLConstants.single();
            if (ws.hasAlerts(21)) {
                BLAlertService bLAlertService = BLAlertService.single();
                BLConstants.single();
                List alertsPublished = bLAlertService.publishAlerts(pCtx, wsid, ws.getAlertNames(21));
                if (BLControl.util.DEBUG_ALERTS) {
                    BLControl.logger.debugKey(BIZ_LOGIC_ERR_3160, "WFWorkstepInstance.complete", new Object[]{pCtx.getProcessInstanceName(), pCtx.getWorkstep(wsid).getName(), "W_COMPLETED", alertsPublished});
                }
            }
        }
        catch (Exception e) {
            BLControl.logger.errorKey(BIZ_LOGIC_ERR_3691, new Object[]{pCtx.getProcessInstanceName(), pCtx.getWorkstep(wsid).getName(), "W_COMPLETED"}, (Throwable)e);
        }
        this.forceSave(pCtx, wsieb);
        long lockWSID = -1L;
        if (BLControl.util.getLockLevel() > 1 && (lockWSID = ws.getNextAndJoinWSID()) > 0L) {
            if (BLControl.util.getLockLevel() == 4) {
                this.getWSInstance(pCtx, lockWSID);
            }
        }
        if (pCtx.isDebug()) {
            DebugService.self().removeDebugWSEntry(pCtx, wsid, 1);
        }
        if (BLControl.util.isCallback()) {
            if (ProcessCallback.hasCallback((int)21, (String)pCtx.getProcessTemplateName(), (String)pCtx.getProcess().getAppName())) {
                ProcessContext prcctx = BLUtil.getProcessContext((WFProcessContext)pCtx, (String)ws.getName(), (JSTools)new JSTools(pCtx, ws.getName()));
                ProcessCallback.execute((int)21, (SBMContext)prcctx, (boolean)true);
            }
        }
    }

    public void afterComplete(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debug((Object)"WFWorkstepInstance.afterComplete(): Setting Milestone name and Milestone description to empty string.");
        }
        pCtx.clearDueDateSetForWs(wsid);
    }

    public void activateNextWorksteps(WFProcessContext pCtx, long wsid) {
        WFWorkstep thisWS = pCtx.getWorkstep(wsid);
        if (thisWS.isFinishWorkstep()) {
            return;
        }
        String ptName = pCtx.getProcess().getName();
        String wsName = thisWS.getName();
        long piid = pCtx.getProcessInstanceID();
        pCtx.getWorkstepInstanceEB(wsid);
        if (BLControl.util.DEBUG_ENGINE) {
            // empty if block
        }
        List<WFWorkstep> wfWorkstepList = this.getAllWorkStepsForActivation(pCtx, wsid, thisWS, ptName, wsName);
        for (WFWorkstep wfWorkstep : wfWorkstepList) {
            if (pCtx.isPICompleted()) {
                BLControl.logger.warnKey("BizLogic_ERR_4524", ACTIVATE_NEXT_WORKSTEPS, new Object[]{piid, wsName});
                return;
            }
            String nwsName = wfWorkstep.getName();
            int nwsType = wfWorkstep.getType();
            long nwsID = wfWorkstep.getID();
            if (pCtx.isDebug() && !DebugService.self().isDebugAllowed(pCtx, thisWS, wfWorkstep)) continue;
            this.getWSInstance(pCtx, nwsID);
            if (this.isActivationWaitState(pCtx, nwsID) || this.isPreConditionWaitState(pCtx, nwsID) || this.isMessageWaitState(pCtx, nwsID) || this.isEventActivationWaitState(pCtx, nwsID)) {
                WorkStepInstanceEBLocal nwsieb = pCtx.getWorkstepInstanceEB(nwsID);
                BLControl.logger.infoKey("BizLogic_ERR_935", ACTIVATE_NEXT_WORKSTEPS, new Object[]{wsName, nwsName, piid, ptName, BLConstants.single().wfStates[nwsieb.getState()]});
                continue;
            }
            this.activateWfWorkstep(pCtx, wsid, piid, nwsType, nwsID);
        }
    }

    private void activateWfWorkstep(WFProcessContext pCtx, long wsid, long piid, int nwsType, long nwsId) {
        if (113 == nwsType) {
            pCtx.getXORHelper().setActivatorWsId(wsid);
        }
        if (this.isSuspendedByCompensatory(pCtx, nwsId)) {
            pCtx.activateWorkstep(nwsId);
        } else if (104 == nwsType) {
            if (!this.isActivated(pCtx, nwsId)) {
                this.setExpectArrivals(pCtx, nwsId, wsid);
            } else {
                this.removeFromExpectArrivals(pCtx, nwsId, wsid);
            }
            pCtx.activateWorkstep(nwsId);
        } else if (!this.isActivated(pCtx, nwsId)) {
            pCtx.activateWorkstep(nwsId);
        } else {
            BLControl.logger.warnKey("BizLogic_ERR_1013", ACTIVATE_NEXT_WORKSTEPS, (Throwable)new RuntimeException("Call Stack:"), new Object[]{piid, pCtx.getWorkstep(nwsId).getName()});
        }
    }

    private List<WFWorkstep> getAllWorkStepsForActivation(WFProcessContext pCtx, long wsid, WFWorkstep thisWS, String ptName, String wsName) {
        AbstractList wfWorksteps;
        if (!pCtx.isWorkstepSkipped(wsid) && pCtx.isWSActivationInLoop(wsid)) {
            wfWorksteps = new ArrayList();
            wfWorksteps.add(thisWS);
        } else {
            wfWorksteps = this.getNextWorksteps(pCtx, wsid);
        }
        if (wfWorksteps == null || wfWorksteps.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_569", ACTIVATE_NEXT_WORKSTEPS, (Object[])new String[]{ptName, wsName});
        }
        return wfWorksteps;
    }

    public void setExpectArrivals(WFProcessContext pCtx, long wsid, long previd) {
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debug((Object)("setExpectArrivals:wsid=" + wsid + ", previd=" + previd));
        }
        Vector links = pCtx.getWorkstep(wsid).getInConnections();
        StringBuffer linkNames = new StringBuffer(100);
        boolean isFirst = true;
        for (int i = 0; i < links.size(); ++i) {
            WFLink l = (WFLink)links.elementAt(i);
            long sWSid = l.getSource().getID();
            if (sWSid == previd) continue;
            if (isFirst) {
                linkNames.append(sWSid);
                isFirst = false;
                continue;
            }
            linkNames.append(",").append(sWSid);
        }
        WorkStepInstanceEBLocal wiseb = pCtx.getWorkstepInstanceEB(wsid);
        this.setExpectArrivals(wiseb, linkNames.toString());
        pCtx.addAndWSInSameTx(wsid);
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debug((Object)("setExpectArrivals to: " + linkNames.toString()));
        }
    }

    public String getExpectArivals(WFProcessContext pCtx, long wsid) {
        if (pCtx.isAndActivatedInSameTx(wsid)) {
            return pCtx.getWorkstepInstanceEB(wsid).getExpectArrivals();
        }
        String earrivals = WorkStepInstanceDAO.getExpectArrivals(pCtx.getProcessInstanceID(), wsid);
        if (earrivals == null || earrivals.trim().isEmpty()) {
            earrivals = pCtx.getWorkstepInstanceEB(wsid).getExpectArrivals();
        }
        return earrivals;
    }

    public void removeFromExpectArrivals(WFProcessContext pCtx, long wsid, long previd) {
        WorkStepInstanceEBLocal wiseb = pCtx.getWorkstepInstanceEB(wsid);
        String linkids = this.getExpectArivals(pCtx, wsid);
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.info((Object)("remExpArrival-begin:piid=" + pCtx.getProcessInstanceID() + ", wsid=" + wsid + ", previd=" + previd + " wstocomplete:" + linkids + ", session-id:" + pCtx.getSession() + ", " + Thread.currentThread().getName()));
        }
        StringTokenizer tok = new StringTokenizer(linkids, ",");
        Vector<String> v = new Vector<String>();
        while (tok.hasMoreTokens()) {
            v.addElement(tok.nextToken());
        }
        v.removeElement(Long.valueOf(previd).toString());
        boolean isFirst = true;
        StringBuilder linkNames = new StringBuilder(100);
        for (int i = 0; i < v.size(); ++i) {
            if (isFirst) {
                linkNames.append(v.elementAt(i));
                isFirst = false;
                continue;
            }
            linkNames.append(",").append(v.elementAt(i));
        }
        this.setExpectArrivals(wiseb, linkNames.toString());
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.info((Object)("remExpArrival-end:piid=" + pCtx.getProcessInstanceID() + ", wsid=" + wsid + ", previd=" + previd + " wstocomplete:" + linkNames.toString() + ", session-id:" + pCtx.getSession() + ", " + Thread.currentThread().getName()));
        }
    }

    public boolean isEmptyExpectArrivals(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wiseb = pCtx.getWorkstepInstanceEB(wsid);
        String linkNames = wiseb.getExpectArrivals();
        return linkNames == null || linkNames.length() == 0;
    }

    private void setExpectArrivals(WorkStepInstanceEBLocal wiseb, String linkids) {
        wiseb.setExpectArrivals(linkids);
        if (SBMControl.dbmap.isOracle() || BLControl.util.isAndWSForceSave()) {
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_1202", new Object[]{wiseb.getId(), wiseb.getProcessInstanceID()});
            }
            wiseb.save();
        }
    }

    public void activate(WFProcessContext pCtx, long wsid) {
        if (pCtx.getWorkstep(wsid).isMonitorStep()) {
            if (this.isSuspended(pCtx, wsid)) {
                if (pCtx.getWorkstepInstanceEB(wsid).getSuspendState() != 2) {
                    this.resumeMonitorStep(pCtx, wsid);
                    return;
                }
            } else if (91 == pCtx.getWorkstepInstanceEB(wsid).getState()) {
                this.activateMonitorStep(pCtx, wsid);
                return;
            }
        }
        if (!pCtx.getProcess().getRollbackPoints().isEmpty()) {
            this.addNodeVisited(pCtx, Long.valueOf(wsid).toString());
        }
        WorkStepInstanceEBLocal wsieb = this.getWSInstance(pCtx, wsid);
        this.runIt(pCtx, wsid);
        int n = pCtx.getWorkstep(wsid).getType();
        BLConstants.single();
        if (n == 102 && pCtx.isXORHelperExist() && pCtx.getXORHelper().isMarkedForTermination(wsid)) {
            this.terminatePreWsToXOR(pCtx, wsid);
        }
        if (pCtx.getWorkstep(wsid).isMonitorStep()) {
            if (SMPConfig.self().isProcessExtEventFromBL()) {
                int n2 = wsieb.getState();
                BLConstants.single();
                if (n2 == 91) {
                    this.processExtEvents(pCtx, wsid);
                } else {
                    BLControl.logger.warnKey("BizLogic_ERR_8076", "WFWorkstepInstance.activate()", new Object[]{pCtx.getWorkstep(wsid).getName(), pCtx.getProcessTemplateName(), wsid, pCtx.getProcessInstanceID(), wsieb.getState()});
                }
            } else {
                this.createWaitEvent(pCtx, wsid, pCtx.getWorkstep(wsid).isWaitForActivateEvent());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExtEvents(WFProcessContext pCtx, long wsid) {
        pCtx.setExtEventsProcessedFromBL(true);
        WFWorkstep workstep = pCtx.getWorkstep(wsid);
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        List<BLExternalEvent> events = null;
        BLExternalEvent externalEvent = null;
        EventProcessor eventProcessor = EventProcessor.self();
        try {
            events = MPUtil.getEventsForWorkstep(pCtx.getMonitorDSValue(), pCtx.getProcessTemplateName(), workstep.getName(), wsieb.getLoopCounter());
        }
        catch (Throwable e) {
            BLControl.logger.errorKey("BizLogic_ERR_8073", "WFWorkstepInstance.processExtEvents()", e, new Object[]{workstep.getName(), pCtx.getProcessTemplateName(), pCtx.getProcessInstanceID(), wsieb.getLoopCounter()});
        }
        try {
            events = this.removeDuplicateEvents(events);
            if (BLControl.logger.isDebugEnabled()) {
                BLControl.logger.debugKey("BizLogic_ERR_8077", "WFWorkstepInstance.processExtEvents()", new Object[]{events != null ? events.size() : 0, workstep.getName(), pCtx.getProcessTemplateName(), pCtx.getProcessInstanceID()});
            }
            if (null == events || events.isEmpty()) {
                this.createWaitEvent(pCtx, wsid, workstep.isWaitForActivateEvent());
            } else if (events.size() == 1) {
                externalEvent = events.get(0);
                if (externalEvent.getOperationType().isCompleteWorkstep()) {
                    if (workstep.isWaitForActivateEvent()) {
                        this.createWaitEvent(pCtx, wsid, workstep.isWaitForActivateEvent());
                    } else {
                        eventProcessor.processExtEventFromBL(externalEvent, pCtx);
                    }
                } else {
                    eventProcessor.processExtEventFromBL(externalEvent, pCtx);
                    this.createWaitEvent(pCtx, wsid, false);
                }
            } else {
                Iterator<BLExternalEvent> e = events.iterator();
                while (e.hasNext()) {
                    BLExternalEvent currentEvent;
                    externalEvent = currentEvent = e.next();
                    eventProcessor.processExtEventFromBL(currentEvent, pCtx);
                }
            }
        }
        catch (InvalidEventDataException e) {
            try {
                MPUtil.handleInvalidEvent(externalEvent, e.getMessage());
                boolean isWaitForActivate = this.isWaitForActivate(workstep, externalEvent);
                this.createWaitEvent(pCtx, wsid, isWaitForActivate);
            }
            catch (Throwable t) {
                BLControl.logger.errorKey("BizLogic_ERR_8074", "WFWorkstepInstance.processExtEvents()", t, new Object[]{MPUtil.getEventCtx(externalEvent), wsieb.getLoopCounter()});
                wsieb.setSuspendState(3);
                this.suspend(pCtx, wsid, false, t, null);
            }
        }
        catch (InvalidProcessStateException e) {
            try {
                boolean isWaitForActivate = this.isWaitForActivate(workstep, externalEvent);
                this.createWaitEvent(pCtx, wsid, isWaitForActivate);
            }
            catch (Throwable t) {
                BLControl.logger.errorKey("BizLogic_ERR_8074", "WFWorkstepInstance.processExtEvents()", t, new Object[]{MPUtil.getEventCtx(externalEvent), wsieb.getLoopCounter()});
                wsieb.setSuspendState(3);
                this.suspend(pCtx, wsid, false, t, null);
            }
        }
        catch (Throwable e) {
            BLControl.logger.errorKey("BizLogic_ERR_8075", "WFWorkstepInstance.processExtEvents()", e, new Object[]{MPUtil.getEventCtx(externalEvent), wsieb.getLoopCounter()});
            try {
                boolean isWaitForActivate = this.isWaitForActivate(workstep, externalEvent);
                this.createWaitEvent(pCtx, wsid, isWaitForActivate);
            }
            catch (Throwable t) {
                BLControl.logger.errorKey("BizLogic_ERR_8074", "WFWorkstepInstance.processExtEvents()", t, new Object[]{MPUtil.getEventCtx(externalEvent), wsieb.getLoopCounter()});
            }
            wsieb.setSuspendState(3);
            this.suspend(pCtx, wsid, false, e, null);
        }
        finally {
            pCtx.setExtEventsProcessedFromBL(false);
        }
    }

    private boolean isWaitForActivate(WFWorkstep workstep, BLExternalEvent externalEvent) {
        if (externalEvent.getOperationType().isCompleteWorkstep()) {
            return false;
        }
        return workstep.isWaitForActivateEvent();
    }

    private List<BLExternalEvent> removeDuplicateEvents(List<BLExternalEvent> events) {
        if (null == events || events.isEmpty()) {
            return null;
        }
        ArrayList<BLExternalEvent> externalEvents = new ArrayList<BLExternalEvent>();
        BLExternalEvent activateEvent = null;
        BLExternalEvent completeEvent = null;
        for (BLExternalEvent blExternalEvent : events) {
            if (null == blExternalEvent) continue;
            if (blExternalEvent.getOperationType().isActivateWorkstep()) {
                activateEvent = blExternalEvent;
                continue;
            }
            completeEvent = blExternalEvent;
        }
        if (null != activateEvent) {
            externalEvents.add(activateEvent);
        }
        if (null != completeEvent) {
            externalEvents.add(completeEvent);
        }
        return externalEvents;
    }

    public void activateMonitorStep(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        WFWorkstep ws = pCtx.getWorkstep(wsid);
        if (wsieb.getState() != 91) {
            throw new BizLogicException("BizLogic_ERR_4819", "WFWorkstepInstance.activateMonitorStep", (Object[])new String[]{pCtx.getProcessInstanceName(), ws.getName(), BLConstants.single().wfStates[wsieb.getState()]});
        }
        wsieb.setState(18);
        if (ws.isWaitForActivateEvent() && !pCtx.isExtEventsProcessedFromBL()) {
            MPService.self().getPersistenceService().updateWaitForActivationFlag(pCtx.getProcessInstanceID(), wsid, wsieb.getLoopCounter(), SBMConstants.Boolean.FALSE.intValue());
        }
        int eventType = 18;
        if (wsieb.getPerformer() == null || wsieb.getPerformer().trim().length() == 0) {
            this.setDefaultPerformer(pCtx, wsid);
        }
        if (ws.hasOverDueActions()) {
            TimerActionDAO.updateDueDate(wsieb.getProcessInstanceID(), wsid, wsieb.getDuedate());
            if (BLControl.util.DEBUG_TIMERACTION) {
                BLControl.logger.debugKey("BizLogic_ERR_3952", "WFWorkstepInstance.activateMonitorStep", new Object[]{pCtx.getProcessInstanceName(), ws.getName(), new Date(wsieb.getDuedate())});
            }
        }
        try {
            BLConstants.single();
            if (eventType == 18) {
                BLConstants.single();
                if (ws.hasAlerts(18)) {
                    BLAlertService bLAlertService = BLAlertService.single();
                    BLConstants.single();
                    List alertsPublished = bLAlertService.publishAlerts(pCtx, wsid, ws.getAlertNames(18));
                    if (BLControl.util.DEBUG_ALERTS) {
                        BLControl.logger.debugKey(BIZ_LOGIC_ERR_3160, "WFWorkstepInstance.activateMonitorStep", new Object[]{pCtx.getProcessInstanceName(), ws.getName(), W_ACTIVATED, alertsPublished});
                    }
                }
            }
        }
        catch (Throwable th) {
            BLControl.logger.errorKey(BIZ_LOGIC_ERR_3691, new Object[]{pCtx.getProcessInstanceName(), ws.getName(), W_ACTIVATED}, th);
        }
        if (BLControl.util.DEBUG_ENGINE || BLControl.util.DEBUG_MONITORING) {
            BLControl.logger.debugKey("BizLogic_ERR_4304", "WFWorkstepInstance.activateMonitorStep", new Object[]{pCtx.getProcessInstanceID(), wsid});
        }
        if (eventType == 18 && BLControl.util.isCallback()) {
            if (ProcessCallback.hasCallback((int)18, (String)pCtx.getProcessTemplateName(), (String)pCtx.getProcess().getAppName())) {
                ProcessContext prcctx = BLUtil.getProcessContext((WFProcessContext)pCtx, (String)ws.getName(), (JSTools)new JSTools(pCtx, ws.getName()));
                ProcessCallback.execute((int)18, (SBMContext)prcctx, (boolean)true);
            }
        }
        BLUtil.fireEvent(this.getEventContext(pCtx, wsid, eventType), (int)eventType);
    }

    private void resumeMonitorStep(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        WFWorkstep ws = pCtx.getWorkstep(wsid);
        if (!this.isSuspended(pCtx, wsid)) {
            throw new BizLogicException("BizLogic_ERR_4692", "WFWorkstepInstance.resumeMonitorStep", (Object[])new String[]{pCtx.getProcessInstanceName(), ws.getName(), BLConstants.single().wfStates[wsieb.getState()]});
        }
        int eventType = wsieb.getPreviousState() == 91 ? 91 : 17;
        wsieb.setState(wsieb.getPreviousState());
        if (BLControl.util.DEBUG_ENGINE || BLControl.util.DEBUG_MONITORING) {
            Object[] objectArray = new Object[3];
            objectArray[0] = pCtx.getProcessInstanceID();
            objectArray[1] = ws.getName();
            objectArray[2] = BLControl.consts.wfStates[18];
            BLControl.logger.debugKey(BIZ_LOGIC_ERR_4303, "WFWorkstepInstance.resumeMonitorStep", objectArray);
        }
        BLUtil.fireEvent(this.getEventContext(pCtx, wsid, eventType), (int)eventType);
        if (SMPConfig.self().isProcessExtEventFromBL()) {
            if (wsieb.getState() == 91) {
                this.processExtEvents(pCtx, wsid);
            }
        }
    }

    private long getActivateAfter(WFProcessContext pCtx, WFWorkstep ws) {
        String afterDur = ws.getActivateAfter();
        long value = -1L;
        try {
            if (afterDur != null && BLUtil.isMappedDataSlot((String)afterDur)) {
                String[] dsName = new String[1];
                dsName[0] = afterDur.substring("@".length());
                HashMap dsValue = pCtx.getSlotValue(dsName);
                value = (Long)dsValue.get(dsName[0]);
            } else {
                try {
                    value = Long.parseLong(afterDur) * 1000L;
                }
                catch (NumberFormatException dsName) {}
            }
        }
        catch (Exception ex) {
            BLControl.logger.errorKey("BizLogic_ERR_805", new Object[]{afterDur, pCtx.getProcessInstanceID(), ws.getName()}, (Throwable)ex);
        }
        return value;
    }

    private long getActivateAt(WFProcessContext pCtx, WFWorkstep ws) {
        String atTime = ws.getActivateAt();
        long value = -1L;
        try {
            if (atTime != null && BLUtil.isMappedDataSlot((String)atTime)) {
                String[] dsName = new String[1];
                dsName[0] = atTime.substring("@".length());
                HashMap dsValue = pCtx.getSlotValue(dsName);
                value = ws.getDataslot(dsName[0]).isDate() ? ((DateTime)dsValue.get(dsName[0])).getTime() : ((Long)dsValue.get(dsName[0])).longValue();
            } else {
                try {
                    value = Long.parseLong(atTime) * 1000L;
                }
                catch (NumberFormatException dsName) {}
            }
        }
        catch (Exception ex) {
            BLControl.logger.errorKey("BizLogic_ERR_806", new Object[]{atTime, pCtx.getProcessInstanceID(), ws.getName()}, (Throwable)ex);
        }
        return value;
    }

    private boolean delayActivation(WFProcessContext pCtx, WFWorkstep ws, long wsid, WorkStepInstanceEBLocal wsieb) {
        long startTime = wsieb.getTimeStarted();
        long actTime = 0L;
        try {
            actTime = this.getActivateAfter(pCtx, ws);
            if (actTime > 0L) {
                actTime = startTime + actTime;
            } else {
                actTime = this.getActivateAt(pCtx, ws);
                if (actTime <= startTime) {
                    return false;
                }
            }
            if (actTime > 0L) {
                BLConstants.TAConstants cfr_ignored_0 = BLControl.consts.ta;
                TimerActionDAO.create(pCtx.getProcessInstanceID(), wsid, pCtx.getProcessTemplateID(), actTime, "ACTIVATE_WORKSTEP_INSTANCE", null, null, BIZ_LOGIC);
                wsieb.setState(61);
                wsieb.setTimeStarted(actTime);
                this.calculateDueDate(pCtx, wsieb, ws);
                BLUtil.fireEvent(this.getEventContext(pCtx, wsid, 61), (int)61);
                if (BLControl.util.DEBUG_ENGINE) {
                    BLControl.logger.debugKey("BizLogic_ERR_1006", new Object[]{pCtx.getProcessInstanceName(), ws.getName(), actTime});
                }
            }
        }
        catch (Exception ex) {
            BLControl.logger.errorKey("BizLogic_ERR_807", new Object[]{pCtx.getProcessInstanceName(), ws.getName(), actTime}, (Throwable)ex);
            wsieb.setSuspendState(7);
            this.suspend(pCtx, wsid, true, ex, null);
        }
        return true;
    }

    public void runIt(WFProcessContext context, long wsIdParam) {
        WorkStepInstanceEBLocal workStepInstanceEBLocal = context.getWorkstepInstanceEB(wsIdParam);
        WFWorkstep wfWorkstep = context.getWorkstep(wsIdParam);
        if (wfWorkstep.isAtomic() && BLUtil.isMappedDataSlot((String)wfWorkstep.getPerformer())) {
            workStepInstanceEBLocal.setPerformer(wfWorkstep.getPerformer());
        }
        WFWorkstepRunItParams wfWorkstepRunItParams = new WFWorkstepRunItParams(context, wfWorkstep);
        if (BLControl.util.DEBUG_ENGINE) {
            wfWorkstepRunItParams.wsID = wfWorkstepRunItParams.piName + COLON + wfWorkstepRunItParams.wsName;
        }
        if (this.isWorkStepInstanceEBLocalSuspended(workStepInstanceEBLocal, context, wsIdParam, wfWorkstepRunItParams)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        if (this.isSkipProcessingOfWorkstep(context, wsIdParam, workStepInstanceEBLocal, wfWorkstepRunItParams, wfWorkstep, startTime)) {
            return;
        }
        if (this.isDelayActivation(wfWorkstep, context, workStepInstanceEBLocal, wsIdParam, wfWorkstepRunItParams)) {
            return;
        }
        if (this.isMessageExecutionActivated(wfWorkstep, workStepInstanceEBLocal, context, wsIdParam)) {
            return;
        }
        this.assignStartTimeAndDueDate(context, wsIdParam, workStepInstanceEBLocal, wfWorkstepRunItParams, wfWorkstep, startTime);
        if (this.isProcessWsSuspendedAtPrecondition(wfWorkstep, context, wsIdParam, workStepInstanceEBLocal, wfWorkstepRunItParams)) {
            return;
        }
        if (this.isProcessSuspendOnPreJsFailure(context, workStepInstanceEBLocal, wsIdParam, wfWorkstepRunItParams)) {
            return;
        }
        if (this.isSuspendedByCompensatoryResumed(context, wsIdParam, wfWorkstepRunItParams, workStepInstanceEBLocal)) {
            return;
        }
        this.setInstruction(context, wsIdParam, workStepInstanceEBLocal);
        this.updateActualPerformer(context, wsIdParam, workStepInstanceEBLocal);
        if (this.isEventActivationForceSave(context, wsIdParam, wfWorkstep, workStepInstanceEBLocal)) {
            return;
        }
        workStepInstanceEBLocal.setSuspendState(5);
        this.processInlineBlockName(workStepInstanceEBLocal, wfWorkstep, context);
        this.startWorkstepExecution(wfWorkstep, context, wsIdParam, workStepInstanceEBLocal, wfWorkstepRunItParams);
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debug((Object)(EXECUTION_DONE_FOR + wfWorkstepRunItParams.wsID + GT_SIGN));
        }
    }

    private boolean isWorkStepInstanceEBLocalSuspended(WorkStepInstanceEBLocal workStepInstanceEBLocal, WFProcessContext context, long wsIdParam, WFWorkstepRunItParams wfWorkstepRunItParams) {
        if (this.isSuspended(context, wsIdParam)) {
            if (workStepInstanceEBLocal.getSuspendState() == 4) {
                if (this.isSuspendedByCompensatory(context, wsIdParam)) {
                    workStepInstanceEBLocal.setState(18);
                    this.setSuspendedByCompensatory(context, wsIdParam, false);
                }
                this.complete(context, wsIdParam);
                return true;
            }
            if (workStepInstanceEBLocal.getSuspendState() == 5 && !this.isSuspendedByCompensatory(context, wsIdParam)) {
                wfWorkstepRunItParams.wsID = wfWorkstepRunItParams.piName + COLON + wfWorkstepRunItParams.wsName;
                BLControl.logger.warnKey(BIZ_LOGIC_ERR_2562, new Object[]{wfWorkstepRunItParams.wsID});
                return true;
            }
        }
        return false;
    }

    private boolean isSkipProcessingOfWorkstep(WFProcessContext context, long wsIdParam, WorkStepInstanceEBLocal workStepInstanceEBLocal, WFWorkstepRunItParams wfWorkstepRunItParams, WFWorkstep wfWorkstep, long startTime) {
        if (this.isCreated(context, wsIdParam) || this.isCompleted(context, wsIdParam) || this.isTerminated(context, wsIdParam) || this.isSkipped(context, wsIdParam) || this.isSuspended(context, wsIdParam) && workStepInstanceEBLocal.getSuspendState() == 8) {
            if (!this.isSuspendedAtLoopCounter(context, wsIdParam)) {
                this.incrementLoopCounter(context, wsIdParam);
            }
            if (this.suspendOnMaxLoopCounter(context, wsIdParam)) {
                return true;
            }
            workStepInstanceEBLocal.setTimeStarted(startTime);
            workStepInstanceEBLocal.setTimeCompleted(0L);
            workStepInstanceEBLocal.setDuedate(startTime);
            if (this.isSkipWorkstepAndProcessNextWorksteps(context, wfWorkstepRunItParams, wfWorkstep, workStepInstanceEBLocal, wsIdParam, startTime)) {
                return true;
            }
        }
        return false;
    }

    private boolean isSkipWorkstepAndProcessNextWorksteps(WFProcessContext context, WFWorkstepRunItParams wfWorkstepRunItParams, WFWorkstep wfWorkstep, WorkStepInstanceEBLocal workStepInstanceEBLocal, long wsIdParam, long startTime) {
        boolean debugSkipWS;
        boolean bl = debugSkipWS = context.isDebug() && DebugService.self().isSkipWS(context.getProcessInstanceID(), wfWorkstepRunItParams.wsName);
        if (wfWorkstep.hasSkipCondition() || debugSkipWS) {
            boolean isValid;
            boolean bl2 = isValid = debugSkipWS || this.executeSkipCondition(context, wfWorkstep);
            if (isValid) {
                workStepInstanceEBLocal.setState(63);
                workStepInstanceEBLocal.setTimeCompleted(startTime);
                workStepInstanceEBLocal.setDuration(0L);
                Map<String, Object> eventContext = this.getEventContext(context, wsIdParam, 63);
                eventContext.put("ESTIMATEDDURATION", String.valueOf(this.getRealDuration(context, wfWorkstep)));
                BLUtil.fireEvent(eventContext, (int)63);
                WFWorkstepInstance.removeDebugWSEntry(context, wsIdParam);
                this.processNextWorksteps(context, wsIdParam);
                return true;
            }
        }
        return false;
    }

    private void assignStartTimeAndDueDate(WFProcessContext context, long wsIdParam, WorkStepInstanceEBLocal workStepInstanceEBLocal, WFWorkstepRunItParams wfWorkstepRunItParams, WFWorkstep wfWorkstep, long startTime) {
        if (this.isCreated(context, wsIdParam) || this.isCompleted(context, wsIdParam) || this.isActivationWaitState(context, wsIdParam) || this.isMessageWaitState(context, wsIdParam) || this.isTerminated(context, wsIdParam) || this.isSkipped(context, wsIdParam)) {
            workStepInstanceEBLocal.setTimeStarted(startTime);
            workStepInstanceEBLocal.setTimeCompleted(0L);
            long dueDate = this.calculateDueDate(context, workStepInstanceEBLocal, wfWorkstep);
            if (wfWorkstep.hasOverDueActions()) {
                TimerActionDAO.create(workStepInstanceEBLocal.getProcessInstanceID(), wsIdParam, workStepInstanceEBLocal.getProcessTemplateID(), dueDate, null, null, null, BIZ_LOGIC);
                WFWorkstepInstance.logTimerActionError(wfWorkstepRunItParams, dueDate, "");
            } else if (wfWorkstep.hasTimeoutFlow()) {
                TimerActionDAO.create(context.getProcessInstanceID(), wsIdParam, context.getProcessTemplateID(), dueDate, "ACTIVATE_TIMEOUT_FLOW", null, null, BIZ_LOGIC);
                WFWorkstepInstance.logTimerActionError(wfWorkstepRunItParams, dueDate, ACTION_NAME_ACTIVE_TIMEOUT_FLOW);
            }
            WFWorkstepInstance.setDataSlotCopies(wfWorkstep, workStepInstanceEBLocal, context);
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey(BIZ_LOGIC_ERR_3520, RUN_IT_MESSAGE, new Object[]{wfWorkstepRunItParams.piName, wfWorkstepRunItParams.wsName, new Date(dueDate)});
            }
        }
    }

    private boolean isProcessWsSuspendedAtPrecondition(WFWorkstep wfWorkstep, WFProcessContext context, long wsIdParam, WorkStepInstanceEBLocal workStepInstanceEBLocal, WFWorkstepRunItParams wfWorkstepRunItParams) {
        String precondition = wfWorkstep.getPreCondition();
        int preconditionType = wfWorkstep.getPreConditionType();
        if (!this.isActivated(context, wsIdParam) && precondition != null && workStepInstanceEBLocal.getSuspendState() <= 1) {
            boolean isValid = WFWorkstepInstance.isValidWorkstepCondition(context, wsIdParam, preconditionType, precondition, wfWorkstepRunItParams);
            if (!isValid) {
                this.processWsSuspendedAtPrecond(workStepInstanceEBLocal, context, wfWorkstep, wsIdParam);
                BLControl.logger.infoKey(BIZ_LOGIC_ERR_020, (Object[])new String[]{wfWorkstepRunItParams.piName, wfWorkstepRunItParams.wsName});
                return true;
            }
            WFWorkstepInstance.logValidPreConditionInfoMessage(wfWorkstepRunItParams);
        }
        return false;
    }

    private boolean isProcessSuspendOnPreJsFailure(WFProcessContext context, WorkStepInstanceEBLocal workStepInstanceEBLocal, long wsIdParam, WFWorkstepRunItParams wfWorkstepRunItParams) {
        if (!this.isActivated(context, wsIdParam)) {
            if (workStepInstanceEBLocal.getSuspendState() <= 2) {
                try {
                    context.cacheDueDateBefPreScript(wsIdParam, workStepInstanceEBLocal.getDuedate());
                    this.executeScript(context, wsIdParam, "PRE");
                }
                catch (RuntimeException ex) {
                    this.suspendOnPreJsFailure(ex, wfWorkstepRunItParams, workStepInstanceEBLocal, context, wsIdParam);
                    return true;
                }
            }
            WFWorkstepInstance.logPreJavascriptExecuted(wfWorkstepRunItParams.wsID);
        }
        return false;
    }

    private boolean isSuspendedByCompensatoryResumed(WFProcessContext context, long wsIdParam, WFWorkstepRunItParams wfWorkstepRunItParams, WorkStepInstanceEBLocal workStepInstanceEBLocal) {
        if (this.isSuspendedByCompensatory(context, wsIdParam)) {
            this.setSuspendedByCompensatory(context, wsIdParam, false);
            WFWorkstepInstance.logCompensatoryFlagInitialized(wfWorkstepRunItParams.wsID);
            if (workStepInstanceEBLocal.getType() == 102) {
                workStepInstanceEBLocal.setState(18);
                BLUtil.fireEvent(this.getEventContext(context, wsIdParam, 17), (int)17);
                return true;
            }
        }
        return false;
    }

    private boolean isEventActivationForceSave(WFProcessContext context, long wsIdParam, WFWorkstep wfWorkstep, WorkStepInstanceEBLocal workStepInstanceEBLocal) {
        if (!this.isActivated(context, wsIdParam)) {
            int eventType = this.getEventType(context, wsIdParam);
            if (wfWorkstep.isMonitorStep()) {
                eventType = 91;
                workStepInstanceEBLocal.setState(91);
                this.forceSave(context, workStepInstanceEBLocal);
                WFWorkstepInstance.logBizLogiError4303(context, wsIdParam);
                BLUtil.fireEvent(this.getEventContext(context, wsIdParam, eventType), (int)eventType);
                return true;
            }
            workStepInstanceEBLocal.setState(18);
            WFWorkstepInstance.publishAlerts(eventType, wfWorkstep, context, wsIdParam);
            WFWorkstepInstance.callBackAdapterOnActivation(eventType, context, wfWorkstep);
            BLUtil.fireEvent(this.getEventContext(context, wsIdParam, eventType), (int)eventType);
        }
        return false;
    }

    private static void removeDebugWSEntry(WFProcessContext context, long wsIdParam) {
        if (context.isDebug()) {
            DebugService.self().removeDebugWSEntry(context, wsIdParam, 1);
        }
    }

    private void processNextWorksteps(WFProcessContext context, long wsIdParam) {
        if (context.isXORHelperExist() && context.getXORHelper().isMarkedForTermination(wsIdParam)) {
            context.getXORHelper().removeFromTerminationList(wsIdParam);
            BLControl.logger.infoKey(BIZ_LOGIC_ERR_4107, RUN_IT_METHOD, new Object[]{context.getWorkStepInstanceName(wsIdParam), context.getProcessInstanceName()});
        } else {
            this.activateNextWorksteps(context, wsIdParam);
        }
    }

    private boolean isDelayActivation(WFWorkstep wfWorkstep, WFProcessContext context, WorkStepInstanceEBLocal workStepInstanceEBLocal, long wsIdParam, WFWorkstepRunItParams wfWorkstepRunItParams) {
        boolean isDelay;
        if (wfWorkstep.isDelayActivation() && !context.isDebug() && (workStepInstanceEBLocal.getSuspendState() == 7 || this.isCreated(context, wsIdParam) || this.isCompleted(context, wsIdParam) || this.isSkipped(context, wsIdParam)) && (isDelay = this.delayActivation(context, wfWorkstep, wsIdParam, workStepInstanceEBLocal))) {
            BLControl.logger.infoKey(BIZ_LOGIC_ERR_3242, (Object[])new String[]{wfWorkstepRunItParams.piName, wfWorkstepRunItParams.wsName});
            return true;
        }
        return false;
    }

    private boolean isMessageExecutionActivated(WFWorkstep wfWorkstep, WorkStepInstanceEBLocal workStepInstanceEBLocal, WFProcessContext context, long wsIdParam) {
        if (this.isWorkStepSubscribedToAnyMessage(wfWorkstep) && !wfWorkstep.isMessageSubscriberWS() && !wfWorkstep.isInitialWorkstep() && (workStepInstanceEBLocal.getSuspendState() == 10 || this.isCreated(context, wsIdParam))) {
            WFMessageSubscriberInstance.self().execute(context, wsIdParam);
            return true;
        }
        return false;
    }

    private static void logTimerActionError(WFWorkstepRunItParams wfWorkstepRunItParams, long dueDate, String message) {
        if (BLControl.util.DEBUG_TIMERACTION) {
            BLControl.logger.debugKey(BIZ_LOGIC_ERR_3519, RUN_IT_MESSAGE, new Object[]{wfWorkstepRunItParams.piName, wfWorkstepRunItParams.wsName, new Date(dueDate), message});
        }
    }

    private static void setDataSlotCopies(WFWorkstep wfWorkstep, WorkStepInstanceEBLocal workStepInstanceEBLocal, WFProcessContext context) {
        if (wfWorkstep.isRollbackPoint() && wfWorkstep.hasDSCopies() && workStepInstanceEBLocal.getDataSlotCopies() == null) {
            String[] convertedDsCopyNames = BLUtil.convertVectorToStringArray((Vector)wfWorkstep.getDSCopyNames());
            workStepInstanceEBLocal.setDataSlotCopies(context.getSlotValue(convertedDsCopyNames));
        }
    }

    private static void logValidPreConditionInfoMessage(WFWorkstepRunItParams wfWorkstepRunItParams) {
        BLControl.logger.infoKey(BIZ_LOGIC_ERR_8001, (Object[])new String[]{wfWorkstepRunItParams.wsName, wfWorkstepRunItParams.piName});
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debug((Object)(PRE_COND_EVALUATED + wfWorkstepRunItParams.wsID + GT_SIGN));
        }
    }

    private static boolean isValidWorkstepCondition(WFProcessContext context, long wsIdParam, int preConditionType, String preCondition, WFWorkstepRunItParams wfWorkstepRunItParams) {
        boolean isValid = context.isWSPreConditionValid(wsIdParam);
        if (!isValid) {
            try {
                isValid = WFPreCondition.self().validateCondition(context, wsIdParam, preConditionType, preCondition);
            }
            catch (RuntimeException th) {
                BLControl.logger.errorKey(BIZ_LOGIC_ERR_2684, (Object[])new String[]{preCondition, wfWorkstepRunItParams.processTemplateName + COLON + wfWorkstepRunItParams.wsName}, (Throwable)th);
            }
        }
        return isValid;
    }

    private void processWsSuspendedAtPrecond(WorkStepInstanceEBLocal workStepInstanceEBLocal, WFProcessContext context, WFWorkstep wfWorkstep, long wsid) {
        if (workStepInstanceEBLocal.getSuspendState() < 1) {
            long piid = context.getProcessInstanceID();
            WFWorkstepInstance.insertProcessTemplate(wfWorkstep, context, piid, wsid);
            workStepInstanceEBLocal.setSuspendState(1);
            workStepInstanceEBLocal.setState(62);
            BLUtil.fireEvent(this.getEventContext(context, wsid, 62), (int)62);
        }
    }

    private static void insertProcessTemplate(WFWorkstep wfWorkstep, WFProcessContext context, long piId, long wsIdParam) {
        if (wfWorkstep.isPreCondReferGlobalDS()) {
            WaitWorkStepDAO.insert(context.getProcessTemplateID(), piId, wsIdParam, 1);
        } else {
            WaitWorkStepDAO.insert(context.getProcessTemplateID(), piId, wsIdParam, 0);
        }
    }

    private void suspendOnPreJsFailure(RuntimeException exception, WFWorkstepRunItParams wfWorkstepRunItParams, WorkStepInstanceEBLocal workStepInstanceEBLocal, WFProcessContext context, long wsIdParam) {
        BLControl.logger.errorKey(BIZ_LOGIC_ERR_931, new Object[]{wfWorkstepRunItParams.piName, wfWorkstepRunItParams.wsName, RUN_IT_MESSAGE}, (Throwable)exception);
        workStepInstanceEBLocal.setSuspendState(2);
        this.suspend(context, wsIdParam, false, exception, null);
    }

    private static void logPreJavascriptExecuted(String wsID) {
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debug((Object)(PRE_JAVASCRIPT_EXECUTED_FOR + wsID + GT_SIGN));
        }
    }

    private static void logCompensatoryFlagInitialized(String wsID) {
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debug((Object)(COMPENSATORY_FLAG_INITIALIZED_FOR + wsID + GT_SIGN));
        }
    }

    private void setInstruction(WFProcessContext context, long wsIdParam, WorkStepInstanceEBLocal wsieb) {
        wsieb.setInstruction(this.getRealInstruction(context, wsIdParam));
    }

    private void updateActualPerformer(WFProcessContext context, long wsIdParam, WorkStepInstanceEBLocal wsieb) {
        this.setActualPerformer(context, wsIdParam, this.getRealPerformer(context, wsIdParam, wsieb.getPerformer()));
    }

    private int getEventType(WFProcessContext context, long wsIdParam) {
        int eventType = 18;
        if (this.isSuspended(context, wsIdParam)) {
            eventType = 17;
        }
        return eventType;
    }

    private static void publishAlerts(int eventType, WFWorkstep wfWorkstep, WFProcessContext context, long wsIdParam) {
        try {
            if (eventType == 18 && wfWorkstep.hasAlerts(18)) {
                List alertsPublished = BLAlertService.single().publishAlerts(context, wsIdParam, wfWorkstep.getAlertNames(18));
                if (BLControl.util.DEBUG_ALERTS) {
                    BLControl.logger.debugKey(BIZ_LOGIC_ERR_3160, RUN_IT_MESSAGE, new Object[]{context.getProcessInstanceName(), context.getWorkstep(wsIdParam).getName(), W_ACTIVATED, alertsPublished});
                }
            }
        }
        catch (RuntimeException e) {
            BLControl.logger.errorKey(BIZ_LOGIC_ERR_3691, new Object[]{context.getProcessInstanceName(), context.getWorkstep(wsIdParam).getName(), W_ACTIVATED}, (Throwable)e);
        }
    }

    private static void logBizLogiError4303(WFProcessContext context, long wsIdParam) {
        if (BLControl.util.DEBUG_ENGINE || BLControl.util.DEBUG_MONITORING) {
            BLControl.logger.debugKey(BIZ_LOGIC_ERR_4303, RUN_IT_MESSAGE, new Object[]{context.getProcessInstanceID(), wsIdParam, 91});
        }
    }

    private static void callBackAdapterOnActivation(int eventType, WFProcessContext context, WFWorkstep wfWorkstep) {
        if (eventType == 18 && BLControl.util.isCallback() && ProcessCallback.hasCallback((int)18, (String)context.getProcessTemplateName(), (String)context.getProcess().getAppName())) {
            ProcessContext prcctx = BLUtil.getProcessContext((WFProcessContext)context, (String)wfWorkstep.getName(), (JSTools)new JSTools(context, wfWorkstep.getName()));
            ProcessCallback.execute((int)18, (SBMContext)prcctx, (boolean)true);
        }
    }

    private void processInlineBlockName(WorkStepInstanceEBLocal workStepInstanceEBLocal, WFWorkstep wfWorkstep, WFProcessContext context) {
        if (workStepInstanceEBLocal.getInlineBlockName() == null && wfWorkstep.isWithinInlineBlock()) {
            this.updateInlineBlockName(context, workStepInstanceEBLocal, wfWorkstep);
        }
    }

    private void startWorkstepExecution(WFWorkstep wfWorkstep, WFProcessContext context, long wsIdParam, WorkStepInstanceEBLocal workStepInstanceEBLocal, WFWorkstepRunItParams wfWorkstepRunItParams) {
        int piStateBeforeWSExecute = context.getProcessInstanceEB().getState();
        try {
            this.execute(context, wsIdParam);
        }
        catch (RuntimeException th) {
            BLControl.logger.errorKey(BIZ_LOGIC_ERR_931, new Object[]{wfWorkstepRunItParams.piName, wfWorkstepRunItParams.wsName, RUN_IT_MESSAGE}, (Throwable)th);
            WFWorkstepInstance.removeByWorkStepInstance(workStepInstanceEBLocal, wsIdParam, context);
            this.endWorkstepExecution(wfWorkstep, context, piStateBeforeWSExecute, workStepInstanceEBLocal, wsIdParam, th);
        }
    }

    private static void removeByWorkStepInstance(WorkStepInstanceEBLocal workStepInstanceEBLocal, long wsIdParam, WFProcessContext context) {
        if (workStepInstanceEBLocal.getType() == 102) {
            try {
                WorkItemDAO.removeByWorkStepInstance(context.getProcessInstanceID(), wsIdParam);
            }
            catch (RuntimeException e) {
                BLControl.logger.warnKey(BIZ_LOGIC_ERR_3562, RUN_IT_METHOD, (Throwable)e, new Object[]{context.getProcessInstanceID(), wsIdParam});
            }
        }
    }

    private void endWorkstepExecution(WFWorkstep wfWorkstep, WFProcessContext context, int piStateBeforeWSExecute, WorkStepInstanceEBLocal workStepInstanceEBLocal, long wsIdParam, RuntimeException exception) {
        if (wfWorkstep.getType() == 101) {
            int piStateOnWSExecuteError = context.getProcessInstanceEB().getState();
            context.getProcessInstanceEB().setState(piStateBeforeWSExecute);
            BLControl.logger.errorKey(BIZ_LOGIC_ERR_4724, RUN_IT_METHOD, new Object[]{context.getProcessInstanceID(), wfWorkstep.getID(), wfWorkstep.getName(), piStateBeforeWSExecute, piStateOnWSExecuteError});
        }
        workStepInstanceEBLocal.setSuspendState(3);
        this.suspend(context, wsIdParam, true, exception, null);
    }

    private boolean executeSkipCondition(WFProcessContext pCtx, WFWorkstep ws) {
        String skipConditionCode = ws.getSkipConditionCode();
        boolean success = false;
        try {
            success = WFPreCondition.self().validateCondition(pCtx, ws.getID(), ws.getSkipConditionType(), skipConditionCode);
        }
        catch (Exception ex) {
            throw new BizLogicException("BizLogic_ERR_3721", "WFWorkstepInstance:runIt()", new Object[]{skipConditionCode, pCtx.getProcessTemplateName() + COLON + pCtx.getProcessInstanceName() + COLON + ws.getName()}, (Throwable)ex);
        }
        if (success) {
            BLControl.logger.infoKey("BizLogic_ERR_3228", new Object[]{pCtx.getProcessTemplateName() + COLON + pCtx.getProcessInstanceName() + COLON + ws.getName(), ws.getSkipCondition()});
        }
        return success;
    }

    public long getLoopConditionCounter(WFProcessContext pCtx, long wsid) {
        WFWorkstep ws = pCtx.getWorkstep(wsid);
        if (ws.getLoopConditionCounterDSName() != null) {
            Long counterValue = (Long)pCtx.getSlotValue(ws.getLoopConditionCounterDSName());
            return counterValue;
        }
        return -1L;
    }

    private void incrementLoopConditionCounter(WFProcessContext pCtx, WFWorkstep ws) {
        if (!ws.hasLoopCondition()) {
            return;
        }
        String lcDSName = ws.getLoopConditionCounterDSName();
        if (lcDSName != null) {
            pCtx.incrementLongSlotValue(lcDSName, 1L);
        }
    }

    private boolean executeLoopCondition(WFProcessContext pCtx, WFWorkstep ws) {
        String loopConditionCode = ws.getLoopConditionCode();
        boolean lcResult = false;
        try {
            lcResult = WFPreCondition.self().validateCondition(pCtx, ws.getID(), ws.getLoopConditionType(), loopConditionCode);
        }
        catch (Exception ex) {
            WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(ws.getID());
            wsieb.setSuspendState(9);
            this.suspend(pCtx, ws.getID(), false, ex, null);
            return false;
        }
        if (lcResult) {
            pCtx.setWSActivationInLoop(ws.getID());
        } else {
            pCtx.setWSActivationInLoop(-1L);
        }
        if (lcResult && BLControl.util.DEBUG_JSCRIPT) {
            BLControl.logger.debugKey("BizLogic_ERR_3156", "WFWorkstepInstance.executeLoopCondition", new Object[]{pCtx.getProcessTemplateName() + COLON + pCtx.getProcessInstanceName() + COLON + ws.getName(), ws.getLoopCondition()});
        }
        return true;
    }

    public Object executeJS(WFProcessContext pCtx, long wsid, String scriptLocation) {
        if (pCtx == null || scriptLocation == null || scriptLocation.trim().isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_1505", "WFWorkstepInstance.executeJS");
        }
        WFProcess pt = pCtx.getProcess();
        WFJavaScript wsJS = pt.getJavaScript(wsid);
        if (wsJS == null) {
            return null;
        }
        return WFJavaScript.executeJS(pCtx, wsid, wsJS, scriptLocation);
    }

    private Object executeScript(WFProcessContext pCtx, long wsid, String scriptLocation) {
        if (pCtx == null || scriptLocation == null || scriptLocation.trim().isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_1505", "WFWorkstepInstance.executeScript");
        }
        WFProcess pt = pCtx.getProcess();
        WFJavaScript wsJS = pt.getJavaScript(wsid);
        if (wsJS == null) {
            return null;
        }
        if (!wsJS.hasScript(scriptLocation)) {
            return null;
        }
        if (wsJS.getScriptType(scriptLocation) == 205) {
            String javaCode = wsJS.getJavaScriptCode(scriptLocation);
            if (javaCode != null && !javaCode.trim().isEmpty()) {
                return WFJavaScript.executeJavaCode(pCtx, wsid, null, javaCode);
            }
        } else if (wsJS.getScriptType(scriptLocation) == 201) {
            return WFJavaScript.executeJS(pCtx, wsid, wsJS, scriptLocation);
        }
        return null;
    }

    public void execute(WFProcessContext pCtx, long wsid) {
    }

    public void suspend(WFProcessContext pCtx, long wsid, boolean reactivateOnError, Throwable causedBy, String reason) {
        WFWorkstep ws;
        String reactiveWS;
        if (this.isSuspended(pCtx, wsid)) {
            BLControl.logger.warnKey("BizLogic_ERR_1669", new Object[]{pCtx.getWorkstep(wsid).getName(), pCtx.getProcessInstanceName()});
            return;
        }
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        wsieb.setState(16);
        Map<String, Object> eventContext = this.getEventContext(pCtx, wsid, 16);
        if (causedBy != null) {
            String exception = SBMUtil.getStackTrace((Throwable)causedBy);
            eventContext.put("EXCEPTION", exception);
        }
        if (reason != null && reason.trim().length() > 0) {
            eventContext.put("REASON", reason);
        }
        BLUtil.fireEvent(eventContext, (int)16);
        EmailComposer.self().sendWSSuspendProblem(pCtx, wsid, BLUtil.SYSTEMADMIN, causedBy, reason);
        if (pCtx.isDebug()) {
            DebugService.self().removeDebugWSEntry(pCtx, wsid, 1);
        }
        if ((reactiveWS = (ws = pCtx.getWorkstep(wsid)).getReactivateWorkStepName()) != null && reactivateOnError) {
            wsieb.save();
            BLControl.logger.errorKey("BizLogic_ERR_2563", new Object[]{pCtx.getProcessInstanceName(), ws.getName(), reactiveWS});
            this.reactivate(pCtx, reactiveWS);
        }
    }

    public void resume(WFProcessContext pCtx, long wsid) {
        if (this.isActivated(pCtx, wsid)) {
            BLControl.logger.warnKey("BizLogic_ERR_1670", new Object[]{pCtx.getWorkstep(wsid).getName(), pCtx.getProcessInstanceName()});
            return;
        }
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        if (this.isSuspended(pCtx, wsid)) {
            if (this.isSuspendedByCompensatory(pCtx, wsid)) {
                String piname = pCtx.getProcessInstanceName();
                String wsname = pCtx.getWorkstep(wsid).getName();
                throw new BizLogicException("BizLogic_ERR_681", "WFWorkstepInstance.resume", (Object[])new String[]{wsname, piname});
            }
            if (wsieb.getPreviousState() == 61) {
                wsieb.setState(wsieb.getPreviousState());
                BLUtil.fireEvent(this.getEventContext(pCtx, wsid, 61), (int)61);
                return;
            }
            if (wsieb.getPreviousState() == 62) {
                wsieb.setState(wsieb.getPreviousState());
                BLUtil.fireEvent(this.getEventContext(pCtx, wsid, 62), (int)62);
                this.resume(pCtx, wsid);
                return;
            }
            if (wsieb.getSuspendState() == 9) {
                wsieb.setState(18);
                this.complete(pCtx, wsid);
            } else if (wsieb.getSuspendState() == 4) {
                if (pCtx.getWorkstep(wsid).isMonitorStep()) {
                    wsieb.setState(wsieb.getPreviousState());
                } else {
                    wsieb.setState(18);
                }
                this.complete(pCtx, wsid);
            } else if (wsieb.getSuspendState() == 5) {
                if (pCtx.getWorkstep(wsid).isMonitorStep()) {
                    this.activate(pCtx, wsid);
                    return;
                }
                wsieb.setState(wsieb.getPreviousState());
                BLUtil.fireEvent(this.getEventContext(pCtx, wsid, 17), (int)17);
            } else {
                this.activate(pCtx, wsid);
            }
        } else if (this.isPreConditionWaitState(pCtx, wsid)) {
            long startTime = System.currentTimeMillis();
            wsieb.setTimeStarted(startTime);
            this.activate(pCtx, wsid);
        }
    }

    public boolean isSplit(WFProcessContext pCtx, long wsid) {
        block5: {
            Vector v;
            block4: {
                int typeTag = pCtx.getWorkstep(wsid).getType();
                if (typeTag == 103) break block4;
                if (typeTag != 106) break block5;
            }
            if ((v = this.getNextWorksteps(pCtx, wsid)).size() > 1) {
                return true;
            }
        }
        return false;
    }

    public Vector getNextWorksteps(WFProcessContext pCtx, long wsid) {
        Vector<WFWorkstep> ws = new Vector<WFWorkstep>();
        Vector<WFWorkstep> defaultws = new Vector<WFWorkstep>();
        WFWorkstep wsdef = pCtx.getWorkstep(wsid);
        Vector hasOutgoing = wsdef.getOutConnections();
        for (int x = 0; x < hasOutgoing.size(); ++x) {
            WFLink c = (WFLink)hasOutgoing.elementAt(x);
            if (c.isTimeoutFlow()) continue;
            if (c.isDefault()) {
                defaultws.addElement(c.getTarget());
                if (!wsdef.isExclusive()) continue;
                if (BLControl.util.DEBUG_JSCRIPT) {
                    BLControl.logger.debugKey("BizLogic_ERR_3157", "WFWorkstepInstance.getNextWorksteps", new Object[]{pCtx.getProcessInstanceName(), wsdef.getName(), c.getName(), c.getTarget().getName()});
                }
                return defaultws;
            }
            boolean checkCondition = false;
            try {
                String query = c.getQuery();
                int queryType = c.getQueryType();
                checkCondition = queryType == 201 ? WFPreCondition.self().validateJS(pCtx, c.getName(), query, c.getcompiledJSQuery(), "DECISION") : (queryType == 203 ? WFPreCondition.self().validateJavaCode(pCtx, -1L, c.getName(), query) : WFPreCondition.self().validateCondition(pCtx, wsid, queryType, query));
            }
            catch (Throwable th) {
                BLControl.logger.warnKey("BizLogic_ERR_1134", new Object[]{c.getQuery(), c.getName(), pCtx.getProcessTemplateName()});
            }
            if (!checkCondition) continue;
            ws.addElement(c.getTarget());
            if (!wsdef.isExclusive()) continue;
            if (BLControl.util.DEBUG_JSCRIPT) {
                BLControl.logger.debugKey("BizLogic_ERR_3158", "WFWorkstepInstance.getNextWorksteps", new Object[]{pCtx.getProcessInstanceName(), wsdef.getName(), c.getName(), c.getQuery(), c.getTarget().getName()});
            }
            return ws;
        }
        if (wsdef.isExclusive()) {
            throw new BizLogicException("BizLogic_ERR_3679", "WFWorkstepInstance.getNextWorksteps", (Object[])new String[]{pCtx.getProcessInstanceName(), wsdef.getName()});
        }
        if (ws.isEmpty()) {
            if (defaultws.isEmpty()) {
                throw new BizLogicException("BizLogic_ERR_3679", "WFWorkstepInstance.getNextWorksteps", (Object[])new String[]{pCtx.getProcessInstanceName(), wsdef.getName()});
            }
            return defaultws;
        }
        return ws;
    }

    public Vector getPreviousWorksteps(WFProcessContext pCtx, long wsid) {
        return pCtx.getWorkstep(wsid).getPreviousWorksteps();
    }

    public boolean isActivated(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid, true);
        if (wsieb == null) {
            return false;
        }
        return wsieb.getState() == 18;
    }

    public boolean isActivated(long piid, long wsid) {
        return WorkStepInstanceDAO.getWorkstepState(piid, wsid) == 18;
    }

    public boolean isTerminated(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid, true);
        if (wsieb == null) {
            return false;
        }
        return wsieb.getState() == 19;
    }

    public boolean isTerminated(long piid, long wsid) {
        return WorkStepInstanceDAO.getWorkstepState(piid, wsid) == 19;
    }

    public boolean isActivated(long piid, long wsid, int loopCounter) {
        return WorkStepInstanceDAO.getWorkstepState(piid, wsid, loopCounter) == 18;
    }

    public boolean isSuspended(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid, true);
        if (wsieb == null) {
            return false;
        }
        return wsieb.getState() == 16;
    }

    public boolean isSuspendedAtLoopCounter(WFProcessContext pCtx, long wsid) {
        if (this.isSuspended(pCtx, wsid)) {
            WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
            int n = wsieb.getSuspendState();
            BLConstants.single();
            return n == 8;
        }
        return false;
    }

    public boolean isCompleted(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid, true);
        if (wsieb == null) {
            return false;
        }
        return wsieb.getState() == 21;
    }

    public boolean isCompleted(long piid, long wsid) {
        return WorkStepInstanceDAO.getWorkstepState(piid, wsid) == 21;
    }

    public boolean isCreated(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid, true);
        if (wsieb == null) {
            return true;
        }
        return wsieb.getState() == 15;
    }

    public boolean isMessageWaitState(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid, true);
        if (wsieb == null) {
            return true;
        }
        return wsieb.getState() == 60;
    }

    public boolean isActivationWaitState(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid, true);
        if (wsieb == null) {
            return true;
        }
        return wsieb.getState() == 61;
    }

    public boolean isEventActivationWaitState(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid, true);
        if (wsieb == null) {
            return true;
        }
        return wsieb.getState() == 91;
    }

    public boolean isPreConditionWaitState(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid, true);
        if (wsieb == null) {
            return true;
        }
        return wsieb.getState() == 62;
    }

    public boolean isSkipped(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid, true);
        if (wsieb == null) {
            return false;
        }
        return wsieb.getState() == 63;
    }

    public boolean isSkipped(long piid, long wsid) {
        return WorkStepInstanceDAO.getWorkstepState(piid, wsid) == 63;
    }

    private boolean suspendOnMaxLoopCounter(WFProcessContext pCtx, long wsid) {
        block2: {
            block4: {
                WFWorkstep ws;
                WorkStepInstanceEBLocal wsieb;
                block3: {
                    wsieb = pCtx.getWorkstepInstanceEB(wsid);
                    ws = pCtx.getWorkstep(wsid);
                    String wsName = ws.getName();
                    String piName = pCtx.getProcessInstanceName();
                    if (!this.isMaxLoopCounterReached(pCtx, wsid) || ws.isConnectorWS()) break block2;
                    BLControl.logger.errorKey("BizLogic_ERR_3664", new Object[]{wsName, piName, ws.getActivationLimit()});
                    if (!this.isSuspended(pCtx, wsid)) break block3;
                    if (wsieb.getSuspendState() == 8) break block4;
                }
                wsieb.setSuspendState(8);
                this.suspend(pCtx, wsid, false, null, BLControl.msgFactory.lookup("BizLogic_ERR_4644", new Object[]{ws.getActivationLimit()}));
            }
            return true;
        }
        return false;
    }

    private boolean isMaxLoopCounterReached(WFProcessContext pCtx, long wsid) {
        if (-1 == pCtx.getWorkstep(wsid).getActivationLimit()) {
            return false;
        }
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        return wsieb.getLoopCounter() > pCtx.getWorkstep(wsid).getActivationLimit();
    }

    private void incrementLoopCounter(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        wsieb.incrementLoopCounter();
    }

    private long calculateDueDate(WFProcessContext pCtx, WorkStepInstanceEBLocal wsieb, WFWorkstep ws) {
        long timeStarted = wsieb.getTimeStarted();
        long duedate = wsieb.getDuedate();
        if (duedate <= timeStarted) {
            long durationSecs = this.getRealDuration(pCtx, ws);
            long duration = durationSecs * 1000L;
            wsieb.setDuration(durationSecs);
            if (BLUtil.self().useCalendar() && ws.isAtomic()) {
                duedate = BLCalendar.self().getDueDate(timeStarted, duration);
                if (BLControl.util.DEBUG_ENGINE) {
                    long piid = wsieb.getProcessInstanceID();
                    BLControl.logger.debugKey("BizLogic_ERR_1714", new Object[]{ws.getName(), piid, new Date(duedate).toString()});
                }
            } else {
                duedate = timeStarted + duration;
            }
            wsieb.setDuedate(duedate);
        }
        return duedate;
    }

    public void setDuration(WFProcessContext pCtx, long wsid, long d) {
        long duration = d;
        WorkStepInstanceEBLocal wsieb = this.getWSInstance(pCtx, wsid);
        long timeStarted = wsieb.getTimeStarted();
        long duedate = BLControl.util.adjustDueDate(timeStarted + duration * 1000L, timeStarted);
        this.setDue(pCtx, wsid, duedate);
    }

    public void setDue(WFProcessContext pCtx, long wsid, long duedate) {
        WorkStepInstanceEBLocal wsieb = this.getWSInstance(pCtx, wsid);
        wsieb.setDuedate(duedate);
        this.setWorkItemsDueDate(pCtx, wsid, duedate);
        if (pCtx.getWorkstep(wsid).isCheckDue()) {
            TimerActionDAO.updateDueDate(pCtx.getProcessInstanceID(), wsid, duedate);
            pCtx.setWsDueDateSet(true);
        }
    }

    void setInstruction(WFProcessContext pCtx, long wsid, String instruction) {
        WorkStepInstanceEBLocal wsieb = this.getWSInstance(pCtx, wsid);
        wsieb.setInstruction(instruction);
    }

    private void setSubProcessInstanceID(WFProcessContext pCtx, long wsid, long spiid) {
        WorkStepInstanceEBLocal wsieb = this.getWSInstance(pCtx, wsid);
        wsieb.setSubProcessInstanceID(spiid);
    }

    private void setWorkItemsDueDate(WFProcessContext pCtx, long wsid, long dt) {
        Vector wiList = WorkItemDAO.getWorkItemList(pCtx.getProcessInstanceID(), wsid, false);
        for (int ix = 0; ix < wiList.size(); ++ix) {
            HashMap wiattrs = (HashMap)wiList.get(ix);
            Long wiID = (Long)wiattrs.get("WORKITEMID");
            if (wiID == null) continue;
            WFWorkItem.self().setDueDate(pCtx, wiID, dt);
        }
    }

    private void setWorkItemsPriority(WFProcessContext pCtx, long wsid, int priority) {
        Collection wiList = WorkItemDAO.findByWorkStepInstance(pCtx.getProcessInstanceID(), wsid);
        Long wiID2 = null;
        for (Long wiID2 : wiList) {
            WFWorkItem.self().setPriority(pCtx, (long)wiID2, priority);
        }
    }

    public void setActivationTime(WFProcessContext pCtx, long wsid, long time) {
        WFWorkstep ws = pCtx.getWorkstep(wsid);
        if (time <= System.currentTimeMillis()) {
            throw new BizLogicException("BizLogic_ERR_872", "WFWorkstepInstance.setActivationTime()", new Object[]{pCtx.getProcessInstanceName(), time, ws.getName()});
        }
        if (!this.isActivationWaitState(pCtx, wsid)) {
            throw new BizLogicException("BizLogic_ERR_871", "WFWorkstepInstance.setActivationTime()", new Object[]{ws.getName(), pCtx.getProcessInstanceName()});
        }
        WorkStepInstanceEBLocal wsieb = this.getWSInstance(pCtx, wsid);
        wsieb.setTimeStarted(time);
        TimerActionDAO.updateDueDate(pCtx.getProcessInstanceID(), wsid, time);
    }

    public void setDuedate(WFProcessContext pCtx, long wsid, long date, boolean isCalledAtActivationOrResume) {
        if (!isCalledAtActivationOrResume && (this.isSuspended(pCtx, wsid) || this.isCompleted(pCtx, wsid))) {
            throw new BizLogicException("Bizlogic_ERR_4805", "WFWorkstepInstance.setDuedate", new Object[]{pCtx.getWorkStepInstanceName(wsid), pCtx.getProcessInstanceName()});
        }
        WorkStepInstanceEBLocal wsieb = this.getWSInstance(pCtx, wsid);
        if (wsieb.getDuedate() == date) {
            return;
        }
        long timeStarted = wsieb.getTimeStarted();
        long duedt = BLControl.util.adjustDueDate(date, timeStarted);
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debug((Object)("WFWorkstepInstance.setDuedate(): Setting DUEDATE_SET_FOR_WS on workstep instance entity. The due date value being set to is " + duedt));
        }
        pCtx.setDueDateSetForWs(wsid);
        duedt = this.adjustDueDate(pCtx, wsid, duedt);
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debug((Object)("WFWorkstepInstance.setDuedate(): After adjusting the due date value as per appropriate calendar, new value is " + duedt));
        }
        this.setDue(pCtx, wsid, duedt);
        BLUtil.fireEvent(this.getEventContext(pCtx, wsid, 23), (int)23);
    }

    public long adjustDueDate(WFProcessContext pCtx, long wsid, long dueDate) {
        long newDueDate = BLCalendar.self().getDueDate(dueDate, 0L);
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debug((Object)("WFWorkstepInstance.adjustDueDate(): \n\t wsid=" + wsid + "\n\t dueDate=" + dueDate + "\n\t newDueDate=" + newDueDate));
        }
        return newDueDate;
    }

    public void setDuedate(WFProcessContext pCtx, long wsid, String dateString, boolean isCalledAtActivationOrResume) {
        long parseValue;
        if (!isCalledAtActivationOrResume && (this.isSuspended(pCtx, wsid) || this.isCompleted(pCtx, wsid))) {
            throw new BizLogicException("Bizlogic_ERR_4805", "WFWorkstepInstance.setDuedate", new Object[]{pCtx.getWorkStepInstanceName(wsid), pCtx.getProcessInstanceName()});
        }
        String wsName = pCtx.getWorkstep(wsid).getName();
        String piName = pCtx.getProcessInstanceName();
        try {
            parseValue = new DateTime(dateString).getTime();
        }
        catch (Exception ex) {
            throw new BizLogicException("BizLogic_ERR_2569", "WFWorkstepInstance.setDuedate", (Object[])new String[]{piName, wsName}, (Throwable)ex);
        }
        WorkStepInstanceEBLocal wsieb = this.getWSInstance(pCtx, wsid);
        long timeStarted = wsieb.getTimeStarted();
        parseValue = BLControl.util.adjustDueDate(parseValue, timeStarted);
        if (parseValue <= timeStarted) {
            throw new BizLogicException("BizLogic_ERR_2567", "WFWorkstepInstance.setDuedate", (Object[])new String[]{piName, wsName});
        }
        this.setDue(pCtx, wsid, parseValue);
        BLUtil.fireEvent(this.getEventContext(pCtx, wsid, 23), (int)23);
    }

    public void setPerformer(WFProcessContext pCtx, long wsid, String p) {
        if (!BLUtil.isValidHumanStepPerformer((String)p)) {
            throw new BizLogicException("BizLogic_ERR_600", "WFWorkstepInstance.setPerformer", (Object[])new String[]{pCtx.getProcessInstanceEB().getName(), p, pCtx.getWorkstep(wsid).getName()});
        }
        if (p.length() > BLControl.util.MAX_PERFORMER_SIZE) {
            String wsName = pCtx.getWorkstep(wsid).getName();
            throw new BizLogicException("BizLogic_ERR_666", "WFWorkStepInstance::setPerformer", new Object[]{p, wsName, pCtx.getProcessInstanceName(), String.valueOf(BLControl.util.MAX_PERFORMER_SIZE)});
        }
        WorkStepInstanceEBLocal wsieb = this.getWSInstance(pCtx, wsid);
        wsieb.setPerformer(p);
        Map<String, Object> eventContext = this.getEventContext(pCtx, wsid, 24);
        if (p == null) {
            p = "";
        }
        eventContext.put("PERFORMERVALUE", p);
        BLUtil.fireEvent(eventContext, (int)24);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getRealPriority(WFProcessContext pCtx, long wsid) {
        int priority = -1;
        String mappedPriority = pCtx.getWorkstep(wsid).getMappedPriority();
        if (mappedPriority == null) return pCtx.getWorkstep(wsid).getPriority();
        if (mappedPriority.trim().length() == 0) return pCtx.getWorkstep(wsid).getPriority();
        Object dsValue = pCtx.getSlotValue(mappedPriority);
        if (dsValue == null) return BLUtil.getIntegerPriority((String)((String)dsValue));
        if (!(dsValue instanceof String)) throw new BizLogicException("BizLogic_ERR_3904", "WFWorkstepInstance.getRealPriority", new Object[]{mappedPriority, pCtx.getWorkstep(wsid).getName(), pCtx.getWorkstep(wsid).getProcessName()});
        return BLUtil.getIntegerPriority((String)((String)dsValue));
    }

    public String getRealPerformer(WFProcessContext pCtx, long wsid, String performerID) {
        if (performerID == null) {
            return null;
        }
        if (BLUtil.isSinglePerformer((String)performerID)) {
            return performerID;
        }
        Vector performerList = BLUtil.toVectorListPerformer((String)performerID);
        Vector realPerformerList = this.getRealPerformer(pCtx, wsid, performerList);
        return BLUtil.toStringListPerformer((List)realPerformerList);
    }

    public Vector getRealPerformer(WFProcessContext pCtx, long wsid, Vector performerList) {
        if (performerList == null) {
            return null;
        }
        Vector<String> realPerformerList = new Vector<String>(performerList.size());
        Vector<String> dsPerformerList = new Vector<String>();
        for (int ix = 0; ix < performerList.size(); ++ix) {
            String performer = (String)performerList.elementAt(ix);
            if (!BLUtil.isParameter((String)performer)) {
                realPerformerList.addElement(performer);
                continue;
            }
            String performerSansAt = BLUtil.getParameter((String)performer);
            if ("CREATOR".equalsIgnoreCase(performerSansAt)) {
                String piCreator = pCtx.getProcessInstanceEB().getCreator();
                if (piCreator == null) {
                    throw new BizLogicException("BizLogic_ERR_571", "WFWorkstepInstance.getRealPerformer", (Object[])new String[]{pCtx.getProcessInstanceName()});
                }
                realPerformerList.addElement(piCreator);
                continue;
            }
            if (performerSansAt.toUpperCase().startsWith("WORKSTEP:")) {
                String nwsName = performerSansAt.substring("WORKSTEP:".length(), performerSansAt.length());
                WFWorkstep w = pCtx.getProcess().getWorkstep(nwsName);
                w.getType();
                String p = pCtx.getWorkstepRealPerformer(w.getID(), w.getPerformer());
                realPerformerList.addElement(p);
                continue;
            }
            if (BOExpression.isObjExpression((String)performerSansAt)) {
                realPerformerList.addAll(this.getObjectDSPerformers(performerSansAt, pCtx, wsid));
                continue;
            }
            dsPerformerList.addElement(performerSansAt);
        }
        if (!dsPerformerList.isEmpty()) {
            HashMap dsNameValues = pCtx.getSlotValue(BLUtil.convertVectorToStringArray(dsPerformerList));
            Iterator i = dsNameValues.keySet().iterator();
            while (i.hasNext()) {
                Object tempDataSlotValue = dsNameValues.get(i.next());
                if (null == tempDataSlotValue || "<NULL>".equalsIgnoreCase(tempDataSlotValue.toString().trim())) continue;
                if (tempDataSlotValue instanceof List) {
                    for (Object obj : (List)tempDataSlotValue) {
                        if (obj == null) continue;
                        realPerformerList.addElement(obj.toString());
                    }
                    continue;
                }
                realPerformerList.addElement(tempDataSlotValue.toString());
            }
        }
        return realPerformerList;
    }

    private List<String> getObjectDSPerformers(String performerSansAt, WFProcessContext pCtx, long wsid) {
        ArrayList<String> performers = new ArrayList<String>();
        Object performersObject = null;
        try {
            performersObject = pCtx.getSlotValue(performerSansAt);
            if (performersObject instanceof String) {
                performers.add((String)performersObject);
            } else if (performersObject instanceof List) {
                performers.addAll((List)performersObject);
            }
        }
        catch (Throwable e) {
            BLControl.logger.errorKey("BizLogic_ERR_3828", (Object[])new String[]{performerSansAt, "Performer", pCtx.getWorkstep(wsid).getName()}, e);
        }
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debugKey("BizLogic_ERR_3282", "WFWorkstepInstance.getObjectDSPerformers", new Object[]{performers, performerSansAt, pCtx.getProcessInstanceID(), pCtx.getProcessTemplateName()});
        }
        return performers;
    }

    public String getRealPerformer(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = this.getWSInstance(pCtx, wsid);
        return this.getRealPerformer(pCtx, wsid, wsieb.getPerformer());
    }

    public Object getRealPerformingApp(WFProcessContext pCtx, long wsid) {
        Object performingApp = pCtx.getWorkstep(wsid).getPerformingApp();
        if (performingApp != null && BLUtil.isParameter((String)performingApp.toString())) {
            String tmp = BLUtil.getParameter((String)((String)performingApp));
            return pCtx.getSlotValue(tmp);
        }
        return performingApp;
    }

    public String getRealInstruction(WFProcessContext pCtx, long wsid) {
        String instruction = pCtx.getWorkstep(wsid).getInstruction();
        if (instruction == null) {
            return null;
        }
        if (BLUtil.isParameter((String)instruction)) {
            String param = instruction;
            BLConstants.single();
            if (!param.equalsIgnoreCase("@CREATOR")) {
                BLConstants.single();
                if (!param.equalsIgnoreCase("@PROCESSNAME")) {
                    BLConstants.single();
                    if (!param.equalsIgnoreCase("@WORKSTEPNAME")) {
                        BLConstants.single();
                        if (!(param.equalsIgnoreCase("@PRIORITY") || param.equalsIgnoreCase("@PROCESS_INSTANCE_ID") || param.equalsIgnoreCase("@PROCESS_TEMPLATE_NAME"))) {
                            param = BLUtil.getParameter((String)instruction);
                        }
                    }
                }
            }
            return (String)pCtx.getSlotValue(wsid, param);
        }
        return instruction;
    }

    public int getPriority(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid, true);
        if (wsieb == null) {
            return pCtx.getWorkstep(wsid).getPriority();
        }
        return wsieb.getPriority();
    }

    public void setPriority(WFProcessContext pCtx, long wsid, int priority) {
        WorkStepInstanceEBLocal wsieb = this.getWSInstance(pCtx, wsid);
        if (wsieb.getPriority() != priority) {
            wsieb.setPriority(priority);
            BLUtil.fireEvent(this.getEventContext(pCtx, wsid, 22), (int)22);
        }
        if (wsieb.getType() == 102 && !wsieb.isMonitorStep()) {
            this.setWorkItemsPriority(pCtx, wsid, priority);
        }
    }

    public void setPriority(WFProcessContext pCtx, long wsid, String priority) {
        int pri;
        if (priority != null && (pri = SBMControl.util.getIntegerPriority(priority)) != -1) {
            this.setPriority(pCtx, wsid, pri);
            return;
        }
        throw new BizLogicException("BizLogic_ERR_1647", "WFWorkstepInstance.setPriority", new Object[]{SBMControl.util.strPriority});
    }

    /*
     * Unable to fully structure code
     */
    protected Map<String, Object> getEventContext(WFProcessContext pCtx, long wsid, int eventType) {
        eventContext = SBMUtil.getNewEventContext();
        if (!WFProcessInstance.checkAuditRequired(pCtx, eventType)) {
            eventContext.put("AUDIT_DISABLED", true);
            return eventContext;
        }
        cacheKey = new AbstractMap.SimpleEntry<Long, Long>(pCtx.getProcessInstanceID(), wsid);
        cached = (Map)CacheManager.cached((String)"WFWorkstepInstance", cacheKey);
        if (cached != null) {
            return cached;
        }
        groupType = null;
        ws = pCtx.getWorkstep(wsid);
        if (ws.isAtomic() && !(performedByAll = ((WFAtomicWS)ws).getPerformedByAll())) {
            groupType = "ANY";
        }
        wsieb = pCtx.getWorkstepInstanceEB(wsid);
        pieb = pCtx.getProcessInstanceEB();
        piName = pieb.getName();
        tmp = null;
        if (BLControl.util.isPrintEvent()) {
            eventContext.put("NAME", ws.getName());
        }
        eventContext.put("RPID", pieb.getRootInstanceID());
        eventContext.put("RPTID", pieb.getRootTemplateID());
        eventContext.put("PROCESSTEMPLATENAME", pCtx.getProcessTemplateName());
        eventContext.put("PROCESSTEMPLATEID", pCtx.getProcessTemplateID());
        eventContext.put("PROCESSINSTANCENAME", piName);
        eventContext.put("PROCESSINSTANCEID", pCtx.getProcessInstanceID());
        eventContext.put("WORKSTEPNAME", ws.getName());
        eventContext.put("WORKSTEPID", ws.getID());
        eventContext.put("MONITOR_STEP", ws.isMonitorStep());
        eventContext.put("TYPE", BLUtil.getStringWSType((int)ws.getType()));
        eventContext.put("LOOPCOUNTER", String.valueOf(wsieb.getLoopCounter()));
        tmp = ws.getPerformer();
        if (tmp == null || tmp.trim().isEmpty()) {
            v0 = ws.getType();
            BLConstants.single();
            if (v0 == 110) {
                BLConstants.single();
                eventContext.put("PERFORMER", "BizLogic");
                BLConstants.single();
                eventContext.put("PERFORMERVALUE", "BizLogic");
            } else {
                eventContext.put("PERFORMER", "");
                eventContext.put("PERFORMERVALUE", "");
            }
        } else {
            eventContext.put("PERFORMER", tmp);
            tmp = wsieb.getActualPerformer();
            if (tmp == null) {
                tmp = "";
            }
            eventContext.put("PERFORMERVALUE", tmp);
        }
        if (ws.isMonitorStep() && wsieb.getPerformer() != null) {
            eventContext.put("PERFORMER", wsieb.getPerformer());
            eventContext.put("PERFORMERVALUE", wsieb.getPerformer());
        }
        timeStarted = wsieb.getTimeStarted();
        eventContext.put("STARTTIME", String.valueOf(timeStarted));
        timeCompleted = wsieb.getTimeCompleted();
        eventContext.put("ENDTIME", String.valueOf(timeCompleted));
        duedate = wsieb.getDuedate();
        eventContext.put("DUEDATE", String.valueOf(duedate));
        stat = wsieb.getState();
        if (stat == 21) ** GOTO lbl-1000
        if (stat == 19) ** GOTO lbl-1000
        if (stat == 63) lbl-1000:
        // 3 sources

        {
            duration = (timeCompleted - timeStarted) / 1000L;
            if (ws.isMonitorStep() && wsieb.getDuration() > 0L) {
                duration = wsieb.getDuration();
            }
            eventContext.put("DURATION", String.valueOf(duration));
        } else {
            estimatedDuration = this.getDuration(pCtx, wsid);
            eventContext.put("ESTIMATEDDURATION", String.valueOf(estimatedDuration));
        }
        if (pCtx.getSession() != null) {
            eventContext.put("SESSION_USER", pCtx.getSession().getUser());
        }
        if (wsieb.getPreviousState() == 16) {
            eventContext.put("PREVIOUSSTATUS", BLConstants.single().wfStates[16]);
        }
        if ((tmp = ws.getMilestoneName()) != null) {
            eventContext.put("MILESTONE_NAME", tmp);
        }
        if ((tmp = wsieb.getInstruction()) != null) {
            eventContext.put("INSTRUCTION", tmp);
        }
        if ((tmp = SBMControl.util.getStringPriority(this.getPriority(pCtx, wsid))) != null) {
            eventContext.put("PRIORITY", tmp);
        }
        if (groupType != null) {
            eventContext.put("GROUPTYPE", groupType);
        }
        pt = pCtx.getProcess();
        eventContext.put("APP_NAME", pt.getAppName());
        if (pCtx.isDebug()) {
            eventContext.put("PI_DEBUG", Boolean.TRUE);
        }
        if (wsieb.getInlineBlockName() == null && ws.isWithinInlineBlock()) {
            this.updateInlineBlockName(pCtx, wsieb, ws);
            this.fireInlineBlockActivateEvent(pCtx, ws.getInlineBlockName());
        }
        if (ws.isWithinInlineBlock()) {
            eventContext.put("INLINEBLOCK_NAME", wsieb.getInlineBlockName());
        }
        ds = null;
        slots = null;
        if (stat != 18 || !BLControl.util.isWSActivationOutputSlots()) {
            if (stat != 21) {
                if (stat == 63) {
                } else {
                    CacheManager.cache((String)"WFWorkstepInstance", cacheKey, (Object)eventContext);
                    return eventContext;
                }
            }
        }
        slots = ws.getOutputSlotsKeys();
        if (stat == 21) {
            if (ws.isAtomic() && ((WFAtomicWS)ws).isVoteEnabled()) {
                votemap = pCtx.getVoteDetails();
                voteDone = Boolean.FALSE;
                if (votemap != null) {
                    BLConstants.single();
                    voteDone = (Boolean)votemap.get("VOTECOMPLETED");
                }
                BLConstants.single();
                eventContext.put("VOTECOMPLETED", voteDone);
            }
            if (ws.isAdapter() && ((WFExternalWS)ws).isSynchron()) {
                BLConstants.single();
                eventContext.put("READTIME", pCtx.getAdapterInvocationTime());
            }
            if (ws.getLoopConditionCounterDSName() != null) {
                loopConditionCounterDS = ws.getLoopConditionCounterDSName();
                loopConditionCounterValue = pCtx.getSlotValue(loopConditionCounterDS);
                eventContext.put("LOOPCONDITIONCOUNTERDS", loopConditionCounterValue);
            }
        }
        if (slots != null && slots.length > 0) {
            v = pt.getGlobalDSNamesList();
            if (v != null && !v.isEmpty()) {
                eventContext.put("GLOBAL_SLOT_NAME_LIST", v);
            }
            if (BLControl.util.excludeBlobDSInEvents()) {
                blobDSNameList = pt.getBlobDataslots(Arrays.asList(slots));
                for (String dsName : blobDSNameList) {
                    eventContext.put(dsName, "<VALUE NOT ADDED>");
                }
                dsNameList = pt.excludeBlobDataslots(Arrays.asList(slots));
                slots = dsNameList.toArray(new String[0]);
            }
            dsNameValueMap = BLUtil.makeObjectToString((HashMap)this.getSlotValue(pCtx, wsid, slots, true));
            eventContext.putAll(dsNameValueMap);
            i = dsNameValueMap.keySet().iterator();
            while (i.hasNext()) {
                ds = this.getDataslot(pCtx, wsid, (String)i.next());
                if (stat != 21) {
                    if (stat != 63) continue;
                }
                if (!ds.isValueMapped() || (mappedKey = ds.getMappedObject(piName)) == null) continue;
                key = mappedKey.substring(0, mappedKey.indexOf(95) + 1);
                key = key + ds.getName();
                mappedKey = mappedKey.substring(mappedKey.indexOf(95) + 1);
                eventContext.put(key, mappedKey);
            }
        }
        eventContext.put("STARTTIME", String.valueOf(wsieb.getTimeStarted()));
        CacheManager.cache((String)"WFWorkstepInstance", cacheKey, (Object)eventContext);
        return eventContext;
    }

    protected void updateInlineBlockName(WFProcessContext pCtx, WorkStepInstanceEBLocal wsieb, WFWorkstep ws) {
        String inlineBlockName = wsieb.getInlineBlockName();
        if (inlineBlockName == null || inlineBlockName.trim().length() == 0) {
            inlineBlockName = ws.getInlineBlockName();
            wsieb.setInlineBlockName(inlineBlockName);
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_3280", "WFWorkstepInstance.updateInlineBlockName", new Object[]{inlineBlockName, ws.getName(), pCtx.getProcessInstanceID(), pCtx.getProcessTemplateName()});
            }
        }
    }

    private void fireInlineBlockActivateEvent(WFProcessContext pCtx, String inlineBlockName) {
        WFWorkstep inlineWS = pCtx.getProcess().getWorkstep(inlineBlockName);
        WorkStepInstanceEBLocal wsieb = this.getWSInstance(pCtx, inlineWS.getID());
        if (wsieb.getState() != 18) {
            wsieb.setTimeStarted(System.currentTimeMillis());
            wsieb.incrementLoopCounter();
            BLConstants.single();
            wsieb.setState(18);
            BLUtil.self();
            long l = inlineWS.getID();
            BLConstants.single();
            Map<String, Object> map = this.getEventContext(pCtx, l, 18);
            BLConstants.single();
            BLUtil.fireEvent(map, (int)18);
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_3281", "WFWorkstepInstance.fireInlineBlockActivateEvent", new Object[]{inlineWS.getName(), pCtx.getProcessInstanceID(), pCtx.getProcessTemplateName()});
            }
        }
    }

    public HashMap getInputSlotValueByMappedName(WFProcessContext pCtx, long wsid) {
        HashMap inputSlotValueByName = this.getInputSlotValueByName(pCtx, wsid);
        if (inputSlotValueByName == null) {
            return null;
        }
        HashMap mapping = pCtx.getWorkstep(wsid).getInputSlotsMapping();
        HashMap inputSlotValueByMappedName = new HashMap(inputSlotValueByName.size());
        for (String dsName : inputSlotValueByName.keySet()) {
            Object dsValue = inputSlotValueByName.get(dsName);
            String mappedName = (String)mapping.get(dsName);
            if (dsValue != null) {
                inputSlotValueByMappedName.put(mappedName, dsValue);
                continue;
            }
            inputSlotValueByMappedName.put(mappedName, "<NULL>");
        }
        return inputSlotValueByMappedName;
    }

    public void setAllOutputDS(WFProcessContext pCtx, long wsid, Hashtable dsValues) {
    }

    public Object[] getData(WFProcessContext pCtx, long wsid, String wiperformer) {
        return new Object[0];
    }

    public HashMap getInputSlotValueByName(WFProcessContext pCtx, long wsid) {
        String[] inputSlotNames = pCtx.getWorkstep(wsid).getInputSlotsKeys();
        if (inputSlotNames == null || inputSlotNames.length == 0) {
            return null;
        }
        return this.getSlotValue(pCtx, wsid, inputSlotNames, false);
    }

    public HashMap getOutputSlotValueByName(WFProcessContext pCtx, long wsid) {
        String[] outputSlotNames = pCtx.getWorkstep(wsid).getOutputSlotsKeys();
        if (outputSlotNames == null || outputSlotNames.length == 0) {
            return null;
        }
        return this.getSlotValue(pCtx, wsid, outputSlotNames, false);
    }

    public WFDataslot getDataslot(WFProcessContext pCtx, long wsid, String dsName) throws BizLogicException {
        if (dsName.startsWith("@")) {
            Object value = this.getSystemPredefinedSlotValue(pCtx, wsid, dsName);
            if ("STARTTIME".equalsIgnoreCase(dsName = dsName.substring("@".length()))) {
                return new WFDataslot(dsName, "LONG", value, null, null);
            }
            if ("ALLDATASLOTS".equalsIgnoreCase(dsName)) {
                return new WFDataslot(dsName, "OBJECT", value, null, null);
            }
            return new WFDataslot(dsName, "STRING", value, null, null);
        }
        return pCtx.getDataslot(dsName);
    }

    public HashMap getSlotValue(WFProcessContext pCtx, long wsid, String[] dsNames, boolean isPublicOnly) {
        if (dsNames == null || dsNames.length == 0) {
            return null;
        }
        HashMap<String, Object> dsNameValues = new HashMap<String, Object>();
        WFDataslot ds = null;
        Vector<String> globalDSNames = new Vector<String>();
        Vector<String> instanceDSNames = new Vector<String>();
        ArrayList<String> extBODSList = new ArrayList<String>();
        for (int ix = 0; ix < dsNames.length; ++ix) {
            String dsName = dsNames[ix];
            if (dsName.startsWith("@")) {
                dsNameValues.put(dsName, this.getSystemPredefinedSlotValue(pCtx, wsid, dsName));
                continue;
            }
            ds = pCtx.getProcess().getDataslot(dsName);
            if (isPublicOnly && !ds.isPublic) {
                dsNameValues.put(dsName, "Not Public");
                continue;
            }
            if (ds.isValueMapped() && !ds.isValueMappedToCreator()) {
                dsNameValues.put(dsName, pCtx.getValueMappedSlotValue(dsName, (String)ds.getValue()));
                continue;
            }
            if (ds.isObject() && ds.isExternalBO()) {
                extBODSList.add(dsName);
                continue;
            }
            if (ds.isGlobal()) {
                globalDSNames.addElement(dsName);
                continue;
            }
            instanceDSNames.addElement(dsName);
        }
        long ptid = pCtx.getProcessTemplateID();
        long piid = pCtx.getProcessInstanceID();
        DAOContext daoCtx = BLUtil.self().getDAOContext(pCtx.getSession());
        HashMap tmp = DataSlotDAO.findByNameList(daoCtx, ptid, globalDSNames);
        if (tmp != null) {
            dsNameValues.putAll(tmp);
        }
        if ((tmp = DataSlotDAO.findByNameList(daoCtx, ptid, piid, instanceDSNames)) != null) {
            dsNameValues.putAll(tmp);
        }
        if (null != extBODSList && !extBODSList.isEmpty()) {
            BLBusinessObjectService.self().populateExtBODataslots(extBODSList, pCtx, dsNameValues);
        }
        return dsNameValues;
    }

    public HashMap getSlotValues(WFProcessContext pCtx, long wsid) {
        WFWorkstep ws = pCtx.getWorkstep(wsid);
        HashMap inputSlots = ws.getInputSlotsMapping();
        HashMap outputSlots = ws.getOutputSlotsMapping();
        HashMap dsNamesMap = new HashMap();
        dsNamesMap.putAll(inputSlots);
        dsNamesMap.putAll(outputSlots);
        String[] dsNames = BLUtil.getHashMapKeys(dsNamesMap);
        if (dsNames != null && dsNames.length != 0) {
            return this.getSlotValue(pCtx, wsid, dsNames, false);
        }
        return null;
    }

    public HashMap getSlotValues(WFProcessContext pCtx, long wsid, String[] dsNames) {
        if (dsNames == null || dsNames.length == 0) {
            return null;
        }
        for (int ix = 0; ix < dsNames.length; ++ix) {
            String dsName = dsNames[ix];
            WFWorkstep ws = pCtx.getWorkstep(wsid);
            if (ws.hasThisInput(dsName) || ws.hasThisOutput(dsName)) continue;
            throw new BizLogicException("BizLogic_ERR_1680", "WFWorkstepInstance.getSlotValues", new Object[]{dsName, pCtx.getProcessInstanceName() + " : " + ws.getName()});
        }
        return this.getSlotValue(pCtx, wsid, dsNames, false);
    }

    public void setSlotValues(WFProcessContext pCtx, long wsid, HashMap dsValues) {
        if (dsValues == null || dsValues.isEmpty()) {
            return;
        }
        for (String dsName : dsValues.keySet()) {
            WFWorkstep ws = pCtx.getWorkstep(wsid);
            if (ws.hasThisOutput(dsName)) continue;
            throw new BizLogicException("BizLogic_ERR_1701", "WFWorkstepInstance.setSlotValues", new Object[]{dsName, pCtx.getProcessInstanceName() + " : " + ws.getName()});
        }
        pCtx.updateSlotValue(dsValues);
    }

    private Object getSystemPredefinedSlotValue(WFProcessContext pCtx, long wsid, String dsName) {
        WFWorkstep ws = pCtx.getWorkstep(wsid);
        if (dsName.equalsIgnoreCase("@" + "WORKSTEPNAME")) {
            return ws.getName();
        }
        if (dsName.equalsIgnoreCase("@" + "PRIORITY")) {
            return SBMControl.util.getStringPriority(this.getPriority(pCtx, wsid));
        }
        if (dsName.equalsIgnoreCase("@" + "ALLDATASLOTS")) {
            return this.createCompleteDSlist(pCtx, wsid);
        }
        return pCtx.getSystemPredefinedSlotValue(dsName);
    }

    private HashMap createCompleteDSlist(WFProcessContext pCtx, long wsid) {
        HashMap hm = pCtx.createCompleteDSlist();
        WFWorkstep ws = pCtx.getWorkstep(wsid);
        hm.put("WORKSTEPNAME", ws.getName());
        hm.put("PRIORITY", SBMControl.util.getStringPriority(this.getPriority(pCtx, wsid)));
        return hm;
    }

    public Hashtable<String, DocumentDS> getDocumentsForInputDocDS(WFProcessContext pCtx, long wsid) {
        Hashtable<String, DocumentDS> inputDocDS = new Hashtable<String, DocumentDS>();
        String wsName = pCtx.getWorkstep(wsid).getName();
        String[] inputSlots = pCtx.getWorkstep(wsid).getInputSlotsKeys();
        if (inputSlots != null) {
            for (int i = 0; i < inputSlots.length; ++i) {
                WFDataslot ds = this.getDataslot(pCtx, wsid, inputSlots[i]);
                if (!ds.getType().equals("DOCUMENT")) continue;
                DocumentDS docDS = null;
                try {
                    docDS = (DocumentDS)pCtx.getSlotValue(ds.getName());
                    if (docDS == null) {
                        throw new BizLogicException("BizLogic_ERR_3064", "WFWorkstepInstance.getDocumentsForInputDocDS", BLDocService.getDebugMsg((long)pCtx.getProcessTemplateID(), (long)pCtx.getProcessInstanceID(), (String)ds.getName(), null));
                    }
                }
                catch (Exception ex) {
                    throw new BizLogicException("BizLogic_ERR_1554", "WFWorkstepInstance.getDocumentsForInputDocDS", new Object[]{wsName}, (Throwable)ex);
                }
                inputDocDS.put(ds.getName(), docDS);
            }
        }
        return inputDocDS;
    }

    public Hashtable<String, DocumentDS> getDocumentsForOutputDocDS(WFProcessContext pCtx, long wsid) {
        Hashtable<String, DocumentDS> outputDocDS = new Hashtable<String, DocumentDS>();
        String wsName = pCtx.getWorkstep(wsid).getName();
        String[] outputSlots = pCtx.getWorkstep(wsid).getOutputSlotsKeys();
        if (outputSlots != null) {
            for (int i = 0; i < outputSlots.length; ++i) {
                WFDataslot ds = this.getDataslot(pCtx, wsid, outputSlots[i]);
                if (!ds.getType().equals("DOCUMENT")) continue;
                DocumentDS docDS = null;
                try {
                    docDS = (DocumentDS)pCtx.getSlotValue(ds.getName());
                    if (docDS == null) {
                        throw new BizLogicException("BizLogic_ERR_3064", "WFWorkstepInstance.getDocumentsForOutputDocDS", BLDocService.getDebugMsg((long)pCtx.getProcessTemplateID(), (long)pCtx.getProcessInstanceID(), (String)ds.getName(), null));
                    }
                }
                catch (Exception ex) {
                    throw new BizLogicException("BizLogic_ERR_1554", "WFWorkstepInstance.getDocumentsForOutputDocDS", (Object[])new String[]{wsName}, (Throwable)ex);
                }
                outputDocDS.put(ds.getName(), docDS);
            }
        }
        return outputDocDS;
    }

    public void reactivate(WFProcessContext pCtx, String wsName) {
        long wsID = pCtx.getProcess().getWorkstep(wsName).getID();
        ProcessInstanceEBLocal piEB = pCtx.getProcessInstanceEB();
        if (!this.isValidRollbackState(pCtx, wsID)) {
            throw new BizLogicException("BizLogic_ERR_2529", "WFWorkstepInstance.reactivateWorkStep", new Object[]{piEB.getName(), wsName});
        }
        if (!pCtx.getWorkstep(wsID).isRollbackPoint()) {
            throw new BizLogicException("BizLogic_ERR_2530", "WFWorkstepInstance.reactivateWorkStep", new Object[]{piEB.getName(), wsName});
        }
        pCtx.forceSave();
        pCtx.suspendProcessInstance();
        pCtx.isCompProcess = true;
        this.suspendWorkStepsByCompensatory(pCtx, wsID);
        this.runCompProcesses(pCtx, wsID);
        this.replaceDSCopies(pCtx, wsID);
        pCtx.isCompProcess = false;
        pCtx.resumeProcessInstance();
        if (pCtx.isDebug()) {
            DebugService.self().addReactivateWS(pCtx, wsID);
            return;
        }
        pCtx.activateWorkstep(wsID);
    }

    private boolean isValidRollbackState(WFProcessContext pCtx, long wsid) {
        return pCtx.isWorkstepCompleted(wsid) || pCtx.isWorkstepSkipped(wsid) || pCtx.isWorkstepTerminated(wsid);
    }

    void suspendWorkStepsByCompensatory(WFProcessContext pCtx, long wsID) {
        String nodeVisited = this.getNodeVisited(pCtx);
        if (nodeVisited == null || nodeVisited.trim().isEmpty()) {
            throw new BizLogicException("Bizlogic_ERR_3685", "WFWorkStepInstance:suspendWorkStepsByCompensatory", new Object[]{pCtx.getProcessInstanceID(), wsID});
        }
        String forwardString = BLUtil.getSubNodeVisited((String)nodeVisited, (long)wsID, (boolean)true);
        StringTokenizer nodes = new StringTokenizer(forwardString, ";");
        while (nodes.hasMoreTokens()) {
            long id = Long.parseLong(nodes.nextToken());
            WorkStepInstanceEBLocal wsiEB = pCtx.getWorkstepInstanceEB(id);
            if (!this.isSuspended(pCtx, id)) continue;
            wsiEB.setSuspendedByCompensatory(true);
            wsiEB.save();
        }
    }

    void runCompProcesses(WFProcessContext pCtx, long rollbackToWsID) {
        String nodeVisited = this.getNodeVisited(pCtx);
        String forwardString = BLUtil.getSubNodeVisited((String)nodeVisited, (long)rollbackToWsID, (boolean)true);
        StringTokenizer nodes = new StringTokenizer(forwardString, ";");
        while (nodes.hasMoreTokens()) {
            long id = Long.parseLong(nodes.nextToken());
            if (this.isSkipped(pCtx, id)) {
                if (!BLControl.util.DEBUG_JSCRIPT) continue;
                BLControl.logger.debugKey("BizLogic_ERR_3229", new Object[]{pCtx.getProcessTemplateName(), pCtx.getWorkStepInstanceName(id)});
                continue;
            }
            if (id != rollbackToWsID) {
                this.removeDataslotCopies(pCtx, id);
            }
            this.executeScript(pCtx, id, "COMP");
        }
        ProcessInstanceEBLocal pieb = pCtx.getProcessInstanceEB();
        pieb.setNodeVisited(BLUtil.getSubNodeVisited((String)nodeVisited, (long)rollbackToWsID, (boolean)false));
    }

    private void replaceDSCopies(WFProcessContext pCtx, long wsID) {
        WorkStepInstanceEBLocal wsiEB = pCtx.getWorkstepInstanceEB(wsID);
        HashMap dsCopies = wsiEB.getDataSlotCopies();
        if (dsCopies == null) {
            BLControl.logger.debugKey("BizLogic_ERR_9152", new Object[]{pCtx.getProcessTemplateName(), pCtx.getProcessInstanceID(), pCtx.getWorkStepInstanceName(wsID)});
            return;
        }
        pCtx.updateSlotValue(dsCopies);
    }

    public String getNodeVisited(WFProcessContext pCtx) {
        return pCtx.getProcessInstanceEB().getNodeVisited();
    }

    public void addNodeVisited(WFProcessContext pCtx, String id) {
        Vector wsNames;
        if (id == null || id.length() == 0) {
            throw new BizLogicException("BizLogic_ERR_2566", "WFWorkstepInstance.addNodeVisited", new Object[]{pCtx.getProcessInstanceEB().getName(), "null"});
        }
        String nv = BLUtil.addNode((String)this.getNodeVisited(pCtx), (String)id);
        if (BLControl.util.DEBUG_ENGINE && (wsNames = pCtx.getWorkStepExecutedList(nv)) != null) {
            String names = wsNames.toString();
            BLControl.logger.debug((Object)("\nVisited Worksteps in Process Instance <" + pCtx.getProcessInstanceEB().getName() + ">:\n " + names + "\n"));
        }
        pCtx.getProcessInstanceEB().setNodeVisited(nv);
    }

    public boolean isSuspendedByCompensatory(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid, true);
        if (wsieb == null) {
            return false;
        }
        return wsieb.isSuspendedByCompensatory();
    }

    public void setSuspendedByCompensatory(WFProcessContext pCtx, long wsid, boolean flag) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        wsieb.setSuspendedByCompensatory(flag);
    }

    public void resumeWorkStepInstances(long[] ptids, int[] wsTypes) {
        int[] nArray = new int[1];
        nArray[0] = 16;
        List attrsList = BLUtil.getServiceLocal().getWorkStepInstanceList(ptids, null, nArray, wsTypes, null, false);
        for (int ix = 0; ix < attrsList.size(); ++ix) {
            HashMap attrs = (HashMap)attrsList.get(ix);
            long wsid = (Long)attrs.get("WORKSTEPID");
            long piid = (Long)attrs.get("PROCESSINSTANCEID");
            WFProcessContext pCtx = new WFProcessContext(BLControl.getServerSession(), piid);
            BLUtil.getServiceLocal().resumeWorkstep(pCtx, wsid);
        }
    }

    private HashMap getDataslotCopies(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        return wsieb.getDataSlotCopies();
    }

    private void removeDataslotCopies(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        wsieb.setDataSlotCopies(null);
    }

    private WorkStepInstanceEBLocal getWSInstance(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid, true);
        if (wsieb == null) {
            wsieb = BLControl.util.isCreateWSInstanceInNewTx() ? BLUtil.getServiceLocal().createInstance(pCtx, wsid) : this.createInstance(pCtx, wsid);
        }
        return wsieb;
    }

    void createAllInstances(WFProcessContext pCtx) {
        WFProcess pt = pCtx.getProcess();
        Vector wss = pt.getWorksteps();
        int size = wss.size();
        for (int ix = 0; ix < size; ++ix) {
            WFWorkstep ws = (WFWorkstep)wss.get(ix);
            this.create(pCtx, ws.getID());
        }
        pt = null;
        wss = null;
    }

    public void setActualPerformer(WFProcessContext pCtx, long wsid, String actperf) {
        if (actperf != null && actperf.length() > BLControl.util.MAX_PERFORMER_SIZE) {
            String piName = pCtx.getProcessInstanceName();
            String wsName = pCtx.getWorkstep(wsid).getName();
            BLControl.logger.warnKey("BizLogic_ERR_865", new Object[]{actperf, wsName, piName, String.valueOf(BLControl.util.MAX_PERFORMER_SIZE)});
            actperf = actperf.substring(0, BLControl.util.MAX_PERFORMER_SIZE);
        }
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        wsieb.setActualPerformer(actperf);
    }

    protected HashMap getProcessContextData(WFProcessContext pCtx, long wsid) {
        String piName = pCtx.getProcessInstanceName();
        WFProcess pt = pCtx.getProcess();
        String ptName = pt.getName();
        WFWorkstep ws = pt.getWorkstep(wsid);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("PROCESSTEMPLATEID", pt.getID());
        context.put("PROCESSTEMPLATENAME", ptName);
        context.put("PROCESSINSTANCEID", pCtx.getProcessInstanceID());
        context.put("PROCESSINSTANCENAME", piName);
        context.put("WORKSTEPID", wsid);
        context.put("WORKSTEPNAME", ws.getName());
        return context;
    }

    public Collection getActiveWSInstanceList() {
        Vector wsList = WorkStepInstanceDAO.getPKListForRestartExternalService();
        return wsList;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void activateOnServerStart(Vector wspkList) {
        if (wspkList == null || wspkList.isEmpty()) {
            return;
        }
        count = 0;
        wsDetails = null;
        BLControl.logger.infoKey("BizLogic_ERR_2142", new Object[]{wspkList.size()});
        enumeration = wspkList.elements();
        while (enumeration.hasMoreElements()) {
            wsDetails = (long[])enumeration.nextElement();
            piid = wsDetails[0];
            wsid = wsDetails[1];
            wsState = (int)wsDetails[2];
            wsType = (int)wsDetails[3];
            if (wsState != 18) ** GOTO lbl-1000
            if (wsType == 107) ** GOTO lbl-1000
            if (wsType == 109) lbl-1000:
            // 2 sources

            {
                BLUtil.getServiceLocal().activateOnServerStart(piid, wsid, wsState);
            } else if (WFWorkstepInstance.hasRequiredMessageCount(ws = (pCtx = new WFProcessContext(BLControl.getServerSession(), piid)).getWorkstep(wsid), messageCountInDB = BLMessagesDAO.getMessageCount(piid, wsid))) {
                BLUtil.getServiceLocal().activateOnServerStart(piid, wsid, wsState);
            }
            if (++count % 200 != 0) continue;
            BLControl.logger.infoKey("BizLogic_ERR_2143", new Object[]{count});
        }
        BLControl.logger.infoKey("BizLogic_ERR_2144");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doActivateOnServerStart(long piid, long wsid, int wsState) {
        WFProcessContext pCtx = new WFProcessContext(BLControl.getServerSession(), piid);
        WFWorkstep ws = pCtx.getWorkstep(wsid);
        int type = ws.getType();
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debugKey("BizLogic_ERR_2135", new Object[]{ws.getName(), pCtx.getProcessInstanceName()});
        }
        if (wsState == 18) {
            if (type == 107) {
                WFExternalInstance.self().execute(pCtx, wsid);
                return;
            }
        }
        if (wsState == 18) {
            if (type == 109) {
                WFWebServiceInstance.self().sendMessage(pCtx, wsid);
                return;
            }
        }
        WFMessageSubscriberInstance.self().sendMessage(pCtx, wsid);
    }

    protected final void forceSave(WFProcessContext pCtx, WorkStepInstanceEBLocal wsieb) {
        if (pCtx.isCompleteCaller()) {
            WFWorkstep ws = pCtx.getWorkstep(wsieb.getId());
            if (ws.isNextEndWS()) {
                wsieb.save();
            }
        } else if (pCtx.isCompProcessRunning()) {
            wsieb.save();
        }
    }

    public boolean workstepReady(long piid, long wsid) {
        int dura = 0;
        boolean firstTime = true;
        while ((long)dura < BLUtil.self().getMsgRetryMaxTime()) {
            try {
                if (BLControl.util.isSleepFirst() && firstTime) {
                    Thread.sleep(BLControl.util.SLEEP_FIRST_INTERVAL);
                    firstTime = false;
                }
                if (WFWorkstepInstance.single().isActivated(piid, wsid)) {
                    return true;
                }
                Thread.sleep(BLUtil.self().getMsgRetryInterval());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            dura = (int)((long)dura + BLUtil.self().getMsgRetryInterval());
        }
        try {
            if (WFWorkstepInstance.single().isCompleted(piid, wsid)) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public void rePublishMsg(String type, String destination, HashMap message) {
        long piid = -1L;
        long wsid = -1L;
        try {
            piid = (Long)message.get("PROCESSINSTANCEID");
            wsid = (Long)message.get("WORKSTEPID");
            BLConstants.ClusterConstants cfr_ignored_0 = BLControl.consts.cluster;
            int repeatMsgCount = (Integer)message.get("REPEAT_MSG_COUNT");
            BLControl.logger.warnKey("BizLogic_ERR_1008", new Object[]{piid, wsid, repeatMsgCount});
            if (repeatMsgCount > BLControl.util.getMsgRetryMaxCount()) {
                BLControl.logger.errorKey("BizLogic_ERR_928", new Object[]{BLControl.util.getMsgRetryMaxCount(), piid, wsid, "WFWorkstepInstance.republish()"});
                return;
            }
            if (message != null) {
                message.put("TYPE", type);
                BLConstants.ClusterConstants cfr_ignored_1 = BLControl.consts.cluster;
                message.put("REPEAT_MSG_COUNT", ++repeatMsgCount);
            }
            BLJMSService.self().sendMessage(destination, (Object)"", 1, message);
        }
        catch (Exception ex) {
            throw new BizLogicException("BizLogic_ERR_3116", "WFWorkstepInstance.rePublishMsg()", new Object[]{piid, wsid, type, destination}, (Throwable)ex);
        }
    }

    public void resendMessage(String useName, Message message, boolean isChannelName) {
        try {
            if (isChannelName) {
                BLJMSService.self().sendMessage(useName, (Object)message, 6, null);
            } else {
                Destination dest = BLJMSService.self().lookupDestination(useName);
                BLJMSService.self().sendMessage(dest, message);
            }
        }
        catch (Throwable th) {
            throw new RuntimeException("Cannot resend the message for " + useName + " due to " + SBMUtil.getStackTrace((Throwable)th));
        }
    }

    boolean processMessage(Message msg, String useName, boolean isChannelName) {
        if (BLControl.isServerReady()) {
            return true;
        }
        for (int retries = 0; retries < 3; ++retries) {
            try {
                Thread.currentThread();
                Thread.sleep(1000 * BLUtil.getServerStateRetryInterval());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!BLControl.isServerReady()) continue;
            return true;
        }
        if (!BLControl.isServerReady()) {
            this.resendMessage(useName, msg, isChannelName);
            return false;
        }
        return true;
    }

    public boolean isRemoteSubProcess(WFProcessContext pCtx, long wsid) {
        String performer = this.getRealPerformer(pCtx, wsid);
        return this.isRemoteSubProcess(performer);
    }

    public boolean isRemoteSubProcess(String performer) {
        block2: {
            block3: {
                if (performer == null) break block2;
                if (performer.startsWith("b2b://")) break block3;
                if (!performer.startsWith("jndi://")) break block2;
            }
            return true;
        }
        return false;
    }

    protected final String getStateDescription(WFProcessContext pCtx, long wsid) {
        int state = WorkStepInstanceDAO.getWorkstepState(pCtx.getProcessInstanceID(), wsid);
        return BLConstants.single().wfStates[state];
    }

    void validateCompletion(WFProcessContext pCtx, long wsid) {
        if (!this.isActivated(pCtx, wsid)) {
            if (pCtx.getWorkstep(wsid).isMonitorStep() && this.isEventActivationWaitState(pCtx, wsid)) {
                return;
            }
            throw new BizLogicException("BizLogic_ERR_814", "WFWorkstepInstance.validateCompletion", new Object[]{pCtx.getProcessInstanceID(), pCtx.getWorkstep(wsid).getName()});
        }
    }

    public void completeCallerWorkstep(WFProcessContext pCtx, long wsid, HashMap dsValues) {
        String piName = pCtx.getProcessInstanceName();
        String wsName = pCtx.getWorkstep(wsid).getName();
        if (pCtx.isWorkstepCompleted(wsid)) {
            throw new BizLogicException("BizLogic_ERR_2690", "WFWorkstepInstance.completeCallerWorkStep", new Object[]{piName + COLON + wsName});
        }
        if (dsValues != null && !dsValues.isEmpty()) {
            pCtx.setCurrentWorkStepID(wsid);
            pCtx.updateSlotValue(dsValues);
        } else {
            pCtx.lockRootOrInstanceDS(BLLockContext.WS, "WFWorkstepInstance.completeCallerWorkStep", wsid);
        }
    }

    public long getRealDuration(WFProcessContext pCtx, WFWorkstep ws) {
        long duration = 0L;
        String mappedDuration = ws.getMappedDuration();
        if (BLUtil.isParameter((String)mappedDuration)) {
            String dsName = BLUtil.getParameter((String)mappedDuration);
            Long dsValue = (Long)pCtx.getSlotValue(dsName);
            if (dsValue == null) {
                duration = BLUtil.self().getDefaultWSDuration();
                BLControl.logger.warnKey("Bizlogic_ERR_3811", "WFWorkstepInstance.getRealDuration", new Object[]{pCtx.getProcessInstanceName(), ws.getName(), dsName, String.valueOf(duration)});
            } else {
                duration = dsValue;
                if (duration > BLUtil.self().getMaxWorkstepDuration()) {
                    throw new BizLogicException("BizLogic_ERR_687", "WFWorkstepInstance:getRealDuration", new Object[]{duration, ws.getName(), pCtx.getProcessTemplateName(), BLUtil.self().getMaxWorkstepDuration()});
                }
            }
        } else {
            duration = ws.getDuration();
        }
        if (duration <= 0L) {
            duration = ws.isPrimaryWS() ? BLUtil.self().getDefaultWSDuration() : 0L;
        }
        return duration;
    }

    public long getDuration(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = this.getWSInstance(pCtx, wsid);
        return wsieb.getDuration();
    }

    public static boolean hasRequiredMessageCount(WFWorkstep ws, HashMap msgCountsInDB) {
        MessageSubscriptionList msgSubscriptionList = ws.getMessageSubscriptionList();
        boolean waitForAll = msgSubscriptionList.isWaitForAllMessages();
        List msgList = msgSubscriptionList.getSubscribedMessages();
        Integer dbCountObject = null;
        int messagesReceivedCorrectly = 0;
        for (int ix = 0; ix < msgList.size(); ++ix) {
            MessageSubscription msgSubscr = (MessageSubscription)msgList.get(ix);
            String msgName = msgSubscr.getMessageName();
            int reqdCount = msgSubscr.getMessageCount();
            dbCountObject = (Integer)msgCountsInDB.get(msgName);
            int countInDB = dbCountObject == null ? 0 : dbCountObject;
            if (countInDB < reqdCount) continue;
            ++messagesReceivedCorrectly;
        }
        if (waitForAll && messagesReceivedCorrectly == msgList.size()) {
            return true;
        }
        return !waitForAll && messagesReceivedCorrectly > 0;
    }

    private boolean isWorkStepSubscribedToAnyMessage(WFWorkstep ws) {
        return ws.getMessageSubscriptionList().isSubscribedToAnyMessage();
    }

    public void setAttributes(Session session, List<Map<String, Object>> modifiedAttrsList, boolean isMultiTrans) {
        if (modifiedAttrsList == null || modifiedAttrsList.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4621", "WFWorkStepInstance.setAttributes()", new Object[]{"save", "workstep instances"});
        }
        for (Map<String, Object> attrMap : modifiedAttrsList) {
            if (attrMap == null || attrMap.isEmpty()) continue;
            if (isMultiTrans) {
                BLUtil.getServiceLocal().updateWorkStepInstanceAttributes(session, attrMap);
                continue;
            }
            this.setAttributes(session, attrMap);
        }
    }

    public void setAttributes(Session session, Map<String, Object> attrMap) {
        if (attrMap == null || attrMap.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4622", "WFWorkStepInstance.setAttributes(s, attrMap)");
        }
        Long piid = (Long)attrMap.remove("PROCESSINSTANCEID");
        Long wsid = (Long)attrMap.remove("WORKSTEPID");
        String wsName = (String)attrMap.remove("WORKSTEPNAME");
        if (piid == null || wsid == null && wsName == null) {
            throw new BizLogicException("BizLogic_ERR_4617", "WFWorkStepInstance.setAttributes()", new Object[]{piid, wsid, wsName, "attributes"});
        }
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        if (wsid == null) {
            wsid = pCtx.getWorkStepInstanceID(wsName);
        }
        this.setAttributes(pCtx, wsid, attrMap);
    }

    public void setAttributes(WFProcessContext pCtx, long wsid, Map attributes) {
        if (attributes == null || attributes.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4620", "WFWorkStepInstance.setAttributes()", new Object[]{pCtx.getProcessInstanceID(), pCtx.getWorkStepInstanceName(wsid)});
        }
        Map.Entry entry2 = null;
        String key = null;
        Object value = null;
        for (Map.Entry entry2 : attributes.entrySet()) {
            key = (String)entry2.getKey();
            value = entry2.getValue();
            if (key.equalsIgnoreCase("PRIORITY")) {
                this.setPriority(pCtx, wsid, value);
                continue;
            }
            if (key.equalsIgnoreCase("PERFORMER")) {
                this.setPerformer(pCtx, wsid, value);
                continue;
            }
            if (key.equalsIgnoreCase("DUEDATE")) {
                this.setDuedate(pCtx, wsid, (Long)value, false);
                continue;
            }
            if (key.equalsIgnoreCase("INSTRUCTION")) {
                this.setInstruction(pCtx, wsid, (String)value);
                continue;
            }
            if (key.equalsIgnoreCase("SUBPIID")) {
                this.setSubProcessInstanceID(pCtx, wsid, (Long)value);
                continue;
            }
            if (key.equalsIgnoreCase("ACTIVATIONTIME")) {
                this.setActivationTime(pCtx, wsid, (Long)value);
                continue;
            }
            if (key.equalsIgnoreCase("MILESTONE_DESC")) continue;
            if (key.equalsIgnoreCase("MILESTONE_NAME")) continue;
            throw new BizLogicException("BizLogic_ERR_1507", "WFWorkstepInstance.setAttributes", new Object[]{"WorkStepInstance", pCtx.getProcessInstanceID(), key});
        }
    }

    public ResultData<List<Map<String, Object>>> resumeByClient(Session session, List<Map<String, Object>> wsList, boolean isMultiTrans) {
        if (wsList == null || wsList.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4621", "WFWorkStepInstance.resumeByClient()", new Object[]{"resume", "workstep instances"});
        }
        ArrayList<Map<String, Object>> validWSList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> wsAttrs : wsList) {
            if (wsAttrs == null || wsAttrs.isEmpty()) continue;
            try {
                if (isMultiTrans) {
                    BLUtil.getServiceLocal().resumeWorkStepByClient(session, wsAttrs);
                } else {
                    this.resumeByClient(session, wsAttrs);
                }
                validWSList.add(wsAttrs);
            }
            catch (Throwable th) {
                if (isMultiTrans) {
                    return new ResultData(validWSList, th, wsAttrs);
                }
                throw new BizLogicException("BizLogic_ERR_4672", "WFWorkstepInstance.resumeByClient(Session,List,boolean)", new Object[]{"WorkStep resume", "workStep", wsAttrs}, th);
            }
        }
        return new ResultData();
    }

    public void resumeByClient(Session session, Map<String, Object> wsAttrs) {
        if (wsAttrs == null || wsAttrs.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4622", "WFWorkStepInstance.resume(s, wsAttrs)");
        }
        Long piid = (Long)wsAttrs.get("PROCESSINSTANCEID");
        Long wsid = (Long)wsAttrs.get("WORKSTEPID");
        String wsName = (String)wsAttrs.get("WORKSTEPNAME");
        if (piid == null || wsid == null && wsName == null) {
            throw new BizLogicException("BizLogic_ERR_4617", "WFWorkStepInstance.resume()", new Object[]{piid, wsid, wsName, "status"});
        }
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        if (wsid == null) {
            wsid = pCtx.getWorkStepInstanceID(wsName);
        }
        this.resumeByClient(pCtx, wsid);
    }

    public void resumeByClient(WFProcessContext pCtx, long wsid) {
        if (pCtx.getProcessInstanceEB().isSuspended()) {
            throw new BizLogicException("BizLogic_ERR_1675", "WFWorkStepInstance.resume()", new Object[]{pCtx.getWorkStepInstanceName(wsid), pCtx.getProcessInstanceName()});
        }
        BLLockDAO.workstepInstance(pCtx.getProcessInstanceID(), wsid, "WorkStepInstanceSBBean.resume");
        WFWorkstepInstance.getWorkstepInstance(pCtx.getWorkstep(wsid).getType()).resume(pCtx, wsid);
    }

    public ResultData<List<Map<String, Object>>> suspendByClient(Session session, List<Map<String, Object>> wsList, boolean isMultiTrans) {
        if (wsList == null || wsList.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4621", "WFWorkStepInstance.suspendByClient()", new Object[]{"suspend", "workstep instances"});
        }
        ArrayList<Map<String, Object>> validWSList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> wsAttrs : wsList) {
            if (wsAttrs == null || wsAttrs.isEmpty()) continue;
            try {
                if (isMultiTrans) {
                    BLUtil.getServiceLocal().suspendWorkStepByClient(session, wsAttrs);
                } else {
                    this.suspendByClient(session, wsAttrs, true);
                }
                validWSList.add(wsAttrs);
            }
            catch (Throwable th) {
                if (isMultiTrans) {
                    return new ResultData(validWSList, th, wsAttrs);
                }
                throw new BizLogicException("BizLogic_ERR_4672", "WFWorkstepInstance.suspendByClient(Session,List,boolean)", new Object[]{"WorkStep suspend", "workStep", wsAttrs}, th);
            }
        }
        return new ResultData();
    }

    public void suspendByClient(Session session, Map<String, Object> wsAttrs, boolean isBulkOperation) {
        WFWorkstep workstep;
        if (wsAttrs == null || wsAttrs.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4622", "WFWorkStepInstance.suspend(s, wsAttrs)");
        }
        Long piid = (Long)wsAttrs.get("PROCESSINSTANCEID");
        Long wsid = (Long)wsAttrs.get("WORKSTEPID");
        String wsName = (String)wsAttrs.get("WORKSTEPNAME");
        if (piid == null || wsid == null && wsName == null) {
            throw new BizLogicException("BizLogic_ERR_4617", "WFWorkStepInstance.suspend()", new Object[]{piid, wsid, wsName, "status"});
        }
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        if (wsid == null) {
            wsid = pCtx.getWorkStepInstanceID(wsName);
        }
        if ((workstep = pCtx.getProcess().getWorkstep(wsid)).isConnectorWS()) {
            throw new BizLogicException("BizLogic_ERR_3766", "WFWorkStepInstance.suspendByClient(s, wsList)", new Object[]{"suspend", workstep.getName(), BLUtil.getStringWSType((int)workstep.getType()), piid});
        }
        this.suspendByClient(pCtx, wsid, isBulkOperation);
    }

    public void suspendByClient(WFProcessContext pCtx, long wsid, boolean isBulkOperation) {
        int state;
        int type;
        block17: {
            block18: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                type = pCtx.getWorkstep(wsid).getType();
                                state = pCtx.getWorkstepInstanceEB(wsid).getState();
                                if (state == 16 && isBulkOperation) {
                                    BLControl.logger.warnKey("BizLogic_ERR_1669", new Object[]{pCtx.getWorkstep(wsid).getName(), pCtx.getProcessInstanceName()});
                                    return;
                                }
                                if (state == 61) break block13;
                                if (state == 91) break block13;
                                if (state != 62) break block14;
                            }
                            WFWorkstepInstance.getWorkstepInstance(type).suspend(pCtx, wsid, false, null, null);
                            return;
                        }
                        if (type == 102) break block15;
                        if (type != 108) break block16;
                    }
                    if (state == 18) {
                        WFWorkstepInstance.getWorkstepInstance(type).suspend(pCtx, wsid, false, null, null);
                        return;
                    }
                }
                if (type == 110) {
                    if (state == 60) {
                        WFWorkstepInstance.getWorkstepInstance(type).suspend(pCtx, wsid, false, null, null);
                        return;
                    }
                }
                if (!pCtx.getWorkstep(wsid).isMonitorStep()) break block17;
                if (state == 91) break block18;
                if (state != 18) break block17;
            }
            WFWorkstepInstance.getWorkstepInstance(type).suspend(pCtx, wsid, false, null, null);
            return;
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = pCtx.getWorkStepInstanceName(wsid);
        objectArray[1] = pCtx.getProcessInstanceName();
        BLUtil.self();
        objectArray[2] = BLUtil.getStringWSType((int)type);
        objectArray[3] = BLConstants.single().wfStates[state];
        throw new BizLogicException("BizLogic_ERR_1671", "WFWorkstepInstance.suspend()", objectArray);
    }

    public ResultData<List<Map<String, Object>>> skipByClient(Session session, List<Map<String, Object>> wsList, boolean isMultiTrans) {
        if (wsList == null || wsList.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4621", "WFWorkStepInstance.skipByClient()", new Object[]{"skip", "workstep instances"});
        }
        ArrayList<Map<String, Object>> validWSList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> wsAttrs : wsList) {
            if (wsAttrs == null || wsAttrs.isEmpty()) continue;
            try {
                if (isMultiTrans) {
                    BLUtil.getServiceLocal().skipWorkStepByClient(session, wsAttrs);
                } else {
                    this.skipByClient(session, wsAttrs);
                }
                validWSList.add(wsAttrs);
            }
            catch (Throwable th) {
                if (isMultiTrans) {
                    return new ResultData(validWSList, th, wsAttrs);
                }
                throw new BizLogicException("BizLogic_ERR_4672", "WFWorkstepInstance.skipByClient(Session,List,boolean)", new Object[]{"WorkStep skip", "workStep", wsAttrs}, th);
            }
        }
        return new ResultData();
    }

    public void skipByClient(Session session, Map<String, Object> wsAttrs) {
        if (wsAttrs == null || wsAttrs.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4622", "WFWorkStepInstance.skipByClient(s, wsAttrs)");
        }
        Long piid = (Long)wsAttrs.get("PROCESSINSTANCEID");
        Long wsid = (Long)wsAttrs.get("WORKSTEPID");
        String wsName = (String)wsAttrs.get("WORKSTEPNAME");
        if (piid == null || wsid == null && wsName == null) {
            throw new BizLogicException("BizLogic_ERR_4617", "WFWorkStepInstance.skipByClient()", new Object[]{piid, wsid, wsName, "skip"});
        }
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        if (wsid == null) {
            wsid = pCtx.getWorkStepInstanceID(wsName);
        }
        this.skipByClient(pCtx, wsid);
    }

    public void skipByClient(WFProcessContext pCtx, long wsid) {
        int type = pCtx.getWorkstep(wsid).getType();
        if (type != 102) {
            if (type != 111) {
                if (type != 110) {
                    if (type != 107) {
                        throw new BizLogicException("BizLogic_ERR_4625", "WFWorkstepInstance.skip()", new Object[]{type, pCtx.getWorkStepInstanceName(wsid), pCtx.getProcessInstanceName()});
                    }
                }
            }
        }
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        int state = wsieb.getState();
        if (state != 16) {
            if (state != 60) {
                throw new BizLogicException("BizLogic_ERR_4626", "WFWorkstepInstance.skip()", new Object[]{state, pCtx.getWorkStepInstanceName(wsid), pCtx.getProcessInstanceName()});
            }
        }
        WFWorkstepInstance.getWorkstepInstance(type).skip(pCtx, wsid);
    }

    public ResultData<List<Map<String, Object>>> completeByClient(Session session, List<Map<String, Object>> wsList, boolean isMultiTrans) {
        if (wsList == null || wsList.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4622", "WFWorkStepInstance.completeByClient(s, wsList)");
        }
        ArrayList<Map<String, Object>> validWSList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> ws : wsList) {
            if (ws == null) continue;
            BLConstants.single();
            if (!ws.containsKey("PROCESSINSTANCEID")) continue;
            BLConstants.single();
            if (!ws.containsKey("WORKSTEPID")) continue;
            BLConstants.single();
            long piid = (Long)ws.get("PROCESSINSTANCEID");
            BLConstants.single();
            long wsid = (Long)ws.get("WORKSTEPID");
            try {
                if (isMultiTrans) {
                    BLUtil.getServiceLocal().completeWorkstep(session, piid, wsid);
                } else {
                    this.completeByClient(session, piid, wsid);
                }
                validWSList.add(ws);
            }
            catch (Throwable th) {
                if (isMultiTrans) {
                    return new ResultData(validWSList, th, ws);
                }
                throw new BizLogicException("BizLogic_ERR_4672", "WFWorkstepInstance.completeByClient(Session,List,boolean)", new Object[]{"WorkStep complete", "workStep", ws}, th);
            }
        }
        return new ResultData();
    }

    public void completeByClient(Session session, long piid, long wsid) {
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        WFWorkstep workstep = pCtx.getProcess().getWorkstep(wsid);
        if (workstep.isConnectorWS()) {
            throw new BizLogicException("BizLogic_ERR_3766", "WFWorkStepInstance.completeByClient(s, piid, wsid)", new Object[]{"complete", workstep.getName(), BLUtil.getStringWSType((int)workstep.getType()), piid});
        }
        pCtx.completeWorkstep(wsid);
    }

    protected void skip(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        wsieb.setState(63);
        long endTime = System.currentTimeMillis();
        wsieb.setTimeCompleted(endTime);
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debugKey("BizLogic_ERR_4628", "WFWorkstepInstance.skip", new Object[]{pCtx.getProcessInstanceName(), pCtx.getWorkstep(wsid).getName(), pCtx.getWorkstep(wsid).getType()});
        }
        BLUtil.fireEvent(this.getEventContext(pCtx, wsid, 63), (int)63);
        this.activateNextWorksteps(pCtx, wsid);
    }

    private void terminatePreWsToXOR(WFProcessContext pCtx, long wsid) {
        this.terminate(pCtx, wsid);
        pCtx.getXORHelper().removeFromTerminationList(wsid);
        BLControl.logger.infoKey("BizLogic_ERR_4106", "WFWorkstepInstance.terminatePreWsToXOR()", new Object[]{pCtx.getWorkStepInstanceName(wsid), pCtx.getProcessInstanceName()});
    }

    private void createWaitEvent(WFProcessContext pCtx, long wsid, boolean waitForActivate) {
        block9: {
            WorkStepInstanceEBLocal wsieb;
            String monitorIdValue;
            block8: {
                pCtx.getWorkstep(wsid);
                monitorIdValue = WFDataSlotInstance.self().getMonitorDSValue(pCtx);
                wsieb = pCtx.getWorkstepInstanceEB(wsid);
                if (monitorIdValue != null && monitorIdValue.trim().length() != 0 && !"<NULL>".equalsIgnoreCase(monitorIdValue.trim())) {
                    if (SMPConfig.self().isUpdateEventForWaitWS() && !SMPConfig.self().isProcessExtEventFromBL()) {
                        this.updateExternalEvent(pCtx, wsid, monitorIdValue);
                    }
                } else {
                    monitorIdValue = null;
                }
                if (wsieb.getState() == 91) break block8;
                if (wsieb.getState() != 18) break block9;
            }
            if (wsieb.getPreviousState() != 16) {
                this.createMonitorWaitWorksStep(pCtx, wsid, monitorIdValue, waitForActivate);
            }
        }
    }

    private void updateExternalEvent(WFProcessContext pCtx, long wsid, String monitorIdValue) {
        WFWorkstep ws = pCtx.getWorkstep(wsid);
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        HashMap<String, Object> modifiedAttrs = new HashMap<String, Object>();
        modifiedAttrs.put("BL_PROCESS_TEMPLATE_ID", pCtx.getProcessTemplateID());
        modifiedAttrs.put("BL_PROCESS_INSTANCE_ID", pCtx.getProcessInstanceID());
        modifiedAttrs.put("BL_WORKSTEP_ID", wsid);
        modifiedAttrs.put("BL_LOOP_COUNTER", wsieb.getLoopCounter());
        modifiedAttrs.put("READY_TO_PROCESS", 1);
        MPService.self().getPersistenceService().updateEvent(pCtx.getProcessTemplateName(), monitorIdValue, ws.getName(), wsieb.getLoopCounter(), modifiedAttrs);
    }

    private void createMonitorWaitWorksStep(WFProcessContext pCtx, long wsid, String monitorIdValue, boolean waitForActivate) {
        WFWorkstep ws = pCtx.getWorkstep(wsid);
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        HashMap<String, Object> attrsList = new HashMap<String, Object>();
        attrsList.put("PROCESS_INSTANCE_ID", pCtx.getProcessInstanceID());
        attrsList.put("WORKSTEP_ID", wsid);
        attrsList.put("LOOP_COUNTER", wsieb.getLoopCounter());
        attrsList.put("PROCESS_TEMPLATE_NAME", pCtx.getProcessTemplateName());
        attrsList.put("EXTERNAL_INSTANCE_ID", monitorIdValue);
        attrsList.put("WORKSTEP_NAME", ws.getName());
        attrsList.put("PROCESS_TEMPLATE_ID", pCtx.getProcessTemplateID());
        attrsList.put("WAIT_FOR_ACTIVATEEVENT", SBMConstants.Boolean.fromValue((boolean)ws.isWaitForActivateEvent()).intValue());
        MPService.self().getPersistenceService().storeMonitorWaitWorkStep(attrsList);
    }

    private void setDefaultPerformer(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        int n = wsieb.getType();
        BLConstants.single();
        if (n == 102) {
            String defaultPerf = pCtx.getDefaultPerformer(wsid);
            if (defaultPerf == null || defaultPerf.trim().length() == 0) {
                defaultPerf = BMBootProps.self().getUser();
                BLControl.logger.warnKey("BizLogic_ERR_4836", "WFWorkstepInstance.setDefaultPerformer", new Object[]{pCtx.getProcessInstanceName(), pCtx.getWorkstep(wsid).getName(), defaultPerf});
            }
            wsieb.setPerformer(defaultPerf);
            wsieb.setActualPerformer(defaultPerf);
            if (BLControl.util.DEBUG_MONITORING) {
                BLControl.logger.debugKey("BizLogic_ERR_4305", "WFWorkstepInstance.setDefaultPerformer", new Object[]{pCtx.getProcessInstanceName(), pCtx.getWorkstep(wsid).getName(), defaultPerf});
            }
        } else {
            BLConstants.single();
            wsieb.setPerformer("MONITOR_ADAPTER");
            BLConstants.single();
            wsieb.setActualPerformer("MONITOR_ADAPTER");
            if (BLControl.util.DEBUG_MONITORING) {
                Object[] objectArray = new Object[3];
                objectArray[0] = pCtx.getProcessInstanceName();
                objectArray[1] = pCtx.getWorkstep(wsid).getName();
                BLConstants.single();
                objectArray[2] = "MONITOR_ADAPTER";
                BLControl.logger.debugKey("BizLogic_ERR_4305", "WFWorkstepInstance.setDefaultPerformer", objectArray);
            }
        }
    }

    private static class WFWorkstepRunItParams {
        private final String processTemplateName;
        private final String wsName;
        private final String piName;
        private String wsID;

        private WFWorkstepRunItParams(WFProcessContext context, WFWorkstep wfWorkstep) {
            this.processTemplateName = context.getProcessTemplateName();
            this.wsName = wfWorkstep.getName();
            this.piName = context.getProcessInstanceName();
        }
    }
}

