/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.dao;

import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.DBConstants;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SubProcessDAO
extends BLDAOService {
    private static final String[] CREATE_LIST;
    private static final String[] LOAD_TABLELIST;
    public static String createSubProcessInstance;
    public static String findByProcessInstance;
    public static String findByWorkstepInstance;
    public static String removeByProcessInstance;
    public static String removeByWorkstepInstance;
    public static String removeBySubProcessInstance;
    public static String findBySubProcessInstance;
    public static String getCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(long piid, String piName, long wsid, String wsName, long subpiid, long subptid, boolean isRemote, String appServerID) {
        Connection conn = null;
        PreparedStatement pstmtCreateSubProcessInstance = null;
        try {
            conn = SubProcessDAO.getConnection();
            pstmtCreateSubProcessInstance = conn.prepareStatement(createSubProcessInstance);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", createSubProcessInstance, new Object[0]);
            }
            int count = 1;
            pstmtCreateSubProcessInstance.setLong(count++, piid);
            pstmtCreateSubProcessInstance.setString(count++, piName);
            pstmtCreateSubProcessInstance.setLong(count++, wsid);
            pstmtCreateSubProcessInstance.setString(count++, wsName);
            pstmtCreateSubProcessInstance.setLong(count++, subpiid);
            pstmtCreateSubProcessInstance.setLong(count++, subptid);
            pstmtCreateSubProcessInstance.setInt(count++, isRemote ? 1 : 0);
            pstmtCreateSubProcessInstance.setString(count++, appServerID);
            pstmtCreateSubProcessInstance.executeUpdate();
        }
        catch (SQLException sqlex) {
            SubProcessDAO.handle((Throwable)sqlex, (String)("SubProcessDAO.insert(PKey:: piid:" + piid + ":wsid:" + wsid + ":subpiid:" + subpiid + ")"));
        }
        finally {
            SubProcessDAO.clean(null, (Statement)pstmtCreateSubProcessInstance, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List findByProcessInstance(long piid) {
        Connection conn = null;
        PreparedStatement pstmtFindByProcessInstance = null;
        ResultSet rset = null;
        ArrayList subProcessList = new ArrayList();
        try {
            conn = SubProcessDAO.getConnection();
            pstmtFindByProcessInstance = conn.prepareStatement(findByProcessInstance);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", findByProcessInstance, new Object[0]);
            }
            pstmtFindByProcessInstance.setLong(1, piid);
            rset = pstmtFindByProcessInstance.executeQuery();
            while (rset.next()) {
                HashMap<String, Object> subProcessInfo = new HashMap<String, Object>();
                int count = 1;
                subProcessInfo.put("WORKSTEPID", rset.getLong(count++));
                subProcessInfo.put("SUBPROCESS_INSTANCE_ID", rset.getLong(count++));
                subProcessInfo.put("IS_REMOTE", rset.getInt(count++) == 1 ? Boolean.TRUE : Boolean.FALSE);
                subProcessInfo.put("APPSERVER_ID", rset.getString(count++));
                subProcessList.add(subProcessInfo);
            }
        }
        catch (SQLException sqlex) {
            try {
                SubProcessDAO.handle((Throwable)sqlex, (String)("SubProcessDAO.findByProcessInstance(piid:" + piid + ")"));
            }
            catch (Throwable throwable) {
                SubProcessDAO.clean(rset, (Statement)pstmtFindByProcessInstance, (Connection)conn);
                throw throwable;
            }
            SubProcessDAO.clean((ResultSet)rset, (Statement)pstmtFindByProcessInstance, (Connection)conn);
        }
        SubProcessDAO.clean((ResultSet)rset, (Statement)pstmtFindByProcessInstance, (Connection)conn);
        return subProcessList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap findBySubProcessInstance(long subpiid) {
        HashMap<String, Object> subProcessInfo;
        ResultSet rset;
        PreparedStatement pstmtFindBySubProcessInstance;
        Connection conn;
        block5: {
            conn = null;
            pstmtFindBySubProcessInstance = null;
            rset = null;
            subProcessInfo = new HashMap<String, Object>();
            try {
                conn = SubProcessDAO.getConnection();
                pstmtFindBySubProcessInstance = conn.prepareStatement(findBySubProcessInstance);
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1185", findBySubProcessInstance, new Object[0]);
                }
                pstmtFindBySubProcessInstance.setLong(1, subpiid);
                rset = pstmtFindBySubProcessInstance.executeQuery();
                if (!rset.next()) break block5;
                DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
                subProcessInfo.put("PROCESSINSTANCEID", rset.getLong("PROCESS_INSTANCE_ID"));
                DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
                subProcessInfo.put("WORKSTEPID", rset.getLong("WORKSTEP_ID"));
                DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
                subProcessInfo.put("IS_REMOTE", rset.getInt("IS_REMOTE") == 1);
                DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
                subProcessInfo.put("APPSERVER_ID", rset.getString("APPSERVER_ID"));
            }
            catch (SQLException sqlex) {
                try {
                    SubProcessDAO.handle((Throwable)sqlex, (String)("SubProcessDAO.findBySubProcessInstance(subpiid:" + subpiid + ")"));
                }
                catch (Throwable throwable) {
                    SubProcessDAO.clean(rset, (Statement)pstmtFindBySubProcessInstance, (Connection)conn);
                    throw throwable;
                }
                SubProcessDAO.clean((ResultSet)rset, (Statement)pstmtFindBySubProcessInstance, (Connection)conn);
            }
        }
        SubProcessDAO.clean((ResultSet)rset, (Statement)pstmtFindBySubProcessInstance, (Connection)conn);
        return subProcessInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List findByWorkstepInstance(long piid, long wsid) {
        Connection conn = null;
        PreparedStatement pstmtFindByWorkstepInstance = null;
        ResultSet rset = null;
        ArrayList subProcessList = new ArrayList();
        try {
            conn = SubProcessDAO.getConnection();
            pstmtFindByWorkstepInstance = conn.prepareStatement(findByWorkstepInstance);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", findByWorkstepInstance, new Object[0]);
            }
            pstmtFindByWorkstepInstance.setLong(1, piid);
            pstmtFindByWorkstepInstance.setLong(2, wsid);
            rset = pstmtFindByWorkstepInstance.executeQuery();
            while (rset.next()) {
                HashMap<String, Object> subProcessInfo = new HashMap<String, Object>();
                int count = 1;
                subProcessInfo.put("SUBPROCESS_INSTANCE_ID", rset.getLong(count++));
                subProcessInfo.put("IS_REMOTE", rset.getInt(count++) == 1 ? Boolean.TRUE : Boolean.FALSE);
                subProcessInfo.put("APPSERVER_ID", rset.getString(count++));
                subProcessList.add(subProcessInfo);
            }
        }
        catch (SQLException sqlex) {
            try {
                SubProcessDAO.handle((Throwable)sqlex, (String)("SubProcessDAO.findByWorkstepInstance(piid:" + piid + ":wsid:" + wsid + ")"));
            }
            catch (Throwable throwable) {
                SubProcessDAO.clean(rset, (Statement)pstmtFindByWorkstepInstance, (Connection)conn);
                throw throwable;
            }
            SubProcessDAO.clean((ResultSet)rset, (Statement)pstmtFindByWorkstepInstance, (Connection)conn);
        }
        SubProcessDAO.clean((ResultSet)rset, (Statement)pstmtFindByWorkstepInstance, (Connection)conn);
        return subProcessList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount(long piid, long wsid) {
        int subpiCount;
        ResultSet rset;
        PreparedStatement pstmtGetCount;
        Connection conn;
        block5: {
            conn = null;
            pstmtGetCount = null;
            rset = null;
            subpiCount = 0;
            try {
                conn = SubProcessDAO.getConnection();
                pstmtGetCount = conn.prepareStatement(getCount);
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1185", getCount, new Object[0]);
                }
                pstmtGetCount.setLong(1, piid);
                pstmtGetCount.setLong(2, wsid);
                rset = pstmtGetCount.executeQuery();
                if (!rset.next()) break block5;
                subpiCount = rset.getInt(1);
            }
            catch (SQLException sqlex) {
                try {
                    SubProcessDAO.handle((Throwable)sqlex, (String)("SubProcessDAO.getCount(piid:" + piid + ":wsid:" + wsid + ")"));
                }
                catch (Throwable throwable) {
                    SubProcessDAO.clean(rset, (Statement)pstmtGetCount, (Connection)conn);
                    throw throwable;
                }
                SubProcessDAO.clean((ResultSet)rset, (Statement)pstmtGetCount, (Connection)conn);
            }
        }
        SubProcessDAO.clean((ResultSet)rset, (Statement)pstmtGetCount, (Connection)conn);
        return subpiCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeByProcessInstance(long piid) {
        Connection conn = null;
        PreparedStatement pstmtRemoveByProcessInstance = null;
        try {
            conn = SubProcessDAO.getConnection();
            pstmtRemoveByProcessInstance = conn.prepareStatement(removeByProcessInstance);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", removeByProcessInstance, new Object[0]);
            }
            pstmtRemoveByProcessInstance.setLong(1, piid);
            pstmtRemoveByProcessInstance.executeUpdate();
        }
        catch (SQLException sqlex) {
            SubProcessDAO.handle((Throwable)sqlex, (String)("SubProcessDAO.removeByProcessInstance(piid:" + piid + ")"));
        }
        finally {
            SubProcessDAO.clean(null, (Statement)pstmtRemoveByProcessInstance, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeByWorkstepInstance(long piid, long wsid) {
        Connection conn = null;
        PreparedStatement pstmtRemoveByWorkstepInstance = null;
        try {
            conn = SubProcessDAO.getConnection();
            pstmtRemoveByWorkstepInstance = conn.prepareStatement(removeByWorkstepInstance);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", removeByWorkstepInstance, new Object[0]);
            }
            pstmtRemoveByWorkstepInstance.setLong(1, piid);
            pstmtRemoveByWorkstepInstance.setLong(2, wsid);
            pstmtRemoveByWorkstepInstance.executeUpdate();
        }
        catch (SQLException sqlex) {
            SubProcessDAO.handle((Throwable)sqlex, (String)("SubProcessDAO.removeByWorkstepInstance(piid:" + piid + ":wsid:" + wsid + ")"));
        }
        finally {
            SubProcessDAO.clean(null, (Statement)pstmtRemoveByWorkstepInstance, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeBySubProcessInstance(long subpiid) {
        Connection conn = null;
        PreparedStatement pstmtRemoveBySubProcessInstance = null;
        try {
            conn = SubProcessDAO.getConnection();
            pstmtRemoveBySubProcessInstance = conn.prepareStatement(removeBySubProcessInstance);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", removeBySubProcessInstance, new Object[0]);
            }
            pstmtRemoveBySubProcessInstance.setLong(1, subpiid);
            pstmtRemoveBySubProcessInstance.executeUpdate();
        }
        catch (SQLException sqlex) {
            SubProcessDAO.handle((Throwable)sqlex, (String)("SubProcessDAO.removeBySubProcessInstance(sub-piid:" + subpiid + ")"));
        }
        finally {
            SubProcessDAO.clean(null, (Statement)pstmtRemoveBySubProcessInstance, (Connection)conn);
        }
    }

    public static synchronized void initSQLStatements() {
        int ix = 0;
        StringBuffer sb = new StringBuffer(220);
        sb.append("insert into ");
        DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_SUBPROCESSINSTANCE");
        SubProcessDAO.addRowlockHint((StringBuffer)sb);
        sb.append(" (");
        for (ix = 0; ix < CREATE_LIST.length; ++ix) {
            sb.append(CREATE_LIST[ix]);
            if (ix == CREATE_LIST.length - 1) continue;
            sb.append(", ");
        }
        sb.append(") values (");
        for (ix = 0; ix < CREATE_LIST.length; ++ix) {
            sb.append("?");
            if (ix == CREATE_LIST.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        createSubProcessInstance = sb.toString();
        sb = new StringBuffer(300);
        sb.append("select ");
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        sb.append("WORKSTEP_ID").append(", ");
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        sb.append("SUBPROCESS_INSTANCE_ID").append(", ");
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        sb.append("IS_REMOTE").append(", ");
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        sb.append("APPSERVER_ID");
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_5 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_SUBPROCESSINSTANCE");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_6 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" = ? ");
        findByProcessInstance = sb.toString();
        sb = new StringBuffer(300);
        sb.append("select ");
        DBConstants.ColConstants cfr_ignored_7 = BLControl.dbconsts.col;
        sb.append("SUBPROCESS_INSTANCE_ID").append(", ");
        DBConstants.ColConstants cfr_ignored_8 = BLControl.dbconsts.col;
        sb.append("IS_REMOTE").append(", ");
        DBConstants.ColConstants cfr_ignored_9 = BLControl.dbconsts.col;
        sb.append("APPSERVER_ID");
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_10 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_SUBPROCESSINSTANCE");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_11 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" = ? and ");
        DBConstants.ColConstants cfr_ignored_12 = BLControl.dbconsts.col;
        sb.append("WORKSTEP_ID");
        sb.append(" = ? ");
        findByWorkstepInstance = sb.toString();
        sb = new StringBuffer(300);
        sb.append("select count(");
        DBConstants.ColConstants cfr_ignored_13 = BLControl.dbconsts.col;
        sb.append("SUBPROCESS_INSTANCE_ID");
        sb.append(") ");
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_14 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_SUBPROCESSINSTANCE");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_15 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" = ? and ");
        DBConstants.ColConstants cfr_ignored_16 = BLControl.dbconsts.col;
        sb.append("WORKSTEP_ID");
        sb.append(" = ? ");
        getCount = sb.toString();
        sb = new StringBuffer(300);
        sb.append("delete ");
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_17 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_SUBPROCESSINSTANCE");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_18 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" = ? ");
        removeByProcessInstance = sb.toString();
        sb = new StringBuffer(300);
        sb.append("delete ");
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_19 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_SUBPROCESSINSTANCE");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_20 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" = ? and ");
        DBConstants.ColConstants cfr_ignored_21 = BLControl.dbconsts.col;
        sb.append("WORKSTEP_ID");
        sb.append(" = ? ");
        removeByWorkstepInstance = sb.toString();
        sb = new StringBuffer(300);
        sb.append("delete ");
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_22 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_SUBPROCESSINSTANCE");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_23 = BLControl.dbconsts.col;
        sb.append("SUBPROCESS_INSTANCE_ID");
        sb.append(" = ? ");
        removeBySubProcessInstance = sb.toString();
        sb = new StringBuffer(300);
        sb.append("select ");
        DBConstants.ColConstants cfr_ignored_24 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID").append(", ");
        DBConstants.ColConstants cfr_ignored_25 = BLControl.dbconsts.col;
        sb.append("WORKSTEP_ID").append(", ");
        DBConstants.ColConstants cfr_ignored_26 = BLControl.dbconsts.col;
        sb.append("IS_REMOTE").append(", ");
        DBConstants.ColConstants cfr_ignored_27 = BLControl.dbconsts.col;
        sb.append("APPSERVER_ID");
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_28 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_SUBPROCESSINSTANCE");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_29 = BLControl.dbconsts.col;
        sb.append("SUBPROCESS_INSTANCE_ID");
        sb.append(" = ? ");
        findBySubProcessInstance = sb.toString();
        SubProcessDAO.printSQLStatements();
    }

    private static void printSQLStatements() {
        if (BLControl.util.DEBUG_DAO) {
            BLControl.logger.debug((Object)"SubProcessDAO:");
            BLControl.logger.debugKey("BizLogic_ERR_1199", createSubProcessInstance, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", findByProcessInstance, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeByProcessInstance, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeByWorkstepInstance, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", findByWorkstepInstance, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeBySubProcessInstance, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getCount, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", findBySubProcessInstance, new Object[0]);
        }
    }

    static {
        String[] stringArray = new String[8];
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        stringArray[0] = "PROCESS_INSTANCE_ID";
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        stringArray[1] = "PROCESS_INSTANCE_NAME";
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        stringArray[2] = "WORKSTEP_ID";
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        stringArray[3] = "WORKSTEP_NAME";
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        stringArray[4] = "SUBPROCESS_INSTANCE_ID";
        DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
        stringArray[5] = "SUBPROCESS_TEMPLATE_ID";
        DBConstants.ColConstants cfr_ignored_6 = BLControl.dbconsts.col;
        stringArray[6] = "IS_REMOTE";
        DBConstants.ColConstants cfr_ignored_7 = BLControl.dbconsts.col;
        stringArray[7] = "APPSERVER_ID";
        CREATE_LIST = stringArray;
        String[] stringArray2 = new String[5];
        DBConstants.ColConstants cfr_ignored_8 = BLControl.dbconsts.col;
        stringArray2[0] = "PROCESS_INSTANCE_ID";
        DBConstants.ColConstants cfr_ignored_9 = BLControl.dbconsts.col;
        stringArray2[1] = "WORKSTEP_ID";
        DBConstants.ColConstants cfr_ignored_10 = BLControl.dbconsts.col;
        stringArray2[2] = "SUBPROCESS_INSTANCE_ID";
        DBConstants.ColConstants cfr_ignored_11 = BLControl.dbconsts.col;
        stringArray2[3] = "IS_REMOTE";
        DBConstants.ColConstants cfr_ignored_12 = BLControl.dbconsts.col;
        stringArray2[4] = "APPSERVER_ID";
        LOAD_TABLELIST = stringArray2;
    }
}

