/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.dao;

import com.savvion.sbm.bizlogic.server.ejb.WorkItemEBBBean;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.DBConstants;
import com.savvion.sbm.bizlogic.util.PerformerUtil;
import com.savvion.sbm.util.BMTimer;
import com.savvion.sbm.util.SBMControl;
import com.savvion.sbm.util.SBMDatabase;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.SqlInParamUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.ObjectNotFoundException;

public class WorkItemDAO
extends BLDAOService {
    private static final String[] CREATE_LIST;
    private static final String[] CREATE_TABLELIST;
    private static final String[] LOAD_LIST;
    private static final String[] LOAD_TABLELIST;
    private static final String[] CREATE_DYNAMIC_PROCESSLIST;
    private static final String[] CREATE_DYNAMIC_PROCESS_TABLELIST;
    public static String removeWorkItem;
    public static String removeByProcessInstance;
    public static String removeByWorkStepInstance;
    public static String findByPrimaryKey;
    public static String findByWorkStepInstance;
    public static String getCountByWorkStepInstance;
    public static String createWorkItem;
    public static String createDynamicProcessWorkItem;
    public static String loadWorkItem;
    public static String getWorkItemList;
    public static String getQueueWorkItemList;
    public static String getSingleQueueWorkItemList;
    public static String excludeUserSubQuery;
    public static String singleExcludeUserSubQuery;
    public static String getWorkStepWorkItems;
    public static String findByName;
    public static String findByPerformer;
    public static String getIDByWorkStepInstance;
    private static String getCountByProcessTemplateAndPerformer;
    private static String getCountByProcessTemplate;
    private static String getCountByProcessTemplateForAvailableWI;
    public static String orderByDueDate;
    public static String orderByPriority;
    public static String orderByStartTime;
    private static String joinWhereClause;
    private static String excludeQueuePerformer;
    private static String getNextAvlWI;
    private static String nextAvlWIWhereClause;
    private static String nextAvlWIJoinClause;
    private static String defGetNextAvlWI;
    private static String getWIStatus;
    private static String getPIIdbyWIId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create(HashMap attrsList) throws CreateException {
        String key = null;
        Object value = null;
        Connection conn = null;
        PreparedStatement pstmtCreateWorkItem = null;
        long wiid = -1L;
        try {
            conn = WorkItemDAO.getConnection();
            pstmtCreateWorkItem = conn.prepareStatement(createWorkItem);
            for (int ix = 0; ix < CREATE_LIST.length; ++ix) {
                block31: {
                    block30: {
                        block29: {
                            block28: {
                                block27: {
                                    block26: {
                                        key = CREATE_LIST[ix];
                                        value = attrsList.get(key);
                                        if (key.equalsIgnoreCase("STATUS")) break block26;
                                        if (!key.equalsIgnoreCase("PRIORITY")) break block27;
                                    }
                                    if (value == null) {
                                        pstmtCreateWorkItem.setNull(ix + 1, 4);
                                        continue;
                                    }
                                    pstmtCreateWorkItem.setInt(ix + 1, (Integer)value);
                                    continue;
                                }
                                if (key.equalsIgnoreCase("WORKITEMNAME")) break block28;
                                if (key.equalsIgnoreCase("PERFORMER")) break block28;
                                if (key.equalsIgnoreCase("RESPONSE")) break block28;
                                if (key.equalsIgnoreCase("PREVIOUSASSIGNEE")) break block28;
                                if (!key.equalsIgnoreCase("WORKSTEPNAME")) break block29;
                            }
                            if (value == null) {
                                pstmtCreateWorkItem.setNull(ix + 1, 12);
                                continue;
                            }
                            pstmtCreateWorkItem.setString(ix + 1, value);
                            continue;
                        }
                        if (key.equalsIgnoreCase("PROCESSINSTANCEID")) break block30;
                        if (key.equalsIgnoreCase("PROCESSTEMPLATEID")) break block30;
                        if (!key.equalsIgnoreCase("WORKSTEPID")) break block31;
                    }
                    if (value == null) {
                        pstmtCreateWorkItem.setNull(ix + 1, -5);
                        continue;
                    }
                    pstmtCreateWorkItem.setLong(ix + 1, (Long)value);
                    continue;
                }
                if (key.equalsIgnoreCase("WORKITEMID")) {
                    if (value == null) {
                        Object[] objectArray = new Object[2];
                        objectArray[0] = "WORKITEMID";
                        objectArray[1] = "WORKITEM";
                        throw new CreateException(BLControl.msgFactory.lookup("BizLogic_ERR_1588", objectArray));
                    }
                    wiid = value;
                    pstmtCreateWorkItem.setLong(ix + 1, wiid);
                    continue;
                }
                if (!key.equalsIgnoreCase("STARTTIME")) {
                    if (!key.equalsIgnoreCase("DUEDATE")) {
                        if (!key.equalsIgnoreCase("READTIME")) continue;
                    }
                }
                if (value == null) {
                    pstmtCreateWorkItem.setNull(ix + 1, -5);
                    continue;
                }
                WorkItemDAO.setDateValue((PreparedStatement)pstmtCreateWorkItem, (int)(ix + 1), (long)((Long)value).longValue());
            }
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{createWorkItem, WorkItemDAO.getPrimaryKey(wiid)});
            }
            pstmtCreateWorkItem.executeUpdate();
        }
        catch (CreateException createEx) {
            throw createEx;
        }
        catch (Exception ex) {
            WorkItemDAO.handle((Throwable)ex, (String)("WIDAO.create(PKey: " + wiid + ")"));
        }
        finally {
            WorkItemDAO.clean(null, (Statement)pstmtCreateWorkItem, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDynamicProcess(HashMap attrsList) throws CreateException {
        String key = null;
        Object value = null;
        Connection conn = null;
        PreparedStatement pstmtCreateDynamicProcessWorkItem = null;
        try {
            conn = WorkItemDAO.getConnection();
            pstmtCreateDynamicProcessWorkItem = conn.prepareStatement(createDynamicProcessWorkItem);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", createDynamicProcessWorkItem, new Object[0]);
            }
            for (int ix = 0; ix < CREATE_DYNAMIC_PROCESSLIST.length; ++ix) {
                block28: {
                    block27: {
                        block26: {
                            block25: {
                                block24: {
                                    block23: {
                                        key = CREATE_DYNAMIC_PROCESSLIST[ix];
                                        value = attrsList.get(key);
                                        if (key.equalsIgnoreCase("STATUS")) break block23;
                                        if (!key.equalsIgnoreCase("PRIORITY")) break block24;
                                    }
                                    if (value == null) {
                                        pstmtCreateDynamicProcessWorkItem.setNull(ix + 1, 4);
                                        continue;
                                    }
                                    pstmtCreateDynamicProcessWorkItem.setInt(ix + 1, (Integer)value);
                                    continue;
                                }
                                if (key.equalsIgnoreCase("WORKITEMNAME")) break block25;
                                if (key.equalsIgnoreCase("PERFORMER")) break block25;
                                if (key.equalsIgnoreCase("RESPONSE")) break block25;
                                if (key.equalsIgnoreCase("PREVIOUSASSIGNEE")) break block25;
                                if (!key.equalsIgnoreCase("WORKSTEPNAME")) break block26;
                            }
                            if (value == null) {
                                pstmtCreateDynamicProcessWorkItem.setNull(ix + 1, 12);
                                continue;
                            }
                            pstmtCreateDynamicProcessWorkItem.setString(ix + 1, value);
                            continue;
                        }
                        if (key.equalsIgnoreCase("PROCESSINSTANCEID")) break block27;
                        if (key.equalsIgnoreCase("PROCESSTEMPLATEID")) break block27;
                        if (key.equalsIgnoreCase("WORKSTEPID")) break block27;
                        if (!key.equalsIgnoreCase("WORKITEMID")) break block28;
                    }
                    if (value == null) {
                        if (key.equalsIgnoreCase("WORKITEMID")) {
                            Object[] objectArray = new Object[2];
                            objectArray[0] = "WORKITEMID";
                            objectArray[1] = "WORKITEM";
                            throw new CreateException(BLControl.msgFactory.lookup("BizLogic_ERR_1588", objectArray));
                        }
                        pstmtCreateDynamicProcessWorkItem.setNull(ix + 1, -5);
                        continue;
                    }
                    pstmtCreateDynamicProcessWorkItem.setLong(ix + 1, (Long)value);
                    continue;
                }
                if (!key.equalsIgnoreCase("STARTTIME")) {
                    if (!key.equalsIgnoreCase("DUEDATE")) continue;
                }
                if (value == null) {
                    pstmtCreateDynamicProcessWorkItem.setNull(ix + 1, -5);
                    continue;
                }
                WorkItemDAO.setDateValue((PreparedStatement)pstmtCreateDynamicProcessWorkItem, (int)(ix + 1), (long)((Long)value).longValue());
            }
            pstmtCreateDynamicProcessWorkItem.executeUpdate();
        }
        catch (SQLException sqlex) {
            WorkItemDAO.handle((SQLException)sqlex);
        }
        finally {
            WorkItemDAO.clean(null, (Statement)pstmtCreateDynamicProcessWorkItem, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Long findByPrimaryKey(Long wiid) throws ObjectNotFoundException {
        Connection conn = null;
        PreparedStatement pstmtFindByPrimaryKey = null;
        ResultSet rs = null;
        try {
            conn = WorkItemDAO.getConnection();
            pstmtFindByPrimaryKey = conn.prepareStatement(findByPrimaryKey);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", findByPrimaryKey, new Object[0]);
            }
            pstmtFindByPrimaryKey.setLong(1, wiid);
            rs = pstmtFindByPrimaryKey.executeQuery();
            if (!rs.next()) {
                throw new ObjectNotFoundException(BLControl.msgFactory.lookup("BizLogic_ERR_1589", new Object[]{"WORKITEM", "WIID=" + wiid}));
            }
            WorkItemDAO.clean((ResultSet)rs, (Statement)pstmtFindByPrimaryKey, (Connection)conn);
            return wiid;
        }
        catch (ObjectNotFoundException finderEx) {
            throw finderEx;
            catch (Throwable th) {
                WorkItemDAO.handle((Throwable)th);
                return wiid;
            }
        }
        finally {
            WorkItemDAO.clean(rs, (Statement)pstmtFindByPrimaryKey, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection findByWorkStepInstance(long piid, long wsid) {
        Vector<Long> primaryKeys = new Vector<Long>();
        Connection conn = null;
        PreparedStatement pstmtFindByWorkStepInstance = null;
        ResultSet rs = null;
        try {
            conn = WorkItemDAO.getConnection();
            pstmtFindByWorkStepInstance = conn.prepareStatement(findByWorkStepInstance);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", findByWorkStepInstance, new Object[0]);
            }
            pstmtFindByWorkStepInstance.setLong(1, piid);
            pstmtFindByWorkStepInstance.setLong(2, wsid);
            rs = pstmtFindByWorkStepInstance.executeQuery();
            while (rs.next()) {
                primaryKeys.addElement(rs.getLong(1));
            }
        }
        catch (Throwable th) {
            try {
                WorkItemDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                WorkItemDAO.clean(rs, (Statement)pstmtFindByWorkStepInstance, (Connection)conn);
            }
        }
        WorkItemDAO.clean((ResultSet)rs, (Statement)pstmtFindByWorkStepInstance, (Connection)conn);
        return primaryKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isWorkItemExist(long wiid) {
        boolean wiexist;
        ResultSet rset;
        PreparedStatement pstmtGetWorkItemID;
        Connection conn;
        block5: {
            conn = null;
            pstmtGetWorkItemID = null;
            rset = null;
            wiexist = false;
            try {
                conn = WorkItemDAO.getConnection();
                pstmtGetWorkItemID = conn.prepareStatement(findByPrimaryKey);
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1185", findByPrimaryKey, new Object[0]);
                }
                pstmtGetWorkItemID.setLong(1, wiid);
                rset = pstmtGetWorkItemID.executeQuery();
                if (!rset.next()) break block5;
                wiexist = true;
            }
            catch (Throwable throwable) {
                WorkItemDAO.clean(rset, (Statement)pstmtGetWorkItemID, (Connection)conn);
                catch (Throwable throwable2) {
                    WorkItemDAO.clean(rset, (Statement)pstmtGetWorkItemID, (Connection)conn);
                    throw throwable2;
                }
            }
        }
        WorkItemDAO.clean((ResultSet)rset, (Statement)pstmtGetWorkItemID, (Connection)conn);
        return wiexist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getStatus(long wiid) {
        int wistatus;
        ResultSet rset;
        PreparedStatement pstmtGetWorkItemStatus;
        Connection conn;
        block6: {
            conn = null;
            pstmtGetWorkItemStatus = null;
            rset = null;
            wistatus = -1;
            try {
                conn = WorkItemDAO.getConnection();
                pstmtGetWorkItemStatus = conn.prepareStatement(getWIStatus);
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1185", "WorkItemDAO.getStatus(long)", new Object[]{getWIStatus});
                }
                pstmtGetWorkItemStatus.setLong(1, wiid);
                rset = pstmtGetWorkItemStatus.executeQuery();
                if (!rset.next()) break block6;
                wistatus = rset.getInt(1);
            }
            catch (Throwable th) {
                try {
                    WorkItemDAO.handle((Throwable)th);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    WorkItemDAO.clean(rset, (Statement)pstmtGetWorkItemStatus, (Connection)conn);
                }
            }
        }
        WorkItemDAO.clean((ResultSet)rset, (Statement)pstmtGetWorkItemStatus, (Connection)conn);
        return wistatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCountByWorkStepInstance(long piid, long wsid, boolean readOnly) {
        ResultSet rs;
        PreparedStatement pstmtGetCountByWorkStepInstance;
        Connection conn;
        int count;
        block5: {
            count = 0;
            conn = null;
            pstmtGetCountByWorkStepInstance = null;
            rs = null;
            try {
                conn = WorkItemDAO.getConnection((boolean)readOnly);
                pstmtGetCountByWorkStepInstance = conn.prepareStatement(getCountByWorkStepInstance);
                pstmtGetCountByWorkStepInstance.setLong(1, piid);
                pstmtGetCountByWorkStepInstance.setLong(2, wsid);
                rs = pstmtGetCountByWorkStepInstance.executeQuery();
                if (rs.next()) {
                    count = rs.getInt(1);
                }
                if (!BLControl.util.DEBUG_DAO) break block5;
                String debugStr = piid + ", " + wsid;
                BLControl.logger.debugKey("BizLogic_ERR_3251", "WorkItemDAO.getCountByWorkStepInstance", new Object[]{getCountByWorkStepInstance, debugStr, count});
            }
            catch (Throwable th) {
                try {
                    WorkItemDAO.handle((Throwable)th);
                }
                catch (Throwable throwable) {
                    WorkItemDAO.clean(rs, pstmtGetCountByWorkStepInstance, (Connection)conn);
                    throw throwable;
                }
                WorkItemDAO.clean(rs, (Statement)pstmtGetCountByWorkStepInstance, (Connection)conn);
            }
        }
        WorkItemDAO.clean((ResultSet)rs, (Statement)pstmtGetCountByWorkStepInstance, (Connection)conn);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getCountByProcessTemplate(String performer, boolean readOnly) {
        ResultSet rsAwi;
        PreparedStatement pstmtGetCountByProcessTemplateForAvailableWI;
        HashMap processTemplate;
        ResultSet rs;
        PreparedStatement pstmtGetCountByProcessTemplate;
        Connection conn;
        block24: {
            Long processTemplateID = null;
            Integer status = null;
            Integer count = null;
            conn = null;
            pstmtGetCountByProcessTemplate = null;
            rs = null;
            processTemplate = new HashMap();
            String countByProcessTemplate = getCountByProcessTemplate;
            if (performer != null) {
                countByProcessTemplate = getCountByProcessTemplateAndPerformer;
            }
            pstmtGetCountByProcessTemplateForAvailableWI = null;
            rsAwi = null;
            try {
                int i;
                conn = WorkItemDAO.getConnection((boolean)readOnly);
                HashMap<Integer, Integer> workitemstatus = null;
                pstmtGetCountByProcessTemplate = conn.prepareStatement(countByProcessTemplate);
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1185", countByProcessTemplate, new Object[0]);
                }
                if (performer != null) {
                    if (BLUtil.isUserManagerCaseSensitive()) {
                        pstmtGetCountByProcessTemplate.setString(1, performer);
                    } else {
                        pstmtGetCountByProcessTemplate.setString(1, performer.toLowerCase());
                    }
                }
                rs = pstmtGetCountByProcessTemplate.executeQuery();
                while (rs.next()) {
                    Object o;
                    processTemplateID = rs.getLong(1);
                    status = rs.getInt(2);
                    count = rs.getInt(3);
                    if (performer != null) {
                        if (performer == null) continue;
                        if (status == 27) continue;
                    }
                    workitemstatus = (o = processTemplate.get(processTemplateID)) == null ? new HashMap<Integer, Integer>() : (HashMap<Integer, Integer>)o;
                    workitemstatus.put(status, count);
                    processTemplate.put(processTemplateID, workitemstatus);
                }
                List queues = null;
                StringBuffer queryBuffer = new StringBuffer(getCountByProcessTemplateForAvailableWI);
                if (performer == null) break block24;
                if (SBMControl.util.isUseQueue()) {
                    queues = PerformerUtil.getQueues((String)performer);
                }
                if (queues != null && !queues.isEmpty()) {
                    StringBuffer inClause = new StringBuffer("IN (");
                    inClause.append("?");
                    for (i = 0; i < queues.size(); ++i) {
                        inClause.append(", ?");
                    }
                    inClause.append(")");
                    int index = getCountByProcessTemplateForAvailableWI.indexOf("= ?");
                    queryBuffer.replace(index, index + 3, inClause.toString());
                    queryBuffer.insert(queryBuffer.toString().indexOf("group by"), excludeQueuePerformer);
                }
                workitemstatus = null;
                pstmtGetCountByProcessTemplateForAvailableWI = conn.prepareStatement(queryBuffer.toString());
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1185", queryBuffer.toString(), new Object[0]);
                }
                int index = 1;
                if (BLUtil.isUserManagerCaseSensitive()) {
                    pstmtGetCountByProcessTemplateForAvailableWI.setString(index++, performer);
                    if (queues != null && !queues.isEmpty()) {
                        for (i = 0; i < queues.size(); ++i) {
                            pstmtGetCountByProcessTemplateForAvailableWI.setString(index++, (String)queues.get(i));
                        }
                    }
                    int n = index++;
                    BLConstants.single();
                    pstmtGetCountByProcessTemplateForAvailableWI.setInt(n, 27);
                    if (queues != null && !queues.isEmpty()) {
                        pstmtGetCountByProcessTemplateForAvailableWI.setString(index++, performer);
                    }
                } else {
                    pstmtGetCountByProcessTemplateForAvailableWI.setString(index++, performer.toLowerCase());
                    if (queues != null && !queues.isEmpty()) {
                        for (i = 0; i < queues.size(); ++i) {
                            pstmtGetCountByProcessTemplateForAvailableWI.setString(index++, ((String)queues.get(i)).toLowerCase());
                        }
                    }
                    int n = index++;
                    BLConstants.single();
                    pstmtGetCountByProcessTemplateForAvailableWI.setInt(n, 27);
                    if (queues != null && !queues.isEmpty()) {
                        pstmtGetCountByProcessTemplateForAvailableWI.setString(index++, performer.toLowerCase());
                    }
                }
                rsAwi = pstmtGetCountByProcessTemplateForAvailableWI.executeQuery();
                while (rsAwi.next()) {
                    processTemplateID = rsAwi.getLong(1);
                    status = rsAwi.getInt(2);
                    count = rsAwi.getInt(3);
                    Object o = processTemplate.get(processTemplateID);
                    workitemstatus = o == null ? new HashMap<Integer, Integer>() : (HashMap<Integer, Integer>)o;
                    workitemstatus.put(status, count);
                    processTemplate.put(processTemplateID, workitemstatus);
                }
            }
            catch (Throwable th) {
                try {
                    WorkItemDAO.handle((Throwable)th);
                }
                catch (Throwable throwable) {
                    WorkItemDAO.clean(rs, pstmtGetCountByProcessTemplate, null);
                    WorkItemDAO.clean(rsAwi, pstmtGetCountByProcessTemplateForAvailableWI, (Connection)conn);
                    throw throwable;
                }
                WorkItemDAO.clean(rs, (Statement)pstmtGetCountByProcessTemplate, null);
                WorkItemDAO.clean(rsAwi, pstmtGetCountByProcessTemplateForAvailableWI, (Connection)conn);
            }
        }
        WorkItemDAO.clean((ResultSet)rs, (Statement)pstmtGetCountByProcessTemplate, null);
        WorkItemDAO.clean(rsAwi, pstmtGetCountByProcessTemplateForAvailableWI, (Connection)conn);
        return processTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(WorkItemEBBBean wiEB, Long wiid) {
        Connection conn = null;
        PreparedStatement pstmtLoadWorkItem = null;
        ResultSet rs = null;
        try {
            conn = WorkItemDAO.getConnection();
            pstmtLoadWorkItem = conn.prepareStatement(loadWorkItem);
            pstmtLoadWorkItem.setLong(1, wiid);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{loadWorkItem, WorkItemDAO.getPrimaryKey(wiid)});
            }
            if (!(rs = pstmtLoadWorkItem.executeQuery()).next()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = "WorkItem";
                objectArray[1] = wiid;
                DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
                objectArray[2] = "BIZLOGIC_WORKITEM";
                throw new BizLogicException("BizLogic_ERR_1548", "WorkItemDAO.load", objectArray);
            }
            wiEB.id = rs.getLong(1);
            wiEB.processTemplateID = rs.getLong(2);
            wiEB.processInstanceID = rs.getLong(3);
            wiEB.workStepID = rs.getLong(4);
            wiEB.workStepName = rs.getString(5);
            wiEB.timeStarted = WorkItemDAO.getDateValue((ResultSet)rs, (int)6);
            wiEB.timeCompleted = WorkItemDAO.getDateValue((ResultSet)rs, (int)7);
            wiEB.dueDate = WorkItemDAO.getDateValue((ResultSet)rs, (int)8);
            wiEB.state = rs.getInt(9);
            wiEB.previousState = rs.getInt(10);
            wiEB.priority = rs.getInt(11);
            wiEB.name = rs.getString(12);
            wiEB.performer = rs.getString(13);
            wiEB.previousPerformer = rs.getString(14);
            wiEB.response = rs.getString(15);
            wiEB.readTime = rs.getLong(16);
            WorkItemDAO.clean((ResultSet)rs, (Statement)pstmtLoadWorkItem, (Connection)conn);
        }
        catch (Exception ex) {
            wiEB.handleEBEx("WIEB:load", wiid, ex);
            WorkItemDAO.handle((Throwable)ex);
        }
        finally {
            WorkItemDAO.clean(rs, (Statement)pstmtLoadWorkItem, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(WorkItemEBBBean wiEB, Long wiid, HashMap modifiedAttrs) {
        Connection conn = null;
        PreparedStatement pstmtStoreWorkItem = null;
        int attrsCount = modifiedAttrs.size();
        StringBuffer sb = new StringBuffer(300);
        DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
        sb.append("update ").append("BIZLOGIC_WORKITEM");
        WorkItemDAO.addRowlockHint((StringBuffer)sb);
        sb.append(" set ");
        Iterator keySet = modifiedAttrs.keySet().iterator();
        String key = null;
        Object value = null;
        int counter = 0;
        while (keySet.hasNext()) {
            key = (String)keySet.next();
            sb.append(key);
            sb.append(" = ?");
            if (counter != attrsCount - 1) {
                sb.append(", ");
            }
            ++counter;
        }
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        sb.append("WORKITEM_ID");
        sb.append(" = ? ");
        String storeWorkItem = sb.toString();
        try {
            conn = WorkItemDAO.getConnection();
            pstmtStoreWorkItem = conn.prepareStatement(storeWorkItem);
            keySet = modifiedAttrs.keySet().iterator();
            key = null;
            value = null;
            counter = 1;
            while (keySet.hasNext()) {
                block29: {
                    block28: {
                        block27: {
                            block26: {
                                block25: {
                                    block24: {
                                        key = (String)keySet.next();
                                        value = modifiedAttrs.get(key);
                                        if (key.equalsIgnoreCase("PROCESSINSTANCEID")) break block24;
                                        if (key.equalsIgnoreCase("PROCESSTEMPLATEID")) break block24;
                                        if (key.equalsIgnoreCase("WORKSTEPID")) break block24;
                                        if (key.equalsIgnoreCase("WORKITEMID")) break block24;
                                        if (key.equalsIgnoreCase("STARTTIME")) break block24;
                                        if (!key.equalsIgnoreCase("WORKSTEPNAME")) break block25;
                                    }
                                    throw new BizLogicException("BizLogic_ERR_1587", "WorkItemDAO.store", new Object[]{key, "WorkItem"});
                                }
                                if (key.equalsIgnoreCase("STATUS")) break block26;
                                if (key.equalsIgnoreCase("PREVIOUSSTATUS")) break block26;
                                if (!key.equalsIgnoreCase("PRIORITY")) break block27;
                            }
                            if (value == null) {
                                pstmtStoreWorkItem.setNull(counter++, 4);
                                continue;
                            }
                            pstmtStoreWorkItem.setInt(counter++, (Integer)value);
                            continue;
                        }
                        if (key.equalsIgnoreCase("WORKITEMNAME")) break block28;
                        if (key.equalsIgnoreCase("PERFORMER")) break block28;
                        if (key.equalsIgnoreCase("PREVIOUSASSIGNEE")) break block28;
                        if (!key.equalsIgnoreCase("RESPONSE")) break block29;
                    }
                    if (value == null) {
                        pstmtStoreWorkItem.setNull(counter++, 12);
                        continue;
                    }
                    pstmtStoreWorkItem.setString(counter++, value);
                    continue;
                }
                if (!key.equalsIgnoreCase("ENDTIME")) {
                    if (!key.equalsIgnoreCase("DUEDATE")) {
                        if (!key.equalsIgnoreCase("READTIME")) continue;
                    }
                }
                if (value == null) {
                    pstmtStoreWorkItem.setNull(counter++, -5);
                    continue;
                }
                WorkItemDAO.setDateValue((PreparedStatement)pstmtStoreWorkItem, (int)counter++, (long)((Long)value).longValue());
            }
            pstmtStoreWorkItem.setLong(counter, wiid);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{storeWorkItem, WorkItemDAO.getPrimaryKey(wiid)});
            }
            pstmtStoreWorkItem.executeUpdate();
        }
        catch (Exception ex) {
            wiEB.handleEBEx("WIEB:store", wiid, ex);
            WorkItemDAO.handle((Throwable)ex);
        }
        finally {
            WorkItemDAO.clean(null, (Statement)pstmtStoreWorkItem, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Long wiid) {
        Connection conn = null;
        PreparedStatement pstmtRemoveWorkItem = null;
        try {
            conn = WorkItemDAO.getConnection();
            pstmtRemoveWorkItem = conn.prepareStatement(removeWorkItem);
            pstmtRemoveWorkItem.setLong(1, wiid);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{removeWorkItem, WorkItemDAO.getPrimaryKey(wiid)});
            }
            pstmtRemoveWorkItem.executeUpdate();
        }
        catch (Throwable th) {
            WorkItemDAO.handle((Throwable)th);
        }
        finally {
            WorkItemDAO.clean(null, (Statement)pstmtRemoveWorkItem, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeByProcessInstance(long piid) {
        Connection conn = null;
        PreparedStatement pstmtRemoveByProcessInstance = null;
        try {
            conn = WorkItemDAO.getConnection();
            pstmtRemoveByProcessInstance = conn.prepareStatement(removeByProcessInstance);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", removeByProcessInstance, new Object[0]);
            }
            pstmtRemoveByProcessInstance.setLong(1, piid);
            pstmtRemoveByProcessInstance.executeUpdate();
        }
        catch (Throwable th) {
            WorkItemDAO.handle((Throwable)th);
        }
        finally {
            WorkItemDAO.clean(null, (Statement)pstmtRemoveByProcessInstance, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeByWorkStepInstance(long piid, long wsid) {
        Connection conn = null;
        PreparedStatement pstmtRemoveByWorkStepInstance = null;
        try {
            conn = WorkItemDAO.getConnection();
            pstmtRemoveByWorkStepInstance = conn.prepareStatement(removeByWorkStepInstance);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", removeByWorkStepInstance, new Object[0]);
            }
            pstmtRemoveByWorkStepInstance.setLong(1, piid);
            pstmtRemoveByWorkStepInstance.setLong(2, wsid);
            pstmtRemoveByWorkStepInstance.executeUpdate();
        }
        catch (Throwable th) {
            WorkItemDAO.handle((Throwable)th);
        }
        finally {
            WorkItemDAO.clean(null, (Statement)pstmtRemoveByWorkStepInstance, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getAvailableWorkItemList(long[] ptIDs, long[] piIDs, String performer, List queues, boolean readOnly) {
        Vector wiList = new Vector();
        int ix = 0;
        boolean hasCondition = false;
        StringBuffer mainClause = new StringBuffer(getWorkItemList);
        StringBuffer whereClause = new StringBuffer(" WHERE ");
        if (ptIDs != null && ptIDs.length > 0) {
            DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
            whereClause.append("wi.").append("PROCESS_TEMPLATE_ID");
            if (ptIDs.length == 1) {
                whereClause.append(" = ? ");
            } else {
                whereClause.append(" IN (");
                for (ix = 0; ix < ptIDs.length; ++ix) {
                    whereClause.append(String.valueOf(ptIDs[ix]));
                    if (ix < ptIDs.length - 1) {
                        whereClause.append(", ");
                        continue;
                    }
                    whereClause.append(") ");
                }
            }
            hasCondition = true;
        }
        if (!hasCondition && piIDs != null && piIDs.length > 0) {
            DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
            whereClause.append("wi.").append("PROCESS_INSTANCE_ID");
            if (piIDs.length == 1) {
                whereClause.append(" = ? ");
            } else {
                whereClause.append(" IN (");
                for (ix = 0; ix < piIDs.length; ++ix) {
                    whereClause.append(String.valueOf(piIDs[ix]));
                    if (ix < piIDs.length - 1) {
                        whereClause.append(", ");
                        continue;
                    }
                    whereClause.append(") ");
                }
            }
            hasCondition = true;
        }
        if (performer != null) {
            if (hasCondition) {
                whereClause.append(" AND ");
            }
            DBConstants.TableConstants cfr_ignored_2 = BLControl.dbconsts.tab;
            mainClause.append(", ").append("BIZLOGIC_AVAILABLEWORKITEM").append(" awi ");
            StringBuilder availForColumn = new StringBuilder();
            if (BLUtil.isUserManagerCaseSensitive()) {
                DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
                availForColumn.append("awi.").append("AVAILABLEFOR");
            } else {
                BLConstants.single();
                availForColumn.append("lower(").append("awi.");
                DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
                availForColumn.append("AVAILABLEFOR");
                DBConstants.KeywordConstants cfr_ignored_5 = BLControl.dbconsts.kwd;
                availForColumn.append(") ");
            }
            ArrayList<String> qMarks = new ArrayList<String>(1);
            DBConstants.KeywordConstants cfr_ignored_6 = BLControl.dbconsts.kwd;
            qMarks.add("?");
            if (SBMControl.util.isUseQueue()) {
                queues = PerformerUtil.getQueues((String)performer);
            }
            if (queues != null && !queues.isEmpty()) {
                for (int count = 0; count < queues.size(); ++count) {
                    DBConstants.KeywordConstants cfr_ignored_7 = BLControl.dbconsts.kwd;
                    qMarks.add("?");
                }
            }
            String queueSqlInPart = SqlInParamUtil.prepareParams((String)availForColumn.toString(), qMarks, (int)SBMDatabase.self().getBatchSizeForSqlInClause(), (boolean)true);
            whereClause.append(queueSqlInPart);
            DBConstants.ColConstants cfr_ignored_8 = BLControl.dbconsts.col;
            whereClause.append(" AND wi.").append("STATUS");
            whereClause.append(" = ? ");
            DBConstants.ColConstants cfr_ignored_9 = BLControl.dbconsts.col;
            whereClause.append(" AND awi.").append("WORKITEM_ID");
            DBConstants.ColConstants cfr_ignored_10 = BLControl.dbconsts.col;
            whereClause.append("=wi.").append("WORKITEM_ID");
            hasCondition = true;
            if (queues != null && !queues.isEmpty()) {
                whereClause.append(excludeQueuePerformer);
            }
        } else {
            if (hasCondition) {
                whereClause.append(" AND ");
            }
            DBConstants.ColConstants cfr_ignored_11 = BLControl.dbconsts.col;
            whereClause.append("wi.").append("STATUS");
            whereClause.append(" = ? ");
            hasCondition = true;
        }
        if (hasCondition) {
            whereClause.append(" AND ");
        }
        whereClause.append(joinWhereClause);
        mainClause.append(whereClause.toString());
        Connection conn = null;
        PreparedStatement pstmtGetWorkItemList = null;
        ResultSet rs = null;
        try {
            conn = WorkItemDAO.getConnection((boolean)readOnly);
            pstmtGetWorkItemList = conn.prepareStatement(mainClause.toString());
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", mainClause.toString(), new Object[0]);
            }
            int i = 1;
            if (ptIDs != null && ptIDs.length == 1) {
                pstmtGetWorkItemList.setLong(i++, ptIDs[0]);
            }
            if ((ptIDs == null || ptIDs.length == 0) && piIDs != null && piIDs.length == 1) {
                pstmtGetWorkItemList.setLong(i++, piIDs[0]);
            }
            if (performer != null) {
                if (BLUtil.isUserManagerCaseSensitive()) {
                    pstmtGetWorkItemList.setString(i++, performer);
                    if (queues != null && !queues.isEmpty()) {
                        for (int count = 0; count < queues.size(); ++count) {
                            pstmtGetWorkItemList.setString(i++, (String)queues.get(count));
                        }
                    }
                } else {
                    pstmtGetWorkItemList.setString(i++, performer.toLowerCase());
                    if (queues != null && !queues.isEmpty()) {
                        for (int count = 0; count < queues.size(); ++count) {
                            pstmtGetWorkItemList.setString(i++, ((String)queues.get(count)).toLowerCase());
                        }
                    }
                }
            }
            int n = i++;
            pstmtGetWorkItemList.setInt(n, 27);
            if (performer != null && queues != null && !queues.isEmpty()) {
                if (BLUtil.isUserManagerCaseSensitive()) {
                    pstmtGetWorkItemList.setString(i++, performer);
                } else {
                    pstmtGetWorkItemList.setString(i++, performer.toLowerCase());
                }
            }
            rs = pstmtGetWorkItemList.executeQuery();
            wiList = WorkItemDAO.readWorkItemFromResultSet(rs, true);
        }
        catch (Throwable th) {
            try {
                WorkItemDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                WorkItemDAO.clean(rs, pstmtGetWorkItemList, (Connection)conn);
                throw throwable;
            }
            WorkItemDAO.clean(rs, (Statement)pstmtGetWorkItemList, (Connection)conn);
        }
        WorkItemDAO.clean((ResultSet)rs, (Statement)pstmtGetWorkItemList, (Connection)conn);
        return wiList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getQueueWorkItemList(String[] queueNames, String[] excludeUsers, boolean readOnly) {
        int count;
        Vector wiList = new Vector();
        boolean ix = false;
        StringBuffer mainClause = new StringBuffer();
        if (queueNames.length == 1) {
            mainClause = new StringBuffer(getSingleQueueWorkItemList);
        } else {
            mainClause = new StringBuffer(getQueueWorkItemList);
            mainClause.append(" IN ( ? ");
            for (count = 1; count < queueNames.length; ++count) {
                mainClause.append(", ?");
            }
            mainClause.append(" ) ");
        }
        if (excludeUsers != null && excludeUsers.length > 0) {
            if (excludeUsers.length == 1) {
                mainClause.append(singleExcludeUserSubQuery);
            } else {
                mainClause.append(excludeUserSubQuery);
                mainClause.append(" IN ( ? ");
                for (count = 1; count < excludeUsers.length; ++count) {
                    mainClause.append(", ?");
                }
                mainClause.append(" )) ");
            }
        }
        Connection conn = null;
        PreparedStatement pstmtGetQueueWorkItemList = null;
        ResultSet rs = null;
        try {
            conn = WorkItemDAO.getConnection((boolean)readOnly);
            pstmtGetQueueWorkItemList = conn.prepareStatement(mainClause.toString());
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", mainClause.toString(), new Object[0]);
            }
            int i = 1;
            if (BLUtil.isUserManagerCaseSensitive()) {
                int count2;
                for (count2 = 0; count2 < queueNames.length; ++count2) {
                    pstmtGetQueueWorkItemList.setString(i++, queueNames[count2]);
                }
                if (excludeUsers != null) {
                    for (count2 = 0; count2 < excludeUsers.length; ++count2) {
                        pstmtGetQueueWorkItemList.setString(i++, excludeUsers[count2]);
                    }
                }
            } else {
                int count3;
                for (count3 = 0; count3 < queueNames.length; ++count3) {
                    pstmtGetQueueWorkItemList.setString(i++, queueNames[count3].toLowerCase());
                }
                if (excludeUsers != null) {
                    for (count3 = 0; count3 < excludeUsers.length; ++count3) {
                        pstmtGetQueueWorkItemList.setString(i++, excludeUsers[count3].toLowerCase());
                    }
                }
            }
            rs = pstmtGetQueueWorkItemList.executeQuery();
            wiList = WorkItemDAO.readWorkItemFromResultSet(rs, true);
        }
        catch (Throwable th) {
            try {
                WorkItemDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                WorkItemDAO.clean(rs, pstmtGetQueueWorkItemList, (Connection)conn);
                throw throwable;
            }
            WorkItemDAO.clean(rs, (Statement)pstmtGetQueueWorkItemList, (Connection)conn);
        }
        WorkItemDAO.clean((ResultSet)rs, (Statement)pstmtGetQueueWorkItemList, (Connection)conn);
        return wiList;
    }

    public static Vector getAssingedWorkItemList(long[] ptIDs, long[] piIDs, String performer, boolean readOnly) {
        int[] nArray = new int[1];
        nArray[0] = 28;
        return WorkItemDAO.getNonAvailableWorkItemList(ptIDs, piIDs, nArray, performer, readOnly);
    }

    public static Vector getWorkItemList(long[] ptIDs, long[] piIDs, int[] status, String performer, List queues, boolean readOnly) {
        Vector v = new Vector();
        Vector tmp = null;
        if (status == null) {
            tmp = WorkItemDAO.getAvailableWorkItemList(ptIDs, piIDs, performer, queues, readOnly);
            if (tmp != null) {
                v.addAll(tmp);
            }
            int[] nArray = new int[3];
            nArray[0] = 28;
            nArray[1] = 32;
            nArray[2] = 43;
            tmp = WorkItemDAO.getNonAvailableWorkItemList(ptIDs, piIDs, nArray, performer, readOnly);
            if (tmp != null) {
                v.addAll(tmp);
            }
        } else {
            if (status.length == 1) {
                if (status[0] == 27) {
                    return WorkItemDAO.getAvailableWorkItemList(ptIDs, piIDs, performer, queues, readOnly);
                }
            }
            Vector<Integer> s = new Vector<Integer>();
            int ix = 0;
            for (ix = 0; ix < status.length; ++ix) {
                if (status[ix] == 27) {
                    tmp = WorkItemDAO.getAvailableWorkItemList(ptIDs, piIDs, performer, queues, readOnly);
                    if (tmp == null) continue;
                    v.addAll(tmp);
                    continue;
                }
                s.addElement(status[ix]);
            }
            if (!s.isEmpty()) {
                int[] sa = new int[s.size()];
                for (ix = 0; ix < sa.length; ++ix) {
                    sa[ix] = (Integer)s.elementAt(ix);
                }
                tmp = WorkItemDAO.getNonAvailableWorkItemList(ptIDs, piIDs, sa, performer, readOnly);
                if (tmp != null) {
                    v.addAll(tmp);
                }
            }
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector getNonAvailableWorkItemList(long[] ptIDs, long[] piIDs, int[] status, String performer, boolean readOnly) {
        Vector wiList = new Vector();
        int ix = 0;
        boolean hasCondition = false;
        StringBuffer mainClause = new StringBuffer(getWorkItemList);
        StringBuffer whereClause = new StringBuffer(" WHERE ");
        if (ptIDs != null && ptIDs.length > 0) {
            DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
            whereClause.append("wi.").append("PROCESS_TEMPLATE_ID");
            if (ptIDs.length == 1) {
                whereClause.append(" = ? ");
            } else {
                whereClause.append(" IN (");
                for (ix = 0; ix < ptIDs.length; ++ix) {
                    whereClause.append(String.valueOf(ptIDs[ix]));
                    if (ix < ptIDs.length - 1) {
                        whereClause.append(", ");
                        continue;
                    }
                    whereClause.append(") ");
                }
            }
            hasCondition = true;
        }
        if (!hasCondition && piIDs != null && piIDs.length > 0) {
            DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
            whereClause.append("wi.").append("PROCESS_INSTANCE_ID");
            if (piIDs.length == 1) {
                whereClause.append(" = ? ");
            } else {
                whereClause.append(" IN (");
                for (ix = 0; ix < piIDs.length; ++ix) {
                    whereClause.append(String.valueOf(piIDs[ix]));
                    if (ix < piIDs.length - 1) {
                        whereClause.append(", ");
                        continue;
                    }
                    whereClause.append(") ");
                }
            }
            hasCondition = true;
        }
        if (status != null && status.length > 0) {
            if (hasCondition) {
                whereClause.append(" AND ");
            }
            DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
            whereClause.append("wi.").append("STATUS");
            if (status.length == 1) {
                whereClause.append(" = ? ");
            } else {
                whereClause.append(" IN (");
                for (ix = 0; ix < status.length; ++ix) {
                    whereClause.append(String.valueOf(status[ix]));
                    if (ix < status.length - 1) {
                        whereClause.append(", ");
                        continue;
                    }
                    whereClause.append(") ");
                }
            }
            hasCondition = true;
        }
        if (performer != null) {
            if (hasCondition) {
                whereClause.append(" AND ");
            }
            if (BLUtil.isUserManagerCaseSensitive()) {
                DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
                whereClause.append("wi.").append("PERFORMER");
                whereClause.append(" = ? ");
            } else {
                BLConstants.single();
                whereClause.append("lower(");
                DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
                whereClause.append("wi.").append("PERFORMER");
                whereClause.append(") = ? ");
            }
            hasCondition = true;
        }
        if (hasCondition) {
            whereClause.append(" AND ");
        }
        whereClause.append(joinWhereClause);
        mainClause.append(whereClause.toString());
        Connection conn = null;
        PreparedStatement pstmtGetWorkItemList = null;
        ResultSet rs = null;
        try {
            conn = WorkItemDAO.getConnection((boolean)readOnly);
            pstmtGetWorkItemList = conn.prepareStatement(mainClause.toString());
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", mainClause.toString(), new Object[0]);
            }
            int i = 1;
            if (ptIDs != null && ptIDs.length == 1) {
                pstmtGetWorkItemList.setLong(i++, ptIDs[0]);
            }
            if ((ptIDs == null || ptIDs.length == 0) && piIDs != null && piIDs.length == 1) {
                pstmtGetWorkItemList.setLong(i++, piIDs[0]);
            }
            if (status != null && status.length == 1) {
                pstmtGetWorkItemList.setInt(i++, status[0]);
            }
            if (performer != null) {
                if (BLUtil.isUserManagerCaseSensitive()) {
                    pstmtGetWorkItemList.setString(i++, performer);
                } else {
                    pstmtGetWorkItemList.setString(i++, performer.toLowerCase());
                }
            }
            rs = pstmtGetWorkItemList.executeQuery();
            wiList = WorkItemDAO.readWorkItemFromResultSet(rs, false);
        }
        catch (Throwable th) {
            try {
                WorkItemDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                WorkItemDAO.clean(rs, pstmtGetWorkItemList, (Connection)conn);
                throw throwable;
            }
            WorkItemDAO.clean(rs, (Statement)pstmtGetWorkItemList, (Connection)conn);
        }
        WorkItemDAO.clean((ResultSet)rs, (Statement)pstmtGetWorkItemList, (Connection)conn);
        return wiList;
    }

    public static synchronized void initSQLStatements() {
        createWorkItem = WorkItemDAO.getInsertQuery(CREATE_TABLELIST);
        createDynamicProcessWorkItem = WorkItemDAO.getInsertQuery(CREATE_DYNAMIC_PROCESS_TABLELIST);
        loadWorkItem = WorkItemDAO.getLoadWorkItemSql();
        findByPrimaryKey = WorkItemDAO.getFindByPrimaryKey();
        findByWorkStepInstance = WorkItemDAO.getFindByWorkStepInstance();
        findByName = WorkItemDAO.getFindByNameSql();
        getCountByWorkStepInstance = WorkItemDAO.getCountByWorkStepInstance();
        removeWorkItem = WorkItemDAO.getRemoveWorkItem();
        getWorkItemList = WorkItemDAO.getWorkItemList();
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        joinWhereClause = " wi." + "PROCESS_INSTANCE_ID" + " = pi." + "PROCESS_INSTANCE_ID";
        getIDByWorkStepInstance = WorkItemDAO.getIDByWorkStepInstance();
        getCountByProcessTemplateAndPerformer = WorkItemDAO.getCountByProcessTemplateAndPerformer();
        getCountByProcessTemplate = WorkItemDAO.getCountByProcessTemplate();
        getCountByProcessTemplateForAvailableWI = WorkItemDAO.getCountByProcessTemplateForAvailableWI();
        getWorkStepWorkItems = WorkItemDAO.getWorkStepWorkItems();
        findByPerformer = WorkItemDAO.getFindByPerformerSql();
        removeByProcessInstance = WorkItemDAO.getRemoveByProcessInstance();
        removeByWorkStepInstance = WorkItemDAO.getRemoveByWorkstepInstance();
        getQueueWorkItemList = WorkItemDAO.getQueueWorkItemList();
        getSingleQueueWorkItemList = getQueueWorkItemList + " IN (?)";
        excludeUserSubQuery = WorkItemDAO.excludeUserSubquery();
        singleExcludeUserSubQuery = excludeUserSubQuery + " IN ( ? ))";
        excludeQueuePerformer = WorkItemDAO.getExcludedQueuePerformer();
        getNextAvlWI = WorkItemDAO.getNextAvlWi();
        nextAvlWIWhereClause = WorkItemDAO.getNextAvlWiWhereClause();
        nextAvlWIJoinClause = WorkItemDAO.getNextAvlWiJoinClause();
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        orderByDueDate = " ORDER BY wi." + "DUEDATE";
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        orderByPriority = " ORDER BY wi." + "PRIORITY";
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        orderByStartTime = " ORDER BY wi." + "STARTTIME";
        defGetNextAvlWI = WorkItemDAO.getDefaultGetNextAvlWi();
        getWIStatus = WorkItemDAO.getWiStatus();
        getPIIdbyWIId = WorkItemDAO.getPiIdByWiId();
        WorkItemDAO.printSQLStatements();
    }

    private static String getInsertQuery(String[] createItemList) {
        int ix;
        DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
        StringBuffer sql = new StringBuffer("insert into ").append("BIZLOGIC_WORKITEM");
        WorkItemDAO.addRowlockHint((StringBuffer)sql);
        sql.append(" (");
        for (ix = 0; ix < createItemList.length; ++ix) {
            sql.append(createItemList[ix]);
            if (ix == createItemList.length - 1) continue;
            sql.append(", ");
        }
        sql.append(") values (");
        for (ix = 0; ix < createItemList.length; ++ix) {
            sql.append("?");
            if (ix == createItemList.length - 1) continue;
            sql.append(", ");
        }
        sql.append(")");
        return sql.toString();
    }

    private static String getLoadWorkItemSql() {
        StringBuilder sql = new StringBuilder("select ");
        for (int ix = 0; ix < LOAD_TABLELIST.length; ++ix) {
            sql.append(LOAD_TABLELIST[ix]);
            if (ix == LOAD_TABLELIST.length - 1) continue;
            sql.append(", ");
        }
        DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        return sql.append(" from ").append("BIZLOGIC_WORKITEM").append(" where ").append("WORKITEM_ID").append(" = ?").toString();
    }

    private static String getFindByPrimaryKey() {
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        DBConstants.TableConstants cfr_ignored_1 = BLControl.dbconsts.tab;
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        return "select " + "WORKITEM_ID" + " from " + "BIZLOGIC_WORKITEM" + " where " + "WORKITEM_ID" + " = ?";
    }

    private static String getFindByWorkStepInstance() {
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        DBConstants.TableConstants cfr_ignored_1 = BLControl.dbconsts.tab;
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        return "select " + "WORKITEM_ID" + " from " + "BIZLOGIC_WORKITEM" + " where " + "PROCESS_INSTANCE_ID" + " = ? AND " + "WORKSTEP_ID" + " = ?";
    }

    private static String getFindByNameSql() {
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        DBConstants.TableConstants cfr_ignored_1 = BLControl.dbconsts.tab;
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        return "select " + "WORKITEM_ID" + " from " + "BIZLOGIC_WORKITEM" + " where " + "WORKITEM_NAME" + " = ?";
    }

    private static String getCountByWorkStepInstance() {
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        DBConstants.TableConstants cfr_ignored_1 = BLControl.dbconsts.tab;
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        return "select count (" + "WORKITEM_ID" + " ) from " + "BIZLOGIC_WORKITEM" + " where " + "PROCESS_INSTANCE_ID" + " = ? AND " + "WORKSTEP_ID" + " = ?";
    }

    private static String getRemoveWorkItem() {
        DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        return "delete from " + "BIZLOGIC_WORKITEM" + " where " + "WORKITEM_ID" + " = ?";
    }

    private static String getWorkItemList() {
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        DBConstants.TableConstants cfr_ignored_3 = BLControl.dbconsts.tab;
        DBConstants.TableConstants cfr_ignored_4 = BLControl.dbconsts.tab;
        return WorkItemDAO.getSelectAllLoadTableField().append(", pi.").append("CREATOR").append(", pi.").append("PARENTID").append(", pi.").append("PROCESS_INSTANCE_NAME").append(" from ").append("BIZLOGIC_WORKITEM").append(" wi, ").append("BIZLOGIC_PROCESSINSTANCE").append(" pi ").toString();
    }

    private static String getIDByWorkStepInstance() {
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        DBConstants.TableConstants cfr_ignored_1 = BLControl.dbconsts.tab;
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        return "select " + "WORKITEM_ID" + " from " + "BIZLOGIC_WORKITEM" + " " + " where " + "PROCESS_INSTANCE_ID" + " = ? and " + "WORKSTEP_ID" + " = ? ";
    }

    private static String getCountByProcessTemplateAndPerformer() {
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        DBConstants.TableConstants cfr_ignored_2 = BLControl.dbconsts.tab;
        StringBuffer sql = new StringBuffer("select ").append("PROCESS_TEMPLATE_ID").append(", ").append("STATUS").append(", count(*)").append(" from ").append("BIZLOGIC_WORKITEM");
        WorkItemDAO.addNolockHint((StringBuffer)sql);
        sql.append(" where ");
        if (!BLUtil.isUserManagerCaseSensitive()) {
            BLConstants.single();
            sql.append("lower(");
        }
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
        sql.append("PERFORMER").append(" = ? group by ").append("PROCESS_TEMPLATE_ID").append(", ").append("STATUS");
        WorkItemDAO.addReadUncommittedHint((StringBuffer)sql);
        return sql.toString();
    }

    private static String getCountByProcessTemplate() {
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        DBConstants.TableConstants cfr_ignored_2 = BLControl.dbconsts.tab;
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        return new StringBuffer("select ").append("PROCESS_TEMPLATE_ID").append(", ").append("STATUS").append(", count(*)").append(" from ").append("BIZLOGIC_WORKITEM").append(" group by ").append("PROCESS_TEMPLATE_ID").append(", ").append("STATUS").toString();
    }

    private static String getCountByProcessTemplateForAvailableWI() {
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        DBConstants.TableConstants cfr_ignored_2 = BLControl.dbconsts.tab;
        StringBuffer sb = new StringBuffer("select wi.").append("PROCESS_TEMPLATE_ID").append(", wi.").append("STATUS").append(", count(*)").append(" from ").append("BIZLOGIC_AVAILABLEWORKITEM").append(" awi ");
        WorkItemDAO.addNolockHint((StringBuffer)sb);
        DBConstants.TableConstants cfr_ignored_3 = BLControl.dbconsts.tab;
        sb.append(" , ").append("BIZLOGIC_WORKITEM").append(" wi ");
        WorkItemDAO.addNolockHint((StringBuffer)sb);
        sb.append(" where ");
        if (BLUtil.isUserManagerCaseSensitive()) {
            DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
            sb.append(" awi.").append("AVAILABLEFOR").append(" = ? ");
        } else {
            DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
            sb.append("lower(").append("awi.").append("AVAILABLEFOR").append(") = ? ");
        }
        DBConstants.ColConstants cfr_ignored_6 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_7 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_8 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_9 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_10 = BLControl.dbconsts.col;
        sb.append(" and awi.").append("WORKITEM_ID").append(" = wi.").append("WORKITEM_ID").append(" and wi.").append("STATUS").append(" = ? ").append("group by wi.").append("PROCESS_TEMPLATE_ID").append(", wi.").append("STATUS");
        WorkItemDAO.addReadUncommittedHint((StringBuffer)sb);
        return sb.toString();
    }

    private static String getWorkStepWorkItems() {
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        return getWorkItemList + " where " + " wi." + "PROCESS_INSTANCE_ID" + " = ? and " + " wi." + "WORKSTEP_ID" + " = ? and " + joinWhereClause;
    }

    private static String getFindByPerformerSql() {
        StringBuilder sql = new StringBuilder("select distinct ");
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        DBConstants.TableConstants cfr_ignored_1 = BLControl.dbconsts.tab;
        sql.append("WORKITEM_ID").append(" from ").append("BIZLOGIC_WORKITEM").append(" ").append(" where ");
        if (BLUtil.isUserManagerCaseSensitive()) {
            DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
            sql.append("PERFORMER").append(" = ? OR ");
        } else {
            BLConstants.single();
            DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
            sql.append("lower(").append("PERFORMER").append(") = ? OR ");
        }
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
        DBConstants.TableConstants cfr_ignored_6 = BLControl.dbconsts.tab;
        sql.append("WORKITEM_ID").append(" IN ( select ").append("WORKITEM_ID").append(" from ").append("BIZLOGIC_AVAILABLEWORKITEM").append(" ").append(" where ");
        if (BLUtil.isUserManagerCaseSensitive()) {
            DBConstants.ColConstants cfr_ignored_7 = BLControl.dbconsts.col;
            sql.append("AVAILABLEFOR").append(" = ?)");
        } else {
            BLConstants.single();
            DBConstants.ColConstants cfr_ignored_8 = BLControl.dbconsts.col;
            sql.append("lower(").append("AVAILABLEFOR").append(") = ?)");
        }
        return sql.toString();
    }

    private static String getRemoveByProcessInstance() {
        DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        return "delete from " + "BIZLOGIC_WORKITEM" + " where " + "PROCESS_INSTANCE_ID" + " = ?";
    }

    private static String getRemoveByWorkstepInstance() {
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        return removeByProcessInstance + " AND " + "WORKSTEP_ID" + " = ?";
    }

    private static String getQueueWorkItemList() {
        StringBuilder sql = WorkItemDAO.getSelectAllLoadTableField();
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        DBConstants.TableConstants cfr_ignored_3 = BLControl.dbconsts.tab;
        DBConstants.TableConstants cfr_ignored_4 = BLControl.dbconsts.tab;
        DBConstants.TableConstants cfr_ignored_5 = BLControl.dbconsts.tab;
        DBConstants.ColConstants cfr_ignored_6 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_7 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_8 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_9 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_10 = BLControl.dbconsts.col;
        sql.append(", pi.").append("CREATOR").append(", pi.").append("PARENTID").append(", pi.").append("PROCESS_INSTANCE_NAME").append(" from ").append("BIZLOGIC_WORKITEM").append(" wi, ").append("BIZLOGIC_PROCESSINSTANCE").append(" pi, ").append("BIZLOGIC_AVAILABLEWORKITEM").append(" awi ").append(" WHERE ").append(" wi.").append("PROCESS_INSTANCE_ID").append(" = pi.").append("PROCESS_INSTANCE_ID").append(" AND wi.").append("WORKITEM_ID").append("=awi.").append("WORKITEM_ID").append(" AND wi.").append("STATUS").append(" = ").append(27);
        if (BLUtil.isUserManagerCaseSensitive()) {
            DBConstants.ColConstants cfr_ignored_11 = BLControl.dbconsts.col;
            sql.append(" AND awi.").append("AVAILABLEFOR");
        } else {
            StringBuilder stringBuilder = sql.append(" AND ");
            BLConstants.single();
            DBConstants.ColConstants cfr_ignored_12 = BLControl.dbconsts.col;
            stringBuilder.append("lower(").append("awi.").append("AVAILABLEFOR").append(")");
        }
        return sql.toString();
    }

    private static StringBuilder getSelectAllLoadTableField() {
        StringBuilder sql = new StringBuilder("select ");
        for (int ix = 0; ix < LOAD_TABLELIST.length; ++ix) {
            sql.append("wi." + LOAD_TABLELIST[ix]);
            if (ix == LOAD_TABLELIST.length - 1) continue;
            sql.append(", ");
        }
        return sql;
    }

    private static String excludeUserSubquery() {
        StringBuilder sql = new StringBuilder(" AND NOT EXISTS (select ");
        if (!BLUtil.isUserManagerCaseSensitive()) {
            BLConstants.single();
            sql.append("lower(");
        }
        DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        sql.append("BIZLOGIC_EXCLUDE_PERFORMER").append(".").append("PERFORMER");
        if (!BLUtil.isUserManagerCaseSensitive()) {
            sql.append(")");
        }
        DBConstants.TableConstants cfr_ignored_2 = BLControl.dbconsts.tab;
        DBConstants.TableConstants cfr_ignored_3 = BLControl.dbconsts.tab;
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
        DBConstants.TableConstants cfr_ignored_6 = BLControl.dbconsts.tab;
        DBConstants.ColConstants cfr_ignored_7 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_8 = BLControl.dbconsts.col;
        sql.append(" from ").append("BIZLOGIC_EXCLUDE_PERFORMER").append(" where ").append("BIZLOGIC_EXCLUDE_PERFORMER").append(".").append("PROCESS_INSTANCE_ID").append(" = ").append("wi.").append("PROCESS_INSTANCE_ID").append(" AND ").append("BIZLOGIC_EXCLUDE_PERFORMER").append(".").append("WORKSTEP_ID").append(" = ").append("wi.").append("WORKSTEP_ID").append(" AND ");
        if (!BLUtil.isUserManagerCaseSensitive()) {
            BLConstants.single();
            sql.append("lower(");
        }
        DBConstants.TableConstants cfr_ignored_9 = BLControl.dbconsts.tab;
        DBConstants.ColConstants cfr_ignored_10 = BLControl.dbconsts.col;
        sql.append("BIZLOGIC_EXCLUDE_PERFORMER").append(".").append("PERFORMER");
        if (!BLUtil.isUserManagerCaseSensitive()) {
            sql.append(")");
        }
        return sql.toString();
    }

    private static String getExcludedQueuePerformer() {
        StringBuilder sql = new StringBuilder(" AND ? NOT IN (select ");
        if (!BLUtil.isUserManagerCaseSensitive()) {
            BLConstants.single();
            sql.append("lower(");
        }
        DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        sql.append("BIZLOGIC_EXCLUDE_PERFORMER").append(".").append("PERFORMER");
        if (!BLUtil.isUserManagerCaseSensitive()) {
            sql.append(")");
        }
        DBConstants.TableConstants cfr_ignored_2 = BLControl.dbconsts.tab;
        DBConstants.TableConstants cfr_ignored_3 = BLControl.dbconsts.tab;
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
        DBConstants.TableConstants cfr_ignored_6 = BLControl.dbconsts.tab;
        DBConstants.ColConstants cfr_ignored_7 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_8 = BLControl.dbconsts.col;
        return sql.append(" from ").append("BIZLOGIC_EXCLUDE_PERFORMER").append(" where ").append("BIZLOGIC_EXCLUDE_PERFORMER").append(".").append("PROCESS_INSTANCE_ID").append(" = wi.").append("PROCESS_INSTANCE_ID").append(" AND ").append("BIZLOGIC_EXCLUDE_PERFORMER").append(".").append("WORKSTEP_ID").append(" = wi.").append("WORKSTEP_ID").append(" ) ").toString();
    }

    private static String getNextAvlWi() {
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        DBConstants.TableConstants cfr_ignored_4 = BLControl.dbconsts.tab;
        DBConstants.TableConstants cfr_ignored_5 = BLControl.dbconsts.tab;
        DBConstants.TableConstants cfr_ignored_6 = BLControl.dbconsts.tab;
        DBConstants.TableConstants cfr_ignored_7 = BLControl.dbconsts.tab;
        return WorkItemDAO.getSelectAllLoadTableField().append(", pi.").append("CREATOR").append(", pi.").append("PARENTID").append(", pi.").append("PROCESS_INSTANCE_NAME").append(", ws.").append("INSTRUCTION").append(" from ").append("BIZLOGIC_WORKITEM").append(" wi, ").append("BIZLOGIC_WORKSTEPINSTANCE").append(" ws, ").append("BIZLOGIC_PROCESSINSTANCE").append(" pi, ").append("BIZLOGIC_AVAILABLEWORKITEM").append(" awi WHERE ").toString();
    }

    private static String getNextAvlWiWhereClause() {
        StringBuilder sql = new StringBuilder(100);
        if (BLUtil.isUserManagerCaseSensitive()) {
            DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
            sql.append(" awi.").append("AVAILABLEFOR");
        } else {
            BLConstants.single();
            DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
            sql.append("lower(").append("awi.").append("AVAILABLEFOR");
        }
        return sql.append(" IN ( ? ").toString();
    }

    private static String getNextAvlWiJoinClause() {
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_6 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_7 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_8 = BLControl.dbconsts.col;
        return " AND wi." + "WORKITEM_ID" + "= awi." + "WORKITEM_ID" + " AND wi." + "STATUS" + " = " + 27 + " AND wi." + "PROCESS_INSTANCE_ID" + " = pi." + "PROCESS_INSTANCE_ID" + " AND wi." + "PROCESS_INSTANCE_ID" + " = ws." + "PROCESS_INSTANCE_ID" + " AND wi." + "WORKSTEP_ID" + "= ws." + "WORKSTEP_ID";
    }

    private static String getDefaultGetNextAvlWi() {
        StringBuilder sql = new StringBuilder(getNextAvlWI);
        if (BLUtil.isUserManagerCaseSensitive()) {
            DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
            sql.append(" awi.").append("AVAILABLEFOR").append(" IN ( ? ) ");
        } else {
            BLConstants.single();
            DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
            sql.append("lower(").append("awi.").append("AVAILABLEFOR").append(") IN ( ? ) ");
        }
        return sql.append(nextAvlWIJoinClause).append(orderByDueDate).toString();
    }

    private static String getWiStatus() {
        DBConstants.KeywordConstants cfr_ignored_0 = BLControl.dbconsts.kwd;
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        DBConstants.KeywordConstants cfr_ignored_2 = BLControl.dbconsts.kwd;
        DBConstants.TableConstants cfr_ignored_3 = BLControl.dbconsts.tab;
        DBConstants.KeywordConstants cfr_ignored_4 = BLControl.dbconsts.kwd;
        DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
        DBConstants.KeywordConstants cfr_ignored_6 = BLControl.dbconsts.kwd;
        return " SELECT " + "STATUS" + " FROM " + "BIZLOGIC_WORKITEM" + " WHERE " + "WORKITEM_ID" + " = ? ";
    }

    private static String getPiIdByWiId() {
        DBConstants.KeywordConstants cfr_ignored_0 = BLControl.dbconsts.kwd;
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        DBConstants.KeywordConstants cfr_ignored_2 = BLControl.dbconsts.kwd;
        DBConstants.TableConstants cfr_ignored_3 = BLControl.dbconsts.tab;
        DBConstants.KeywordConstants cfr_ignored_4 = BLControl.dbconsts.kwd;
        DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
        DBConstants.KeywordConstants cfr_ignored_6 = BLControl.dbconsts.kwd;
        return " SELECT " + "PROCESS_INSTANCE_ID" + " FROM " + "BIZLOGIC_WORKITEM" + " WHERE " + "WORKITEM_ID" + " = ? ";
    }

    private static void printSQLStatements() {
        if (BLControl.util.DEBUG_DAO) {
            BLControl.logger.debug((Object)"WorkItemDAO:");
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeWorkItem, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", loadWorkItem, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", createWorkItem, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", findByPrimaryKey, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", findByWorkStepInstance, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getCountByWorkStepInstance, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getWorkItemList, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", joinWhereClause, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getCountByProcessTemplateAndPerformer, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getCountByProcessTemplate, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getCountByProcessTemplateForAvailableWI, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getWorkStepWorkItems, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", findByPerformer, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", createDynamicProcessWorkItem, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeByProcessInstance, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeByWorkStepInstance, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", defGetNextAvlWI, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getWIStatus, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getPIIdbyWIId, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getSingleQueueWorkItemList, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", singleExcludeUserSubQuery, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", excludeQueuePerformer, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection findByName(String wiName) {
        Vector<Long> primaryKeys = new Vector<Long>();
        Connection conn = null;
        PreparedStatement pstmtFindByName = null;
        ResultSet rs = null;
        try {
            conn = WorkItemDAO.getConnection();
            pstmtFindByName = conn.prepareStatement(findByName);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", findByName, new Object[0]);
            }
            pstmtFindByName.setString(1, wiName);
            rs = pstmtFindByName.executeQuery();
            while (rs.next()) {
                primaryKeys.addElement(rs.getLong(1));
            }
        }
        catch (Throwable th) {
            try {
                WorkItemDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                WorkItemDAO.clean(rs, (Statement)pstmtFindByName, (Connection)conn);
            }
        }
        WorkItemDAO.clean((ResultSet)rs, (Statement)pstmtFindByName, (Connection)conn);
        return primaryKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getIDByWorkStepInstance(long piid, long wsid, int status) {
        StringBuffer mainClause = new StringBuffer(getIDByWorkStepInstance);
        if (status == 32) {
            mainClause.append(" and ");
            DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
            mainClause.append("STATUS");
            mainClause.append(" = ? ");
        } else if (status == 26) {
            mainClause.append(" and (");
            DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
            mainClause.append("STATUS");
            mainClause.append(" = ? ");
            mainClause.append(" or ");
            DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
            mainClause.append("STATUS");
            mainClause.append(" = ? )");
        }
        String sql = mainClause.toString();
        Vector<Long> ids = new Vector<Long>();
        Connection conn = null;
        PreparedStatement pstmtGetIDByWorkStepInstance = null;
        ResultSet rs = null;
        try {
            conn = WorkItemDAO.getConnection();
            pstmtGetIDByWorkStepInstance = conn.prepareStatement(sql);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", sql, new Object[0]);
            }
            pstmtGetIDByWorkStepInstance.setLong(1, piid);
            pstmtGetIDByWorkStepInstance.setLong(2, wsid);
            if (status == 32) {
                pstmtGetIDByWorkStepInstance.setLong(3, 32L);
            } else {
                pstmtGetIDByWorkStepInstance.setLong(3, 28L);
                pstmtGetIDByWorkStepInstance.setLong(4, 27L);
            }
            rs = pstmtGetIDByWorkStepInstance.executeQuery();
            while (rs.next()) {
                ids.addElement(rs.getLong(1));
            }
        }
        catch (Throwable th) {
            try {
                WorkItemDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                WorkItemDAO.clean(rs, (Statement)pstmtGetIDByWorkStepInstance, (Connection)conn);
            }
        }
        WorkItemDAO.clean((ResultSet)rs, (Statement)pstmtGetIDByWorkStepInstance, (Connection)conn);
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Vector getWorkItemList(long piID, long wsID, boolean readOnly) {
        Vector vector;
        Vector wiList = new Vector();
        boolean ix = false;
        Connection conn = null;
        PreparedStatement pstmtGetWorkItemList = null;
        ResultSet rs = null;
        try {
            conn = WorkItemDAO.getConnection((boolean)readOnly);
            pstmtGetWorkItemList = conn.prepareStatement(getWorkStepWorkItems);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", getWorkStepWorkItems, new Object[0]);
            }
            pstmtGetWorkItemList.setLong(1, piID);
            pstmtGetWorkItemList.setLong(2, wsID);
            boolean i = true;
            rs = pstmtGetWorkItemList.executeQuery();
            vector = WorkItemDAO.readWorkItemFromResultSet(rs, false);
        }
        catch (Throwable th) {
            try {
                WorkItemDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                WorkItemDAO.clean(rs, pstmtGetWorkItemList, (Connection)conn);
                throw throwable;
            }
            WorkItemDAO.clean(rs, (Statement)pstmtGetWorkItemList, (Connection)conn);
            return wiList;
        }
        WorkItemDAO.clean((ResultSet)rs, (Statement)pstmtGetWorkItemList, (Connection)conn);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection findByPerformer(String performer) {
        Vector<Long> primaryKeys = new Vector<Long>();
        Connection conn = null;
        PreparedStatement pstmtFindByPerformer = null;
        ResultSet rs = null;
        try {
            conn = WorkItemDAO.getConnection();
            pstmtFindByPerformer = conn.prepareStatement(findByPerformer);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", findByPerformer, new Object[0]);
            }
            pstmtFindByPerformer.setString(1, performer);
            pstmtFindByPerformer.setString(2, performer);
            rs = pstmtFindByPerformer.executeQuery();
            while (rs.next()) {
                primaryKeys.addElement(rs.getLong(1));
            }
        }
        catch (Throwable th) {
            try {
                WorkItemDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                WorkItemDAO.clean(rs, (Statement)pstmtFindByPerformer, (Connection)conn);
            }
        }
        WorkItemDAO.clean((ResultSet)rs, (Statement)pstmtFindByPerformer, (Connection)conn);
        return primaryKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getProxyWorkItemList(Map proxyForAndApp, int[] status, boolean isOnlyAvailable, boolean readOnly) {
        StringBuffer getProxyWorkItem = new StringBuffer(getWorkItemList);
        if (isOnlyAvailable) {
            DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
            getProxyWorkItem.append(", ").append("BIZLOGIC_AVAILABLEWORKITEM").append(" awi ");
        }
        getProxyWorkItem.append(WorkItemDAO.composeWhereClause(proxyForAndApp, status, isOnlyAvailable));
        Vector wiList = new Vector();
        Connection conn = null;
        PreparedStatement pstmtGetProxyWorkItem = null;
        ResultSet rs = null;
        try {
            conn = WorkItemDAO.getConnection((boolean)readOnly);
            pstmtGetProxyWorkItem = conn.prepareStatement(getProxyWorkItem.toString());
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", getProxyWorkItem.toString(), new Object[0]);
            }
            rs = pstmtGetProxyWorkItem.executeQuery();
            wiList = isOnlyAvailable ? WorkItemDAO.readWorkItemFromResultSet(rs, true) : WorkItemDAO.readWorkItemFromResultSet(rs, false);
        }
        catch (Throwable th) {
            try {
                WorkItemDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                WorkItemDAO.clean(rs, pstmtGetProxyWorkItem, (Connection)conn);
                throw throwable;
            }
            WorkItemDAO.clean(rs, (Statement)pstmtGetProxyWorkItem, (Connection)conn);
        }
        WorkItemDAO.clean((ResultSet)rs, (Statement)pstmtGetProxyWorkItem, (Connection)conn);
        return wiList;
    }

    private static String composeWhereClause(Map proxyForAndApp, int[] status, boolean isOnlyAvailable) {
        StringBuffer whereClause = new StringBuffer(" where (");
        boolean hasCondition = false;
        Map.Entry entry2 = null;
        String performer = null;
        ArrayList ptIDs = null;
        for (Map.Entry entry2 : proxyForAndApp.entrySet()) {
            String subWhere;
            performer = (String)entry2.getKey();
            ptIDs = (ArrayList)entry2.getValue();
            if (hasCondition) {
                whereClause.append(" OR ");
            }
            if (SBMUtil.self().isUseQueue() && isOnlyAvailable) {
                List performers = BLControl.queueManager.getQueues(performer);
                performers.add(performer);
                subWhere = WorkItemDAO.composeWhereClauseForAvailable(ptIDs, performers);
            } else {
                subWhere = WorkItemDAO.composeWhereClause(ptIDs, null, status, performer, isOnlyAvailable);
            }
            if (subWhere == null || subWhere.trim().length() <= 0) continue;
            whereClause.append("(").append(subWhere).append(")");
            hasCondition = true;
        }
        if (status != null && status.length > 0) {
            if (hasCondition) {
                whereClause.append(" ) AND ");
            }
            DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
            whereClause.append("wi.").append("STATUS");
            whereClause.append(WorkItemDAO.getSQLCondition((int[])status));
            hasCondition = true;
        }
        if (isOnlyAvailable) {
            if (hasCondition) {
                whereClause.append(" AND ");
            }
            DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
            whereClause.append(" wi.").append("WORKITEM_ID");
            DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
            whereClause.append("=awi.").append("WORKITEM_ID");
            hasCondition = true;
        }
        if (hasCondition) {
            whereClause.append(" AND ");
        }
        whereClause.append(joinWhereClause);
        return whereClause.toString();
    }

    private static String composeWhereClause(ArrayList ptIDs, long[] piIDs, int[] status, String performer, boolean isAvailableOnly) {
        StringBuffer whereClause = new StringBuffer(100);
        boolean hasCondition = false;
        if (ptIDs != null && !ptIDs.isEmpty()) {
            DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
            whereClause.append("wi.").append("PROCESS_TEMPLATE_ID");
            whereClause.append(WorkItemDAO.getSQLCondition((List)ptIDs));
            hasCondition = true;
        }
        if (!hasCondition && piIDs != null && piIDs.length > 0) {
            DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
            whereClause.append("wi.").append("PROCESS_INSTANCE_ID");
            whereClause.append(WorkItemDAO.getSQLCondition((long[])piIDs));
            hasCondition = true;
        }
        if (performer != null) {
            if (hasCondition) {
                whereClause.append(" AND ");
            }
            if (isAvailableOnly) {
                if (BLUtil.isUserManagerCaseSensitive()) {
                    DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
                    whereClause.append("awi.").append("AVAILABLEFOR");
                    whereClause.append(" = '").append(performer).append("' ");
                } else {
                    BLConstants.single();
                    DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
                    whereClause.append("lower(").append("awi.").append("AVAILABLEFOR");
                    whereClause.append(") = '").append(performer.toLowerCase()).append("' ");
                }
            } else if (BLUtil.isUserManagerCaseSensitive()) {
                DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
                whereClause.append("wi.").append("PERFORMER");
                whereClause.append(" = '").append(performer).append("' ");
            } else {
                BLConstants.single();
                DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
                whereClause.append("lower(").append("wi.").append("PERFORMER");
                whereClause.append(") = '").append(performer.toLowerCase()).append("' ");
            }
            hasCondition = true;
        }
        return whereClause.toString();
    }

    private static String composeWhereClauseForAvailable(ArrayList ptIDs, List<String> performers) {
        StringBuffer whereClause = new StringBuffer(100);
        boolean hasCondition = false;
        if (ptIDs != null && !ptIDs.isEmpty()) {
            DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
            whereClause.append("wi.").append("PROCESS_TEMPLATE_ID");
            whereClause.append(WorkItemDAO.getSQLCondition((List)ptIDs));
            hasCondition = true;
        }
        if (performers != null && !performers.isEmpty()) {
            if (hasCondition) {
                whereClause.append(" AND ");
            }
            if (BLUtil.isUserManagerCaseSensitive()) {
                DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
                whereClause.append("awi.").append("AVAILABLEFOR");
                whereClause.append(WorkItemDAO.getSQLCondition((String[])performers.toArray(new String[0])));
            } else {
                BLConstants.single();
                whereClause.append("lower(");
                DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
                whereClause.append("awi.").append("AVAILABLEFOR").append(")");
                String[] performerArr = performers.toArray(new String[0]);
                String[] performerNames = new String[performers.size()];
                for (int idx = 0; idx < performerArr.length; ++idx) {
                    performerNames[idx] = performerArr[idx].toLowerCase();
                }
                whereClause.append(WorkItemDAO.getSQLCondition((String[])performerNames));
            }
        }
        return whereClause.toString();
    }

    private static Vector readWorkItemFromResultSet(ResultSet rs, boolean isDistinct) throws SQLException {
        ArrayList<Long> wiids = new ArrayList<Long>();
        Long wiid = null;
        Vector wiList = new Vector();
        int ix = 0;
        while (rs.next()) {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            ix = 0;
            wiid = rs.getLong(1);
            if (isDistinct) {
                if (wiids.contains(wiid)) continue;
                wiids.add(wiid);
            }
            attrs.put(LOAD_LIST[ix++], wiid);
            attrs.put(LOAD_LIST[ix++], rs.getLong(2));
            attrs.put(LOAD_LIST[ix++], rs.getLong(3));
            attrs.put(LOAD_LIST[ix++], rs.getLong(4));
            attrs.put(LOAD_LIST[ix++], rs.getString(5));
            attrs.put(LOAD_LIST[ix++], WorkItemDAO.getDateValue((ResultSet)rs, (int)6));
            attrs.put(LOAD_LIST[ix++], WorkItemDAO.getDateValue((ResultSet)rs, (int)7));
            attrs.put(LOAD_LIST[ix++], WorkItemDAO.getDateValue((ResultSet)rs, (int)8));
            attrs.put(LOAD_LIST[ix++], rs.getInt(9));
            attrs.put(LOAD_LIST[ix++], rs.getInt(10));
            attrs.put(LOAD_LIST[ix++], rs.getInt(11));
            attrs.put(LOAD_LIST[ix++], rs.getString(12));
            attrs.put(LOAD_LIST[ix++], rs.getString(13));
            attrs.put(LOAD_LIST[ix++], rs.getString(14));
            attrs.put(LOAD_LIST[ix++], rs.getString(15));
            attrs.put(LOAD_LIST[ix++], WorkItemDAO.getDateValue((ResultSet)rs, (int)16));
            attrs.put(LOAD_LIST[ix++], rs.getString(17));
            attrs.put(LOAD_LIST[ix++], rs.getLong(18));
            attrs.put(LOAD_LIST[ix++], rs.getString(19));
            wiList.addElement(attrs);
        }
        return wiList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getProcessInstanceId(long wiid) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        long piid;
        block5: {
            piid = -1L;
            conn = null;
            pstmt = null;
            rs = null;
            try {
                conn = WorkItemDAO.getConnection();
                pstmt = conn.prepareStatement(getPIIdbyWIId);
                pstmt.setLong(1, wiid);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block5;
                piid = rs.getLong(1);
            }
            catch (Throwable th) {
                try {
                    WorkItemDAO.handle((Throwable)th);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    WorkItemDAO.clean(rs, (Statement)pstmt, (Connection)conn);
                }
            }
        }
        WorkItemDAO.clean((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return piid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getNextAvailableWorkItems(String performer, Map filter) {
        BMTimer getNextAvlWITimer = null;
        if (BLUtil.doBenchmark()) {
            getNextAvlWITimer = BMTimer.getInstance((String)"getNextAvlWITimer");
            getNextAvlWITimer.setLogger(BLControl.logger);
            getNextAvlWITimer.resetStartTime();
        }
        List ptList = null;
        List wsList = null;
        List queues = null;
        String query = null;
        String orderBy = "";
        int fetchsize = 1;
        BLConstants.single();
        ptList = (List)filter.get("PROCESSTEMPLATEID");
        BLConstants.single();
        wsList = (List)filter.get("WORKSTEPNAME");
        BLConstants.single();
        orderBy = (String)filter.get("ORDER_BY");
        BLConstants.single();
        fetchsize = (Integer)filter.get("FETCHSIZE");
        if (SBMControl.util.isUseQueue()) {
            queues = PerformerUtil.getQueues((String)performer);
        }
        if (!BLUtil.isUserManagerCaseSensitive()) {
            performer = performer.toLowerCase();
            if (queues != null) {
                for (int ix = 0; ix < queues.size(); ++ix) {
                    queues.set(ix, ((String)queues.get(ix)).toLowerCase());
                }
            }
        }
        query = WorkItemDAO.getNextAvlQuery(ptList, wsList, performer, queues, orderBy);
        Connection conn = null;
        PreparedStatement pstmtGetNextAvlWorkItemList = null;
        ResultSet rs = null;
        Vector wiList = null;
        try {
            conn = WorkItemDAO.getConnection();
            pstmtGetNextAvlWorkItemList = conn.prepareStatement(query);
            WorkItemDAO.setMaxRows((Statement)pstmtGetNextAvlWorkItemList, (int)fetchsize);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", query, new Object[0]);
            }
            int i = 1;
            pstmtGetNextAvlWorkItemList.setString(i++, performer);
            if (queues != null && !queues.isEmpty()) {
                for (int count = 0; count < queues.size(); ++count) {
                    pstmtGetNextAvlWorkItemList.setString(i++, (String)queues.get(count));
                }
                pstmtGetNextAvlWorkItemList.setString(i++, performer);
            }
            rs = pstmtGetNextAvlWorkItemList.executeQuery();
            wiList = WorkItemDAO.readWorkItemFromResultSet(rs, true);
        }
        catch (Throwable th) {
            try {
                WorkItemDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                WorkItemDAO.clean(rs, (Statement)pstmtGetNextAvlWorkItemList, (Connection)conn);
            }
        }
        WorkItemDAO.clean((ResultSet)rs, (Statement)pstmtGetNextAvlWorkItemList, (Connection)conn);
        long et = System.currentTimeMillis();
        if (BLUtil.doBenchmark() && getNextAvlWITimer != null) {
            getNextAvlWITimer.printTime(Thread.currentThread().getName());
        }
        return wiList;
    }

    private static String getNextAvlQuery(List ptList, List wsList, String performer, List queues, String orderBy) {
        String query = null;
        query = WorkItemDAO.getDefaultNextAvlQuery(ptList, wsList, orderBy);
        if (query != null) {
            return query;
        }
        StringBuffer sb = new StringBuffer(getNextAvlWI);
        if (ptList != null && !ptList.isEmpty()) {
            DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
            sb.append(" wi.").append("PROCESS_TEMPLATE_ID");
            sb.append(WorkItemDAO.getSQLCondition((List)ptList)).append(" AND ");
        }
        if (wsList != null && !wsList.isEmpty()) {
            DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
            sb.append(" ws.").append("WORKSTEP_NAME");
            sb.append(WorkItemDAO.getStringList((List)wsList)).append(" AND ");
        }
        sb.append(nextAvlWIWhereClause);
        if (SBMControl.util.isUseQueue()) {
            if (queues != null && !queues.isEmpty()) {
                for (int count = 0; count < queues.size(); ++count) {
                    sb.append(", ?");
                }
                sb.append(" ) ").append(excludeQueuePerformer);
            } else {
                sb.append(" ) ");
            }
        } else {
            sb.append(" ) ");
        }
        sb.append(nextAvlWIJoinClause);
        sb.append(orderBy);
        query = sb.toString();
        return query;
    }

    private static String getDefaultNextAvlQuery(List ptList, List wsList, String orderBy) {
        if (ptList == null && wsList == null) {
            BLConstants.single();
            if (orderBy.endsWith("DUEDATE") && !SBMControl.util.isUseQueue() && BLUtil.isUserManagerCaseSensitive()) {
                return defGetNextAvlWI;
            }
        }
        return null;
    }

    private static String getPrimaryKey(long wiid) {
        StringBuffer parameterValues = new StringBuffer("wiid=");
        parameterValues.append(wiid);
        return parameterValues.toString();
    }

    static {
        String[] stringArray = new String[14];
        stringArray[0] = "WORKITEMID";
        stringArray[1] = "PROCESSTEMPLATEID";
        stringArray[2] = "PROCESSINSTANCEID";
        stringArray[3] = "WORKSTEPID";
        stringArray[4] = "WORKSTEPNAME";
        stringArray[5] = "STARTTIME";
        stringArray[6] = "DUEDATE";
        stringArray[7] = "STATUS";
        stringArray[8] = "PRIORITY";
        stringArray[9] = "WORKITEMNAME";
        stringArray[10] = "PERFORMER";
        stringArray[11] = "PREVIOUSASSIGNEE";
        stringArray[12] = "RESPONSE";
        stringArray[13] = "READTIME";
        CREATE_LIST = stringArray;
        String[] stringArray2 = new String[14];
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        stringArray2[0] = "WORKITEM_ID";
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        stringArray2[1] = "PROCESS_TEMPLATE_ID";
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        stringArray2[2] = "PROCESS_INSTANCE_ID";
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        stringArray2[3] = "WORKSTEP_ID";
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        stringArray2[4] = "WORKSTEP_NAME";
        DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
        stringArray2[5] = "STARTTIME";
        DBConstants.ColConstants cfr_ignored_6 = BLControl.dbconsts.col;
        stringArray2[6] = "DUEDATE";
        DBConstants.ColConstants cfr_ignored_7 = BLControl.dbconsts.col;
        stringArray2[7] = "STATUS";
        DBConstants.ColConstants cfr_ignored_8 = BLControl.dbconsts.col;
        stringArray2[8] = "PRIORITY";
        DBConstants.ColConstants cfr_ignored_9 = BLControl.dbconsts.col;
        stringArray2[9] = "WORKITEM_NAME";
        DBConstants.ColConstants cfr_ignored_10 = BLControl.dbconsts.col;
        stringArray2[10] = "PERFORMER";
        DBConstants.ColConstants cfr_ignored_11 = BLControl.dbconsts.col;
        stringArray2[11] = "PREVIOUSASSIGNEE";
        stringArray2[12] = "RESPONSE";
        stringArray2[13] = "READTIME";
        CREATE_TABLELIST = stringArray2;
        String[] stringArray3 = new String[19];
        stringArray3[0] = "WORKITEMID";
        stringArray3[1] = "PROCESSTEMPLATEID";
        stringArray3[2] = "PROCESSINSTANCEID";
        stringArray3[3] = "WORKSTEPID";
        stringArray3[4] = "WORKSTEPNAME";
        stringArray3[5] = "STARTTIME";
        stringArray3[6] = "ENDTIME";
        stringArray3[7] = "DUEDATE";
        stringArray3[8] = "STATUS";
        stringArray3[9] = "PREVIOUSSTATUS";
        stringArray3[10] = "PRIORITY";
        stringArray3[11] = "WORKITEMNAME";
        stringArray3[12] = "PERFORMER";
        stringArray3[13] = "PREVIOUSASSIGNEE";
        stringArray3[14] = "RESPONSE";
        stringArray3[15] = "READTIME";
        stringArray3[16] = "CREATOR";
        stringArray3[17] = "PARENTID";
        stringArray3[18] = "PROCESSINSTANCENAME";
        LOAD_LIST = stringArray3;
        String[] stringArray4 = new String[16];
        DBConstants.ColConstants cfr_ignored_12 = BLControl.dbconsts.col;
        stringArray4[0] = "WORKITEM_ID";
        DBConstants.ColConstants cfr_ignored_13 = BLControl.dbconsts.col;
        stringArray4[1] = "PROCESS_TEMPLATE_ID";
        DBConstants.ColConstants cfr_ignored_14 = BLControl.dbconsts.col;
        stringArray4[2] = "PROCESS_INSTANCE_ID";
        DBConstants.ColConstants cfr_ignored_15 = BLControl.dbconsts.col;
        stringArray4[3] = "WORKSTEP_ID";
        DBConstants.ColConstants cfr_ignored_16 = BLControl.dbconsts.col;
        stringArray4[4] = "WORKSTEP_NAME";
        DBConstants.ColConstants cfr_ignored_17 = BLControl.dbconsts.col;
        stringArray4[5] = "STARTTIME";
        DBConstants.ColConstants cfr_ignored_18 = BLControl.dbconsts.col;
        stringArray4[6] = "ENDTIME";
        DBConstants.ColConstants cfr_ignored_19 = BLControl.dbconsts.col;
        stringArray4[7] = "DUEDATE";
        DBConstants.ColConstants cfr_ignored_20 = BLControl.dbconsts.col;
        stringArray4[8] = "STATUS";
        DBConstants.ColConstants cfr_ignored_21 = BLControl.dbconsts.col;
        stringArray4[9] = "PREVIOUSSTATUS";
        DBConstants.ColConstants cfr_ignored_22 = BLControl.dbconsts.col;
        stringArray4[10] = "PRIORITY";
        DBConstants.ColConstants cfr_ignored_23 = BLControl.dbconsts.col;
        stringArray4[11] = "WORKITEM_NAME";
        DBConstants.ColConstants cfr_ignored_24 = BLControl.dbconsts.col;
        stringArray4[12] = "PERFORMER";
        DBConstants.ColConstants cfr_ignored_25 = BLControl.dbconsts.col;
        stringArray4[13] = "PREVIOUSASSIGNEE";
        stringArray4[14] = "RESPONSE";
        stringArray4[15] = "READTIME";
        LOAD_TABLELIST = stringArray4;
        String[] stringArray5 = new String[13];
        stringArray5[0] = "WORKITEMID";
        stringArray5[1] = "PROCESSTEMPLATEID";
        stringArray5[2] = "PROCESSINSTANCEID";
        stringArray5[3] = "WORKSTEPID";
        stringArray5[4] = "WORKSTEPNAME";
        stringArray5[5] = "STARTTIME";
        stringArray5[6] = "DUEDATE";
        stringArray5[7] = "STATUS";
        stringArray5[8] = "PRIORITY";
        stringArray5[9] = "WORKITEMNAME";
        stringArray5[10] = "PERFORMER";
        stringArray5[11] = "PREVIOUSASSIGNEE";
        stringArray5[12] = "RESPONSE";
        CREATE_DYNAMIC_PROCESSLIST = stringArray5;
        String[] stringArray6 = new String[13];
        DBConstants.ColConstants cfr_ignored_26 = BLControl.dbconsts.col;
        stringArray6[0] = "WORKITEM_ID";
        DBConstants.ColConstants cfr_ignored_27 = BLControl.dbconsts.col;
        stringArray6[1] = "PROCESS_TEMPLATE_ID";
        DBConstants.ColConstants cfr_ignored_28 = BLControl.dbconsts.col;
        stringArray6[2] = "PROCESS_INSTANCE_ID";
        DBConstants.ColConstants cfr_ignored_29 = BLControl.dbconsts.col;
        stringArray6[3] = "WORKSTEP_ID";
        DBConstants.ColConstants cfr_ignored_30 = BLControl.dbconsts.col;
        stringArray6[4] = "WORKSTEP_NAME";
        DBConstants.ColConstants cfr_ignored_31 = BLControl.dbconsts.col;
        stringArray6[5] = "STARTTIME";
        DBConstants.ColConstants cfr_ignored_32 = BLControl.dbconsts.col;
        stringArray6[6] = "DUEDATE";
        DBConstants.ColConstants cfr_ignored_33 = BLControl.dbconsts.col;
        stringArray6[7] = "STATUS";
        DBConstants.ColConstants cfr_ignored_34 = BLControl.dbconsts.col;
        stringArray6[8] = "PRIORITY";
        DBConstants.ColConstants cfr_ignored_35 = BLControl.dbconsts.col;
        stringArray6[9] = "WORKITEM_NAME";
        DBConstants.ColConstants cfr_ignored_36 = BLControl.dbconsts.col;
        stringArray6[10] = "PERFORMER";
        DBConstants.ColConstants cfr_ignored_37 = BLControl.dbconsts.col;
        stringArray6[11] = "PREVIOUSASSIGNEE";
        stringArray6[12] = "RESPONSE";
        CREATE_DYNAMIC_PROCESS_TABLELIST = stringArray6;
    }
}

