/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.ejb;

import com.savvion.sbm.bizlogic.storeevent.BSControl;
import com.savvion.sbm.bizlogic.util.MDBAdapter;
import com.savvion.sbm.util.BMJMSService;
import com.savvion.sbm.util.SBMConstants;
import com.savvion.sbm.util.SBMUtil;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;

public class BizStoreMDB
extends MDBAdapter {
    public void onMessage(Message message) {
        String savvionMsgId = null;
        try {
            SBMConstants.self().getClass();
            savvionMsgId = message.getStringProperty("SAVVION_MSG_ID");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!BSControl.isServerRunning()) {
            if (BSControl.DEBUG_ENGINE) {
                if (null != BSControl.logger) {
                    BSControl.logger.debugKey("BizStore_MSG_536", "BizStoreMDB.onMessage", new Object[0]);
                } else {
                    System.out.println("BizStore is not started yet - waiting for some time and reposting the BizStore message...");
                }
            }
            this.republishMessage(message);
            return;
        }
        BSControl.processBizStoreMessage(savvionMsgId);
    }

    private void republishMessage(Message message) {
        try {
            Thread.sleep(BSControl.getSleepWhenBizStoreNotStarted());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            BMJMSService bMJMSService = SBMUtil.self().getBMJMSService();
            SBMConstants.self().getClass();
            Destination destination = bMJMSService.lookupChannelDestination("bizstorequeue");
            SBMUtil.self().getBMJMSService().sendMessage(destination, message);
        }
        catch (JMSException jmse) {
            throw new RuntimeException("Error while trying publish BizStoreMessage", jmse);
        }
    }
}

