/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.ejb;

import com.savvion.sbm.bizlogic.email.EmailReader;
import com.savvion.sbm.bizlogic.messaging.publisher.MessagePublisher;
import com.savvion.sbm.bizlogic.messaging.subscriber.MessageManager;
import com.savvion.sbm.bizlogic.server.ApplicationManager;
import com.savvion.sbm.bizlogic.server.BLBusinessObjectService;
import com.savvion.sbm.bizlogic.server.EPManager;
import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.TimerActionManager;
import com.savvion.sbm.bizlogic.server.WFCWorkItem;
import com.savvion.sbm.bizlogic.server.WFDataSlotInstance;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFInplaceProcessReplacement;
import com.savvion.sbm.bizlogic.server.WFJavaScript;
import com.savvion.sbm.bizlogic.server.WFMessagePublisherInstance;
import com.savvion.sbm.bizlogic.server.WFMessageSubscriberInstance;
import com.savvion.sbm.bizlogic.server.WFPreCondition;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFProcessInstance;
import com.savvion.sbm.bizlogic.server.WFWorkItem;
import com.savvion.sbm.bizlogic.server.WFWorkstepInstance;
import com.savvion.sbm.bizlogic.server.dao.PTReplaceInfoDAO;
import com.savvion.sbm.bizlogic.server.dao.ProcessInstanceDAO;
import com.savvion.sbm.bizlogic.server.dao.ProcessTemplateDAO;
import com.savvion.sbm.bizlogic.server.dao.SessionDAO;
import com.savvion.sbm.bizlogic.server.dao.TimerActionDAO;
import com.savvion.sbm.bizlogic.server.dao.WaitWorkStepDAO;
import com.savvion.sbm.bizlogic.server.dao.WorkItemDAO;
import com.savvion.sbm.bizlogic.server.dao.WorkStepInstanceDAO;
import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceEBLocal;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceEBLocal;
import com.savvion.sbm.bizlogic.server.svo.ProcessTemplate;
import com.savvion.sbm.bizlogic.server.svo.SVOFactory;
import com.savvion.sbm.bizlogic.server.svo.WorkItem;
import com.savvion.sbm.bizlogic.smp.core.ExtEventHandler;
import com.savvion.sbm.bizlogic.smp.core.WaitWorkStepProcessor;
import com.savvion.sbm.bizlogic.storeevent.BSUtil;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.BLJMSService;
import com.savvion.sbm.bizlogic.util.BizLogicAppException;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.bizlogic.util.SessionAdapter;
import com.savvion.sbm.util.CommonEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.ejb.EJBException;
import javax.mail.Message;

public class ServiceBean
extends SessionAdapter {
    public void suspendWorkStepByClient(Session ses, Map<String, Object> wsAttrs) {
        WFWorkstepInstance.single().suspendByClient(ses, wsAttrs, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeWorkstep(WFProcessContext pCtx, long wsid) {
        boolean ppCtxlock = pCtx.instanceLockObtained();
        try {
            pCtx.setInstanceLockObtained(false);
            pCtx.resumeWorkstep(wsid);
        }
        finally {
            pCtx.setInstanceLockObtained(ppCtxlock);
        }
    }

    public void resumeWorkStepByClient(Session ses, Map<String, Object> wsAttrs) {
        WFWorkstepInstance.single().resumeByClient(ses, wsAttrs);
    }

    public void completeWorkstep(Session ses, long piid, long wsid) {
        WFWorkstepInstance.single().completeByClient(ses, piid, wsid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendSubscriber(WFProcessContext pCtx, long wsid) {
        boolean ppCtxlock = pCtx.instanceLockObtained();
        try {
            pCtx.setInstanceLockObtained(false);
            MessageManager.doSuspend(pCtx, wsid);
        }
        finally {
            pCtx.setInstanceLockObtained(ppCtxlock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendAdapter(WFProcessContext pCtx, long wsid, Throwable causedBy) {
        boolean ppCtxlock = pCtx.instanceLockObtained();
        try {
            pCtx.setInstanceLockObtained(false);
            EPManager.suspend(pCtx, wsid, causedBy);
        }
        finally {
            pCtx.setInstanceLockObtained(ppCtxlock);
        }
    }

    public void suspendAdapter(long piid, long wsid, Throwable causedBy) {
        WFProcessContext pCtx = new WFProcessContext(BLControl.getServerSession(), piid);
        EPManager.suspend(pCtx, wsid, causedBy);
    }

    public void suspendWorkItem(Session ses, long wiid, String reason) {
        WFWorkItem.self().suspend(ses, wiid, reason);
    }

    public void resumeWorkItem(Session ses, long wiid) {
        WFWorkItem.self().resumeByClient(ses, wiid);
    }

    public void completeWorkItem(Session ses, long wiid) {
        WFWorkItem.self().complete(ses, wiid);
    }

    public void completeWorkItem(Session session, long wiID, Map<String, Object> dsValues) throws BizLogicAppException {
        try {
            long piid = WorkItemDAO.getProcessInstanceId(wiID);
            WFProcessContext pctx = new WFProcessContext(session, piid);
            pctx.completeWorkItem(wiID, dsValues);
        }
        catch (RuntimeException re) {
            this.ejbContext.setRollbackOnly();
            throw new BizLogicAppException(re.getMessage(), re.getCause());
        }
    }

    public void removeWorkItem(Session ses, long wiid) {
        WFWorkItem.self().remove(ses, wiid);
    }

    public void executeDDL(String ddlQuery) {
        try {
            BLDAOService.executeDDL((String)ddlQuery);
        }
        catch (SQLException se) {
            throw new EJBException((Exception)se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeJS(WFProcessContext pCtx, long wsid, WFJavaScript wsJS, String scriptLocation) {
        boolean ppCtxlock = pCtx.instanceLockObtained();
        try {
            pCtx.setInstanceLockObtained(false);
            Object object = WFJavaScript.executeJS(pCtx, wsid, wsJS, scriptLocation);
            return object;
        }
        finally {
            pCtx.setInstanceLockObtained(ppCtxlock);
        }
    }

    public void executeAction(HashMap actionInfo) {
        TimerActionManager.self().executeAction(actionInfo);
    }

    public void executeResumeWS(long ptid, long piid, Vector wsids, boolean isReValidate) {
        WFPreCondition.self().executeResumeWS(ptid, piid, wsids, isReValidate);
    }

    public void processEmailMessage(Message msg) {
        try {
            EmailReader.self().processMessage(msg);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    public void notifyEP(HashMap epMsg, String destConfigName) {
        try {
            BLJMSService.self().sendMessage(destConfigName, (Object)"", 1, epMsg);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    public ProcessInstanceEBLocal createInstance(WFProcess ptObject, HashMap piAttrs) throws BizLogicException {
        try {
            return WFProcessInstance.self().createInstance(ptObject, piAttrs);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    public WorkStepInstanceEBLocal createInstance(WFProcessContext pCtx, long wsid) {
        boolean ppCtxlock = pCtx.instanceLockObtained();
        try {
            pCtx.setInstanceLockObtained(false);
            WorkStepInstanceEBLocal workStepInstanceEBLocal = WFWorkstepInstance.single().createInstance(pCtx, wsid);
            return workStepInstanceEBLocal;
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
        finally {
            pCtx.setInstanceLockObtained(ppCtxlock);
        }
    }

    public void activateOnServerStart(long piid, long wsid, int wsState) {
        WFWorkstepInstance.single().doActivateOnServerStart(piid, wsid, wsState);
    }

    public boolean removeProcessInstance(Session ses, long piid, boolean force) {
        return this.removeProcessInstance(ses, piid, force, true);
    }

    public boolean removeProcessInstance(Session ses, long piid, boolean force, boolean removeDataslot) {
        WFProcessContext pCtx = new WFProcessContext(ses, piid);
        pCtx.setRemoveDataslot(removeDataslot);
        return pCtx.removeProcessInstance(force, false);
    }

    public void completeProcessInstance(Session ses, long piid) {
        WFProcessContext pCtx = new WFProcessContext(ses, piid);
        pCtx.completeProcessInstance();
    }

    public void suspendProcessInstance(Session ses, long piid) {
        WFProcessContext pCtx = new WFProcessContext(ses, piid);
        pCtx.suspendProcessInstance();
    }

    public void resumeProcessInstance(Session ses, long piid) {
        WFProcessContext pCtx = new WFProcessContext(ses, piid);
        pCtx.resumeProcessInstance();
    }

    public void removeProcessInstance(Session ses, long piid) {
        WFProcessContext pCtx = new WFProcessContext(ses, piid);
        pCtx.removeProcessInstance(false);
    }

    public void saveProcessTemplate(WFProcess pt) {
        ProcessTemplateDAO.store(pt);
    }

    public Collection findPIbyProcessTemplate(long ptid) {
        return ProcessInstanceDAO.findByProcessTemplate(ptid);
    }

    public void updateNewDataSlotsForPTR(Session sess, Map<String, Object> piDetails, Map dsNameValueMap, long ptReplaceID) {
        long piid = (Long)piDetails.get("PROCESSINSTANCEID");
        WFProcessInstance.self().updateNewDataSlotsForPTR(sess, piDetails, dsNameValueMap);
        PTReplaceInfoDAO.update(ptReplaceID, piid);
    }

    public void updateNewDataSlotsForPTRList(Session sess, List<Map<String, Object>> piDetailsList, Map dsNameValueMap, long ptReplaceID) {
        for (Map<String, Object> piDetails : piDetailsList) {
            this.updateNewDataSlotsForPTR(sess, piDetails, dsNameValueMap, ptReplaceID);
        }
    }

    public void updateBSNewDataSlotsForPTR(ArrayList names, ArrayList types, ArrayList values, CommonEvent event, boolean isGlobal) {
        try {
            BSUtil.self();
            BSUtil.updateBSNewDataSlotsForPTR(names, types, values, event, isGlobal);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    public void updateSession(Session sobj) {
        SessionDAO.update(sobj);
    }

    public List getOverDueList() {
        return TimerActionDAO.getOverDueList();
    }

    public Map getPreConditionWaitListForGDS() {
        return WaitWorkStepDAO.getGSInvalidateWorkStepList();
    }

    public List getWorkStepInstanceList(long[] ptids, long[] piids, int[] status, int[] types, String creator, boolean readOnly) {
        return WorkStepInstanceDAO.getWorkStepInstanceList(ptids, piids, status, types, creator, readOnly);
    }

    public WorkItem reAssignTask(Session session, long wiid, String performer) {
        this.reAssignWorkItem(session, wiid, performer);
        return SVOFactory.getWorkItem(session, wiid);
    }

    public void reAssignWorkItem(Session session, long wiid, String performer) {
        WFProcessContext pCtx = new WFProcessContext(session, wiid, true);
        WFWorkItem.self().reAssignWorkItem(pCtx, wiid, performer);
    }

    public void reAssignWorkItemX(Session session, long wiid, String performer) throws BizLogicAppException {
        WFProcessContext pCtx = new WFProcessContext(session, wiid, true);
        try {
            WFWorkItem.self().reAssignWorkItem(pCtx, wiid, performer);
        }
        catch (RuntimeException th) {
            this.ejbContext.setRollbackOnly();
            throw new BizLogicAppException(th.getMessage(), th.getCause());
        }
    }

    public ProcessTemplate replaceProcess(Session session, WFProcess pt, String ptdefinition) {
        WFInplaceProcessReplacement ipr = new WFInplaceProcessReplacement(pt, session);
        ProcessTemplate ptsvo = ipr.replace(ptdefinition);
        ipr = null;
        return ptsvo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardMessagesAndNotify(WFProcessContext pCtx, long wsid, HashMap messagesToDiscard, Throwable th) {
        boolean ppCtxlock = false;
        if (pCtx != null) {
            ppCtxlock = pCtx.instanceLockObtained();
        }
        try {
            if (pCtx != null) {
                pCtx.setInstanceLockObtained(false);
            }
            MessageManager.doDiscardMessagesAndNotify(pCtx, wsid, messagesToDiscard, th);
        }
        finally {
            if (pCtx != null) {
                pCtx.setInstanceLockObtained(ppCtxlock);
            }
        }
    }

    public HashMap invokePublisherHandler(HashMap context, MessagePublisher handler) {
        return WFMessagePublisherInstance.self().doInvoke(context, handler);
    }

    public void suspendCWorkItem(Session ses, long piid, long cwiid) {
        WFCWorkItem.self().suspend(ses, piid, cwiid);
    }

    public void resumeCWorkItem(Session ses, long piid, long cwiid) {
        WFCWorkItem.self().resumeByClient(ses, piid, cwiid);
    }

    public void terminateCWorkItem(Session ses, long piid, long cwiid) {
        WFCWorkItem.self().terminate(ses, piid, cwiid);
    }

    public void completeCWorkItem(Session ses, long piid, long cwiid) {
        WFCWorkItem.self().complete(ses, piid, cwiid);
    }

    public void executeWaitWorkstep(Session session, long piid, long wsid) {
        WFMessageSubscriberInstance.self().doExecuteWaitWorkstep(session, piid, wsid);
    }

    public void initSequence() {
        BLControl.util.initSequence();
    }

    public void initSDMS() {
        BLControl.initSDMS();
    }

    public void createIndex(String tableName, String indexName, List<String> columnNames) throws SQLException {
        BLDAOService.createIndex((String)tableName, (String)indexName, columnNames);
    }

    public void updateSlotValue(Session session, long piid, Map<String, Object> dsValues) {
        WFDataSlotInstance.self().updateSlotValue(session, piid, dsValues);
    }

    public void updateWorkStepInstanceAttributes(Session session, Map<String, Object> modifiedAttrs) {
        WFWorkstepInstance.single().setAttributes(session, modifiedAttrs);
    }

    public void skipWorkStepByClient(Session ses, Map<String, Object> wsAttrs) {
        WFWorkstepInstance.single().skipByClient(ses, wsAttrs);
    }

    public void assignWorkItem(Session session, long wiid, String performer) {
        WFWorkItem.self().assign(session, wiid, performer);
    }

    public List<Map<String, Object>> getInstanceListForPTRDataSlotUpdate(long ptReplaceID, long ptid) {
        return ProcessControl.getInstanceListForPTRDataSlotUpdate(ptReplaceID, ptid);
    }

    public void updatePTReplaceStatus(long ptReplaceID) {
        ProcessControl.updatePTReplaceStatus(ptReplaceID);
    }

    public void executeExternalEventHandler() {
        ExtEventHandler.self().doExecute();
    }

    public void moveToHistory() {
        ExtEventHandler.self().doMoveToHistory();
    }

    public void executeWaitWorkStepProcessor() {
        WaitWorkStepProcessor.self().doExecute();
    }

    public void makeAvailable(Session session, long wiid, Vector<String> performers) {
        WFWorkItem.self().makeAvailable(session, wiid, performers);
    }

    public void removeProcessTemplate(Session session, String ptName, boolean forceRemoveInstances) {
        WFProcess pt = ProcessControl.getProcessTemplate(ptName);
        ProcessControl.removeProcessTemplate(session, pt.getID(), forceRemoveInstances);
    }

    public ProcessTemplate createProcessTemplate(Session session, String ptName) {
        return ApplicationManager.createVersionAndGetTemplate(session, ptName + ".xml", true);
    }

    public void updateInstance(Session session, long piid, Map<String, Object> dsValues, Map<String, Object> attributes) {
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        pCtx.updateInstance(dsValues, attributes);
    }

    public Map<String, Object> createOrUpdateExtBOParentTrans(WFDataslot wfDS, Object boObj) {
        Map<String, Object> response = BLBusinessObjectService.self().doCreateOrUpdate(wfDS, boObj);
        return response;
    }

    public Map<String, Object> createOrUpdateExtBONewTrans(WFDataslot wfDS, Object boObj) {
        Map<String, Object> response = BLBusinessObjectService.self().doCreateOrUpdate(wfDS, boObj);
        return response;
    }

    public Map<String, Object> createOrUpdateExtBONoTrans(WFDataslot wfDS, Object boObj) {
        Map<String, Object> response = BLBusinessObjectService.self().doCreateOrUpdate(wfDS, boObj);
        return response;
    }

    public Object getExtBOByPKMapParentTrans(WFDataslot wfDS, Map<String, Object> pkAttrValueMap) {
        Object response = BLBusinessObjectService.self().doGetExtBOByPKMap(wfDS, pkAttrValueMap);
        return response;
    }

    public Object getExtBOByPKMapNewTrans(WFDataslot wfDS, Map<String, Object> pkAttrValueMap) {
        Object response = BLBusinessObjectService.self().doGetExtBOByPKMap(wfDS, pkAttrValueMap);
        return response;
    }

    public Object getExtBOByPKMapNoTrans(WFDataslot wfDS, Map<String, Object> pkAttrValueMap) {
        Object response = BLBusinessObjectService.self().doGetExtBOByPKMap(wfDS, pkAttrValueMap);
        return response;
    }

    public Object getExtBOParentTrans(WFDataslot wfDS, Object pkObj) {
        Object response = BLBusinessObjectService.self().doGetExtBO(wfDS, pkObj);
        return response;
    }

    public Object getExtBONewTrans(WFDataslot wfDS, Object pkObj) {
        Object response = BLBusinessObjectService.self().doGetExtBO(wfDS, pkObj);
        return response;
    }

    public Object getExtBONoTrans(WFDataslot wfDS, Object pkObj) {
        Object response = BLBusinessObjectService.self().doGetExtBO(wfDS, pkObj);
        return response;
    }
}

