/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.smp.gateway.rest;

import com.savvion.sbm.bizlogic.smp.MPService;
import com.savvion.sbm.bizlogic.smp.core.EventProcessor;
import com.savvion.sbm.bizlogic.smp.gateway.rest.JSONUtil;
import com.savvion.sbm.bizlogic.smp.gateway.rest.ProcessingResponse;
import com.savvion.sbm.bizlogic.smp.model.BLExternalEvent;
import com.savvion.sbm.bizlogic.smp.util.InvalidEventDataException;
import com.savvion.sbm.bizlogic.smp.util.InvalidProcessStateException;
import com.savvion.sbm.bizlogic.smp.util.MPConstant;
import com.savvion.sbm.bizlogic.smp.util.MPUtil;
import com.savvion.sbm.bizlogic.smp.util.MonitoringProcessException;
import com.savvion.sbm.bizlogic.smp.util.SMPConfig;
import com.savvion.sbm.util.logger.SBMLogger;
import java.util.Map;
import net.sf.json.JSONObject;

public class RESTService {
    public ProcessingResponse processJSON(JSONObject extEventJSON) {
        try {
            JSONUtil.validateJSON(extEventJSON);
            BLExternalEvent extEvent = JSONUtil.getExternalEventFromJSON(extEventJSON);
            if (extEvent != null) {
                MPConstant.EventStatus eventStatus = MPConstant.EventStatus.FAILED;
                if (SMPConfig.self().isInlineProcessAtGateway() && SMPConfig.self().isInlineProcessAtGatewayOfEventType(extEvent.getOperationType())) {
                    eventStatus = this.processEvent(extEvent, extEventJSON);
                    if (MPConstant.EventStatus.isInvalidEventData(eventStatus)) {
                        return new ProcessingResponse(eventStatus);
                    }
                    if (MPConstant.EventStatus.isSuccess(eventStatus)) {
                        if (SMPConfig.self().isExtEventHistoryEnabled()) {
                            extEvent.setProcessed(true);
                        } else {
                            return new ProcessingResponse(eventStatus);
                        }
                    }
                }
                MPService.self().getPersistenceService().storeEvent(extEvent);
                return new ProcessingResponse(eventStatus);
            }
            return new ProcessingResponse(MPConstant.EventStatus.INVALID_EVENT_DATA, extEventJSON.toString());
        }
        catch (InvalidEventDataException invalidEventDataException) {
            RESTService.handleInvalidEventDataEx(invalidEventDataException, extEventJSON);
            return new ProcessingResponse(MPConstant.EventStatus.INVALID_EVENT_DATA, invalidEventDataException.getMessage());
        }
        catch (Throwable th) {
            RESTService.handleException(th, extEventJSON);
            return new ProcessingResponse(MPConstant.EventStatus.FAILED, th.getMessage());
        }
    }

    private MPConstant.EventStatus processEvent(BLExternalEvent extEvent, JSONObject extEventJSON) {
        try {
            EventProcessor.self().processEvent(extEvent, null);
            return MPConstant.EventStatus.SUCCESS;
        }
        catch (InvalidEventDataException e) {
            RESTService.handleInvalidEventDataEx(e, extEventJSON);
            return MPConstant.EventStatus.INVALID_EVENT_DATA;
        }
        catch (InvalidProcessStateException e) {
            RESTService.getLogger().warnKey("BM_MPGW156", "RESTService.processEvent(BLExternalEvent,extEventJSON)", (Throwable)((Object)e), new Object[0]);
        }
        catch (Throwable e) {
            RESTService.getLogger().warnKey("BM_MPGW143", "RESTService.processEvent(BLExternalEvent,extEventJSON)", e, new Object[0]);
        }
        return MPConstant.EventStatus.FAILED;
    }

    private static void handleException(Throwable th, JSONObject extEventJSON) {
        if (!(th instanceof InvalidEventDataException)) {
            Map<String, Object> eventCtx = JSONUtil.getEventCtxFromJSON(extEventJSON);
            if (MPUtil.isDebug()) {
                RESTService.getLogger().debugKey("BM_MPGW127", new Object[]{eventCtx});
            }
            MonitoringProcessException mpEx = (MonitoringProcessException)((Object)MPUtil.getMonitoringProcessES().createException("BM_MPGW153", "RESTService.handleException(Throwable,JSONObject)", new Object[]{eventCtx, extEventJSON}, th));
            throw mpEx;
        }
        RESTService.handleInvalidEventDataEx((InvalidEventDataException)((Object)th), extEventJSON);
    }

    public static void handleInvalidEventDataEx(InvalidEventDataException invalidEvtDataEx, JSONObject extEventJSON) {
        try {
            Map<String, Object> invalidEvent = JSONUtil.getInvalidEvent(extEventJSON, invalidEvtDataEx.getMessage());
            if (MPUtil.isDebug()) {
                RESTService.getLogger().debugKey("BM_MPGW123", new Object[]{MPUtil.getInvalidEvtCtx(invalidEvent)});
            }
            MPService.self().getPersistenceService().storeInvalidEvent(invalidEvent);
            if (MPUtil.isDebug()) {
                RESTService.getLogger().debugKey("BM_MPGW124", new Object[]{MPUtil.getInvalidEvtCtx(invalidEvent)});
            }
        }
        catch (Throwable th) {
            Map<String, Object> eventCtx = JSONUtil.getEventCtxFromJSON(extEventJSON);
            if (MPUtil.isDebug()) {
                RESTService.getLogger().debugKey("BM_MPGW154", new Object[]{eventCtx});
            }
            MonitoringProcessException mpEx = (MonitoringProcessException)((Object)MPUtil.getMonitoringProcessES().createException("BM_MPGW153", "RESTService.handleInvalidEventDataEx(InvalidEventDataException,JSONObject)", new Object[]{eventCtx, extEventJSON}, th));
            throw mpEx;
        }
    }

    private static SBMLogger getLogger() {
        return MPService.self().getLogger();
    }
}

