/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.storeevent;

import com.savvion.sbm.bizlogic.storeevent.BSControl;
import com.savvion.sbm.bizlogic.storeevent.BSProcess;
import com.savvion.sbm.bizlogic.storeevent.BSUtil;
import com.savvion.sbm.bizlogic.storeevent.BizLogicEventMap;
import com.savvion.sbm.util.CommonEvent;
import com.savvion.sbm.util.SBMDAOService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;

public class BSProcessNotes
extends BSProcess {
    private static final String INSERT_PNOTES_SQL = "INSERT INTO PROCESS_NOTES (NOTES_ID, PROCESS_TEMPLATE_ID, PROCESS_INSTANCE_ID, LOOPCOUNTER, WORKITEM_ID, CSTEP_ID, CWORKITEM_ID,NOTES_CONTEXT, REFERENCE_ID, LAST_MODIFIED_TIME, NOTES_TYPE, NOTES_USER, WORKSTEP_NAME, WORKITEM_NAME, CWORKITEM_NAME, THREAD_NAME, NOTES) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_PNOTES_SQL = "UPDATE PROCESS_NOTES SET NOTES = ?, LAST_MODIFIED_TIME = ?  WHERE NOTES_ID = ?";
    private static final String REMOVE_PNOTES_SQL = "DELETE FROM PROCESS_NOTES WHERE NOTES_ID = ?";

    protected static void onCreate(CommonEvent commonEvent) throws SQLException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            long notesId = BizLogicEventMap.getNotesID(commonEvent);
            long ptid = BizLogicEventMap.getProcessTemplateID(commonEvent);
            long piid = BizLogicEventMap.getProcessInstanceID(commonEvent);
            int loopCounter = BizLogicEventMap.getLoopcounter(commonEvent);
            long wiid = BizLogicEventMap.getWorkitemID(commonEvent);
            long cStepID = BizLogicEventMap.getCStepID(commonEvent);
            long cWorkItemID = BizLogicEventMap.getCWorkItemID(commonEvent);
            int notesContext = BizLogicEventMap.getNotesContext(commonEvent);
            long refId = BizLogicEventMap.getReferenceID(commonEvent);
            long lastModifiedTime = BizLogicEventMap.getLastModifiedTime(commonEvent);
            String notesType = BizLogicEventMap.getNotesType(commonEvent);
            String user = BizLogicEventMap.getNotesUser(commonEvent);
            String wsName = BizLogicEventMap.getWorkstepName(commonEvent);
            String wiName = BizLogicEventMap.getWorkItemName(commonEvent);
            String cWorkItemName = BizLogicEventMap.getCWorkItemName(commonEvent);
            String threadName = BizLogicEventMap.getThreadName(commonEvent);
            String notes = BizLogicEventMap.getNotes(commonEvent);
            int ix = 1;
            conn = BSControl.util.getBSConnection();
            pstmt = conn.prepareStatement(INSERT_PNOTES_SQL);
            pstmt.setLong(ix++, notesId);
            pstmt.setLong(ix++, ptid);
            pstmt.setLong(ix++, piid);
            pstmt.setInt(ix++, loopCounter);
            pstmt.setLong(ix++, wiid);
            pstmt.setLong(ix++, cStepID);
            pstmt.setLong(ix++, cWorkItemID);
            pstmt.setInt(ix++, notesContext);
            pstmt.setLong(ix++, refId);
            BSUtil.setValue(pstmt, 91, ix++, new Timestamp(lastModifiedTime));
            pstmt.setString(ix++, notesType);
            pstmt.setString(ix++, user);
            pstmt.setString(ix++, wsName);
            pstmt.setString(ix++, wiName);
            pstmt.setString(ix++, cWorkItemName);
            pstmt.setString(ix++, threadName);
            pstmt.setString(ix++, notes);
            pstmt.executeUpdate();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{INSERT_PNOTES_SQL, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, pstmt, conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)pstmt, (Connection)conn);
    }

    protected static void onUpdate(CommonEvent commonEvent) throws SQLException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            long notesID = BizLogicEventMap.getNotesID(commonEvent);
            long lastModifiedTime = BizLogicEventMap.getLastModifiedTime(commonEvent);
            String notes = BizLogicEventMap.getNotes(commonEvent);
            conn = BSControl.util.getBSConnection();
            pstmt = conn.prepareStatement(UPDATE_PNOTES_SQL);
            pstmt.setString(1, notes);
            BSUtil.setValue(pstmt, 91, 2, new Timestamp(lastModifiedTime));
            pstmt.setLong(3, notesID);
            pstmt.executeUpdate();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{UPDATE_PNOTES_SQL, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, pstmt, conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)pstmt, (Connection)conn);
    }

    protected static void onRemove(CommonEvent commonEvent) throws SQLException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            long notesID = BizLogicEventMap.getNotesID(commonEvent);
            conn = BSControl.util.getBSConnection();
            pstmt = conn.prepareStatement(REMOVE_PNOTES_SQL);
            pstmt.setLong(1, notesID);
            pstmt.executeUpdate();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{REMOVE_PNOTES_SQL, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)pstmt, (Connection)conn);
    }
}

