/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.email;

import com.savvion.sbm.bizlogic.client.BLClientUtil;
import com.savvion.sbm.bizlogic.email.EmailData;
import com.savvion.sbm.bizlogic.email.EmailException;
import com.savvion.sbm.bizlogic.email.EmailUtil;
import com.savvion.sbm.bizlogic.email.REManager;
import com.savvion.sbm.bizlogic.server.ejb.BLServer;
import com.savvion.sbm.bizlogic.server.svo.DataSlot;
import com.savvion.sbm.bizlogic.server.svo.DateTime;
import com.savvion.sbm.bizlogic.server.svo.Decimal;
import com.savvion.sbm.bizlogic.server.svo.DocumentDS;
import com.savvion.sbm.bizlogic.server.svo.WorkItem;
import com.savvion.sbm.bizlogic.server.svo.XML;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.BLDocService;
import com.savvion.sbm.bizlogic.util.BizLogicClientException;
import com.savvion.sbm.bizlogic.util.DBConstants;
import com.savvion.sbm.dms.DSContext;
import com.savvion.sbm.dms.svo.Document;
import com.savvion.sbm.util.FileUtil;
import com.savvion.sbm.util.SBMException;
import com.savvion.sbm.util.SBMUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang3.StringUtils;

public class EmailParser {
    private Map parsedEmailData = null;
    private List outputDS = null;
    private long wiid;
    private String emailClientName = null;
    private String performer = null;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EmailData process(Message message) {
        EmailData emailData;
        BLServer server = null;
        com.savvion.sbm.bizlogic.util.Session session = null;
        try {
            String messageId = EmailUtil.getMessageId(message);
            String subject = message.getSubject();
            this.logDebug("EMAIL_MSG_009", new Object[]{message.getFrom()[0], subject, messageId});
            server = BLClientUtil.getBizLogicServer();
            session = server.connect(SBMUtil.self().getGuestUser(), SBMUtil.self().getGuestPasswd());
            InternetAddress sender = (InternetAddress)message.getFrom()[0];
            String senderEmailId = sender.toString();
            EmailUtil emailUtil = EmailUtil.self();
            this.logDebug("EMAIL_MSG_033", new Object[]{subject, messageId, emailUtil, sender});
            String emailText = emailUtil.getContent((Part)message, 1);
            this.logDebug("EMAIL_MSG_034", new Object[]{subject, sender, messageId, emailText});
            if (EmailUtil.isEmpty(emailText)) {
                emailUtil.replyAndDeleteMessage("EMAIL_MSG_232", null);
            }
            DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
            if (!BLDAOService.checkTableExists((String)"BIZLOGIC_WORKITEM")) {
                emailUtil.throwEmailException("EMAIL_MSG_239", new Object[]{senderEmailId, subject, messageId});
            }
            this.parsedEmailData = REManager.self().parse(emailText);
            emailData = this.prepareEmailDataFromContext(message, session, messageId, subject, senderEmailId);
        }
        catch (EmailException emailException) {
            try {
                throw emailException;
                catch (Exception th) {
                    EmailException emailException2 = this.handleException(message, th);
                    throw emailException2;
                }
            }
            catch (Throwable throwable) {
                EmailUtil.disconnect(server, session);
                throw throwable;
            }
        }
        EmailUtil.disconnect(server, session);
        return emailData;
    }

    private EmailData prepareEmailDataFromContext(Message message, com.savvion.sbm.bizlogic.util.Session session, String messageId, String subject, String senderEmailId) throws Exception {
        Map emailCtx = this.getEmailContextData();
        String performerId = this.getPerformerFromContext(emailCtx);
        int wiState = this.getWorkitemState(emailCtx);
        this.wiid = this.getWorkitemId(emailCtx);
        this.emailClientName = this.getEmailClientName(emailCtx);
        this.replyAndDeleteMessage(session, EmailUtil.self());
        this.logDebug("EMAIL_MSG_267.message", new Object[]{this.wiid, this.performer});
        if (!this.validateWiState(subject, messageId, senderEmailId, EmailUtil.self(), wiState)) {
            return new EmailData(this.wiid, emailCtx, senderEmailId, wiState, this.performer);
        }
        Map attachments = this.readAttachments(message);
        String nonExistingDS = this.getNonExistingDS();
        if (StringUtils.isNotBlank((CharSequence)nonExistingDS)) {
            EmailUtil.self().replyAndDeleteMessage("EMAIL_MSG_260", new Object[]{nonExistingDS});
        }
        return this.getEmailData(senderEmailId, emailCtx, performerId, wiState, attachments);
    }

    private String getPerformerFromContext(Map<String, String> emailCtx) {
        String performerId;
        String encodedPerformerId = performerId = emailCtx.get("EMAIL.ENC.USER");
        performerId = performerId.replaceAll("\r\n", "");
        if ((performerId = performerId.replaceAll("\n", "")).length() != encodedPerformerId.length()) {
            this.logDebug("EMAIL_MSG_266.message", new Object[]{this.wiid, performerId});
        }
        this.performer = EmailUtil.getDecryptedValue(performerId);
        return performerId;
    }

    private boolean validateWiState(String subject, String messageId, String senderEmailId, EmailUtil emailUtil, int wiState) {
        if (27 == wiState) {
            if (EmailUtil.isEmpty(this.performer)) {
                emailUtil.replyAndDeleteMessage("EMAIL_MSG_229", new Object[]{messageId, senderEmailId, subject, String.valueOf(this.wiid), this.performer});
            }
            return false;
        }
        return true;
    }

    private void logDebug(String key, Object[] args) {
        if (EmailUtil.self().isDebug()) {
            EmailUtil.self().debug(key, args);
        }
    }

    private void replyAndDeleteMessage(com.savvion.sbm.bizlogic.util.Session session, EmailUtil emailUtil) throws RemoteException {
        if (WorkItem.isExist(session, this.wiid)) {
            WorkItem wi = WorkItem.get(session, this.wiid);
            if (!wi.getEmailSupport()) {
                emailUtil.replyAndDeleteMessage("EMAIL_MSG_220", new Object[]{wi.getPerformer()});
            }
            this.outputDS = wi.getOutputDataSlotList(true).getList();
        } else {
            emailUtil.replyAndDeleteMessage("EMAIL_MSG_219");
        }
    }

    private EmailData getEmailData(String sender, Map emailCtx, String performerId, int wiState, Map<String, String> attachments) throws Exception {
        Map<String, Object> nonDocDS = this.getNonDocumentDS(attachments);
        Collection<String> attachmentURLs = attachments.values();
        Map<String, DocumentDS> docDS = this.getDocumentDS(performerId, attachments);
        if (!this.parsedEmailData.isEmpty()) {
            ArrayList dsList = new ArrayList(this.parsedEmailData.keySet());
            String csDsNames = EmailUtil.self().getCSValues(dsList);
            EmailUtil.self().replyAndDeleteMessage("EMAIL_MSG_226", new Object[]{csDsNames});
        }
        EmailData emailData = new EmailData(this.wiid, emailCtx, nonDocDS, docDS, attachmentURLs, sender, wiState);
        emailData.setPerformer(this.performer);
        return emailData;
    }

    private Map readAttachments(Message message) throws Exception {
        String messageId = EmailUtil.getMessageId(message);
        if (EmailUtil.self().isDebug()) {
            EmailUtil.self().debug("EMAIL_MSG_110", new Object[]{message.getFrom()[0], message.getSubject(), String.valueOf(this.wiid), messageId});
        }
        HashMap<String, String> attachments = new HashMap<String, String>();
        Object content = message.getContent();
        if (content != null && content instanceof Multipart && ((Multipart)content).getCount() > 0) {
            Multipart mp = (Multipart)content;
            int n = mp.getCount();
            for (int i = 0; i < n; ++i) {
                String fileName;
                BodyPart part = mp.getBodyPart(i);
                if (part == null || EmailUtil.isEmpty(fileName = part.getFileName())) continue;
                fileName = fileName.trim();
                if (EmailUtil.self().isDebug()) {
                    EmailUtil.self().debug("EMAIL_MSG_041", new Object[]{fileName, message.getSubject(), message.getFrom()[0], messageId});
                }
                List specifiedFiles = this.getOutputDocumentFileNames();
                fileName = EmailUtil.self().decode(fileName, specifiedFiles);
                if (null == fileName || !specifiedFiles.contains(fileName)) {
                    EmailUtil.self().warn("EMAIL_MSG_124", new Object[]{message.getSubject(), message.getFrom()[0], messageId});
                    continue;
                }
                File tmpFile = this.prepareFile(fileName);
                InputStream is = part.getInputStream();
                String fileURL = null;
                String disposition = part.getDisposition();
                if (disposition != null) {
                    if (disposition.equalsIgnoreCase("attachment") || disposition.equalsIgnoreCase("inline")) {
                        fileURL = FileUtil.saveContent((InputStream)is, (File)tmpFile);
                    }
                } else {
                    fileURL = FileUtil.saveContent((InputStream)is, (File)tmpFile);
                }
                if (!EmailUtil.isValidURL(fileURL)) {
                    EmailUtil.self().error("EMAIL_MSG_255", new Object[]{fileName, fileURL, messageId, message.getSubject(), message.getFrom()[0]});
                    EmailUtil.self().replyAndDeleteMessage("EMAIL_MSG_256", new Object[]{fileName});
                }
                if (EmailUtil.self().isDebug()) {
                    EmailUtil.self().debug("EMAIL_MSG_032", new Object[]{fileName, message.getSubject(), message.getFrom()[0], messageId});
                }
                attachments.put(tmpFile.getName(), fileURL);
            }
        }
        return attachments;
    }

    private File prepareFile(String fileName) throws IOException {
        String fName = fileName;
        String tmpDir = EmailUtil.self().getAttachmentFolder();
        File file = new File(tmpDir + fName.trim());
        return file;
    }

    private Map getEmailContextData() {
        HashMap processCtx = new HashMap();
        this.putStringContextData(this.parsedEmailData, processCtx, "EMAIL.USER");
        this.putStringContextData(this.parsedEmailData, processCtx, "EMAIL.ENC.USER");
        this.putStringContextData(this.parsedEmailData, processCtx, "EMAIL.TYPE");
        this.putNumericContextData(this.parsedEmailData, processCtx, "PCTX.INSTANCE_ID");
        this.putNumericContextData(this.parsedEmailData, processCtx, "PCTX.TEMPLATE_ID");
        this.putNumericContextData(this.parsedEmailData, processCtx, "PCTX.WS_ID");
        this.putNumericContextData(this.parsedEmailData, processCtx, "PCTX.WI_ID");
        this.putStringContextData(this.parsedEmailData, processCtx, "PCTX.WS_NAME");
        this.putStringContextData(this.parsedEmailData, processCtx, "EMAIL.SKEY");
        this.putStringContextData(this.parsedEmailData, processCtx, "PCTX.ENC.WI_ID");
        this.putStringContextData(this.parsedEmailData, processCtx, "PCTX.INSTANCE_NAME");
        this.putStringContextData(this.parsedEmailData, processCtx, "PCTX.TEMPLATE_NAME");
        this.putStringContextData(this.parsedEmailData, processCtx, "EMAIL.CLIENT_NAME");
        return processCtx;
    }

    private void putStringContextData(Map source, Map destination, String key) {
        String val = (String)source.remove(key);
        if (null != val && val.trim().length() > 0) {
            destination.put(key, val);
        }
    }

    private void putNumericContextData(Map source, Map destination, String key) {
        Long val = null;
        try {
            val = Long.valueOf((String)source.remove(key));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (null != val) {
            destination.put(key, val);
        }
    }

    private int getWorkitemState(Map pCtx) {
        String wiStateStr = (String)pCtx.get("EMAIL.TYPE");
        try {
            int wiState;
            block5: {
                block4: {
                    wiState = Integer.parseInt(wiStateStr);
                    BLConstants.single();
                    if (28 == wiState) break block4;
                    BLConstants.single();
                    if (27 != wiState) break block5;
                }
                return wiState;
            }
            EmailUtil.self().deleteMessage("EMAIL_MSG_227", new Object[]{String.valueOf(wiState)});
        }
        catch (NumberFormatException nfe) {
            EmailUtil.self().deleteMessage("EMAIL_MSG_227", new Object[]{wiStateStr});
        }
        return -1;
    }

    private long getWorkitemId(Map pCtx) {
        String key = (String)pCtx.get("EMAIL.SKEY");
        if (EmailUtil.isEmpty(key)) {
            EmailUtil.self().deleteMessage("EMAIL_MSG_224");
        }
        String decryptedWIId = EmailUtil.decryptSecurityKey(key);
        try {
            return Long.parseLong(decryptedWIId);
        }
        catch (NumberFormatException nfe) {
            EmailUtil.self().deleteMessage("EMAIL_MSG_225");
            return -1L;
        }
    }

    private String getEmailClientName(Map pCtx) {
        return (String)pCtx.get("EMAIL.CLIENT_NAME");
    }

    private Map<String, DocumentDS> getDocumentDS(String performerId, Map attachments) throws Exception {
        HashMap<String, DocumentDS> docDSMap = new HashMap<String, DocumentDS>();
        for (int idx = 0; idx < this.outputDS.size(); ++idx) {
            DataSlot ds = (DataSlot)this.outputDS.get(idx);
            String dsName = ds.getName();
            if (!ds.isDocument()) continue;
            DocumentDS docDS = this.readDocumentDS(performerId, ds, attachments);
            docDSMap.put(dsName, docDS);
        }
        return docDSMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentDS readDocumentDS(String performerId, DataSlot ds, Map attachments) throws Exception {
        String dataslotName = ds.getName();
        String dsFiles = (String)this.parsedEmailData.remove(dataslotName);
        if (ds.isRequired() && EmailUtil.isDataSlotEmpty(dsFiles) && EmailUtil.self().isCheckRequiredDSEnabled()) {
            EmailUtil.self().replyAndDeleteMessage("EMAIL_MSG_222", new Object[]{ds.getName()});
        }
        DocumentDS docDS = (DocumentDS)ds.getValue();
        if (EmailUtil.isDataSlotEmpty(dsFiles)) {
            return docDS;
        }
        String[] fileNames = this.parseCSStringValues(dsFiles.trim());
        DSContext dsContext = null;
        try {
            dsContext = BLDocService.startSession(dsContext);
            for (int fidx = 0; fidx < fileNames.length; ++fidx) {
                String fileName = fileNames[fidx].trim();
                String fileURL = this.getFileURL(dataslotName, attachments, fileName);
                List docList = docDS.getDocuments(performerId);
                boolean docExists = false;
                for (int i = 0; i < docList.size(); ++i) {
                    Document doc = (Document)docList.get(i);
                    if (!doc.getName().equals(fileName)) continue;
                    doc.updateContent(dsContext, FileUtil.getByteArray((URL)new URL(fileURL)));
                    docExists = true;
                    break;
                }
                if (docExists) continue;
                docDS.create(performerId, fileName, new URL(fileURL), null);
            }
        }
        finally {
            if (dsContext != null) {
                BLDocService.endSession((DSContext)dsContext);
            }
        }
        return docDS;
    }

    private String getFileURL(String dataSlotName, Map attachments, String fileName) {
        String fileURL = (String)attachments.get(fileName);
        if (EmailUtil.isEmpty(fileURL)) {
            EmailUtil.self().replyAndDeleteMessage("EMAIL_MSG_223", new Object[]{fileName, dataSlotName});
        }
        return fileURL;
    }

    private String getNonExistingDS() {
        StringBuilder nonExistingDSBuf = new StringBuilder();
        String comma = "";
        for (int idx = 0; idx < this.outputDS.size(); ++idx) {
            DataSlot ds = (DataSlot)this.outputDS.get(idx);
            String dsName = ds.getName();
            if (this.parsedEmailData.containsKey(dsName)) continue;
            nonExistingDSBuf.append(comma).append(dsName);
            comma = ", ";
        }
        return nonExistingDSBuf.toString();
    }

    private Map<String, Object> getNonDocumentDS(Map<String, String> attachments) {
        HashMap<String, Object> nonDocDS = new HashMap<String, Object>();
        for (int idx = 0; idx < this.outputDS.size(); ++idx) {
            DataSlot ds = (DataSlot)this.outputDS.get(idx);
            String dsName = ds.getName();
            if (ds.isDocument()) continue;
            Object dsValue = this.readNonDocumentDS(ds, attachments);
            nonDocDS.put(dsName, dsValue);
        }
        return nonDocDS;
    }

    private Object readNonDocumentDS(DataSlot ds, Map attachments) throws BizLogicClientException {
        Object objValue = null;
        String dataSlotName = ds.getName();
        String dsValue = null;
        dsValue = (String)this.parsedEmailData.remove(dataSlotName);
        if (EmailUtil.self().isDecodePlusEnabled()) {
            dsValue = EmailUtil.self().decode(dataSlotName, dsValue, this.emailClientName);
        }
        this.verifyDSValue(dsValue, ds);
        objValue = this.getDSValue(dsValue, ds, attachments);
        return objValue;
    }

    private void verifyDSValue(String dsValue, DataSlot ds) throws BizLogicClientException {
        if (!EmailUtil.isDataSlotEmpty(dsValue)) {
            dsValue = dsValue.trim();
            if (ds.isString() || ds.isURL()) {
                int dsSize = ds.getSize();
                if (dsValue.length() > dsSize) {
                    EmailUtil.self().replyAndDeleteMessage("EMAIL_MSG_216", new Object[]{dsValue, ds.getName(), String.valueOf(dsSize)});
                }
            }
            if (ds.hasChoices() && !ds.getChoices().contains(dsValue)) {
                EmailUtil.self().replyAndDeleteMessage("EMAIL_MSG_218", new Object[]{dsValue, ds.getName()});
            }
        } else if (ds.isRequired() && EmailUtil.self().isCheckRequiredDSEnabled()) {
            EmailUtil.self().replyAndDeleteMessage("EMAIL_MSG_221", new Object[]{ds.getName()});
        }
    }

    private Object getDSValue(String dsValue, DataSlot ds, Map attachments) throws BizLogicClientException {
        ArrayList<String> objValue;
        block30: {
            objValue = "<NULL>";
            if (null != dsValue) {
                if ("<NULL>".equals(dsValue.trim())) {
                    return objValue;
                }
                if ((dsValue = dsValue.trim()).length() != 0) {
                    try {
                        if (ds.isXML()) {
                            if (dsValue.endsWith(".xml") || dsValue.endsWith(".XML")) {
                                URL fileURL = null;
                                try {
                                    fileURL = new URL((String)attachments.get(dsValue));
                                }
                                catch (MalformedURLException malformedURLException) {
                                    // empty catch block
                                }
                                if (fileURL == null) {
                                    EmailUtil.self().replyAndDeleteMessage("EMAIL_MSG_240", new Object[]{dsValue, ds.getName()});
                                } else {
                                    String xmlContent = FileUtil.getString((URL)fileURL, (String)SBMUtil.self().getMailCharset());
                                    objValue = new XML(xmlContent);
                                }
                                break block30;
                            }
                            objValue = new XML(dsValue);
                            break block30;
                        }
                        if (ds.isDecimal()) {
                            objValue = new Decimal(dsValue);
                        } else if (ds.isDouble()) {
                            objValue = Double.valueOf(dsValue);
                        } else if (ds.isLong()) {
                            objValue = Long.valueOf(dsValue);
                        } else if (ds.isDateTime()) {
                            objValue = new DateTime(SBMUtil.self().getDateTime(dsValue, false));
                        } else if (ds.isBoolean()) {
                            objValue = Boolean.valueOf(dsValue);
                        } else if (ds.isList()) {
                            String[] listItems = this.parseCSStringValues(dsValue);
                            if (null != listItems) {
                                ArrayList<String> list = new ArrayList<String>(listItems.length);
                                for (int idx = 0; idx < listItems.length; ++idx) {
                                    list.add(listItems[idx]);
                                }
                                objValue = list;
                            }
                        } else if (ds.isMap()) {
                            try {
                                objValue = SBMUtil.self().createMapFromString(dsValue);
                            }
                            catch (SBMException e) {
                                String message = e.getMessage();
                                EmailUtil.self().throwEmailException(message, e);
                            }
                        } else {
                            objValue = dsValue;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        EmailUtil.self().replyAndDeleteMessage("EMAIL_MSG_217", new Object[]{dsValue, ds.getName()});
                    }
                    catch (ParseException e) {
                        EmailUtil.self().replyAndDeleteMessage("EMAIL_MSG_109", new Object[]{ds.getName(), dsValue});
                    }
                }
            }
        }
        return objValue;
    }

    private String[] parseCSStringValues(String val) {
        String[] fileNames = null;
        if (val != null) {
            fileNames = val.split(",");
        }
        return fileNames;
    }

    public List getOutputDataslots() {
        return this.outputDS;
    }

    public String getPerformer() {
        return this.performer;
    }

    private List getOutputDocumentFileNames() {
        ArrayList<String> files = new ArrayList<String>();
        for (int idx = 0; idx < this.outputDS.size(); ++idx) {
            String dsFiles;
            String[] fileNames;
            DataSlot ds = (DataSlot)this.outputDS.get(idx);
            String dsName = ds.getName();
            if (!ds.isDocument() && !ds.isXML() || (fileNames = this.parseCSStringValues((dsFiles = (String)this.parsedEmailData.get(dsName)).trim())) == null || fileNames.length <= 0) continue;
            for (int i = 0; i < fileNames.length; ++i) {
                files.add(fileNames[i].trim());
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private EmailException handleException(Message message, Throwable throwable) {
        String excMessage2222222222;
        String messageId = EmailUtil.getMessageId(message);
        Session session = null;
        Store store = null;
        String subject = "";
        String fromAddress = "";
        EmailException emailException = null;
        try {
            subject = message.getSubject();
            fromAddress = message.getFrom()[0].toString();
            session = EmailUtil.self().getIncomingMailSession();
            String protocol = EmailUtil.self().getIncomingMailProtocol();
            store = session.getStore(protocol);
            store.connect(EmailUtil.self().getIncomingMailServer(), EmailUtil.self().getIncomingMailPort(), EmailUtil.self().getIncomingMailUser(), EmailUtil.self().getIncomingMailPassword());
            excMessage2222222222 = null;
        }
        catch (Throwable excMessage2222222222) {
            String excMessage3 = null;
            if (null != store && store.isConnected()) {
                try {
                    store.close();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                EmailUtil.self().error("EMAIL_MSG_252", new Object[]{subject, fromAddress, messageId}, throwable);
                excMessage3 = EmailUtil.self().getMessage("EMAIL_MSG_253", new Object[]{subject, fromAddress, throwable.getMessage(), messageId});
                emailException = new EmailException(excMessage3, throwable);
                emailException.setDeleteMail(true);
                emailException.setSendMail(true);
            } else {
                excMessage3 = EmailUtil.self().getMessage("EMAIL_MSG_257", new Object[]{subject, fromAddress, messageId});
                emailException = new EmailException(excMessage3, throwable);
            }
            session = null;
            catch (Throwable throwable3) {
                String excMessage4 = null;
                if (null != store && store.isConnected()) {
                    try {
                        store.close();
                    }
                    catch (Throwable throwable4) {
                        // empty catch block
                    }
                    EmailUtil.self().error("EMAIL_MSG_252", new Object[]{subject, fromAddress, messageId}, throwable);
                    excMessage4 = EmailUtil.self().getMessage("EMAIL_MSG_253", new Object[]{subject, fromAddress, throwable.getMessage(), messageId});
                    emailException = new EmailException(excMessage4, throwable);
                    emailException.setDeleteMail(true);
                    emailException.setSendMail(true);
                } else {
                    excMessage4 = EmailUtil.self().getMessage("EMAIL_MSG_257", new Object[]{subject, fromAddress, messageId});
                    emailException = new EmailException(excMessage4, throwable);
                }
                session = null;
                throw throwable3;
            }
        }
        if (null != store && store.isConnected()) {
            try {
                store.close();
            }
            catch (Throwable throwable5) {
                // empty catch block
            }
            EmailUtil.self().error("EMAIL_MSG_252", new Object[]{subject, fromAddress, messageId}, throwable);
            excMessage2222222222 = EmailUtil.self().getMessage("EMAIL_MSG_253", new Object[]{subject, fromAddress, throwable.getMessage(), messageId});
            emailException = new EmailException(excMessage2222222222, throwable);
            emailException.setDeleteMail(true);
            emailException.setSendMail(true);
        } else {
            excMessage2222222222 = EmailUtil.self().getMessage("EMAIL_MSG_257", new Object[]{subject, fromAddress, messageId});
            emailException = new EmailException(excMessage2222222222, throwable);
        }
        session = null;
        return emailException;
    }
}

