/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.messaging.publisher;

import com.savvion.sbm.bizlogic.messaging.MsgErrorHandler;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.ProcessContext;
import com.savvion.sbm.messaging.svo.Channel;
import com.savvion.sbm.messaging.svo.MessageDescriptor;
import com.savvion.sbm.messaging.svo.MessageProperty;
import com.savvion.sbm.messaging.util.MessagingUtil;
import com.savvion.sbm.util.jax.XMLUtil;
import com.savvion.sbm.util.jax.XPathUtil;
import com.savvion.sbm.util.logger.SBMLogger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import org.w3c.dom.Document;

public abstract class MessagePublisher {
    protected HashMap<String, Object> context = null;
    private transient ProcessContext processContext = null;

    public final void setContext(HashMap newContext) {
        if (this.context != null) {
            return;
        }
        this.context = newContext;
        this.processContext = (ProcessContext)newContext.get("ProcessContext");
    }

    public final Channel getChannel() {
        return (Channel)this.context.get("CHANNEL");
    }

    public final MessageDescriptor getMessageDescriptor() {
        return (MessageDescriptor)this.context.get("MESSAGE_DESCRIPTOR");
    }

    public final List<HashMap<String, String>> getMessageMapping() {
        return (List)this.context.get("MESSAGE_MAPPING");
    }

    public final HashMap getDSValuesMappedToMessage() {
        return (HashMap)this.context.get("MESSAGE_MAPPED_DS_VALUES");
    }

    public final String createPayload() {
        MessageDescriptor msgDescr = this.getMessageDescriptor();
        String templateContent = msgDescr.getTemplateContent();
        List<HashMap<String, String>> messageMapping = this.getMessageMapping();
        Document templateDoc = null;
        try {
            templateDoc = XMLUtil.getDocument((String)templateContent, (boolean)false);
        }
        catch (Throwable th) {
            throw MsgErrorHandler.createEx("BizLogic_ERR_3604", "MessagePublisher.createPayload", new Object[]{templateContent, this.getWorkStepName(), this.getProcessInstanceName()}, th);
        }
        for (int ix = 0; ix < messageMapping.size(); ++ix) {
            HashMap<String, String> oneMapping = messageMapping.get(ix);
            String copyTo = oneMapping.get("COPY_TO");
            if (!msgDescr.isPayloadProperty(copyTo)) continue;
            MessageProperty msgProp = msgDescr.getPayloadProperty(copyTo);
            if (msgProp == null) {
                throw MsgErrorHandler.createEx("BizLogic_ERR_3617", "MessagePublisher.createPayload", new Object[]{copyTo, msgDescr.getMessageName(), this.getWorkStepName(), this.getProcessInstanceName()});
            }
            String xpath = msgProp.getXPath();
            String valueToFill = null;
            try {
                String copyFrom = oneMapping.get("COPY_FROM");
                Object value = this.getValue(copyFrom);
                if (value == null || "<NULL>".trim().equalsIgnoreCase(value.toString())) continue;
                valueToFill = value.toString();
                if (this.isXMLDS(copyFrom) && xpath.endsWith("text()")) {
                    valueToFill = MessagingUtil.encodeString((String)valueToFill, (String)"base64");
                }
                templateDoc = XPathUtil.setNodeValue((Document)templateDoc, (String)xpath, (String)valueToFill, (Map)msgDescr.getNamespaces(), (QName)XPathConstants.NODESET);
                continue;
            }
            catch (Throwable th) {
                throw MsgErrorHandler.createEx("BizLogic_ERR_4520", "MessagePublisher.createPayload", new Object[]{valueToFill, xpath, msgDescr.getMessageName(), this.getWorkStepName(), this.getProcessInstanceName()}, th);
            }
        }
        try {
            String filledTemplate = XMLUtil.convertDOMToString((Document)templateDoc, null);
            if (this.isDebug()) {
                this.getLogger().debugKey("BizLogic_ERR_3137", "MessagePublisher.createPayload", new Object[]{this.getWorkStepName(), this.getProcessInstanceName(), msgDescr.getMessageName(), filledTemplate});
            }
            return filledTemplate;
        }
        catch (Throwable th) {
            throw MsgErrorHandler.createEx("BizLogic_ERR_4521", "MessagePublisher.createPayload", new Object[]{msgDescr.getMessageName(), this.getWorkStepName(), this.getProcessInstanceName()}, th);
        }
    }

    private boolean isXMLDS(String dsName) {
        if (BLUtil.self().isSystemDataSlot(dsName)) {
            return false;
        }
        dsName = dsName.substring(1);
        ProcessContext processContext = (ProcessContext)this.context.get("ProcessContext");
        Map dsTypes = processContext.getDataslotTypes();
        String type = (String)dsTypes.get(dsName);
        BLConstants.single();
        return "XML".equals(type);
    }

    public final HashMap<String, Object> getHeaderProperties() {
        HashMap<String, Object> headerProps = new HashMap<String, Object>();
        String msgName = this.getMessageDescriptor().getMessageName();
        headerProps.put("MessageName", msgName);
        headerProps.put("SenderAppName", this.getApplicationName());
        headerProps.put("SenderTemplateName", this.getProcessTemplateName());
        headerProps.put("SenderInstanceId", this.getProcessInstanceID());
        headerProps.put("SenderTaskName", this.getWorkStepName());
        MessageDescriptor msgDescr = this.getMessageDescriptor();
        List<HashMap<String, String>> messageMapping = this.getMessageMapping();
        for (int ix = 0; ix < messageMapping.size(); ++ix) {
            HashMap<String, String> oneMapping = messageMapping.get(ix);
            String copyTo = oneMapping.get("COPY_TO");
            if (!msgDescr.isHeaderProperty(copyTo)) continue;
            String copyFrom = oneMapping.get("COPY_FROM");
            headerProps.put(copyTo, this.getValue(copyFrom));
        }
        if (this.isDebug()) {
            this.getLogger().debugKey("BizLogic_ERR_3140", "MessagePublisher.getHeaderProperties", new Object[]{this.getWorkStepName(), this.getProcessInstanceName(), msgDescr.getMessageName(), headerProps});
        }
        return headerProps;
    }

    public final Object getValue(String copyFrom) {
        if (MessagePublisher.isDataslot(copyFrom)) {
            String dsName = copyFrom;
            if (!BLUtil.self().isSystemDataSlot(copyFrom)) {
                dsName = copyFrom.substring(1);
            }
            return this.getDSValuesMappedToMessage().get(dsName);
        }
        return copyFrom;
    }

    public final long getProcessTemplateID() {
        return (Long)this.context.get("PROCESSTEMPLATEID");
    }

    public final String getApplicationName() {
        return (String)this.context.get("APPLICATIONNAME");
    }

    public final String getProcessTemplateName() {
        return this.processContext.getProcessTemplateName();
    }

    public final long getProcessInstanceID() {
        return this.processContext.getProcessInstanceID();
    }

    public final String getProcessInstanceName() {
        return this.processContext.getProcessInstanceName();
    }

    public final String getWorkStepName() {
        return this.processContext.getWorkstepName();
    }

    public final long getWorkstepID() {
        return this.processContext.getWorkstepID();
    }

    public final Map getInputSlots() {
        return this.processContext.getInputSlots();
    }

    public final Map getMappedInputDataslots() {
        return this.processContext.getMappedInputDataslots();
    }

    public final Map getMappedOutputDataslots() {
        return this.processContext.getMappedOutputDataslots();
    }

    public final Map getDataslotTypes() {
        return this.processContext.getDataslotTypes();
    }

    public final SBMLogger getLogger() {
        return (SBMLogger)this.context.get("LOGGER");
    }

    public final boolean isDebug() {
        return (Boolean)this.context.get("DEBUG");
    }

    public static final boolean isDataslot(String name) {
        return name != null && name.startsWith("@");
    }

    public abstract void init();

    public abstract void destroy();

    public abstract Object createMessage() throws Exception;

    public abstract HashMap publish(Object var1) throws Exception;
}

