/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.messaging.subscriber;

import com.savvion.sbm.bizlogic.messaging.MessageControl;
import com.savvion.sbm.bizlogic.messaging.subscriber.BLBizMessage;
import com.savvion.sbm.bizlogic.messaging.subscriber.MessageManager;
import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFProcessInstance;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.svo.MessageSubscription;
import com.savvion.sbm.bizlogic.server.svo.MessageSubscriptionList;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.Session;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class TemplateLocator {
    public static List getTemplates(BLBizMessage message) {
        String msgName = message.getMessageName();
        if (BLControl.util.DEBUG_MESSAGING) {
            MessageControl.self().logger.debugKey("BizLogic_ERR_2243", "TemplateLocator.getTemplates", new Object[]{msgName});
        }
        Collection ptCollection = ProcessControl.getAllProcessTemplates();
        ArrayList allPTList = new ArrayList(ptCollection);
        ArrayList<Long> activeTargetTemplates = new ArrayList<Long>();
        ArrayList<String> nonActiveTargetTemplates = new ArrayList<String>();
        WFProcess pt = null;
        for (int ix = 0; ix < allPTList.size(); ++ix) {
            pt = (WFProcess)allPTList.get(ix);
            if (!TemplateLocator.qualifies(pt, message)) continue;
            if (pt.isActivated()) {
                activeTargetTemplates.add(pt.getID());
                continue;
            }
            nonActiveTargetTemplates.add(pt.getName());
        }
        if (!nonActiveTargetTemplates.isEmpty()) {
            MessageControl.self().logger.warnKey("BizLogic_ERR_3611", "TemplateLocator.getTemplates", new Object[]{((Object)nonActiveTargetTemplates).toString(), msgName});
        }
        if (null != activeTargetTemplates && !activeTargetTemplates.isEmpty()) {
            MessageControl.self().logger.debugKey("BizLogic_ERR_2244", "TemplateLocator.getTemplates", new Object[]{((Object)activeTargetTemplates).toString(), msgName});
        }
        return activeTargetTemplates;
    }

    private static boolean qualifies(WFProcess pt, BLBizMessage message) {
        String msgName = message.getMessageName();
        if (!pt.isInstantiateOnMessage(msgName)) {
            return false;
        }
        String receiverAppName = message.getReceiverAppName();
        if (receiverAppName != null && receiverAppName.trim().length() > 0 && !(receiverAppName = receiverAppName.trim()).equals(pt.getAppName())) {
            return false;
        }
        WFWorkstep startWS = pt.getInitialWorkstep();
        MessageSubscriptionList msgSubscriptionList = startWS.getMessageSubscriptionList();
        MessageSubscription msgSubscription = msgSubscriptionList.getSubscribedMessage(msgName);
        if (msgSubscription == null) {
            return false;
        }
        if (!msgSubscription.hasCorrelation()) {
            return true;
        }
        List corrMapping = msgSubscription.getCorrelationMapping();
        for (int ix = 0; ix < corrMapping.size(); ++ix) {
            HashMap oneCorrMap = (HashMap)corrMapping.get(ix);
            String msgPropName = (String)oneCorrMap.get("PROP_NAME");
            String dsNameOrConst = (String)oneCorrMap.get("PROP_VAL");
            String msgValue = message.getProperty(msgPropName);
            String wsName = pt.getInitialWorkstep().getName();
            if (!dsNameOrConst.startsWith("@")) {
                if (dsNameOrConst.equals(msgValue)) continue;
                return false;
            }
            if ("@PROCESSNAME".equalsIgnoreCase(dsNameOrConst)) {
                if (msgValue.equals(pt.getName()) || msgValue.equals(pt.getAppName())) continue;
                return false;
            }
            MessageControl.self().logger.warnKey("BizLogic_ERR_3616", "TemplateLocator.qualifies", new Object[]{dsNameOrConst.substring(1), wsName, pt.getName()});
            return false;
        }
        return true;
    }

    public static void instantiateTemplates(List templateIDs, BLBizMessage message) {
        if (templateIDs == null || templateIDs.isEmpty()) {
            return;
        }
        Session session = BLControl.getServerSession();
        for (int ix = 0; ix < templateIDs.size(); ++ix) {
            Long ptidObj = (Long)templateIDs.get(ix);
            long ptid = ptidObj;
            TemplateLocator.createInstance(ptid, session, message);
        }
    }

    public static void createInstance(long ptid, Session session, BLBizMessage message) {
        String priority;
        if (BLControl.util.DEBUG_MESSAGING) {
            MessageControl.self().logger.debugKey("BizLogic_ERR_2245", "TemplateLocator.createInstance", new Object[]{ptid, message.getMessageName()});
        }
        HashMap attrs = new HashMap();
        if (message.receiverPriorityExists()) {
            priority = message.getReceiverPriority();
            if (BLControl.util.DEBUG_MESSAGING) {
                MessageControl.self().logger.debugKey("BizLogic_ERR_2246", "TemplateLocator.createInstance", new Object[]{priority, "PRIORITY", message.getMessageName()});
            }
            attrs.put("PRIORITY", priority);
        }
        if (message.receiverInstanceAliasExists()) {
            String instancePrefix = message.getReceiverInstanceAlias();
            if (BLControl.util.DEBUG_MESSAGING) {
                MessageControl.self().logger.debugKey("BizLogic_ERR_2246", "TemplateLocator.createInstance", new Object[]{instancePrefix, "INSTANCE_PREFIX", message.getMessageName()});
            }
            attrs.put("PROCESSINSTANCENAME", instancePrefix);
        }
        if (message.receiverPriorityExists()) {
            priority = message.getReceiverPriority();
            if (BLControl.util.DEBUG_MESSAGING) {
                MessageControl.self().logger.debugKey("BizLogic_ERR_2246", "TemplateLocator.createInstance", new Object[]{priority, "PRIORITY", message.getMessageName()});
            }
            attrs.put("PRIORITY", priority);
        }
        if (message.senderNameExists()) {
            String senderName = message.getSenderName();
            if (BLControl.util.DEBUG_MESSAGING) {
                MessageControl.self().logger.debugKey("BizLogic_ERR_2246", "TemplateLocator.createInstance", new Object[]{senderName, "CREATOR", message.getMessageName()});
            }
            attrs.put("CREATOR", senderName);
        }
        String ptName = null;
        try {
            WFProcess ptObj = ProcessControl.getProcessTemplate(ptid);
            ptName = ptObj.getName();
            attrs = WFProcessInstance.self().validateAttributesForCreateInstance(ptName, attrs);
            WFWorkstep startWS = ptObj.getInitialWorkstep();
            HashMap<String, Object> dsValues = MessageManager.getDSValuesMappedToMessage(message, startWS, ptObj, false);
            HashMap dsWithObjectValues = WFProcess.convertStringToObjectValue(ptObj, dsValues);
            WFProcessContext.createProcessInstance(session, attrs, dsWithObjectValues, true);
            if (BLControl.util.DEBUG_MESSAGING) {
                MessageControl.self().logger.debugKey("BizLogic_ERR_2250", "TemplateLocator.createInstance", new Object[]{ptName});
            }
        }
        catch (Throwable t) {
            throw new BizLogicException("BizLogic_ERR_4522", "TemplateLocator.createInstance()", new Object[]{ptName, message.getMessageName()}, t);
        }
    }
}

