/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.enums.SystemDataSlot;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.svo.Decimal;
import com.savvion.sbm.bizlogic.server.svo.DocumentDS;
import com.savvion.sbm.bizlogic.server.svo.XML;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataslotOperation {
    public static void copy(WFProcessContext pCtx, String srcDSName, String tgtDSName) {
        try {
            WFDataslot tgtDS;
            if (SystemDataSlot.isSystemDataSlot((String)tgtDSName)) {
                throw new BizLogicException("BizLogic_ERR_8116", "DataslotOperation.copy()", new Object[]{pCtx.getProcessTemplateID(), pCtx.getProcessInstanceID(), tgtDSName, "System"});
            }
            WFDataslot srcDS = pCtx.getDataslot(srcDSName);
            if (!DataslotOperation.isSameType(srcDS, tgtDS = pCtx.getDataslot(tgtDSName))) {
                throw new BizLogicException("BizLogic_ERR_8115", "DataslotOperation.copy()", new Object[]{pCtx.getProcessTemplateID(), pCtx.getProcessInstanceID(), srcDS.getType(), tgtDS.getType()});
            }
            pCtx.setCopyDSContext(srcDSName);
            if (srcDS.isString()) {
                DataslotOperation.copyString(pCtx, srcDSName, tgtDSName);
            } else if (srcDS.isURL()) {
                DataslotOperation.copyURL(pCtx, srcDSName, tgtDSName);
            } else if (srcDS.isLong()) {
                DataslotOperation.copyLong(pCtx, srcDSName, tgtDSName);
            } else if (srcDS.isDouble()) {
                DataslotOperation.copyDouble(pCtx, srcDSName, tgtDSName);
            } else if (srcDS.isDecimal()) {
                DataslotOperation.copyDecimal(pCtx, srcDSName, tgtDSName);
            } else if (srcDS.isBoolean()) {
                DataslotOperation.copyBoolean(pCtx, srcDSName, tgtDSName);
            } else if (srcDS.isDate()) {
                DataslotOperation.copyDate(pCtx, srcDSName, tgtDSName);
            } else if (srcDS.isList()) {
                DataslotOperation.copyList(pCtx, srcDSName, tgtDSName);
            } else if (srcDS.isMap()) {
                DataslotOperation.copyMap(pCtx, srcDSName, tgtDSName);
            } else if (srcDS.isDocument()) {
                DataslotOperation.copyDocument(pCtx, srcDSName, tgtDSName);
            } else if (srcDS.isXML()) {
                DataslotOperation.copyXML(pCtx, srcDSName, tgtDSName);
            } else if (srcDS.isObject()) {
                DataslotOperation.copyObject(pCtx, srcDSName, tgtDSName);
            }
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_8117", "DataslotOperation.copy()", new Object[]{srcDSName, tgtDSName, pCtx.getProcessTemplateID(), pCtx.getProcessInstanceID()}, th);
        }
    }

    private static void copyString(WFProcessContext pCtx, String srcDSName, String tgtDSName) {
        HashMap dsValues = pCtx.getSlotValue(new String[]{srcDSName, tgtDSName});
        String srcDSValue = (String)dsValues.get(srcDSName);
        String tgtDSValue = (String)dsValues.get(tgtDSName);
        if (pCtx.getDataslot(tgtDSName).isMonitorDS() && tgtDSValue != null) {
            throw new BizLogicException("BizLogic_ERR_8116", "DataslotOperation.copyString()", new Object[]{pCtx.getProcessTemplateID(), pCtx.getProcessInstanceID(), tgtDSName, "Monitor"});
        }
        if (DataslotOperation.isNull(srcDSValue, tgtDSValue)) {
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_8114", new Object[]{pCtx.getProcessTemplateID(), pCtx.getProcessInstanceID(), pCtx.getDataslot(srcDSName).getType(), srcDSName, tgtDSName});
            }
            return;
        }
        if (!DataslotOperation.containsNull(srcDSValue, tgtDSValue) && DataslotOperation.isEqual(srcDSValue, tgtDSValue)) {
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_8114", new Object[]{pCtx.getProcessTemplateID(), pCtx.getProcessInstanceID(), pCtx.getDataslot(srcDSName).getType(), srcDSName, tgtDSName});
            }
            return;
        }
        WFDataslot tgtDS = pCtx.getDataslot(tgtDSName);
        int targetDSSize = tgtDS.getSize();
        int srcDataLen = srcDSValue.length();
        if (srcDataLen > targetDSSize) {
            throw new BizLogicException("BizLogic_ERR_8118", "DataslotOperation.copyString()", new Object[]{pCtx.getProcessTemplateID(), pCtx.getProcessInstanceID(), srcDataLen, srcDSName, targetDSSize, tgtDSName});
        }
        pCtx.updateSlotValue(tgtDSName, srcDSValue);
    }

    private static void copyURL(WFProcessContext pCtx, String srcDSName, String tgtDSName) {
        DataslotOperation.copyString(pCtx, srcDSName, tgtDSName);
    }

    private static void copyLong(WFProcessContext pCtx, String srcDSName, String tgtDSName) {
        DataslotOperation.copyIfNotSame(pCtx, srcDSName, tgtDSName);
    }

    private static void copyDouble(WFProcessContext pCtx, String srcDSName, String tgtDSName) {
        DataslotOperation.copyIfNotSame(pCtx, srcDSName, tgtDSName);
    }

    private static void copyDecimal(WFProcessContext pCtx, String srcDSName, String tgtDSName) throws ParseException {
        Object tgtDSValue;
        HashMap dsValues = pCtx.getSlotValue(new String[]{srcDSName, tgtDSName});
        Object srcDSValue = dsValues.get(srcDSName);
        if (DataslotOperation.isEqual(srcDSValue, tgtDSValue = dsValues.get(tgtDSName))) {
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_8114", new Object[]{pCtx.getProcessTemplateID(), pCtx.getProcessInstanceID(), pCtx.getDataslot(srcDSName).getType(), srcDSName, tgtDSName});
            }
            return;
        }
        WFDataslot tgtDS = pCtx.getDataslot(tgtDSName);
        int targetDSScale = tgtDS.getScale();
        int tgtDSPrecison = tgtDS.getPrecision();
        Decimal srcDS = (Decimal)srcDSValue;
        srcDS.validate(tgtDSPrecison, targetDSScale);
        pCtx.updateSlotValue(tgtDSName, srcDSValue);
    }

    private static void copyBoolean(WFProcessContext pCtx, String srcDSName, String tgtDSName) {
        DataslotOperation.copyIfNotSame(pCtx, srcDSName, tgtDSName);
    }

    private static void copyDate(WFProcessContext pCtx, String srcDSName, String tgtDSName) {
        DataslotOperation.copyIfNotSame(pCtx, srcDSName, tgtDSName);
    }

    private static void copyList(WFProcessContext pCtx, String srcDSName, String tgtDSName) {
        HashMap dsValues = pCtx.getSlotValue(new String[]{srcDSName, tgtDSName});
        Object srcDSValue = dsValues.get(srcDSName);
        Object tgtDSValue = dsValues.get(tgtDSName);
        if (srcDSValue == null || DataslotOperation.isNull(srcDSValue, tgtDSValue)) {
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_8113", new Object[]{pCtx.getProcessTemplateID(), pCtx.getProcessInstanceID(), pCtx.getDataslot(srcDSName).getType(), srcDSName, tgtDSName});
            }
            return;
        }
        List srcDS = (List)srcDSValue;
        List tgtDS = (List)tgtDSValue;
        if (srcDS.isEmpty() || srcDS.isEmpty() && tgtDS.isEmpty()) {
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_8114", new Object[]{pCtx.getProcessTemplateID(), pCtx.getProcessInstanceID(), pCtx.getDataslot(srcDSName).getType(), srcDSName, tgtDSName});
            }
            return;
        }
        List newVal = null;
        if (tgtDS == null || tgtDS.isEmpty()) {
            newVal = srcDS;
        } else {
            tgtDS.addAll(srcDS);
            newVal = tgtDS;
        }
        pCtx.updateSlotValue(tgtDSName, newVal);
    }

    private static void copyMap(WFProcessContext pCtx, String srcDSName, String tgtDSName) {
        HashMap dsValues = pCtx.getSlotValue(new String[]{srcDSName, tgtDSName});
        Object srcDSValue = dsValues.get(srcDSName);
        Object tgtDSValue = dsValues.get(tgtDSName);
        if (srcDSValue == null || DataslotOperation.isNull(srcDSValue, tgtDSValue)) {
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_8113", new Object[]{pCtx.getProcessTemplateID(), pCtx.getProcessInstanceID(), pCtx.getDataslot(srcDSName).getType(), srcDSName, tgtDSName});
            }
            return;
        }
        Map srcDS = (Map)srcDSValue;
        Map tgtDS = (Map)tgtDSValue;
        if (srcDS.isEmpty() || srcDS.isEmpty() && tgtDS.isEmpty()) {
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_8114", new Object[]{pCtx.getProcessTemplateID(), pCtx.getProcessInstanceID(), pCtx.getDataslot(srcDSName).getType(), srcDSName, tgtDSName});
            }
            return;
        }
        Map newVal = null;
        if (tgtDS == null || tgtDS.isEmpty()) {
            newVal = srcDS;
        } else {
            tgtDS.putAll(srcDS);
            newVal = tgtDS;
        }
        pCtx.updateSlotValue(tgtDSName, newVal);
    }

    private static void copyDocument(WFProcessContext pCtx, String srcDSName, String tgtDSName) {
        HashMap dsValues = pCtx.getSlotValue(new String[]{srcDSName, tgtDSName});
        Object srcDSValue = dsValues.get(srcDSName);
        Object tgtDSValue = dsValues.get(tgtDSName);
        DocumentDS srcDocDS = (DocumentDS)srcDSValue;
        DocumentDS tgtDocDS = (DocumentDS)tgtDSValue;
        if (srcDocDS.isNull()) {
            BLControl.logger.warnKey("BizLogic_ERR_8113", new Object[]{pCtx.getProcessTemplateID(), pCtx.getProcessInstanceID(), pCtx.getDataslot(srcDSName).getType(), srcDSName, tgtDSName});
            return;
        }
        if (srcDocDS.isEmpty()) {
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_8114", new Object[]{pCtx.getProcessTemplateID(), pCtx.getProcessInstanceID(), pCtx.getDataslot(srcDSName).getType(), srcDSName, tgtDSName});
            }
            return;
        }
        if (tgtDocDS.isEmpty()) {
            srcDocDS.copyDocumentDS(tgtDocDS);
        } else {
            List srcDocNames = srcDocDS.getDocumentNames();
            List tgtDocNames = tgtDocDS.getDocumentNames();
            for (String srcDocName : srcDocNames) {
                if (!tgtDocNames.contains(srcDocName)) continue;
                tgtDocDS.removeByName(srcDocName);
            }
            srcDocDS.copyDocumentDS(tgtDocDS);
        }
        pCtx.updateSlotValue(tgtDSName, tgtDocDS);
    }

    private static void copyXML(WFProcessContext pCtx, String srcDSName, String tgtDSName) throws Throwable {
        HashMap dsValues = pCtx.getSlotValue(new String[]{srcDSName, tgtDSName});
        Object srcDSValue = dsValues.get(srcDSName);
        Object tgtDSValue = dsValues.get(tgtDSName);
        XML srcDS = (XML)srcDSValue;
        XML tgtDS = (XML)tgtDSValue;
        if (srcDS.isNull() || srcDS.getContent(pCtx.getSession()) == null) {
            BLControl.logger.warnKey("BizLogic_ERR_8113", new Object[]{pCtx.getProcessTemplateID(), pCtx.getProcessInstanceID(), pCtx.getDataslot(srcDSName).getType(), srcDSName, tgtDSName});
            return;
        }
        XML newTgtXml = null;
        if (!srcDS.isNull() && tgtDS.isNull()) {
            newTgtXml = new XML(srcDS.getContent(pCtx.getSession()));
            newTgtXml.setName(srcDS.getName());
        } else {
            newTgtXml = tgtDS;
            newTgtXml.setContent(srcDS.getContent(pCtx.getSession()));
            newTgtXml.setName(srcDS.getName());
        }
        pCtx.updateSlotValue(tgtDSName, newTgtXml);
    }

    private static void copyObject(WFProcessContext pCtx, String srcDSName, String tgtDSName) {
        Object tgtDSValue;
        HashMap dsValues = pCtx.getSlotValue(new String[]{srcDSName, tgtDSName});
        Object srcDSValue = dsValues.get(srcDSName);
        if (DataslotOperation.isNull(srcDSValue, tgtDSValue = dsValues.get(tgtDSName))) {
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_8114", new Object[]{pCtx.getProcessTemplateID(), pCtx.getProcessInstanceID(), pCtx.getDataslot(srcDSName).getType(), srcDSName, tgtDSName});
            }
            return;
        }
        WFDataslot srcDS = pCtx.getDataslot(srcDSName);
        WFDataslot tgtDS = pCtx.getDataslot(tgtDSName);
        if (!srcDS.getJavaClassName().equals(tgtDS.getJavaClassName())) {
            throw new BizLogicException("BizLogic_ERR_8119", "DataslotOperation.copyObject()", new Object[]{pCtx.getProcessTemplateID(), pCtx.getProcessInstanceID(), srcDSName, srcDS.getJavaClassName(), tgtDSName, tgtDS.getJavaClassName()});
        }
        pCtx.updateSlotValue(tgtDSName, srcDSValue);
    }

    private static void copyIfNotSame(WFProcessContext pCtx, String srcDSName, String tgtDSName) {
        Object tgtDSValue;
        HashMap dsValues = pCtx.getSlotValue(new String[]{srcDSName, tgtDSName});
        Object srcDSValue = dsValues.get(srcDSName);
        if (DataslotOperation.isEqual(srcDSValue, tgtDSValue = dsValues.get(tgtDSName))) {
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_8114", new Object[]{pCtx.getProcessTemplateID(), pCtx.getProcessInstanceID(), pCtx.getDataslot(srcDSName).getType(), srcDSName, tgtDSName});
            }
            return;
        }
        pCtx.updateSlotValue(tgtDSName, srcDSValue);
    }

    private static boolean isEqual(Object srcDSValue, Object tgtDSValue) {
        return DataslotOperation.isNull(srcDSValue, tgtDSValue) || srcDSValue.equals(tgtDSValue);
    }

    private static boolean isNull(Object srcDSValue, Object tgtDSValue) {
        return srcDSValue == null && tgtDSValue == null;
    }

    private static boolean containsNull(Object srcDSValue, Object tgtDSValue) {
        return srcDSValue == null || tgtDSValue == null;
    }

    private static boolean isSameType(WFDataslot srcDS, WFDataslot tgtDS) {
        return srcDS.getType().equalsIgnoreCase(tgtDS.getType());
    }
}

