/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFNestedWS;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.svo.DataSlotMapping;
import com.savvion.sbm.bizlogic.server.svo.DataSlotMappingList;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import java.io.Serializable;
import java.util.ArrayList;

public class SubProcessMetaData
implements Serializable {
    static final long serialVersionUID = 8914906015005268754L;
    private final String subProcessName;
    private Object count;
    private boolean isCountMappedDS = false;
    private String subProcessAlias;
    private final WFProcess parentProcess;
    private final WFNestedWS parentWS;
    private DataSlotMappingList inputSlots;
    private DataSlotMappingList outputSlots;

    SubProcessMetaData(WFProcess wfProcess, WFNestedWS ws, String subProcessName) {
        if (wfProcess == null || ws == null) {
            throw new BizLogicException("BizLogic_ERR_885", "SubProcessMetaData.<init>", new Object[]{subProcessName});
        }
        this.parentProcess = wfProcess;
        this.parentWS = ws;
        this.subProcessName = subProcessName;
    }

    void setSubProcessAlias(String alias) {
        this.subProcessAlias = alias;
    }

    void setCount(Object count, boolean isCountMappedDS) {
        this.isCountMappedDS = isCountMappedDS;
        this.count = count;
    }

    void setInputSlots(DataSlotMappingList inputSlots) {
        this.inputSlots = inputSlots;
    }

    void setOutputSlots(DataSlotMappingList outputSlots) {
        this.outputSlots = outputSlots;
    }

    String getSubProcessName() {
        return this.subProcessName;
    }

    boolean isCountMappedDS() {
        return this.isCountMappedDS;
    }

    boolean isSubProcessNameMappedDS() {
        return this.isMapped(this.subProcessName);
    }

    boolean hasCount() {
        return this.count != null;
    }

    Object getCount() {
        return this.count;
    }

    String getSubProcessAlias() {
        return this.subProcessAlias;
    }

    DataSlotMappingList getInputSlots() {
        return this.inputSlots;
    }

    DataSlotMappingList getOutputSlots() {
        return this.outputSlots;
    }

    void fillDataslotMappingInfo() {
        WFWorkstep.fillDataslotMappingInfo(this.parentProcess, this.getInputSlots());
        WFWorkstep.fillDataslotMappingInfo(this.parentProcess, this.getOutputSlots());
    }

    ArrayList getIndexedSlots() {
        ArrayList list = this.inputSlots.getIndexedDataSlotMappings();
        list.addAll(this.outputSlots.getIndexedDataSlotMappings());
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isMapped(String val) {
        if (val == null) return false;
        BLConstants.single();
        if (!val.startsWith("@")) return false;
        return true;
    }

    void validate() {
        if (this.hasCount()) {
            WFDataslot ds;
            String dsName;
            if (this.isCountMappedDS) {
                dsName = this.count.toString();
                ds = this.parentProcess.getDataslot(dsName, true);
                if (ds == null) {
                    throw new BizLogicException("BizLogic_ERR_876", "SubProcessMetaData.validate", new Object[]{this.count, this.parentWS.getName(), this.parentProcess.getName()});
                }
                if (!ds.isLong()) {
                    throw new BizLogicException("BizLogic_ERR_876", "SubProcessMetaData.validate", new Object[]{this.count, this.parentWS.getName(), this.parentProcess.getName()});
                }
            }
            if (this.subProcessName == null || this.subProcessName.trim().length() == 0) {
                throw new BizLogicException("BizLogic_ERR_883", "SubProcessMetaData.validate", new Object[]{this.parentProcess.getName(), this.parentWS.getName()});
            }
            if (this.isMapped(this.subProcessName)) {
                BLConstants.single();
                dsName = this.subProcessName.substring(this.subProcessName.indexOf("@") + 1);
                ds = this.parentProcess.getDataslot(dsName, true);
                if (ds == null) {
                    throw new BizLogicException("BizLogic_ERR_875", "SubProcessMetaData.validate", new Object[]{this.subProcessName, this.parentWS.getName(), this.parentProcess.getName()});
                }
                if (!ds.isString() && !ds.isList()) {
                    throw new BizLogicException("BizLogic_ERR_875", "SubProcessMetaData.validate", new Object[]{this.subProcessName, this.parentWS.getName(), this.parentProcess.getName()});
                }
                if (ds.isList() && this.hasCount() && (this.isCountMappedDS || (Long)this.count != 1L)) {
                    throw new BizLogicException("BizLogic_ERR_878", "SubProcessMetaData.validate", new Object[]{this.parentWS.getName(), this.parentProcess.getName(), dsName});
                }
            }
        }
        ArrayList indexedSlots = this.getIndexedSlots();
        for (int ix = 0; ix < indexedSlots.size(); ++ix) {
            DataSlotMapping dsMapping = (DataSlotMapping)indexedSlots.get(ix);
            if (dsMapping.isList() || dsMapping.isObject()) continue;
            String dsName = dsMapping.getDataSlotName();
            throw new BizLogicException("BizLogic_ERR_877", "SubProcessMetaData.validate", new Object[]{dsName, this.parentWS.getName(), this.parentProcess.getName()});
        }
        if (this.subProcessAlias != null && this.subProcessAlias.trim().length() != 0) {
            this.validateSubProcessAlias();
        }
    }

    private void validateSubProcessAlias() {
        if (this.subProcessAlias != null && this.subProcessAlias.trim().length() != 0) {
            if (!BLUtil.isParameter((String)this.subProcessAlias)) {
                if (!BLUtil.isParameter((String)this.subProcessName)) {
                    return;
                }
                if (!this.isMappedStringDS(this.subProcessName)) {
                    throw new BizLogicException("BizLogic_ERR_3739", "SubProcessMetaData.validate()", new Object[]{this.parentProcess.getName(), this.parentWS.getName(), this.subProcessName, this.subProcessAlias, "String"});
                }
            } else {
                String dsName = BLUtil.getParameter((String)this.subProcessAlias);
                WFDataslot ds = this.parentProcess.getDataslot(dsName, true);
                if (ds == null) {
                    throw new BizLogicException("BizLogic_ERR_3740", "SubProcessMetaData.validate()", new Object[]{this.parentProcess.getName(), this.parentWS.getName(), dsName});
                }
                if (ds.isString()) {
                    if (!BLUtil.isParameter((String)this.subProcessName)) {
                        return;
                    }
                    if (!this.isMappedStringDS(this.subProcessName)) {
                        throw new BizLogicException("BizLogic_ERR_3739", "SubProcessMetaData.validate()", new Object[]{this.parentProcess.getName(), this.parentWS.getName(), this.subProcessName, this.subProcessAlias, "String"});
                    }
                } else if (ds.isList()) {
                    if (!BLUtil.isParameter((String)this.subProcessName)) {
                        throw new BizLogicException("BizLogic_ERR_3742", "SubProcessMetaData.validate()", new Object[]{this.parentProcess.getName(), this.subProcessName, this.parentWS.getName(), this.subProcessAlias});
                    }
                    if (!this.isMappedListDS(this.subProcessName)) {
                        throw new BizLogicException("BizLogic_ERR_3739", "SubProcessMetaData.validate()", new Object[]{this.parentProcess.getName(), this.parentWS.getName(), this.subProcessName, this.subProcessAlias, "List"});
                    }
                } else {
                    throw new BizLogicException("BizLogic_ERR_3741", "SubProcessMetaData.validate()", new Object[]{this.parentProcess.getName(), this.parentWS.getName(), dsName, ds.getType(), this.subProcessAlias});
                }
            }
        }
    }

    private boolean isMappedStringDS(String mapdsName) {
        if (!BLUtil.isParameter((String)mapdsName)) {
            return false;
        }
        String dsName = BLUtil.getParameter((String)mapdsName);
        WFDataslot ds = this.parentProcess.getDataslot(dsName, true);
        return ds != null && ds.isString();
    }

    private boolean isMappedListDS(String mapdsName) {
        if (!BLUtil.isParameter((String)mapdsName)) {
            return false;
        }
        String dsName = BLUtil.getParameter((String)mapdsName);
        WFDataslot ds = this.parentProcess.getDataslot(dsName, true);
        return ds != null && ds.isList();
    }
}

