/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.server.WFWorkstep;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class WFMessagePublisherWS
extends WFWorkstep {
    static final long serialVersionUID = 278269051609396730L;
    static final String DEFAULT_JMS_HANDLER = "com.savvion.sbm.bizlogic.messaging.publisher.BLJMSMessagePublisher";
    private final String channelName;
    private final String messageName;
    private List messageMapping;

    public WFMessagePublisherWS(String name, String handler, String channelName, String messageName) {
        this.typeTag = 111;
        super.setName(name);
        this.setHandler(handler);
        this.channelName = channelName;
        this.messageName = messageName;
    }

    public void setMessageMapping(List messageMapping) {
        this.messageMapping = messageMapping;
    }

    public final void setHandler(String handler) {
        this.hasPerformer = handler != null && !handler.trim().isEmpty() ? handler : DEFAULT_JMS_HANDLER;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getMessageName() {
        return this.messageName;
    }

    public List getMessageMapping() {
        return this.messageMapping;
    }

    public String getHandler() {
        return this.hasPerformer;
    }

    @Override
    public void setAttributes(HashMap hm) {
        Iterator iter = hm.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.equals("PERFORMER")) continue;
            this.setHandler((String)hm.get(key));
            iter.remove();
        }
        super.setAttributes(hm);
    }

    @Override
    public HashMap getAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("CHANNEL_NAME", this.getChannelName());
        attributes.put("MESSAGE_NAME", this.getMessageName());
        attributes.put("MESSAGE_MAPPING", this.messageMapping);
        attributes.putAll(super.getAttributes());
        return attributes;
    }

    public HashMap getSlotMapping() {
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (Object obj : this.messageMapping) {
            HashMap map = (HashMap)obj;
            String dsName = (String)map.get("COPY_FROM");
            String propName = (String)map.get("COPY_TO");
            if (propName == null || dsName == null) continue;
            if (dsName.startsWith("@") && dsName.length() > 1) {
                dsName = dsName.substring(1);
            }
            mapping.put(propName, dsName);
        }
        return mapping;
    }

    @Override
    public boolean validate() {
        super.validate();
        this.validateSubscriptionMapping(this.messageMapping);
        return true;
    }
}

