/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.email.EmailComposer;
import com.savvion.sbm.bizlogic.email.EmailManager;
import com.savvion.sbm.bizlogic.email.EmailUtil;
import com.savvion.sbm.bizlogic.server.JSTools;
import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.WFAtomicInstance;
import com.savvion.sbm.bizlogic.server.WFAtomicWS;
import com.savvion.sbm.bizlogic.server.WFCWorkItem;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFProcessInstance;
import com.savvion.sbm.bizlogic.server.WFVoteWS;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.WFWorkstepInstance;
import com.savvion.sbm.bizlogic.server.dao.AvailableWorkItemDAO;
import com.savvion.sbm.bizlogic.server.dao.BLLockDAO;
import com.savvion.sbm.bizlogic.server.dao.CWorkItemDAO;
import com.savvion.sbm.bizlogic.server.dao.VoteDAO;
import com.savvion.sbm.bizlogic.server.dao.WorkItemDAO;
import com.savvion.sbm.bizlogic.server.dao.WorkItemPerformerDAO;
import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceEBLocal;
import com.savvion.sbm.bizlogic.server.ejb.WorkItemEBLocal;
import com.savvion.sbm.bizlogic.server.ejb.WorkItemEBLocalHome;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceEBLocal;
import com.savvion.sbm.bizlogic.server.svo.DataSlotList;
import com.savvion.sbm.bizlogic.server.svo.SVOFactory;
import com.savvion.sbm.bizlogic.server.svo.VoteCriteria;
import com.savvion.sbm.bizlogic.server.svo.VoteResult;
import com.savvion.sbm.bizlogic.server.svo.WorkItem;
import com.savvion.sbm.bizlogic.server.svo.WorkItemList;
import com.savvion.sbm.bizlogic.util.BLCalendar;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicAppException;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.PerformerUtil;
import com.savvion.sbm.bizlogic.util.ProcessContext;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.bizlogic.util.SessionManager;
import com.savvion.sbm.util.ResultData;
import com.savvion.sbm.util.SBMContext;
import com.savvion.sbm.util.SBMControl;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.callback.ProcessCallback;
import com.tdiinc.common.Emailer.OutGoingMailException;
import com.tdiinc.userManager.User;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.ejb.CreateException;

public class WFWorkItem {
    private static WFWorkItem self;

    private WFWorkItem() {
    }

    public static WFWorkItem self() {
        if (self == null) {
            self = new WFWorkItem();
        }
        return self;
    }

    public void complete(Session session, long wiId) {
        WFProcessContext pCtx = new WFProcessContext(session, wiId, true);
        this.complete(pCtx, wiId);
    }

    public void complete(WFProcessContext pCtx, long wiId) {
        this.complete(pCtx, wiId, pCtx.getSession().getUser());
    }

    public void complete(WFProcessContext pCtx, long wiId, String wiPerformer) {
        boolean sessionUser = true;
        if (!pCtx.getSession().getUser().equals(wiPerformer)) {
            sessionUser = false;
        }
        if (!sessionUser) {
            this.getValidatedSingleUser(wiPerformer, false);
        }
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiId);
        long piid = pCtx.getProcessInstanceID();
        long wsid = wieb.getWorkStepID();
        String wiName = wieb.getName();
        if (wieb.getState() == 32) {
            throw new BizLogicException("BizLogic_ERR_9304", "WFWorkItem.assignWorkItem", new Object[]{wiId, wiPerformer});
        }
        if (wieb.getState() != 28) {
            throw new BizLogicException("BizLogic_ERR_585", "WFWorkItem.complete", new Object[]{wiName, BLControl.consts.wfStates[wieb.getState()]});
        }
        if (SBMControl.util.isUseQueue() && BLControl.util.VALIDATE_ON_QUEUE_WI_COMPLETE && !this.isValidWIPerformer(pCtx, wieb)) {
            return;
        }
        WFAtomicWS atomicWS = (WFAtomicWS)pCtx.getWorkstep(wsid);
        if (((WFAtomicWS)pCtx.getWorkstep(wsid)).isCollaborationEnabled()) {
            int[] states = new int[]{65, 69, 66};
            List<Long> cwiidList = CWorkItemDAO.findByParentWI(wiId, states);
            for (Long cwiid : cwiidList) {
                WFCWorkItem.self().terminate(pCtx, cwiid);
            }
        }
        String user = pCtx.getSession().getUser();
        if (!sessionUser && wiPerformer != null && wiPerformer.trim().length() > 0) {
            user = wiPerformer;
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_4603", "WFWorkItem.complete()", new Object[]{wiPerformer, pCtx.getSession().getUser()});
            }
        }
        String currentPerformer = wieb.getPerformer();
        if (!SBMControl.util.isGuest(user) && !user.equals(currentPerformer)) {
            wieb.setPreviousPerformer(currentPerformer);
            wieb.setPerformer(user);
        }
        if (atomicWS.isCollaborationEnabled()) {
            CWorkItemDAO.removeByParentWI(wiId);
        }
        wieb.setTimeCompleted(new Date().getTime());
        wieb.setState(31);
        if (BLControl.util.isCallback() && ProcessCallback.hasCallback((int)31, (String)pCtx.getProcessTemplateName(), (String)pCtx.getProcess().getAppName())) {
            ProcessContext prcctx = BLUtil.getProcessContext((WFProcessContext)pCtx, (String)wieb.getWorkStepName(), (JSTools)new JSTools(pCtx, wsid));
            ProcessCallback.execute((int)31, (SBMContext)prcctx, (boolean)true);
        }
        BLUtil.fireEvent(this.getEventContext(pCtx, wiId, 31), (int)31);
        WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wsid);
        if (BLControl.util.isTrackWorkItemPerformer() || ws.isTrackWorkItemPerformer()) {
            int loopcounter = pCtx.getWorkstepInstanceEB(wsid).getLoopCounter();
            WorkItemPerformerDAO.insert(piid, wsid, loopcounter, wiId, user);
        }
        this.checkWorkStepCompletion(pCtx, wiId, "complete");
    }

    private Object getValidatedSingleUser(String performer, boolean isEmailIdValid) {
        if (performer == null || performer.trim().length() == 0 || "<NULL>".equals(performer.trim())) {
            throw new BizLogicException("BizLogic_ERR_4526", "WFWorkItem.validateSingleUser", new Object[]{performer});
        }
        if (!BLUtil.isSinglePerformer((String)performer)) {
            throw new BizLogicException("BizLogic_ERR_4533", "WFWorkItem.validateSingleUser", new Object[]{performer});
        }
        User userObj = BLUtil.getUser((String)performer);
        if (userObj != null) {
            return userObj;
        }
        if (isEmailIdValid && BLUtil.isEmailAddress((String)performer)) {
            if (!BLControl.util.isExternalEmailPerformerEnabled()) {
                throw new BizLogicException("BizLogic_ERR_504", "WFWorkItem.getValidatedSingleUser()", new Object[]{performer});
            }
            return null;
        }
        throw new BizLogicException("BizLogic_ERR_504", "WFWorkItem.getValidatedSingleUser()", new Object[]{performer});
    }

    public void skip(WFProcessContext pCtx, long wiId) {
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiId);
        long wsid = wieb.getWorkStepID();
        WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wsid);
        if (28 != wieb.getState()) {
            long piid = pCtx.getProcessInstanceID();
            throw new BizLogicException("BizLogic_ERR_3746", "WFWorkitem.skip", new Object[]{"id=" + wiId + "::name=" + wieb.getName(), ws.getName(), piid, ws.getProcessName()});
        }
        if (ws.isCollaborationEnabled()) {
            CWorkItemDAO.removeByParentWI(wiId);
        }
        wieb.setTimeCompleted(System.currentTimeMillis());
        wieb.setState(48);
        BLUtil.fireEvent(this.getEventContext(pCtx, wiId, 48), (int)48);
        this.checkWorkStepCompletion(pCtx, wiId, "skip");
    }

    private void checkWorkStepCompletion(WFProcessContext pCtx, long wiId, String operation) {
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiId);
        long piid = pCtx.getProcessInstanceID();
        long wsid = wieb.getWorkStepID();
        String wiName = wieb.getName();
        WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wsid);
        try {
            boolean voteComplete;
            if (!ws.getPerformedByAll()) {
                AvailableWorkItemDAO.removeByWorkitemID(wiId);
            }
            wieb.remove();
            int numWIs = 0;
            if (ws.getPerformedByAll()) {
                numWIs = WorkItemDAO.getCountByWorkStepInstance(piid, wsid, false);
            }
            if (numWIs == 0) {
                WFAtomicInstance.self().completeX(pCtx, wsid);
            }
            if (ws.isVoteEnabled() && (voteComplete = this.updateVoteInfo(pCtx, (WFVoteWS)ws, wiId, numWIs)) && numWIs > 0) {
                WFAtomicInstance.self().complete(pCtx, wsid);
            }
        }
        catch (Throwable th) {
            String voteMsg = "";
            if (ws.isVoteEnabled()) {
                voteMsg = "Voting may be completed for piid = " + piid + " wsName = " + ws.getName();
            }
            throw new BizLogicException("BizLogic_ERR_3745", "WFWorkitem.checkWorkStepCompletion", new Object[]{operation, "id=" + wiId + "::name=" + wiName, ws.getName(), piid, ws.getProcessName(), voteMsg}, th);
        }
    }

    public void assignWorkItem(WFProcessContext pCtx, long wiId, String performer) {
        try {
            this.assignWorkItem(pCtx, wiId, performer, false);
        }
        catch (OutGoingMailException outGoingMailException) {
            // empty catch block
        }
    }

    public void assignWorkItem(WFProcessContext pCtx, long wiId, String performer, boolean throwMailException) throws OutGoingMailException {
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiId);
        long wsid = wieb.getWorkStepID();
        performer = WFWorkstepInstance.single().getRealPerformer(pCtx, wsid, performer);
        Object userObj = this.getValidatedSingleUser(performer, true);
        if (wieb.getState() == 28 && wieb.getPerformer().equals(performer)) {
            BLControl.logger.warnKey("BizLogic_ERR_3172", "WFWorkItem.assignWorkItem", new Object[]{wieb.getName(), performer});
            return;
        }
        if (wieb.getState() == 32) {
            throw new BizLogicException("BizLogic_ERR_9302", "WFWorkItem.assignWorkItem", new Object[]{wiId, performer});
        }
        if (wieb.getState() != 27) {
            throw new BizLogicException("BizLogic_ERR_523", "WFWorkItem.assignWorkItem", new Object[]{"id=" + wiId + ";name=" + wieb.getName(), BLControl.consts.wfStates[wieb.getState()]});
        }
        Set excludePerformer = WFAtomicInstance.self().getExcludedPerformerList(pCtx, wsid);
        if (excludePerformer.contains(performer)) {
            throw new BizLogicException("BizLogic_ERR_853", "WFWorkItem.assignWorkItem", new Object[]{performer, pCtx.getWorkStepInstanceName(wsid), pCtx.getProcessTemplateName()});
        }
        String prevPerf = wieb.getPerformer();
        wieb.setPreviousPerformer(prevPerf);
        wieb.setPerformer(performer);
        wieb.setState(28);
        if (BLControl.util.notifyAvailablePerformers) {
            Vector performers = pCtx.getAvailableWorkItemPerformers(wiId);
            for (int i = 0; i < performers.size(); ++i) {
                if (performer.equals(performers.elementAt(i))) continue;
                String emailAddress = PerformerUtil.getUserEmailAddress((String)((String)performers.elementAt(i)));
                Locale recipientLocale = SBMUtil.self().getUserLocale((String)performers.elementAt(i), true);
                EmailComposer.self().sendAvailChangeToAssign(pCtx, wiId, emailAddress, recipientLocale, performer, (String)performers.elementAt(i));
            }
        }
        BLUtil.fireEvent(this.getEventContext(pCtx, wiId, 28), (int)28);
        WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wsid);
        if (ws.getEmailSupport() || userObj == null && BLUtil.isEmailAddress((String)performer)) {
            String emailAddress = PerformerUtil.getUserEmailAddress((String)performer);
            pCtx.overrideEmailSupport(true);
            try {
                EmailComposer.self().sendAssignedTask(pCtx, wiId, emailAddress, null);
            }
            catch (OutGoingMailException ex) {
                if (throwMailException) {
                    throw ex;
                }
                BLControl.logger.errorKey("BizLogic_ERR_3566", "WFWorkItem.assignWorkItem()", (Throwable)ex, new Object[]{emailAddress, pCtx.getProcessInstanceID(), wiId});
            }
            pCtx.overrideEmailSupport(false);
        }
    }

    public void reAssignWorkItem(WFProcessContext pCtx, long wiId, String performer) {
        if (performer == null) {
            throw new BizLogicException("BizLogic_ERR_504", "WFWorkItem.reAssignWorkItem", new Object[]{performer});
        }
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiId);
        if (wieb.getState() == 32) {
            throw new BizLogicException("BizLogic_ERR_9303", "WFWorkItem.reAssignWorkItem", new Object[]{wiId, performer});
        }
        if (wieb.getState() != 28) {
            throw new BizLogicException("BizLogic_ERR_585", "WFWorkItem.reAssignWorkItem", new Object[]{"id=" + wiId + ";name=" + wieb.getName(), BLControl.consts.wfStates[wieb.getState()]});
        }
        String currPerformer = wieb.getPerformer();
        performer = performer.trim();
        boolean isUserCaseSensitive = BLUtil.isUserManagerCaseSensitive();
        if (isUserCaseSensitive && currPerformer.equals(performer) || !isUserCaseSensitive && currPerformer.equalsIgnoreCase(performer)) {
            BLControl.logger.warnKey("BizLogic_ERR_4643", "WFWorkItem.reAssignWorkItem()", new Object[]{wiId, performer, currPerformer, wieb.getWorkStepName(), pCtx.getProcessInstanceID()});
            return;
        }
        long wsid = wieb.getWorkStepID();
        Set excludePerformer = WFAtomicInstance.self().getExcludedPerformerList(pCtx, wsid);
        if (excludePerformer.contains(performer)) {
            throw new BizLogicException("BizLogic_ERR_853", "WFWorkItem.reAssignWorkItem", new Object[]{performer, pCtx.getWorkStepInstanceName(wsid), pCtx.getProcessTemplateName()});
        }
        String realPerformer = WFWorkstepInstance.single().getRealPerformer(pCtx, wsid, performer);
        WFAtomicWS atomicWS = (WFAtomicWS)pCtx.getWorkstep(wsid);
        Object userObj = this.getValidatedSingleUser(realPerformer, atomicWS.getEmailSupport());
        wieb.setPreviousPerformer(wieb.getPerformer());
        wieb.setPerformer(realPerformer);
        wieb.setState(28);
        wieb.setReadTime(0L);
        if (atomicWS.isCollaborationEnabled()) {
            CWorkItemDAO.updateCreator(wiId, realPerformer);
        }
        BLUtil.fireEvent(this.getEventContext(pCtx, wiId, 28), (int)28);
        WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wsid);
        if (ws.getEmailSupport() || BLUtil.self().isSendEmailForTask() || userObj == null && BLUtil.isEmailAddress((String)realPerformer)) {
            String emailAddress = PerformerUtil.getUserEmailAddress((String)realPerformer);
            pCtx.overrideEmailSupport(true);
            try {
                EmailComposer.self().sendAssignedTask(pCtx, wiId, emailAddress, null);
            }
            catch (OutGoingMailException ex) {
                BLControl.logger.errorKey("BizLogic_ERR_3566", "WFWorkItem.reAssignWorkItem()", (Throwable)ex, new Object[]{emailAddress, pCtx.getProcessInstanceID(), wiId});
            }
            pCtx.overrideEmailSupport(false);
        }
    }

    public Vector getAvailablePerformers(WFProcessContext pCtx, long wiId) {
        return AvailableWorkItemDAO.getAvailablePerformers(wiId);
    }

    public boolean isAvailablePerformer(WFProcessContext pCtx, long wiId, String performer) {
        Vector availPerformers = this.getAvailablePerformers(pCtx, wiId);
        if (availPerformers.isEmpty()) {
            return false;
        }
        if (BLUtil.isUserManagerCaseSensitive() && availPerformers.contains(performer)) {
            return true;
        }
        if (!BLUtil.isUserManagerCaseSensitive() && SBMUtil.containsIgnoreCase((List)availPerformers, (String)performer)) {
            return true;
        }
        if (!BLUtil.isUser((String)performer)) {
            return false;
        }
        List availQNames = BLControl.queueManager.getValidQueueFromList((List)availPerformers);
        if (availQNames == null || availQNames.isEmpty()) {
            return false;
        }
        List performerQList = null;
        performerQList = BLControl.queueManager.getQueues(performer);
        if (performerQList == null || performerQList.isEmpty()) {
            return false;
        }
        for (String availQName : availQNames) {
            if (!performerQList.contains(availQName)) continue;
            return true;
        }
        return false;
    }

    public boolean isAssignedPerformer(WFProcessContext pCtx, long wiId, String performer) {
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiId);
        if (wieb.getState() != 28) {
            return false;
        }
        String perf = wieb.getPerformer();
        if (perf == null || performer == null) {
            return false;
        }
        if (!BLUtil.isUserManagerCaseSensitive()) {
            return perf.equalsIgnoreCase(performer);
        }
        return perf.equals(performer);
    }

    public void suspend(Session session, long wiId, String reason) {
        WFProcessContext pCtx = new WFProcessContext(session, wiId, true);
        this.suspend(pCtx, wiId, reason);
    }

    public void suspend(WFProcessContext pCtx, long wiId, String reason) {
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiId);
        int state = wieb.getState();
        if (state == 32) {
            BLControl.logger.warnKey("BizLogic_ERR_1673", new Object[]{wieb.getName(), pCtx.getProcessInstanceName()});
            return;
        }
        if (state == 28 || state == 27) {
            long wsid = wieb.getWorkStepID();
            if (((WFAtomicWS)pCtx.getWorkstep(wsid)).isCollaborationEnabled()) {
                List<Long> cwiidList = CWorkItemDAO.findByParentWI(wiId);
                for (int ix = 0; ix < cwiidList.size(); ++ix) {
                    long cwiid = cwiidList.get(ix);
                    WFCWorkItem.self().suspend(pCtx, cwiid);
                }
            }
            wieb.setPreviousState();
            wieb.setState(32);
            Map<String, Object> eventContext = this.getEventContext(pCtx, wiId, 32);
            if (reason != null && reason.trim().length() > 0) {
                eventContext.put("REASON", reason);
            }
            BLUtil.fireEvent(eventContext, (int)32);
        }
    }

    public void resumeByClient(Session session, long wiId) {
        WFProcessContext pCtx = new WFProcessContext(session, wiId, true);
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiId);
        String wiName = wieb.getName();
        long wsid = wieb.getWorkStepID();
        if (pCtx.getWorkstepInstanceEB(wsid).isSuspended()) {
            throw new BizLogicException("BizLogic_ERR_1667", "WFWorkItem.resumeByClient", new Object[]{wiName, pCtx.getWorkStepInstanceName(wsid)});
        }
        this.resume(pCtx, wiId);
    }

    public void resume(WFProcessContext pCtx, long wiId) {
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiId);
        long wsid = wieb.getWorkStepID();
        if (wieb.getState() == 32) {
            if (((WFAtomicWS)pCtx.getWorkstep(wsid)).isCollaborationEnabled()) {
                List<Long> cwiidList = CWorkItemDAO.findByParentWI(wiId);
                for (int ix = 0; ix < cwiidList.size(); ++ix) {
                    long cwiid = cwiidList.get(ix);
                    WFCWorkItem.self().resume(pCtx, cwiid);
                }
            }
            int previousState = wieb.getPreviousState();
            wieb.setPreviousState();
            wieb.setState(previousState);
            BLUtil.fireEvent(this.getEventContext(pCtx, wiId, previousState), (int)previousState);
        } else {
            BLControl.logger.warnKey("BizLogic_ERR_1674", new Object[]{wieb.getName(), pCtx.getProcessInstanceName()});
        }
    }

    public void resumeByWorkStepID(WFProcessContext pCtx, long wsid) {
        Vector v = WorkItemDAO.getIDByWorkStepInstance(pCtx.getProcessInstanceID(), wsid, 32);
        for (int ix = v.size() - 1; ix >= 0; --ix) {
            long wiid = (Long)v.elementAt(ix);
            WFWorkItem.self().resume(pCtx, wiid);
        }
    }

    protected Map<String, Object> getEventContext(WFProcessContext pCtx, long wiid, int eventType) {
        Map eventContext = SBMUtil.getNewEventContext();
        if (!WFProcessInstance.checkAuditRequired(pCtx, eventType)) {
            eventContext.put("AUDIT_DISABLED", true);
            return eventContext;
        }
        WFProcess pt = pCtx.getProcess();
        ProcessInstanceEBLocal pieb = pCtx.getProcessInstanceEB();
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiid);
        long wsid = wieb.getWorkStepID();
        WFWorkstep ws = pCtx.getWorkstep(wsid);
        WorkStepInstanceEBLocal wseb = this.getWorkStepInstanceEBLocal(pCtx, wsid);
        this.validate(pieb, ws, wseb);
        eventContext.put("RPID", pieb.getRootInstanceID());
        eventContext.put("RPTID", pieb.getRootTemplateID());
        eventContext.put("PROCESSTEMPLATENAME", pt.getName());
        eventContext.put("PROCESSTEMPLATEID", pt.getID());
        eventContext.put("PROCESSINSTANCENAME", pieb.getName());
        eventContext.put("PROCESSINSTANCEID", pieb.getId());
        eventContext.put("WORKSTEPNAME", ws.getName());
        eventContext.put("WORKSTEPID", wsid);
        eventContext.put("WORKITEMNAME", wieb.getName());
        eventContext.put("WORKITEMID", wieb.getId());
        eventContext.put("LOOPCOUNTER", String.valueOf(wseb.getLoopCounter()));
        this.addPriority(eventContext, wieb);
        eventContext.put("PERFORMER", wieb.getPerformer());
        this.addSession(pCtx, eventContext);
        this.addPrevStates(eventContext, wieb);
        this.addDuration(pCtx, eventContext, wieb, wsid);
        this.addReadTime(eventContext, wieb);
        this.addNames(eventContext, pt, wieb);
        this.addResponse(eventContext, wieb);
        if (pCtx.isDebug()) {
            eventContext.put("PI_DEBUG", Boolean.TRUE);
        }
        if (pCtx.hasResources()) {
            this.addResourcesToContext(pCtx, eventContext);
        }
        return eventContext;
    }

    private WorkStepInstanceEBLocal getWorkStepInstanceEBLocal(WFProcessContext pCtx, long wsid) {
        return pCtx.getWorkstepInstanceEB(wsid, true);
    }

    private void validate(ProcessInstanceEBLocal pieb, WFWorkstep ws, WorkStepInstanceEBLocal wseb) {
        if (wseb == null) {
            throw new BizLogicException("BizLogic_ERR_6028", "WFWorkItem::getEventContext", new Object[]{ws.getName(), pieb.getId()});
        }
    }

    private void addPriority(Map<String, Object> eventContext, WorkItemEBLocal wieb) {
        String priority = SBMControl.util.getStringPriority(wieb.getPriority());
        if (priority != null) {
            eventContext.put("PRIORITY", priority);
        }
    }

    private void addSession(WFProcessContext pCtx, Map<String, Object> eventContext) {
        if (pCtx.getSession() != null) {
            eventContext.put("SESSION_USER", pCtx.getSession().getUser());
        }
    }

    private void addPrevStates(Map<String, Object> eventContext, WorkItemEBLocal wieb) {
        String previousPerformer;
        if (!(wieb.getState() != 28 && wieb.getState() != 31 || wieb.getPreviousState() != 28 && wieb.getPreviousState() != 27 || (previousPerformer = wieb.getPreviousPerformer()) == null)) {
            eventContext.put("PREV_PERFORMER", wieb.getPreviousPerformer());
        }
        eventContext.put("PREVIOUSSTATUS", BLControl.consts.wfStates[wieb.getPreviousState()]);
    }

    private void addDuration(WFProcessContext pCtx, Map<String, Object> eventContext, WorkItemEBLocal wieb, long wsid) {
        long timeStarted = wieb.getTimeStarted();
        eventContext.put("STARTTIME", String.valueOf(timeStarted));
        long timeCompleted = this.getTimeCompleted(wieb);
        eventContext.put("ENDTIME", String.valueOf(timeCompleted));
        eventContext.put("DUEDATE", String.valueOf(wieb.getDueDate()));
        long duration = WFWorkstepInstance.single().getDuration(pCtx, wsid);
        eventContext.put("ESTIMATEDDURATION", String.valueOf(duration));
        if (wieb.getState() == 31 || wieb.getState() == 29 || wieb.getState() == 48) {
            duration = this.getDuration(pCtx, wieb.getPerformer(), timeStarted, timeCompleted);
            eventContext.put("DURATION", String.valueOf(duration));
        }
    }

    private long getTimeCompleted(WorkItemEBLocal wieb) {
        return wieb.getState() == 31 ? wieb.getTimeCompleted() : System.currentTimeMillis();
    }

    private void addReadTime(Map<String, Object> eventContext, WorkItemEBLocal wieb) {
        if (wieb.getReadTime() > 0L) {
            eventContext.put("READTIME", wieb.getReadTime());
        } else {
            eventContext.put("READTIME", "<NULL>");
        }
    }

    private void addNames(Map<String, Object> eventContext, WFProcess pt, WorkItemEBLocal wieb) {
        if (BLControl.util.isPrintEvent()) {
            eventContext.put("NAME", wieb.getName());
        }
        eventContext.put("APP_NAME", pt.getAppName());
    }

    private void addResponse(Map<String, Object> eventContext, WorkItemEBLocal wieb) {
        String response = wieb.getResponse();
        if (response != null) {
            eventContext.put("RESPONSE", response);
        } else {
            eventContext.put("RESPONSE", "<NULL>");
        }
    }

    public void addResourcesToContext(WFProcessContext pCtx, Map<String, Object> eventContext) {
        if (!pCtx.hasResources()) {
            return;
        }
        Hashtable resources = pCtx.getResources();
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : resources.entrySet()) {
            String name = (String)entry2.getKey();
            eventContext.put("RES_" + name, entry2.getValue());
        }
        pCtx.setResources(null);
    }

    public void remove(Session session, long wiID) {
        WFProcessContext pCtx = new WFProcessContext(session, wiID, true);
        this.remove(pCtx, wiID);
    }

    public void remove(WFProcessContext pCtx, long wiID) {
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiID);
        long piID = pCtx.getProcessInstanceID();
        long wsID = wieb.getWorkStepID();
        if (wieb.getState() == 32) {
            throw new BizLogicException("BizLogic_ERR_813", "WFWorkItem.remove", new Object[]{"id=" + wiID + ";name=" + wieb.getName()});
        }
        try {
            WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wsID);
            if (!ws.getPerformedByAll()) {
                AvailableWorkItemDAO.removeByWorkitemID(wiID);
            }
            if (ws.isCollaborationEnabled()) {
                CWorkItemDAO.removeByParentWI(wiID);
            }
            Map<String, Object> eventContext = WFWorkItem.self().getEventContext(pCtx, wiID, 44);
            wieb.remove();
            BLUtil.fireEvent(eventContext, (int)44);
            int numWIs = WorkItemDAO.getCountByWorkStepInstance(piID, wsID, false);
            if (numWIs == 0) {
                WFAtomicInstance.self().completeX(pCtx, wsID);
            }
        }
        catch (Exception e) {
            throw new BizLogicException("BizLogic_ERR_2539", "WFWorkItem.remove", new Object[]{"id=" + wiID + ";name=" + wieb.getName()}, (Throwable)e);
        }
    }

    public void add(WFProcessContext pCtx, long wsID, String performer, String suffix, int priority, long duedate) {
        long wiID;
        long ptID = pCtx.getProcessTemplateID();
        long piID = pCtx.getProcessInstanceID();
        String piName = pCtx.getProcessInstanceName();
        String wsName = pCtx.getWorkstep(wsID).getName();
        WorkStepInstanceEBLocal wsiEB = pCtx.getWorkstepInstanceEB(wsID);
        if (wsiEB.getState() != 18) {
            throw new BizLogicException("BizLogic_ERR_2534", "WFWorkItem.add", new Object[]{wsName});
        }
        if (BLUtil.getUser((String)performer) == null) {
            throw new BizLogicException("BizLogic_ERR_2537", "WFWorkItem.add", new Object[]{performer});
        }
        String wiName = suffix == null || suffix.length() == 0 ? piName + "::" + wsName : piName + "::" + wsName + "::" + suffix;
        if (wiName.length() > BLControl.util.MAX_WINAME_SIZE) {
            throw new BizLogicException("BizLogic_ERR_662", "WFWorkitem:add", new Object[]{wiName, piName, wsName, String.valueOf(BLControl.util.MAX_WINAME_SIZE)});
        }
        if (performer != null && performer.length() > BLControl.util.MAX_WIPERFORMER_SIZE) {
            throw new BizLogicException("BizLogic_ERR_663", "WFWorkitem:add", new Object[]{performer, wiName, piName, wsName, String.valueOf(BLControl.util.MAX_WIPERFORMER_SIZE)});
        }
        try {
            wiID = BLControl.util.wiSeq.getNextNumber();
        }
        catch (SQLException sqle) {
            throw new BizLogicException("BizLogic_ERR_1602", "WFWorkItem.add", new Object[]{wiName}, (Throwable)sqle);
        }
        WorkItemEBLocal wi = null;
        int status = 28;
        try {
            HashMap<String, Object> attr = new HashMap<String, Object>();
            attr.put("PROCESSTEMPLATEID", ptID);
            attr.put("PROCESSINSTANCEID", piID);
            attr.put("WORKSTEPID", wsID);
            attr.put("WORKSTEPNAME", wsName);
            attr.put("WORKITEMID", wiID);
            attr.put("WORKITEMNAME", wiName);
            attr.put("PERFORMER", performer);
            attr.put("STATUS", status);
            attr.put("STARTTIME", new Date().getTime());
            attr.put("DUEDATE", duedate);
            attr.put("PRIORITY", priority);
            WorkItemEBLocalHome ebh = BLUtil.self().getWorkItemEBHome();
            wi = ebh.create(attr);
            pCtx.cacheIt(wiID, wi);
        }
        catch (CreateException ce) {
            throw new BizLogicException("BizLogic_ERR_1620", "WFWorkItem.add", new Object[]{wsName}, (Throwable)ce);
        }
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debug((Object)"Created wi:");
            BLControl.logger.debug((Object)("\t winame=" + wiName));
            BLControl.logger.debug((Object)("\t wiperf=" + performer));
        }
        BLUtil.fireEvent(WFWorkItem.self().getEventContext(pCtx, wiID, 25), (int)25);
        BLUtil.fireEvent(WFWorkItem.self().getEventContext(pCtx, wiID, status), (int)status);
    }

    public void makeAvailable(WFProcessContext pCtx, long wiid, Vector performers, Vector origPerformers) {
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiid);
        if (wieb.getState() == 32) {
            throw new BizLogicException("BizLogic_ERR_4632", "WFWorkItem.makeAvailable", new Object[]{pCtx.getProcessInstanceName(), "workitem", wiid});
        }
        if (performers != null) {
            AvailableWorkItemDAO.remove(wiid);
            long ptid = pCtx.getProcessTemplateID();
            long piid = pCtx.getProcessInstanceID();
            AvailableWorkItemDAO.store(wiid, ptid, piid, performers.toArray(new String[0]));
            wieb.setPreviousPerformer(wieb.getPerformer());
            String wiperf = BLUtil.toStringListPerformer((List)origPerformers);
            if (wiperf.length() > BLControl.util.MAX_WIPERFORMER_SIZE) {
                BLControl.logger.warnKey("BizLogic_ERR_870", new Object[]{wiperf, wieb.getName(), pCtx.getProcessInstanceName(), String.valueOf(BLControl.util.MAX_WIPERFORMER_SIZE)});
                wiperf = wiperf.substring(0, BLControl.util.MAX_WIPERFORMER_SIZE);
            }
            wieb.setPerformer(wiperf);
        } else {
            wieb.setPreviousPerformer(wieb.getPerformer());
            wieb.setPerformer(this.getTruncatedAvailPerformers(wiid));
        }
        if (wieb.getState() == 28) {
            wieb.setState(27);
        }
        wieb.setReadTime(0L);
        long wsid = wieb.getWorkStepID();
        if (((WFAtomicWS)pCtx.getWorkstep(wsid)).isCollaborationEnabled()) {
            CWorkItemDAO.removeByParentWI(wiid);
            BLControl.logger.warnKey("BizLogic_ERR_3626", "WFWorkItem.makeAvailable", new Object[]{wieb.getName(), pCtx.getProcessInstanceName()});
        }
        BLUtil.fireEvent(WFWorkItem.self().getEventContext(pCtx, wiid, wieb.getState()), (int)wieb.getState());
    }

    public void setDueDate(WFProcessContext pCtx, long wiid, long date) {
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiid);
        long timeStarted = wieb.getTimeStarted();
        wieb.setDueDate(BLControl.util.adjustDueDate(date, timeStarted));
        BLUtil.fireEvent(this.getEventContext(pCtx, wiid, 46), (int)46);
    }

    public void setResponse(WFProcessContext pCtx, long wiid, String response) {
        if (response != null && response.length() > BLControl.util.MAX_RESPONSE_SIZE) {
            throw new BizLogicException("BizLogic_ERR_3847", "WFWorkItem.setResponse", new Object[]{wiid, pCtx.getProcessInstanceID(), String.valueOf(BLControl.util.MAX_RESPONSE_SIZE)});
        }
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiid);
        wieb.setResponse(response);
        BLUtil.fireEvent(this.getEventContext(pCtx, wiid, 49), (int)49);
    }

    public void setPriority(WFProcessContext pCtx, long wiid, int priority) {
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiid);
        if (wieb.getPriority() != priority) {
            wieb.setPriority(priority);
            BLUtil.fireEvent(this.getEventContext(pCtx, wiid, 47), (int)47);
        }
    }

    public void setPriority(WFProcessContext pCtx, long wiid, String priority) {
        int pri;
        if (priority != null && (pri = SBMControl.util.getIntegerPriority(priority)) != -1) {
            this.setPriority(pCtx, wiid, pri);
            return;
        }
        throw new BizLogicException("BizLogic_ERR_1647", "WFWorkItem.setPriority", new Object[]{SBMControl.util.strPriority});
    }

    public void setAttributes(WFProcessContext pCtx, long wiid, HashMap attributes) {
        Map.Entry entry2 = null;
        String key = null;
        Object value = null;
        for (Map.Entry entry2 : attributes.entrySet()) {
            key = (String)entry2.getKey();
            value = entry2.getValue();
            if (key.equalsIgnoreCase("PRIORITY")) {
                this.setPriority(pCtx, wiid, value);
                continue;
            }
            if (key.equalsIgnoreCase("DUEDATE")) {
                this.setDueDate(pCtx, wiid, (Long)value);
                continue;
            }
            if (key.equalsIgnoreCase("RESPONSE")) {
                this.setResponse(pCtx, wiid, value);
                continue;
            }
            throw new BizLogicException("BizLogic_ERR_1507", "WFWorkItem.setAttributes", new Object[]{"WorkItem", pCtx.getProcessInstanceID(), key});
        }
    }

    private boolean isValidWIPerformer(WFProcessContext pCtx, WorkItemEBLocal wieb) {
        long wsid = wieb.getWorkStepID();
        WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wsid);
        if (ws.getPerformedByAll()) {
            return true;
        }
        String wiPerformer = null;
        wiPerformer = SBMControl.util.isGuest(pCtx.getSession().getUser()) ? wieb.getPerformer() : pCtx.getSession().getUser();
        ArrayList queues = (ArrayList)BLControl.queueManager.getQueues(wiPerformer);
        Vector xperfs = AvailableWorkItemDAO.getPerformerList(wieb.getId());
        for (int i = 0; i < xperfs.size(); ++i) {
            String perf = (String)xperfs.elementAt(i);
            if (!perf.equals(wiPerformer) && !queues.contains(perf)) continue;
            return true;
        }
        BLControl.logger.warnKey("BizLogic_ERR_850", new Object[]{wieb.getName(), wiPerformer});
        try {
            pCtx.makeAvailable(wsid, xperfs);
        }
        catch (OutGoingMailException ex) {
            BLControl.logger.errorKey("BizLogic_ERR_3568", "WFWorkItem.isValidWIPerformer()", (Throwable)ex, new Object[]{pCtx.getProcessInstanceID(), wieb.getId()});
        }
        return false;
    }

    public boolean updateVoteInfo(WFProcessContext pCtx, WFVoteWS voteWS, long wiid, int numWIs) {
        String performer;
        List voteChoices;
        boolean isVotingCompleted = false;
        long wsid = voteWS.getID();
        VoteCriteria voteCriteria = voteWS.getVoteCriteria();
        HashMap voteDetails = pCtx.getVoteDetails();
        Object voteDSValue = voteDetails.get("VOTEDSVALUE");
        long piid = pCtx.getProcessInstanceID();
        int loopCounter = pCtx.getWorkstepInstanceEB(wsid).getLoopCounter();
        HashMap voteInfo = (HashMap)VoteDAO.getVoteInfo(piid, wsid, loopCounter);
        this.checkVoteInfo(pCtx, wsid, wiid, voteInfo);
        int totalCount = (Integer)voteInfo.get("TOTAL_COUNT");
        int expCount = (Integer)voteInfo.get("EXPECTED_COUNT");
        int validCount = (Integer)voteInfo.get("VALID_COUNT");
        HashMap votes = (HashMap)voteInfo.get("VOTES");
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debugKey("BizLogic_ERR_6012", new Object[]{piid, wsid, loopCounter});
            BLControl.logger.debug((Object)("totalCount = " + totalCount));
            BLControl.logger.debug((Object)("expectedCount = " + expCount));
            BLControl.logger.debug((Object)("validCount = " + validCount));
            BLControl.logger.debug((Object)("votes = " + votes));
        }
        if ((voteChoices = this.getVoteChoices(voteCriteria, votes)) != null) {
            if (voteChoices.contains(voteDSValue)) {
                if (BLControl.util.DEBUG_ENGINE) {
                    BLControl.logger.debugKey("BizLogic_ERR_6013", new Object[]{voteDSValue, piid, wsid, loopCounter});
                }
                ++validCount;
            }
        } else {
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_6014", new Object[]{piid, wsid, loopCounter});
            }
            ++validCount;
        }
        if (votes.containsKey(performer = pCtx.getSession().getUser())) {
            votes.put(performer + "(" + wiid + ")", voteDSValue);
        } else {
            votes.put(performer, voteDSValue);
        }
        if (validCount >= expCount || numWIs == 0) {
            isVotingCompleted = true;
            voteInfo.put("VOTECOMPLETED", isVotingCompleted);
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_6016", new Object[]{piid, wsid, loopCounter, totalCount, expCount, validCount});
            }
            if (voteChoices != null) {
                voteInfo.put("VALID_COUNT", validCount);
                voteInfo.put("VOTES", votes);
                HashMap voteAttrs = this.createVoteResultAttrs(piid, wsid, voteCriteria, voteInfo);
                this.updateVotingDataslots(pCtx, voteWS, voteAttrs);
            }
        }
        VoteDAO.updateVoteInfo(piid, wsid, loopCounter, validCount, votes);
        voteDetails.put("VOTECOMPLETED", isVotingCompleted);
        return isVotingCompleted;
    }

    private List getVoteChoices(VoteCriteria voteCriteria, Map votes) {
        List voteChoices = null;
        voteChoices = voteCriteria.isMappedChoices() ? (List)votes.get("@@CHOICES@@") : voteCriteria.getChoices();
        return voteChoices;
    }

    private HashMap createVoteResultAttrs(long piid, long wsid, VoteCriteria voteCriteria, Map voteInfo) {
        HashMap<String, Object> voteAttrs = new HashMap<String, Object>(5);
        voteAttrs.put("PROCESSINSTANCEID", piid);
        voteAttrs.put("WORKSTEPID", wsid);
        voteAttrs.put("VOTECRITERIA", voteCriteria);
        voteAttrs.put("VOTEDETAILS", voteInfo);
        return voteAttrs;
    }

    private void updateVotingDataslots(WFProcessContext pCtx, WFVoteWS voteWS, HashMap voteAttrs) {
        String voteDS = voteWS.getMajorityDSName();
        String voteResultDS = voteWS.getVoteResultDSName();
        VoteResult vr = SVOFactory.getVoteResult(voteAttrs);
        HashMap<String, Object> dsValues = new HashMap<String, Object>(3);
        if (voteDS != null) {
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_6026", new Object[]{pCtx.getProcessInstanceID(), voteWS.getID(), vr.getMajorityChoice()});
            }
            dsValues.put(voteDS, vr.getMajorityChoice());
        }
        if (voteResultDS != null) {
            if (voteWS.isMapVoteResultDS()) {
                dsValues.put(voteResultDS, voteAttrs);
            } else {
                dsValues.put(voteResultDS, vr);
            }
        }
        pCtx.updateSlotValue(dsValues);
    }

    private void checkVoteInfo(WFProcessContext pCtx, long wsid, long wiid, Map voteInfo) {
        if (voteInfo == null || voteInfo.isEmpty() || voteInfo.containsKey("VOTECOMPLETED")) {
            if (pCtx.isWorkstepCompleted(wsid)) {
                throw new BizLogicException("BizLogic_ERR_6024", "WFWorkItem.updateVoteInfo", new Object[]{pCtx.getProcessInstanceID(), wsid, wiid});
            }
            throw new BizLogicException("BizLogic_ERR_6025", "WFWorkItem.updateVoteInfo", new Object[]{pCtx.getProcessInstanceID(), wsid, wiid});
        }
    }

    public void terminate(WFProcessContext pCtx, long wiId) {
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiId);
        pCtx.getProcessInstanceID();
        long wsid = wieb.getWorkStepID();
        wieb.getName();
        if (((WFAtomicWS)pCtx.getWorkstep(wsid)).isCollaborationEnabled()) {
            CWorkItemDAO.removeByParentWI(wiId);
        }
        wieb.setTimeCompleted(System.currentTimeMillis());
        wieb.setState(29);
        BLUtil.fireEvent(this.getEventContext(pCtx, wiId, 29), (int)29);
    }

    public synchronized WorkItemList getNextAvailableWorkItems(Session session, String user, HashMap filter) {
        SessionManager.validate((Session)session, (String)"getNextAvailableWorkItems(session,user,filter)");
        return SVOFactory.getNextAvailableWorkItemList(session, user, filter);
    }

    public synchronized WorkItem getNextAvailableWorkItem(Session session, String user) {
        SessionManager.validate((Session)session, (String)"getNextAvailableWorkItems(session,user)");
        return SVOFactory.getNextAvailableWorkItem(session, user);
    }

    public WorkItemList getWorkItemList(Session session, long piid, String wsName) {
        if (wsName == null || wsName.trim().isEmpty()) {
            throw new BizLogicException("Bizlogic_ERR_3651", "WFWorkItem.getWorkItemList", new Object[]{piid});
        }
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        long ptid = pCtx.getProcessTemplateID();
        WFProcess pt = ProcessControl.getProcessTemplate(ptid);
        long wsid = pt.getWorkstep(wsName).getID();
        return SVOFactory.getWorkItemList(session, piid, wsid);
    }

    public boolean sendAssignedTask(Session session, long wiid) {
        boolean isWorkitemId = true;
        WFProcessContext pCtx = new WFProcessContext(session, wiid, isWorkitemId);
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiid);
        String performer = wieb.getPerformer();
        String emailAddress = PerformerUtil.getUserEmailAddress((String)performer);
        if (null != emailAddress && emailAddress.trim().length() > 0) {
            return EmailManager.sendAssignedTask(pCtx, wiid, emailAddress, null);
        }
        throw new BizLogicException("Bizlogic_ERR_3802", "WFWorkItem.sendAssignedTask", new Object[]{performer, String.valueOf(wiid)});
    }

    public long getDuration(WFProcessContext pCtx, String performer, long timeStarted, long timeCompleted) {
        long duration = 0L;
        if (BLControl.util.useCalendar() && BLControl.util.useBizDuration()) {
            User user = pCtx.getUser(performer);
            String calName = null;
            if (user != null) {
                calName = user.getAttribute("calendarname");
            }
            duration = BLCalendar.self().getDuration(calName, timeStarted, timeCompleted);
        } else {
            duration = timeCompleted - timeStarted;
        }
        return duration / 1000L;
    }

    public final void reAssignWorkItem(Session session, long wiid, String performer, boolean multiTransaction) {
        if (!multiTransaction) {
            WFProcessContext pCtx = new WFProcessContext(session, wiid, true);
            this.reAssignWorkItem(pCtx, wiid, performer);
        } else {
            try {
                BLUtil.getServiceLocal().reAssignWorkItemX(session, wiid, performer);
            }
            catch (BizLogicAppException ex) {
                throw new BizLogicException(ex.getMessage(), ex.getCause());
            }
        }
    }

    public WorkItemList reAssignTask(Session session, List<Long> wiids, String performer, boolean isMultiTrans) {
        if (wiids == null || wiids.isEmpty()) {
            throw new BizLogicException("Bizlogic_ERR_3806", "WFWorkItem.reAssignTask");
        }
        if (performer == null || performer.trim().length() == 0) {
            throw new BizLogicException("BizLogic_ERR_504", "WFWorkItem.reAssignTask", new Object[]{performer});
        }
        Vector<HashMap> attrsList = new Vector<HashMap>();
        HashMap attrs = null;
        for (Long wiId : wiids) {
            WorkItem wi = null;
            if (!isMultiTrans) {
                WFProcessContext pCtx = new WFProcessContext(session, (long)wiId, true);
                this.reAssignWorkItem(pCtx, wiId, performer);
                wi = SVOFactory.getWorkItem(session, wiId);
            } else {
                wi = BLUtil.getServiceLocal().reAssignTask(session, wiId, performer);
            }
            attrs = wi.getAttributes();
            attrsList.add(attrs);
        }
        return SVOFactory.getWorkItemList(session, attrsList);
    }

    public ResultData<List<Long>> reAssign(Session session, List wiids, String performer, boolean isMultiTrans) {
        if (wiids == null || wiids.isEmpty()) {
            throw new BizLogicException("Bizlogic_ERR_3806", "WFWorkItem.reAssign");
        }
        Long[] ids = new Long[wiids.size()];
        ids = wiids.toArray(ids);
        ResultData result = new ResultData();
        ArrayList<Long> validIdList = new ArrayList<Long>();
        for (int idx = 0; idx < ids.length; ++idx) {
            long wiid = ids[idx];
            try {
                this.reAssignWorkItem(session, wiid, performer, isMultiTrans);
                validIdList.add(wiid);
                continue;
            }
            catch (Throwable th) {
                if (isMultiTrans) {
                    BizLogicException cause = th instanceof BizLogicException ? (BizLogicException)th : new BizLogicException("BizLogic_ERR_4829", "wfwi.reAssign()", new Object[]{wiid, performer}, th);
                    result.addGracefulMessage(cause.getGracefulMessage());
                    result.addFailureToTrace("Error occured reassigning WorkItem", (Throwable)cause);
                    continue;
                }
                throw new BizLogicException("BizLogic_ERR_4672", "WFWorkItem.reAssign(Sess,List,String,bool)", new Object[]{"WorkItem reassign", "workItem", "WIID = " + wiid + " Perfomer = " + performer}, th);
            }
        }
        result.setReturnValue(validIdList);
        return result;
    }

    public ResultData<List<Long>> reAssign(Session session, Hashtable wiids, boolean isMultiTrans) {
        if (wiids == null || wiids.isEmpty()) {
            throw new BizLogicException("Bizlogic_ERR_3805", "WFWorkitem.reAssign");
        }
        ResultData result = new ResultData();
        ArrayList<Long> validIdList = new ArrayList<Long>();
        for (Map.Entry entry : wiids.entrySet()) {
            long wiid = (Long)entry.getKey();
            String performer = (String)entry.getValue();
            try {
                this.reAssignWorkItem(session, wiid, performer, isMultiTrans);
                validIdList.add(wiid);
            }
            catch (Throwable th) {
                if (isMultiTrans) {
                    BizLogicException cause = th instanceof BizLogicException ? (BizLogicException)th : new BizLogicException("BizLogic_ERR_4829", "wfwi.reAssign()", new Object[]{wiid, performer}, th);
                    result.addGracefulMessage(cause.getGracefulMessage());
                    result.addFailureToTrace("Error occured reassigning WorkItem", (Throwable)cause);
                    continue;
                }
                throw new BizLogicException("BizLogic_ERR_4672", "WFWorkItem.reAssign(Sess,Hashtable,bool)", new Object[]{"WorkItem reassign", "workItem", "WIID = " + wiid + " Perfomer = " + performer}, th);
            }
        }
        result.setReturnValue(validIdList);
        return result;
    }

    public void reAssign(Session session, String fromPerformer, String toPerformer, boolean isMultiTrans) {
        if (fromPerformer == null || fromPerformer.trim().length() == 0) {
            throw new BizLogicException("Bizlogic_ERR_3807", "WFWorkitem.reAssign");
        }
        if (toPerformer == null || toPerformer.trim().length() == 0) {
            throw new BizLogicException("Bizlogic_ERR_3808", "WFWorkitem.reAssign");
        }
        boolean isUserCaseSensitive = BLUtil.isUserManagerCaseSensitive();
        toPerformer = toPerformer.trim();
        fromPerformer = fromPerformer.trim();
        if (isUserCaseSensitive && toPerformer.equals(fromPerformer) || !isUserCaseSensitive && toPerformer.equalsIgnoreCase(fromPerformer)) {
            throw new BizLogicException("Bizlogic_ERR_3809", "WFWorkitem.reAssign");
        }
        WorkItemList workItemList = SVOFactory.getWorkItemList(session, null, null, new int[]{28}, fromPerformer);
        List wiids = workItemList.getList();
        if (null == wiids || wiids.isEmpty()) {
            BLControl.logger.warnKey("Bizlogic_ERR_3810", "WFWorkitem.reAssign", new Object[]{fromPerformer});
            return;
        }
        for (WorkItem wi : wiids) {
            long wiid = wi.getID();
            this.reAssignWorkItem(session, wiid, toPerformer, isMultiTrans);
        }
    }

    public void markRead(Session session, long wiid, long readTime) {
        WFProcessContext pCtx = new WFProcessContext(session, wiid, true);
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiid);
        if (wieb.getReadTime() > 0L) {
            throw new BizLogicException("BizLogic_ERR_4513", "WFWorkItem.markRead()", new Object[]{wieb.getName(), new Date(wieb.getReadTime())});
        }
        wieb.setReadTime(readTime);
        BLUtil.fireEvent(this.getEventContext(pCtx, wiid, 50), (int)50);
    }

    public static Map getEmailTemplateInstance(Session session, long wiid) {
        WFProcessContext pCtx = new WFProcessContext(session, wiid, true);
        String performer = pCtx.getWorkItemEB(wiid).getPerformer();
        String performerEmail = PerformerUtil.getUserEmailAddress((String)performer);
        if (performerEmail == null) {
            performerEmail = PerformerUtil.getUserEmailAddress((String)session.getUser());
        }
        if (performerEmail == null) {
            performerEmail = EmailUtil.self().getFromEmailId();
        }
        return EmailManager.prepareEmailData(pCtx, wiid, performerEmail);
    }

    public ResultData<List<Long>> makeAvailable(Session session, List<Long> wiids, List<String> performers, boolean isMultiTrans) {
        if (wiids == null || wiids.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4613", "WFWorkItem.makeAvailable()");
        }
        Vector<String> vperformers = null;
        ResultData result = new ResultData();
        ArrayList<Long> validIdList = new ArrayList<Long>();
        if (performers != null) {
            vperformers = new Vector<String>(performers);
        }
        if (isMultiTrans) {
            for (Long wiid : wiids) {
                try {
                    BLUtil.getServiceLocal().makeAvailable(session, wiid, vperformers);
                    validIdList.add(wiid);
                }
                catch (Throwable th) {
                    BizLogicException ble = new BizLogicException("BizLogic_ERR_4831", "wfwi.makeAvailable()", new Object[]{wiid});
                    result.addFailureToTrace("Error occured making WorkItem available", (Throwable)ble);
                }
            }
        } else {
            for (Long wiid : wiids) {
                this.makeAvailable(session, wiid, vperformers);
            }
        }
        result.setReturnValue(validIdList);
        return result;
    }

    public void makeAvailable(Session session, long wiid, Vector<String> performers) {
        WorkItemEBLocal wiEB = BLUtil.self().getWorkItemEB(wiid);
        long piid = wiEB.getProcessInstanceID();
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        long wsid = wiEB.getWorkStepID();
        pCtx.makeAvailable(wsid, performers);
    }

    public ResultData<List<Long>> assign(Session session, Map<Long, String> wiids, boolean isMultiTrans) {
        if (wiids == null || wiids.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4636", "WFWorkItem.assign()");
        }
        Set<Map.Entry<Long, String>> entrySet = wiids.entrySet();
        ResultData result = new ResultData();
        ArrayList<Long> validIdList = new ArrayList<Long>();
        for (Map.Entry<Long, String> entry : entrySet) {
            if (isMultiTrans) {
                try {
                    BLUtil.getServiceLocal().assignWorkItem(session, entry.getKey(), entry.getValue());
                    validIdList.add(entry.getKey());
                }
                catch (Throwable th) {
                    BizLogicException cause = th.getCause() != null && th.getCause() instanceof BizLogicException ? (BizLogicException)th.getCause() : new BizLogicException("BizLogic_ERR_4830", "wfwi.assign()", new Object[]{entry.getKey(), entry.getValue()});
                    result.addGracefulMessage(cause.getGracefulMessage());
                    result.addFailureToTrace("Error occured assigning WorkItem", (Throwable)cause);
                }
                continue;
            }
            this.assign(session, entry.getKey(), entry.getValue());
        }
        result.setReturnValue(validIdList);
        return result;
    }

    public ResultData<List<Long>> assign(Session session, List<Long> wiids, String performer, boolean isMultiTrans) {
        if (wiids == null || wiids.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4613", "WFWorkItem.assign()");
        }
        ResultData result = new ResultData();
        ArrayList<Long> validIdList = new ArrayList<Long>();
        if (isMultiTrans) {
            for (Long wiid : wiids) {
                try {
                    BLUtil.getServiceLocal().assignWorkItem(session, wiid, performer);
                    validIdList.add(wiid);
                }
                catch (Throwable th) {
                    BizLogicException cause = th.getCause() != null && th.getCause() instanceof BizLogicException ? (BizLogicException)th.getCause() : new BizLogicException("BizLogic_ERR_4830", "wfwi.assign()", new Object[]{wiid, performer});
                    result.addGracefulMessage(cause.getGracefulMessage());
                    result.addFailureToTrace("Error occured assigning WorkItem", (Throwable)cause);
                }
            }
        } else {
            for (Long wiid : wiids) {
                this.assign(session, wiid, performer);
            }
        }
        result.setReturnValue(validIdList);
        return result;
    }

    public void assign(Session session, long wiid, String performer) {
        BLLockDAO.workitem(wiid, "WorkItemSBBean.assign");
        WorkItemEBLocal wiEB = BLUtil.self().getWorkItemEB(wiid);
        long piid = wiEB.getProcessInstanceID();
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        this.assignWorkItem(pCtx, wiid, performer, true);
    }

    public List<WorkItem> getWorkItems(Session session, List<Long> wiids) {
        if (wiids == null || wiids.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4613", "WFWorkItem.getWorkItems()");
        }
        ArrayList<WorkItem> wiList = new ArrayList<WorkItem>();
        for (Long wiid : wiids) {
            WorkItem wi = SVOFactory.getWorkItem(session, wiid, false);
            wiList.add(wi);
        }
        return wiList;
    }

    public ResultData<List<Long>> completeByClient(Session session, List<Long> idList) {
        return this.completeByClient(session, idList, null, true);
    }

    public ResultData<List<Long>> completeByClient(Session session, List<Long> idList, Map<String, Object> dsValues, boolean isMultiTrans) {
        if (idList == null || idList.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4621", "WFWorkItem.completeByClient(Sess,List,Map,bool)", new Object[]{"complete", "workitem"});
        }
        ArrayList<Long> validIdList = new ArrayList<Long>();
        ResultData result = new ResultData();
        for (Long wiID : idList) {
            try {
                if (wiID == null) {
                    if (isMultiTrans) {
                        BizLogicException th = new BizLogicException("BizLogic_ERR_4673", "WFWorkItem.completeByClient(Sess,List,Map,bool)", new Object[]{idList, "complete", "workitem"});
                        result.addFailureToTrace("WIID is null", (Throwable)th);
                        continue;
                    }
                    throw new BizLogicException("BizLogic_ERR_3762", "WFWorkItem.completeByClient(Sess,List,Map,bool)", new Object[]{idList, "complete", "workitem"});
                }
                if (isMultiTrans) {
                    BLUtil.getServiceLocal().completeWorkItem(session, wiID, dsValues);
                } else {
                    long piid = WorkItemDAO.getProcessInstanceId(wiID);
                    WFProcessContext pctx = new WFProcessContext(session, piid);
                    pctx.completeWorkItem(wiID, dsValues);
                }
                validIdList.add(wiID);
            }
            catch (Throwable th2) {
                BizLogicException th2;
                if (th2 instanceof BizLogicAppException) {
                    th2 = new BizLogicException(th2.getMessage(), th2.getCause());
                }
                if (isMultiTrans) {
                    BizLogicException cause = th2 instanceof BizLogicException ? (BizLogicException)th2 : new BizLogicException("BizLogic_ERR_4828", "wfwi.completeByClient()", new Object[]{wiID, session.getUser()}, (Throwable)th2);
                    result.addGracefulMessage(cause.getGracefulMessage());
                    result.addFailureToTrace("Error occured completing WorkItem", (Throwable)cause);
                    continue;
                }
                throw new BizLogicException("BizLogic_ERR_4672", "WFWorkItem.completeByClient(Sess,List,Map,bool)", new Object[]{"WorkItem complete", "workItem", "WIID=" + wiID}, (Throwable)th2);
            }
        }
        result.setReturnValue(validIdList);
        return result;
    }

    public ResultData<List<Long>> suspendByClient(Session session, List<Long> idList) {
        if (idList == null || idList.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4621", "WFWorkItem.suspendByClient()", new Object[]{"suspend", "workitem"});
        }
        ArrayList<Long> validIdList = new ArrayList<Long>();
        for (Long wiID : idList) {
            try {
                if (wiID == null) {
                    throw new BizLogicException("BizLogic_ERR_3762", "WFWorkItem.suspendByClient()", new Object[]{idList, "suspend", "workitem"});
                }
                BLUtil.getServiceLocal().suspendWorkItem(session, wiID, "Suspend By Client");
                validIdList.add(wiID);
            }
            catch (Throwable th) {
                return new ResultData(validIdList, th, (Object)wiID);
            }
        }
        return new ResultData();
    }

    public ResultData<List<Long>> resumeByClient(Session session, List<Long> idList) {
        if (idList == null || idList.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4621", "WFWorkItem.resumeByClient()", new Object[]{"resume", "workitem"});
        }
        ArrayList<Long> validIdList = new ArrayList<Long>();
        for (Long wiID : idList) {
            try {
                if (wiID == null) {
                    throw new BizLogicException("BizLogic_ERR_3762", "WFWorkItem.resumeByClient()", new Object[]{idList, "resume", "workitem"});
                }
                BLUtil.getServiceLocal().resumeWorkItem(session, wiID);
                validIdList.add(wiID);
            }
            catch (Throwable th) {
                return new ResultData(validIdList, th, (Object)wiID);
            }
        }
        return new ResultData();
    }

    public ResultData<List<Long>> removeByClient(Session session, List<Long> idList) {
        if (idList == null || idList.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4621", "WFWorkItem.removeByClient()", new Object[]{"remove", "workitem"});
        }
        ArrayList<Long> validIdList = new ArrayList<Long>();
        for (Long wiID : idList) {
            try {
                if (wiID == null) {
                    throw new BizLogicException("BizLogic_ERR_3762", "WFWorkItem.removeByClient()", new Object[]{idList, "remove", "workitem"});
                }
                BLUtil.getServiceLocal().removeWorkItem(session, wiID);
                validIdList.add(wiID);
            }
            catch (Throwable th) {
                return new ResultData(validIdList, th, (Object)wiID);
            }
        }
        return new ResultData();
    }

    private String getTruncatedAvailPerformers(long wiid) {
        String performerStr = AvailableWorkItemDAO.getAvailablePerformersString(wiid);
        if (performerStr.length() > 64) {
            performerStr = performerStr.substring(0, 64);
        }
        return performerStr;
    }

    public DataSlotList getDataSlotList(Session session, long wiid, String[] dsNames, boolean withMetaData) {
        WFProcessContext pCtx = new WFProcessContext(session, wiid, true);
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiid);
        return SVOFactory.getDataSlotList(pCtx, wieb.getProcessTemplateID(), wieb.getProcessInstanceID(), wieb.getWorkStepID(), dsNames, withMetaData);
    }
}

