/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.common.script.ScriptBuilder;
import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.WFAppObject;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFJavaScript;
import com.savvion.sbm.bizlogic.server.WFLink;
import com.savvion.sbm.bizlogic.server.WFPreCondition;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.svo.DataSlotMapping;
import com.savvion.sbm.bizlogic.server.svo.DataSlotMappingList;
import com.savvion.sbm.bizlogic.server.svo.MessageSubscription;
import com.savvion.sbm.bizlogic.server.svo.MessageSubscriptionList;
import com.savvion.sbm.bizlogic.server.svo.TimerAction;
import com.savvion.sbm.bizlogic.server.svo.TimerActionList;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BOExpression;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.util.LoggerUtil;
import com.savvion.sbm.util.SBMUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class WFWorkstep
extends WFAppObject {
    static final long serialVersionUID = -1817298055148513715L;
    private static final String CREATOR = "CREATOR";
    private static final String PROCESSNAME = "PROCESSNAME";
    private static final String WORKSTEPNAME = "WORKSTEPNAME";
    private static final String PRIORITY = "PRIORITY";
    private static final String STARTTIME = "STARTTIME";
    private static final String ALLDATASLOTS = "ALLDATASLOTS";
    private static final String CREATOR_AT = "@CREATOR";
    String hasPerformer = null;
    private String mappedDuration = null;
    long duration;
    int priority;
    String mappedPriority = null;
    String activateAfter;
    String activateAt;
    private int activationLimit;
    int preconditionType = -1;
    String precondition = null;
    String preconditionCode = null;
    int typeTag;
    String instruction;
    HashMap inputSlots = new LinkedHashMap();
    HashMap outputSlots = new LinkedHashMap();
    HashMap inputSlotsQuery = new HashMap();
    HashMap outputSlotsQuery = new HashMap();
    Vector hasIncoming = new Vector();
    Vector hasOutgoing = new Vector();
    WFProcess parentProcess;
    String milestoneName;
    Object performingApp;
    WFJavaScript wsjscript;
    private boolean rollbackPoint = false;
    private Vector dsCopyNames = null;
    public Hashtable dsCopies = null;
    private String reactivateWorkStepName = null;
    Vector preCondReadDS;
    Vector preJSReadDS;
    Vector postJSReadDS;
    private boolean isPreCondReferGlobalDS = false;
    private String timeoutFlow = null;
    TimerActionList timerActions = null;
    boolean inLineTask = false;
    String skipcondition = null;
    String skipconditionCode = null;
    int skipconditionType = -1;
    String loopCondition = null;
    String loopConditionCode = null;
    int loopConditionType = -1;
    String loopConditionCounterDS = null;
    private transient Long nextAndJoinWSID = null;
    private transient Long nextEndWSID = null;
    private DataSlotMappingList inputDSMapping;
    private DataSlotMappingList outputDSMapping;
    private MessageSubscriptionList MessageSubscriptionList;
    private boolean exclusiveDecision = false;
    private String inlineBlockName = null;
    private Map<Integer, ArrayList<String>> alertNamesForState = null;
    private boolean isMonitorStep = false;
    private boolean waitForActivateEvent = false;
    private Set<String> smsAlertName = null;

    public int getActivationLimit() {
        if (this.activationLimit < -1 || this.activationLimit == 0) {
            return BLUtil.self().getMaxWSLoopCounter();
        }
        return this.activationLimit;
    }

    public WFWorkstep() {
        this.state = 15;
    }

    public WFWorkstep(int type) {
        this.typeTag = type;
        this.state = 15;
    }

    public boolean hasSkipCondition() {
        return this.skipcondition != null;
    }

    void setInlineBlockName(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4504", "WFWorkstep.setInlineBlockName()", new Object[]{this.parentProcess.getName(), "InlineBlock", name, this.getName(), BLUtil.getStringWSType((int)this.getType())});
        }
        this.inlineBlockName = name;
    }

    String getInlineBlockName() {
        return this.inlineBlockName;
    }

    public boolean isWithinInlineBlock() {
        return this.inlineBlockName != null;
    }

    void setSkipCondition(String condition, int type) {
        if (type == -1 || condition == null || condition.trim().isEmpty()) {
            this.skipcondition = null;
            this.skipconditionType = -1;
            return;
        }
        if (!this.isPrimaryWS()) {
            throw new BizLogicException("BizLogic_ERR_3722", "WFWorkstep.setSkipCondition", new Object[]{this.getWSType(), this.parentProcess.getName()});
        }
        if (!this.isValidExpressionType(type)) {
            throw new BizLogicException("BizLogic_ERR_3723", "WFWorkstep.setSkipCondition", new Object[]{condition, this.getWSType(), this.parentProcess.getName()});
        }
        this.skipcondition = condition.trim();
        this.skipconditionType = type;
        BLControl.logger.infoKey("BizLogic_ERR_3226", new Object[]{this.parentProcess.getName(), this.getName(), this.skipcondition, this.skipconditionType});
    }

    public boolean hasLoopCondition() {
        return this.loopCondition != null;
    }

    void setLoopCondition(String condition, int type) {
        if (type == -1 || condition == null || condition.trim().isEmpty()) {
            this.loopCondition = null;
            this.loopConditionType = -1;
            return;
        }
        if (!this.isPrimaryWS()) {
            throw new BizLogicException("BizLogic_ERR_3666", "WFWorkstep.setLoopCondition", new Object[]{this.getWSType(), this.parentProcess.getName()});
        }
        if (!this.isValidExpressionType(type)) {
            throw new BizLogicException("BizLogic_ERR_3667", "WFWorkstep.setLoopCondition", new Object[]{condition, this.getWSType(), this.parentProcess.getName()});
        }
        this.loopCondition = condition.trim();
        this.loopConditionType = type;
        BLControl.logger.infoKey("BizLogic_ERR_3153", new Object[]{this.parentProcess.getName(), this.getName(), this.loopCondition, this.loopConditionType});
    }

    private boolean isValidExpressionType(int type) {
        return type == 200 || type == 201 || type == 203 || type == 205;
    }

    void setLoopConditionCounterDSName(String dsName) {
        this.loopConditionCounterDS = dsName;
    }

    public String getLoopConditionCounterDSName() {
        return this.loopConditionCounterDS;
    }

    public boolean isInLineTask() {
        return this.inLineTask;
    }

    public void addOutConnection(WFLink c) {
        this.hasOutgoing.addElement(c);
    }

    public void addInConnection(WFLink c) {
        this.hasIncoming.addElement(c);
    }

    public void removeOutConnection(WFLink c) {
        this.hasOutgoing.removeElement(c);
    }

    public void removeInConnection(WFLink c) {
        this.hasIncoming.removeElement(c);
    }

    public Vector getOutConnections() {
        return this.hasOutgoing;
    }

    public Vector getInConnections() {
        return this.hasIncoming;
    }

    public Vector getNextWorksteps() {
        Vector<WFWorkstep> ws = new Vector<WFWorkstep>();
        for (int x = 0; x < this.hasOutgoing.size(); ++x) {
            WFLink c = (WFLink)this.hasOutgoing.elementAt(x);
            if (c.isTimeoutFlow()) continue;
            ws.addElement(c.getTarget());
        }
        return ws;
    }

    public Vector getNextWorkstepsNames() {
        Vector<String> wsnamelist = new Vector<String>();
        for (int x = 0; x < this.hasOutgoing.size(); ++x) {
            WFLink c = (WFLink)this.hasOutgoing.elementAt(x);
            wsnamelist.addElement(c.getTarget().getName());
        }
        return wsnamelist;
    }

    public Vector getPreviousWorkstepsNames() {
        Vector<String> wsnamelist = new Vector<String>();
        for (int x = 0; x < this.hasIncoming.size(); ++x) {
            WFLink c = (WFLink)this.hasIncoming.elementAt(x);
            wsnamelist.addElement(c.getSource().getName());
        }
        return wsnamelist;
    }

    public Vector getPreviousWorksteps() {
        Vector<WFWorkstep> ws = new Vector<WFWorkstep>();
        for (int x = 0; x < this.hasIncoming.size(); ++x) {
            WFLink c = (WFLink)this.hasIncoming.elementAt(x);
            ws.addElement(c.getSource());
        }
        return ws;
    }

    public boolean isInitialWorkstep() {
        return this.typeTag == 100;
    }

    public boolean isFinishWorkstep() {
        return this.typeTag == 101;
    }

    public boolean isAtomic() {
        return this.typeTag == 102;
    }

    public boolean isSubProcess() {
        return this.typeTag == 108;
    }

    public boolean isAdapter() {
        return this.typeTag == 107;
    }

    public boolean isSplit() {
        return this.typeTag == 103;
    }

    public boolean isAndJoin() {
        return this.typeTag == 104;
    }

    public boolean isOrJoin() {
        return this.typeTag == 105;
    }

    public boolean isXORJoin() {
        return this.typeTag == 113;
    }

    public boolean isDecision() {
        return this.typeTag == 106;
    }

    public boolean isInlineBlock() {
        return this.typeTag == 114;
    }

    public boolean isInlineBlockStart() {
        return this.typeTag == 115;
    }

    public boolean isInlineBlockEnd() {
        return this.typeTag == 116;
    }

    public boolean isMessageSubscriberWS() {
        return this.typeTag == 110;
    }

    public boolean isMessagePublisherWS() {
        return this.typeTag == 111;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusiveDecision = exclusive;
    }

    public boolean isExclusive() {
        return this.exclusiveDecision;
    }

    public boolean isConnectorWS() {
        return this.isSplit() || this.isOrJoin() || this.isAndJoin() || this.isDecision() || this.isXORJoin();
    }

    public boolean isPrimaryWS() {
        return !this.isInitialWorkstep() && !this.isFinishWorkstep() && !this.isConnectorWS() && !this.isInlineBlockStart() && !this.isInlineBlockEnd();
    }

    protected final void setType(int t) {
        this.typeTag = t;
    }

    public int getType() {
        return this.typeTag;
    }

    public final void setParentProcess(WFProcess p) {
        this.parentProcess = p;
    }

    protected final WFProcess getParentProcess() {
        return this.parentProcess;
    }

    public final String getProcessName() {
        return this.parentProcess.getName();
    }

    public void setPreCondReadDS(Vector preds) {
        this.preCondReadDS = preds;
    }

    public Vector getPreCondReadDS() {
        return this.preCondReadDS;
    }

    public void setPreJSReadDS(Vector prejsds) {
        this.preJSReadDS = prejsds;
    }

    public Vector getPreJSReadDS() {
        return this.preJSReadDS;
    }

    public void setPostJSReadDS(Vector postjsds) {
        this.postJSReadDS = postjsds;
    }

    public Vector getPostJSReadDS() {
        return this.postJSReadDS;
    }

    public String[] getInputSlotsKeys() {
        return BLUtil.getHashMapKeys((HashMap)this.inputSlots);
    }

    public String[] getOutputSlotsKeys() {
        return BLUtil.getHashMapKeys((HashMap)this.outputSlots);
    }

    public String[] getSlotKeys() {
        HashMap dsList = new HashMap();
        dsList.putAll(this.inputSlots);
        dsList.putAll(this.outputSlots);
        return BLUtil.getHashMapKeys(dsList);
    }

    public Hashtable getInputDataslotList() {
        String[] dsNames = this.getInputSlotsKeys();
        return this.getDataSlotList(dsNames);
    }

    public Hashtable getOutputDataslotList() {
        String[] dsNames = this.getOutputSlotsKeys();
        return this.getDataSlotList(dsNames);
    }

    public Hashtable getDataslotList() {
        String[] dsNames = this.getSlotKeys();
        return this.getDataSlotList(dsNames);
    }

    private Hashtable getDataSlotList(String[] dsNameList) {
        Hashtable<String, Vector> dataslotList = new Hashtable<String, Vector>();
        if (dsNameList != null) {
            try {
                for (int x = 0; x < dsNameList.length; ++x) {
                    WFDataslot d = this.getDataslot(dsNameList[x]);
                    dataslotList.put(dsNameList[x], this.getDataslotInfo(d));
                }
            }
            catch (Exception e) {
                BLControl.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return dataslotList;
    }

    private Vector getDataslotInfo(WFDataslot d) {
        Vector<Object> v = new Vector<Object>();
        v.addElement(d.getType());
        if (d.getValue() != null) {
            v.addElement(d.getValue().toString());
        } else {
            v.addElement("NULL");
        }
        if ((d.isDouble() || d.isLong() || d.isURL() || d.isString()) && d.hasChoices()) {
            v.addElement(d.getChoices());
        }
        return v;
    }

    public Vector getObjectDataSlotList() {
        int ix;
        WFDataslot ds = null;
        Vector<WFDataslot> objDSList = new Vector<WFDataslot>();
        String[] dsNames = this.getInputSlotsKeys();
        if (dsNames != null) {
            for (ix = 0; ix < dsNames.length; ++ix) {
                ds = this.getDataslot(dsNames[ix]);
                if (ds == null || !ds.isObject()) continue;
                objDSList.add(ds);
            }
        }
        if ((dsNames = this.getOutputSlotsKeys()) != null) {
            for (ix = 0; ix < dsNames.length; ++ix) {
                ds = this.getDataslot(dsNames[ix]);
                if (ds == null || !ds.isObject()) continue;
                objDSList.add(ds);
            }
        }
        return objDSList;
    }

    public synchronized void setInputSlots(HashMap ids) {
        if (this.parentProcess.isActivated()) {
            this.validateDataslots(ids);
        }
        this.inputSlots = ids;
    }

    public HashMap getInputSlotsMapping() {
        return this.inputSlots;
    }

    public synchronized void setInputSlotsQuery(HashMap dsQueries) {
        if (dsQueries != null) {
            this.inputSlotsQuery = dsQueries;
        }
    }

    public String getInputSlotQueryId(String dsName) {
        return (String)this.inputSlotsQuery.get(dsName);
    }

    public synchronized void setOutputSlots(HashMap ods) {
        if (this.parentProcess.isActivated()) {
            this.validateDataslots(ods);
        }
        this.outputSlots = ods;
    }

    public HashMap getOutputSlotsMapping() {
        return this.outputSlots;
    }

    public synchronized void setOutputSlotsQuery(HashMap dsQueries) {
        if (dsQueries != null) {
            this.outputSlotsQuery = dsQueries;
        }
    }

    public String getOutputSlotQueryId(String dsName) {
        return (String)this.outputSlotsQuery.get(dsName);
    }

    private boolean validateDataslots(HashMap ds) {
        Set set = ds.keySet();
        String dsName2 = null;
        for (String dsName2 : set) {
            if (this.parentProcess.isDataslotExist(dsName2)) continue;
            throw new BizLogicException("Bizlogic_ERR_3706", "WFWorkstep.validateDataslots", new Object[]{dsName2, this.getName(), this.parentProcess.getName()});
        }
        return true;
    }

    public boolean hasThisOutput(String dsName) {
        if (this.outputSlots == null || dsName == null) {
            return false;
        }
        return this.outputSlots.containsKey(dsName);
    }

    public boolean hasThisInput(String dsName) {
        if (this.inputSlots == null || dsName == null) {
            return false;
        }
        return this.inputSlots.containsKey(dsName);
    }

    public WFDataslot getDataslot(String dsn) throws BizLogicException {
        BLConstants consts = BLControl.consts;
        WFProcess pt = this.getParentProcess();
        if (dsn == null || pt == null) {
            throw new BizLogicException("BizLogic_ERR_570", "WFWorkstep.getDataslot", (Object[])new String[]{this.parentProcess.getName(), "null"});
        }
        if (dsn.startsWith("@")) {
            String tmp = dsn.substring(1).toUpperCase();
            if (CREATOR.equals(tmp)) {
                return new WFDataslot(tmp, "STRING", pt.getCreator(), null, null);
            }
            if (PROCESSNAME.equals(tmp)) {
                return new WFDataslot(tmp, "STRING", pt.getName(), null, null);
            }
            if (WORKSTEPNAME.equals(tmp)) {
                return new WFDataslot(tmp, "STRING", this.getName(), null, null);
            }
            if (PRIORITY.equals(tmp)) {
                return new WFDataslot(tmp, "STRING", SBMUtil.self().getStringPriority(this.getPriority()), null, null);
            }
            if (STARTTIME.equals(tmp)) {
                return new WFDataslot(tmp, "LONG", 0L, null, null);
            }
            if ("@PROCESS_INSTANCE_ID".equalsIgnoreCase(dsn)) {
                return new WFDataslot(tmp, "LONG", 0L, null, null);
            }
            if ("@PROCESS_TEMPLATE_NAME".equalsIgnoreCase(dsn)) {
                return new WFDataslot(tmp, "STRING", pt.getName(), null, null);
            }
            if (ALLDATASLOTS.equals(tmp)) {
                HashMap hm = this.createCompleteDSlist();
                return new WFDataslot(tmp, "OBJECT", hm, null, null);
            }
            throw new BizLogicException("BizLogic_ERR_570", "WFWorkstep.getDataslot", (Object[])new String[]{this.parentProcess.getName(), tmp});
        }
        return pt.getDataslot(dsn);
    }

    private HashMap createCompleteDSlist() {
        HashMap hm = this.getParentProcess().getAllDataSlots();
        hm.put(PROCESSNAME, this.getParentProcess().getName());
        hm.put(WORKSTEPNAME, this.getName());
        return hm;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public String getRealInstruction() {
        if (this.instruction != null && BLUtil.isParameter((String)this.instruction)) {
            String tmp = BLUtil.getParameter((String)this.instruction);
            Object inst = this.parentProcess.getSlotValue(tmp);
            if (inst != null) {
                return inst.toString();
            }
            return null;
        }
        return this.instruction;
    }

    public synchronized void setInstruction(String instruction) {
        this.instruction = BLUtil.trim((String)this.getProcessName(), (String)"INSTRUCTION", (String)instruction, (int)BLControl.util.MAX_INSTRUCTION_SIZE);
    }

    public String getPerformer() {
        return this.hasPerformer;
    }

    public Object getPerformingApp() {
        return this.performingApp;
    }

    public Object getRealPerformingApp() {
        if (this.performingApp != null && BLUtil.isParameter((String)this.performingApp.toString())) {
            String tmp = BLUtil.getParameter((String)((String)this.performingApp));
            return this.parentProcess.getSlotValue(tmp);
        }
        return this.performingApp;
    }

    public void setPerformingApp(Object p) {
        this.performingApp = p;
    }

    public boolean isPreCondReferGlobalDS() {
        return this.isPreCondReferGlobalDS;
    }

    public void setIsPreCondReferGlobalDS(boolean bvalue) {
        this.isPreCondReferGlobalDS = bvalue;
    }

    public void checkPreCondReadDS() {
        block7: {
            block6: {
                if (this.preconditionType == 203) break block6;
                if (this.preconditionType != 201) break block7;
            }
            if (this.preCondReadDS == null || this.preCondReadDS.isEmpty()) {
                this.setIsPreCondReferGlobalDS(true);
                return;
            }
        }
        if (this.preCondReadDS != null) {
            boolean isFirstTime = true;
            for (int ix = this.preCondReadDS.size() - 1; ix >= 0; --ix) {
                String dsName = (String)this.preCondReadDS.elementAt(ix);
                WFDataslot ds = this.parentProcess.getDataslot(dsName);
                if (!ds.isGlobal() || !isFirstTime) continue;
                this.setIsPreCondReferGlobalDS(true);
                isFirstTime = false;
            }
        }
    }

    public final String getPreCondition() {
        block3: {
            block2: {
                if (this.preconditionType == 203) break block2;
                if (this.preconditionType != 201) break block3;
            }
            return this.preconditionCode;
        }
        return this.precondition;
    }

    public final String getPreCondExpression() {
        return this.precondition;
    }

    public final int getPreConditionType() {
        return this.preconditionType;
    }

    public boolean isMilestone() {
        return this.milestoneName != null && this.milestoneName.trim().length() != 0;
    }

    public String getMilestoneName() {
        return this.milestoneName;
    }

    public String getMilestoneDescription() {
        if (this.milestoneName != null) {
            return this.getParentProcess().getMilestoneDescription(this.milestoneName);
        }
        return null;
    }

    void setMilestoneName(String name) {
        if (!this.getParentProcess().hasMilestone(name)) {
            throw new BizLogicException("Bizlogic_ERR_3705", "WFWorkstep.getMilestone(name)", new Object[]{name, this.getProcessName()});
        }
        this.milestoneName = name;
    }

    public void setTimeoutFlow(String timerws) {
        this.timeoutFlow = timerws;
        if (this.timeoutFlow != null && this.timeoutFlow.trim().isEmpty()) {
            this.timeoutFlow = null;
        }
    }

    public String getTimeoutFlow() {
        return this.timeoutFlow;
    }

    public boolean hasTimeoutFlow() {
        return this.timeoutFlow != null;
    }

    public void setMessageSubscriptionList(MessageSubscriptionList messageSubscriptionList) {
        this.MessageSubscriptionList = messageSubscriptionList;
    }

    private void validateSubscription() {
        List subscriptionList;
        if (this.MessageSubscriptionList != null && (subscriptionList = this.MessageSubscriptionList.getSubscribedMessages()) != null) {
            for (Object element : subscriptionList) {
                MessageSubscription subscription = (MessageSubscription)element;
                this.validateSubscriptionMapping(subscription.getMessageMapping());
            }
        }
    }

    protected void validateSubscriptionMapping(List mappingList) {
        if (mappingList != null) {
            String dsKey = null;
            dsKey = this.isMessagePublisherWS() ? "COPY_FROM" : "COPY_TO";
            for (Object listElement : mappingList) {
                Map mapping = (Map)listElement;
                String dsName = (String)mapping.get(dsKey);
                BLConstants.single();
                if (!dsName.startsWith("@")) {
                    if (this.isMessageSubscriberWS()) {
                        throw new BizLogicException("BizLogic_ERR_3077", "WFWorkstep.validateSubscriptionMapping", new Object[]{this.getName(), this.getParentProcess().getName()});
                    }
                    return;
                }
                dsName = dsName.substring(1);
                boolean isSystemDS = BLUtil.self().isSystemDataSlot(dsName);
                if (this.isMessageSubscriberWS() && isSystemDS) {
                    throw new BizLogicException("BizLogic_ERR_3078", "WFWorkstep.validateSubscriptionMapping", new Object[]{this.getName(), this.getParentProcess().getName(), dsName});
                }
                if (isSystemDS) continue;
                WFDataslot ds = this.parentProcess.getDataslot(dsName, true);
                if (ds == null) {
                    throw new BizLogicException("BizLogic_ERR_3070", "WFWorkstep.validateSubscriptionMapping", new Object[]{dsName, this.getName(), this.getParentProcess().getName()});
                }
                if (!ds.isDocument()) continue;
                throw new BizLogicException("BizLogic_ERR_3071", "WFWorkstep.validateSubscriptionMapping", new Object[]{dsName, this.getName(), this.getParentProcess().getName()});
            }
        }
    }

    public MessageSubscriptionList getMessageSubscriptionList() {
        if (this.MessageSubscriptionList == null) {
            this.MessageSubscriptionList = new MessageSubscriptionList(this.getName(), this.getParentProcess().getName());
        }
        return this.MessageSubscriptionList;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long d) {
        this.duration = d;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int p) {
        this.priority = p;
    }

    public String getMappedPriority() {
        return this.mappedPriority;
    }

    public void setMappedPriority(String priority) {
        this.mappedPriority = priority;
    }

    public String getWSType() {
        return BLUtil.getStringWSType((int)this.typeTag);
    }

    public String getActivateAfter() {
        return this.activateAfter;
    }

    public String getActivateAt() {
        return this.activateAt;
    }

    public void setActivateAfter(String waitDuration) {
        if (waitDuration == null) {
            this.activateAfter = waitDuration;
            return;
        }
        if (this.activateAt != null && !this.activateAt.trim().isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_780", "WFWorkstep.setActivateAfter(s)", new Object[]{this.getParentProcess().getName(), this.getName()});
        }
        if (BLUtil.isMappedDataSlot((String)waitDuration)) {
            if (this.getParentProcess().isActivated()) {
                this.validateActivationDelay(waitDuration, true);
            }
        } else {
            try {
                Long.parseLong(waitDuration);
            }
            catch (NumberFormatException nfe) {
                throw new BizLogicException("BizLogic_ERR_801", "WFWorkstep.setActivateAfter(s)", new Object[]{waitDuration, this.getParentProcess().getName(), this.getName()});
            }
        }
        this.activateAfter = waitDuration;
    }

    public void setActivateAt(String actTime) {
        if (actTime == null) {
            this.activateAt = actTime;
            return;
        }
        if (this.activateAfter != null && !this.activateAfter.trim().isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_780", "WFWorkstep.setActivateAt(s)", new Object[]{this.getParentProcess().getName(), this.getName()});
        }
        if (BLUtil.isMappedDataSlot((String)actTime)) {
            if (this.getParentProcess().isActivated()) {
                this.validateActivationDelay(actTime, false);
            }
        } else {
            try {
                Long.parseLong(actTime);
            }
            catch (NumberFormatException nfe) {
                throw new BizLogicException("BizLogic_ERR_802", "WFWorkstep.setActivateAt(s)", new Object[]{this.getParentProcess().getName(), this.getName(), actTime});
            }
        }
        this.activateAt = actTime;
    }

    public boolean isDelayActivation() {
        return this.activateAfter != null && !this.activateAfter.trim().isEmpty() || this.activateAt != null && !this.activateAt.trim().isEmpty();
    }

    void setReactivateWorkstep(WFWorkstep ws) {
        String wsName = ws.getName();
        if (ws.isRollbackPoint()) {
            this.reactivateWorkStepName = wsName;
            return;
        }
        throw new BizLogicException("BizLogic_ERR_2554", "WFWorkstep.setReactivateWorkstep", new Object[]{this.parentProcess.getName(), this.getName(), wsName, wsName});
    }

    public WFJavaScript getJavaScript() {
        return this.wsjscript;
    }

    void setID(long id) {
        this.ID = id;
    }

    public void setAttributes(HashMap hm) {
        if (this.getParentProcess().isSuspended()) {
            throw new BizLogicException("BizLogic_ERR_675", "WFWorkstep.setAttributes(hm)", new Object[]{this.getName(), this.getParentProcess().getName()});
        }
        for (String key : hm.keySet()) {
            if (key.equals("PERFORMER")) {
                String perf = (String)hm.get(key);
                this.setPerformer(perf);
                continue;
            }
            if (key.equals("PERFORMINGAPP")) {
                String app = (String)hm.get(key);
                this.setPerformingApp(app);
                continue;
            }
            if (key.equals("DURATION")) {
                long duration = (Long)hm.get(key);
                this.setDuration(duration);
                continue;
            }
            if (key.equals("PRECONDITION")) {
                String cond = (String)hm.get(key);
                this.setPreCondition(cond);
                this.preconditionType = hm.containsKey("PRECONDITIONTYPE") ? (Integer)hm.get("PRECONDITIONTYPE") : -1;
                this.validatePreCondition();
                continue;
            }
            if (key.equals("PRESCRIPT")) {
                String script = (String)hm.get(key);
                int preType = -1;
                preType = hm.containsKey("PRESCRIPTTYPE") ? (Integer)hm.get("PRESCRIPTTYPE") : -1;
                this.setPreFunction(script, preType);
                continue;
            }
            if (key.equals("POSTSCRIPT")) {
                String script = (String)hm.get(key);
                int postType = -1;
                postType = hm.containsKey("POSTSCRIPTTYPE") ? (Integer)hm.get("POSTSCRIPTTYPE") : -1;
                this.setPostFunction(script, postType);
                continue;
            }
            if (key.equals("COMPSCRIPT")) {
                String script = (String)hm.get(key);
                int compType = -1;
                compType = hm.containsKey("COMPSCRIPTTYPE") ? (Integer)hm.get("COMPSCRIPTTYPE") : -1;
                this.setCompFunction(script, compType);
                continue;
            }
            if (key.equals("REACTIVATEWS")) {
                String name = (String)hm.get(key);
                this.setReactivateWorkStepName(name);
                continue;
            }
            if (key.equals("INPUTDATASLOTS")) {
                HashMap inputSlots = (HashMap)hm.get(key);
                this.setInputSlots(inputSlots);
                continue;
            }
            if (key.equals("OUTPUTDATASLOTS")) {
                HashMap outputSlots = (HashMap)hm.get(key);
                this.setOutputSlots(outputSlots);
                continue;
            }
            if (key.equals("FYI")) {
                Vector fyi = (Vector)hm.get(key);
                this.getParentProcess().setWSFYI(this.getName(), fyi);
                continue;
            }
            if (key.equals("ROLLBACK")) {
                boolean rollback = (Boolean)hm.get(key);
                this.setRollbackPoint(rollback);
                continue;
            }
            if (key.equals("INSTRUCTION")) {
                String instr = (String)hm.get(key);
                this.setInstruction(instr);
                continue;
            }
            if (key.equals("MILESTONE_NAME")) {
                this.milestoneName = (String)hm.get(key);
                continue;
            }
            if (key.equals("MILESTONE_DESC")) continue;
            if (key.equals(PRIORITY)) continue;
            if (key.equals("DATASLOTCOPYNAMES")) {
                Vector dsNames = (Vector)hm.get(key);
                this.setDSCopyNames(dsNames);
                continue;
            }
            if (key.equals("TIMER_ACTION")) {
                TimerActionList actions = (TimerActionList)hm.get(key);
                this.setOverDueAction(actions);
                continue;
            }
            if (key.equals("PRECONDITIONTYPE")) continue;
            if (key.equals("ACTIVATEAFTER")) {
                this.setActivateAfter((String)hm.get(key));
                continue;
            }
            if (key.equals("ACTIVATEAT")) {
                this.setActivateAt((String)hm.get(key));
                continue;
            }
            if (key.equals("PRESCRIPTTYPE")) continue;
            if (key.equals("POSTSCRIPTTYPE")) continue;
            if (key.equals("COMPSCRIPTTYPE")) continue;
            throw new BizLogicException("BizLogic_ERR_1517", "WFWorkstep.setAttributes", new Object[]{this.getParentProcess().getName() + ":" + this.getName(), key, hm.get(key)});
        }
        ProcessControl.updateProcessTemplate(this.getParentProcess());
    }

    public HashMap getAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("WORKSTEPID", this.getID());
        attributes.put(WORKSTEPNAME, this.getName());
        attributes.put("PROCESSTEMPLATEID", this.getParentProcess().getID());
        attributes.put("TYPE", this.getType());
        attributes.put("PERFORMER", this.getPerformer());
        if (this.milestoneName != null && !this.milestoneName.trim().isEmpty()) {
            attributes.put("MILESTONE_NAME", this.getMilestoneName());
            attributes.put("MILESTONE_DESC", this.getMilestoneDescription());
        }
        attributes.put(PRIORITY, this.priority);
        attributes.put("MAPPED_PRIORITY", this.mappedPriority);
        attributes.put("PERFORMINGAPP", this.performingApp);
        attributes.put("DURATION", this.getDuration());
        attributes.put("STATUS", this.state);
        boolean dynamic = this.parentProcess.isDynamic();
        attributes.put("DYNAMIC", dynamic);
        attributes.put("ROLLBACK", this.rollbackPoint);
        if (dynamic) {
            attributes.put("DYNAMICINSTANCEID", this.parentProcess.dynamicinstanceid);
        }
        attributes.put("ACTIVATEAFTER", this.activateAfter);
        attributes.put("ACTIVATEAT", this.activateAt);
        attributes.put("MAPPED_DURATION", this.mappedDuration);
        attributes.put("MESSAGE_SUBSCRIPTION_LIST", this.MessageSubscriptionList);
        attributes.put("FYI", this.getParentProcess().getWSFYI(this.getName()));
        if (this.hasSkipCondition()) {
            attributes.put("SKIPCONDITION", this.skipcondition);
        }
        if (this.hasLoopCondition()) {
            attributes.put("LOOPCONDITION", this.loopCondition);
            if (this.getLoopConditionCounterDSName() != null) {
                attributes.put("LOOPCONDITIONCOUNTERDS", this.loopConditionCounterDS);
            }
        }
        attributes.put("MONITOR_STEP", this.isMonitorStep());
        return attributes;
    }

    public String getPreFunction() {
        if (this.wsjscript != null) {
            return this.wsjscript.getPreFunction();
        }
        return null;
    }

    public int getPreFunctionType() {
        if (this.wsjscript != null) {
            return this.wsjscript.getPreFunctionType();
        }
        return -1;
    }

    public String getPostFunction() {
        if (this.wsjscript != null) {
            return this.wsjscript.getPostFunction();
        }
        return null;
    }

    public int getPostFunctionType() {
        if (this.wsjscript != null) {
            return this.wsjscript.getPostFunctionType();
        }
        return -1;
    }

    public Hashtable getDataslotType() {
        WFDataslot ds;
        int x;
        String[] inpSlots = this.getInputSlotsKeys();
        String[] outSlots = this.getOutputSlotsKeys();
        Hashtable<String, String> dataslotTypes = new Hashtable<String, String>();
        if (inpSlots != null) {
            try {
                for (x = 0; x < inpSlots.length; ++x) {
                    ds = this.getDataslot(inpSlots[x]);
                    if (ds == null || ds.getType() == null) continue;
                    dataslotTypes.put(ds.getName(), ds.getType());
                }
            }
            catch (Throwable th) {
                LoggerUtil.logStackTrace((String)"Exception while getting dataslot name using inpSlots <WFWorkstep:getDataslotType()> ", (Throwable)th, null);
            }
        }
        if (outSlots != null) {
            try {
                for (x = 0; x < outSlots.length; ++x) {
                    ds = this.getDataslot(outSlots[x]);
                    if (ds == null || ds.getType() == null) continue;
                    dataslotTypes.put(ds.getName(), ds.getType());
                }
            }
            catch (Throwable th) {
                LoggerUtil.logStackTrace((String)"Exception while getting dataslot name using outSlots <WFWorkstep:getDataslotType()> ", (Throwable)th, null);
            }
        }
        return dataslotTypes;
    }

    public boolean hasInputObjectDS() {
        String[] inpds = this.getInputSlotsKeys();
        if (inpds == null) {
            return false;
        }
        for (int ix = 0; ix < inpds.length; ++ix) {
            WFDataslot ds = this.getDataslot(inpds[ix]);
            if (!ds.getType().equalsIgnoreCase("OBJECT")) continue;
            return true;
        }
        return false;
    }

    private void checkConnections() {
        Object[] eargs;
        block19: {
            int outconSize;
            int inconSize;
            block25: {
                block24: {
                    block23: {
                        block22: {
                            block21: {
                                block20: {
                                    block18: {
                                        if (BLControl.util.DEBUG_ENGINE) {
                                            BLControl.logger.debugKey("BizLogic_ERR_017", this.parentProcess.getName(), new Object[0]);
                                        }
                                        inconSize = this.getInConnections().size();
                                        outconSize = this.getOutConnections().size();
                                        BLConstants consts = BLControl.consts;
                                        eargs = new String[]{this.parentProcess.getName(), this.getName()};
                                        if (this.typeTag != 100) break block18;
                                        if (inconSize != 0) {
                                            throw new BizLogicException("BizLogic_ERR_3670", "WFWorkstep.checkConnections", eargs);
                                        }
                                        if (outconSize < 1) {
                                            throw new BizLogicException("BizLogic_ERR_3671", "WFWorkstep.checkConnections", eargs);
                                        }
                                        break block19;
                                    }
                                    if (this.typeTag != 101) break block20;
                                    if (inconSize < 1) {
                                        throw new BizLogicException("BizLogic_ERR_558", "WFWorkstep.checkConnections", eargs);
                                    }
                                    if (outconSize != 0) {
                                        throw new BizLogicException("BizLogic_ERR_559", "WFWorkstep.checkConnections", eargs);
                                    }
                                    break block19;
                                }
                                if (this.typeTag == 105) break block21;
                                if (this.typeTag == 104) break block21;
                                if (this.typeTag != 113) break block22;
                            }
                            if (inconSize < 1) {
                                throw new BizLogicException("BizLogic_ERR_560", "WFWorkstep.checkConnections", eargs);
                            }
                            if (outconSize != 1) {
                                throw new BizLogicException("BizLogic_ERR_561", "WFWorkstep.checkConnections", eargs);
                            }
                            break block19;
                        }
                        if (this.typeTag == 106) break block23;
                        if (this.typeTag != 103) break block24;
                    }
                    if (inconSize < 1) {
                        throw new BizLogicException("BizLogic_ERR_560", "WFWorkstep.checkConnections", eargs);
                    }
                    if (outconSize < 1) {
                        throw new BizLogicException("BizLogic_ERR_3672", "WFWorkstep.checkConnections", eargs);
                    }
                    break block19;
                }
                if (this.typeTag == 107) break block25;
                if (this.typeTag == 102) break block25;
                if (this.typeTag == 109) break block25;
                if (this.typeTag == 110) break block25;
                if (this.typeTag == 111) break block25;
                if (this.typeTag != 112) break block19;
            }
            if (inconSize < 1) {
                throw new BizLogicException("BizLogic_ERR_560", "WFWorkstep.checkConnections", eargs);
            }
            if (outconSize < 1) {
                throw new BizLogicException("BizLogic_ERR_3672", "WFWorkstep.checkConnections", eargs);
            }
        }
        if (this.hasOutgoing != null && !this.hasOutgoing.isEmpty()) {
            boolean hasDefaultLink = false;
            for (Object obj : this.hasOutgoing) {
                WFLink lnk = (WFLink)obj;
                if (!lnk.isDefault() || lnk.isTimeoutFlow()) continue;
                hasDefaultLink = true;
                break;
            }
            if (!hasDefaultLink) {
                throw new BizLogicException("BizLogic_ERR_3668", "WFWorkstep.checkConnections", eargs);
            }
        }
        this.setInLinksByWorkstepAsc();
        this.setOutLinksByWorkstepAsc();
    }

    private void checkMappedPriority(String ptName) {
        if (this.mappedPriority != null && this.mappedPriority.trim().length() != 0) {
            if (!BOExpression.isObjExpression((String)this.mappedPriority)) {
                WFDataslot ds = this.getParentProcess().getDataslot(this.mappedPriority, true);
                if (ds == null) {
                    throw new BizLogicException("BizLogic_ERR_3812", "WFWorkstep.checkMappedPriority", new Object[]{ptName, this.getName(), this.mappedPriority});
                }
                if (!ds.isString()) {
                    throw new BizLogicException("BizLogic_ERR_3744", "WFWorkstep.checkMappedPriority", new Object[]{this.mappedPriority, this.getName(), ptName, ds.getType()});
                }
            } else {
                BOExpression.validate((WFProcess)this.getParentProcess(), (String)this.mappedPriority);
            }
        }
    }

    private void checkMappedDuration(String ptName) {
        if (BLUtil.isParameter((String)this.mappedDuration)) {
            String dsName = BLUtil.getParameter((String)this.mappedDuration);
            WFDataslot ds = this.getParentProcess().getDataslot(dsName, true);
            if (ds == null) {
                throw new BizLogicException("BizLogic_ERR_3812", "WFWorkstep.checkMappedDuration", new Object[]{ptName, this.getName(), this.mappedDuration});
            }
            if (!ds.isLong()) {
                throw new BizLogicException("BizLogic_ERR_3813", "WFWorkstep.checkMappedDuration", new Object[]{dsName, this.getName(), ptName});
            }
        }
    }

    private void checkPerformer(String ptName) {
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debugKey("BizLogic_ERR_019", ptName, new Object[0]);
        }
        Object[] eargs = new String[]{ptName, this.getName()};
        if (this.typeTag == 107) {
            if (this.hasPerformer == null) {
                throw new BizLogicException("BizLogic_ERR_567", "WFWorkstep.checkPerformer", eargs);
            }
            if (this.hasPerformer.startsWith("@") && !CREATOR_AT.equalsIgnoreCase(this.hasPerformer)) {
                if (!this.hasPerformer.toUpperCase().startsWith("@" + "WORKSTEP:")) {
                    try {
                        this.getParentProcess().getSlotValue(this.hasPerformer.substring("@".length(), this.hasPerformer.length()));
                    }
                    catch (BizLogicException e) {
                        throw new BizLogicException("BizLogic_ERR_568", "WFWorkstep.checkPerformer", (Object[])new String[]{ptName, this.hasPerformer});
                    }
                }
            }
        } else if (this.typeTag == 102) {
            if (this.hasPerformer == null) {
                throw new BizLogicException("BizLogic_ERR_567", "WFWorkstep.checkPerformer", eargs);
            }
            if (!BLUtil.isValidPerformerExpression((String)this.hasPerformer)) {
                throw new BizLogicException("BizLogic_ERR_600", "WFWorkstep.checkPerformer", (Object[])new String[]{ptName, this.hasPerformer, this.getName()});
            }
            boolean listANY = BLUtil.isPerformerListANY((String)this.hasPerformer);
            boolean listALL = BLUtil.isPerformerListALL((String)this.hasPerformer);
            if (listALL) {
                this.validatePerformerListALL(this.hasPerformer);
            } else if (listANY) {
                this.validatePerformerListANY(this.hasPerformer);
            } else {
                this.validateSinglePerformer(this.hasPerformer);
            }
        }
    }

    public boolean validate() {
        String[] inpSlots = BLUtil.getHashMapKeys((HashMap)this.inputSlots);
        String[] outSlots = BLUtil.getHashMapKeys((HashMap)this.outputSlots);
        String ptName = this.parentProcess.getName();
        String name = this.getName();
        String[] eargs = new String[]{ptName, name};
        BLConstants consts = BLControl.consts;
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debugKey("BizLogic_ERR_016", ptName, new Object[0]);
        }
        if (!BLUtil.validWorkStepType((int)this.typeTag)) {
            throw new BizLogicException("BizLogic_ERR_557", "WFWorkstep.validate", (Object[])new String[]{ptName, name});
        }
        if (this.isNameTag()) {
            this.validateName(ptName, name, consts);
            this.validateSlots(inpSlots, ptName, name);
            this.validateSlots(outSlots, ptName, name);
        }
        this.validateInOutSlots(inpSlots, outSlots, eargs, consts);
        this.checkConnections();
        this.validateDefaultRoute(eargs, consts);
        if (!this.isMonitorStep()) {
            this.checkPerformer(ptName);
        }
        this.checkMappedDuration(ptName);
        this.checkMappedPriority(ptName);
        this.validateOutSlots(outSlots, ptName, consts);
        this.validateActivationDelay(name);
        this.validateWSData();
        this.validateSubscription();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isNameTag() {
        BLConstants consts = BLControl.consts;
        if (this.typeTag == 100) return true;
        if (this.typeTag == 107) return true;
        if (this.typeTag == 108) return true;
        if (this.typeTag == 102) return true;
        if (this.typeTag == 109) return true;
        if (this.typeTag == 110) return true;
        if (this.typeTag == 111) return true;
        if (this.typeTag == 112) return true;
        if (this.typeTag == 101) return true;
        if (this.typeTag == 114) return true;
        if (this.typeTag == 115) return true;
        if (this.typeTag != 116) return false;
        return true;
    }

    private void validateName(String ptName, String name, BLConstants consts) {
        if (name.length() > 32) {
            Object[] objectArray = new Object[3];
            objectArray[0] = ptName;
            objectArray[1] = name;
            objectArray[2] = 32;
            throw new BizLogicException("BizLogic_ERR_615", "WFWorkstep.validate", objectArray);
        }
    }

    private void validateSlots(String[] inpSlots, String ptName, String name) {
        if (inpSlots == null) {
            return;
        }
        for (String inpSlot : inpSlots) {
            try {
                this.getDataslot(inpSlot);
            }
            catch (RuntimeException e) {
                throw new BizLogicException("BizLogic_ERR_554", "WFWorkstep.validate", new Object[]{ptName, inpSlot, name});
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateInOutSlots(String[] inpSlots, String[] outSlots, String[] eargs, BLConstants consts) {
        block3: {
            block2: {
                if (this.typeTag == 101) break block2;
                if (this.typeTag == 105) break block2;
                if (this.typeTag == 104) break block2;
                if (this.typeTag != 103) break block3;
            }
            if (inpSlots == null || inpSlots.length == 0) return;
            throw new BizLogicException("BizLogic_ERR_555", "WFWorkstep.validate", (Object[])eargs);
        }
        if (this.typeTag != 106 || outSlots == null || outSlots.length == 0) return;
        throw new BizLogicException("BizLogic_ERR_556", "WFWorkstep.validate", (Object[])eargs);
    }

    private void validateDefaultRoute(String[] eargs, BLConstants consts) {
        boolean defaultOut = false;
        Vector connections = this.getOutConnections();
        for (WFLink link : connections) {
            if (link.getQuery() == null) {
                defaultOut = true;
                continue;
            }
            if (this.typeTag == 106) continue;
            throw new BizLogicException("BizLogic_ERR_565", "WFWorkstep.validate", (Object[])eargs);
        }
        if (this.typeTag == 106 && !defaultOut) {
            throw new BizLogicException("BizLogic_ERR_566", "WFWorkstep.validate", (Object[])eargs);
        }
    }

    private void validateOutSlots(String[] outSlots, String ptName, BLConstants consts) {
        if (outSlots == null) {
            return;
        }
        for (String outSlot : outSlots) {
            if (!outSlot.startsWith("@")) continue;
            throw new BizLogicException("BizLogic_ERR_564", "WFWorkstep.validate", (Object[])new String[]{ptName, outSlot});
        }
    }

    private void validateActivationDelay(String name) {
        this.validateActivationDelay(this.activateAfter, true);
        this.validateActivationDelay(this.activateAt, false);
        if (this.activateAfter != null && this.activateAt != null) {
            throw new BizLogicException("BizLogic_ERR_808", "WFWorkstep.validate", new Object[]{this.activateAfter, this.activateAt, this.getParentProcess().getName(), name});
        }
    }

    protected void validateWSData() {
    }

    protected void validateActivationDelay(String act, boolean isDuration) {
        if (act == null) {
            return;
        }
        if (BLUtil.isMappedDataSlot((String)act)) {
            try {
                String dsName = act.substring(1);
                WFDataslot ds = this.getDataslot(dsName);
                if (isDuration) {
                    if (!ds.isLong()) {
                        throw new BizLogicException("BizLogic_ERR_803", "WFWorkstep.validate", new Object[]{act, this.getParentProcess().getName(), this.getName()});
                    }
                } else if (!ds.isDate() && !ds.isLong()) {
                    throw new BizLogicException("BizLogic_ERR_804", "WFWorkstep.validate", new Object[]{act, this.getParentProcess().getName(), this.getName()});
                }
            }
            catch (BizLogicException blex) {
                throw blex;
            }
            catch (Exception ex) {
                throw new BizLogicException("BizLogic_ERR_1694", "WFWorkstep.validate", new Object[]{"validateActivationDelay", ex.getMessage()}, (Throwable)ex);
            }
        }
    }

    private void validatePerformerListANY(String performer) {
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debug((Object)("Validate listANY = " + performer));
        }
        StringTokenizer listTok = BLUtil.getPerformerListANY((String)performer);
        String elem = null;
        while (listTok.hasMoreTokens()) {
            elem = listTok.nextToken().trim();
            this.validateSinglePerformer(elem);
        }
    }

    private void validatePerformerListALL(String performer) {
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debug((Object)("Validate listALL = " + performer));
        }
        StringTokenizer listTok = BLUtil.getPerformerListALL((String)performer);
        String elem = null;
        while (listTok.hasMoreTokens()) {
            elem = listTok.nextToken().trim();
            if (elem.startsWith("{")) {
                if (elem.endsWith("}")) {
                    int startIdx = elem.indexOf("{") + 1;
                    int endIdx = elem.lastIndexOf("}");
                    String anyList = elem.substring(startIdx, endIdx);
                    this.validatePerformerListANY(anyList);
                    continue;
                }
            }
            this.validateSinglePerformer(elem);
        }
    }

    private void validateSinglePerformer(String performer) {
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debug((Object)("Validate single = " + performer));
        }
        if (performer == null || performer.length() == 0) {
            throw new BizLogicException("BizLogic_ERR_600", "WFWorkstep.validateSinglePerformer", (Object[])new String[]{this.parentProcess.getName(), performer, this.getName()});
        }
        if (!CREATOR_AT.equalsIgnoreCase(performer)) {
            if (performer.toUpperCase().startsWith("@") && !BOExpression.isObjExpression((String)performer)) {
                String ds = performer.substring("@".length());
                if (BLControl.util.DEBUG_ENGINE) {
                    BLControl.logger.debug((Object)("Validating ParamPerf = " + ds));
                }
                try {
                    this.getParentProcess().getSlotValue(ds);
                }
                catch (BizLogicException e) {
                    throw new BizLogicException("BizLogic_ERR_568", "WFWorkstep.validateSinglePerformer", (Object[])new String[]{this.parentProcess.getName(), ds});
                }
            }
        }
    }

    void validateLoopCondition() {
        if (this.loopCondition == null) {
            return;
        }
        if (this.loopConditionType == 203) {
            this.loopConditionCode = ScriptBuilder.generateJava((String)this.getName(), (String)this.loopCondition, (Map)this.parentProcess.getDataSlotsType());
        } else if (this.loopConditionType == 205) {
            this.loopConditionCode = this.loopCondition;
        }
        if (BLControl.util.DEBUG_JSCRIPT) {
            BLControl.logger.debugKey("BizLogic_ERR_3154", "WFWorkstep.validateLoopCondition", new Object[]{this.parentProcess.getName(), this.getName(), this.loopConditionCode});
        }
        WFJavaScript.parseJavaCode(this.loopConditionCode);
    }

    public void validatePreCondition() {
        if (this.precondition == null) {
            return;
        }
        this.precondition = this.precondition.trim();
        if (this.preconditionType == 203) {
            this.preconditionCode = ScriptBuilder.generateJava((String)this.getName(), (String)this.precondition, (Map)this.parentProcess.getDataSlotsType());
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_3124", "WFWorkstep.validatePreCondition", new Object[]{this.parentProcess.getName(), this.getName(), this.preconditionCode});
            }
            WFJavaScript.parseJavaCode(this.preconditionCode);
            Vector javads = WFPreCondition.self().getJavaPreConditionSlots(this.precondition, this.parentProcess.getDataSlotsType());
            this.setPreCondReadDS(javads);
            this.checkPreCondReadDS();
            return;
        }
        if (BLUtil.isJS((String)this.precondition)) {
            this.preconditionCode = BLUtil.getJS((String)this.precondition);
            this.preconditionType = 201;
            this.initJavaScriptObject();
            this.wsjscript.setPreCondition(this.preconditionCode);
            if (this.getParentProcess().getStatus() != -1) {
                Vector jsds = this.getJavaScriptSlots(this.precondition);
                this.setPreCondReadDS(jsds);
                this.checkPreCondReadDS();
            }
        } else if (BLUtil.isJavaCode((String)this.precondition)) {
            this.preconditionCode = BLUtil.getJavaCode((String)this.precondition);
            this.preconditionType = 203;
            WFJavaScript.parseJavaCode(this.preconditionCode);
        } else {
            this.preconditionType = 200;
            this.precondition = WFPreCondition.self().formattingCondition(this.precondition);
            Vector preds = WFPreCondition.self().getPreConditionSlots(this.precondition);
            if (!preds.isEmpty()) {
                this.setPreCondReadDS(preds);
                if (this.parentProcess.isActivated()) {
                    this.checkPreCondReadDS();
                }
            }
        }
    }

    void validateSkipCondition() {
        if (this.skipcondition == null) {
            return;
        }
        if (this.skipconditionType == 203) {
            this.skipconditionCode = ScriptBuilder.generateJava((String)this.getName(), (String)this.skipcondition, (Map)this.parentProcess.getDataSlotsType());
        } else if (this.skipconditionType == 205) {
            this.skipconditionCode = this.skipcondition;
        }
        if (BLControl.util.DEBUG_JSCRIPT) {
            BLControl.logger.debugKey("BizLogic_ERR_3224", "WFWorkstep.validateSkipCondition", new Object[]{this.parentProcess.getName(), this.getName(), this.skipconditionCode});
        }
        WFJavaScript.parseJavaCode(this.skipconditionCode);
    }

    public void initJavaScriptObject() {
        if (this.wsjscript == null) {
            this.wsjscript = new WFJavaScript();
        }
    }

    private Vector getJavaScriptSlots(String jscode) {
        Vector dsUsed = null;
        if (jscode != null && jscode.trim().isEmpty()) {
            Vector ptDSNames = this.getParentProcess().getDataSlotNames();
            dsUsed = BLUtil.getJavaScriptSlots((String)jscode, (Vector)ptDSNames);
        }
        return dsUsed;
    }

    public void setPerformer(String p) {
        if (p.length() > BLControl.util.MAX_PERFORMER_SIZE) {
            throw new BizLogicException("BizLogic_ERR_666", "WFWorkstep::setPerformer", new Object[]{p, this.getName(), this.parentProcess.getName(), String.valueOf(BLControl.util.MAX_PERFORMER_SIZE)});
        }
        if (BLUtil.isJS((String)p)) {
            this.initJavaScriptObject();
            this.wsjscript.setPerformerFunction(BLUtil.getJS((String)p));
        } else if (!BLUtil.isValidHumanStepPerformer((String)p)) {
            throw new BizLogicException("BizLogic_ERR_600", "WFWorkstep.setPerformer", (Object[])new String[]{this.parentProcess.getName(), p, this.getName()});
        }
        this.hasPerformer = p;
    }

    public void setPreCondition(String precond) {
        this.precondition = precond;
    }

    public void setPreConditionType(int type) {
        this.preconditionType = type;
    }

    public void setPreFunction(String script, int preType) throws BizLogicException {
        Vector jsds;
        this.initJavaScriptObject();
        this.wsjscript.setPreFunction(script, preType);
        if (this.getParentProcess().getStatus() != -1 && (jsds = this.getJavaScriptSlots(script)) != null) {
            this.setPreJSReadDS(jsds);
        }
    }

    public void setPostFunction(String script, int postType) throws BizLogicException {
        Vector jsds;
        this.initJavaScriptObject();
        this.wsjscript.setPostFunction(script, postType);
        if (this.getParentProcess().getStatus() != -1 && (jsds = this.getJavaScriptSlots(script)) != null) {
            this.setPostJSReadDS(jsds);
        }
    }

    public void setRollbackPoint(boolean value) {
        block3: {
            block2: {
                int wstype = this.getType();
                if (wstype == 102) break block2;
                if (wstype == 107) break block2;
                if (wstype == 109) break block2;
                if (wstype == 110) break block2;
                if (wstype == 111) break block2;
                if (wstype == 112) break block2;
                if (wstype != 108) break block3;
            }
            this.rollbackPoint = value;
        }
    }

    public boolean isRollbackPoint() {
        return this.rollbackPoint;
    }

    public String getReactivateWorkStepName() {
        return this.reactivateWorkStepName;
    }

    public void setReactivateWorkStepName(String wsName) {
        if (wsName == null) {
            this.reactivateWorkStepName = wsName;
            return;
        }
        int n = this.parentProcess.getStatus();
        BLConstants.single();
        if (n == -1) {
            this.reactivateWorkStepName = wsName;
            return;
        }
        WFWorkstep wsObject = this.parentProcess.getWorkstep(wsName);
        if (wsObject.isRollbackPoint()) {
            this.reactivateWorkStepName = wsName;
            return;
        }
        throw new BizLogicException("BizLogic_ERR_2554", "WFWorkstep.setReactivateWorkStepName", new Object[]{this.parentProcess.getName(), this.getName(), wsName, wsName});
    }

    public void removeReactivateWorkStepName() {
        this.reactivateWorkStepName = null;
    }

    public Vector getDSCopyNames() {
        return this.dsCopyNames;
    }

    boolean hasDSCopies() {
        return this.dsCopyNames != null && !this.dsCopyNames.isEmpty();
    }

    public synchronized void setDSCopyNames(Vector dsNames) {
        if (!this.isRollbackPoint()) {
            throw new BizLogicException("BizLogic_ERR_1510", "WFWorkstep.setDSCopyNames", new Object[]{this.parentProcess.getName(), this.getName()});
        }
        if (dsNames == null || dsNames.isEmpty()) {
            this.dsCopyNames = null;
            return;
        }
        this.dsCopyNames = dsNames;
        if (BLControl.util.DEBUG_ENGINE && this.hasDSCopies()) {
            Vector sds = this.getDSCopyNames();
            BLControl.logger.debugKey("BizLogic_ERR_204", new Object[]{this.getName(), this.parentProcess.getName(), sds.toString()});
        }
    }

    public synchronized void setCompFunction(String compJScript, int compType) throws BizLogicException {
        if (this.wsjscript == null) {
            this.wsjscript = new WFJavaScript();
        }
        this.wsjscript.setCompFunction(compJScript, compType);
    }

    public String getCompFunction() {
        if (this.wsjscript != null) {
            return this.wsjscript.getCompFunction();
        }
        return null;
    }

    public int getCompFunctionType() {
        if (this.wsjscript != null) {
            return this.wsjscript.getCompFunctionType();
        }
        return -1;
    }

    public TimerActionList getOverDueAction() {
        return this.getOverDueAction(true);
    }

    public TimerActionList getOverDueAction(boolean includeJSScript) {
        if (this.timerActions == null) {
            return this.timerActions;
        }
        TimerActionList newTAList = new TimerActionList();
        int size = this.timerActions.getNumberOfEscalation();
        for (int i = 0; i < size; ++i) {
            TimerAction ta = this.timerActions.get(i);
            if (!includeJSScript) {
                TimerAction newta = ta.cloneActions();
                for (int j = 0; j < newta.getNumberOfActions(); ++j) {
                    HashMap hm = newta.getAction(j);
                    BLConstants.single();
                    if (!hm.containsKey("js:")) continue;
                    BLConstants.single();
                    hm.remove("js:");
                }
                newTAList.add(newta);
                continue;
            }
            newTAList.add(ta);
        }
        return newTAList;
    }

    public int getOverDueEscalationCount() {
        if (this.timerActions != null) {
            return this.timerActions.getNumberOfEscalation();
        }
        return -1;
    }

    public TimerAction getOverDueAction(int escalateLevel) {
        if (this.timerActions != null) {
            return this.timerActions.get(escalateLevel);
        }
        return null;
    }

    public void setOverDueAction(TimerActionList actions) {
        this.timerActions = actions;
    }

    public int getMaxOverDueTimes() {
        if (this.timerActions != null) {
            return this.timerActions.getNumberOfEscalation();
        }
        return 0;
    }

    public final boolean isCheckDue() {
        return this.getMaxOverDueTimes() > 0;
    }

    public boolean hasOverDueActions() {
        return this.timerActions != null && this.timerActions.getNumberOfEscalation() > 0;
    }

    public long getNextAndJoinWSID() {
        if (this.nextAndJoinWSID == null) {
            this.nextAndJoinWSID = -1L;
            Vector v = this.getNextWorksteps();
            WFWorkstep ws = null;
            for (int ix = 0; ix < v.size(); ++ix) {
                ws = (WFWorkstep)v.elementAt(ix);
                int n = ws.getType();
                BLConstants.single();
                if (n != 104) continue;
                this.nextAndJoinWSID = ws.getID();
            }
        }
        return this.nextAndJoinWSID;
    }

    public boolean isNextEndWS() {
        if (this.nextEndWSID == null) {
            this.nextEndWSID = -1L;
            Vector wsl = this.getNextWorksteps();
            WFWorkstep ws = null;
            for (int ix = 0; ix < wsl.size(); ++ix) {
                ws = (WFWorkstep)wsl.get(ix);
                int n = ws.getType();
                BLConstants.single();
                if (n != 101) continue;
                this.nextEndWSID = ws.getID();
            }
        }
        return this.nextEndWSID > 0L;
    }

    public void migration_setID(long id) {
        this.ID = id;
    }

    public void migration_setMilestone(String milestone) {
        this.milestoneName = milestone;
    }

    public void migration_setInstruction(String instruction) {
        this.instruction = instruction;
    }

    public String[] getOutLinkNames() {
        int itr;
        String[] out = new String[this.hasOutgoing.size()];
        WFLink link = null;
        for (itr = 0; itr < this.hasOutgoing.size(); ++itr) {
            link = (WFLink)this.hasOutgoing.elementAt(itr);
            out[itr] = link.getName();
        }
        for (itr = 0; itr < this.hasOutgoing.size(); ++itr) {
        }
        return out;
    }

    public String[] getInLinkNames() {
        int itr;
        String[] in = new String[this.hasIncoming.size()];
        WFLink link = null;
        for (itr = 0; itr < this.hasIncoming.size(); ++itr) {
            link = (WFLink)this.hasIncoming.elementAt(itr);
            in[itr] = link.getName();
        }
        for (itr = 0; itr < this.hasIncoming.size(); ++itr) {
        }
        return in;
    }

    private void setOutLinksByWorkstepAsc() {
        Vector out = new Vector();
        WFLink link = null;
        for (int itr = 0; itr < this.hasOutgoing.size(); ++itr) {
            link = (WFLink)this.hasOutgoing.elementAt(itr);
            this.putTargetLinkInPlace(out, link);
        }
        this.hasOutgoing = out;
    }

    private void setInLinksByWorkstepAsc() {
        Vector in = new Vector();
        WFLink link = null;
        for (int itr = 0; itr < this.hasIncoming.size(); ++itr) {
            link = (WFLink)this.hasIncoming.elementAt(itr);
            this.putSourceLinkInPlace(in, link);
        }
        this.hasIncoming = in;
    }

    private void putSourceLinkInPlace(Vector links, WFLink link) {
        WFLink fromLink = null;
        for (int itr = 0; itr < links.size(); ++itr) {
            fromLink = (WFLink)links.elementAt(itr);
            if (fromLink.getSource().getName().compareTo(link.getSource().getName()) <= 0) continue;
            links.add(itr, link);
            return;
        }
        links.add(link);
    }

    private void putTargetLinkInPlace(Vector links, WFLink link) {
        WFLink toLink = null;
        for (int itr = 0; itr < links.size(); ++itr) {
            toLink = (WFLink)links.elementAt(itr);
            if (toLink.getTarget().getName().compareTo(link.getTarget().getName()) <= 0) continue;
            links.add(itr, link);
            return;
        }
        links.add(link);
    }

    public void setInputSlotMappings(DataSlotMappingList dsList) {
        this.inputDSMapping = dsList;
    }

    public void setOutputSlotMappings(DataSlotMappingList dsList) {
        this.outputDSMapping = dsList;
    }

    public DataSlotMappingList getInputDataSlotMapping() {
        if (this.inputDSMapping == null) {
            ArrayList<DataSlotMapping> list = new ArrayList<DataSlotMapping>();
            for (String dsName : this.inputSlots.keySet()) {
                String mappedName = (String)this.inputSlots.get(dsName);
                list.add(new DataSlotMapping(dsName, mappedName, false));
            }
            this.inputDSMapping = new DataSlotMappingList(list);
        }
        return this.inputDSMapping;
    }

    public DataSlotMappingList getOutputDataSlotMapping() {
        if (this.outputDSMapping == null) {
            ArrayList<DataSlotMapping> list = new ArrayList<DataSlotMapping>();
            for (String dsName : this.outputSlots.keySet()) {
                String mappedName = (String)this.outputSlots.get(dsName);
                list.add(new DataSlotMapping(dsName, mappedName, false));
            }
            this.outputDSMapping = new DataSlotMappingList(list);
        }
        return this.outputDSMapping;
    }

    public void fillDataslotMappingInfo() {
        WFWorkstep.fillDataslotMappingInfo(this.getParentProcess(), this.getInputDataSlotMapping());
        WFWorkstep.fillDataslotMappingInfo(this.getParentProcess(), this.getOutputDataSlotMapping());
    }

    public static void fillDataslotMappingInfo(WFProcess pt, DataSlotMappingList dsMappingList) {
        String[] dsNames = dsMappingList.getDataSlotNames();
        for (int ix = 0; ix < dsNames.length; ++ix) {
            String dsName = dsNames[ix];
            WFDataslot ds = pt.getDataslot(dsName, true);
            DataSlotMapping dsMapping = dsMappingList.getMapping(dsName);
            if (ds != null) {
                dsMapping.setType(ds.getType());
                if (ds.isObject()) {
                    dsMapping.setStorageClass(ds.getJavaClassName());
                    continue;
                }
                if (!ds.isCollection()) continue;
                dsMapping.setStorageClass(ds.getStorageFormat());
                continue;
            }
            dsMapping.setType("STRING");
        }
    }

    public void setMappedDuration(String duration) {
        this.mappedDuration = duration;
    }

    public String getMappedDuration() {
        return this.mappedDuration;
    }

    public boolean hasMappedDuration() {
        return this.mappedDuration != null && !this.mappedDuration.trim().isEmpty();
    }

    public final String getSkipCondition() {
        return this.skipcondition;
    }

    public final String getSkipConditionCode() {
        return this.skipconditionCode;
    }

    public final int getSkipConditionType() {
        return this.skipconditionType;
    }

    public final String getLoopCondition() {
        return this.loopCondition;
    }

    public final String getLoopConditionCode() {
        return this.loopConditionCode;
    }

    public final int getLoopConditionType() {
        return this.loopConditionType;
    }

    public boolean hasDocumentDS() {
        String[] dsNames = this.getSlotKeys();
        if (dsNames == null || dsNames.length == 0) {
            return false;
        }
        for (int ix = 0; ix < dsNames.length; ++ix) {
            WFDataslot ds = this.getDataslot(dsNames[ix]);
            if (!ds.getType().equalsIgnoreCase("DOCUMENT")) continue;
            return true;
        }
        return false;
    }

    public boolean hasAlerts() {
        if (this.hasOverdueAlerts()) {
            return true;
        }
        return this.alertNamesForState != null;
    }

    public boolean hasAlerts(int state) {
        return this.alertNamesForState != null && this.alertNamesForState.get(state) != null;
    }

    public boolean hasOverdueAlerts() {
        for (int i = 0; i < this.getOverDueEscalationCount(); ++i) {
            TimerAction ta = this.getOverDueAction(i);
            Vector actions = ta.getAction();
            for (Object obj : actions) {
                HashMap actionMap = (HashMap)obj;
                BLConstants.single();
                String actionName = (String)actionMap.get("ACTION_NAME");
                if (actionName == null) continue;
                BLConstants.TAConstants cfr_ignored_0 = BLConstants.single().ta;
                if (!actionName.equals("SEND_ALERTS")) continue;
                return true;
            }
        }
        return false;
    }

    public void setAlertNamesForState(Map<Integer, ArrayList<String>> wsAlertNames) {
        this.alertNamesForState = wsAlertNames;
    }

    public Map<Integer, ArrayList<String>> getAlertNamesForState() {
        return this.alertNamesForState;
    }

    public ArrayList<String> getAlertNames(int state) {
        if (this.alertNamesForState != null) {
            return this.alertNamesForState.get(state);
        }
        return null;
    }

    protected void setMonitorStep(boolean isMonitorStep) {
        this.isMonitorStep = isMonitorStep;
    }

    public boolean isMonitorStep() {
        return this.isMonitorStep;
    }

    void setActivationLimit(int activationLimit) {
        this.activationLimit = activationLimit;
    }

    public boolean isWaitForActivateEvent() {
        return this.waitForActivateEvent;
    }

    void setWaitForActivateEvent(boolean waitForActivateEvent) {
        this.waitForActivateEvent = waitForActivateEvent;
    }

    public void setSMSAlertNames(Set<String> smsAlertName) {
        this.smsAlertName = smsAlertName;
    }

    public Set<String> getSMSAlertNames() {
        return this.smsAlertName;
    }
}

