/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.dao;

import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class DebugServiceDAO
extends BLDAOService {
    private static final String BIZLOGIC_DEBUG_WORKSTEP = "BIZLOGIC_DEBUG_WORKSTEP";
    private static final String BIZLOGIC_DEBUG_PI = "BIZLOGIC_DEBUG_PI";
    public static final String PROCESS_INSTANCE_ID = "PROCESS_INSTANCE_ID";
    public static final String WORKSTEP_ID = "WORKSTEP_ID";
    public static final String WORKSTEP_NAME = "WORKSTEP_NAME";
    public static final String LOOPCOUNTER = "LOOPCOUNTER";
    public static final String BREAKPOINT_STATE = "BREAKPOINT_STATE";
    public static final String PI_DEBUG_STATUS = "PI_DEBUG_STATUS";
    private static final String[] INSERT_PI_LIST = new String[]{"PROCESS_INSTANCE_ID", "PI_DEBUG_STATUS"};
    private static final String[] INSERT_WS_LIST = new String[]{"PROCESS_INSTANCE_ID", "WORKSTEP_ID", "WORKSTEP_NAME", "LOOPCOUNTER", "BREAKPOINT_STATE"};
    public static String insertDebugInfo;
    public static String getByPI;
    public static String removeWS;
    public static String removeByPI;
    public static String loadPIStatus;
    public static String storePIStatus;
    public static String removePIStatus;
    public static String isExistWS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertDebugWSEntry(HashMap<String, Object> attrs) {
        Connection conn = null;
        PreparedStatement pstmtInsertDebugInfo = null;
        try {
            conn = DebugServiceDAO.getConnection();
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1207", "DebugServiceDAO.insertDebugWSEntry(attrs)", new Object[]{insertDebugInfo, attrs});
            }
            pstmtInsertDebugInfo = conn.prepareStatement(insertDebugInfo);
            String key = null;
            Object value = null;
            for (int i = 0; i < INSERT_WS_LIST.length; ++i) {
                key = INSERT_WS_LIST[i];
                value = attrs.get(key);
                if (key.equals(WORKSTEP_ID) || key.equals(PROCESS_INSTANCE_ID)) {
                    if (value == null) {
                        pstmtInsertDebugInfo.setNull(i + 1, -5);
                        continue;
                    }
                    pstmtInsertDebugInfo.setLong(i + 1, (Long)value);
                    continue;
                }
                if (key.equals(WORKSTEP_NAME)) {
                    if (value == null) {
                        pstmtInsertDebugInfo.setNull(i + 1, 12);
                        continue;
                    }
                    pstmtInsertDebugInfo.setString(i + 1, (String)value);
                    continue;
                }
                if (!key.equals(LOOPCOUNTER) && !key.equals(BREAKPOINT_STATE)) continue;
                if (value == null) {
                    pstmtInsertDebugInfo.setNull(i + 1, 4);
                    continue;
                }
                pstmtInsertDebugInfo.setInt(i + 1, (Integer)value);
            }
            pstmtInsertDebugInfo.execute();
        }
        catch (SQLException e) {
            try {
                DebugServiceDAO.handle((Throwable)e, (String)("DebugServiceDAO.insertDebugWSEntry() attrs : " + attrs));
            }
            catch (Throwable throwable) {
                DebugServiceDAO.clean(null, pstmtInsertDebugInfo, (Connection)conn);
                throw throwable;
            }
            DebugServiceDAO.clean(null, (Statement)pstmtInsertDebugInfo, (Connection)conn);
        }
        DebugServiceDAO.clean(null, (Statement)pstmtInsertDebugInfo, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDebugWSEntry(long piid, long wsid, int loopCounter, int status) {
        Connection conn = null;
        PreparedStatement pstmtRemoveWS = null;
        try {
            conn = DebugServiceDAO.getConnection();
            if (BLControl.util.DEBUG_DAO) {
                String debugStr = "<" + piid + ", " + wsid + ", " + loopCounter + ", " + status + ">";
                BLControl.logger.debugKey("BizLogic_ERR_1207", "DebugServiceDAO.removeDebugWSEntry(piid, wsid, loopCounter, status)", new Object[]{removeWS, debugStr});
            }
            pstmtRemoveWS = conn.prepareStatement(removeWS);
            pstmtRemoveWS.setLong(1, piid);
            pstmtRemoveWS.setLong(2, wsid);
            pstmtRemoveWS.setInt(3, loopCounter);
            pstmtRemoveWS.setInt(4, status);
            pstmtRemoveWS.execute();
        }
        catch (SQLException e) {
            try {
                DebugServiceDAO.handle((Throwable)e, (String)("DebugServiceDAO.removeDebugWSEntry() piid : " + piid + " wsid : " + wsid + " loopcounter : " + loopCounter + " status : " + status));
            }
            catch (Throwable throwable) {
                DebugServiceDAO.clean(null, pstmtRemoveWS, (Connection)conn);
                throw throwable;
            }
            DebugServiceDAO.clean(null, (Statement)pstmtRemoveWS, (Connection)conn);
        }
        DebugServiceDAO.clean(null, (Statement)pstmtRemoveWS, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isExistDebugWSEntry(long piid, long wsid, int loopCounter, int status) {
        ResultSet rs;
        PreparedStatement pstmtIsExistWS;
        Connection conn;
        boolean exists;
        block5: {
            exists = false;
            conn = null;
            pstmtIsExistWS = null;
            rs = null;
            try {
                conn = DebugServiceDAO.getConnection();
                if (BLControl.util.DEBUG_DAO) {
                    String debugStr = "<" + piid + ", " + wsid + ", " + loopCounter + ", " + status + ">";
                    BLControl.logger.debugKey("BizLogic_ERR_1207", "DebugServiceDAO.isExistDebugWSEntry(piid, wsid, loopCounter, status)", new Object[]{isExistWS, debugStr});
                }
                pstmtIsExistWS = conn.prepareStatement(isExistWS);
                pstmtIsExistWS.setLong(1, piid);
                pstmtIsExistWS.setLong(2, wsid);
                pstmtIsExistWS.setInt(3, loopCounter);
                pstmtIsExistWS.setInt(4, status);
                rs = pstmtIsExistWS.executeQuery();
                if (!rs.next()) break block5;
                exists = true;
            }
            catch (SQLException sQLException) {
                DebugServiceDAO.clean(rs, pstmtIsExistWS, (Connection)conn);
                catch (Throwable throwable) {
                    DebugServiceDAO.clean(rs, pstmtIsExistWS, (Connection)conn);
                    throw throwable;
                }
            }
        }
        DebugServiceDAO.clean((ResultSet)rs, (Statement)pstmtIsExistWS, (Connection)conn);
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getDebugWSEntryByPI(long piid) {
        HashMap<String, Long> wsNamesIDMap = new HashMap<String, Long>();
        Connection conn = null;
        PreparedStatement pstmtGetByPI = null;
        ResultSet rs = null;
        try {
            conn = DebugServiceDAO.getConnection();
            if (BLControl.util.DEBUG_DAO) {
                String debugStr = "<" + piid + ">";
                BLControl.logger.debugKey("BizLogic_ERR_1207", "DebugServiceDAO.getDebugWSEntryByPI(piid)", new Object[]{getByPI, debugStr});
            }
            pstmtGetByPI = conn.prepareStatement(getByPI);
            pstmtGetByPI.setLong(1, piid);
            rs = pstmtGetByPI.executeQuery();
            while (rs.next()) {
                String wsName = rs.getString(WORKSTEP_NAME);
                wsNamesIDMap.put(wsName, rs.getLong(WORKSTEP_ID));
            }
        }
        catch (SQLException e) {
            try {
                DebugServiceDAO.handle((Throwable)e, (String)("DebugServiceDAO.getDebugWSEntryByPI() piid " + piid));
            }
            catch (Throwable throwable) {
                DebugServiceDAO.clean(rs, pstmtGetByPI, (Connection)conn);
                throw throwable;
            }
            DebugServiceDAO.clean((ResultSet)rs, (Statement)pstmtGetByPI, (Connection)conn);
        }
        DebugServiceDAO.clean((ResultSet)rs, (Statement)pstmtGetByPI, (Connection)conn);
        return wsNamesIDMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDebugWSEntryByPI(long piid) {
        Connection conn = null;
        PreparedStatement pstmtRemoveByPI = null;
        try {
            conn = DebugServiceDAO.getConnection();
            if (BLControl.util.DEBUG_DAO) {
                String debugStr = "<" + piid + ">";
                BLControl.logger.debugKey("BizLogic_ERR_1207", "DebugServiceDAO.removeDebugWSEntryByPI(piid)", new Object[]{removeByPI, debugStr});
            }
            pstmtRemoveByPI = conn.prepareStatement(removeByPI);
            pstmtRemoveByPI.setLong(1, piid);
            pstmtRemoveByPI.execute();
        }
        catch (SQLException e) {
            try {
                DebugServiceDAO.handle((Throwable)e, (String)("DebugServiceDAO.removeDebugWSEntryByPI() piid : " + piid));
            }
            catch (Throwable throwable) {
                DebugServiceDAO.clean(null, pstmtRemoveByPI, (Connection)conn);
                throw throwable;
            }
            DebugServiceDAO.clean(null, (Statement)pstmtRemoveByPI, (Connection)conn);
        }
        DebugServiceDAO.clean(null, (Statement)pstmtRemoveByPI, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<Long, Boolean> loadDebugInstanceEntry() {
        HashMap<Long, Boolean> piIDStatusMap = new HashMap<Long, Boolean>();
        Connection conn = null;
        PreparedStatement pstmtLoadPIStatus = null;
        ResultSet rs = null;
        try {
            conn = DebugServiceDAO.getConnection();
            if (BLControl.util.DEBUG_DAO) {
                String debugStr = "<>";
                BLControl.logger.debugKey("BizLogic_ERR_1207", "DebugServiceDAO.loadDebugInstanceEntry()", new Object[]{loadPIStatus, debugStr});
            }
            pstmtLoadPIStatus = conn.prepareStatement(loadPIStatus);
            rs = pstmtLoadPIStatus.executeQuery();
            while (rs.next()) {
                long piid = rs.getLong(PROCESS_INSTANCE_ID);
                int temp = rs.getInt(PI_DEBUG_STATUS);
                boolean status = false;
                if (temp == 1) {
                    status = true;
                }
                piIDStatusMap.put(piid, status);
            }
        }
        catch (SQLException e) {
            try {
                DebugServiceDAO.handle((Throwable)e, (String)"DebugServiceDAO.loadDebugInstanceEntry() ");
            }
            catch (Throwable throwable) {
                DebugServiceDAO.clean(rs, pstmtLoadPIStatus, (Connection)conn);
                throw throwable;
            }
            DebugServiceDAO.clean(rs, (Statement)pstmtLoadPIStatus, (Connection)conn);
        }
        DebugServiceDAO.clean((ResultSet)rs, (Statement)pstmtLoadPIStatus, (Connection)conn);
        return piIDStatusMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDebugInstanceEntry(long piid, boolean status) {
        Connection conn = null;
        PreparedStatement pstmtStorePIStatus = null;
        try {
            conn = DebugServiceDAO.getConnection();
            if (BLControl.util.DEBUG_DAO) {
                String debugStr = "" + piid + ":" + status;
                BLControl.logger.debugKey("BizLogic_ERR_1207", "DebugServiceDAO.createDebugInstanceEntry(piid, status)", new Object[]{storePIStatus, debugStr});
            }
            pstmtStorePIStatus = conn.prepareStatement(storePIStatus);
            pstmtStorePIStatus.setLong(1, piid);
            if (status) {
                pstmtStorePIStatus.setInt(2, 1);
            } else {
                pstmtStorePIStatus.setInt(2, 0);
            }
            pstmtStorePIStatus.execute();
        }
        catch (SQLException e) {
            try {
                DebugServiceDAO.handle((Throwable)e, (String)("DebugServiceDAO.createDebugInstanceEntry() piid : " + piid + " status : " + status));
            }
            catch (Throwable throwable) {
                DebugServiceDAO.clean(null, pstmtStorePIStatus, (Connection)conn);
                throw throwable;
            }
            DebugServiceDAO.clean(null, (Statement)pstmtStorePIStatus, (Connection)conn);
        }
        DebugServiceDAO.clean(null, (Statement)pstmtStorePIStatus, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDebugInstanceEntry(long piid) {
        Connection conn = null;
        PreparedStatement pstmtRemovePIStatus = null;
        try {
            conn = DebugServiceDAO.getConnection();
            if (BLControl.util.DEBUG_DAO) {
                String debugStr = "<" + piid + ">";
                BLControl.logger.debugKey("BizLogic_ERR_1207", "DebugServiceDAO.removeDebugInstanceEntry(piid)", new Object[]{removePIStatus, debugStr});
            }
            pstmtRemovePIStatus = conn.prepareStatement(removePIStatus);
            pstmtRemovePIStatus.setLong(1, piid);
            pstmtRemovePIStatus.execute();
        }
        catch (SQLException e) {
            try {
                DebugServiceDAO.handle((Throwable)e, (String)("DebugServiceDAO.removeDebugInstanceEntry() piid : " + piid));
            }
            catch (Throwable throwable) {
                DebugServiceDAO.clean(null, pstmtRemovePIStatus, (Connection)conn);
                throw throwable;
            }
            DebugServiceDAO.clean(null, (Statement)pstmtRemovePIStatus, (Connection)conn);
        }
        DebugServiceDAO.clean(null, (Statement)pstmtRemovePIStatus, (Connection)conn);
    }

    public static synchronized void initSQLStatements() {
        int ix;
        StringBuffer buff = new StringBuffer(100);
        buff.append("INSERT INTO ");
        buff.append(BIZLOGIC_DEBUG_WORKSTEP);
        DebugServiceDAO.addRowlockHint((StringBuffer)buff);
        buff.append(" (");
        for (ix = 0; ix < INSERT_WS_LIST.length; ++ix) {
            buff.append(INSERT_WS_LIST[ix]);
            if (ix == INSERT_WS_LIST.length - 1) continue;
            buff.append(", ");
        }
        buff.append(") values (");
        for (ix = 0; ix < INSERT_WS_LIST.length; ++ix) {
            buff.append("?");
            if (ix == INSERT_WS_LIST.length - 1) continue;
            buff.append(", ");
        }
        buff.append(")");
        insertDebugInfo = buff.toString();
        buff = new StringBuffer(50);
        buff.append("SELECT ").append(PROCESS_INSTANCE_ID).append(" , ");
        buff.append(PI_DEBUG_STATUS).append(" FROM ");
        buff.append(BIZLOGIC_DEBUG_PI);
        DebugServiceDAO.addRowlockHint((StringBuffer)buff);
        loadPIStatus = buff.toString();
        buff = new StringBuffer(100);
        buff.append("INSERT INTO ").append(BIZLOGIC_DEBUG_PI);
        DebugServiceDAO.addRowlockHint((StringBuffer)buff);
        buff.append(" (");
        for (ix = 0; ix < INSERT_PI_LIST.length; ++ix) {
            buff.append(INSERT_PI_LIST[ix]);
            if (ix == INSERT_PI_LIST.length - 1) continue;
            buff.append(", ");
        }
        buff.append(") values (");
        for (ix = 0; ix < INSERT_PI_LIST.length; ++ix) {
            buff.append("?");
            if (ix == INSERT_PI_LIST.length - 1) continue;
            buff.append(", ");
        }
        buff.append(")");
        storePIStatus = buff.toString();
        buff = new StringBuffer(50);
        buff.append("DELETE FROM ").append(BIZLOGIC_DEBUG_PI);
        buff.append(" WHERE ").append(PROCESS_INSTANCE_ID).append(" = ? ");
        removePIStatus = buff.toString();
        buff = new StringBuffer(50);
        buff.append("SELECT ").append(WORKSTEP_NAME).append(" , ");
        buff.append(WORKSTEP_ID);
        buff.append(" FROM ").append(BIZLOGIC_DEBUG_WORKSTEP);
        DebugServiceDAO.addRowlockHint((StringBuffer)buff);
        buff.append(" WHERE ").append(PROCESS_INSTANCE_ID);
        buff.append(" = ? ");
        getByPI = buff.toString();
        buff = new StringBuffer(50);
        buff.append("DELETE FROM ").append(BIZLOGIC_DEBUG_WORKSTEP);
        buff.append(" WHERE ");
        buff.append(PROCESS_INSTANCE_ID).append(" = ? AND ");
        buff.append(WORKSTEP_ID).append(" = ? AND ");
        buff.append(LOOPCOUNTER).append(" = ? AND ");
        buff.append(BREAKPOINT_STATE).append(" = ?");
        removeWS = buff.toString();
        buff = new StringBuffer(50);
        buff.append("SELECT ").append(WORKSTEP_ID);
        buff.append(" FROM ").append(BIZLOGIC_DEBUG_WORKSTEP);
        DebugServiceDAO.addRowlockHint((StringBuffer)buff);
        buff.append(" WHERE ");
        buff.append(PROCESS_INSTANCE_ID).append(" = ? AND ");
        buff.append(WORKSTEP_ID).append(" = ? AND ");
        buff.append(LOOPCOUNTER).append(" = ? AND ");
        buff.append(BREAKPOINT_STATE).append(" = ?");
        isExistWS = buff.toString();
        buff = new StringBuffer(50);
        buff.append("DELETE FROM ").append(BIZLOGIC_DEBUG_WORKSTEP);
        buff.append(" WHERE ").append(PROCESS_INSTANCE_ID).append(" = ? ");
        removeByPI = buff.toString();
        DebugServiceDAO.printSQLStatements();
    }

    private static void printSQLStatements() {
        if (BLControl.util.DEBUG_DAO) {
            BLControl.logger.debug((Object)"DebugServiceDAO:");
            BLControl.logger.debugKey("BizLogic_ERR_1199", insertDebugInfo, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", loadPIStatus, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", storePIStatus, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removePIStatus, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getByPI, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeWS, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", isExistWS, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeByPI, new Object[0]);
        }
    }
}

