/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.ejb;

import com.savvion.sbm.bizlogic.server.WFWebServiceInstance;
import com.savvion.sbm.bizlogic.server.WSDLManager;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.MDBAdapter;
import com.savvion.sbm.util.TransactionService;
import com.savvion.sbm.util.logger.SBMLogger;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.transaction.UserTransaction;

public class BLWebServiceMDB
extends MDBAdapter {
    public void onMessage(Message jmsg) {
        block12: {
            if ((BLControl.isServerNotReady() || BLControl.util == null) && !WFWebServiceInstance.self().processMessage(jmsg)) {
                return;
            }
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debug((Object)("Active BLWebServiceMDB handling:" + jmsg));
            }
            UserTransaction ut = null;
            HashMap props = null;
            try {
                if (jmsg.getJMSRedelivered()) {
                    return;
                }
                if (!(jmsg instanceof TextMessage)) {
                    this.log(BLControl.logger, "BLWebServiceMDB.onMessage():Ignored message " + jmsg);
                    return;
                }
                props = (HashMap)BLUtil.getMap((Message)((TextMessage)jmsg));
                if (BLControl.util.DEBUG_ENGINE) {
                    this.printDebug(props, "processing message from(pi:ws): ");
                }
            }
            catch (Throwable th) {
                BLControl.logger.error((Object)("JMS message sent to BLWebServiceMDB contains invalid properties:" + jmsg.toString()));
            }
            ut = this.mdc.getUserTransaction();
            try {
                ut.begin();
                try {
                    WSDLManager.invoke(props);
                    if (BLControl.util.DEBUG_ENGINE) {
                        this.printDebug(props, "BLWebServiceMDB successfully completed");
                    }
                }
                catch (BizLogicException th) {
                    // empty catch block
                }
                ut.commit();
            }
            catch (Throwable th) {
                if (ut == null) break block12;
                TransactionService.rollback((UserTransaction)ut, (SBMLogger)BLControl.logger);
            }
        }
    }

    private final void printDebug(Map props, String msg) {
        BLControl.logger.debug((Object)(msg + " for PI:" + (Long)props.get("PROCESSINSTANCEID") + " WS:" + (Long)props.get("WORKSTEPID")));
    }
}

