/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BizLogicClientException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

public class VoteCriteria
implements Serializable {
    static final long serialVersionUID = -8749756234558009112L;
    private HashMap attributes = null;
    public static final String PROCESSTEMPLATEID;
    public static final String WORKSTEPID;
    public static final String TYPE = "TYPE";
    public static final String EXPECTED_COUNT = "EXPECTED_COUNT";
    public static final String MAJORITYDS = "MAJORITYDS";
    public static final String MAJORITYDS_TYPE = "MAJORITYDS_TYPE";
    public static final String RESULTDS = "RESULTDS";
    public static final String CHOICES = "CHOICES";
    public static final String MAPPEDCHOICES = "MAPPEDCHOICES";
    private static final String DELIM = ",";

    public VoteCriteria(HashMap attrs) throws BizLogicClientException {
        if (attrs == null) {
            throw new BizLogicClientException("BizLogic_ERR_6022", (Object)"VoteCriteria.<init>");
        }
        this.attributes = attrs;
    }

    public HashMap getAttributes() {
        return this.attributes;
    }

    public boolean hasVoteChoices() {
        return this.getChoices() != null && !this.getChoices().isEmpty();
    }

    public int getExpectedCount() {
        return (Integer)this.attributes.get(EXPECTED_COUNT);
    }

    public int getVoteType() {
        return (Integer)this.attributes.get(TYPE);
    }

    public String getStringVoteType() {
        if (this.isPercentage()) {
            BLConstants.single();
            return "PERCENTAGE";
        }
        BLConstants.single();
        return "NUMERIC";
    }

    public boolean isPercentage() {
        int n = this.getVoteType();
        BLConstants.single();
        return n == 2;
    }

    public String getMajorityDataSlotName() {
        return (String)this.attributes.get(MAJORITYDS);
    }

    public String getMajorityDataSlotType() {
        return (String)this.attributes.get(MAJORITYDS_TYPE);
    }

    public String getResultDataSlotName() {
        return (String)this.attributes.get(RESULTDS);
    }

    public List getChoices() {
        return (List)this.attributes.get(CHOICES);
    }

    public String getStringChoices() {
        List choices = this.getChoices();
        if (choices == null || choices.isEmpty()) {
            return null;
        }
        StringBuilder str = new StringBuilder(50);
        for (int ix = 0; ix < choices.size(); ++ix) {
            str.append(choices.get(ix).toString());
            if (ix >= choices.size() - 1) continue;
            str.append(DELIM);
        }
        return str.toString();
    }

    public boolean isMappedChoices() {
        return (Boolean)this.attributes.get(MAPPEDCHOICES);
    }

    static {
        BLConstants.single();
        PROCESSTEMPLATEID = "PROCESSTEMPLATEID";
        BLConstants.single();
        WORKSTEPID = "WORKSTEPID";
    }
}

