/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.smp.core;

import com.savvion.sbm.bizlogic.enums.BLLockContext;
import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.WFDataSlotInstance;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFProcessInstance;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.WFWorkstepInstance;
import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceEBLocal;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceEBLocal;
import com.savvion.sbm.bizlogic.smp.core.EventUtil;
import com.savvion.sbm.bizlogic.smp.model.BLExternalEvent;
import com.savvion.sbm.bizlogic.smp.util.MPUtil;
import com.savvion.sbm.bizlogic.smp.util.MonitoringProcessException;
import com.savvion.sbm.bizlogic.smp.util.SMPConfig;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.util.BMBootProps;
import com.savvion.sbm.util.SBMUtil;
import java.util.HashMap;
import java.util.Map;

public class EventProcessor {
    private static final String BM_MPSH048 = "BM_MPSH048";
    private static final String BM_MPSH035 = "BM_MPSH035";
    private static final String BM_MPSH046 = "BM_MPSH046";
    private static final String BM_MPSH315 = "BM_MPSH315";
    private static final String EVENT_PROCESSOR_COMPLETE_WORK_STEP = "EventProcessor.completeWorkStep()";
    private static final String MONITOR_ADAPTER = "MONITOR_ADAPTER";
    private static EventProcessor self = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventProcessor self() {
        if (self != null) return self;
        Class<EventProcessor> clazz = EventProcessor.class;
        synchronized (EventProcessor.class) {
            if (self != null) return self;
            self = new EventProcessor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return self;
        }
    }

    public void processEvent(BLExternalEvent event, WFProcessContext paramPCtx) {
        this.validateEvent(event);
        if (event.getOperationType().isCreateInstance()) {
            this.validateCreateInstanceEvent(event);
            MPUtil.handleProcessedEvent(event);
            this.createInstance(event);
        } else if (event.getOperationType().isActivateWorkstep()) {
            WFProcessContext processContext = this.findProcessInstanceId(event, paramPCtx);
            long wsid = this.findWorkstepId(event, processContext);
            processContext.lockRootOrInstanceDS(BLLockContext.WS, "EventProcessor.processEvent:ActivateWorkstep", wsid);
            this.validateWSEvent(event, wsid, processContext);
            MPUtil.handleProcessedEvent(event);
            this.activateWorkStep(event, processContext);
        } else if (event.getOperationType().isCompleteWorkstep()) {
            WFProcessContext processContext = this.findProcessInstanceId(event, paramPCtx);
            long wsid = this.findWorkstepId(event, processContext);
            processContext.lockRootOrInstanceDS(BLLockContext.WS, "EventProcessor.processEvent:CompleteWorkstep", wsid);
            this.validateWSEvent(event, wsid, processContext);
            MPUtil.handleProcessedEvent(event);
            this.completeWorkStep(event, processContext);
        } else if (event.getOperationType().isUpdateDataslot()) {
            WFProcessContext processContext = this.findProcessInstanceId(event, paramPCtx);
            processContext.lockRootOrInstanceDS(BLLockContext.PIDS, "EventProcessor.processEvent:UpdateDataslot", new Object[0]);
            this.validateUpdateDSEvent(event, processContext);
            MPUtil.handleProcessedEvent(event);
            this.updateDataSlot(event);
        } else {
            throw EventUtil.createInvalidEventDataEx("BM_MPSH014", "EventProcessor.processEvent()", new Object[]{event.getOperationType(), MPUtil.getEventCtx(event)});
        }
        EventUtil.logDebug("BM_MPSH040", "EventProcessor.processEvent()", MPUtil.getEventCtx(event));
    }

    public void processExtEventFromBL(BLExternalEvent event, WFProcessContext pCtx) {
        if (null == pCtx) {
            throw (MonitoringProcessException)((Object)EventUtil.getMonitoringProcessES().createException("BM_MPSH310", "EventProcessor.processExtEventFromBL()", new Object[]{MPUtil.getEventCtx(event)}));
        }
        this.processEvent(event, pCtx);
    }

    private void validateEvent(BLExternalEvent event) {
        if (event == null) {
            throw (MonitoringProcessException)((Object)EventUtil.getMonitoringProcessES().createException("BM_MPSH015", "EventProcessor.validateEvent()"));
        }
        String ptName = event.getProcessName();
        if (!ProcessControl.isProcessTemplateExist(ptName)) {
            throw EventUtil.createInvalidEventDataEx("BM_MPSH004", "EventProcessor.validateEvent()", ptName, MPUtil.getEventCtx(event));
        }
        WFProcess ptObj = ProcessControl.getProcessTemplate(ptName);
        if (event.getOperationType().isCreateInstance() && !ptObj.isActivated()) {
            throw EventUtil.createInvalidEventDataEx("BM_MPSH007", "EventProcessor.validateEvent()", ptName, MPUtil.getEventCtx(event));
        }
    }

    private void validateCreateInstanceEvent(BLExternalEvent event) {
        String ptName = event.getProcessName();
        WFProcess ptObj = ProcessControl.getProcessTemplate(ptName);
        if (ptObj.isMonitoringProcess()) {
            String eiId = event.getExternalInstanceId();
            if (ptObj.isMonitorDSMappedToPIID()) {
                if (eiId != null && SMPConfig.self().logWarningMessage()) {
                    EventUtil.getLogger().warnKey("BM_MPSH044", "EventProcessor.validateCreateInstanceEvent()", new Object[]{eiId, MPUtil.getEventCtx(event)});
                }
                return;
            }
            if (!MPUtil.isValidString(eiId)) {
                throw EventUtil.createInvalidEventDataEx("BM_MPSH005", "EventProcessor.validateCreateInstanceEvent()", eiId, MPUtil.getEventCtx(event));
            }
            if (!EventUtil.isUniqueExternalInstanceId(ptName, ptObj.getMonitorDSName(), eiId)) {
                throw EventUtil.createInvalidEventDataEx("BM_MPSH006", "EventProcessor.validateCreateInstanceEvent()", eiId, MPUtil.getEventCtx(event));
            }
        }
    }

    private void createInstance(BLExternalEvent event) {
        Map<String, Object> invalidDS;
        HashMap<Object, Object> dsValues = null;
        String ptName = event.getProcessName();
        HashMap piAttrs = new HashMap();
        String priority = event.getPriority();
        WFProcess ptObj = ProcessControl.getProcessTemplate(ptName);
        if (SBMUtil.self().isValidPriority(priority)) {
            BLConstants.single();
            piAttrs.put("PRIORITY", event.getPriority());
        } else {
            BLConstants.single();
            piAttrs.put("PRIORITY", SBMUtil.self().getDefaultPriority());
            EventUtil.logDebug("BM_MPSH010", "EventProcessor.createInstance()", priority, SBMUtil.self().getDefaultPriority());
        }
        if (MPUtil.isValidString(event.getPerformer())) {
            if (!ptObj.isMonitoringProcess() && MPUtil.isDebug()) {
                EventUtil.logDebug("BM_MPSH302", "EventProcessor.createInstance()", event.getPerformer(), MPUtil.getEventCtx(event));
            }
            BLConstants.single();
            piAttrs.put("CREATOR", event.getPerformer());
        } else {
            BLConstants.single();
            piAttrs.put("CREATOR", BMBootProps.self().getUser());
            if (ptObj.isMonitoringProcess()) {
                if (MPUtil.isDebug()) {
                    EventUtil.logDebug("BM_MPSH016", "EventProcessor.createInstance()", event.getPerformer(), MPUtil.getEventCtx(event), BMBootProps.self().getUser());
                }
            } else if (SMPConfig.self().logWarningMessage()) {
                EventUtil.getLogger().warnKey("BM_MPSH016", "EventProcessor.createInstance()", new Object[]{event.getPerformer(), MPUtil.getEventCtx(event), BMBootProps.self().getUser()});
            }
        }
        if (MPUtil.isValidString(event.getInstanceAlias())) {
            BLConstants.single();
            piAttrs.put("PROCESSINSTANCENAME", event.getInstanceAlias());
        }
        dsValues = !event.containsEventData() ? new HashMap() : new HashMap<String, Object>(event.getEventData());
        if (MPUtil.isDebug()) {
            EventUtil.getLogger().debugKey("BM_MPSH308", "EventProcessor.createInstance()", new Object[]{dsValues, MPUtil.getEventCtx(event)});
        }
        if ((invalidDS = EventUtil.removeInvalidDataslots(ptObj, dsValues)) != null && !invalidDS.isEmpty()) {
            EventUtil.getLogger().infoKey("BM_MPSH011", "EventProcessor.createInstance()", new Object[]{invalidDS, MPUtil.getEventCtx(event)});
        }
        if (ptObj.isMonitoringProcess()) {
            if (!ptObj.isMonitorDSMappedToPIID()) {
                dsValues.put(ptObj.getMonitorDSName(), event.getExternalInstanceId());
            }
        } else if (MPUtil.isDebug()) {
            EventUtil.getLogger().debugKey("BM_MPSH301", "EventProcessor.createInstance()", new Object[]{MPUtil.getEventCtx(event)});
        }
        piAttrs = WFProcessInstance.self().validateAttributesForCreateInstance(ptName, piAttrs);
        WFProcessContext pCtx = WFProcessContext.createProcessInstance(BLControl.getServerSession(), piAttrs, dsValues, false);
        long startTime = event.getStartTime();
        if (ptObj.isMonitoringProcess()) {
            long createTime = event.getCreateTime();
            ProcessInstanceEBLocal piEB = pCtx.getProcessInstanceEB();
            if (startTime > 0L) {
                piEB.setTimeStarted(startTime);
            } else if (createTime > 0L) {
                piEB.setTimeStarted(createTime);
                EventUtil.logDebug("BM_MPSH018", "EventProcessor.createInstance()", createTime);
            }
        } else if (startTime > 0L && SMPConfig.self().logWarningMessage()) {
            EventUtil.getLogger().warnKey("BM_MPSH303", new Object[]{startTime, MPUtil.getEventCtx(event)});
        }
        pCtx.activateProcessInstance();
    }

    private void validateWSEvent(BLExternalEvent event, long wsid, WFProcessContext pCtx) {
        long piid = pCtx.getProcessInstanceID();
        long evtLoopCounter = this.updateLoopCounter(event);
        WorkStepInstanceEBLocal wsEBean = pCtx.getWorkstepInstanceEB(wsid, true);
        if (wsEBean == null) {
            throw EventUtil.createInvalidProcessStateEx("BM_MPSH306", "EventProcessor.validateWSEvent()", wsid, piid, MPUtil.getEventCtx(event));
        }
        if (event.getOperationType().isCompleteWorkstep() && !MPUtil.shouldProcessCompleteEvent(pCtx, wsid, wsEBean)) {
            throw EventUtil.createInvalidProcessStateEx("BM_MPSH304", "EventProcessor.validateWSEvent()", wsid, piid, MPUtil.getEventCtx(event));
        }
        if (evtLoopCounter > 0L) {
            long wsLoopCounter = wsEBean.getLoopCounter();
            if (evtLoopCounter > wsLoopCounter) {
                throw EventUtil.createInvalidProcessStateEx("BM_MPSH034", "EventProcessor.validateWSEvent()", wsLoopCounter, evtLoopCounter, MPUtil.getEventCtx(event));
            }
            if (evtLoopCounter < wsLoopCounter) {
                throw EventUtil.createInvalidEventDataEx("BM_MPSH031", "EventProcessor.validateWSEvent()", evtLoopCounter, MPUtil.getEventCtx(event));
            }
        }
        int n = wsEBean.getState();
        BLConstants.single();
        if (n == 16) {
            throw EventUtil.createInvalidProcessStateEx("BM_MPSH029", "EventProcessor.validateWSEvent()", BLConstants.single().wfStates[wsEBean.getState()], MPUtil.getEventCtx(event));
        }
        if (event.getOperationType().isActivateWorkstep()) {
            int n2 = wsEBean.getState();
            BLConstants.single();
            if (n2 != 91) {
                throw EventUtil.createInvalidEventDataEx("BM_MPSH029", "EventProcessor.validateWSEvent()", BLConstants.single().wfStates[wsEBean.getState()], MPUtil.getEventCtx(event));
            }
        }
    }

    private long updateLoopCounter(BLExternalEvent event) {
        long evtLoopCounter = event.getBLLoopCounter();
        if (evtLoopCounter <= 0L) {
            evtLoopCounter = event.getLoopCounter();
            event.setBLLoopCounter(evtLoopCounter);
        }
        return evtLoopCounter;
    }

    private long findWorkstepId(BLExternalEvent event, WFProcessContext pCtx) {
        WFWorkstep workstep;
        long wsid = event.getBLWorkStepId();
        if (wsid <= 0L && null != (workstep = pCtx.getProcess().getWorkstep(event.getWorkstepName(), true))) {
            wsid = workstep.getID();
            event.setBLWorkStepId(wsid);
        }
        if (wsid <= 0L) {
            throw EventUtil.createInvalidEventDataEx("BM_MPSH307", "EventProcessor.updateWorkstepID()", wsid, pCtx.getProcessInstanceID(), MPUtil.getEventCtx(event));
        }
        return wsid;
    }

    private WFProcessContext findProcessInstanceId(BLExternalEvent event, WFProcessContext paramPCtx) {
        String eiId = event.getExternalInstanceId();
        if (!MPUtil.isValidString(eiId)) {
            throw EventUtil.createInvalidEventDataEx("BM_MPSH005", "EventProcessor.updateProcessInstanceID()", eiId, MPUtil.getEventCtx(event));
        }
        long piid = event.getBLProcessInstanceId();
        if (piid <= 0L) {
            if (null != paramPCtx) {
                piid = paramPCtx.getProcessInstanceID();
            } else {
                WFProcess ptObj = ProcessControl.getProcessTemplate(event.getProcessName());
                if (ptObj.isMonitorDSMappedToPIID()) {
                    try {
                        piid = Long.parseLong(event.getExternalInstanceId());
                    }
                    catch (NumberFormatException nfe) {
                        throw EventUtil.createInvalidEventDataEx("BM_MPSH042", "EventProcessor.updateProcessInstanceID()", nfe, event.getExternalInstanceId(), MPUtil.getEventCtx(event));
                    }
                } else {
                    piid = WFDataSlotInstance.getProcessInstanceId(event.getProcessName(), event.getExternalInstanceId(), false);
                }
            }
            event.setBLProcessInstanceId(piid);
        }
        if (piid <= 0L) {
            if (MPUtil.isPIExistInBizStore(event.getProcessName(), event.getExternalInstanceId())) {
                throw EventUtil.createInvalidEventDataEx("BM_MPSH312", "EventProcessor.updateProcessInstanceID()", MPUtil.getEventCtx(event));
            }
            throw EventUtil.createInvalidProcessStateEx("BM_MPSH311", "EventProcessor.updateProcessInstanceID()", MPUtil.getEventCtx(event));
        }
        if (!WFProcessInstance.self().isExist(piid)) {
            throw EventUtil.createInvalidEventDataEx("BM_MPSH027", "EventProcessor.updateProcessInstanceID()", MPUtil.getEventCtx(event));
        }
        WFProcessContext pCtx = paramPCtx;
        if (null == pCtx) {
            pCtx = new WFProcessContext(BLControl.getServerSession(), piid);
        }
        if (WFProcessInstance.self().isSuspended(pCtx)) {
            throw EventUtil.createInvalidProcessStateEx("BM_MPSH024", "EventProcessor.updateProcessInstanceID()", "suspended", MPUtil.getEventCtx(event));
        }
        if (!WFProcessInstance.self().isActivated(pCtx)) {
            throw EventUtil.createInvalidProcessStateEx("BM_MPSH024", "EventProcessor.updateProcessInstanceID()", "not activated", MPUtil.getEventCtx(event));
        }
        return pCtx;
    }

    private void activateWorkStep(BLExternalEvent event, WFProcessContext pCtx) {
        String ctx = "EventProcessor.activateWorkStep()";
        event.getBLProcessInstanceId();
        long wsId = event.getBLWorkStepId();
        Map<String, Object> dsValues = this.getValidWorkStepDataSlots(event);
        if (dsValues != null && !dsValues.isEmpty()) {
            pCtx.updateSlotValue(dsValues);
        }
        WorkStepInstanceEBLocal wsEBean = pCtx.getWorkstepInstanceEB(wsId);
        if (SBMUtil.self().isValidPriority(event.getPriority())) {
            WFWorkstepInstance.single().setPriority(pCtx, wsId, event.getPriority());
        } else if (SMPConfig.self().logWarningMessage()) {
            EventUtil.getLogger().warnKey("BM_MPSH047", "EventProcessor.activateWorkStep()", new Object[]{event.getPriority(), event.getWorkstepName(), MPUtil.getEventCtx(event)});
        }
        if (MPUtil.isValidString(event.getPerformer())) {
            wsEBean.setPerformer(event.getPerformer());
            wsEBean.setActualPerformer(event.getPerformer());
        } else {
            this.setDefaultPerformer(event, pCtx);
        }
        long startTime = System.currentTimeMillis();
        if (event.getStartTime() > 0L) {
            startTime = event.getStartTime();
        } else if (event.getCreateTime() > 0L) {
            startTime = event.getCreateTime();
            EventUtil.logDebug("BM_MPSH033", ctx, event.getCreateTime());
        }
        wsEBean.setTimeStarted(startTime);
        if (event.getDuration() > 0L) {
            wsEBean.setDuration(event.getDuration());
            wsEBean.setDuedate(wsEBean.getTimeStarted() + event.getDuration() * 1000L);
        } else {
            long durationSecs = WFWorkstepInstance.single().getRealDuration(pCtx, pCtx.getWorkstep(wsId));
            wsEBean.setDuedate(wsEBean.getTimeStarted() + durationSecs * 1000L);
        }
        pCtx.activateMonitorWorkstep(wsId);
    }

    private void completeWorkStep(BLExternalEvent event, WFProcessContext pCtx) {
        event.getBLProcessInstanceId();
        long wsId = event.getBLWorkStepId();
        Map<String, Object> dsValues = this.getValidWorkStepDataSlots(event);
        if (dsValues != null && !dsValues.isEmpty()) {
            pCtx.updateSlotValue(dsValues);
        }
        WorkStepInstanceEBLocal workStepInstanceEBLocal = pCtx.getWorkstepInstanceEB(wsId);
        if (SBMUtil.self().isValidPriority(event.getPriority())) {
            WFWorkstepInstance.single().setPriority(pCtx, wsId, event.getPriority());
        } else if (SMPConfig.self().logWarningMessage()) {
            EventUtil.getLogger().warnKey(BM_MPSH048, EVENT_PROCESSOR_COMPLETE_WORK_STEP, new Object[]{event.getPriority(), event.getWorkstepName(), MPUtil.getEventCtx(event)});
        }
        if (MPUtil.isValidString(event.getPerformer())) {
            workStepInstanceEBLocal.setPerformer(event.getPerformer());
            workStepInstanceEBLocal.setActualPerformer(event.getPerformer());
        }
        int wsState = workStepInstanceEBLocal.getState();
        this.workstepEventActivation(event, pCtx, wsId, wsState);
        long duration = event.getDuration();
        long completionTime = event.getEndTime();
        BLConstants.single();
        if (wsState == 91) {
            this.updateWorkStepInstanceEBLocalWaitEventActivation(event, workStepInstanceEBLocal, duration, completionTime);
        } else {
            this.updateWorkStepInstanceEBLocalDefaultCase(event, workStepInstanceEBLocal, duration, completionTime);
        }
        pCtx.completeWorkstep(wsId);
    }

    private void workstepEventActivation(BLExternalEvent event, WFProcessContext pCtx, long wsId, int wsState) {
        BLConstants.single();
        if (wsState == 91) {
            if (!MPUtil.isValidString(event.getPerformer())) {
                this.setDefaultPerformer(event, pCtx);
            }
            if (SMPConfig.self().isFireActivationEvent()) {
                pCtx.activateMonitorWorkstep(wsId);
            }
        }
    }

    private void updateWorkStepInstanceEBLocalWaitEventActivation(BLExternalEvent event, WorkStepInstanceEBLocal workStepInstanceEBLocal, long durationParam, long completionTimeParam) {
        long duration = durationParam;
        long completionTime = completionTimeParam;
        long startTime = event.getStartTime();
        if (completionTime > 0L && startTime > 0L) {
            if (duration > 0L) {
                long calcDuration = (completionTime - startTime) / 1000L;
                if (calcDuration != duration && SMPConfig.self().logWarningMessage()) {
                    EventUtil.getLogger().warnKey(BM_MPSH035, EVENT_PROCESSOR_COMPLETE_WORK_STEP, new Object[]{calcDuration, duration, MPUtil.getEventCtx(event)});
                }
            } else {
                duration = (completionTime - startTime) / 1000L;
            }
        } else if (completionTime > 0L && duration > 0L) {
            startTime = completionTime - duration * 1000L;
        } else if (completionTime > 0L && duration <= 0L) {
            duration = workStepInstanceEBLocal.getDuration();
            startTime = completionTime - duration * 1000L;
        } else if (completionTime <= 0L && startTime > 0L) {
            if (duration <= 0L) {
                duration = workStepInstanceEBLocal.getDuration();
            }
            completionTime = startTime + duration * 1000L;
        } else if (completionTime <= 0L && startTime <= 0L) {
            completionTime = event.getCreateTime();
            if (duration <= 0L) {
                duration = workStepInstanceEBLocal.getDuration();
            }
            startTime = completionTime - duration * 1000L;
        }
        if (duration <= 0L) {
            if (SMPConfig.self().logWarningMessage()) {
                EventUtil.getLogger().warnKey(BM_MPSH046, EVENT_PROCESSOR_COMPLETE_WORK_STEP, new Object[]{duration, workStepInstanceEBLocal.getTimeStarted(), completionTime, MPUtil.getEventCtx(event)});
            }
            duration = 0L;
        }
        if (completionTime < workStepInstanceEBLocal.getTimeStarted()) {
            if (SMPConfig.self().logWarningMessage()) {
                EventUtil.getLogger().warnKey(BM_MPSH315, EVENT_PROCESSOR_COMPLETE_WORK_STEP, new Object[]{workStepInstanceEBLocal.getTimeStarted(), completionTime, duration, MPUtil.getEventCtx(event)});
            }
            completionTime = workStepInstanceEBLocal.getTimeStarted() + duration;
        }
        workStepInstanceEBLocal.setTimeCompleted(completionTime);
        workStepInstanceEBLocal.setTimeStarted(startTime);
        workStepInstanceEBLocal.setDuration(duration);
    }

    private void updateWorkStepInstanceEBLocalDefaultCase(BLExternalEvent event, WorkStepInstanceEBLocal workStepInstanceEBLocal, long durationParam, long completionTimeParam) {
        long duration = durationParam;
        long completionTime = completionTimeParam;
        if (completionTime > 0L && duration > 0L) {
            long calcDuration = (completionTime - workStepInstanceEBLocal.getTimeStarted()) / 1000L;
            if (calcDuration != duration && SMPConfig.self().logWarningMessage()) {
                EventUtil.getLogger().warnKey(BM_MPSH035, EVENT_PROCESSOR_COMPLETE_WORK_STEP, new Object[]{calcDuration, duration, MPUtil.getEventCtx(event)});
            }
        } else if (completionTime > 0L && duration <= 0L) {
            duration = (completionTime - workStepInstanceEBLocal.getTimeStarted()) / 1000L;
        } else if (completionTime <= 0L && duration > 0L) {
            completionTime = workStepInstanceEBLocal.getTimeStarted() + duration * 1000L;
        } else if (completionTime <= 0L && duration <= 0L) {
            completionTime = event.getCreateTime();
            duration = (completionTime - workStepInstanceEBLocal.getTimeStarted()) / 1000L;
        }
        if (duration <= 0L) {
            if (SMPConfig.self().logWarningMessage()) {
                EventUtil.getLogger().warnKey(BM_MPSH046, EVENT_PROCESSOR_COMPLETE_WORK_STEP, new Object[]{duration, workStepInstanceEBLocal.getTimeStarted(), completionTime, MPUtil.getEventCtx(event)});
            }
            duration = 0L;
        }
        if (completionTime < workStepInstanceEBLocal.getTimeStarted()) {
            if (SMPConfig.self().logWarningMessage()) {
                EventUtil.getLogger().warnKey(BM_MPSH315, EVENT_PROCESSOR_COMPLETE_WORK_STEP, new Object[]{workStepInstanceEBLocal.getTimeStarted(), completionTime, duration, MPUtil.getEventCtx(event)});
            }
            completionTime = workStepInstanceEBLocal.getTimeStarted() + duration;
        }
        workStepInstanceEBLocal.setTimeCompleted(completionTime);
        workStepInstanceEBLocal.setDuration(duration);
    }

    private void validateUpdateDSEvent(BLExternalEvent event, WFProcessContext pCtx) {
        Map<String, Object> invalidDS;
        WFProcess ptObj = pCtx.getProcess();
        if (!event.containsEventData()) {
            throw EventUtil.createInvalidEventDataEx("BM_MPSH025", "EventProcessor.validateUpdateDSEvent()", MPUtil.getEventCtx(event));
        }
        HashMap<String, Object> dsValues = new HashMap<String, Object>(event.getEventData());
        if (MPUtil.isDebug()) {
            EventUtil.getLogger().debugKey("BM_MPSH308", "EventProcessor.validateUpdateDSEvent()", new Object[]{dsValues, MPUtil.getEventCtx(event)});
        }
        if ((invalidDS = EventUtil.removeInvalidDataslots(ptObj, dsValues)) != null && !invalidDS.isEmpty()) {
            EventUtil.getLogger().infoKey("BM_MPSH011", "EventProcessor.validateUpdateDSEvent()", new Object[]{invalidDS, MPUtil.getEventCtx(event)});
        }
        EventUtil.removeMonitorDataslot(ptObj, dsValues);
        if (dsValues.isEmpty()) {
            throw EventUtil.createInvalidEventDataEx("BM_MPSH025", "EventProcessor.validateUpdateDSEvent()", MPUtil.getEventCtx(event));
        }
        if (MPUtil.isDebug()) {
            EventUtil.getLogger().debugKey("BM_MPSH309", "EventProcessor.validateUpdateDSEvent()", new Object[]{dsValues, MPUtil.getEventCtx(event)});
        }
    }

    private void updateDataSlot(BLExternalEvent event) {
        long piid;
        Object monitorDS;
        HashMap<String, Object> dsValues = new HashMap<String, Object>(event.getEventData());
        WFProcess ptObj = ProcessControl.getProcessTemplate(event.getProcessName());
        Map<String, Object> invalidDS = EventUtil.removeInvalidDataslots(ptObj, dsValues);
        if (invalidDS != null && !invalidDS.isEmpty()) {
            EventUtil.getLogger().infoKey("BM_MPSH011", "EventProcessor.updateDataSlot()", new Object[]{invalidDS, MPUtil.getEventCtx(event)});
        }
        if ((monitorDS = EventUtil.removeMonitorDataslot(ptObj, dsValues)) != null && SMPConfig.self().logWarningMessage()) {
            EventUtil.getLogger().warnKey("BM_MPSH026", "EventProcessor.updateDataSlot()", new Object[]{ptObj.getMonitorDSName(), MPUtil.getEventCtx(event)});
        }
        if ((piid = event.getBLProcessInstanceId()) == -1L || piid == 0L) {
            piid = WFDataSlotInstance.getProcessInstanceId(event.getProcessName(), event.getExternalInstanceId(), false);
        }
        WFDataSlotInstance.self().updateSlotValue(BLControl.getServerSession(), piid, dsValues);
    }

    private Map<String, Object> getValidWorkStepDataSlots(BLExternalEvent event) {
        Map<String, Object> nonOutoutDS;
        WFProcess ptObj;
        Map<String, Object> invalidDS;
        Map<String, Object> dsValues = null;
        if (!event.containsEventData()) {
            return null;
        }
        dsValues = event.getEventData();
        if (MPUtil.isDebug()) {
            EventUtil.getLogger().debugKey("BM_MPSH308", "EventProcessor.validateUpdateDSEvent()", new Object[]{dsValues, MPUtil.getEventCtx(event)});
        }
        if ((invalidDS = EventUtil.removeInvalidDataslots(ptObj = ProcessControl.getProcessTemplate(event.getProcessName()), dsValues)) != null && !invalidDS.isEmpty()) {
            EventUtil.getLogger().infoKey("BM_MPSH011", "EventProcessor.getValidWorkStepDataSlots()", new Object[]{invalidDS, MPUtil.getEventCtx(event)});
        }
        Object monitorDS = EventUtil.removeMonitorDataslot(ptObj, dsValues);
        if (MPUtil.isDebug()) {
            EventUtil.getLogger().debugKey("BM_MPSH309", "EventProcessor.validateUpdateDSEvent()", new Object[]{dsValues, MPUtil.getEventCtx(event)});
        }
        if (monitorDS != null && SMPConfig.self().logWarningMessage()) {
            EventUtil.getLogger().warnKey("BM_MPSH026", "EventProcessor.getValidWorkStepDataSlots()", new Object[]{ptObj.getMonitorDSName(), MPUtil.getEventCtx(event)});
        }
        if ((nonOutoutDS = EventUtil.removeNonOutputDataslots(ptObj, event.getBLWorkStepId(), dsValues)) != null && !nonOutoutDS.isEmpty()) {
            EventUtil.getLogger().infoKey("BM_MPSH032", "EventProcessor.getValidWorkStepDataSlots()", new Object[]{nonOutoutDS, event.getOperationType(), MPUtil.getEventCtx(event)});
        }
        return dsValues;
    }

    private void setDefaultPerformer(BLExternalEvent event, WFProcessContext pCtx) {
        long wsId = event.getBLWorkStepId();
        WorkStepInstanceEBLocal wsEBean = pCtx.getWorkstepInstanceEB(wsId);
        int n = wsEBean.getType();
        BLConstants.single();
        if (n == 102) {
            String defaultPerf = pCtx.getDefaultPerformer(wsId);
            if (defaultPerf == null || defaultPerf.trim().length() == 0) {
                defaultPerf = BMBootProps.self().getUser();
                if (SMPConfig.self().logWarningMessage()) {
                    EventUtil.getLogger().warnKey("BM_MPSH036", "EventProcessor.setDefaultPerformer()", new Object[]{defaultPerf, MPUtil.getEventCtx(event)});
                }
            }
            wsEBean.setPerformer(defaultPerf);
            wsEBean.setActualPerformer(defaultPerf);
            EventUtil.logDebug("BM_MPSH038", "EventProcessor.setDefaultPerformer()", defaultPerf, MPUtil.getEventCtx(event));
        } else {
            wsEBean.setPerformer(MONITOR_ADAPTER);
            wsEBean.setActualPerformer(MONITOR_ADAPTER);
            EventUtil.logDebug("BM_MPSH038", "EventProcessor.setDefaultPerformer()", MONITOR_ADAPTER, MPUtil.getEventCtx(event));
        }
    }
}

