/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.smp.core;

import com.savvion.sbm.bizlogic.smp.MPService;
import com.savvion.sbm.bizlogic.smp.core.EventProcessor;
import com.savvion.sbm.bizlogic.smp.core.EventUtil;
import com.savvion.sbm.bizlogic.smp.core.QuartzThreadHandler;
import com.savvion.sbm.bizlogic.smp.model.BLExternalEvent;
import com.savvion.sbm.bizlogic.smp.persistence.EventPersistenceService;
import com.savvion.sbm.bizlogic.smp.util.InvalidEventDataException;
import com.savvion.sbm.bizlogic.smp.util.InvalidProcessStateException;
import com.savvion.sbm.bizlogic.smp.util.MPUtil;
import com.savvion.sbm.bizlogic.smp.util.SMPConfig;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.util.SBMDatabase;
import com.savvion.sbm.util.ServiceLocator;
import com.savvion.sbm.util.TransactionService;
import com.savvion.sbm.util.logger.SBMLogger;
import java.util.HashMap;
import java.util.List;
import javax.transaction.UserTransaction;

public class ExtEventHandler
extends QuartzThreadHandler {
    private static ExtEventHandler self = null;
    private long eventJobCompletionTime = 0L;
    private long historyJobCompletionTime = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExtEventHandler self() {
        if (self != null) return self;
        Class<ExtEventHandler> clazz = ExtEventHandler.class;
        synchronized (ExtEventHandler.class) {
            if (self != null) return self;
            self = new ExtEventHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return self;
        }
    }

    public void execute() {
        if (MPUtil.isDebugScheduler() && this.eventJobCompletionTime > 0L) {
            MPService.self().getLogger().debugKey("BM_MPSH207", "ExtEventHandler.execute()", new Object[]{System.currentTimeMillis() - this.eventJobCompletionTime});
        }
        this.doExecute();
        this.eventJobCompletionTime = System.currentTimeMillis();
    }

    public void doExecute() {
        EventPersistenceService eps = MPService.self().getPersistenceService();
        List<BLExternalEvent> readyEvents = eps.getReadyToProcessEventList(SMPConfig.self().getEventJobBatch(), SMPConfig.self().isSortedEventSelection());
        long startTime = System.currentTimeMillis();
        if (readyEvents == null || readyEvents.isEmpty()) {
            EventUtil.logDebug("BM_MPSH003", "ExtEventHandler.doExecute()", new Object[0]);
            return;
        }
        boolean continueProcessing = true;
        for (BLExternalEvent event : readyEvents) {
            UserTransaction utx = null;
            try {
                utx = this.getUserTransaction();
                utx.begin();
                EventProcessor.self().processEvent(event, null);
                utx.commit();
            }
            catch (InvalidEventDataException e) {
                try {
                    continueProcessing = this.handleError(event, (Throwable)((Object)e));
                    if (continueProcessing) {
                        if (utx != null) {
                            utx.commit();
                        }
                    } else {
                        this.getLogger().errorKey("BM_MPSH045", "ExtEventHandler.doExecute()", (Throwable)((Object)e), new Object[]{MPUtil.getEventCtx(event)});
                        if (utx != null) {
                            TransactionService.rollback((UserTransaction)utx, (SBMLogger)this.getLogger());
                        }
                    }
                }
                catch (Throwable th1) {
                    continueProcessing = false;
                    TransactionService.rollback((UserTransaction)utx, (SBMLogger)this.getLogger());
                    this.getLogger().errorKey("BM_MPSH020", "ExtEventHandler.doExecute()", th1, new Object[]{MPUtil.getEventCtx(event)});
                }
            }
            catch (Throwable th) {
                TransactionService.rollback((UserTransaction)utx, (SBMLogger)this.getLogger());
                UserTransaction transaction = null;
                try {
                    transaction = this.getUserTransaction();
                    transaction.begin();
                    continueProcessing = this.handleError(event, th);
                    if (continueProcessing) {
                        transaction.commit();
                    } else {
                        this.getLogger().errorKey("BM_MPSH045", "ExtEventHandler.doExecute()", th, new Object[]{MPUtil.getEventCtx(event)});
                        TransactionService.rollback((UserTransaction)transaction, (SBMLogger)this.getLogger());
                    }
                }
                catch (Throwable th1) {
                    continueProcessing = false;
                    TransactionService.rollback((UserTransaction)transaction, (SBMLogger)this.getLogger());
                    this.getLogger().errorKey("BM_MPSH020", "ExtEventHandler.doExecute()", th1, new Object[]{MPUtil.getEventCtx(event)});
                }
            }
            if (continueProcessing) continue;
            break;
        }
        long endTime = System.currentTimeMillis();
        this.getLogger().infoKey("BM_MPSH039", "ExtEventHandler.doExecute()", new Object[]{readyEvents.size(), endTime - startTime});
    }

    private boolean handleError(BLExternalEvent event, Throwable th) {
        if (!MPUtil.isDBAvailable()) {
            return false;
        }
        EventPersistenceService eps = MPService.self().getPersistenceService();
        eps.markEventAsNotProcessed(event.getEventId());
        if (th instanceof InvalidEventDataException) {
            MPUtil.handleInvalidEvent(event, th.getMessage());
        } else if (th instanceof InvalidProcessStateException) {
            if (SMPConfig.self().checkMaxInvalidStateEventRetryCount() && event.getRetryCounter() + 1L >= SMPConfig.self().getMaxInvalidStateEventRetryCount()) {
                String errMsg = MPUtil.lookupMessage("BM_MPSH021", SMPConfig.self().getMaxInvalidStateEventRetryCount(), MPUtil.getEventCtx(event));
                MPUtil.handleInvalidEvent(event, errMsg);
                return true;
            }
            this.updateBizlogicData(event);
            eps.incrementEventRetryCount(event.getEventId(), SMPConfig.self().getInvalidStateEventRetryInterval());
            if (SMPConfig.self().logWarningMessage()) {
                this.getLogger().warnKey("BM_MPSH008", "ExtEventHandler.handleError()", null, new Object[]{th.getMessage(), MPUtil.getEventCtx(event), event.getRetryCounter() + 1L});
            }
        } else {
            if (SMPConfig.self().checkMaxEventRetryCount() && event.getRetryCounter() + 1L >= SMPConfig.self().getMaxEventRetryCount()) {
                String errMsg = MPUtil.lookupMessage("BM_MPSH021", SMPConfig.self().getMaxEventRetryCount(), MPUtil.getEventCtx(event));
                MPUtil.handleInvalidEvent(event, errMsg);
                return true;
            }
            eps.incrementEventRetryCount(event.getEventId(), SMPConfig.self().getEventRetryInterval());
            this.getLogger().errorKey("BM_MPSH023", "ExtEventHandler.handleError()", th, new Object[]{event.getOperationType(), MPUtil.getEventCtx(event), event.getRetryCounter() + 1L});
        }
        return true;
    }

    private void updateBizlogicData(BLExternalEvent event) {
        if (event.getOperationType().isUpdateDataslot() && event.getBLProcessInstanceId() > 0L && event.getRetryCounter() == 0L) {
            HashMap<String, Object> modifiedAttrs = new HashMap<String, Object>();
            modifiedAttrs.put("BL_PROCESS_INSTANCE_ID", event.getBLProcessInstanceId());
            MPService.self().getPersistenceService().updateEventById(event.getEventId(), modifiedAttrs);
        }
    }

    public void moveToHistory() {
        if (!SMPConfig.self().isExtEventHistoryEnabled()) {
            return;
        }
        if (MPUtil.isDebugScheduler() && this.historyJobCompletionTime > 0L) {
            MPService.self().getLogger().debugKey("BM_MPSH208", "ExtEventHandler.moveToHistory()", new Object[]{System.currentTimeMillis() - this.historyJobCompletionTime});
        }
        if (ServiceLocator.self().isWebsphere()) {
            try {
                BLUtil.getServiceLocal().moveToHistory();
            }
            catch (Throwable th) {
                this.getLogger().errorKey("BM_MPSH041", "ExtEventHandler.moveToHistory()", th, new Object[]{"ExtEventHandler.doMoveToHistory()"});
            }
        } else {
            this.doMoveToHistory();
        }
        this.historyJobCompletionTime = System.currentTimeMillis();
    }

    public void doMoveToHistory() {
        EventPersistenceService eps = MPService.self().getPersistenceService();
        if (SBMDatabase.self().isOpenEdge()) {
            List<BLExternalEvent> processedEvt = eps.getProcessedEvents(SMPConfig.self().getHistoryJobBatch());
            if (processedEvt.isEmpty()) {
                EventUtil.logDebug("BM_MPSH001", "ExtEventHandler.doMoveToHistory()", new Object[0]);
                return;
            }
            UserTransaction utx = null;
            try {
                utx = this.getUserTransaction();
                utx.begin();
                eps.insertEventsInHistory(processedEvt);
                eps.deleteExternalEvents(processedEvt);
                utx.commit();
                EventUtil.logDebug("BM_MPSH002", "ExtEventHandler.doMoveToHistory()", processedEvt.size(), processedEvt);
            }
            catch (Throwable th) {
                TransactionService.rollback((UserTransaction)utx, (SBMLogger)this.getLogger());
                this.getLogger().errorKey("BM_MPSH022", "ExtEventHandler.doMoveToHistory()", th, new Object[]{processedEvt.size()});
            }
        } else {
            List<Long> processedEvt = eps.getProcessedEventIds(SMPConfig.self().getHistoryJobBatch());
            if (processedEvt.isEmpty()) {
                EventUtil.logDebug("BM_MPSH001", "ExtEventHandler.doMoveToHistory()", new Object[0]);
                return;
            }
            UserTransaction utx = null;
            try {
                utx = this.getUserTransaction();
                utx.begin();
                eps.insertEventsInHistoryByIds(processedEvt);
                eps.deleteExternalEventByIds(processedEvt);
                utx.commit();
                EventUtil.logDebug("BM_MPSH002", "ExtEventHandler.doMoveToHistory()", processedEvt.size(), processedEvt);
            }
            catch (Throwable th) {
                TransactionService.rollback((UserTransaction)utx, (SBMLogger)this.getLogger());
                this.getLogger().errorKey("BM_MPSH022", "ExtEventHandler.doMoveToHistory()", th, new Object[]{processedEvt.size()});
            }
        }
    }

    private SBMLogger getLogger() {
        return MPService.self().getLogger();
    }
}

