/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.storeevent;

import com.savvion.sbm.bizlogic.storeevent.BSControl;
import com.savvion.sbm.bizlogic.storeevent.BSProcess;
import com.savvion.sbm.bizlogic.storeevent.BizLogicEventMap;
import com.savvion.sbm.bizlogic.storeevent.be.BEEventHandler;
import com.savvion.sbm.eventreader.MissingEventDAO;
import com.savvion.sbm.eventreader.SenderX;
import com.savvion.sbm.util.CommonEvent;
import com.savvion.sbm.util.SBMDatabase;
import java.sql.Connection;
import java.util.List;
import java.util.Map;

public class BSEventHandler
implements SenderX {
    private static int missingEventCounter = 0;

    public long publish(long lastEventID, List eventList) throws Exception {
        CommonEvent eventObj;
        int esize = eventList.size();
        long eventID = lastEventID;
        for (int num = 0; !(num >= esize || BSControl.isServerShuttingDown() || (BizLogicEventMap.isPRemoved(eventObj = (CommonEvent)eventList.get(num)) || BizLogicEventMap.isPReplaced(eventObj) || SBMDatabase.self().isOpenEdge() && BizLogicEventMap.isPCreated(eventObj)) && num != 0); ++num) {
            eventID = eventObj.getEventID();
            if (this.isMissingEvents(lastEventID, eventObj)) {
                return lastEventID;
            }
            this.storeBLData(eventObj);
            lastEventID = eventID;
            missingEventCounter = 0;
        }
        return eventID;
    }

    private void storeBLData(CommonEvent eventObj) {
        String type = eventObj.getType();
        if (type.equalsIgnoreCase("BIZLOGIC")) {
            Map context = eventObj.getContext();
            if (context != null) {
                if (BizLogicEventMap.isPRemoved(eventObj)) {
                    BEEventHandler.processEvent(eventObj);
                }
                BSProcess.storeBizLogicData(eventObj);
            } else {
                BSControl.logger.errorKey("BizStore_MSG_1526", new Object[]{eventObj.toLogFormat() + "\n"});
            }
        } else {
            BSControl.logger.debugKey("BizStore_MSG_003", new Object[]{type, eventObj.toLogFormat() + "\n"});
        }
    }

    private boolean isMissingEvents(long lastEventID, CommonEvent eventObj) throws Exception {
        long eventID = eventObj.getEventID();
        if (eventObj.isMissingEvent(lastEventID, BSControl.getMissingEventDelayAllowed())) {
            if (missingEventCounter < BSControl.getMissingEvtRetryMaxCount()) {
                BSControl.logger.warnKey("BizStore_MSG_1004", new Object[]{lastEventID + 1L, eventID - 1L, ++missingEventCounter});
                BSControl.sleep();
                return true;
            }
            BSControl.logger.warnKey("BizStore_MSG_1005", new Object[]{missingEventCounter, lastEventID + 1L, eventID - 1L});
            if (BSControl.isMissingEventInsertEnabled()) {
                this.insertMissingEvents(lastEventID + 1L, eventID - 1L);
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertMissingEvents(long firstInvalidID, long lastInvalidID) throws Exception {
        Connection conn = null;
        try {
            conn = BSControl.util.getBSConnection();
            MissingEventDAO.insert((long)firstInvalidID, (long)lastInvalidID, (String)"BIZSTORE", (Connection)conn);
        }
        finally {
            BSControl.util.closeBSConnection(conn);
        }
    }
}

