/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.storeevent;

import com.savvion.sbm.bizlogic.enums.SystemDataSlot;
import com.savvion.sbm.bizlogic.util.DBConstants;
import com.savvion.sbm.util.DBService;
import com.savvion.sbm.util.SBMDatabase;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BizStoreSchemaViewService {
    private static String createPIViewSqlTemplate;
    private static String createWSViewSqlTemplate;
    private static String dropViewSqlTemplate;
    private static String CreateViewPart1SqlTemplate;
    static final String PATTERN_VIEW_NAME = "<VIEW_NAME>";
    static final String PATTERN_PT_NAME = "<PT_NAME>";
    static final String PATTERN_INSTANCE_DS = "<INSTANCE_DS>";
    static final String PATTERN_DS_TABLE_NAME = "<DS_TABLE_NAME>";
    static final String PATTERN_COLUMN_NAME = "<COLUMN_NAME>";
    static final String PATTERN_COLUMN_ALIAS = "<COLUMN_ALIAS>";
    public static final String PT_NAME = "PT_NAME";
    public static final String PT_ID = "PT_ID";
    public static final String INSTANCE_DS = "INSTANCE_DS";
    public static final String MONITOR_DS = "MONITOR_DS";
    public static final String COLUMN_NAME = "COLUMN_NAME";
    public static final String COLUMN_ALIAS = "COLUMN_ALIAS";
    public static final String PI_VIEW_SUFFIX = "_VIEW";
    public static final String WS_VIEW_SUFFIX = "_WSV";
    static final String ATOMIC = "ATOMIC";
    static final String EXTERNAL = "EXTERNAL";
    static final String NESTED = "NESTED";
    static final String WEBSERVICE = "WEBSERVICE";
    static final String SUBSCRIBER = "SUBSCRIBER";
    static final String PUBLISHER = "PUBLISHER";
    static final String WS_VIEW_COLUMN_PREFIX = "WS_";
    static final String PROCESS = "process";
    static final String WORKSTEP = "workstep";
    public static final String MSSQL_LH_READPAST = "WITH (READPAST)";

    public static void addReadpastHint(StringBuilder sb, String tableAlias, String keyword) {
        DBConstants dbConsts = DBConstants.single();
        DBConstants.KeywordConstants kwd = dbConsts.kwd;
        try {
            if (sb != null) {
                if (SBMDatabase.self().isSQLServer()) {
                    sb.append(tableAlias).append(" ").append(MSSQL_LH_READPAST);
                } else {
                    sb.append(tableAlias);
                }
                if (keyword != null) {
                    sb.append(keyword);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final boolean isSystemDataSlot(String dsName) {
        return SystemDataSlot.isSystemDataSlot((String)dsName);
    }

    public static String getProcessViewName(String templateName) {
        return BizStoreSchemaViewService.getViewName(templateName, PI_VIEW_SUFFIX);
    }

    public static String getWSViewName(String templateName) {
        return BizStoreSchemaViewService.getViewName(templateName, WS_VIEW_SUFFIX);
    }

    private static String getViewName(String templateName, String viewSuffix) {
        if (templateName == null || templateName.trim().length() == 0) {
            throw new RuntimeException("Specified template name is null or empty");
        }
        StringBuilder sb = new StringBuilder(templateName);
        sb.append(viewSuffix);
        return DBService.getCorrectCaseByDb((String)sb.toString());
    }

    public static Map<String, String> prepareProcessViewColumnAliasNames(Map<String, Object> viewInfo) {
        DBConstants dbConsts = DBConstants.single();
        DBConstants.KeywordConstants kwd = dbConsts.kwd;
        DBConstants.ColConstants col = dbConsts.col;
        DBConstants.TableAliasConstants tabalias = dbConsts.tabalias;
        DBConstants.ViewAliasConstants viewAlias = dbConsts.viewAlias;
        StringBuilder columnName = new StringBuilder();
        StringBuilder aliasName = new StringBuilder();
        columnName.append("BSPI" + "." + "PROCESS_INSTANCE_ID").append(", ");
        aliasName.append("PROCESS_INSTANCE_ID").append(", ");
        columnName.append("'").append(PATTERN_PT_NAME).append("'").append(", ");
        aliasName.append(" ").append("PROCESS_NAME").append(", ");
        columnName.append("BSPI" + "." + "STATUS").append(", ");
        aliasName.append(" ").append("PROCESS_STATUS").append(", ");
        columnName.append("BSPI" + "." + "PRIORITY").append(", ");
        aliasName.append(" ").append("PROCESS_PRIORITY").append(", ");
        columnName.append("BSPI" + "." + "START_TIME").append(", ");
        aliasName.append(" ").append("START_TIME").append(", ");
        columnName.append("BSPI" + "." + "END_TIME").append(", ");
        aliasName.append(" ").append("END_TIME").append(", ");
        columnName.append("BSPI" + "." + "DURATION").append(", ");
        aliasName.append(" ").append("DURATION").append(", ");
        columnName.append("BSPI" + "." + "CREATOR").append(", ");
        aliasName.append(" ").append("CREATOR").append(", ");
        columnName.append("BSPI" + "." + "PROCESS_INSTANCE_NAME").append(", ");
        aliasName.append(" ").append("PROCESS_INSTANCE_NAME").append(", ");
        columnName.append("BSPI" + "." + "ESTIMATED_DURATION");
        aliasName.append(" ").append("ESTIMATED_DURATION");
        BizStoreSchemaViewService.prepareDSColumnAlias(columnName, aliasName, viewInfo, PROCESS);
        HashMap<String, String> columnAliasNames = new HashMap<String, String>();
        String colName = columnName.toString().replace(PATTERN_PT_NAME, (String)viewInfo.get(PT_NAME));
        columnAliasNames.put(COLUMN_NAME, colName);
        columnAliasNames.put(COLUMN_ALIAS, aliasName.toString());
        return columnAliasNames;
    }

    public static Map<String, String> prepareWSViewColumnAliasNames(Map<String, Object> viewInfo) {
        DBConstants dbConsts = DBConstants.single();
        DBConstants.KeywordConstants kwd = dbConsts.kwd;
        DBConstants.ColConstants col = dbConsts.col;
        DBConstants.TableAliasConstants tabalias = dbConsts.tabalias;
        DBConstants.ViewAliasConstants viewAlias = dbConsts.viewAlias;
        StringBuilder columnName = new StringBuilder();
        StringBuilder aliasName = new StringBuilder();
        columnName.append("BSPI").append(".").append("PROCESS_TEMPLATE_ID").append(", ");
        aliasName.append("PROCESS_TEMPLATE_ID").append(", ");
        columnName.append("'").append(PATTERN_PT_NAME).append("'").append(", ");
        aliasName.append("PROCESS_NAME").append(", ");
        columnName.append("BSPI").append(".").append("PROCESS_INSTANCE_ID").append(", ");
        aliasName.append("PROCESS_INSTANCE_ID").append(", ");
        columnName.append("BSPI").append(".").append("PROCESS_INSTANCE_NAME").append(", ");
        aliasName.append("PROCESS_INSTANCE_NAME").append(", ");
        columnName.append("BSPI").append(".").append("CREATOR").append(", ");
        aliasName.append("CREATOR").append(", ");
        columnName.append("BSPI").append(".").append("STATUS").append(", ");
        aliasName.append("STATUS").append(", ");
        columnName.append("BSPI").append(".").append("PRIORITY").append(", ");
        aliasName.append("PRIORITY").append(", ");
        columnName.append("BSPI").append(".").append("START_TIME").append(", ");
        aliasName.append("START_TIME").append(", ");
        columnName.append("BSPI").append(".").append("END_TIME").append(", ");
        aliasName.append("END_TIME").append(", ");
        columnName.append("BSPI").append(".").append("DUE_DATE").append(", ");
        aliasName.append("DUE_DATE").append(", ");
        columnName.append("BSPI").append(".").append("DURATION").append(", ");
        aliasName.append("DURATION").append(", ");
        columnName.append("BSPI").append(".").append("ESTIMATED_DURATION").append(", ");
        aliasName.append("ESTIMATED_DURATION").append(", ");
        columnName.append("BSWSI").append(".").append("WORKSTEP_NAME").append(", ");
        aliasName.append("WORKSTEP_NAME").append(", ");
        columnName.append("BSWSI").append(".").append("TYPE").append(", ");
        aliasName.append(WS_VIEW_COLUMN_PREFIX).append("TYPE").append(", ");
        columnName.append("BSWSI").append(".").append("PERFORMER").append(", ");
        aliasName.append(WS_VIEW_COLUMN_PREFIX).append("PERFORMER").append(", ");
        columnName.append("BSWSI").append(".").append("GROUP_TYPE").append(", ");
        aliasName.append(WS_VIEW_COLUMN_PREFIX).append("GROUP_TYPE").append(", ");
        columnName.append("BSWSI").append(".").append("LOOPCOUNTER").append(", ");
        aliasName.append(WS_VIEW_COLUMN_PREFIX).append("LOOPCOUNTER").append(", ");
        columnName.append("BSWSI").append(".").append("STATUS").append(", ");
        aliasName.append(WS_VIEW_COLUMN_PREFIX).append("STATUS").append(", ");
        columnName.append("BSWSI").append(".").append("PRIORITY").append(", ");
        aliasName.append(WS_VIEW_COLUMN_PREFIX).append("PRIORITY").append(", ");
        columnName.append("BSWSI").append(".").append("START_TIME").append(", ");
        aliasName.append(WS_VIEW_COLUMN_PREFIX).append("START_TIME").append(", ");
        columnName.append("BSWSI").append(".").append("END_TIME").append(", ");
        aliasName.append(WS_VIEW_COLUMN_PREFIX).append("END_TIME").append(", ");
        columnName.append("BSWSI").append(".").append("DUE_DATE").append(", ");
        aliasName.append(WS_VIEW_COLUMN_PREFIX).append("DUE_DATE").append(", ");
        columnName.append("BSWSI").append(".").append("DURATION").append(", ");
        aliasName.append(WS_VIEW_COLUMN_PREFIX).append("DURATION").append(", ");
        columnName.append("BSWSI").append(".").append("ESTIMATED_DURATION").append(", ");
        aliasName.append(WS_VIEW_COLUMN_PREFIX).append("ESTIMATED_DURATION").append(", ");
        columnName.append("BSWSI").append(".").append("MONITOR_STEP");
        aliasName.append(" ").append(WS_VIEW_COLUMN_PREFIX).append("MONITOR_STEP");
        BizStoreSchemaViewService.prepareDSColumnAlias(columnName, aliasName, viewInfo, WORKSTEP);
        HashMap<String, String> columnAliasNames = new HashMap<String, String>();
        String colName = columnName.toString().replace(PATTERN_PT_NAME, (String)viewInfo.get(PT_NAME));
        columnAliasNames.put(COLUMN_NAME, colName);
        columnAliasNames.put(COLUMN_ALIAS, aliasName.toString());
        return columnAliasNames;
    }

    public static void prepareDSColumnAlias(StringBuilder columnName, StringBuilder aliasName, Map<String, Object> viewInfo, String viewType) {
        DBConstants dbConsts = DBConstants.single();
        DBConstants.KeywordConstants kwd = dbConsts.kwd;
        DBConstants.TableAliasConstants tabalias = dbConsts.tabalias;
        List instanceDSLst = (List)viewInfo.get(INSTANCE_DS);
        new StringBuilder();
        String monitorDS = null;
        if (viewInfo.containsKey(MONITOR_DS) && (monitorDS = (String)viewInfo.get(MONITOR_DS)) != null) {
            if (monitorDS.equalsIgnoreCase("@PROCESS_INSTANCE_ID")) {
                columnName.append(", ");
                columnName.append("BSPI" + ".");
                DBConstants.ColConstants cfr_ignored_0 = dbConsts.col;
                columnName.append("PROCESS_INSTANCE_ID");
            } else if (instanceDSLst != null && !instanceDSLst.isEmpty()) {
                for (String instDSName : instanceDSLst) {
                    if (instDSName == null || !instDSName.equalsIgnoreCase(monitorDS)) continue;
                    instDSName = instDSName.trim().toUpperCase();
                    columnName.append(", ");
                    columnName.append("BSIDS" + ".");
                    columnName.append(DBService.polish((String)instDSName));
                }
            }
            aliasName.append(", ");
            DBConstants.ViewAliasConstants cfr_ignored_1 = dbConsts.viewAlias;
            aliasName.append(DBService.polish((String)"EIID"));
        }
        if (instanceDSLst != null && !instanceDSLst.isEmpty() && columnName.length() > 0) {
            Collections.sort(instanceDSLst);
            columnName.append(", ");
            aliasName.append(", ");
            HashMap<String, String> dsNameAliasMap = new HashMap<String, String>();
            for (int index = 0; index < instanceDSLst.size(); ++index) {
                String instDSName = (String)instanceDSLst.get(index);
                if (instDSName == null || instDSName.trim().length() <= 0) continue;
                String columnAlias = instDSName = instDSName.trim().toUpperCase();
                columnAlias = DBService.polish((String)BizStoreSchemaViewService.getColumnAlias(columnAlias, instDSName, dsNameAliasMap, 1, (String)viewInfo.get(PT_NAME), viewType));
                columnName.append("BSIDS" + ".");
                columnName.append(DBService.polish((String)instDSName));
                aliasName.append(columnAlias);
                if (index < instanceDSLst.size() - 1) {
                    columnName.append(", ");
                    aliasName.append(", ");
                }
                dsNameAliasMap.put(instDSName, columnAlias);
            }
        }
    }

    public static String getColumnAlias(String columnAlias, String instDSName, Map<String, String> dsNameAliasMap, int iterator, String ptName, String viewType) {
        DBConstants dbConsts = DBConstants.single();
        DBConstants.ViewAliasConstants viewAlias = dbConsts.viewAlias;
        String DS_PREFIX = "D";
        String UNDERSCORE = "_";
        int MAX_ALIAS_LENGTH = 30;
        if (!(BizStoreSchemaViewService.isSystemDataSlot(columnAlias) || viewAlias.isReservedAlias(columnAlias) || dsNameAliasMap.containsValue(columnAlias))) {
            if (columnAlias.length() > 30) {
                StringBuilder ctx = new StringBuilder();
                ctx.append("For Process:[").append(ptName).append("] alias name:[");
                ctx.append(columnAlias).append("] length exceeds 30 chracters for instance dataslot:[").append(instDSName);
                ctx.append("] during dynamic ").append(viewType).append(" view creation");
                throw new RuntimeException(ctx.toString());
            }
            return columnAlias;
        }
        StringBuilder newColumnAlias = new StringBuilder();
        if (iterator != 1) {
            newColumnAlias.append("D").append(iterator).append("_").append(instDSName);
        } else {
            newColumnAlias.append("D").append("_").append(instDSName);
        }
        return BizStoreSchemaViewService.getColumnAlias(newColumnAlias.toString(), instDSName, dsNameAliasMap, iterator++, ptName, viewType);
    }

    public static String getSqlCreateProcessView(String ptViewName, Map<String, Object> viewInfo) {
        Map<String, String> columnAlias = BizStoreSchemaViewService.prepareProcessViewColumnAliasNames(viewInfo);
        return BizStoreSchemaViewService.getSqlCreateView(ptViewName, viewInfo, createPIViewSqlTemplate, columnAlias);
    }

    public static String getSqlCreateWSView(String wsViewName, Map<String, Object> viewInfo) {
        Map<String, String> columnAlias = BizStoreSchemaViewService.prepareWSViewColumnAliasNames(viewInfo);
        return BizStoreSchemaViewService.getSqlCreateView(wsViewName, viewInfo, createWSViewSqlTemplate, columnAlias);
    }

    private static String getSqlCreateView(String viewName, Map<String, Object> viewInfo, String viewSql, Map<String, String> columnAlias) {
        if (viewInfo == null) {
            throw new RuntimeException("Specified viewInfo parameter is null");
        }
        String templateName = (String)viewInfo.get(PT_NAME);
        if (templateName == null || templateName.trim().length() == 0) {
            throw new RuntimeException("Specified process template name is null or empty");
        }
        String createViewSql = viewSql;
        HashMap<String, String> replaceToken = new HashMap<String, String>();
        replaceToken.put(PATTERN_VIEW_NAME, viewName);
        replaceToken.put(PATTERN_DS_TABLE_NAME, DBService.polish((String)templateName));
        replaceToken.put(PATTERN_COLUMN_NAME, columnAlias.get(COLUMN_NAME));
        replaceToken.put(PATTERN_COLUMN_ALIAS, columnAlias.get(COLUMN_ALIAS));
        for (Map.Entry replaceEntry : replaceToken.entrySet()) {
            createViewSql = createViewSql.replaceAll((String)replaceEntry.getKey(), (String)replaceEntry.getValue());
        }
        return createViewSql;
    }

    public static String getSqlDropProcessView(String viewName) {
        return BizStoreSchemaViewService.getSqlDropView(viewName, dropViewSqlTemplate);
    }

    public static String getSqlDropWSView(String viewName) {
        return BizStoreSchemaViewService.getSqlDropView(viewName, dropViewSqlTemplate);
    }

    private static String getSqlDropView(String viewName, String dropSql) {
        return dropSql.replaceAll(PATTERN_VIEW_NAME, viewName);
    }

    static {
        DBConstants dbConsts = DBConstants.single();
        DBConstants.KeywordConstants kwd = dbConsts.kwd;
        DBConstants.ColConstants col = dbConsts.col;
        DBConstants.TableAliasConstants tabalias = dbConsts.tabalias;
        StringBuilder sb = new StringBuilder();
        sb.append(" CREATE VIEW ");
        sb.append(PATTERN_VIEW_NAME).append(" ");
        sb.append(" (").append(PATTERN_COLUMN_ALIAS).append(") ");
        sb.append(" AS ");
        sb.append(" SELECT ");
        sb.append(PATTERN_COLUMN_NAME);
        CreateViewPart1SqlTemplate = sb.toString();
        sb = new StringBuilder();
        sb.append(CreateViewPart1SqlTemplate);
        sb.append(" FROM ");
        DBConstants.TableConstants cfr_ignored_0 = dbConsts.tab;
        sb.append("PROCESSINSTANCE").append(" ");
        BizStoreSchemaViewService.addReadpastHint(sb, "BSPI", ", ");
        sb.append(PATTERN_DS_TABLE_NAME).append(" ");
        DBConstants.TableAliasConstants cfr_ignored_1 = dbConsts.tabalias;
        BizStoreSchemaViewService.addReadpastHint(sb, "BSIDS", null);
        sb.append(" WHERE ");
        sb.append("BSPI" + "." + "PROCESS_INSTANCE_ID");
        sb.append(" = ");
        sb.append("BSIDS" + "." + "PROCESS_INSTANCE_ID");
        createPIViewSqlTemplate = sb.toString();
        sb = new StringBuilder();
        sb.append(CreateViewPart1SqlTemplate);
        sb.append(" FROM ");
        DBConstants.TableConstants cfr_ignored_2 = dbConsts.tab;
        sb.append("PROCESSINSTANCE").append(" ");
        BizStoreSchemaViewService.addReadpastHint(sb, "BSPI", ", ");
        DBConstants.TableConstants cfr_ignored_3 = dbConsts.tab;
        sb.append("WORKSTEP").append(" ");
        BizStoreSchemaViewService.addReadpastHint(sb, "BSWSI", ", ");
        sb.append(PATTERN_DS_TABLE_NAME).append(" ");
        DBConstants.TableAliasConstants cfr_ignored_4 = dbConsts.tabalias;
        BizStoreSchemaViewService.addReadpastHint(sb, "BSIDS", null);
        sb.append(" WHERE ");
        sb.append("BSPI").append(".").append("PROCESS_INSTANCE_ID");
        sb.append(" = ");
        sb.append("BSWSI").append(".").append("PROCESS_INSTANCE_ID");
        sb.append(" AND ");
        sb.append("BSPI").append(".").append("PROCESS_INSTANCE_ID");
        sb.append(" = ");
        sb.append("BSIDS").append(".").append("PROCESS_INSTANCE_ID");
        sb.append(" AND ");
        sb.append("BSWSI").append(".").append("TYPE");
        sb.append(" IN ").append(" (");
        sb.append("'").append(ATOMIC).append("'").append(", ");
        sb.append("'").append(EXTERNAL).append("'").append(", ");
        sb.append("'").append(NESTED).append("'").append(", ");
        sb.append("'").append(WEBSERVICE).append("'").append(", ");
        sb.append("'").append(SUBSCRIBER).append("'").append(", ");
        sb.append("'").append(PUBLISHER).append("'");
        sb.append(") ");
        createWSViewSqlTemplate = sb.toString();
        sb = new StringBuilder();
        sb.append(" DROP VIEW ");
        sb.append(PATTERN_VIEW_NAME);
        dropViewSqlTemplate = sb.toString();
    }
}

