/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.client;

import com.savvion.common.distcache.core.AbstractCache;
import com.savvion.common.distcache.core.AbstractCacheListener;
import com.savvion.sbm.distcache.cacheconfig.ConfigGeneratorConstant;
import com.savvion.sbm.distcache.config.CacheConfigService;
import com.savvion.sbm.distcache.core.AppCacheService;
import com.savvion.sbm.distcache.listener.AdapterExecutorNodeKeyCacheListener;
import com.savvion.sbm.distcache.util.AppCacheConstant;
import com.savvion.sbm.distcache.util.AppCacheException;
import com.savvion.sbm.distcache.util.AppCacheUtil;
import com.savvion.sbm.util.ExceptionService;
import com.savvion.sbm.util.logger.SBMLogger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AdapterExecutorNodeCacheService {
    private static final String MESSAGE_KEY_DEST_CONFIG_NAME = "destConfigName";
    private static final String MESSAGE_KEY_NODE_ID = "NODE_ID";
    protected static final long INVALID_PTID = -1L;
    private static AdapterExecutorNodeCacheService self = null;
    private AppCacheService appCacheSvc;
    private SBMLogger logger;
    private final ExceptionService<AppCacheException> excpService;
    private boolean isAdapterExecutorNodeCacheEnabled = true;
    private boolean isDebugEnabled = false;
    private String adapterExecutorNodeCacheName = null;

    public static synchronized void createInstance(AppCacheService appCacheService, SBMLogger sbmLogger) {
        if (self == null) {
            self = new AdapterExecutorNodeCacheService(appCacheService, sbmLogger);
        }
    }

    public static synchronized void createInstance(SBMLogger sbmLogger) {
        if (self == null) {
            self = new AdapterExecutorNodeCacheService(sbmLogger);
        }
    }

    public static AdapterExecutorNodeCacheService self() {
        if (self != null) {
            return self;
        }
        boolean isAdapterExecutorNodeCacheEnabled = CacheConfigService.self().isCategoryEnabled(ConfigGeneratorConstant.CacheClusterType.EJBWEB, AppCacheConstant.CacheCategory.ADAPTER_EXECUTOR_NODE_CACHE.name());
        if (isAdapterExecutorNodeCacheEnabled) {
            throw (AppCacheException)AppCacheUtil.self().getExService().createException("BM_DCAC052", "AdapterExecutorNodeCacheService.self()", new Object[]{"AdapterExecutorNodeCacheService.createInstance(AppCacheService, SBMLogger)"});
        }
        throw (AppCacheException)AppCacheUtil.self().getExService().createException("BM_DCAC052", "AdapterExecutorNodeCacheService.self()", new Object[]{"AdapterExecutorNodeCacheService.createInstance(SBMLogger)"});
    }

    private AdapterExecutorNodeCacheService(AppCacheService appCacheService, SBMLogger sbmLogger) {
        this(sbmLogger);
        if (appCacheService == null) {
            throw (AppCacheException)this.getExcpService().createException("BM_DCAC006", "AdapterExecutorNodeCacheService(appCacheService, logger)");
        }
        this.appCacheSvc = appCacheService;
        this.adapterExecutorNodeCacheName = AppCacheUtil.self().getOrgCacheName("DEFAULT", AppCacheConstant.CacheName.ADAPTER_EXECUTOR_NODE_CACHE.name());
        this.addCacheListener();
    }

    private AdapterExecutorNodeCacheService(SBMLogger sbmLogger) {
        this.logger = sbmLogger != null ? sbmLogger.cloneInstance("sbmdistcachemessages", AdapterExecutorNodeCacheService.class.getClassLoader()) : AppCacheUtil.self().getDefaultLogger();
        this.excpService = new ExceptionService(AppCacheException.class, "sbmdistcachemessages", this.logger);
        this.isAdapterExecutorNodeCacheEnabled = CacheConfigService.self().isCategoryEnabled(ConfigGeneratorConstant.CacheClusterType.EJBWEB, AppCacheConstant.CacheCategory.ADAPTER_EXECUTOR_NODE_CACHE.name());
        this.isDebugEnabled = CacheConfigService.self().isCategoryDebugEnabled(ConfigGeneratorConstant.CacheClusterType.EJBWEB, AppCacheConstant.CacheCategory.ADAPTER_EXECUTOR_NODE_CACHE.name());
    }

    public void addAdapterExecutorNode(String adapterInstanceId, Map<String, Object> message, String nodeId, String destConfigName) {
        if (!this.isAdapterExecutorNodeCacheEnabled()) {
            return;
        }
        this.validateAdapterInstanceId(adapterInstanceId);
        adapterInstanceId = adapterInstanceId.trim();
        if (this.isDebugEnabled()) {
            this.getLogger().debugKey("BM_DCAC278", "AdapterExecutorNodeCacheService.addAdapterExecutorNode(String,String,String)", new Object[]{this.adapterExecutorNodeCacheName, adapterInstanceId, message, nodeId});
        }
        message.put(MESSAGE_KEY_DEST_CONFIG_NAME, destConfigName);
        message.put(MESSAGE_KEY_NODE_ID, nodeId);
        String key = adapterInstanceId + "_" + nodeId;
        this.getAdapterExecutorNodeCache().put((Object)key, message);
    }

    public void removeAdapterExecutorNode(String adapterInstanceId, String nodeIdentifier) {
        if (!this.isAdapterExecutorNodeCacheEnabled()) {
            return;
        }
        this.validateAdapterInstanceId(adapterInstanceId);
        adapterInstanceId = adapterInstanceId.trim();
        if (this.isDebugEnabled()) {
            this.getLogger().debugKey("BM_DCAC280", "AdapterExecutorNodeCacheService.removeAdapterExecutorNode(String)", new Object[]{this.adapterExecutorNodeCacheName, adapterInstanceId});
        }
        String key = adapterInstanceId + "_" + nodeIdentifier;
        this.getAdapterExecutorNodeCache().remove((Object)key);
    }

    public Collection<String> getAdaptersOnExecutorNode(String nodeId) {
        HashSet<String> adaptersOnExecutorNode = new HashSet<String>();
        AbstractCache<String, Map<String, Object>> adapterExecutorNodeCache = this.getAdapterExecutorNodeCache();
        Set adapterInstanceIds = adapterExecutorNodeCache.getKeys();
        for (String adapterInstanceId : adapterInstanceIds) {
            Map currentNodeId = (Map)adapterExecutorNodeCache.getValue((Object)adapterInstanceId);
            if (!nodeId.equals(currentNodeId.get(MESSAGE_KEY_NODE_ID))) continue;
            adaptersOnExecutorNode.add(adapterInstanceId);
        }
        return adaptersOnExecutorNode;
    }

    private AbstractCache<String, Map<String, Object>> getAdapterExecutorNodeCache() {
        if (this.isDebugEnabled()) {
            this.getLogger().debugKey("BM_DCAC284", "AdapterExecutorNodeCacheService.getAdapterExecutorNodeCache()", new Object[]{this.adapterExecutorNodeCacheName, ConfigGeneratorConstant.CacheClusterType.EJBWEB.name()});
        }
        return this.appCacheSvc.getCacheCluster(ConfigGeneratorConstant.CacheClusterType.EJBWEB).getCache(this.adapterExecutorNodeCacheName);
    }

    private final ExceptionService<AppCacheException> getExcpService() {
        return this.excpService;
    }

    private void addCacheListener() {
        if (this.isAdapterExecutorNodeCacheEnabled()) {
            this.getAdapterExecutorNodeCache().setLogger(this.getLogger());
            if (this.isDebugEnabled()) {
                AdapterExecutorNodeKeyCacheListener cacheLstnr = new AdapterExecutorNodeKeyCacheListener();
                cacheLstnr.setLogger(this.getLogger());
                this.getAdapterExecutorNodeCache().addListener((AbstractCacheListener)cacheLstnr);
            }
        }
    }

    private SBMLogger getLogger() {
        return this.logger;
    }

    private boolean isAdapterExecutorNodeCacheEnabled() {
        return this.isAdapterExecutorNodeCacheEnabled;
    }

    private boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    private void validateAdapterInstanceId(String adapterInstanceId) {
        if (!this.isValidStr(adapterInstanceId)) {
            throw (AppCacheException)this.getExcpService().createException("BM_DCAC034", "AdapterExecutorNodeCacheService.validateAdapterInstanceId(String)", new Object[]{"adapterInstanceId", adapterInstanceId});
        }
    }

    private boolean isValidStr(String str) {
        return str != null && !str.trim().isEmpty();
    }
}

