/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.email;

import com.savvion.sbm.bizlogic.email.EmailUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EmailData {
    private final long workItemId;
    private final Map emailContext;
    private Map documentDS;
    private Map nonDocumentDS;
    private List attachmentURLs;
    private String sender;
    private int emailType;
    private String performer;

    public EmailData(long workItemID, Map emailContextData, String senderAddress, int emailType, String performerId) {
        this(workItemID, emailContextData, null, null, null, senderAddress, emailType, performerId);
    }

    public EmailData(long workItemID, Map emailContextData, Map nonDocumentDS, Map documentDS, Collection attachmentURLs, String senderAddress, int emailType) {
        this(workItemID, emailContextData, nonDocumentDS, documentDS, attachmentURLs, senderAddress, emailType, null);
    }

    private EmailData(long workItemID, Map emailContextData, Map nonDocumentDS, Map documentDS, Collection attachmentURLs, String senderAddress, int emailType, String performerId) {
        if (workItemID < 0L) {
            throw new IllegalArgumentException(EmailUtil.self().getMessage("EMAIL_MSG_209", new Object[]{"WorkItem Id", String.valueOf(workItemID)}));
        }
        if (null == emailContextData || emailContextData.isEmpty()) {
            throw new IllegalArgumentException(" PKContext is empty. No Process Context information provided.");
        }
        this.workItemId = workItemID;
        this.emailContext = emailContextData;
        this.nonDocumentDS = nonDocumentDS;
        this.documentDS = documentDS;
        this.sender = senderAddress;
        this.performer = performerId;
        this.emailType = emailType;
        if (null != attachmentURLs) {
            this.attachmentURLs = new ArrayList(attachmentURLs);
        }
        if (this.nonDocumentDS == null) {
            this.nonDocumentDS = new HashMap();
        }
        if (this.documentDS == null) {
            this.documentDS = new HashMap();
        }
    }

    public long getWorkItemId() {
        return this.workItemId;
    }

    public Long getProcessInstanceId() {
        return (Long)this.emailContext.get("PCTX.INSTANCE_ID");
    }

    public Long getTemplateId() {
        return (Long)this.emailContext.get("PCTX.TEMPLATE_ID");
    }

    public Long getWorkStepId() {
        return (Long)this.emailContext.get("PCTX.WS_ID");
    }

    public String getWorkstepName() {
        return (String)this.emailContext.get("PCTX.WS_NAME");
    }

    public String getProcessTemplateName() {
        return (String)this.emailContext.get("PCTX.TEMPLATE_NAME");
    }

    public String getProcessInstanceName() {
        return (String)this.emailContext.get("PCTX.INSTANCE_NAME");
    }

    public String getSender() {
        return this.sender;
    }

    public Map getDocumentDataSlots() {
        return this.documentDS;
    }

    public Map getNonDocumentDataSlots() {
        return this.nonDocumentDS;
    }

    public List getAttachmentURLs() {
        return this.attachmentURLs;
    }

    public Object getNonDocumentDSValue(Object dataSlotName) {
        return this.nonDocumentDS.get(dataSlotName);
    }

    public Object getDocumentDSValue(Object dataSlotName) {
        return this.documentDS.get(dataSlotName);
    }

    void addNonDocumentDS(Object dataSlotName, Object value) {
        this.nonDocumentDS.put(dataSlotName, value);
    }

    void addDocumentDS(Object dataSlotName, Object value) {
        this.documentDS.put(dataSlotName, value);
    }

    void setSender(String sender) {
        this.sender = sender;
    }

    public int getEmailType() {
        return this.emailType;
    }

    void setEmailType(int emailType) {
        this.emailType = emailType;
    }

    public String getPerformer() {
        return this.performer;
    }

    void setPerformer(String performer) {
        this.performer = performer;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(512);
        builder.append(EmailData.class);
        builder.append("{ InstanceId=");
        builder.append(this.getProcessInstanceId());
        builder.append(" ; TemplateId=");
        builder.append(this.getTemplateId());
        builder.append(" ; WorkitemId=");
        builder.append(this.getWorkItemId());
        builder.append(" ; WorkStepId=");
        builder.append(this.getWorkStepId());
        builder.append(" ; WorkstepName=");
        builder.append(this.getWorkstepName());
        builder.append(" ; ProcessInstanceName=");
        builder.append(this.getProcessInstanceName());
        builder.append(" ; ProcessTemplateName=");
        builder.append(this.getProcessTemplateName());
        builder.append(" } ");
        return builder.toString();
    }
}

